/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2014 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=.5*3*Math.PI,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,a=e-Math.floor(e/r)*r;return a<-Math.PI?a+r:a>=Math.PI?a-r:a},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");for(var r=i.EPSILON10,a=i.PI,o=i.TWO_PI;-(a+r)>e;)e+=o;if(-a>e)return-a;for(;e>a+r;)e-=o;return e>a?a:e},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=e%i.TWO_PI;return 0>r?(r+i.TWO_PI)%i.TWO_PI:r},i.equalsEpsilon=function(e,i,a){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");return a=r(a,0),Math.abs(e-i)<=a};var a=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=a.length;if(e>=r)for(var t=a[r-1],i=r;e>=i;i++)a.push(t*i);return a[e]},i.incrementWrap=function(e,i,a){if(a=r(a,0),!t(e))throw new n("n is required.");if(a>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=a),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var o=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");o=new e(r)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){return Math.asin(i.clamp(e,-1,1))},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};a.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new a);var o=n.clock,s=n.cone,u=e(n.magnitude,1),h=u*Math.sin(s);return i.x=h*Math.cos(o),i.y=h*Math.sin(o),i.z=u*Math.cos(s),i},a.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new a(e,t,n)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a]=n.z},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i],o},a.fromArray=a.unpack,a.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},a.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},a.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},a.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var s=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,s),o=a.multiplyByScalar(e,1-i,o),a.add(s,o,o)};var u=new a,h=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");a.normalize(e,u),a.normalize(n,h);var i=a.dot(u,h),o=a.magnitude(a.cross(u,h,u));return Math.atan2(o,i)};var f=new a;a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,f);return a.abs(i,i),n=i.x<=i.y?i.x<=i.z?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Z,n):i.y<=i.z?a.clone(a.UNIT_Y,n):a.clone(a.UNIT_Z,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i},a.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var a=e.x,o=e.y,s=e.z,u=n.x,h=n.y,f=n.z,c=o*f-s*h,l=s*u-a*f,d=a*h-o*u;return i.x=c,i.y=l,i.z=d,i},a.fromDegrees=function(e,n,o,s,u){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var h=i.toRadians(e),f=i.toRadians(n);return a.fromRadians(h,f,o,s,u)};var c=new a,l=new a,d=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,i,o,s,u){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");o=e(o,0);var h=r(s)?s.radiiSquared:d,f=Math.cos(i);c.x=f*Math.cos(n),c.y=f*Math.sin(n),c.z=Math.sin(i),c=a.normalize(c,c),a.multiplyComponents(h,c,l);var w=Math.sqrt(a.dot(c,l));return l=a.divideByScalar(l,w,l),c=a.multiplyByScalar(c,o,c),r(u)||(u=new a),a.add(l,c,u)},a.fromDegreesArray=function(e,n,o){if(!r(e))throw new t("positions is required.");for(var s=new Array(e.length),u=0;u<e.length;u++)s[u]=i.toRadians(e[u]);return a.fromRadiansArray(s,n,o)},a.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(0!==e.length%2)throw new t("positions length must be a multiple of 2.");var o=e.length;r(i)?i.length=o/2:i=new Array(o/2);for(var s=0;o>s;s+=2){var u=e[s],h=e[s+1];i[s/2]=a.fromRadians(u,h,0,n,i[s/2])}return i},a.fromDegreesArrayHeights=function(e,n,o){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");for(var s=new Array(e.length),u=0;u<e.length;u+=3)s[u]=i.toRadians(e[u]),s[u+1]=i.toRadians(e[u+1]),s[u+2]=e[u+2];return a.fromRadiansArrayHeights(s,n,o)},a.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");var o=e.length;r(i)?i.length=o/3:i=new Array(o/3);for(var s=0;o>s;s+=3){var u=e[s],h=e[s+1],f=e[s+2];i[s/3]=a.fromRadians(u,h,f,n,i[s/3])}return i},a.ZERO=n(new a(0,0,0)),a.UNIT_X=n(new a(1,0,0)),a.UNIT_Y=n(new a(0,1,0)),a.UNIT_Z=n(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return a.fromRadians=function(n,i,o,s){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return o=e(o,0),r(s)?(s.longitude=n,s.latitude=i,s.height=o,s):new a(n,i,o)},a.fromDegrees=function(e,n,o,s){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),a.fromRadians(e,n,o,s)},a.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new a(e.longitude,e.latitude,e.height):void 0},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},a.toString=function(e){if(!r(e))throw new t("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},a.ZERO=n(new a(0,0,0)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return a.toString(this)},a}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a,o,s){"use strict";var u=function(r,n,i){if(r=t(r,0),n=t(n,0),i=t(i,0),0>r||0>n||0>i)throw new a("All radii components must be greater than or equal to zero.");this._radii=new e(r,n,i),this._radiiSquared=new e(r*r,n*n,i*i),this._radiiToTheFourth=new e(r*r*r*r,n*n*n*n,i*i*i*i),this._oneOverRadii=new e(0===r?0:1/r,0===n?0:1/n,0===i?0:1/i),this._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===n?0:1/(n*n),0===i?0:1/(i*i)),this._minimumRadius=Math.min(r,n,i),this._maximumRadius=Math.max(r,n,i),this._centerToleranceSquared=s.EPSILON1};i(u.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),u.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new u(i.x,i.y,i.z)},u.fromCartesian3=function(e){return n(e)?new u(e.x,e.y,e.z):new u},u.WGS84=o(new u(6378137,6378137,6356752.314245179)),u.UNIT_SPHERE=o(new u(1,1,1)),u.MOON=o(new u(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.geocentricSurfaceNormal=e.normalize,u.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new a("cartographic is required.");var i=r.longitude,o=r.latitude,s=Math.cos(o),u=s*Math.cos(i),h=s*Math.sin(i),f=Math.sin(o);return n(t)||(t=new e),t.x=u,t.y=h,t.z=f,e.normalize(t,t)},u.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var h=new e,f=new e;u.prototype.cartographicToCartesian=function(r,t){var i=h,a=f;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(a,i,t)},u.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new a("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var c=new e,l=new e,d=new e;u.prototype.cartesianToCartographic=function(t,i){var a=this.scaleToGeodeticSurface(t,l);if(!n(a))return void 0;var o=this.geodeticSurfaceNormal(a,c),u=e.subtract(t,a,d),h=Math.atan2(o.y,o.x),f=Math.asin(o.z),w=s.sign(e.dot(u,t))*e.magnitude(u);return n(i)?(i.longitude=h,i.latitude=f,i.height=w,i):new r(h,f,w)},u.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new a("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var w=new e,m=new e;return u.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");var i=r.x,o=r.y,u=r.z,h=this._oneOverRadii,f=h.x,c=h.y,l=h.z,d=i*i*f*f,p=o*o*c*c,y=u*u*l*l,g=d+p+y,v=Math.sqrt(1/g),q=e.multiplyByScalar(r,v,w);if(g<this._centerToleranceSquared)return isFinite(v)?e.clone(q,t):void 0;var x=this._oneOverRadiiSquared,E=x.x,b=x.y,S=x.z,M=m;M.x=2*q.x*E,M.y=2*q.y*b,M.z=2*q.z*S;var _,O,P,T,C,R,N,I,D,z,A,U=(1-v)*e.magnitude(r)/(.5*e.magnitude(M)),L=0;do{U-=L,P=1/(1+U*E),T=1/(1+U*b),C=1/(1+U*S),R=P*P,N=T*T,I=C*C,D=R*P,z=N*T,A=I*C,_=d*R+p*N+y*I-1,O=d*D*E+p*z*b+y*A*S;var W=-2*O;L=_/W}while(Math.abs(_)>s.EPSILON12);return n(t)?(t.x=i*P,t.y=o*T,t.z=u*C,t):new e(i*P,o*T,u*C)},u.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");n(t)||(t=new e);var i=r.x,o=r.y,s=r.z,u=this._oneOverRadiiSquared,h=1/Math.sqrt(i*i*u.x+o*o*u.y+s*s*u.z);return e.multiplyByScalar(r,h,t)},u.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},u.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},u.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},u.prototype.toString=function(){return this._radii.toString()},u}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,a,o){"use strict";var s=function(e){this._ellipsoid=t(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(r,t){var i=this._semimajorAxis,a=r.longitude*i,o=r.latitude*i,s=r.height;return n(t)?(t.x=a,t.y=o,t.z=s,t):new e(a,o,s)},s.prototype.unproject=function(e,t){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,s=e.y*i,u=e.z;return n(t)?(t.longitude=o,t.latitude=s,t.height=u,t):new r(o,s,u)},s}),define("Core/Intersect",[],function(){"use strict";var e={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};i.fromElements=function(e,t,n,a,o){return r(o)?(o.x=e,o.y=t,o.z=n,o.w=a,o):new i(e,t,n,a)},i.fromColor=function(e,n){if(!r(e))throw new t("color is required");return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a++]=n.z,i[a]=n.w},i.unpack=function(n,a,o){if(!r(n))throw new t("array is required");return a=e(a,0),r(o)||(o=new i),o.x=n[a++],o.y=n[a++],o.z=n[a++],o.w=n[a],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},i.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},i.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},i.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},i.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return i.subtract(e,n,a),i.magnitude(a)},i.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var a=i.magnitude(e);return n.x=e.x/a,n.y=e.y/a,n.z=e.z/a,n.w=e.w/a,n},i.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},i.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},i.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},i.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},i.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},i.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},i.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},i.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var o=new i;i.lerp=function(e,n,a,s){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof a)throw new t("t is required and must be a number.");if(!r(s))throw new t("result is required.");return i.multiplyByScalar(n,a,o),s=i.multiplyByScalar(e,1-a,s),i.add(o,s,s)};var s=new i;return i.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var a=i.normalize(e,s);return i.abs(a,a),n=a.x<=a.y?a.x<=a.z?a.x<=a.w?i.clone(i.UNIT_X,n):i.clone(i.UNIT_W,n):a.z<=a.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n):a.y<=a.z?a.y<=a.w?i.clone(i.UNIT_Y,n):i.clone(i.UNIT_W,n):a.z<=a.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},i.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i&&Math.abs(e.w-n.w)<=i},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,r){return i.equalsEpsilon(this,e,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a){"use strict";function o(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function s(e){for(var r=0,t=0;3>t;++t){var n=e[h.getElementIndex(d[t],l[t])];r+=2*n*n}return Math.sqrt(r)}function u(e,r){for(var t=a.EPSILON15,n=0,i=1,o=0;3>o;++o){var s=Math.abs(e[h.getElementIndex(d[o],l[o])]);s>n&&(i=o,n=s)}var u=1,f=0,c=l[i],w=d[i];if(Math.abs(e[h.getElementIndex(w,c)])>t){var m,p=e[h.getElementIndex(w,w)],y=e[h.getElementIndex(c,c)],g=e[h.getElementIndex(w,c)],v=(p-y)/2/g;m=0>v?-1/(-v+Math.sqrt(1+v*v)):1/(v+Math.sqrt(1+v*v)),u=1/Math.sqrt(1+m*m),f=m*u}return r=h.clone(h.IDENTITY,r),r[h.getElementIndex(c,c)]=r[h.getElementIndex(w,w)]=u,r[h.getElementIndex(w,c)]=f,r[h.getElementIndex(c,w)]=-f,r}var h=function(e,t,n,i,a,o,s,u,h){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(s,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(u,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(h,0)};h.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new h(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},h.fromArray=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new h),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a[9]=e[i+9],a},h.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return h.clone(e,r)},h.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new h(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},h.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,s=e.x*e.w,u=e.y*e.y,f=e.y*e.z,c=e.y*e.w,l=e.z*e.z,d=e.z*e.w,w=e.w*e.w,m=i-u-l+w,p=2*(a-d),y=2*(o+c),g=2*(a+d),v=-i+u-l+w,q=2*(f-s),x=2*(o-c),E=2*(f+s),b=-i-u+l+w;return t(r)?(r[0]=m,r[1]=g,r[2]=x,r[3]=p,r[4]=v,r[5]=E,r[6]=y,r[7]=q,r[8]=b,r):new h(m,p,y,g,v,q,x,E,b)},h.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new h(e.x,0,0,0,e.y,0,0,0,e.z)},h.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new h(e,0,0,0,e,0,0,0,e)},h.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=a,r[6]=0,r[7]=-a,r[8]=i,r):new h(1,0,0,0,i,-a,0,a,i)},h.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=i,r):new h(i,0,a,0,1,0,-a,0,i)},h.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=a,r[2]=0,r[3]=-a,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new h(i,-a,0,a,i,0,0,0,1)},h.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},h.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},h.getColumn=function(r,i,a){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var o=3*i,s=r[o],u=r[o+1],h=r[o+2];return t(a)?(a.x=s,a.y=u,a.z=h,a):new e(s,u,h)},h.setColumn=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");a=h.clone(e,a);var o=3*r;return a[o]=i.x,a[o+1]=i.y,a[o+2]=i.z,a},h.getRow=function(r,i,a){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var o=r[i],s=r[i+3],u=r[i+6];return t(a)?(a.x=o,a.y=s,a.z=u,a):new e(o,s,u)},h.setRow=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");return a=h.clone(e,a),a[r]=i.x,a[r+3]=i.y,a[r+6]=i.z,a};var f=new e;h.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");return t(i)||(i=new e),i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],f)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],f)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],f)),i};var c=new e;h.getMaximumScale=function(r){return h.getScale(r,c),e.getMaximumComponent(c)},h.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");var a=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],o=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],s=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],f=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],l=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],d=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],w=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return t(i)?(i[0]=a,i[1]=o,i[2]=s,i[3]=u,i[4]=f,i[5]=c,i[6]=l,i[7]=d,i[8]=w,i):new h(a,u,l,o,f,d,s,c,w)},h.multiplyByVector=function(r,i,a){if(!t(r))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");var o=i.x,s=i.y,u=i.z,h=r[0]*o+r[3]*s+r[6]*u,f=r[1]*o+r[4]*s+r[7]*u,c=r[2]*o+r[5]*s+r[8]*u;return t(a)?(a.x=h,a.y=f,a.z=c,a):new e(h,f,c)},h.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");return t(i)?(i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i):new h(e[0]*r,e[3]*r,e[6]*r,e[1]*r,e[4]*r,e[7]*r,e[2]*r,e[5]*r,e[8]*r)},h.negate=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r):new h(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},h.transpose=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],a=e[3],o=e[6],s=e[1],u=e[4],f=e[7],c=e[2],l=e[5],d=e[8];return t(r)?(r[0]=i,r[1]=a,r[2]=o,r[3]=s,r[4]=u,r[5]=f,r[6]=c,r[7]=l,r[8]=d,r):new h(i,s,c,a,u,l,o,f,d)};var l=[1,0,0],d=[2,2,1],w=new h,m=new h;return h.getEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=a.EPSILON20,f=10,c=0,l=0;
t(r)||(r={});for(var d=r.unitary=h.clone(h.IDENTITY,r.unitary),p=r.diagonal=h.clone(e,r.diagonal),y=i*o(p);f>l&&s(p)>y;)u(p,w),h.transpose(w,m),h.multiply(p,w,p),h.multiply(m,p,p),h.multiply(d,w,d),++c>2&&(++l,c=0);return r},h.abs=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r):new h(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},h.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],a=e[6],o=e[1],s=e[4],u=e[7],h=e[2],f=e[5],c=e[8];return r*(s*c-f*u)+o*(f*a-i*c)+h*(i*u-s*a)},h.inverse=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],o=e[1],s=e[2],u=e[3],f=e[4],c=e[5],l=e[6],d=e[7],w=e[8],m=h.determinant(e);if(Math.abs(m)<=a.EPSILON15)throw new n("matrix is not invertible");t(r)||(r=new h),r[0]=f*w-d*c,r[1]=d*s-o*w,r[2]=o*c-f*s,r[3]=l*c-u*w,r[4]=i*w-l*s,r[5]=u*s-i*c,r[6]=u*d-l*f,r[7]=l*o-i*d,r[8]=i*f-u*o;var p=1/m;return h.multiplyByScalar(r,p,r)},h.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},h.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},h.IDENTITY=i(new h(1,0,0,0,1,0,0,0,1)),h.COLUMN0ROW0=0,h.COLUMN0ROW1=1,h.COLUMN0ROW2=2,h.COLUMN1ROW0=3,h.COLUMN1ROW1=4,h.COLUMN1ROW2=5,h.COLUMN2ROW0=6,h.COLUMN2ROW1=7,h.COLUMN2ROW2=8,h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.equalsEpsilon=function(e,r){return h.equalsEpsilon(this,e,r)},h.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},h}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,a,o,s,u){"use strict";var h=function(e,r,n,i,a,o,s,u,h,f,c,l,d,w,m,p){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(h,0),this[3]=t(d,0),this[4]=t(r,0),this[5]=t(o,0),this[6]=t(f,0),this[7]=t(w,0),this[8]=t(n,0),this[9]=t(s,0),this[10]=t(c,0),this[11]=t(m,0),this[12]=t(i,0),this[13]=t(u,0),this[14]=t(l,0),this[15]=t(p,0)};h.packedLength=16,h.pack=function(e,r,a){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");a=t(a,0),r[a++]=e[0],r[a++]=e[1],r[a++]=e[2],r[a++]=e[3],r[a++]=e[4],r[a++]=e[5],r[a++]=e[6],r[a++]=e[7],r[a++]=e[8],r[a++]=e[9],r[a++]=e[10],r[a++]=e[11],r[a++]=e[12],r[a++]=e[13],r[a++]=e[14],r[a]=e[15]},h.unpack=function(e,r,a){if(!n(e))throw new i("array is required");return r=t(r,0),n(a)||(a=new h),a[0]=e[r++],a[1]=e[r++],a[2]=e[r++],a[3]=e[r++],a[4]=e[r++],a[5]=e[r++],a[6]=e[r++],a[7]=e[r++],a[8]=e[r++],a[9]=e[r++],a[10]=e[r++],a[11]=e[r++],a[12]=e[r++],a[13]=e[r++],a[14]=e[r++],a[15]=e[r],a},h.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new h(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},h.fromArray=h.unpack,h.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return h.clone(e,r)},h.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new h(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},h.fromRotationTranslation=function(e,r,t){if(!n(e))throw new i("rotation is required.");if(!n(r))throw new i("translation is required.");return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=0,t[4]=e[3],t[5]=e[4],t[6]=e[5],t[7]=0,t[8]=e[6],t[9]=e[7],t[10]=e[8],t[11]=0,t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=1,t):new h(e[0],e[3],e[6],r.x,e[1],e[4],e[7],r.y,e[2],e[5],e[8],r.z,0,0,0,1)},new s,h.fromTranslationQuaternionRotationScale=function(e,r,t,a){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(a)||(a=new h);var o=t.x,s=t.y,u=t.z,f=r.x*r.x,c=r.x*r.y,l=r.x*r.z,d=r.x*r.w,w=r.y*r.y,m=r.y*r.z,p=r.y*r.w,y=r.z*r.z,g=r.z*r.w,v=r.w*r.w,q=f-w-y+v,x=2*(c-g),E=2*(l+p),b=2*(c+g),S=-f+w-y+v,M=2*(m-d),_=2*(l-p),O=2*(m+d),P=-f-w+y+v;return a[0]=q*o,a[1]=b*o,a[2]=_*o,a[3]=0,a[4]=x*s,a[5]=S*s,a[6]=O*s,a[7]=0,a[8]=E*u,a[9]=M*u,a[10]=P*u,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},h.fromTranslation=function(e,r){return h.fromRotationTranslation(s.IDENTITY,e,r)},h.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new h(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},h.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new h(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var f=new e,c=new e,l=new e;h.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var a=r.eye,o=r.target,s=r.up;if(!n(a))throw new i("camera.eye is required.");if(!n(o))throw new i("camera.target is required.");if(!n(s))throw new i("camera.up is required.");e.normalize(e.subtract(o,a,f),f),e.normalize(e.cross(f,s,c),c),e.normalize(e.cross(c,f,l),l);var u=c.x,d=c.y,w=c.z,m=f.x,p=f.y,y=f.z,g=l.x,v=l.y,q=l.z,x=a.x,E=a.y,b=a.z,S=u*-x+d*-E+w*-b,M=g*-x+v*-E+q*-b,_=m*x+p*E+y*b;return n(t)?(t[0]=u,t[1]=g,t[2]=-m,t[3]=0,t[4]=d,t[5]=v,t[6]=-p,t[7]=0,t[8]=w,t[9]=q,t[10]=-y,t[11]=0,t[12]=S,t[13]=M,t[14]=_,t[15]=1,t):new h(u,d,w,S,g,v,q,M,-m,-p,-y,_,0,0,0,1)},h.computePerspectiveFieldOfView=function(e,r,t,a,o){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=a)throw new i("far must be greater than zero.");var s=Math.tan(.5*e),u=1/s,f=u/r,c=(a+t)/(t-a),l=2*a*t/(t-a);return n(o)?(o[0]=f,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=u,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=-1,o[12]=0,o[13]=0,o[14]=l,o[15]=0,o):new h(f,0,0,0,0,u,0,0,0,0,c,l,0,0,-1,0)},h.computeOrthographicOffCenter=function(e,r,t,a,o,s,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(s))throw new i("far is required.");var f=1/(r-e),c=1/(a-t),l=1/(s-o),d=-(r+e)*f,w=-(a+t)*c,m=-(s+o)*l;return f*=2,c*=2,l*=-2,n(u)?(u[0]=f,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=l,u[11]=0,u[12]=d,u[13]=w,u[14]=m,u[15]=1,u):new h(f,0,0,d,0,c,0,w,0,0,l,m,0,0,0,1)},h.computePerspectiveOffCenter=function(e,r,t,a,o,s,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(s))throw new i("far is required.");var f=2*o/(r-e),c=2*o/(a-t),l=(r+e)/(r-e),d=(a+t)/(a-t),w=-(s+o)/(s-o),m=-1,p=-2*s*o/(s-o);return n(u)?(u[0]=f,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=l,u[9]=d,u[10]=w,u[11]=m,u[12]=0,u[13]=0,u[14]=p,u[15]=0,u):new h(f,0,l,0,0,c,d,0,0,0,w,p,0,0,m,0)},h.computeInfinitePerspectiveOffCenter=function(e,r,t,a,o,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");var u=2*o/(r-e),f=2*o/(a-t),c=(r+e)/(r-e),l=(a+t)/(a-t),d=-1,w=-1,m=-2*o;return n(s)?(s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=f,s[6]=0,s[7]=0,s[8]=c,s[9]=l,s[10]=d,s[11]=w,s[12]=0,s[13]=0,s[14]=m,s[15]=0,s):new h(u,0,c,0,0,f,l,0,0,0,d,m,0,0,w,0)},h.computeViewportTransformation=function(e,r,i,a){e=t(e,t.EMPTY_OBJECT);var o=t(e.x,0),s=t(e.y,0),u=t(e.width,0),f=t(e.height,0);r=t(r,0),i=t(i,1);var c=.5*u,l=.5*f,d=.5*(i-r),w=c,m=l,p=d,y=o+c,g=s+l,v=r+d,q=1;return n(a)?(a[0]=w,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=m,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=p,a[11]=0,a[12]=y,a[13]=g,a[14]=v,a[15]=q,a):new h(w,0,0,y,0,m,0,g,0,0,p,v,0,0,0,q)},h.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},h.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},h.getColumn=function(e,t,a){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var o=4*t,s=e[o],u=e[o+1],h=e[o+2],f=e[o+3];return n(a)?(a.x=s,a.y=u,a.z=h,a.w=f,a):new r(s,u,h,f)},h.setColumn=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");a=h.clone(e,a);var o=4*r;return a[o]=t.x,a[o+1]=t.y,a[o+2]=t.z,a[o+3]=t.w,a},h.getRow=function(e,t,a){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var o=e[t],s=e[t+4],u=e[t+8],h=e[t+12];return n(a)?(a.x=o,a.y=s,a.z=u,a.w=h,a):new r(o,s,u,h)},h.setRow=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");return a=h.clone(e,a),a[r]=t.x,a[r+4]=t.y,a[r+8]=t.z,a[r+12]=t.w,a};var d=new e;h.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");return n(t)||(t=new e),t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],d)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],d)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],d)),t};var w=new e;h.getMaximumScale=function(r){return h.getScale(r,w),e.getMaximumComponent(w)},h.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var a=e[0],o=e[1],s=e[2],u=e[3],f=e[4],c=e[5],l=e[6],d=e[7],w=e[8],m=e[9],p=e[10],y=e[11],g=e[12],v=e[13],q=e[14],x=e[15],E=r[0],b=r[1],S=r[2],M=r[3],_=r[4],O=r[5],P=r[6],T=r[7],C=r[8],R=r[9],N=r[10],I=r[11],D=r[12],z=r[13],A=r[14],U=r[15],L=a*E+f*b+w*S+g*M,W=o*E+c*b+m*S+v*M,B=s*E+l*b+p*S+q*M,F=u*E+d*b+y*S+x*M,G=a*_+f*O+w*P+g*T,H=o*_+c*O+m*P+v*T,V=s*_+l*O+p*P+q*T,Y=u*_+d*O+y*P+x*T,j=a*C+f*R+w*N+g*I,k=o*C+c*R+m*N+v*I,X=s*C+l*R+p*N+q*I,Z=u*C+d*R+y*N+x*I,J=a*D+f*z+w*A+g*U,K=o*D+c*z+m*A+v*U,$=s*D+l*z+p*A+q*U,Q=u*D+d*z+y*A+x*U;return n(t)?(t[0]=L,t[1]=W,t[2]=B,t[3]=F,t[4]=G,t[5]=H,t[6]=V,t[7]=Y,t[8]=j,t[9]=k,t[10]=X,t[11]=Z,t[12]=J,t[13]=K,t[14]=$,t[15]=Q,t):new h(L,G,j,J,W,H,k,K,B,V,X,$,F,Y,Z,Q)},h.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var a=e[0],o=e[1],s=e[2],u=e[4],f=e[5],c=e[6],l=e[8],d=e[9],w=e[10],m=e[12],p=e[13],y=e[14],g=r[0],v=r[1],q=r[2],x=r[4],E=r[5],b=r[6],S=r[8],M=r[9],_=r[10],O=r[12],P=r[13],T=r[14],C=a*g+u*v+l*q,R=o*g+f*v+d*q,N=s*g+c*v+w*q,I=a*x+u*E+l*b,D=o*x+f*E+d*b,z=s*x+c*E+w*b,A=a*S+u*M+l*_,U=o*S+f*M+d*_,L=s*S+c*M+w*_,W=a*O+u*P+l*T+m,B=o*O+f*P+d*T+p,F=s*O+c*P+w*T+y;return n(t)?(t[0]=C,t[1]=R,t[2]=N,t[3]=0,t[4]=I,t[5]=D,t[6]=z,t[7]=0,t[8]=A,t[9]=U,t[10]=L,t[11]=0,t[12]=W,t[13]=B,t[14]=F,t[15]=1,t):new h(C,I,A,W,R,D,U,B,N,z,L,F,0,0,0,1)},h.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");var a=r.x,o=r.y,s=r.z,u=a*e[0]+o*e[4]+s*e[8]+e[12],f=a*e[1]+o*e[5]+s*e[9]+e[13],c=a*e[2]+o*e[6]+s*e[10]+e[14];return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=u,t[13]=f,t[14]=c,t[15]=e[15],t):new h(e[0],e[4],e[8],u,e[1],e[5],e[9],f,e[2],e[6],e[10],c,e[3],e[7],e[11],e[15])};var m=new e;return h.multiplyByUniformScale=function(e,r,t){if("number"!=typeof r)throw new i("scale is required");return m.x=r,m.y=r,m.z=r,h.multiplyByScale(e,m,t)},h.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");var a=r.x,o=r.y,s=r.z;return 1===a&&1===o&&1===s?h.clone(e,t):n(t)?(t[0]=a*e[0],t[1]=a*e[1],t[2]=a*e[2],t[3]=0,t[4]=o*e[4],t[5]=o*e[5],t[6]=o*e[6],t[7]=0,t[8]=s*e[8],t[9]=s*e[9],t[10]=s*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t):new h(a*e[0],o*e[4],s*e[8],e[12],a*e[1],o*e[5],s*e[9],e[13],a*e[2],o*e[6],s*e[10],e[14],0,0,0,1)},h.multiplyByVector=function(e,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,s=t.y,u=t.z,h=t.w,f=e[0]*o+e[4]*s+e[8]*u+e[12]*h,c=e[1]*o+e[5]*s+e[9]*u+e[13]*h,l=e[2]*o+e[6]*s+e[10]*u+e[14]*h,d=e[3]*o+e[7]*s+e[11]*u+e[15]*h;return n(a)?(a.x=f,a.y=c,a.z=l,a.w=d,a):new r(f,c,l,d)},h.multiplyByPointAsVector=function(r,t,a){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,s=t.y,u=t.z,h=r[0]*o+r[4]*s+r[8]*u,f=r[1]*o+r[5]*s+r[9]*u,c=r[2]*o+r[6]*s+r[10]*u;return n(a)?(a.x=h,a.y=f,a.z=c,a):new e(h,f,c)},h.multiplyByPoint=function(r,t,a){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,s=t.y,u=t.z,h=r[0]*o+r[4]*s+r[8]*u+r[12],f=r[1]*o+r[5]*s+r[9]*u+r[13],c=r[2]*o+r[6]*s+r[10]*u+r[14];return n(a)?(a.x=h,a.y=f,a.z=c,a):new e(h,f,c)},h.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");return n(t)?(t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t):new h(e[0]*r,e[4]*r,e[8]*r,e[12]*r,e[1]*r,e[5]*r,e[9]*r,e[13]*r,e[2]*r,e[6]*r,e[10]*r,e[14]*r,e[3]*r,e[7]*r,e[11]*r,e[15]*r)},h.negate=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r):new h(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},h.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))return new h(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var t=e[1],a=e[2],o=e[3],s=e[6],u=e[7],f=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=a,r[9]=s,r[10]=e[10],r[11]=e[14],r[12]=o,r[13]=u,r[14]=f,r[15]=e[15],r},h.abs=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r):new h(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},h.equals=function(e,r){return e===r||n(e)&&n(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[11]===r[11]&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[15]===r[15]},h.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},h.getTranslation=function(r,t){if(!n(r))throw new i("matrix is required");return n(t)?(t.x=r[12],t.y=r[13],t.z=r[14],t):new e(r[12],r[13],r[14])},h.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r):new s(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},h.inverse=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],a=e[4],s=e[8],f=e[12],c=e[1],l=e[5],d=e[9],w=e[13],m=e[2],p=e[6],y=e[10],g=e[14],v=e[3],q=e[7],x=e[11],E=e[15],b=y*E,S=g*x,M=p*E,_=g*q,O=p*x,P=y*q,T=m*E,C=g*v,R=m*x,N=y*v,I=m*q,D=p*v,z=b*l+_*d+O*w-(S*l+M*d+P*w),A=S*c+T*d+N*w-(b*c+C*d+R*w),U=M*c+C*l+I*w-(_*c+T*l+D*w),L=P*c+R*l+D*d-(O*c+N*l+I*d),W=S*a+M*s+P*f-(b*a+_*s+O*f),B=b*t+C*s+R*f-(S*t+T*s+N*f),F=_*t+T*a+D*f-(M*t+C*a+I*f),G=O*t+N*a+I*s-(P*t+R*a+D*s);b=s*w,S=f*d,M=a*w,_=f*l,O=a*d,P=s*l,T=t*w,C=f*c,R=t*d,N=s*c,I=t*l,D=a*c;var H=b*q+_*x+O*E-(S*q+M*x+P*E),V=S*v+T*x+N*E-(b*v+C*x+R*E),Y=M*v+C*q+I*E-(_*v+T*q+D*E),j=P*v+R*q+D*x-(O*v+N*q+I*x),k=M*y+P*g+S*p-(O*g+b*p+_*y),X=R*g+b*m+C*y-(T*y+N*g+S*m),Z=T*p+D*g+_*m-(I*g+M*m+C*p),J=I*y+O*m+N*p-(R*p+D*y+P*m),K=t*z+a*A+s*U+f*L;if(Math.abs(K)<o.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return K=1/K,n(r)?(r[0]=z*K,r[1]=A*K,r[2]=U*K,r[3]=L*K,r[4]=W*K,r[5]=B*K,r[6]=F*K,r[7]=G*K,r[8]=H*K,r[9]=V*K,r[10]=Y*K,r[11]=j*K,r[12]=k*K,r[13]=X*K,r[14]=Z*K,r[15]=J*K,r):new h(z*K,W*K,H*K,k*K,A*K,B*K,V*K,X*K,U*K,F*K,Y*K,Z*K,L*K,G*K,j*K,J*K)},h.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],a=e[1],o=e[2],s=e[4],u=e[5],f=e[6],c=e[8],l=e[9],d=e[10],w=e[12],m=e[13],p=e[14],y=-t*w-a*m-o*p,g=-s*w-u*m-f*p,v=-c*w-l*m-d*p;return n(r)?(r[0]=t,r[1]=s,r[2]=c,r[3]=0,r[4]=a,r[5]=u,r[6]=l,r[7]=0,r[8]=o,r[9]=f,r[10]=d,r[11]=0,r[12]=y,r[13]=g,r[14]=v,r[15]=1,r):new h(t,a,o,y,s,u,f,g,c,l,d,v,0,0,0,1)},h.IDENTITY=a(new h(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),h.COLUMN0ROW0=0,h.COLUMN0ROW1=1,h.COLUMN0ROW2=2,h.COLUMN0ROW3=3,h.COLUMN1ROW0=4,h.COLUMN1ROW1=5,h.COLUMN1ROW2=6,h.COLUMN1ROW3=7,h.COLUMN2ROW0=8,h.COLUMN2ROW1=9,h.COLUMN2ROW2=10,h.COLUMN2ROW3=11,h.COLUMN3ROW0=12,h.COLUMN3ROW1=13,h.COLUMN3ROW2=14,h.COLUMN3ROW3=15,h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.equalsEpsilon=function(e,r){return h.equalsEpsilon(this,e,r)},h.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},h}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,a,o){"use strict";var s=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};s.fromDegrees=function(e,n,i,a,u){return e=o.toRadians(r(e,0)),n=o.toRadians(r(n,0)),i=o.toRadians(r(i,0)),a=o.toRadians(r(a,0)),t(u)?(u.west=e,u.south=n,u.east=i,u.north=a,u):new s(e,n,i,a)},s.fromCartographicArray=function(e,r){if(!t(e))throw new n("cartographics is required.");for(var i=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,u=-Number.MAX_VALUE,h=0,f=e.length;f>h;h++){var c=e[h];i=Math.min(i,c.longitude),a=Math.max(a,c.longitude),o=Math.min(o,c.latitude),u=Math.max(u,c.latitude)}return t(r)?(r.west=i,r.south=o,r.east=a,r.north=u,r):new s(i,o,a,u)},s.packedLength=4,s.pack=function(e,i,a){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");a=r(a,0),i[a++]=e.west,i[a++]=e.south,i[a++]=e.east,i[a]=e.north},s.unpack=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new s),a.west=e[i++],a.south=e[i++],a.east=e[i++],a.north=e[i],a},s.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},s.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new n("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){if(!t(e))throw new n("rectangle is required");var r=e.north;if("number"!=typeof r)throw new n("north is required to be a number.");if(r<-o.PI_OVER_TWO||r>o.PI_OVER_TWO)throw new n("north must be in the interval [-Pi/2, Pi/2].");var i=e.south;if("number"!=typeof i)throw new n("south is required to be a number.");if(i<-o.PI_OVER_TWO||i>o.PI_OVER_TWO)throw new n("south must be in the interval [-Pi/2, Pi/2].");var a=e.west;if("number"!=typeof a)throw new n("west is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new n("west must be in the interval [-Pi, Pi].");var s=e.east;if("number"!=typeof s)throw new n("east is required to be a number.");if(s<-Math.PI||s>Math.PI)throw new n("east must be in the interval [-Pi, Pi].")},s.getSouthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.getNorthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.getNortheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.getSoutheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.getCenter=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=.5*(r.west+r.east),i.latitude=.5*(r.south+r.north),i.height=0,i):new e(.5*(r.west+r.east),.5*(r.south+r.north))},s.intersectWith=function(e,r,i){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("otherRectangle is required.");var a=Math.max(e.west,r.west),o=Math.max(e.south,r.south),u=Math.min(e.east,r.east),h=Math.min(e.north,r.north);return t(i)?(i.west=a,i.south=o,i.east=u,i.north=h,i):new s(a,o,u,h)},s.contains=function(e,r){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("cartographic is required.");return r.longitude>=e.west&&r.longitude<=e.east&&r.latitude>=e.south&&r.latitude<=e.north},s.isEmpty=function(e){if(!t(e))throw new n("rectangle is required");return e.west>=e.east||e.south>=e.north};var u=new e;return s.subsample=function(e,a,s,h){if(!t(e))throw new n("rectangle is required");a=r(a,i.WGS84),s=r(s,0),t(h)||(h=[]);var f=0,c=e.north,l=e.south,d=e.east,w=e.west,m=u;m.height=s,m.longitude=w,m.latitude=c,h[f]=a.cartographicToCartesian(m,h[f]),f++,m.longitude=d,h[f]=a.cartographicToCartesian(m,h[f]),f++,m.latitude=l,h[f]=a.cartographicToCartesian(m,h[f]),f++,m.longitude=w,h[f]=a.cartographicToCartesian(m,h[f]),f++,m.latitude=0>c?c:l>0?l:0;for(var p=1;8>p;++p){var y=-Math.PI+p*o.PI_OVER_TWO;y>w&&d>y&&(m.longitude=y,h[f]=a.cartographicToCartesian(m,h[f]),f++)}return 0===m.latitude&&(m.longitude=w,h[f]=a.cartographicToCartesian(m,h[f]),f++,m.longitude=d,h[f]=a.cartographicToCartesian(m,h[f]),f++),h.length=f,h},s.MAX_VALUE=a(new s(-Math.PI,-o.PI_OVER_TWO,Math.PI,o.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,r,t,n,i,a,o,s,u,h,f){"use strict";var c=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},l=new e,d=new e,w=new e,m=new e,p=new e,y=new e,g=new e,v=new e,q=new e,x=new e,E=new e,b=new e;c.fromPoints=function(r,t){if(n(t)||(t=new c),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],g),a=e.clone(i,l),o=e.clone(i,d),s=e.clone(i,w),u=e.clone(i,m),h=e.clone(i,p),f=e.clone(i,y),S=r.length,M=1;S>M;M++){e.clone(r[M],i);var _=i.x,O=i.y,P=i.z;_<a.x&&e.clone(i,a),_>u.x&&e.clone(i,u),O<o.y&&e.clone(i,o),O>h.y&&e.clone(i,h),P<s.z&&e.clone(i,s),P>f.z&&e.clone(i,f)}var T=e.magnitudeSquared(e.subtract(u,a,v)),C=e.magnitudeSquared(e.subtract(h,o,v)),R=e.magnitudeSquared(e.subtract(f,s,v)),N=a,I=u,D=T;C>D&&(D=C,N=o,I=h),R>D&&(D=R,N=s,I=f);var z=q;z.x=.5*(N.x+I.x),z.y=.5*(N.y+I.y),z.z=.5*(N.z+I.z);var A=e.magnitudeSquared(e.subtract(I,z,v)),U=Math.sqrt(A),L=x;L.x=a.x,L.y=o.y,L.z=s.z;var W=E;W.x=u.x,W.y=h.y,W.z=f.z;var B=e.multiplyByScalar(e.add(L,W,v),.5,b),F=0;for(M=0;S>M;M++){e.clone(r[M],i);var G=e.magnitude(e.subtract(i,B,v));G>F&&(F=G);var H=e.magnitudeSquared(e.subtract(i,z,v));if(H>A){var V=Math.sqrt(H);U=.5*(U+V),A=U*U;var Y=V-U;z.x=(U*z.x+Y*i.x)/V,z.y=(U*z.y+Y*i.y)/V,z.z=(U*z.z+Y*i.z)/V}}return F>U?(e.clone(z,t.center),t.radius=U):(e.clone(B,t.center),t.radius=F),t};var S=new o,M=new e,_=new e,O=new r,P=new r;c.fromRectangle2D=function(e,r,t){return c.fromRectangleWithHeights2D(e,r,0,0,t)},c.fromRectangleWithHeights2D=function(r,i,a,o,s){if(n(s)||(s=new c),!n(r))return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;i=t(i,S),f.getSouthwest(r,O),O.height=a,f.getNortheast(r,P),P.height=o;var u=i.project(O,M),h=i.project(P,_),l=h.x-u.x,d=h.y-u.y,w=h.z-u.z;s.radius=.5*Math.sqrt(l*l+d*d+w*w);var m=s.center;return m.x=u.x+.5*l,m.y=u.y+.5*d,m.z=u.z+.5*w,s};var T=[];c.fromRectangle3D=function(e,r,i,o){r=t(r,a.WGS84),i=t(i,0);var s;return n(e)&&(s=f.subsample(e,r,i,T)),c.fromPoints(s,o)},c.fromVertices=function(r,a,o,s){if(n(s)||(s=new c),!n(r)||0===r.length)return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;if(a=t(a,e.ZERO),o=t(o,3),3>o)throw new i("stride must be 3 or greater.");var u=g;u.x=r[0]+a.x,u.y=r[1]+a.y,u.z=r[2]+a.z;for(var h=e.clone(u,l),f=e.clone(u,d),S=e.clone(u,w),M=e.clone(u,m),_=e.clone(u,p),O=e.clone(u,y),P=r.length,T=0;P>T;T+=o){var C=r[T]+a.x,R=r[T+1]+a.y,N=r[T+2]+a.z;u.x=C,u.y=R,u.z=N,C<h.x&&e.clone(u,h),C>M.x&&e.clone(u,M),R<f.y&&e.clone(u,f),R>_.y&&e.clone(u,_),N<S.z&&e.clone(u,S),N>O.z&&e.clone(u,O)}var I=e.magnitudeSquared(e.subtract(M,h,v)),D=e.magnitudeSquared(e.subtract(_,f,v)),z=e.magnitudeSquared(e.subtract(O,S,v)),A=h,U=M,L=I;D>L&&(L=D,A=f,U=_),z>L&&(L=z,A=S,U=O);var W=q;W.x=.5*(A.x+U.x),W.y=.5*(A.y+U.y),W.z=.5*(A.z+U.z);var B=e.magnitudeSquared(e.subtract(U,W,v)),F=Math.sqrt(B),G=x;G.x=h.x,G.y=f.y,G.z=S.z;var H=E;H.x=M.x,H.y=_.y,H.z=O.z;var V=e.multiplyByScalar(e.add(G,H,v),.5,b),Y=0;for(T=0;P>T;T+=o){u.x=r[T]+a.x,u.y=r[T+1]+a.y,u.z=r[T+2]+a.z;var j=e.magnitude(e.subtract(u,V,v));j>Y&&(Y=j);var k=e.magnitudeSquared(e.subtract(u,W,v));if(k>B){var X=Math.sqrt(k);F=.5*(F+X),B=F*F;var Z=X-F;W.x=(F*W.x+Z*u.x)/X,W.y=(F*W.y+Z*u.y)/X,W.z=(F*W.z+Z*u.z)/X}}return Y>F?(e.clone(W,s.center),s.radius=F):(e.clone(V,s.center),s.radius=Y),s},c.fromCornerPoints=function(r,t,a){if(!n(r)||!n(t))throw new i("corner and oppositeCorner are required.");n(a)||(a=new c);var o=a.center;return e.add(r,t,o),e.multiplyByScalar(o,.5,o),a.radius=e.distance(o,t),a},c.fromEllipsoid=function(r,t){if(!n(r))throw new i("ellipsoid is required.");return n(t)||(t=new c),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t},c.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new c(r.center,r.radius):void 0},c.packedLength=4,c.pack=function(e,r,a){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");a=t(a,0);var o=e.center;r[a++]=o.x,r[a++]=o.y,r[a++]=o.z,r[a]=e.radius},c.unpack=function(e,r,a){if(!n(e))throw new i("array is required");r=t(r,0),n(a)||(a=new c);var o=a.center;return o.x=e[r++],o.y=e[r++],o.z=e[r++],a.radius=e[r],a};var C=new e,R=new e;c.union=function(r,t,a){if(!n(r))throw new i("left is required.");if(!n(t))throw new i("right is required.");n(a)||(a=new c);var o=r.center,s=t.center;e.add(o,s,R);var u=e.multiplyByScalar(R,.5,R),h=e.magnitude(e.subtract(o,u,C))+r.radius,f=e.magnitude(e.subtract(s,u,C))+t.radius;return a.radius=Math.max(h,f),e.clone(u,a.center),a};var N=new e;c.expand=function(r,t,a){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("point is required.");a=c.clone(r,a);var o=e.magnitude(e.subtract(t,a.center,N));return o>a.radius&&(a.radius=o),a},c.intersect=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("plane is required.");var a=r.center,o=r.radius,u=e.dot(t,a)+t.w;return-o>u?s.OUTSIDE:o>u?s.INTERSECTING:s.INSIDE},c.transform=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new c),t.center=h.multiplyByPoint(r,e.center,t.center),t.radius=h.getMaximumScale(r)*e.radius,t};var I=new e;c.distanceSquaredTo=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("cartesian is required.");var a=e.subtract(r.center,t,I);return e.magnitudeSquared(a)-r.radius*r.radius},c.transformWithoutScale=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new c),t.center=h.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var D=new e;c.getPlaneDistances=function(r,t,a,o){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("position is required.");if(!n(a))throw new i("direction is required.");n(o)||(o=new u);var s=e.subtract(r.center,t,D),h=e.multiplyByScalar(a,e.dot(a,s),D),f=e.magnitude(h);return o.start=f-r.radius,o.stop=f+r.radius,o};for(var z=new e,A=new e,U=new e,L=new e,W=new e,B=new r,F=new Array(8),G=0;8>G;++G)F[G]=new e;var H=new o;return c.projectTo2D=function(r,a,o){if(!n(r))throw new i("sphere is required.");a=t(a,H);var s=a.ellipsoid,u=r.center,h=r.radius,f=s.geodeticSurfaceNormal(u,z),l=e.cross(e.UNIT_Z,f,A);e.normalize(l,l);var d=e.cross(f,l,U);e.normalize(d,d),e.multiplyByScalar(f,h,f),e.multiplyByScalar(d,h,d),e.multiplyByScalar(l,h,l);var w=e.negate(d,W),m=e.negate(l,L),p=F,y=p[0];e.add(f,d,y),e.add(y,l,y),y=p[1],e.add(f,d,y),e.add(y,m,y),y=p[2],e.add(f,w,y),e.add(y,m,y),y=p[3],e.add(f,w,y),e.add(y,l,y),e.negate(f,f),y=p[4],e.add(f,d,y),e.add(y,l,y),y=p[5],e.add(f,d,y),e.add(y,m,y),y=p[6],e.add(f,w,y),e.add(y,m,y),y=p[7],e.add(f,w,y),e.add(y,l,y);for(var g=p.length,v=0;g>v;++v){var q=p[v];e.add(u,q,q);var x=s.cartesianToCartographic(q,B);a.project(x,q)}o=c.fromPoints(p,o),u=o.center;var E=u.x,b=u.y,S=u.z;return u.x=S,u.y=E,u.z=b,o},c.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius
},c.prototype.intersect=function(e){return c.intersect(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.prototype.clone=function(e){return c.clone(this,e)},c}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,s=a.length;s>o;++o){var u=a[o];i=u+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=u+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=u+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=u+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=u+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=u+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=u+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=u+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=u+"fullscreenchange",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=u+"fullscreenerror",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(l)){var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null===e?l=!1:(l=!0,d=n(e[1]))}return l}function a(){return i()&&d}function o(){if(!r(w))if(i()||!/ Safari\/[\.0-9]+/.test(navigator.userAgent))w=!1;else{var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null===e?w=!1:(w=!0,m=n(e[1]))}return w}function s(){return o()&&m}function u(){if(!r(p)){var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null===e?p=!1:(p=!0,y=n(e[1]),y.isNightly=!!e[2])}return p}function h(){return u()&&y}function f(){if(!r(g)){var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(g=!0,v=n(e[1]))):"Netscape"===navigator.appName?(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(g=!0,v=n(e[1]))):g=!1}return g}function c(){return f()&&v}var l,d,w,m,p,y,g,v,q={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:s,isWebkit:u,webkitVersion:h,isInternetExplorer:f,internetExplorerVersion:c,hardwareConcurrency:e(navigator.hardwareConcurrency,3)};return q.supportsFullscreen=function(){return t.supportsFullscreen()},q.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},q}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection"],function(e,r,t,n){"use strict";if(!n.supportsTypedArrays())return{};var i={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return i.getSizeInBytes=function(e){if(!r(e))throw new t("value is required.");switch(e){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new t("componentDatatype is not a valid value.")}},i.fromTypedArray=function(e){return e instanceof Int8Array?i.BYTE:e instanceof Uint8Array?i.UNSIGNED_BYTE:e instanceof Int16Array?i.SHORT:e instanceof Uint16Array?i.UNSIGNED_SHORT:e instanceof Float32Array?i.FLOAT:e instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(e){return r(e)&&(e===i.BYTE||e===i.UNSIGNED_BYTE||e===i.SHORT||e===i.UNSIGNED_SHORT||e===i.FLOAT||e===i.DOUBLE)},i.createTypedArray=function(e,n){if(!r(e))throw new t("componentDatatype is required.");if(!r(n))throw new t("valuesOrLength is required.");switch(e){case i.BYTE:return new Int8Array(n);case i.UNSIGNED_BYTE:return new Uint8Array(n);case i.SHORT:return new Int16Array(n);case i.UNSIGNED_SHORT:return new Uint16Array(n);case i.FLOAT:return new Float32Array(n);case i.DOUBLE:return new Float64Array(n);default:throw new t("componentDatatype is not a valid value.")}},i.createArrayBufferView=function(n,a,o,s){if(!r(n))throw new t("componentDatatype is required.");if(!r(a))throw new t("buffer is required.");switch(o=e(o,0),s=e(s,(a.byteLength-o)/i.getSizeInBytes(n)),n){case i.BYTE:return new Int8Array(a,o,s);case i.UNSIGNED_BYTE:return new Uint8Array(a,o,s);case i.SHORT:return new Int16Array(a,o,s);case i.UNSIGNED_SHORT:return new Uint16Array(a,o,s);case i.FLOAT:return new Float32Array(a,o,s);case i.DOUBLE:return new Float64Array(a,o,s);default:throw new t("componentDatatype is not a valid value.")}},i}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.attributes))throw new t("options.attributes is required.");if(!r(n.primitiveType))throw new t("options.primitiveType is required.");this.attributes=n.attributes,this.indices=n.indices,this.primitiveType=n.primitiveType,this.boundingSphere=n.boundingSphere};return n.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&r(e.attributes[i])&&r(e.attributes[i].values)){var a=e.attributes[i],o=a.values.length/a.componentsPerAttribute;if(n!==o&&-1!==n)throw new t("All attribute lists must have the same number of attributes.");n=o}return n},n}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(n.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(n.values))throw new t("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/IndexDatatype",["./defined","./DeveloperError","./Math"],function(e,r,t){"use strict";var n={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return n.getSizeInBytes=function(e){switch(e){case n.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case n.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case n.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new r("indexDatatype is required and must be a valid IndexDatatype constant.")},n.validate=function(r){return e(r)&&(r===n.UNSIGNED_BYTE||r===n.UNSIGNED_SHORT||r===n.UNSIGNED_INT)},n.createTypedArray=function(n,i){if(!e(n))throw new r("numberOfVertices is required.");return n>t.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},n}),define("Core/PrimitiveType",[],function(){"use strict";var e={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(r){return r===e.POINTS||r===e.LINES||r===e.LINE_LOOP||r===e.LINE_STRIP||r===e.TRIANGLES||r===e.TRIANGLE_STRIP||r===e.TRIANGLE_FAN}};return e}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Intersect"],function(e,r,t,n,i){"use strict";var a=function(n,i,a){this.minimum=e.clone(r(n,e.ZERO)),this.maximum=e.clone(r(i,e.ZERO)),t(a)?a=e.clone(a):(a=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(a,.5,a)),this.center=a};a.fromPoints=function(r,n){if(t(n)||(n=new a),!t(r)||0===r.length)return n.minimum=e.clone(e.ZERO,n.minimum),n.maximum=e.clone(e.ZERO,n.maximum),n.center=e.clone(e.ZERO,n.center),n;for(var i=r[0].x,o=r[0].y,s=r[0].z,u=r[0].x,h=r[0].y,f=r[0].z,c=r.length,l=1;c>l;l++){var d=r[l],w=d.x,m=d.y,p=d.z;i=Math.min(w,i),u=Math.max(w,u),o=Math.min(m,o),h=Math.max(m,h),s=Math.min(p,s),f=Math.max(p,f)}var y=n.minimum;y.x=i,y.y=o,y.z=s;var g=n.maximum;g.x=u,g.y=h,g.z=f;var v=e.add(y,g,n.center);return e.multiplyByScalar(v,.5,v),n},a.clone=function(r,n){return t(r)?t(n)?(n.minimum=e.clone(r.minimum,n.minimum),n.maximum=e.clone(r.maximum,n.maximum),n.center=e.clone(r.center,n.center),n):new a(r.minimum,r.maximum):void 0},a.equals=function(r,n){return r===n||t(r)&&t(n)&&e.equals(r.center,n.center)&&e.equals(r.minimum,n.minimum)&&e.equals(r.maximum,n.maximum)};var o=new e;return a.intersect=function(r,a){if(!t(r))throw new n("box is required.");if(!t(a))throw new n("plane is required.");o=e.subtract(r.maximum,r.minimum,o);var s=e.multiplyByScalar(o,.5,o),u=s.x*Math.abs(a.x)+s.y*Math.abs(a.y)+s.z*Math.abs(a.z),h=e.dot(r.center,a)+a.w;return h-u>0?i.INSIDE:0>h+u?i.OUTSIDE:i.INTERSECTING},a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.intersect=function(e){return a.intersect(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t){this.x=e(r,0),this.y=e(t,0)};a.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new a(e,t)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a]=n.y},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i],o},a.fromArray=a.unpack,a.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y)},a.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y)},a.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i},a.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n};var s=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,s),o=a.multiplyByScalar(e,1-i,o),a.add(s,o,o)};var u=new a,h=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return a.normalize(e,u),a.normalize(n,h),i.acosClamped(a.dot(u,h))};var f=new a;return a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,f);return a.abs(i,i),n=i.x<=i.y?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Y,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i},a.ZERO=n(new a(0,0)),a.UNIT_X=n(new a(1,0)),a.UNIT_Y=n(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,r){"use strict";function t(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}var n={};return n.discriminant=function(r,t,n){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=t*t-4*r*n;return i},n.realRoots=function(n,i,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");var o;if(0===n)return 0===i?[]:[-a/i];if(0===i){if(0===a)return[0,0];var s=Math.abs(a),u=Math.abs(n);if(u>s&&s/u<r.EPSILON14)return[0,0];if(s>u&&u/s<r.EPSILON14)return[];if(o=-a/n,0>o)return[];var h=Math.sqrt(o);return[-h,h]}if(0===a)return o=-i/n,0>o?[o,0]:[0,o];var f=i*i,c=4*n*a,l=t(f,-c,r.EPSILON14);if(0>l)return[];var d=-.5*t(i,r.sign(i)*Math.sqrt(l),r.EPSILON14);return i>0?[d/n,a/d]:[a/d,d/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,r){"use strict";function t(e,r,t,n){var i,a,o=e,s=r/3,u=t/3,h=n,f=o*u,c=s*h,l=s*s,d=u*u,w=o*u-l,m=o*h-s*u,p=s*h-d,y=4*w*p-m*m;if(0>y){var g,v,q;l*c>=f*d?(g=o,v=w,q=-2*s*w+o*m):(g=h,v=p,q=-h*m+2*u*p);var x=0>q?-1:1,E=-x*Math.abs(g)*Math.sqrt(-y);a=-q+E;var b=a/2,S=0>b?-Math.pow(-b,1/3):Math.pow(b,1/3),M=a===E?-S:-v/S;return i=0>=v?S+M:-q/(S*S+M*M+v),l*c>=f*d?[(i-s)/o]:[-h/(i+u)]}var _=w,O=-2*s*w+o*m,P=p,T=-h*m+2*u*p,C=Math.sqrt(y),R=Math.sqrt(3)/2,N=Math.abs(Math.atan2(o*C,-O)/3);i=2*Math.sqrt(-_);var I=Math.cos(N);a=i*I;var D=i*(-I/2-R*Math.sin(N)),z=a+D>2*s?a-s:D-s,A=o,U=z/A;N=Math.abs(Math.atan2(h*C,-T)/3),i=2*Math.sqrt(-P),I=Math.cos(N),a=i*I,D=i*(-I/2-R*Math.sin(N));var L=-h,W=2*u>a+D?a+u:D+u,B=L/W,F=A*W,G=-z*W-A*L,H=z*L,V=(u*G-s*H)/(-s*G+u*F);return V>=U?B>=U?B>=V?[U,V,B]:[U,B,V]:[B,U,V]:B>=U?[V,U,B]:B>=V?[V,B,U]:[B,V,U]}var n={};return n.discriminant=function(r,t,n,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var a=r*r,o=t*t,s=n*n,u=i*i,h=18*r*t*n*i+o*s-27*a*u-4*(r*s*n+o*t*i);return h},n.realRoots=function(n,i,a,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var s,u;if(0===n)return r.realRoots(i,a,o);if(0===i){if(0===a){if(0===o)return[0,0,0];u=-o/n;var h=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[h,h,h]}return 0===o?(s=r.realRoots(n,0,a),0===s.Length?[0]:[s[0],0,s[1]]):t(n,0,a,o)}return 0===a?0===o?(u=-i/n,0>u?[u,0,0]:[0,0,u]):t(n,i,0,o):0===o?(s=r.realRoots(n,i,a),0===s.length?[0]:s[1]<=0?[s[0],s[1],0]:s[0]>=0?[0,s[0],s[1]]:[s[0],0,s[1]]):t(n,i,a,o)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,r,t,n){"use strict";function i(r,i,a,o){var s=r*r,u=i-3*s/8,h=a-i*r/2+s*r/8,f=o-a*r/4+i*s/16-3*s*s/256,c=e.realRoots(1,2*u,u*u-4*f,-h*h);if(c.length>0){var l=-r/4,d=c[c.length-1];if(Math.abs(d)<t.EPSILON14){var w=n.realRoots(1,u,f);if(2===w.length){var m,p=w[0],y=w[1];if(p>=0&&y>=0){var g=Math.sqrt(p),v=Math.sqrt(y);return[l-v,l-g,l+g,l+v]}if(p>=0&&0>y)return m=Math.sqrt(p),[l-m,l+m];if(0>p&&y>=0)return m=Math.sqrt(y),[l-m,l+m]}return[]}if(d>0){var q=Math.sqrt(d),x=(u+d-h/q)/2,E=(u+d+h/q)/2,b=n.realRoots(1,q,x),S=n.realRoots(1,-q,E);return 0!==b.length?(b[0]+=l,b[1]+=l,0!==S.length?(S[0]+=l,S[1]+=l,b[1]<=S[0]?[b[0],b[1],S[0],S[1]]:S[1]<=b[0]?[S[0],S[1],b[0],b[1]]:b[0]>=S[0]&&b[1]<=S[1]?[S[0],b[0],b[1],S[1]]:S[0]>=b[0]&&S[1]<=b[1]?[b[0],S[0],S[1],b[1]]:b[0]>S[0]&&b[0]<S[1]?[S[0],b[0],S[1],b[1]]:[b[0],S[0],b[1],S[1]]):b):0!==S.length?(S[0]+=l,S[1]+=l,S):[]}}return[]}function a(r,i,a,o){var s=a*a,u=i*i,h=r*r,f=-2*i,c=a*r+u-4*o,l=h*o-a*i*r+s,d=e.realRoots(1,f,c,l);if(d.length>0){var w,m,p=d[0],y=i-p,g=y*y,v=r/2,q=y/2,x=g-4*o,E=g+4*Math.abs(o),b=h-4*p,S=h+4*Math.abs(p);if(0>p||b*E>x*S){var M=Math.sqrt(b);w=M/2,m=0===M?0:(r*q-a)/M}else{var _=Math.sqrt(x);w=0===_?0:(r*q-a)/_,m=_/2}var O,P;0===v&&0===w?(O=0,P=0):t.sign(v)===t.sign(w)?(O=v+w,P=p/O):(P=v-w,O=p/P);var T,C;0===q&&0===m?(T=0,C=0):t.sign(q)===t.sign(m)?(T=q+m,C=o/T):(C=q-m,T=o/C);var R=n.realRoots(1,O,T),N=n.realRoots(1,P,C);if(0!==R.length)return 0!==N.length?R[1]<=N[0]?[R[0],R[1],N[0],N[1]]:N[1]<=R[0]?[N[0],N[1],R[0],R[1]]:R[0]>=N[0]&&R[1]<=N[1]?[N[0],R[0],R[1],N[1]]:N[0]>=R[0]&&N[1]<=R[1]?[R[0],N[0],N[1],R[1]]:R[0]>N[0]&&R[0]<N[1]?[N[0],R[0],N[1],R[1]]:[R[0],N[0],R[1],N[1]]:R;if(0!==N.length)return N}return[]}var o={};return o.discriminant=function(e,t,n,i,a){if("number"!=typeof e)throw new r("a is a required number.");if("number"!=typeof t)throw new r("b is a required number.");if("number"!=typeof n)throw new r("c is a required number.");if("number"!=typeof i)throw new r("d is a required number.");if("number"!=typeof a)throw new r("e is a required number.");var o=e*e,s=o*e,u=t*t,h=u*t,f=n*n,c=f*n,l=i*i,d=l*i,w=a*a,m=w*a,p=u*f*l-4*h*d-4*e*c*l+18*e*t*n*d-27*o*l*l+256*s*m+a*(18*h*n*i-4*u*c+16*e*f*f-80*e*t*f*i-6*e*u*l+144*o*n*l)+w*(144*e*u*n-27*u*u-128*o*f-192*o*t*i);return p},o.realRoots=function(n,o,s,u,h){if("number"!=typeof n)throw new r("a is a required number.");if("number"!=typeof o)throw new r("b is a required number.");if("number"!=typeof s)throw new r("c is a required number.");if("number"!=typeof u)throw new r("d is a required number.");if("number"!=typeof h)throw new r("e is a required number.");if(Math.abs(n)<t.EPSILON15)return e.realRoots(o,s,u,h);var f=o/n,c=s/n,l=u/n,d=h/n,w=0>f?1:0;switch(w+=0>c?w+1:w,w+=0>l?w+1:w,w+=0>d?w+1:w){case 0:return i(f,c,l,d);case 1:return a(f,c,l,d);case 2:return a(f,c,l,d);case 3:return i(f,c,l,d);case 4:return i(f,c,l,d);case 5:return a(f,c,l,d);case 6:return i(f,c,l,d);case 7:return i(f,c,l,d);case 8:return a(f,c,l,d);case 9:return i(f,c,l,d);case 10:return i(f,c,l,d);case 11:return a(f,c,l,d);case 12:return i(f,c,l,d);case 13:return i(f,c,l,d);case 14:return i(f,c,l,d);case 15:return i(f,c,l,d);default:return void 0}},o}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial"],function(e,r,t,n,i,a,o,s){"use strict";function u(e,r,t){var n=e+r;return i.sign(e)!==i.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<t?0:n}function h(r,t,n,h,f){var c,l=h*h,d=f*f,w=(r[a.COLUMN1ROW1]-r[a.COLUMN2ROW2])*d,m=f*(h*u(r[a.COLUMN1ROW0],r[a.COLUMN0ROW1],i.EPSILON15)+t.y),p=r[a.COLUMN0ROW0]*l+r[a.COLUMN2ROW2]*d+h*t.x+n,y=d*u(r[a.COLUMN2ROW1],r[a.COLUMN1ROW2],i.EPSILON15),g=f*(h*u(r[a.COLUMN2ROW0],r[a.COLUMN0ROW2])+t.z),v=[];if(0===g&&0===y){if(c=o.realRoots(w,m,p),0===c.length)return v;var q=c[0],x=Math.sqrt(Math.max(1-q*q,0));if(v.push(new e(h,f*q,f*-x)),v.push(new e(h,f*q,f*x)),2===c.length){var E=c[1],b=Math.sqrt(Math.max(1-E*E,0));v.push(new e(h,f*E,f*-b)),v.push(new e(h,f*E,f*b))}return v}var S=g*g,M=y*y,_=w*w,O=g*y,P=_+M,T=2*(m*w+O),C=2*p*w+m*m-M+S,R=2*(p*m-O),N=p*p-S;if(0===P&&0===T&&0===C&&0===R)return v;c=s.realRoots(P,T,C,R,N);var I=c.length;if(0===I)return v;for(var D=0;I>D;++D){var z,A=c[D],U=A*A,L=Math.max(1-U,0),W=Math.sqrt(L);z=i.sign(w)===i.sign(p)?u(w*U+p,m*A,i.EPSILON12):i.sign(p)===i.sign(m*A)?u(w*U,m*A+p,i.EPSILON12):u(w*U+m*A,p,i.EPSILON12);var B=u(y*A,g,i.EPSILON15),F=z*B;0>F?v.push(new e(h,f*A,f*W)):F>0?v.push(new e(h,f*A,f*-W)):0!==W?(v.push(new e(h,f*A,f*-W)),v.push(new e(h,f*A,f*W)),++D):v.push(new e(h,f*A,f*W))}return v}var f={};f.rayPlane=function(r,a,o){if(!t(r))throw new n("ray is required.");if(!t(a))throw new n("plane is required.");t(o)||(o=new e);var s=r.origin,u=r.direction,h=a.normal,f=e.dot(h,u);if(Math.abs(f)<i.EPSILON15)return void 0;var c=(-a.distance-e.dot(h,s))/f;return 0>c?void 0:(o=e.multiplyByScalar(u,c,o),e.add(s,o,o))};var c=new e,l=new e;f.rayEllipsoid=function(r,i){if(!t(r))throw new n("ray is required.");if(!t(i))throw new n("ellipsoid is required.");var a,o,s,u,h,f=i.oneOverRadii,d=e.multiplyComponents(f,r.origin,c),w=e.multiplyComponents(f,r.direction,l),m=e.magnitudeSquared(d),p=e.dot(d,w);if(m>1){if(p>=0)return void 0;var y=p*p;if(a=m-1,o=e.magnitudeSquared(w),s=o*a,s>y)return void 0;if(y>s){u=p*p-s,h=-p+Math.sqrt(u);var g=h/o,v=a/h;return v>g?{start:g,stop:v}:{start:v,stop:g}}var q=Math.sqrt(a/o);return{start:q,stop:q}}return 1>m?(a=m-1,o=e.magnitudeSquared(w),s=o*a,u=p*p-s,h=-p+Math.sqrt(u),{start:0,stop:h/o}):0>p?(o=e.magnitudeSquared(w),{start:0,stop:-p/o}):void 0};var d=new e,w=new e,m=new e,p=new e;f.grazingAltitudeLocation=function(o,s){if(!t(o))throw new n("ray is required.");if(!t(s))throw new n("ellipsoid is required.");var u=o.origin,f=o.direction,c=s.geodeticSurfaceNormal(u);if(e.dot(f,c)>=0)return u;var l,y,g=t(this.rayEllipsoid(o,s)),v=s.transformPositionToScaledSpace(f),q=e.normalize(v,d),x=e.mostOrthogonalAxis(v,p),E=e.normalize(e.cross(x,q,w),w),b=e.normalize(e.cross(q,E,m),m),S=new a(q.x,E.x,b.x,q.y,E.y,b.y,q.z,E.z,b.z),M=a.transpose(S),_=a.fromScale(s.radii),O=a.fromScale(s.oneOverRadii),P=new a(0,f.z,-f.y,-f.z,0,f.x,f.y,-f.x,0),T=a.multiply(a.multiply(M,O),P),C=a.multiply(a.multiply(T,_),S),R=a.multiplyByVector(T,u),N=h(C,e.negate(R,d),0,0,1),I=N.length;if(I>0){for(var D=e.ZERO,z=Number.NEGATIVE_INFINITY,A=0;I>A;++A){l=a.multiplyByVector(_,a.multiplyByVector(S,N[A]));var U=e.normalize(e.subtract(l,u,p),p),L=e.dot(U,f);L>z&&(z=L,D=l)}var W=s.cartesianToCartographic(D);return z=i.clamp(z,0,1),y=e.magnitude(e.subtract(D,u,p))*Math.sqrt(1-z*z),y=g?-y:y,s.cartographicToCartesian(new r(W.longitude,W.latitude,y))}return void 0};var y=new e;return f.lineSegmentPlane=function(r,a,o,s){if(!t(r))throw new n("endPoint0 is required.");if(!t(a))throw new n("endPoint1 is required.");if(!t(o))throw new n("plane is required.");t(s)||(s=new e);var u=e.subtract(a,r,y),h=o.normal,f=e.dot(h,u);if(Math.abs(f)<i.EPSILON6)return void 0;var c=e.dot(h,r),l=-(o.distance+c)/f;return 0>l||l>1?void 0:(e.multiplyByScalar(u,l,s),e.add(r,s,s),s)},f.trianglePlaneIntersection=function(r,i,a,o){if(!(t(r)&&t(i)&&t(a)&&t(o)))throw new n("p0, p1, p2, and plane are required.");var s=o.normal,u=o.distance,h=e.dot(s,r)+u<0,c=e.dot(s,i)+u<0,l=e.dot(s,a)+u<0,d=0;d+=h?1:0,d+=c?1:0,d+=l?1:0;var w,m;if((1===d||2===d)&&(w=new e,m=new e),1===d){if(h)return f.lineSegmentPlane(r,i,o,w),f.lineSegmentPlane(r,a,o,m),{positions:[r,i,a,w,m],indices:[0,3,4,1,2,4,1,4,3]};if(c)return f.lineSegmentPlane(i,a,o,w),f.lineSegmentPlane(i,r,o,m),{positions:[r,i,a,w,m],indices:[1,3,4,2,0,4,2,4,3]};if(l)return f.lineSegmentPlane(a,r,o,w),f.lineSegmentPlane(a,i,o,m),{positions:[r,i,a,w,m],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===d){if(!h)return f.lineSegmentPlane(i,r,o,w),f.lineSegmentPlane(a,r,o,m),{positions:[r,i,a,w,m],indices:[1,2,4,1,4,3,0,3,4]};if(!c)return f.lineSegmentPlane(a,i,o,w),f.lineSegmentPlane(r,i,o,m),{positions:[r,i,a,w,m],indices:[2,0,4,2,4,3,1,3,4]};if(!l)return f.lineSegmentPlane(r,a,o,w),f.lineSegmentPlane(i,a,o,m),{positions:[r,i,a,w,m],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},f}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n,i){if(!r(n))throw new t("normal is required.");if(!r(i))throw new t("distance is required.");this.normal=e.clone(n),this.distance=i};return n.fromPointNormal=function(i,a,o){if(!r(i))throw new t("point is required.");if(!r(a))throw new t("normal is required.");var s=-e.dot(a,i);return r(o)?(e.clone(a,o.normal),o.distance=s,o):new n(a,s)},n.getPointDistance=function(n,i){if(!r(n))throw new t("plane is required.");if(!r(i))throw new t("point is required.");return e.dot(n.normal,i)+n.distance},n}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=function(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n};return i.getPoint=function(r,i,a){if(!t(r))throw new n("ray is requred");if("number"!=typeof i)throw new n("t is a required number");return t(a)||(a=new e),a=e.multiplyByScalar(r.direction,i,a),e.add(r.origin,a,a)},i}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,t,n,i){return r(e).then(t,n,i)}function r(e){var r,t;return e instanceof n?r=e:s(e)?(t=o(),e.then(function(e){t.resolve(e)},function(e){t.reject(e)},function(e){t.progress(e)}),r=t.promise):r=i(e),r}function t(r){return e(r,a)}function n(e){this.then=e}function i(e){var t=new n(function(t){try{return r(t?t(e):e)}catch(n){return a(n)}});return t}function a(e){var t=new n(function(t,n){try{return n?r(n(e)):a(e)}catch(i){return a(i)}});return t}function o(){function e(e,r,t){return l(e,r,t)}function t(e){return w(e)}function i(e){return w(a(e))}function s(e){return d(e)}var u,h,f,c,l,d,w;return h=new n(e),u={then:e,resolve:t,reject:i,progress:s,promise:h,resolver:{resolve:t,reject:i,progress:s}},f=[],c=[],l=function(e,r,t){var n,i;return n=o(),i="function"==typeof t?function(e){try{n.progress(t(e))}catch(r){n.progress(r)}}:function(e){n.progress(e)},f.push(function(t){t.then(e,r).then(n.resolve,n.reject,i)}),c.push(i),n.promise},d=function(e){return m(c,e),e},w=function(e){return e=r(e),l=e.then,w=r,d=y,m(f,e),c=f=x,e},u}function s(e){return e&&"function"==typeof e.then}function u(r,t,n,i,a){return p(2,arguments),e(r,function(r){function s(e){m(e)}function u(e){w(e)}var h,f,c,l,d,w,m,p,g,v;if(g=r.length>>>0,h=Math.max(0,Math.min(t,g)),c=[],f=g-h+1,l=[],d=o(),h)for(p=d.progress,m=function(e){l.push(e),--f||(w=m=y,d.reject(l))},w=function(e){c.push(e),--h||(w=m=y,d.resolve(c))},v=0;g>v;++v)v in r&&e(r[v],u,s,p);else d.resolve(c);return d.then(n,i,a)})}function h(e,r,t,n){function i(e){return r?r(e[0]):e[0]}return u(e,1,i,t,n)}function f(e,r,t,n){return p(1,arguments),l(e,g).then(r,t,n)}function c(){return l(arguments,g)}function l(r,t){return e(r,function(r){var n,i,a,s,u,h;if(a=i=r.length>>>0,n=[],h=o(),a)for(s=function(r,i){e(r,t).then(function(e){n[i]=e,--a||h.resolve(n)},h.reject)},u=0;i>u;u++)u in r?s(r[u],u):--a;else h.resolve(n);return h.promise})}function d(r,t){var n=q.call(arguments,1);return e(r,function(r){var i;return i=r.length,n[0]=function(r,n,a){return e(r,function(r){return e(n,function(e){return t(r,e,a,i)})})},v.apply(r,n)})}function w(r,t,n){var i=arguments.length>2;return e(r,function(e){return e=i?n:e,t.resolve(e),e},function(e){return t.reject(e),a(e)},t.progress)}function m(e,r){for(var t,n=0;t=e[n++];)t(r)}function p(e,r){for(var t,n=r.length;n>e;)if(t=r[--n],null!=t&&"function"!=typeof t)throw new Error("arg "+n+" must be a function")}function y(){}function g(e){return e}var v,q,x;return e.defer=o,e.resolve=r,e.reject=t,e.join=c,e.all=f,e.map=l,e.reduce=d,e.any=h,e.some=u,e.chain=w,e.isPromise=s,n.prototype={always:function(e,r){return this.then(e,e,r)},otherwise:function(e){return this.then(x,e)},yield:function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(r){return f(r,function(r){return e.apply(x,r)})})}},q=[].slice,v=[].reduce||function(e){var r,t,n,i,a;if(a=0,r=Object(this),i=r.length>>>0,t=arguments,t.length<=1)for(;;){if(a in r){n=r[a++];break}if(++a>=i)throw new TypeError}else n=t[1];for(;i>a;++a)a in r&&(n=e(n,r[a],a,r));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,r){"use strict";var t=function(t,n,i){if(!e(t))throw new r("array is required.");if(!e(n))throw new r("itemToFind is required.");if(!e(i))throw new r("comparator is required.");for(var a,o,s=0,u=t.length-1;u>=s;)if(a=~~((s+u)/2),o=i(t[a],n),0>o)s=a+1;else{if(!(o>0))return a;u=a-1}return~(u+1)};return t}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,r,t,n,i){this.xPoleWander=e,this.yPoleWander=r,this.xPoleOffset=t,this.yPoleOffset=n,this.ut1MinusUtc=i};return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,r=arguments,t=0,n=r[t++],i=function(e,r,t,n){t||(t=" ");var i=e.length>=r?"":Array(1+r-e.length>>>0).join(t);return n?e+i:i+e},a=function(e,r,t,n,a,o){var s=n-e.length;return s>0&&(e=t||!a?i(e,n,o,t):e.slice(0,r.length)+i("",s,"0",!0)+e.slice(r.length)),e},o=function(e,r,t,n,o,s,u){var h=e>>>0;return t=t&&h&&{2:"0b",8:"0",16:"0x"}[r]||"",e=t+i(h.toString(r),s||0,"0",!1),a(e,t,n,o,u)},s=function(e,r,t,n,i,o){return null!=n&&(e=e.slice(0,n)),a(e,"",r,t,i,o)},u=function(e,n,u,h,f,c,l){var d,w,m,p,y;if("%%"==e)return"%";for(var g=!1,v="",q=!1,x=!1,E=" ",b=u.length,S=0;u&&b>S;S++)switch(u.charAt(S)){case" ":v=" ";break;case"+":v="+";break;case"-":g=!0;break;case"'":E=u.charAt(S+1);break;case"0":q=!0;break;case"#":x=!0
}if(h=h?"*"==h?+r[t++]:"*"==h.charAt(0)?+r[h.slice(1,-1)]:+h:0,0>h&&(h=-h,g=!0),!isFinite(h))throw new Error("sprintf: (minimum-)width must be finite");switch(c=c?"*"==c?+r[t++]:"*"==c.charAt(0)?+r[c.slice(1,-1)]:+c:"fFeE".indexOf(l)>-1?6:"d"==l?0:void 0,y=n?r[n.slice(0,-1)]:r[t++],l){case"s":return s(String(y),g,h,c,q,E);case"c":return s(String.fromCharCode(+y),g,h,c,q);case"b":return o(y,2,x,g,h,c,q);case"o":return o(y,8,x,g,h,c,q);case"x":return o(y,16,x,g,h,c,q);case"X":return o(y,16,x,g,h,c,q).toUpperCase();case"u":return o(y,10,x,g,h,c,q);case"i":case"d":return d=+y||0,d=Math.round(d-d%1),w=0>d?"-":v,y=w+i(String(Math.abs(d)),c,"0",!1),a(y,w,g,h,q);case"e":case"E":case"f":case"F":case"g":case"G":return d=+y,w=0>d?"-":v,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(l.toLowerCase())],p=["toString","toUpperCase"]["eEfFgG".indexOf(l)%2],y=w+Math.abs(d)[m](c),a(y,w,g,h,q)[p]();default:return e}};return n.replace(e,u)}return e}),define("Core/GregorianDate",[],function(){"use strict";var e=function(e,r,t,n,i,a,o,s){this.year=e,this.month=r,this.day=t,this.hour=n,this.minute=i,this.second=a,this.millisecond=o,this.isLeapSecond=s};return e}),define("Core/isArray",["./defined"],function(e){"use strict";var r=Array.isArray;return e(r)||(r=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),r}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function r(r){if(null===r||isNaN(r))throw new e("year is required and must be a number.");return 0===r%4&&0!==r%100||0===r%400}return r}),define("Core/LeapSecond",[],function(){"use strict";var e=function(e,r){this.julianDate=e,this.offset=r};return e}),define("Core/TimeConstants",[],function(){"use strict";var e={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e}),define("Core/TimeStandard",[],function(){"use strict";var e={UTC:0,TAI:1};return e}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./defineProperties","./DeveloperError","./GregorianDate","./isArray","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,r,t,n,i,a,o,s,u,h,f,c){"use strict";function l(e,r){return R.compare(e.julianDate,r.julianDate)}function d(e){q.julianDate=e;var t=R.leapSeconds,n=r(t,q,l);0>n&&(n=~n),n>=t.length&&(n=t.length-1);var i=t[n].offset;if(n>0){var a=R.getSecondsDifference(t[n].julianDate,e);a>i&&(n--,i=t[n].offset)}R.addSeconds(e,i,e)}function w(e,t){q.julianDate=e;var n=R.leapSeconds,i=r(n,q,l);if(0>i&&(i=~i),0===i)return R.addSeconds(e,-n[0].offset,t);if(i>=n.length)return R.addSeconds(e,-n[i-1].offset,t);var a=R.getSecondsDifference(n[i].julianDate,e);return 0===a?R.addSeconds(e,-n[i].offset,t):1>=a?void 0:R.addSeconds(e,-n[--i].offset,t)}function m(e,r,t){var n=0|r/f.SECONDS_PER_DAY;return e+=n,r-=f.SECONDS_PER_DAY*n,0>r&&(e--,r+=f.SECONDS_PER_DAY),t.dayNumber=e,t.secondsOfDay=r,t}function p(e,r,t,n,i,a,o){var s=0|(r-14)/12,u=e+4800+s,h=(0|1461*u/4)+(0|367*(r-2-12*s)/12)-(0|3*((u+100)/100)/4)+t-32075;n-=12,0>n&&(n+=24);var c=a+(n*f.SECONDS_PER_HOUR+i*f.SECONDS_PER_MINUTE+o*f.SECONDS_PER_MILLISECOND);return c>=43200&&(h-=1),[h,c]}var y=new o,g=[31,28,31,30,31,30,31,31,30,31,30,31],v=29,q=new h,x=/^(\d{4})$/,E=/^(\d{4})-(\d{2})$/,b=/^(\d{4})-?(\d{3})$/,S=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,M=/^(\d{4})-?(\d{2})-?(\d{2})$/,_=/([Z+\-])?(\d{2})?:?(\d{2})?$/,O=/^(\d{2})(\.\d+)?/.source+_.source,P=/^(\d{2}):?(\d{2})(\.\d+)?/.source+_.source,T=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+_.source,C="Invalid ISO 8601 date.",R=function(e,r,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=t(e,0),r=t(r,0),n=t(n,c.UTC);var i=0|e;r+=(e-i)*f.SECONDS_PER_DAY,m(i,r,this),n===c.UTC&&d(this)};R.fromDate=function(e,r){if(!(e instanceof Date)||isNaN(e.getTime()))throw new a("date must be a valid JavaScript Date.");var t=p(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(r)?(m(t[0],t[1],r),d(r),r):new R(t[0],t[1],c.UTC)},R.fromIso8601=function(e,r){if("string"!=typeof e)throw new a(C);e=e.replace(",",".");var t,i,o,s=e.split("T"),h=1,f=1,l=0,w=0,y=0,q=0,_=s[0],N=s[1];if(!n(_))throw new a(C);var I;if(s=_.match(M),null!==s){if(I=_.split("-").length-1,I>0&&2!==I)throw new a(C);t=+s[1],h=+s[2],f=+s[3]}else if(s=_.match(E),null!==s)t=+s[1],h=+s[2];else if(s=_.match(x),null!==s)t=+s[1];else{var D;if(s=_.match(b),null!==s){if(t=+s[1],D=+s[2],o=u(t),1>D||o&&D>366||!o&&D>365)throw new a(C)}else{if(s=_.match(S),null===s)throw new a(C);t=+s[1];var z=+s[2],A=+s[3]||0;if(I=_.split("-").length-1,I>0&&(!n(s[3])&&1!==I||n(s[3])&&2!==I))throw new a(C);var U=new Date(Date.UTC(t,0,4));D=7*z+A-U.getUTCDay()-3}i=new Date(Date.UTC(t,0,1)),i.setUTCDate(D),h=i.getUTCMonth()+1,f=i.getUTCDate()}if(o=u(t),1>h||h>12||1>f||(2!==h||!o)&&f>g[h-1]||o&&2===h&&f>v)throw new a(C);var L;if(n(N)){if(s=N.match(T),null!==s){if(I=N.split(":").length-1,I>0&&2!==I&&3!==I)throw new a(C);l=+s[1],w=+s[2],y=+s[3],q=1e3*+(s[4]||0),L=5}else if(s=N.match(P),null!==s){if(I=N.split(":").length-1,I>0&&1!==I)throw new a(C);l=+s[1],w=+s[2],y=60*+(s[3]||0),L=4}else{if(s=N.match(O),null===s)throw new a(C);l=+s[1],w=60*+(s[2]||0),L=3}if(w>=60||y>=61||l>24||24===l&&(w>0||y>0||q>0))throw new a(C);var W=s[L],B=+s[L+1],F=+(s[L+2]||0);switch(W){case"+":l-=B,w-=F;break;case"-":l+=B,w+=F;break;case"Z":break;default:w+=new Date(Date.UTC(t,h-1,f,l,w)).getTimezoneOffset()}}else w+=new Date(Date.UTC(t,h-1,f)).getTimezoneOffset();var G=60===y;for(G&&y--;w>=60;)w-=60,l++;for(;l>=24;)l-=24,f++;for(i=o&&2===h?v:g[h-1];f>i;)f-=i,h++,h>12&&(h-=12,t++),i=o&&2===h?v:g[h-1];for(;0>w;)w+=60,l--;for(;0>l;)l+=24,f--;for(;1>f;)h--,1>h&&(h+=12,t--),i=o&&2===h?v:g[h-1],f+=i;var H=p(t,h,f,l,w,y,q);return n(r)?(m(H[0],H[1],r),d(r)):r=new R(H[0],H[1],c.UTC),G&&R.addSeconds(r,1,r),r},R.now=function(e){return R.fromDate(new Date,e)};var N=new R(0,0,c.TAI);return R.toGregorianDate=function(e,r){if(!n(e))throw new a("julianDate is required.");var t=!1,i=w(e,N);n(i)||(R.addSeconds(e,-1,N),i=w(N,N),t=!0);var s=i.dayNumber,u=i.secondsOfDay;u>=43200&&(s+=1);var h=0|s+68569,c=0|4*h/146097;h=0|h-(0|(146097*c+3)/4);var l=0|4e3*(h+1)/1461001;h=0|h-(0|1461*l/4)+31;var d=0|80*h/2447,m=0|h-(0|2447*d/80);h=0|d/11;var p=0|d+2-12*h,y=0|100*(c-49)+l+h,g=0|u/f.SECONDS_PER_HOUR,v=u-g*f.SECONDS_PER_HOUR,q=0|v/f.SECONDS_PER_MINUTE;v-=q*f.SECONDS_PER_MINUTE;var x=0|v,E=(v-x)/f.SECONDS_PER_MILLISECOND;return g+=12,g>23&&(g-=24),t&&(x+=1),n(r)?(r.year=y,r.month=p,r.day=m,r.hour=g,r.minute=q,r.second=x,r.millisecond=E,r.isLeapSecond=t,r):new o(y,p,m,g,q,x,E,t)},R.toDate=function(e){if(!n(e))throw new a("julianDate is required.");var r=R.toGregorianDate(e,y),t=r.second;return r.isLeapSecond&&(t-=1),new Date(Date.UTC(r.year,r.month-1,r.day,r.hour,r.minute,t,r.millisecond))},R.toIso8601=function(r,t){if(!n(r))throw new a("julianDate is required.");var i,o=R.toGregorianDate(r,o);return n(t)||0===o.millisecond?n(t)&&0!==t?(i=(.01*o.millisecond).toFixed(t).replace(".","").slice(0,t),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,i)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",o.year,o.month,o.day,o.hour,o.minute,o.second):(i=(.01*o.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,i))},R.clone=function(e,r){return n(e)?n(r)?(r.dayNumber=e.dayNumber,r.secondsOfDay=e.secondsOfDay,r):new R(e.dayNumber,e.secondsOfDay,c.TAI):void 0},R.compare=function(e,r){if(!n(e))throw new a("left is required.");if(!n(r))throw new a("right is required.");var t=e.dayNumber-r.dayNumber;return 0!==t?t:e.secondsOfDay-r.secondsOfDay},R.equals=function(e,r){return e===r||n(e)&&n(r)&&e.dayNumber===r.dayNumber&&e.secondsOfDay===r.secondsOfDay},R.equalsEpsilon=function(e,r,t){if(!n(t))throw new a("epsilon is required.");return e===r||n(e)&&n(r)&&Math.abs(R.getSecondsDifference(e,r))<=t},R.getTotalDays=function(e){if(!n(e))throw new a("julianDate is required.");return e.dayNumber+e.secondsOfDay/f.SECONDS_PER_DAY},R.getSecondsDifference=function(e,r){if(!n(e))throw new a("left is required.");if(!n(r))throw new a("right is required.");var t=(e.dayNumber-r.dayNumber)*f.SECONDS_PER_DAY;return t+(e.secondsOfDay-r.secondsOfDay)},R.getDaysDifference=function(e,r){if(!n(e))throw new a("left is required.");if(!n(r))throw new a("right is required.");var t=e.dayNumber-r.dayNumber,i=(e.secondsOfDay-r.secondsOfDay)/f.SECONDS_PER_DAY;return t+i},R.getTaiMinusUtc=function(e){q.julianDate=e;var t=R.leapSeconds,n=r(t,q,l);return 0>n&&(n=~n,--n,0>n&&(n=0)),t[n].offset},R.addSeconds=function(e,r,t){if(!n(e))throw new a("julianDate is required.");if(!n(r))throw new a("seconds is required.");if(!n(t))throw new a("result is required.");return m(e.dayNumber,e.secondsOfDay+r,t)},R.addMinutes=function(e,r,t){if(!n(e))throw new a("julianDate is required.");if(!n(r))throw new a("minutes is required.");if(!n(t))throw new a("result is required.");var i=e.secondsOfDay+r*f.SECONDS_PER_MINUTE;return m(e.dayNumber,i,t)},R.addHours=function(e,r,t){if(!n(e))throw new a("julianDate is required.");if(!n(r))throw new a("hours is required.");if(!n(t))throw new a("result is required.");var i=e.secondsOfDay+r*f.SECONDS_PER_HOUR;return m(e.dayNumber,i,t)},R.addDays=function(e,r,t){if(!n(e))throw new a("julianDate is required.");if(!n(r))throw new a("days is required.");if(!n(t))throw new a("result is required.");var i=e.dayNumber+r;return m(i,e.secondsOfDay,t)},R.lessThan=function(e,r){return R.compare(e,r)<0},R.lessThanOrEquals=function(e,r){return R.compare(e,r)<=0},R.greaterThan=function(e,r){return R.compare(e,r)>0},R.greaterThanOrEquals=function(e,r){return R.compare(e,r)>=0},R.prototype.clone=function(e){return R.clone(this,e)},R.prototype.equals=function(e){return R.equals(this,e)},R.prototype.equalsEpsilon=function(e,r){return R.equalsEpsilon(this,e,r)},R.leapSeconds=[new h(new R(2441317,43210,c.TAI),10),new h(new R(2441499,43211,c.TAI),11),new h(new R(2441683,43212,c.TAI),12),new h(new R(2442048,43213,c.TAI),13),new h(new R(2442413,43214,c.TAI),14),new h(new R(2442778,43215,c.TAI),15),new h(new R(2443144,43216,c.TAI),16),new h(new R(2443509,43217,c.TAI),17),new h(new R(2443874,43218,c.TAI),18),new h(new R(2444239,43219,c.TAI),19),new h(new R(2444786,43220,c.TAI),20),new h(new R(2445151,43221,c.TAI),21),new h(new R(2445516,43222,c.TAI),22),new h(new R(2446247,43223,c.TAI),23),new h(new R(2447161,43224,c.TAI),24),new h(new R(2447892,43225,c.TAI),25),new h(new R(2448257,43226,c.TAI),26),new h(new R(2448804,43227,c.TAI),27),new h(new R(2449169,43228,c.TAI),28),new h(new R(2449534,43229,c.TAI),29),new h(new R(2450083,43230,c.TAI),30),new h(new R(2450630,43231,c.TAI),31),new h(new R(2451179,43232,c.TAI),32),new h(new R(2453736,43233,c.TAI),33),new h(new R(2454832,43234,c.TAI),34),new h(new R(2456109,43235,c.TAI),35)],R}),define("Core/clone",["./defaultValue"],function(e){"use strict";var r=function(t,n){if(null===t||"object"!=typeof t)return t;n=e(n,!1);var i=new t.constructor;for(var a in t)if(t.hasOwnProperty(a)){var o=t[a];n&&(o=r(o,n)),i[a]=o}return i};return r}),define("Core/parseResponseHeaders",[],function(){"use strict";var e=function(e){var r={};if(!e)return r;for(var t=e.split("\r\n"),n=0;n<t.length;++n){var i=t[n],a=i.indexOf(": ");if(a>0){var o=i.substring(0,a),s=i.substring(a+2);r[o]=s}}return r};return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,r){"use strict";var t=function(e,t,n){this.statusCode=e,this.response=t,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=r(this.responseHeaders))};return t.prototype.toString=function(){var r="Request has failed.";return e(this.statusCode)&&(r+=" Status Code: "+this.statusCode),r},t}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent"],function(e,r,t,n,i){"use strict";function a(e,r){var t=decodeURIComponent(r);return e?atob(t):t}function o(e,r){for(var t=a(e,r),n=new ArrayBuffer(t.length),i=new Uint8Array(n),o=0;o<t.length;o++)i[o]=t.charCodeAt(o);return n}function s(e,t){t=r(t,"");var i=e[1],s=!!e[2],u=e[3];switch(t){case"":case"text":return a(s,u);case"arraybuffer":return o(s,u);case"blob":var h=o(s,u);return new Blob([h],{type:i});case"document":var f=new DOMParser;return f.parseFromString(a(s,u),i);case"json":return JSON.parse(a(s,u));default:throw new n("Unhandled responseType: "+t)}}var u=function(i){if(i=r(i,r.EMPTY_OBJECT),!t(i.url))throw new n("options.url is required.");var a=i.responseType,o=r(i.method,"GET"),s=i.data,h=i.headers,f=i.overrideMimeType;return e(i.url,function(r){var t=e.defer();return u.load(r,a,o,s,h,t,f),t.promise})},h=/^data:(.*?)(;base64)?,(.*)$/;return u.load=function(e,r,n,a,o,u,f){var c=h.exec(e);if(null!==c)return u.resolve(s(c,r)),void 0;var l=new XMLHttpRequest;if(t(f)&&l.overrideMimeType(f),l.open(n,e,!0),t(o))for(var d in o)o.hasOwnProperty(d)&&l.setRequestHeader(d,o[d]);t(r)&&(l.responseType=r),l.onload=function(){200===l.status?u.resolve(l.response):u.reject(new i(l.status,l.response,l.getAllResponseHeaders()))},l.onerror=function(){u.reject(new i)},l.send(a)},u.defaultLoad=u.load,u}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";var r=function(r,t){return e({url:r,headers:t})};return r}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,r,t,n){"use strict";var i={Accept:"application/json,*/*;q=0.01"},a=function(a,o){if(!r(a))throw new t("url is required.");return r(o)?r(o.Accept)||(o=e(o),o.Accept=i.Accept):o=i,n(a,o).then(function(e){return JSON.parse(e)})};return a}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,r,t,n,i,a,o,s,u,h,f,c){"use strict";function l(e,r){return o.compare(e.julianDate,r)}function d(e,t){if(!n(t.columnNames))return e._dataError="Error in loaded EOP data: The columnNames property is required.",void 0;if(!n(t.samples))return e._dataError="Error in loaded EOP data: The samples property is required.",void 0;var i=t.columnNames.indexOf("modifiedJulianDateUtc"),a=t.columnNames.indexOf("xPoleWanderRadians"),u=t.columnNames.indexOf("yPoleWanderRadians"),h=t.columnNames.indexOf("ut1MinusUtcSeconds"),d=t.columnNames.indexOf("xCelestialPoleOffsetRadians"),w=t.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=t.columnNames.indexOf("taiMinusUtcSeconds");if(0>i||0>a||0>u||0>h||0>d||0>w||0>m)return e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns",void 0;var p=e._samples=t.samples,y=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=a,e._yPoleWanderRadiansColumn=u,e._ut1MinusUtcSecondsColumn=h,e._xCelestialPoleOffsetRadiansColumn=d,e._yCelestialPoleOffsetRadiansColumn=w,e._taiMinusUtcSecondsColumn=m,e._columnCount=t.columnNames.length,e._lastIndex=void 0;for(var g,v=e._addNewLeapSeconds,q=0,x=p.length;x>q;q+=e._columnCount){var E=p[q+i],b=p[q+m],S=E+f.MODIFIED_JULIAN_DATE_DIFFERENCE,M=new o(S,b,c.TAI);if(y.push(M),v){if(b!==g&&n(g)){var _=o.leapSeconds,O=r(_,M,l);if(0>O){var P=new s(M,b);_.splice(~O,0,P)}}g=b}}}function w(e,r,t,n,i){var a=t*n;i.xPoleWander=r[a+e._xPoleWanderRadiansColumn],i.yPoleWander=r[a+e._yPoleWanderRadiansColumn],i.xPoleOffset=r[a+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=r[a+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=r[a+e._ut1MinusUtcSecondsColumn]}function m(e,r,t){return r+e*(t-r)}function p(e,r,t,n,i,a,s){var u=e._columnCount;if(a>r.length-1)return s.xPoleWander=0,s.yPoleWander=0,s.xPoleOffset=0,s.yPoleOffset=0,s.ut1MinusUtc=0,s;var h=r[i],f=r[a];if(h.equals(f)||n.equals(h))return w(e,t,i,u,s),s;if(n.equals(f))return w(e,t,a,u,s),s;var c=o.getSecondsDifference(n,h)/o.getSecondsDifference(f,h),l=i*u,d=a*u,p=t[l+e._ut1MinusUtcSecondsColumn],y=t[d+e._ut1MinusUtcSecondsColumn],g=y-p;if(g>.5||-.5>g){var v=t[l+e._taiMinusUtcSecondsColumn],q=t[d+e._taiMinusUtcSecondsColumn];v!==q&&(f.equals(n)?p=y:y-=q-v)}return s.xPoleWander=m(c,t[l+e._xPoleWanderRadiansColumn],t[d+e._xPoleWanderRadiansColumn]),s.yPoleWander=m(c,t[l+e._yPoleWanderRadiansColumn],t[d+e._yPoleWanderRadiansColumn]),s.xPoleOffset=m(c,t[l+e._xCelestialPoleOffsetRadiansColumn],t[d+e._xCelestialPoleOffsetRadiansColumn]),s.yPoleOffset=m(c,t[l+e._yCelestialPoleOffsetRadiansColumn],t[d+e._yCelestialPoleOffsetRadiansColumn]),s.ut1MinusUtc=m(c,p,y),s}var y=function(r){if(r=t(r,t.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=t(r.addNewLeapSeconds,!0),n(r.data))d(this,r.data);else if(n(r.url)){var i=this;this._downloadPromise=e(u(r.url),function(e){d(i,e)},function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+r.url+"."})}else d(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return y.NONE=a({getPromiseToLoad:function(){return e()},compute:function(e,r){return n(r)?(r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0):r=new i(0,0,0,0,0),r}}),y.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},y.prototype.compute=function(e,t){if(!n(this._samples)){if(n(this._dataError))throw new h(this._dataError);return void 0}if(n(t)||(t=new i(0,0,0,0,0)),0===this._samples.length)return t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0,t;var a=this._dates,s=this._lastIndex,u=0,f=0;if(n(s)){var c=a[s],l=a[s+1],d=o.lessThanOrEquals(c,e),w=!n(l),m=w||o.greaterThanOrEquals(l,e);if(d&&m)return u=s,!w&&l.equals(e)&&++u,f=u+1,p(this,a,this._samples,e,u,f,t),t}var y=r(a,e,o.compare,this._dateColumn);return y>=0?(y<a.length-1&&a[y+1].equals(e)&&++y,u=y,f=y):(f=~y,u=f-1,0>u&&(u=0)),this._lastIndex=u,p(this,a,this._samples,e,u,f,t),t},y}),define("ThirdParty/Uri",[],function(){function e(r){if(r instanceof e)this.scheme=r.scheme,this.authority=r.authority,this.path=r.path,this.query=r.query,this.fragment=r.fragment;else if(r){var t=n.exec(r);this.scheme=t[1],this.authority=t[2],this.path=t[3],this.query=t[4],this.fragment=t[5]}}function r(e){var r=unescape(e);return a.test(r)?r:e.toUpperCase()}function t(e,r,t,n){return(r||"")+t.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,t).replace(i,r)),this.path&&(this.path=this.path.replace(i,r)),this.query&&(this.query=this.query.replace(i,r)),this.fragment&&(this.fragment=this.fragment.replace(i,r))};var i=/%[0-9a-z]{2}/gi,a=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(r){var t=new e;return this.scheme?(t.scheme=this.scheme,t.authority=this.authority,t.path=this.path,t.query=this.query):(t.scheme=r.scheme,this.authority?(t.authority=this.authority,t.path=this.path,t.query=this.query):(t.authority=r.authority,""==this.path?(t.path=r.path,t.query=this.query||r.query):("/"==this.path.charAt(0)?(t.path=this.path,t.removeDotSegments()):(t.path=r.authority&&""==r.path?"/"+this.path:r.path.substring(0,r.path.lastIndexOf("/")+1)+this.path,t.removeDotSegments()),t.query=this.query))),t.fragment=this.fragment,t},e.prototype.removeDotSegments=function(){var e,r=this.path.split("/"),t=[],n=""==r[0];for(n&&r.shift(),""==r[0]?r.shift():null;r.length;)e=r.shift(),".."==e?t.pop():"."!=e&&t.push(e);("."==e||".."==e)&&t.push(""),n&&t.unshift(""),this.path=t.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,r,t,n){"use strict";function i(){for(var e=document.getElementsByTagName("script"),r=0,t=e.length;t>r;++r){var n=e[r].getAttribute("src"),i=c.exec(n);if(null!==i)return i[1]}return void 0}function a(){if(r(u))return u;var n;if(n="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:i(),!r(n))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return u=new e(n).resolve(new e(document.location.href))}function o(e){return n.toUrl("../"+e)}function s(r){return new e(r).resolve(a()).toString()}var u,h,f,c=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,l=function(e){r(h)||(h=r(n.toUrl)?o:s),r(f)||(f=document.createElement("a"));var t=h(e);return f.href=t,f.href=f.href,f.href};return l._cesiumScriptRegex=c,l}),define("Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,r,t){this.x=e,this.y=r,this.s=t};return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,r,t,n,i,a,o,s){"use strict";function u(e,r,t){var n=c;return n.dayNumber=r,n.secondsOfDay=t,a.getDaysDifference(n,e._sampleZeroDateTT)}function h(t,i){if(t._chunkDownloadsInProgress[i])return t._chunkDownloadsInProgress[i];var a=e.defer();t._chunkDownloadsInProgress[i]=a;var s,u=t._xysFileUrlTemplate;return s=n(u)?u.replace("{0}",i):r("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json"),e(o(s),function(e){t._chunkDownloadsInProgress[i]=!1;for(var r=t._samples,n=e.samples,o=3*i*t._samplesPerXysFile,s=0,u=n.length;u>s;++s)r[o+s]=n[s];a.resolve()}),a.promise}var f=function(e){e=t(e,t.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=t(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=t(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new a(this._sampleZeroJulianEphemerisDate,0,s.TAI),this._stepSizeDays=t(e.stepSizeDays,1),this._samplesPerXysFile=t(e.samplesPerXysFile,1e3),this._totalSamples=t(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var r=this._interpolationOrder,n=this._denominators=new Array(r+1),i=this._xTable=new Array(r+1),o=Math.pow(this._stepSizeDays,r),u=0;r>=u;++u){n[u]=o,i[u]=u*this._stepSizeDays;for(var h=0;r>=h;++h)h!==u&&(n[u]*=u-h);n[u]=1/n[u]}this._work=new Array(r+1),this._coef=new Array(r+1)},c=new a(0,0,s.TAI);return f.prototype.preload=function(r,t,n,i){var a=u(this,r,t),o=u(this,n,i),s=0|a/this._stepSizeDays-this._interpolationOrder/2;0>s&&(s=0);var f=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;f>=this._totalSamples&&(f=this._totalSamples-1);for(var c=0|s/this._samplesPerXysFile,l=0|f/this._samplesPerXysFile,d=[],w=c;l>=w;++w)d.push(h(this,w));return e.all(d)},f.prototype.computeXysRadians=function(e,r,t){var a=u(this,e,r);if(0>a)return void 0;var o=0|a/this._stepSizeDays;if(o>=this._totalSamples)return void 0;var s=this._interpolationOrder,f=o-(0|s/2);0>f&&(f=0);var c=f+s;c>=this._totalSamples&&(c=this._totalSamples-1,f=c-s,0>f&&(f=0));var l=!1,d=this._samples;if(n(d[3*f])||(h(this,0|f/this._samplesPerXysFile),l=!0),n(d[3*c])||(h(this,0|c/this._samplesPerXysFile),l=!0),l)return void 0;n(t)?(t.x=0,t.y=0,t.s=0):t=new i(0,0,0);var w,m,p=a-f*this._stepSizeDays,y=this._work,g=this._denominators,v=this._coef,q=this._xTable;for(w=0;s>=w;++w)y[w]=p-q[w];for(w=0;s>=w;++w){for(v[w]=1,m=0;s>=m;++m)m!==w&&(v[w]*=y[m]);v[w]*=g[w];var x=3*(f+w);t.x+=v[w]*d[x++],t.y+=v[w]*d[x++],t.s+=v[w]*d[x]}return t},f}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./TimeConstants"],function(e,r,t,n,i,a,o,s,u,h,f,c,l,d,w,m,p){"use strict";var y={},g=new t,v=new t,q=new t;y.eastNorthUpToFixedFrame=function(e,r,n){if(!a(e))throw new o("origin is required.");if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var s=d.sign(e.z);return a(n)?(n[0]=0,n[1]=1,n[2]=0,n[3]=0,n[4]=-s,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=s,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(0,-s,0,e.x,1,0,0,e.y,0,0,s,e.z,0,0,0,1)}var u=g,f=v,c=q;return r=i(r,h.WGS84),r.geodeticSurfaceNormal(e,u),f.x=-e.y,f.y=e.x,f.z=0,t.normalize(f,f),t.cross(u,f,c),a(n)?(n[0]=f.x,n[1]=f.y,n[2]=f.z,n[3]=0,n[4]=c.x,n[5]=c.y,n[6]=c.z,n[7]=0,n[8]=u.x,n[9]=u.y,n[10]=u.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(f.x,c.x,u.x,e.x,f.y,c.y,u.y,e.y,f.z,c.z,u.z,e.z,0,0,0,1)};var x=new t,E=new t,b=new t;y.northEastDownToFixedFrame=function(e,r,n){if(!a(e))throw new o("origin is required.");if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var s=d.sign(e.z);return a(n)?(n[0]=-s,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=1,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=-s,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(-s,0,0,e.x,0,1,0,e.y,0,0,-s,e.z,0,0,0,1)}var u=x,f=E,c=b;return r=i(r,h.WGS84),r.geodeticSurfaceNormal(e,u),f.x=-e.y,f.y=e.x,f.z=0,t.normalize(f,f),t.cross(u,f,c),a(n)?(n[0]=c.x,n[1]=c.y,n[2]=c.z,n[3]=0,n[4]=f.x,n[5]=f.y,n[6]=f.z,n[7]=0,n[8]=-u.x,n[9]=-u.y,n[10]=-u.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(c.x,f.x,-u.x,e.x,c.y,f.y,-u.y,e.y,c.z,f.z,-u.z,e.z,0,0,0,1)};var S=24110.54841,M=8640184.812866,_=.093104,O=-62e-7,P=1.1772758384668e-19,T=72921158553e-15,C=d.TWO_PI/86400,R=new l;y.computeTemeToPseudoFixedMatrix=function(e,r){if(!a(e))throw new o("date is required.");R=l.addSeconds(e,-l.getTaiMinusUtc(e),R);var t,n=R.dayNumber,i=R.secondsOfDay,s=n-2451545;t=i>=43200?(s+.5)/p.DAYS_PER_JULIAN_CENTURY:(s-.5)/p.DAYS_PER_JULIAN_CENTURY;var u=S+t*(M+t*(_+t*O)),h=u*C%d.TWO_PI,f=T+P*(n-2451545.5),c=(i+.5*p.SECONDS_PER_DAY)%p.SECONDS_PER_DAY,m=h+f*c,y=Math.cos(m),g=Math.sin(m);return a(r)?(r[0]=y,r[1]=-g,r[2]=0,r[3]=g,r[4]=y,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new w(y,g,0,-g,y,0,0,0,1)},y.iau2006XysData=new f,y.earthOrientationParameters=s.NONE;var N=32.184,I=2451545;y.preloadIcrfFixed=function(r){var t=r.start.dayNumber,n=r.start.secondsOfDay+N,i=r.stop.dayNumber,a=r.stop.secondsOfDay+N,o=y.iau2006XysData.preload(t,n,i,a),s=y.earthOrientationParameters.getPromiseToLoad();return e.all([o,s])},y.computeIcrfToFixedMatrix=function(e,r){if(!a(e))throw new o("date is required.");var t=y.computeFixedToIcrfMatrix(e,r);return a(t)?w.transpose(t,r):void 0};var D=new c(0,0,0),z=new u(0,0,0,0,0,0),A=new w,U=new w;y.computeFixedToIcrfMatrix=function(e,r){if(!a(e))throw new o("date is required.");var t=y.earthOrientationParameters.compute(e,z);if(!a(t))return void 0;var n=e.dayNumber,i=e.secondsOfDay+N,s=y.iau2006XysData.computeXysRadians(n,i,D);if(!a(s))return void 0;var u=s.x+t.xPoleOffset,h=s.y+t.yPoleOffset,f=1/(1+Math.sqrt(1-u*u-h*h)),c=A;c[0]=1-f*u*u,c[3]=-f*u*h,c[6]=u,c[1]=-f*u*h,c[4]=1-f*h*h,c[7]=h,c[2]=-u,c[5]=-h,c[8]=1-f*(u*u+h*h);var m=w.fromRotationZ(-s.s,U),g=w.multiply(c,m,A),v=e.dayNumber,q=e.secondsOfDay-l.getTaiMinusUtc(e)+t.ut1MinusUtc,x=v-2451545,E=q/p.SECONDS_PER_DAY,b=.779057273264+E+.00273781191135448*(x+E);b=b%1*d.TWO_PI;var S=w.fromRotationZ(b,U),M=w.multiply(g,S,A),_=Math.cos(t.xPoleWander),O=Math.cos(t.yPoleWander),P=Math.sin(t.xPoleWander),T=Math.sin(t.yPoleWander),C=n-I+i/p.SECONDS_PER_DAY;C/=36525;var R=-47e-6*C*d.RADIANS_PER_DEGREE/3600,L=Math.cos(R),W=Math.sin(R),B=U;return B[0]=_*L,B[1]=_*W,B[2]=P,B[3]=-O*W+T*P*L,B[4]=O*L+T*P*W,B[5]=-T*_,B[6]=-T*W-O*P*L,B[7]=T*L-O*P*W,B[8]=O*_,w.multiply(M,B,r)};var L=new n;return y.pointToWindowCoordinates=function(e,t,i,s){if(!a(e))throw new o("modelViewProjectionMatrix is required.");if(!a(t))throw new o("viewportTransformation is required.");if(!a(i))throw new o("point is required.");a(s)||(s=new r);var u=L;return m.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,u),u),n.multiplyByScalar(u,1/u.w,u),m.multiplyByVector(t,u,u),r.fromCartesian4(u,s)},y}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix4","./Plane","./Ray","./Transforms"],function(e,r,t,n,i,a,o,s,u,h,f,c,l){"use strict";var d=function(e,r){if(!i(e))throw new o("origin is required.");if(r=n(r,s.WGS84),e=r.scaleToGeodeticSurface(e),!i(e))throw new o("origin must not be at the center of the ellipsoid.");var a=l.eastNorthUpToFixedFrame(e,r);this._ellipsoid=r,this._origin=e,this._xAxis=t.fromCartesian4(h.getColumn(a,0)),this._yAxis=t.fromCartesian4(h.getColumn(a,1));var u=t.fromCartesian4(h.getColumn(a,2));this._plane=f.fromPointNormal(e,u)};a(d.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}}});var w=new e;d.fromPoints=function(r,t){if(!i(r))throw new o("cartesians is required.");var n=e.fromPoints(r,w);return new d(n.center,t)};var m=new c,p=new t;d.prototype.projectPointOntoPlane=function(e,n){if(!i(e))throw new o("cartesian is required.");var a=m;a.origin=e,t.normalize(e,a.direction);var s=u.rayPlane(a,this._plane,p);if(i(s)||(t.negate(a.direction,a.direction),s=u.rayPlane(a,this._plane,p)),i(s)){var h=t.subtract(s,this._origin,s),f=t.dot(this._xAxis,h),c=t.dot(this._yAxis,h);return i(n)?(n.x=f,n.y=c,n):new r(f,c)}return void 0},d.prototype.projectPointsOntoPlane=function(e,r){if(!i(e))throw new o("cartesians is required.");i(r)||(r=[]);for(var t=0,n=e.length,a=0;n>a;a++){var s=this.projectPointOntoPlane(e[a],r[t]);i(s)&&(r[t]=s,t++)}return r.length=t,r};var y=new t;return d.prototype.projectPointsOntoEllipsoid=function(e,r){if(!i(e))throw new o("cartesians is required.");var n=e.length;i(r)?r.length=n:r=new Array(n);for(var a=this._ellipsoid,s=this._origin,u=this._xAxis,h=this._yAxis,f=y,c=0;n>c;++c){var l=e[c];t.multiplyByScalar(u,l.x,f),i(r[c])||(r[c]=new t);var d=t.add(s,f,r[c]);t.multiplyByScalar(h,l.y,f),t.add(d,f,d),a.scaleToGeocentricSurface(d,d)}return r},d}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=new r,a=new r,o=new r,s=function(s,u,h,f,c){if(!(t(s)&&t(u)&&t(h)&&t(f)))throw new n("point, p0, p1, and p2 are required.");t(c)||(c=new r);var l,d,w,m,p,y,g,v;t(u.z)?(l=r.subtract(h,u,i),d=r.subtract(f,u,a),w=r.subtract(s,u,o),m=r.dot(l,l),p=r.dot(l,d),y=r.dot(l,w),g=r.dot(d,d),v=r.dot(d,w)):(l=e.subtract(h,u,i),d=e.subtract(f,u,a),w=e.subtract(s,u,o),m=e.dot(l,l),p=e.dot(l,d),y=e.dot(l,w),g=e.dot(d,d),v=e.dot(d,w));
var q=1/(m*g-p*p);return c.y=(g*y-p*v)*q,c.z=(m*v-p*y)*q,c.x=1-c.y-c.z,c};return s}),define("Core/pointInsideTriangle",["./barycentricCoordinates","./Cartesian3"],function(e,r){"use strict";var t=new r,n=function(r,n,i,a){return e(r,n,i,a,t),t.x>0&&t.y>0&&t.z>0};return n}),define("Core/Queue",[],function(){"use strict";var e=function(){this._array=[],this._offset=0,this.length=0};return e.prototype.enqueue=function(e){this._array.push(e),this.length++},e.prototype.dequeue=function(){if(0===this.length)return void 0;var e=this._array,r=this._offset,t=e[r];return e[r]=void 0,r++,r>10&&2*r>e.length&&(this._array=e.slice(r),r=0),this._offset=r,this.length--,t},e.prototype.contains=function(e){return-1!==this._array.indexOf(e)},e.prototype.clear=function(){this._array.length=this._offset=this.length=0},e.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},e}),define("Core/WindingOrder",[],function(){"use strict";var e={CLOCKWISE:2304,COUNTER_CLOCKWISE:2305,validate:function(r){return r===e.CLOCKWISE||r===e.COUNTER_CLOCKWISE}};return e}),define("Core/PolygonPipeline",["./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./Math","./pointInsideTriangle","./PrimitiveType","./Queue","./WindingOrder"],function(e,r,t,n,i,a,o,s,u,h,f,c,l,d,w){"use strict";function m(r,t,n){var i=e.subtract(t,r,L),a=e.subtract(n,t,W);return i.x*a.y-i.y*a.x>=0}function p(e){for(var r=e[0].x,t=0,n=0;n<e.length;n++)e[n].x>r&&(r=e[n].x,t=n);return t}function y(e){for(var r=e[0][0].x,t=0,n=0;n<e.length;n++){var i=e[n][p(e[n])].x;i>r&&(r=i,t=n)}return t}function g(e){for(var r=[],t=0;t<e.length;t++){var n=e[(t-1+e.length)%e.length],i=e[t],a=e[(t+1)%e.length];m(n,i,a)||r.push(i)}return r}function v(r,t){for(var n=0;n<r.length;n++)if(e.equals(t,r[n]))return n;return-1}function q(t,i,a){a=n(a,[]);var o=Number.MAX_VALUE,s=p(i),u=new e(i[s].x,t.y);a.push(s),a.push((s+1)%i.length);for(var h=i[0].x,f=h,c=1;c<i.length;++c)i[c].x<h?h=i[c].x:i[c].x>f&&(f=i[c].x);f+=f-h;var l=new r(f,t.y,0);for(c=0;c<i.length;c++){var d=i[c],w=i[(c+1)%i.length];if((d.x>=t.x||w.x>=t.x)&&(d.y>=t.y&&w.y<=t.y||d.y<=t.y&&w.y>=t.y)){var m=(w.y-d.y)*(l.x-t.x)-(w.x-d.x)*(l.y-t.y);if(0!==m){m=1/m;var y=((w.x-d.x)*(t.y-d.y)-(w.y-d.y)*(t.x-d.x))*m,g=((l.x-t.x)*(t.y-d.y)-(l.y-t.y)*(t.x-d.x))*m;if(y>=0&&1>=y&&g>=0&&1>=g){var v=new e(t.x+y*(l.x-t.x),t.y+y*(l.y-t.y)),q=e.subtract(v,t,B);m=e.magnitudeSquared(q),o>m&&(u=v,o=m,a[0]=c,a[1]=(c+1)%i.length)}}}}return u}function x(r,t){var n=y(t),i=t[n],a=p(i),o=i[a],s=[],u=q(o,r,s),h=v(r,u);if(-1!==h)return h;var l=e.magnitudeSquared(e.subtract(r[s[0]],o,F)),d=e.magnitudeSquared(e.subtract(r[s[1]],o,F)),w=d>l?r[s[0]]:r[s[1]],m=g(r),x=m.indexOf(w);-1!==x&&m.splice(x,1);for(var E=[],b=0;b<m.length;b++){var S=m[b];c(S,o,u,w)&&E.push(S)}var M=Number.MAX_VALUE;if(E.length>0){var _=e.fromElements(1,0,F);for(b=0;b<E.length;b++){var O=e.subtract(E[b],o,G),P=e.magnitude(_)*e.magnitudeSquared(O);if(0!==P){var T=Math.abs(f.acosClamped(e.dot(_,O)/P));M>T&&(M=T,w=E[b])}}}return r.indexOf(w)}function E(e,t,n){for(var i=sr.computeWindingOrder2D(e),a=0;a<t.length;a++){var o=t[a];r.equals(o[0],o[o.length-1])||o.push(o[0]);var u=sr.computeWindingOrder2D(o);u===i&&o.reverse()}var h=s.fromPoints(e,n),f=h.projectPointsOntoPlane(e),c=[];for(a=0;a<t.length;a++)c.push(h.projectPointsOntoPlane(t[a]));var l=x(f,c),d=y(c),w=p(c[d]),m=t[d],g=[];for(a=0;a<e.length;a++)g.push(e[a]);var v,q=[];if(0!==w)for(v=0;v<=m.length;v++){var E=(v+w)%m.length;0!==E&&q.push(m[E])}else for(v=0;v<m.length;v++)q.push(m[(v+w)%m.length]);var b=g.lastIndexOf(e[l]);q.push(e[b]);var S=g.slice(0,b+1),M=g.slice(b+1);return g=S.concat(q,M),t.splice(d,1),g}function b(e){var r="0."+Math.sin(H).toString().substr(5);H+=.2;var t=Math.floor(r*e);return t===e&&t--,t}function S(r,t,n){return M(r,t,n)&&M(t,r,n)&&!D(n[r].position,n[t].position,n)&&!e.equals(n[r].position,n[t].position)}function M(r,t,n){P(r,n);var i=n[r],a=n[t],o=O(r,n,V),s=O(r,n,Y),u=e.subtract(n[o].position,i.position,j),h=e.subtract(n[s].position,i.position,k),f=e.subtract(a.position,i.position,X);return T(u,f)?_(u,f):T(h,f)?_(h,f):C(u,h)?I(u,h,f)?!0:!1:R(u,h)?N(u,h,f)?!1:!0:void 0}function _(r,t){return e.magnitude(t)<e.magnitude(r)}function O(e,r,t){var n=e+t;return 0>n&&(n=r.length-1),n===r.length&&(n=0),P(n,r),n}function P(r,t){var n=r-1,i=r+1;0>n&&(n=t.length-1),i===t.length&&(i=0);var o=e.subtract(t[n].position,t[r].position,Z),s=e.subtract(t[i].position,t[r].position,J);if(T(o,s)){var u=new a("Superfluous vertex found.");throw u.vertexIndex=r,u}}function T(e,t){return 0===r.cross(e,t,K).z}function C(e,t){return r.cross(e,t,$).z<0}function R(e,t){return r.cross(e,t,Q).z>0}function N(e,t,n){return r.cross(e,n,er).z>0&&r.cross(n,t,er).z>0}function I(e,t,n){return r.cross(e,n,rr).z<0&&r.cross(n,t,rr).z<0}function D(r,t,n){for(var i=0;i<n.length;i++){var a,o=n[i].position;if(a=i<n.length-1?n[i+1].position:n[0].position,!(e.equals(r,o)||e.equals(t,a)||e.equals(r,a)||e.equals(t,o))){var s=(t.y-r.y)/(t.x-r.x),u=(a.y-o.y)/(a.x-o.x);if(!(s===u||isNaN(s)&&isNaN(u))){var h;h=isNaN(s)?r.x:isNaN(u)?o.x:(r.y-o.y-s*r.x+u*o.x)/(u-s);var f=s*h+r.y-s*r.x,c=e.fromElements(h,f,tr);if(!(e.equals(c,r)||e.equals(c,t)||e.equals(c,o)||e.equals(c,a))){var l=A(h,r.x,t.x)&&A(f,r.y,t.y)&&A(h,o.x,a.x)&&A(f,o.y,a.y);if(l)return!0}}}}return!1}function z(r){var t=r[0].position,n=r[1].position,i=r[2].position,a=e.subtract(n,t,nr),o=e.subtract(i,t,ir);return T(a,o)}function A(e,r,t){return(e>r||e>t)&&(r>e||t>e)||r===t&&r===e}function U(e){var r=e.length;if(3===r)return z(e)?[]:[e[0].index,e[1].index,e[2].index];if(e.length<3)throw new a("Invalid polygon: must have at least three vertices.");for(var t=!1,n=0;!t;){var i=10*e.length;if(n>i)return[];n++;for(var o=b(e.length),s=o+1;Math.abs(o-s)<2||Math.abs(o-s)>e.length-2;)s=b(e.length);if(o>s){var u=o;o=s,s=u}try{if(S(o,s,e)){var h=e.splice(o,s-o+1,e[o],e[s]);return U(e).concat(U(h))}}catch(f){if(f.hasOwnProperty("vertexIndex"))return e.splice(f.vertexIndex,1),U(e);throw f}}}var L=new e,W=new e,B=new e,F=new e(1,0),G=new e,H=0,V=-1,Y=1,j=new r,k=new r,X=new r,Z=new r,J=new r,K=new r,$=new r,Q=new r,er=new r,rr=new r,tr=new e,nr=new r,ir=new r,ar=new r,or=new r,sr={};return sr.removeDuplicates=function(e){if(!i(e))throw new a("positions is required.");if(e.length<3)throw new a("At least three positions are required.");for(var t=e.length,n=[],o=t-1,s=0;t>s;o=s++){var u=e[o],h=e[s];r.equals(u,h)||n.push(h)}return n},sr.computeArea2D=function(e){if(!i(e))throw new a("positions is required.");if(e.length<3)throw new a("At least three positions are required.");for(var r=e.length,t=0,n=r-1,o=0;r>o;n=o++){var s=e[n],u=e[o];t+=s.x*u.y-u.x*s.y}return.5*t},sr.computeWindingOrder2D=function(e){var r=sr.computeArea2D(e);return r>0?w.COUNTER_CLOCKWISE:w.CLOCKWISE},sr.triangulate=function(e){if(!i(e))throw new a("positions is required.");if(e.length<3)throw new a("At least three positions are required.");for(var r=e.length,t=[],n=0;r>n;++n)t[n]={position:e[n],index:n};return U(t)},sr.resetSeed=function(e){H=n(e,0)},sr.computeSubdivision=function(e,o,s){if(s=n(s,f.RADIANS_PER_DEGREE),!i(e))throw new a("positions is required.");if(!i(o))throw new a("indices is required.");if(o.length<3)throw new a("At least three indices are required.");if(0!==o.length%3)throw new a("The number of indices must be divisable by three.");if(0>=s)throw new a("granularity must be greater than zero.");for(var c=new d,w=o.length,m=0;w>m;m+=3)c.enqueue({i0:o[m],i1:o[m+1],i2:o[m+2]});for(var p,y=e.slice(0),g=[],v={};c.length>0;){var q,x,E=c.dequeue(),b=y[E.i0],S=y[E.i1],M=y[E.i2],_=r.angleBetween(b,S),O=r.angleBetween(S,M),P=r.angleBetween(M,b),T=Math.max(_,Math.max(O,P));T>s?_===T?(q=Math.min(E.i0,E.i1).toString()+" "+Math.max(E.i0,E.i1).toString(),p=v[q],p||(x=r.add(b,S,new r),r.multiplyByScalar(x,.5,x),y.push(x),p=y.length-1,v[q]=p),c.enqueue({i0:E.i0,i1:p,i2:E.i2}),c.enqueue({i0:p,i1:E.i1,i2:E.i2})):O===T?(q=Math.min(E.i1,E.i2).toString()+" "+Math.max(E.i1,E.i2).toString(),p=v[q],p||(x=r.add(S,M,new r),r.multiplyByScalar(x,.5,x),y.push(x),p=y.length-1,v[q]=p),c.enqueue({i0:E.i1,i1:p,i2:E.i0}),c.enqueue({i0:p,i1:E.i2,i2:E.i0})):P===T&&(q=Math.min(E.i2,E.i0).toString()+" "+Math.max(E.i2,E.i0).toString(),p=v[q],p||(x=r.add(M,b,new r),r.multiplyByScalar(x,.5,x),y.push(x),p=y.length-1,v[q]=p),c.enqueue({i0:E.i2,i1:p,i2:E.i1}),c.enqueue({i0:p,i1:E.i0,i2:E.i1})):(g.push(E.i0),g.push(E.i1),g.push(E.i2))}var C=y.length,R=new Array(3*C),N=0;for(p=0;C>p;p++){var I=y[p];R[N++]=I.x,R[N++]=I.y,R[N++]=I.z}return new u({attributes:{position:new h({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:R})},indices:g,primitiveType:l.TRIANGLES})},sr.scaleToGeodeticHeight=function(e,t,a,s){a=n(a,o.WGS84);var u=ar,h=or;if(t=n(t,0),s=n(s,!0),i(e)&&i(e.attributes)&&i(e.attributes.position))for(var f=e.attributes.position.values,c=f.length,l=0;c>l;l+=3)r.fromArray(f,l,h),s&&(h=a.scaleToGeodeticSurface(h,h)),u=a.geodeticSurfaceNormal(h,u),r.multiplyByScalar(u,t,u),r.add(h,u,h),f[l]=h.x,f[l+1]=h.y,f[l+2]=h.z;return e},sr.eliminateHoles=function(e,t,s){if(!i(e))throw new a("outerRing is required.");if(0===e.length)throw new a("outerRing must not be empty.");if(!i(t))throw new a("innerRings is required.");s=n(s,o.WGS84);for(var u=[],h=0;h<t.length;h++){for(var f=[],c=0;c<t[h].length;c++)f.push(r.clone(t[h][c]));u.push(f)}for(var l=e;u.length>0;)l=E(l,u,s);return l},sr}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,r,t,n,i,a,o,s){"use strict";function u(e){var r=e._uSquared,t=e._ellipsoid.maximumRadius,n=e._ellipsoid.minimumRadius,i=(t-n)/t,a=Math.cos(e._startHeading),o=Math.sin(e._startHeading),s=(1-i)*Math.tan(e._start.latitude),u=1/Math.sqrt(1+s*s),h=u*s,f=Math.atan2(s,a),c=u*o,l=c*c,d=1-l,w=Math.sqrt(d),m=r/4,p=m*m,y=p*m,g=p*p,v=1+m-3*p/4+5*y/4-175*g/64,q=1-m+15*p/8-35*y/8,x=1-3*m+35*p/4,E=1-5*m,b=v*f-q*Math.sin(2*f)*m/2-x*Math.sin(4*f)*p/16-E*Math.sin(6*f)*y/48-5*Math.sin(8*f)*g/512,S=e._constants;S.a=t,S.b=n,S.f=i,S.cosineHeading=a,S.sineHeading=o,S.tanU=s,S.cosineU=u,S.sineU=h,S.sigma=f,S.sineAlpha=c,S.sineSquaredAlpha=l,S.cosineSquaredAlpha=d,S.cosineAlpha=w,S.u2Over4=m,S.u4Over16=p,S.u6Over64=y,S.u8Over256=g,S.a0=v,S.a1=q,S.a2=x,S.a3=E,S.distanceRatio=b}function h(e,r){return e*r*(4+e*(4-3*r))/16}function f(e,r,t,n,i,a,o){var s=h(e,t);return(1-s)*e*r*(n+s*i*(o+s*a*(2*o*o-1)))}function c(e,r,t,n,i,a,o){var u,h,c,l,d,w=(r-t)/r,m=a-n,p=Math.atan((1-w)*Math.tan(i)),y=Math.atan((1-w)*Math.tan(o)),g=Math.cos(p),v=Math.sin(p),q=Math.cos(y),x=Math.sin(y),E=g*q,b=g*x,S=v*x,M=v*q,_=m,O=s.TWO_PI,P=Math.cos(_),T=Math.sin(_);do{P=Math.cos(_),T=Math.sin(_);var C=b-M*P;c=Math.sqrt(q*q*T*T+C*C),h=S+E*P,u=Math.atan2(c,h);var R;0===c?(R=0,l=1):(R=E*T/c,l=1-R*R),O=_,d=h-2*S/l,isNaN(d)&&(d=0),_=m+f(w,R,l,u,c,h,d)}while(Math.abs(_-O)>s.EPSILON12);var N=l*(r*r-t*t)/(t*t),I=1+N*(4096+N*(N*(320-175*N)-768))/16384,D=N*(256+N*(N*(74-47*N)-128))/1024,z=d*d,A=D*c*(d+D*(h*(2*z-1)-D*d*(4*c*c-3)*(4*z-3)/6)/4),U=t*I*(u-A),L=Math.atan2(q*T,b-M*P),W=Math.atan2(g*T,b*P-M);e._distance=U,e._startHeading=L,e._endHeading=W,e._uSquared=N}function l(t,n,i,o){var s=e.normalize(o.cartographicToCartesian(n,w),d),h=e.normalize(o.cartographicToCartesian(i,w),w);if(Math.abs(Math.abs(e.angleBetween(s,h))-Math.PI)<.0125)throw new a("geodesic position is not unique");c(t,o.maximumRadius,o.minimumRadius,n.longitude,n.latitude,i.longitude,i.latitude),n.height=0,i.height=0,t._start=r.clone(n,t._start),t._end=r.clone(i,t._end),u(t)}var d=new e,w=new e,m=function(e,i,a){var s=t(a,o.WGS84);this._ellipsoid=s,this._start=new r,this._end=new r,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,n(e)&&n(i)&&l(this,e,i,s)};return i(m.prototype,{surfaceDistance:{get:function(){if(!n(this._distance))throw new a("set end positions before getting surfaceDistance");return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){if(!n(this._distance))throw new a("set end positions before getting startHeading");return this._startHeading}},endHeading:{get:function(){if(!n(this._distance))throw new a("set end positions before getting endHeading");return this._endHeading}}}),m.prototype.setEndPoints=function(e,r){if(!n(e))throw new a("start cartographic position is required");if(!n(r))throw new a("end cartgraphic position is required");l(this,e,r,this._ellipsoid)},m.prototype.interpolateUsingFraction=function(e,r){return this.interpolateUsingSurfaceDistance(this._distance*e,r)},m.prototype.interpolateUsingSurfaceDistance=function(e,t){if(!n(this._distance))throw new a("start and end must be set before calling funciton interpolateUsingSurfaceDistance");var i=this._constants,o=i.distanceRatio+e/i.b,s=Math.cos(2*o),u=Math.cos(4*o),h=Math.cos(6*o),c=Math.sin(2*o),l=Math.sin(4*o),d=Math.sin(6*o),w=Math.sin(8*o),m=o*o,p=o*m,y=i.u8Over256,g=i.u2Over4,v=i.u6Over64,q=i.u4Over16,x=2*p*y*s/3+o*(1-g+7*q/4-15*v/4+579*y/64-(q-15*v/4+187*y/16)*s-(5*v/4-115*y/16)*u-29*y*h/16)+(g/2-q+71*v/32-85*y/16)*c+(5*q/16-5*v/4+383*y/96)*l-m*((v-11*y/2)*c+5*y*l/2)+(29*v/96-29*y/16)*d+539*y*w/1536,E=Math.asin(Math.sin(x)*i.cosineAlpha),b=Math.atan(i.a/i.b*Math.tan(E));x-=i.sigma;var S=Math.cos(2*i.sigma+x),M=Math.sin(x),_=Math.cos(x),O=i.cosineU*_,P=i.sineU*M,T=Math.atan2(M*i.sineHeading,O-P*i.cosineHeading),C=T-f(i.f,i.sineAlpha,i.cosineSquaredAlpha,x,M,_,S);return n(t)?(t.longitude=this._start.longitude+C,t.latitude=b,t.height=0,t):new r(this._start.longitude+C,b,0)},m}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,r,t,n,i,a,o,s,u,h,f,c){"use strict";function l(r,t,n,i){var a=i.scaleToGeodeticSurface(r,_),o=i.scaleToGeodeticSurface(t,O),s=e.angleBetween(a,o),u=Math.ceil(s/n),h=new Array(3*u),f=i.cartesianToCartographic(a,b),c=i.cartesianToCartographic(o,S);P.setEndPoints(f,c);var l=P.surfaceDistance/u,d=0;f.height=0;var w=i.cartographicToCartesian(f,M);h[d++]=w.x,h[d++]=w.y,h[d++]=w.z;for(var m=1;u>m;m++){var p=P.interpolateUsingSurfaceDistance(m*l,S);w=i.cartographicToCartesian(p,M),h[d++]=w.x,h[d++]=w.y,h[d++]=w.z}return h}function d(r,t,n){var i=T;return n.geodeticSurfaceNormal(r,i),e.multiplyByScalar(i,t,i),e.add(r,i,r),r}var w={},m=new f,p=new e,y=new e,g=new c(e.ZERO,0),v=new e,q=new c(e.ZERO,0),x=new e,E=new e,b=new r,S=new r,M=new e,_=new e,O=new e,P=new o,T=new e,C=new e;return w.wrapLongitude=function(r,i){var a=[],o=[];if(n(r)&&r.length>0){i=t(i,f.IDENTITY);var u=f.inverseTransformation(i,m),h=f.multiplyByPoint(u,e.ZERO,p),l=f.multiplyByPointAsVector(u,e.UNIT_Y,y),d=c.fromPointNormal(h,l,g),w=f.multiplyByPointAsVector(u,e.UNIT_X,v),b=c.fromPointNormal(h,w,q),S=1;a.push(e.clone(r[0]));for(var M=a[0],_=r.length,O=1;_>O;++O){var P=r[O];if(c.getPointDistance(b,M)<0||c.getPointDistance(b,P)<0){var T=s.lineSegmentPlane(M,P,d,x);if(n(T)){var C=e.multiplyByScalar(l,5e-9,E);c.getPointDistance(d,M)<0&&e.negate(C,C),a.push(e.add(T,C,new e)),o.push(S+1),e.negate(C,C),a.push(e.add(T,C,new e)),S=1}}a.push(e.clone(r[O])),S++,M=P}o.push(S)}return{positions:a,lengths:o}},w.removeDuplicates=function(r){if(!n(r))throw new i("positions is required.");var t=r.length;if(2>t)return r.slice(0);var a=[];a.push(r[0]);for(var o=1;t>o;++o){var s=r[o-1],u=r[o];e.equals(s,u)||a.push(u)}return a},w.scaleToSurface=function(e,r,o){if(!n(e))throw new i("positions is required");r=t(r,h.RADIANS_PER_DEGREE),o=t(o,a.WGS84);for(var s=e.length,u=[],f=0;s-1>f;f++){var c=e[f],d=e[f+1];u=u.concat(l(c,d,r,o))}var w=e[s-1],m=o.cartesianToCartographic(w,b);m.height=0;var p=o.cartographicToCartesian(m,M);return u.push(p.x,p.y,p.z),u},w.scaleToGeodeticHeight=function(r,o,s,h){if(!n(r))throw new i("positions must be defined.");if(!n(o))throw new i("height must be defined");s=t(s,a.WGS84);var f,c,l=r.length,w=C;if(n(h)){if(h.length!==r.length)throw new i("result.length must be equal to positions.length");c=h}else c=new Array(r.length);if(0===o){for(f=0;l>f;f+=3)w=s.scaleToGeodeticSurface(e.fromArray(r,f,w),w),c[f]=w.x,c[f+1]=w.y,c[f+2]=w.z;return c}var m;if(u(o)){if(o.length!==l/3)throw new i("height.length must be equal to positions.length");for(f=0;l>f;f+=3)m=o[f/3],w=e.fromArray(r,f,w),w=d(w,m,s),c[f]=w.x,c[f+1]=w.y,c[f+2]=w.z}else for(m=o,f=0;l>f;f+=3)w=e.fromArray(r,f,w),w=d(w,m,s),c[f]=w.x,c[f+1]=w.y,c[f+2]=w.z;return c},w}),define("Core/WallGeometryLibrary",["./Cartesian3","./Cartographic","./defined","./DeveloperError","./EllipsoidTangentPlane","./Math","./PolygonPipeline","./PolylinePipeline","./WindingOrder"],function(e,r,t,n,i,a,o,s,u){"use strict";function h(r,t,n,i,a){var o,s=e.angleBetween(r,t),u=Math.ceil(s/a),h=new Array(u);if(n===i){for(o=0;u>o;o++)h[o]=n;return h}var f=i-n,c=f/u;for(o=1;u>o;o++){var l=n+o*c;h[o]=l}return h[0]=n,h}function f(e,r){return a.equalsEpsilon(e.latitude,r.latitude,a.EPSILON14)&&a.equalsEpsilon(e.longitude,r.longitude,a.EPSILON14)}function c(e,n,i,a){var o=t(a),s=t(i),u=[],h=[],c=o?[]:void 0,l=n.length;if(2>l)return{positions:n};var m=n[0];u.push(m);var p=e.cartesianToCartographic(m,d);s&&(p.height=i[0]),h.push(p.height),o&&c.push(a[0]);for(var y=1;l>y;++y){var g=n[y],v=e.cartesianToCartographic(g,w);s&&(v.height=i[y]),f(p,v)?p.height<v.height&&(h[h.length-1]=v.height):(u.push(g),h.push(v.height),o&&c.push(a[y])),r.clone(v,p)}return{positions:u,topHeights:h,bottomHeights:c}}var l={},d=new r,w=new r;return l.computePositions=function(e,r,a,f,l,d){var w=c(e,r,a,f);if(r=w.positions,a=w.topHeights,f=w.bottomHeights,r.length<2)throw new n("unique positions must be greater than or equal to 2");var m=t(f);if(r.length>=3){var p=i.fromPoints(r,e),y=p.projectPointsOntoPlane(r);o.computeWindingOrder2D(y)===u.CLOCKWISE&&(r.reverse(),a.reverse(),m&&f.reverse())}var g,v=r.length,q=[],x=m?[]:void 0,E=[];for(g=0;v-1>g;g++){var b=r[g],S=r[g+1],M=a[g],_=a[g+1];q=q.concat(h(b,S,M,_,l)),d&&q.push(_),m&&(b=r[g],S=r[g+1],M=f[g],_=f[g+1],x=x.concat(h(b,S,M,_,l)),d&&x.push(_)),d&&(E=E.concat(s.scaleToSurface([b,S],l,e)))}d||(E=s.scaleToSurface(r,l,e),q.push(a[v-1]),m&&x.push(f[v-1]));var O=m?s.scaleToGeodeticHeight(E,x,e):E.slice(0),P=s.scaleToGeodeticHeight(E,q,e);return{newWallPositions:E,bottomPositions:O,topPositions:P}},l}),define("Core/WallOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./WallGeometryLibrary"],function(e,r,t,n,i,a,o,s,u,h,f,c,l,d){"use strict";var w=new r,m=new r,p=function(e){e=n(e,n.EMPTY_OBJECT);var r=e.positions,t=e.maximumHeights,s=e.minimumHeights;if(!i(r))throw new a("options.positions is required.");if(i(t)&&t.length!==r.length)throw new a("options.positions and options.maximumHeights must have the same length.");if(i(s)&&s.length!==r.length)throw new a("options.positions and options.minimumHeights must have the same length.");var u=n(e.granularity,c.RADIANS_PER_DEGREE),h=n(e.ellipsoid,o.WGS84);this._positions=r,this._minimumHeights=s,this._maximumHeights=t,this._granularity=u,this._ellipsoid=h,this._workerName="createWallOutlineGeometry"};return p.fromConstantHeights=function(e){e=n(e,n.EMPTY_OBJECT);var r=e.positions;if(!i(r))throw new a("options.positions is required.");var t,o,s=e.minimumHeight,u=e.maximumHeight,h=i(s),f=i(u);if(h||f){var c=r.length;t=h?new Array(c):void 0,o=f?new Array(c):void 0;for(var l=0;c>l;++l)h&&(t[l]=s),f&&(o[l]=u)}var d={positions:r,maximumHeights:o,minimumHeights:t,ellipsoid:e.ellipsoid};return new p(d)},p.createGeometry=function(n){var i=n._positions,a=n._minimumHeights,o=n._maximumHeights,p=n._granularity,y=n._ellipsoid,g=d.computePositions(y,i,o,a,p,!1),v=g.newWallPositions,q=g.bottomPositions,x=g.topPositions,E=v.length,b=2*E,S=new Float64Array(b),M=0;E/=3;var _;for(_=0;E>_;++_){var O=3*_,P=r.fromArray(x,O,w),T=r.fromArray(q,O,m);S[M++]=T.x,S[M++]=T.y,S[M++]=T.z,S[M++]=P.x,S[M++]=P.y,S[M++]=P.z}var C=new h({position:new u({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:S})}),R=b/3;b=2*R-4+R;var N=f.createTypedArray(R,b),I=0;for(_=0;R-2>_;_+=2){var D=_,z=_+2,A=r.fromArray(S,3*D,w),U=r.fromArray(S,3*z,m);if(!r.equalsEpsilon(A,U,c.EPSILON6)){var L=_+1,W=_+3;N[I++]=L,N[I++]=D,N[I++]=L,N[I++]=W,N[I++]=D,N[I++]=z}}return N[I++]=R-2,N[I++]=R-1,new s({attributes:C,indices:N,primitiveType:l.LINES,boundingSphere:new e.fromVertices(S)})},p}),define("Workers/createWallOutlineGeometry",["../Core/Ellipsoid","../Core/WallOutlineGeometry"],function(e,r){"use strict";function t(t){return t._ellipsoid=e.clone(t._ellipsoid),r.createGeometry(t)}return t})}();