/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2014 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},i.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},i.lerp=function(e,t,r){return(1-r)*e+r*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=.5*3*Math.PI,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!r(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!r(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!r(e))throw new n("angle is required.");var t=i.TWO_PI,a=e-Math.floor(e/t)*t;return a<-Math.PI?a+t:a>=Math.PI?a-t:a},i.negativePiToPi=function(e){if(!r(e))throw new n("x is required.");for(var t=i.EPSILON10,a=i.PI,o=i.TWO_PI;-(a+t)>e;)e+=o;if(-a>e)return-a;for(;e>a+t;)e-=o;return e>a?a:e},i.zeroToTwoPi=function(e){if(!r(e))throw new n("x is required.");var t=e%i.TWO_PI;return 0>t?(t+i.TWO_PI)%i.TWO_PI:t},i.equalsEpsilon=function(e,i,a){if(!r(e))throw new n("left is required.");if(!r(i))throw new n("right is required.");return a=t(a,0),Math.abs(e-i)<=a};var a=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var t=a.length;if(e>=t)for(var r=a[t-1],i=t;e>=i;i++)a.push(r*i);return a[e]},i.incrementWrap=function(e,i,a){if(a=t(a,0),!r(e))throw new n("n is required.");if(a>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=a),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,t,i){if(!r(e))throw new n("value is required");if(!r(t))throw new n("min is required.");if(!r(i))throw new n("max is required.");return t>e?t:e>i?i:e};var o=new e;return i.setRandomNumberSeed=function(t){if(!r(t))throw new n("seed is required.");o=new e(t)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){return Math.asin(i.clamp(e,-1,1))},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i){"use strict";var a=function(t,r,n){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0)};a.fromSpherical=function(n,i){if(!t(n))throw new r("spherical is required");t(i)||(i=new a);var o=n.clock,s=n.cone,u=e(n.magnitude,1),h=u*Math.sin(s);return i.x=h*Math.cos(o),i.y=h*Math.sin(o),i.z=u*Math.cos(s),i},a.fromElements=function(e,r,n,i){return t(i)?(i.x=e,i.y=r,i.z=n,i):new a(e,r,n)},a.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(n,i,a){if(!t(n))throw new r("value is required");if(!t(i))throw new r("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a]=n.z},a.unpack=function(n,i,o){if(!t(n))throw new r("array is required");return i=e(i,0),t(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i],o},a.fromArray=a.unpack,a.getMaximumComponent=function(e){if(!t(e))throw new r("cartesian is required");return Math.max(e.x,e.y,e.z)},a.getMinimumComponent=function(e){if(!t(e))throw new r("cartesian is required");return Math.min(e.x,e.y,e.z)},a.getMinimumByComponent=function(e,n,i){if(!t(e))throw new r("first is required.");if(!t(n))throw new r("second is required.");if(!t(i))throw new r("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},a.getMaximumByComponent=function(e,n,i){if(!t(e))throw new r("first is required.");if(!t(n))throw new r("second is required.");if(!t(i))throw new r("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},a.magnitudeSquared=function(e){if(!t(e))throw new r("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!t(e)||!t(n))throw new r("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.normalize=function(e,n){if(!t(e))throw new r("cartesian is required");if(!t(n))throw new r("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},a.dot=function(e,n){if(!t(e))throw new r("left is required");if(!t(n))throw new r("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},a.multiplyComponents=function(e,n,i){if(!t(e))throw new r("left is required");if(!t(n))throw new r("right is required");if(!t(i))throw new r("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},a.add=function(e,n,i){if(!t(e))throw new r("left is required");if(!t(n))throw new r("right is required");if(!t(i))throw new r("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},a.subtract=function(e,n,i){if(!t(e))throw new r("left is required");if(!t(n))throw new r("right is required");if(!t(i))throw new r("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},a.multiplyByScalar=function(e,n,i){if(!t(e))throw new r("cartesian is required");if("number"!=typeof n)throw new r("scalar is required and must be a number.");if(!t(i))throw new r("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},a.divideByScalar=function(e,n,i){if(!t(e))throw new r("cartesian is required");if("number"!=typeof n)throw new r("scalar is required and must be a number.");if(!t(i))throw new r("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},a.negate=function(e,n){if(!t(e))throw new r("cartesian is required");if(!t(n))throw new r("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},a.abs=function(e,n){if(!t(e))throw new r("cartesian is required");if(!t(n))throw new r("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var s=new a;a.lerp=function(e,n,i,o){if(!t(e))throw new r("start is required.");if(!t(n))throw new r("end is required.");if("number"!=typeof i)throw new r("t is required and must be a number.");if(!t(o))throw new r("result is required.");return a.multiplyByScalar(n,i,s),o=a.multiplyByScalar(e,1-i,o),a.add(s,o,o)};var u=new a,h=new a;a.angleBetween=function(e,n){if(!t(e))throw new r("left is required");if(!t(n))throw new r("right is required");a.normalize(e,u),a.normalize(n,h);var i=a.dot(u,h),o=a.magnitude(a.cross(u,h,u));return Math.atan2(o,i)};var f=new a;a.mostOrthogonalAxis=function(e,n){if(!t(e))throw new r("cartesian is required.");if(!t(n))throw new r("result is required.");var i=a.normalize(e,f);return a.abs(i,i),n=i.x<=i.y?i.x<=i.z?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Z,n):i.y<=i.z?a.clone(a.UNIT_Y,n):a.clone(a.UNIT_Z,n)},a.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new r("epsilon is required and must be a number.");return e===n||t(e)&&t(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i},a.cross=function(e,n,i){if(!t(e))throw new r("left is required");if(!t(n))throw new r("right is required");if(!t(i))throw new r("result is required");var a=e.x,o=e.y,s=e.z,u=n.x,h=n.y,f=n.z,c=o*f-s*h,l=s*u-a*f,d=a*h-o*u;return i.x=c,i.y=l,i.z=d,i},a.fromDegrees=function(e,n,o,s,u){if(!t(e))throw new r("longitude is required");if(!t(n))throw new r("latitude is required");var h=i.toRadians(e),f=i.toRadians(n);return a.fromRadians(h,f,o,s,u)};var c=new a,l=new a,d=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,i,o,s,u){if(!t(n))throw new r("longitude is required");if(!t(i))throw new r("latitude is required");o=e(o,0);var h=t(s)?s.radiiSquared:d,f=Math.cos(i);c.x=f*Math.cos(n),c.y=f*Math.sin(n),c.z=Math.sin(i),c=a.normalize(c,c),a.multiplyComponents(h,c,l);var w=Math.sqrt(a.dot(c,l));return l=a.divideByScalar(l,w,l),c=a.multiplyByScalar(c,o,c),t(u)||(u=new a),a.add(l,c,u)},a.fromDegreesArray=function(e,n,o){if(!t(e))throw new r("positions is required.");for(var s=new Array(e.length),u=0;u<e.length;u++)s[u]=i.toRadians(e[u]);return a.fromRadiansArray(s,n,o)},a.fromRadiansArray=function(e,n,i){if(!t(e))throw new r("positions is required.");if(e.length<2)throw new r("positions length cannot be less than 2.");if(0!==e.length%2)throw new r("positions length must be a multiple of 2.");var o=e.length;t(i)?i.length=o/2:i=new Array(o/2);for(var s=0;o>s;s+=2){var u=e[s],h=e[s+1];i[s/2]=a.fromRadians(u,h,0,n,i[s/2])}return i},a.fromDegreesArrayHeights=function(e,n,o){if(!t(e))throw new r("positions is required.");if(e.length<3)throw new r("positions length cannot be less than 3.");if(0!==e.length%3)throw new r("positions length must be a multiple of 3.");for(var s=new Array(e.length),u=0;u<e.length;u+=3)s[u]=i.toRadians(e[u]),s[u+1]=i.toRadians(e[u+1]),s[u+2]=e[u+2];return a.fromRadiansArrayHeights(s,n,o)},a.fromRadiansArrayHeights=function(e,n,i){if(!t(e))throw new r("positions is required.");if(e.length<3)throw new r("positions length cannot be less than 3.");if(0!==e.length%3)throw new r("positions length must be a multiple of 3.");var o=e.length;t(i)?i.length=o/3:i=new Array(o/3);for(var s=0;o>s;s+=3){var u=e[s],h=e[s+1],f=e[s+2];i[s/3]=a.fromRadians(u,h,f,n,i[s/3])}return i},a.ZERO=n(new a(0,0,0)),a.UNIT_X=n(new a(1,0,0)),a.UNIT_Y=n(new a(0,1,0)),a.UNIT_Z=n(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t){return a.equalsEpsilon(this,e,t)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i){"use strict";var a=function(t,r,n){this.longitude=e(t,0),this.latitude=e(r,0),this.height=e(n,0)};return a.fromRadians=function(n,i,o,s){if(!t(n))throw new r("longitude is required.");if(!t(i))throw new r("latitude is required.");return o=e(o,0),t(s)?(s.longitude=n,s.latitude=i,s.height=o,s):new a(n,i,o)},a.fromDegrees=function(e,n,o,s){if(!t(e))throw new r("longitude is required.");if(!t(n))throw new r("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),a.fromRadians(e,n,o,s)},a.clone=function(e,r){return t(e)?t(r)?(r.longitude=e.longitude,r.latitude=e.latitude,r.height=e.height,r):new a(e.longitude,e.latitude,e.height):void 0},a.equals=function(e,r){return e===r||t(e)&&t(r)&&e.longitude===r.longitude&&e.latitude===r.latitude&&e.height===r.height},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new r("epsilon is required and must be a number.");return e===n||t(e)&&t(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},a.toString=function(e){if(!t(e))throw new r("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},a.ZERO=n(new a(0,0,0)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t){return a.equalsEpsilon(this,e,t)},a.prototype.toString=function(){return a.toString(this)},a}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a,o,s){"use strict";var u=function(t,n,i){if(t=r(t,0),n=r(n,0),i=r(i,0),0>t||0>n||0>i)throw new a("All radii components must be greater than or equal to zero.");this._radii=new e(t,n,i),this._radiiSquared=new e(t*t,n*n,i*i),this._radiiToTheFourth=new e(t*t*t*t,n*n*n*n,i*i*i*i),this._oneOverRadii=new e(0===t?0:1/t,0===n?0:1/n,0===i?0:1/i),this._oneOverRadiiSquared=new e(0===t?0:1/(t*t),0===n?0:1/(n*n),0===i?0:1/(i*i)),this._minimumRadius=Math.min(t,n,i),this._maximumRadius=Math.max(t,n,i),this._centerToleranceSquared=s.EPSILON1};i(u.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),u.clone=function(t,r){if(!n(t))return void 0;var i=t._radii;return n(r)?(e.clone(i,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new u(i.x,i.y,i.z)},u.fromCartesian3=function(e){return n(e)?new u(e.x,e.y,e.z):new u},u.WGS84=o(new u(6378137,6378137,6356752.314245179)),u.UNIT_SPHERE=o(new u(1,1,1)),u.MOON=o(new u(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.geocentricSurfaceNormal=e.normalize,u.prototype.geodeticSurfaceNormalCartographic=function(t,r){if(!n(t))throw new a("cartographic is required.");var i=t.longitude,o=t.latitude,s=Math.cos(o),u=s*Math.cos(i),h=s*Math.sin(i),f=Math.sin(o);return n(r)||(r=new e),r.x=u,r.y=h,r.z=f,e.normalize(r,r)},u.prototype.geodeticSurfaceNormal=function(t,r){return n(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var h=new e,f=new e;u.prototype.cartographicToCartesian=function(t,r){var i=h,a=f;this.geodeticSurfaceNormalCartographic(t,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,t.height,i),n(r)||(r=new e),e.add(a,i,r)},u.prototype.cartographicArrayToCartesianArray=function(e,t){if(!n(e))throw new a("cartographics is required.");var r=e.length;n(t)?t.length=r:t=new Array(r);for(var i=0;r>i;i++)t[i]=this.cartographicToCartesian(e[i],t[i]);return t};var c=new e,l=new e,d=new e;u.prototype.cartesianToCartographic=function(r,i){var a=this.scaleToGeodeticSurface(r,l);if(!n(a))return void 0;var o=this.geodeticSurfaceNormal(a,c),u=e.subtract(r,a,d),h=Math.atan2(o.y,o.x),f=Math.asin(o.z),w=s.sign(e.dot(u,r))*e.magnitude(u);return n(i)?(i.longitude=h,i.latitude=f,i.height=w,i):new t(h,f,w)},u.prototype.cartesianArrayToCartographicArray=function(e,t){if(!n(e))throw new a("cartesians is required.");var r=e.length;n(t)?t.length=r:t=new Array(r);for(var i=0;r>i;++i)t[i]=this.cartesianToCartographic(e[i],t[i]);return t};var w=new e,m=new e;return u.prototype.scaleToGeodeticSurface=function(t,r){if(!n(t))throw new a("cartesian is required.");var i=t.x,o=t.y,u=t.z,h=this._oneOverRadii,f=h.x,c=h.y,l=h.z,d=i*i*f*f,p=o*o*c*c,y=u*u*l*l,v=d+p+y,g=Math.sqrt(1/v),q=e.multiplyByScalar(t,g,w);if(v<this._centerToleranceSquared)return isFinite(g)?e.clone(q,r):void 0;var x=this._oneOverRadiiSquared,E=x.x,b=x.y,S=x.z,M=m;M.x=2*q.x*E,M.y=2*q.y*b,M.z=2*q.z*S;var _,O,P,T,C,N,R,I,A,D,z,U=(1-g)*e.magnitude(t)/(.5*e.magnitude(M)),L=0;do{U-=L,P=1/(1+U*E),T=1/(1+U*b),C=1/(1+U*S),N=P*P,R=T*T,I=C*C,A=N*P,D=R*T,z=I*C,_=d*N+p*R+y*I-1,O=d*A*E+p*D*b+y*z*S;var W=-2*O;L=_/W}while(Math.abs(_)>s.EPSILON12);return n(r)?(r.x=i*P,r.y=o*T,r.z=u*C,r):new e(i*P,o*T,u*C)},u.prototype.scaleToGeocentricSurface=function(t,r){if(!n(t))throw new a("cartesian is required.");n(r)||(r=new e);var i=t.x,o=t.y,s=t.z,u=this._oneOverRadiiSquared,h=1/Math.sqrt(i*i*u.x+o*o*u.y+s*s*u.z);return e.multiplyByScalar(t,h,r)},u.prototype.transformPositionToScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},u.prototype.transformPositionFromScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},u.prototype.equals=function(t){return this===t||n(t)&&e.equals(this._radii,t._radii)},u.prototype.toString=function(){return this._radii.toString()},u}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,i,a,o){"use strict";var s=function(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(t,r){var i=this._semimajorAxis,a=t.longitude*i,o=t.latitude*i,s=t.height;return n(r)?(r.x=a,r.y=o,r.z=s,r):new e(a,o,s)},s.prototype.unproject=function(e,r){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,s=e.y*i,u=e.z;return n(r)?(r.longitude=o,r.latitude=s,r.height=u,r):new t(o,s,u)},s}),define("Core/Intersect",[],function(){"use strict";var e={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,r){this.start=e(t,0),this.stop=e(r,0)};return t}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var i=function(t,r,n,i){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0),this.w=e(i,0)};i.fromElements=function(e,r,n,a,o){return t(o)?(o.x=e,o.y=r,o.z=n,o.w=a,o):new i(e,r,n,a)},i.fromColor=function(e,n){if(!t(e))throw new r("color is required");return t(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(n,i,a){if(!t(n))throw new r("value is required");if(!t(i))throw new r("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a++]=n.z,i[a]=n.w},i.unpack=function(n,a,o){if(!t(n))throw new r("array is required");return a=e(a,0),t(o)||(o=new i),o.x=n[a++],o.y=n[a++],o.z=n[a++],o.w=n[a],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){if(!t(e))throw new r("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},i.getMinimumComponent=function(e){if(!t(e))throw new r("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},i.getMinimumByComponent=function(e,n,i){if(!t(e))throw new r("first is required.");if(!t(n))throw new r("second is required.");if(!t(i))throw new r("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},i.getMaximumByComponent=function(e,n,i){if(!t(e))throw new r("first is required.");if(!t(n))throw new r("second is required.");if(!t(i))throw new r("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},i.magnitudeSquared=function(e){if(!t(e))throw new r("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,n){if(!t(e)||!t(n))throw new r("left and right are required.");return i.subtract(e,n,a),i.magnitude(a)},i.normalize=function(e,n){if(!t(e))throw new r("cartesian is required");if(!t(n))throw new r("result is required");var a=i.magnitude(e);return n.x=e.x/a,n.y=e.y/a,n.z=e.z/a,n.w=e.w/a,n},i.dot=function(e,n){if(!t(e))throw new r("left is required");if(!t(n))throw new r("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},i.multiplyComponents=function(e,n,i){if(!t(e))throw new r("left is required");if(!t(n))throw new r("right is required");if(!t(i))throw new r("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},i.add=function(e,n,i){if(!t(e))throw new r("left is required");if(!t(n))throw new r("right is required");if(!t(i))throw new r("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},i.subtract=function(e,n,i){if(!t(e))throw new r("left is required");if(!t(n))throw new r("right is required");if(!t(i))throw new r("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},i.multiplyByScalar=function(e,n,i){if(!t(e))throw new r("cartesian is required");if("number"!=typeof n)throw new r("scalar is required and must be a number.");if(!t(i))throw new r("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},i.divideByScalar=function(e,n,i){if(!t(e))throw new r("cartesian is required");if("number"!=typeof n)throw new r("scalar is required and must be a number.");if(!t(i))throw new r("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},i.negate=function(e,n){if(!t(e))throw new r("cartesian is required");if(!t(n))throw new r("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},i.abs=function(e,n){if(!t(e))throw new r("cartesian is required");if(!t(n))throw new r("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var o=new i;i.lerp=function(e,n,a,s){if(!t(e))throw new r("start is required.");if(!t(n))throw new r("end is required.");if("number"!=typeof a)throw new r("t is required and must be a number.");if(!t(s))throw new r("result is required.");return i.multiplyByScalar(n,a,o),s=i.multiplyByScalar(e,1-a,s),i.add(o,s,s)};var s=new i;return i.mostOrthogonalAxis=function(e,n){if(!t(e))throw new r("cartesian is required.");if(!t(n))throw new r("result is required.");var a=i.normalize(e,s);return i.abs(a,a),n=a.x<=a.y?a.x<=a.z?a.x<=a.w?i.clone(i.UNIT_X,n):i.clone(i.UNIT_W,n):a.z<=a.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n):a.y<=a.z?a.y<=a.w?i.clone(i.UNIT_Y,n):i.clone(i.UNIT_W,n):a.z<=a.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},i.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new r("epsilon is required and must be a number.");return e===n||t(e)&&t(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i&&Math.abs(e.w-n.w)<=i},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function s(e){for(var t=0,r=0;3>r;++r){var n=e[h.getElementIndex(d[r],l[r])];t+=2*n*n}return Math.sqrt(t)}function u(e,t){for(var r=a.EPSILON15,n=0,i=1,o=0;3>o;++o){var s=Math.abs(e[h.getElementIndex(d[o],l[o])]);s>n&&(i=o,n=s)}var u=1,f=0,c=l[i],w=d[i];if(Math.abs(e[h.getElementIndex(w,c)])>r){var m,p=e[h.getElementIndex(w,w)],y=e[h.getElementIndex(c,c)],v=e[h.getElementIndex(w,c)],g=(p-y)/2/v;m=0>g?-1/(-g+Math.sqrt(1+g*g)):1/(g+Math.sqrt(1+g*g)),u=1/Math.sqrt(1+m*m),f=m*u}return t=h.clone(h.IDENTITY,t),t[h.getElementIndex(c,c)]=t[h.getElementIndex(w,w)]=u,t[h.getElementIndex(w,c)]=f,t[h.getElementIndex(c,w)]=-f,t}var h=function(e,r,n,i,a,o,s,u,h){this[0]=t(e,0),this[1]=t(i,0),this[2]=t(s,0),this[3]=t(r,0),this[4]=t(a,0),this[5]=t(u,0),this[6]=t(n,0),this[7]=t(o,0),this[8]=t(h,0)};h.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new h(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},h.fromArray=function(e,i,a){if(!r(e))throw new n("array is required");return i=t(i,0),r(a)||(a=new h),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a[9]=e[i+9],a},h.fromColumnMajorArray=function(e,t){if(!r(e))throw new n("values parameter is required");return h.clone(e,t)},h.fromRowMajorArray=function(e,t){if(!r(e))throw new n("values is required.");return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new h(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},h.fromQuaternion=function(e,t){if(!r(e))throw new n("quaternion is required");var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,s=e.x*e.w,u=e.y*e.y,f=e.y*e.z,c=e.y*e.w,l=e.z*e.z,d=e.z*e.w,w=e.w*e.w,m=i-u-l+w,p=2*(a-d),y=2*(o+c),v=2*(a+d),g=-i+u-l+w,q=2*(f-s),x=2*(o-c),E=2*(f+s),b=-i-u+l+w;return r(t)?(t[0]=m,t[1]=v,t[2]=x,t[3]=p,t[4]=g,t[5]=E,t[6]=y,t[7]=q,t[8]=b,t):new h(m,p,y,v,g,q,x,E,b)},h.fromScale=function(e,t){if(!r(e))throw new n("scale is required.");return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new h(e.x,0,0,0,e.y,0,0,0,e.z)},h.fromUniformScale=function(e,t){if("number"!=typeof e)throw new n("scale is required.");return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new h(e,0,0,0,e,0,0,0,e)},h.fromRotationX=function(e,t){if(!r(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=i,t[5]=a,t[6]=0,t[7]=-a,t[8]=i,t):new h(1,0,0,0,i,-a,0,a,i)},h.fromRotationY=function(e,t){if(!r(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=i,t[1]=0,t[2]=-a,t[3]=0,t[4]=1,t[5]=0,t[6]=a,t[7]=0,t[8]=i,t):new h(i,0,a,0,1,0,-a,0,i)},h.fromRotationZ=function(e,t){if(!r(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=i,t[1]=a,t[2]=0,t[3]=-a,t[4]=i,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new h(i,-a,0,a,i,0,0,0,1)},h.toArray=function(e,t){if(!r(e))throw new n("matrix is required");return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},h.getElementIndex=function(e,t){if("number"!=typeof t||0>t||t>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+t},h.getColumn=function(t,i,a){if(!r(t))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var o=3*i,s=t[o],u=t[o+1],h=t[o+2];return r(a)?(a.x=s,a.y=u,a.z=h,a):new e(s,u,h)},h.setColumn=function(e,t,i,a){if(!r(e))throw new n("matrix is required");if(!r(i))throw new n("cartesian is required");if("number"!=typeof t||0>t||t>2)throw new n("index must be 0, 1, or 2.");a=h.clone(e,a);var o=3*t;return a[o]=i.x,a[o+1]=i.y,a[o+2]=i.z,a},h.getRow=function(t,i,a){if(!r(t))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var o=t[i],s=t[i+3],u=t[i+6];return r(a)?(a.x=o,a.y=s,a.z=u,a):new e(o,s,u)},h.setRow=function(e,t,i,a){if(!r(e))throw new n("matrix is required");if(!r(i))throw new n("cartesian is required");if("number"!=typeof t||0>t||t>2)throw new n("index must be 0, 1, or 2.");return a=h.clone(e,a),a[t]=i.x,a[t+3]=i.y,a[t+6]=i.z,a};var f=new e;h.getScale=function(t,i){if(!r(t))throw new n("matrix is required.");return r(i)||(i=new e),i.x=e.magnitude(e.fromElements(t[0],t[1],t[2],f)),i.y=e.magnitude(e.fromElements(t[3],t[4],t[5],f)),i.z=e.magnitude(e.fromElements(t[6],t[7],t[8],f)),i};var c=new e;h.getMaximumScale=function(t){return h.getScale(t,c),e.getMaximumComponent(c)},h.multiply=function(e,t,i){if(!r(e))throw new n("left is required");if(!r(t))throw new n("right is required");var a=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],o=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],s=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],u=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],f=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],c=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],l=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],d=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],w=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r(i)?(i[0]=a,i[1]=o,i[2]=s,i[3]=u,i[4]=f,i[5]=c,i[6]=l,i[7]=d,i[8]=w,i):new h(a,u,l,o,f,d,s,c,w)},h.multiplyByVector=function(t,i,a){if(!r(t))throw new n("matrix is required");if(!r(i))throw new n("cartesian is required");var o=i.x,s=i.y,u=i.z,h=t[0]*o+t[3]*s+t[6]*u,f=t[1]*o+t[4]*s+t[7]*u,c=t[2]*o+t[5]*s+t[8]*u;return r(a)?(a.x=h,a.y=f,a.z=c,a):new e(h,f,c)},h.multiplyByScalar=function(e,t,i){if(!r(e))throw new n("matrix is required");if("number"!=typeof t)throw new n("scalar must be a number");return r(i)?(i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i[4]=e[4]*t,i[5]=e[5]*t,i[6]=e[6]*t,i[7]=e[7]*t,i[8]=e[8]*t,i):new h(e[0]*t,e[3]*t,e[6]*t,e[1]*t,e[4]*t,e[7]*t,e[2]*t,e[5]*t,e[8]*t)},h.negate=function(e,t){if(!r(e))throw new n("matrix is required");return r(t)?(t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t):new h(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},h.transpose=function(e,t){if(!r(e))throw new n("matrix is required");var i=e[0],a=e[3],o=e[6],s=e[1],u=e[4],f=e[7],c=e[2],l=e[5],d=e[8];return r(t)?(t[0]=i,t[1]=a,t[2]=o,t[3]=s,t[4]=u,t[5]=f,t[6]=c,t[7]=l,t[8]=d,t):new h(i,s,c,a,u,l,o,f,d)};var l=[1,0,0],d=[2,2,1],w=new h,m=new h;return h.getEigenDecomposition=function(e,t){if(!r(e))throw new n("matrix is required.");var i=a.EPSILON20,f=10,c=0,l=0;
r(t)||(t={});for(var d=t.unitary=h.clone(h.IDENTITY,t.unitary),p=t.diagonal=h.clone(e,t.diagonal),y=i*o(p);f>l&&s(p)>y;)u(p,w),h.transpose(w,m),h.multiply(p,w,p),h.multiply(m,p,p),h.multiply(d,w,d),++c>2&&(++l,c=0);return t},h.abs=function(e,t){if(!r(e))throw new n("matrix is required");return r(t)?(t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t):new h(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},h.determinant=function(e){if(!r(e))throw new n("matrix is required");var t=e[0],i=e[3],a=e[6],o=e[1],s=e[4],u=e[7],h=e[2],f=e[5],c=e[8];return t*(s*c-f*u)+o*(f*a-i*c)+h*(i*u-s*a)},h.inverse=function(e,t){if(!r(e))throw new n("matrix is required");var i=e[0],o=e[1],s=e[2],u=e[3],f=e[4],c=e[5],l=e[6],d=e[7],w=e[8],m=h.determinant(e);if(Math.abs(m)<=a.EPSILON15)throw new n("matrix is not invertible");r(t)||(t=new h),t[0]=f*w-d*c,t[1]=d*s-o*w,t[2]=o*c-f*s,t[3]=l*c-u*w,t[4]=i*w-l*s,t[5]=u*s-i*c,t[6]=u*d-l*f,t[7]=l*o-i*d,t[8]=i*f-u*o;var p=1/m;return h.multiplyByScalar(t,p,t)},h.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},h.equalsEpsilon=function(e,t,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i&&Math.abs(e[4]-t[4])<=i&&Math.abs(e[5]-t[5])<=i&&Math.abs(e[6]-t[6])<=i&&Math.abs(e[7]-t[7])<=i&&Math.abs(e[8]-t[8])<=i},h.IDENTITY=i(new h(1,0,0,0,1,0,0,0,1)),h.COLUMN0ROW0=0,h.COLUMN0ROW1=1,h.COLUMN0ROW2=2,h.COLUMN1ROW0=3,h.COLUMN1ROW1=4,h.COLUMN1ROW2=5,h.COLUMN2ROW0=6,h.COLUMN2ROW1=7,h.COLUMN2ROW2=8,h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.equalsEpsilon=function(e,t){return h.equalsEpsilon(this,e,t)},h.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},h}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,i,a,o,s,u){"use strict";var h=function(e,t,n,i,a,o,s,u,h,f,c,l,d,w,m,p){this[0]=r(e,0),this[1]=r(a,0),this[2]=r(h,0),this[3]=r(d,0),this[4]=r(t,0),this[5]=r(o,0),this[6]=r(f,0),this[7]=r(w,0),this[8]=r(n,0),this[9]=r(s,0),this[10]=r(c,0),this[11]=r(m,0),this[12]=r(i,0),this[13]=r(u,0),this[14]=r(l,0),this[15]=r(p,0)};h.packedLength=16,h.pack=function(e,t,a){if(!n(e))throw new i("value is required");if(!n(t))throw new i("array is required");a=r(a,0),t[a++]=e[0],t[a++]=e[1],t[a++]=e[2],t[a++]=e[3],t[a++]=e[4],t[a++]=e[5],t[a++]=e[6],t[a++]=e[7],t[a++]=e[8],t[a++]=e[9],t[a++]=e[10],t[a++]=e[11],t[a++]=e[12],t[a++]=e[13],t[a++]=e[14],t[a]=e[15]},h.unpack=function(e,t,a){if(!n(e))throw new i("array is required");return t=r(t,0),n(a)||(a=new h),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},h.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new h(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},h.fromArray=h.unpack,h.fromColumnMajorArray=function(e,t){if(!n(e))throw new i("values is required");return h.clone(e,t)},h.fromRowMajorArray=function(e,t){if(!n(e))throw new i("values is required.");return n(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new h(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},h.fromRotationTranslation=function(e,t,r){if(!n(e))throw new i("rotation is required.");if(!n(t))throw new i("translation is required.");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=0,r[4]=e[3],r[5]=e[4],r[6]=e[5],r[7]=0,r[8]=e[6],r[9]=e[7],r[10]=e[8],r[11]=0,r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=1,r):new h(e[0],e[3],e[6],t.x,e[1],e[4],e[7],t.y,e[2],e[5],e[8],t.z,0,0,0,1)},new s,h.fromTranslationQuaternionRotationScale=function(e,t,r,a){if(!n(e))throw new i("translation is required.");if(!n(t))throw new i("rotation is required.");if(!n(r))throw new i("scale is required.");n(a)||(a=new h);var o=r.x,s=r.y,u=r.z,f=t.x*t.x,c=t.x*t.y,l=t.x*t.z,d=t.x*t.w,w=t.y*t.y,m=t.y*t.z,p=t.y*t.w,y=t.z*t.z,v=t.z*t.w,g=t.w*t.w,q=f-w-y+g,x=2*(c-v),E=2*(l+p),b=2*(c+v),S=-f+w-y+g,M=2*(m-d),_=2*(l-p),O=2*(m+d),P=-f-w+y+g;return a[0]=q*o,a[1]=b*o,a[2]=_*o,a[3]=0,a[4]=x*s,a[5]=S*s,a[6]=O*s,a[7]=0,a[8]=E*u,a[9]=M*u,a[10]=P*u,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},h.fromTranslation=function(e,t){return h.fromRotationTranslation(s.IDENTITY,e,t)},h.fromScale=function(e,t){if(!n(e))throw new i("scale is required.");return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new h(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},h.fromUniformScale=function(e,t){if("number"!=typeof e)throw new i("scale is required.");return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new h(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var f=new e,c=new e,l=new e;h.fromCamera=function(t,r){if(!n(t))throw new i("camera is required.");var a=t.eye,o=t.target,s=t.up;if(!n(a))throw new i("camera.eye is required.");if(!n(o))throw new i("camera.target is required.");if(!n(s))throw new i("camera.up is required.");e.normalize(e.subtract(o,a,f),f),e.normalize(e.cross(f,s,c),c),e.normalize(e.cross(c,f,l),l);var u=c.x,d=c.y,w=c.z,m=f.x,p=f.y,y=f.z,v=l.x,g=l.y,q=l.z,x=a.x,E=a.y,b=a.z,S=u*-x+d*-E+w*-b,M=v*-x+g*-E+q*-b,_=m*x+p*E+y*b;return n(r)?(r[0]=u,r[1]=v,r[2]=-m,r[3]=0,r[4]=d,r[5]=g,r[6]=-p,r[7]=0,r[8]=w,r[9]=q,r[10]=-y,r[11]=0,r[12]=S,r[13]=M,r[14]=_,r[15]=1,r):new h(u,d,w,S,v,g,q,M,-m,-p,-y,_,0,0,0,1)},h.computePerspectiveFieldOfView=function(e,t,r,a,o){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=t)throw new i("aspectRatio must be greater than zero.");if(0>=r)throw new i("near must be greater than zero.");if(0>=a)throw new i("far must be greater than zero.");var s=Math.tan(.5*e),u=1/s,f=u/t,c=(a+r)/(r-a),l=2*a*r/(r-a);return n(o)?(o[0]=f,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=u,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=-1,o[12]=0,o[13]=0,o[14]=l,o[15]=0,o):new h(f,0,0,0,0,u,0,0,0,0,c,l,0,0,-1,0)},h.computeOrthographicOffCenter=function(e,t,r,a,o,s,u){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");if(!n(r))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(s))throw new i("far is required.");var f=1/(t-e),c=1/(a-r),l=1/(s-o),d=-(t+e)*f,w=-(a+r)*c,m=-(s+o)*l;return f*=2,c*=2,l*=-2,n(u)?(u[0]=f,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=l,u[11]=0,u[12]=d,u[13]=w,u[14]=m,u[15]=1,u):new h(f,0,0,d,0,c,0,w,0,0,l,m,0,0,0,1)},h.computePerspectiveOffCenter=function(e,t,r,a,o,s,u){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");if(!n(r))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(s))throw new i("far is required.");var f=2*o/(t-e),c=2*o/(a-r),l=(t+e)/(t-e),d=(a+r)/(a-r),w=-(s+o)/(s-o),m=-1,p=-2*s*o/(s-o);return n(u)?(u[0]=f,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=l,u[9]=d,u[10]=w,u[11]=m,u[12]=0,u[13]=0,u[14]=p,u[15]=0,u):new h(f,0,l,0,0,c,d,0,0,0,w,p,0,0,m,0)},h.computeInfinitePerspectiveOffCenter=function(e,t,r,a,o,s){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");if(!n(r))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");var u=2*o/(t-e),f=2*o/(a-r),c=(t+e)/(t-e),l=(a+r)/(a-r),d=-1,w=-1,m=-2*o;return n(s)?(s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=f,s[6]=0,s[7]=0,s[8]=c,s[9]=l,s[10]=d,s[11]=w,s[12]=0,s[13]=0,s[14]=m,s[15]=0,s):new h(u,0,c,0,0,f,l,0,0,0,d,m,0,0,w,0)},h.computeViewportTransformation=function(e,t,i,a){e=r(e,r.EMPTY_OBJECT);var o=r(e.x,0),s=r(e.y,0),u=r(e.width,0),f=r(e.height,0);t=r(t,0),i=r(i,1);var c=.5*u,l=.5*f,d=.5*(i-t),w=c,m=l,p=d,y=o+c,v=s+l,g=t+d,q=1;return n(a)?(a[0]=w,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=m,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=p,a[11]=0,a[12]=y,a[13]=v,a[14]=g,a[15]=q,a):new h(w,0,0,y,0,m,0,v,0,0,p,g,0,0,0,q)},h.toArray=function(e,t){if(!n(e))throw new i("matrix is required");return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},h.getElementIndex=function(e,t){if("number"!=typeof t||0>t||t>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+t},h.getColumn=function(e,r,a){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");var o=4*r,s=e[o],u=e[o+1],h=e[o+2],f=e[o+3];return n(a)?(a.x=s,a.y=u,a.z=h,a.w=f,a):new t(s,u,h,f)},h.setColumn=function(e,t,r,a){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");a=h.clone(e,a);var o=4*t;return a[o]=r.x,a[o+1]=r.y,a[o+2]=r.z,a[o+3]=r.w,a},h.getRow=function(e,r,a){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");var o=e[r],s=e[r+4],u=e[r+8],h=e[r+12];return n(a)?(a.x=o,a.y=s,a.z=u,a.w=h,a):new t(o,s,u,h)},h.setRow=function(e,t,r,a){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");return a=h.clone(e,a),a[t]=r.x,a[t+4]=r.y,a[t+8]=r.z,a[t+12]=r.w,a};var d=new e;h.getScale=function(t,r){if(!n(t))throw new i("matrix is required.");return n(r)||(r=new e),r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],d)),r.y=e.magnitude(e.fromElements(t[4],t[5],t[6],d)),r.z=e.magnitude(e.fromElements(t[8],t[9],t[10],d)),r};var w=new e;h.getMaximumScale=function(t){return h.getScale(t,w),e.getMaximumComponent(w)},h.multiply=function(e,t,r){if(!n(e))throw new i("left is required");if(!n(t))throw new i("right is required");var a=e[0],o=e[1],s=e[2],u=e[3],f=e[4],c=e[5],l=e[6],d=e[7],w=e[8],m=e[9],p=e[10],y=e[11],v=e[12],g=e[13],q=e[14],x=e[15],E=t[0],b=t[1],S=t[2],M=t[3],_=t[4],O=t[5],P=t[6],T=t[7],C=t[8],N=t[9],R=t[10],I=t[11],A=t[12],D=t[13],z=t[14],U=t[15],L=a*E+f*b+w*S+v*M,W=o*E+c*b+m*S+g*M,B=s*E+l*b+p*S+q*M,F=u*E+d*b+y*S+x*M,G=a*_+f*O+w*P+v*T,V=o*_+c*O+m*P+g*T,Y=s*_+l*O+p*P+q*T,j=u*_+d*O+y*P+x*T,H=a*C+f*N+w*R+v*I,k=o*C+c*N+m*R+g*I,X=s*C+l*N+p*R+q*I,Z=u*C+d*N+y*R+x*I,J=a*A+f*D+w*z+v*U,K=o*A+c*D+m*z+g*U,$=s*A+l*D+p*z+q*U,Q=u*A+d*D+y*z+x*U;return n(r)?(r[0]=L,r[1]=W,r[2]=B,r[3]=F,r[4]=G,r[5]=V,r[6]=Y,r[7]=j,r[8]=H,r[9]=k,r[10]=X,r[11]=Z,r[12]=J,r[13]=K,r[14]=$,r[15]=Q,r):new h(L,G,H,J,W,V,k,K,B,Y,X,$,F,j,Z,Q)},h.multiplyTransformation=function(e,t,r){if(!n(e))throw new i("left is required");if(!n(t))throw new i("right is required");var a=e[0],o=e[1],s=e[2],u=e[4],f=e[5],c=e[6],l=e[8],d=e[9],w=e[10],m=e[12],p=e[13],y=e[14],v=t[0],g=t[1],q=t[2],x=t[4],E=t[5],b=t[6],S=t[8],M=t[9],_=t[10],O=t[12],P=t[13],T=t[14],C=a*v+u*g+l*q,N=o*v+f*g+d*q,R=s*v+c*g+w*q,I=a*x+u*E+l*b,A=o*x+f*E+d*b,D=s*x+c*E+w*b,z=a*S+u*M+l*_,U=o*S+f*M+d*_,L=s*S+c*M+w*_,W=a*O+u*P+l*T+m,B=o*O+f*P+d*T+p,F=s*O+c*P+w*T+y;return n(r)?(r[0]=C,r[1]=N,r[2]=R,r[3]=0,r[4]=I,r[5]=A,r[6]=D,r[7]=0,r[8]=z,r[9]=U,r[10]=L,r[11]=0,r[12]=W,r[13]=B,r[14]=F,r[15]=1,r):new h(C,I,z,W,N,A,U,B,R,D,L,F,0,0,0,1)},h.multiplyByTranslation=function(e,t,r){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("translation is required");var a=t.x,o=t.y,s=t.z,u=a*e[0]+o*e[4]+s*e[8]+e[12],f=a*e[1]+o*e[5]+s*e[9]+e[13],c=a*e[2]+o*e[6]+s*e[10]+e[14];return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=u,r[13]=f,r[14]=c,r[15]=e[15],r):new h(e[0],e[4],e[8],u,e[1],e[5],e[9],f,e[2],e[6],e[10],c,e[3],e[7],e[11],e[15])};var m=new e;return h.multiplyByUniformScale=function(e,t,r){if("number"!=typeof t)throw new i("scale is required");return m.x=t,m.y=t,m.z=t,h.multiplyByScale(e,m,r)},h.multiplyByScale=function(e,t,r){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("scale is required");var a=t.x,o=t.y,s=t.z;return 1===a&&1===o&&1===s?h.clone(e,r):n(r)?(r[0]=a*e[0],r[1]=a*e[1],r[2]=a*e[2],r[3]=0,r[4]=o*e[4],r[5]=o*e[5],r[6]=o*e[6],r[7]=0,r[8]=s*e[8],r[9]=s*e[9],r[10]=s*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r):new h(a*e[0],o*e[4],s*e[8],e[12],a*e[1],o*e[5],s*e[9],e[13],a*e[2],o*e[6],s*e[10],e[14],0,0,0,1)},h.multiplyByVector=function(e,r,a){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");var o=r.x,s=r.y,u=r.z,h=r.w,f=e[0]*o+e[4]*s+e[8]*u+e[12]*h,c=e[1]*o+e[5]*s+e[9]*u+e[13]*h,l=e[2]*o+e[6]*s+e[10]*u+e[14]*h,d=e[3]*o+e[7]*s+e[11]*u+e[15]*h;return n(a)?(a.x=f,a.y=c,a.z=l,a.w=d,a):new t(f,c,l,d)},h.multiplyByPointAsVector=function(t,r,a){if(!n(t))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");var o=r.x,s=r.y,u=r.z,h=t[0]*o+t[4]*s+t[8]*u,f=t[1]*o+t[5]*s+t[9]*u,c=t[2]*o+t[6]*s+t[10]*u;return n(a)?(a.x=h,a.y=f,a.z=c,a):new e(h,f,c)},h.multiplyByPoint=function(t,r,a){if(!n(t))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");var o=r.x,s=r.y,u=r.z,h=t[0]*o+t[4]*s+t[8]*u+t[12],f=t[1]*o+t[5]*s+t[9]*u+t[13],c=t[2]*o+t[6]*s+t[10]*u+t[14];return n(a)?(a.x=h,a.y=f,a.z=c,a):new e(h,f,c)},h.multiplyByScalar=function(e,t,r){if(!n(e))throw new i("matrix is required");if("number"!=typeof t)throw new i("scalar must be a number");return n(r)?(r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r):new h(e[0]*t,e[4]*t,e[8]*t,e[12]*t,e[1]*t,e[5]*t,e[9]*t,e[13]*t,e[2]*t,e[6]*t,e[10]*t,e[14]*t,e[3]*t,e[7]*t,e[11]*t,e[15]*t)},h.negate=function(e,t){if(!n(e))throw new i("matrix is required");return n(t)?(t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t):new h(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},h.transpose=function(e,t){if(!n(e))throw new i("matrix is required");if(!n(t))return new h(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var r=e[1],a=e[2],o=e[3],s=e[6],u=e[7],f=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=a,t[9]=s,t[10]=e[10],t[11]=e[14],t[12]=o,t[13]=u,t[14]=f,t[15]=e[15],t},h.abs=function(e,t){if(!n(e))throw new i("matrix is required");return n(t)?(t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t):new h(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},h.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[11]===t[11]&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[15]===t[15]},h.equalsEpsilon=function(e,t,r){if("number"!=typeof r)throw new i("epsilon must be a number");return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},h.getTranslation=function(t,r){if(!n(t))throw new i("matrix is required");return n(r)?(r.x=t[12],r.y=t[13],r.z=t[14],r):new e(t[12],t[13],t[14])},h.getRotation=function(e,t){if(!n(e))throw new i("matrix is required");return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t):new s(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},h.inverse=function(e,t){if(!n(e))throw new i("matrix is required");var r=e[0],a=e[4],s=e[8],f=e[12],c=e[1],l=e[5],d=e[9],w=e[13],m=e[2],p=e[6],y=e[10],v=e[14],g=e[3],q=e[7],x=e[11],E=e[15],b=y*E,S=v*x,M=p*E,_=v*q,O=p*x,P=y*q,T=m*E,C=v*g,N=m*x,R=y*g,I=m*q,A=p*g,D=b*l+_*d+O*w-(S*l+M*d+P*w),z=S*c+T*d+R*w-(b*c+C*d+N*w),U=M*c+C*l+I*w-(_*c+T*l+A*w),L=P*c+N*l+A*d-(O*c+R*l+I*d),W=S*a+M*s+P*f-(b*a+_*s+O*f),B=b*r+C*s+N*f-(S*r+T*s+R*f),F=_*r+T*a+A*f-(M*r+C*a+I*f),G=O*r+R*a+I*s-(P*r+N*a+A*s);b=s*w,S=f*d,M=a*w,_=f*l,O=a*d,P=s*l,T=r*w,C=f*c,N=r*d,R=s*c,I=r*l,A=a*c;var V=b*q+_*x+O*E-(S*q+M*x+P*E),Y=S*g+T*x+R*E-(b*g+C*x+N*E),j=M*g+C*q+I*E-(_*g+T*q+A*E),H=P*g+N*q+A*x-(O*g+R*q+I*x),k=M*y+P*v+S*p-(O*v+b*p+_*y),X=N*v+b*m+C*y-(T*y+R*v+S*m),Z=T*p+A*v+_*m-(I*v+M*m+C*p),J=I*y+O*m+R*p-(N*p+A*y+P*m),K=r*D+a*z+s*U+f*L;if(Math.abs(K)<o.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return K=1/K,n(t)?(t[0]=D*K,t[1]=z*K,t[2]=U*K,t[3]=L*K,t[4]=W*K,t[5]=B*K,t[6]=F*K,t[7]=G*K,t[8]=V*K,t[9]=Y*K,t[10]=j*K,t[11]=H*K,t[12]=k*K,t[13]=X*K,t[14]=Z*K,t[15]=J*K,t):new h(D*K,W*K,V*K,k*K,z*K,B*K,Y*K,X*K,U*K,F*K,j*K,Z*K,L*K,G*K,H*K,J*K)},h.inverseTransformation=function(e,t){if(!n(e))throw new i("matrix is required");var r=e[0],a=e[1],o=e[2],s=e[4],u=e[5],f=e[6],c=e[8],l=e[9],d=e[10],w=e[12],m=e[13],p=e[14],y=-r*w-a*m-o*p,v=-s*w-u*m-f*p,g=-c*w-l*m-d*p;return n(t)?(t[0]=r,t[1]=s,t[2]=c,t[3]=0,t[4]=a,t[5]=u,t[6]=l,t[7]=0,t[8]=o,t[9]=f,t[10]=d,t[11]=0,t[12]=y,t[13]=v,t[14]=g,t[15]=1,t):new h(r,a,o,y,s,u,f,v,c,l,d,g,0,0,0,1)},h.IDENTITY=a(new h(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),h.COLUMN0ROW0=0,h.COLUMN0ROW1=1,h.COLUMN0ROW2=2,h.COLUMN0ROW3=3,h.COLUMN1ROW0=4,h.COLUMN1ROW1=5,h.COLUMN1ROW2=6,h.COLUMN1ROW3=7,h.COLUMN2ROW0=8,h.COLUMN2ROW1=9,h.COLUMN2ROW2=10,h.COLUMN2ROW3=11,h.COLUMN3ROW0=12,h.COLUMN3ROW1=13,h.COLUMN3ROW2=14,h.COLUMN3ROW3=15,h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.equalsEpsilon=function(e,t){return h.equalsEpsilon(this,e,t)},h.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},h}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,i,a,o){"use strict";var s=function(e,r,n,i){this.west=t(e,0),this.south=t(r,0),this.east=t(n,0),this.north=t(i,0)};s.fromDegrees=function(e,n,i,a,u){return e=o.toRadians(t(e,0)),n=o.toRadians(t(n,0)),i=o.toRadians(t(i,0)),a=o.toRadians(t(a,0)),r(u)?(u.west=e,u.south=n,u.east=i,u.north=a,u):new s(e,n,i,a)},s.fromCartographicArray=function(e,t){if(!r(e))throw new n("cartographics is required.");for(var i=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,u=-Number.MAX_VALUE,h=0,f=e.length;f>h;h++){var c=e[h];i=Math.min(i,c.longitude),a=Math.max(a,c.longitude),o=Math.min(o,c.latitude),u=Math.max(u,c.latitude)}return r(t)?(t.west=i,t.south=o,t.east=a,t.north=u,t):new s(i,o,a,u)},s.packedLength=4,s.pack=function(e,i,a){if(!r(e))throw new n("value is required");if(!r(i))throw new n("array is required");a=t(a,0),i[a++]=e.west,i[a++]=e.south,i[a++]=e.east,i[a]=e.north},s.unpack=function(e,i,a){if(!r(e))throw new n("array is required");return i=t(i,0),r(a)||(a=new s),a.west=e[i++],a.south=e[i++],a.east=e[i++],a.north=e[i],a},s.clone=function(e,t){return r(e)?r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){if("number"!=typeof t)throw new n("epsilon is required and must be a number.");return r(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(e){if(!r(e))throw new n("rectangle is required");var t=e.north;if("number"!=typeof t)throw new n("north is required to be a number.");if(t<-o.PI_OVER_TWO||t>o.PI_OVER_TWO)throw new n("north must be in the interval [-Pi/2, Pi/2].");var i=e.south;if("number"!=typeof i)throw new n("south is required to be a number.");if(i<-o.PI_OVER_TWO||i>o.PI_OVER_TWO)throw new n("south must be in the interval [-Pi/2, Pi/2].");var a=e.west;if("number"!=typeof a)throw new n("west is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new n("west must be in the interval [-Pi, Pi].");var s=e.east;if("number"!=typeof s)throw new n("east is required to be a number.");if(s<-Math.PI||s>Math.PI)throw new n("east must be in the interval [-Pi, Pi].")},s.getSouthwest=function(t,i){if(!r(t))throw new n("rectangle is required");return r(i)?(i.longitude=t.west,i.latitude=t.south,i.height=0,i):new e(t.west,t.south)},s.getNorthwest=function(t,i){if(!r(t))throw new n("rectangle is required");return r(i)?(i.longitude=t.west,i.latitude=t.north,i.height=0,i):new e(t.west,t.north)},s.getNortheast=function(t,i){if(!r(t))throw new n("rectangle is required");return r(i)?(i.longitude=t.east,i.latitude=t.north,i.height=0,i):new e(t.east,t.north)},s.getSoutheast=function(t,i){if(!r(t))throw new n("rectangle is required");return r(i)?(i.longitude=t.east,i.latitude=t.south,i.height=0,i):new e(t.east,t.south)},s.getCenter=function(t,i){if(!r(t))throw new n("rectangle is required");return r(i)?(i.longitude=.5*(t.west+t.east),i.latitude=.5*(t.south+t.north),i.height=0,i):new e(.5*(t.west+t.east),.5*(t.south+t.north))},s.intersectWith=function(e,t,i){if(!r(e))throw new n("rectangle is required");if(!r(t))throw new n("otherRectangle is required.");var a=Math.max(e.west,t.west),o=Math.max(e.south,t.south),u=Math.min(e.east,t.east),h=Math.min(e.north,t.north);return r(i)?(i.west=a,i.south=o,i.east=u,i.north=h,i):new s(a,o,u,h)},s.contains=function(e,t){if(!r(e))throw new n("rectangle is required");if(!r(t))throw new n("cartographic is required.");return t.longitude>=e.west&&t.longitude<=e.east&&t.latitude>=e.south&&t.latitude<=e.north},s.isEmpty=function(e){if(!r(e))throw new n("rectangle is required");return e.west>=e.east||e.south>=e.north};var u=new e;return s.subsample=function(e,a,s,h){if(!r(e))throw new n("rectangle is required");a=t(a,i.WGS84),s=t(s,0),r(h)||(h=[]);var f=0,c=e.north,l=e.south,d=e.east,w=e.west,m=u;m.height=s,m.longitude=w,m.latitude=c,h[f]=a.cartographicToCartesian(m,h[f]),f++,m.longitude=d,h[f]=a.cartographicToCartesian(m,h[f]),f++,m.latitude=l,h[f]=a.cartographicToCartesian(m,h[f]),f++,m.longitude=w,h[f]=a.cartographicToCartesian(m,h[f]),f++,m.latitude=0>c?c:l>0?l:0;for(var p=1;8>p;++p){var y=-Math.PI+p*o.PI_OVER_TWO;y>w&&d>y&&(m.longitude=y,h[f]=a.cartographicToCartesian(m,h[f]),f++)}return 0===m.latitude&&(m.longitude=w,h[f]=a.cartographicToCartesian(m,h[f]),f++,m.longitude=d,h[f]=a.cartographicToCartesian(m,h[f]),f++),h.length=f,h},s.MAX_VALUE=a(new s(-Math.PI,-o.PI_OVER_TWO,Math.PI,o.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,t,r,n,i,a,o,s,u,h,f){"use strict";var c=function(t,n){this.center=e.clone(r(t,e.ZERO)),this.radius=r(n,0)},l=new e,d=new e,w=new e,m=new e,p=new e,y=new e,v=new e,g=new e,q=new e,x=new e,E=new e,b=new e;c.fromPoints=function(t,r){if(n(r)||(r=new c),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;for(var i=e.clone(t[0],v),a=e.clone(i,l),o=e.clone(i,d),s=e.clone(i,w),u=e.clone(i,m),h=e.clone(i,p),f=e.clone(i,y),S=t.length,M=1;S>M;M++){e.clone(t[M],i);var _=i.x,O=i.y,P=i.z;_<a.x&&e.clone(i,a),_>u.x&&e.clone(i,u),O<o.y&&e.clone(i,o),O>h.y&&e.clone(i,h),P<s.z&&e.clone(i,s),P>f.z&&e.clone(i,f)}var T=e.magnitudeSquared(e.subtract(u,a,g)),C=e.magnitudeSquared(e.subtract(h,o,g)),N=e.magnitudeSquared(e.subtract(f,s,g)),R=a,I=u,A=T;C>A&&(A=C,R=o,I=h),N>A&&(A=N,R=s,I=f);var D=q;D.x=.5*(R.x+I.x),D.y=.5*(R.y+I.y),D.z=.5*(R.z+I.z);var z=e.magnitudeSquared(e.subtract(I,D,g)),U=Math.sqrt(z),L=x;L.x=a.x,L.y=o.y,L.z=s.z;var W=E;W.x=u.x,W.y=h.y,W.z=f.z;var B=e.multiplyByScalar(e.add(L,W,g),.5,b),F=0;for(M=0;S>M;M++){e.clone(t[M],i);var G=e.magnitude(e.subtract(i,B,g));G>F&&(F=G);var V=e.magnitudeSquared(e.subtract(i,D,g));if(V>z){var Y=Math.sqrt(V);U=.5*(U+Y),z=U*U;var j=Y-U;D.x=(U*D.x+j*i.x)/Y,D.y=(U*D.y+j*i.y)/Y,D.z=(U*D.z+j*i.z)/Y}}return F>U?(e.clone(D,r.center),r.radius=U):(e.clone(B,r.center),r.radius=F),r};var S=new o,M=new e,_=new e,O=new t,P=new t;c.fromRectangle2D=function(e,t,r){return c.fromRectangleWithHeights2D(e,t,0,0,r)},c.fromRectangleWithHeights2D=function(t,i,a,o,s){if(n(s)||(s=new c),!n(t))return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;i=r(i,S),f.getSouthwest(t,O),O.height=a,f.getNortheast(t,P),P.height=o;var u=i.project(O,M),h=i.project(P,_),l=h.x-u.x,d=h.y-u.y,w=h.z-u.z;s.radius=.5*Math.sqrt(l*l+d*d+w*w);var m=s.center;return m.x=u.x+.5*l,m.y=u.y+.5*d,m.z=u.z+.5*w,s};var T=[];c.fromRectangle3D=function(e,t,i,o){t=r(t,a.WGS84),i=r(i,0);var s;return n(e)&&(s=f.subsample(e,t,i,T)),c.fromPoints(s,o)},c.fromVertices=function(t,a,o,s){if(n(s)||(s=new c),!n(t)||0===t.length)return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;if(a=r(a,e.ZERO),o=r(o,3),3>o)throw new i("stride must be 3 or greater.");var u=v;u.x=t[0]+a.x,u.y=t[1]+a.y,u.z=t[2]+a.z;for(var h=e.clone(u,l),f=e.clone(u,d),S=e.clone(u,w),M=e.clone(u,m),_=e.clone(u,p),O=e.clone(u,y),P=t.length,T=0;P>T;T+=o){var C=t[T]+a.x,N=t[T+1]+a.y,R=t[T+2]+a.z;u.x=C,u.y=N,u.z=R,C<h.x&&e.clone(u,h),C>M.x&&e.clone(u,M),N<f.y&&e.clone(u,f),N>_.y&&e.clone(u,_),R<S.z&&e.clone(u,S),R>O.z&&e.clone(u,O)}var I=e.magnitudeSquared(e.subtract(M,h,g)),A=e.magnitudeSquared(e.subtract(_,f,g)),D=e.magnitudeSquared(e.subtract(O,S,g)),z=h,U=M,L=I;A>L&&(L=A,z=f,U=_),D>L&&(L=D,z=S,U=O);var W=q;W.x=.5*(z.x+U.x),W.y=.5*(z.y+U.y),W.z=.5*(z.z+U.z);var B=e.magnitudeSquared(e.subtract(U,W,g)),F=Math.sqrt(B),G=x;G.x=h.x,G.y=f.y,G.z=S.z;var V=E;V.x=M.x,V.y=_.y,V.z=O.z;var Y=e.multiplyByScalar(e.add(G,V,g),.5,b),j=0;for(T=0;P>T;T+=o){u.x=t[T]+a.x,u.y=t[T+1]+a.y,u.z=t[T+2]+a.z;var H=e.magnitude(e.subtract(u,Y,g));H>j&&(j=H);var k=e.magnitudeSquared(e.subtract(u,W,g));if(k>B){var X=Math.sqrt(k);F=.5*(F+X),B=F*F;var Z=X-F;W.x=(F*W.x+Z*u.x)/X,W.y=(F*W.y+Z*u.y)/X,W.z=(F*W.z+Z*u.z)/X}}return j>F?(e.clone(W,s.center),s.radius=F):(e.clone(Y,s.center),s.radius=j),s},c.fromCornerPoints=function(t,r,a){if(!n(t)||!n(r))throw new i("corner and oppositeCorner are required.");n(a)||(a=new c);var o=a.center;return e.add(t,r,o),e.multiplyByScalar(o,.5,o),a.radius=e.distance(o,r),a},c.fromEllipsoid=function(t,r){if(!n(t))throw new i("ellipsoid is required.");return n(r)||(r=new c),e.clone(e.ZERO,r.center),r.radius=t.maximumRadius,r},c.clone=function(t,r){return n(t)?n(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new c(t.center,t.radius):void 0},c.packedLength=4,c.pack=function(e,t,a){if(!n(e))throw new i("value is required");if(!n(t))throw new i("array is required");a=r(a,0);var o=e.center;t[a++]=o.x,t[a++]=o.y,t[a++]=o.z,t[a]=e.radius},c.unpack=function(e,t,a){if(!n(e))throw new i("array is required");t=r(t,0),n(a)||(a=new c);var o=a.center;return o.x=e[t++],o.y=e[t++],o.z=e[t++],a.radius=e[t],a};var C=new e,N=new e;c.union=function(t,r,a){if(!n(t))throw new i("left is required.");if(!n(r))throw new i("right is required.");n(a)||(a=new c);var o=t.center,s=r.center;e.add(o,s,N);var u=e.multiplyByScalar(N,.5,N),h=e.magnitude(e.subtract(o,u,C))+t.radius,f=e.magnitude(e.subtract(s,u,C))+r.radius;return a.radius=Math.max(h,f),e.clone(u,a.center),a};var R=new e;c.expand=function(t,r,a){if(!n(t))throw new i("sphere is required.");if(!n(r))throw new i("point is required.");a=c.clone(t,a);var o=e.magnitude(e.subtract(r,a.center,R));return o>a.radius&&(a.radius=o),a},c.intersect=function(t,r){if(!n(t))throw new i("sphere is required.");if(!n(r))throw new i("plane is required.");var a=t.center,o=t.radius,u=e.dot(r,a)+r.w;return-o>u?s.OUTSIDE:o>u?s.INTERSECTING:s.INSIDE},c.transform=function(e,t,r){if(!n(e))throw new i("sphere is required.");if(!n(t))throw new i("transform is required.");return n(r)||(r=new c),r.center=h.multiplyByPoint(t,e.center,r.center),r.radius=h.getMaximumScale(t)*e.radius,r};var I=new e;c.distanceSquaredTo=function(t,r){if(!n(t))throw new i("sphere is required.");if(!n(r))throw new i("cartesian is required.");var a=e.subtract(t.center,r,I);return e.magnitudeSquared(a)-t.radius*t.radius},c.transformWithoutScale=function(e,t,r){if(!n(e))throw new i("sphere is required.");if(!n(t))throw new i("transform is required.");return n(r)||(r=new c),r.center=h.multiplyByPoint(t,e.center,r.center),r.radius=e.radius,r};var A=new e;c.getPlaneDistances=function(t,r,a,o){if(!n(t))throw new i("sphere is required.");if(!n(r))throw new i("position is required.");if(!n(a))throw new i("direction is required.");n(o)||(o=new u);var s=e.subtract(t.center,r,A),h=e.multiplyByScalar(a,e.dot(a,s),A),f=e.magnitude(h);return o.start=f-t.radius,o.stop=f+t.radius,o};for(var D=new e,z=new e,U=new e,L=new e,W=new e,B=new t,F=new Array(8),G=0;8>G;++G)F[G]=new e;var V=new o;return c.projectTo2D=function(t,a,o){if(!n(t))throw new i("sphere is required.");a=r(a,V);var s=a.ellipsoid,u=t.center,h=t.radius,f=s.geodeticSurfaceNormal(u,D),l=e.cross(e.UNIT_Z,f,z);e.normalize(l,l);var d=e.cross(f,l,U);e.normalize(d,d),e.multiplyByScalar(f,h,f),e.multiplyByScalar(d,h,d),e.multiplyByScalar(l,h,l);var w=e.negate(d,W),m=e.negate(l,L),p=F,y=p[0];e.add(f,d,y),e.add(y,l,y),y=p[1],e.add(f,d,y),e.add(y,m,y),y=p[2],e.add(f,w,y),e.add(y,m,y),y=p[3],e.add(f,w,y),e.add(y,l,y),e.negate(f,f),y=p[4],e.add(f,d,y),e.add(y,l,y),y=p[5],e.add(f,d,y),e.add(y,m,y),y=p[6],e.add(f,w,y),e.add(y,m,y),y=p[7],e.add(f,w,y),e.add(y,l,y);for(var v=p.length,g=0;v>g;++g){var q=p[g];e.add(u,q,q);var x=s.cartesianToCartographic(q,B);a.project(x,q)}o=c.fromPoints(p,o),u=o.center;var E=u.x,b=u.y,S=u.z;return u.x=S,u.y=E,u.z=b,o},c.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&t.radius===r.radius
},c.prototype.intersect=function(e){return c.intersect(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.prototype.clone=function(e){return c.clone(this,e)},c}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,s=a.length;s>o;++o){var u=a[o];i=u+"RequestFullscreen","function"==typeof t[i]?(n.requestFullscreen=i,r=!0):(i=u+"RequestFullScreen","function"==typeof t[i]&&(n.requestFullscreen=i,r=!0)),i=u+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=u+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=u+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=u+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=u+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=u+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=u+"fullscreenchange",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=u+"fullscreenerror",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenError"),n.fullscreenerror=i)}return r},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function i(){if(!t(l)){var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null===e?l=!1:(l=!0,d=n(e[1]))}return l}function a(){return i()&&d}function o(){if(!t(w))if(i()||!/ Safari\/[\.0-9]+/.test(navigator.userAgent))w=!1;else{var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null===e?w=!1:(w=!0,m=n(e[1]))}return w}function s(){return o()&&m}function u(){if(!t(p)){var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null===e?p=!1:(p=!0,y=n(e[1]),y.isNightly=!!e[2])}return p}function h(){return u()&&y}function f(){if(!t(v)){var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(v=!0,g=n(e[1]))):"Netscape"===navigator.appName?(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(v=!0,g=n(e[1]))):v=!1}return v}function c(){return f()&&g}var l,d,w,m,p,y,v,g,q={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:s,isWebkit:u,webkitVersion:h,isInternetExplorer:f,internetExplorerVersion:c,hardwareConcurrency:e(navigator.hardwareConcurrency,3)};return q.supportsFullscreen=function(){return r.supportsFullscreen()},q.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},q}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection"],function(e,t,r,n){"use strict";if(!n.supportsTypedArrays())return{};var i={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return i.getSizeInBytes=function(e){if(!t(e))throw new r("value is required.");switch(e){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},i.fromTypedArray=function(e){return e instanceof Int8Array?i.BYTE:e instanceof Uint8Array?i.UNSIGNED_BYTE:e instanceof Int16Array?i.SHORT:e instanceof Uint16Array?i.UNSIGNED_SHORT:e instanceof Float32Array?i.FLOAT:e instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(e){return t(e)&&(e===i.BYTE||e===i.UNSIGNED_BYTE||e===i.SHORT||e===i.UNSIGNED_SHORT||e===i.FLOAT||e===i.DOUBLE)},i.createTypedArray=function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e){case i.BYTE:return new Int8Array(n);case i.UNSIGNED_BYTE:return new Uint8Array(n);case i.SHORT:return new Int16Array(n);case i.UNSIGNED_SHORT:return new Uint16Array(n);case i.FLOAT:return new Float32Array(n);case i.DOUBLE:return new Float64Array(n);default:throw new r("componentDatatype is not a valid value.")}},i.createArrayBufferView=function(n,a,o,s){if(!t(n))throw new r("componentDatatype is required.");if(!t(a))throw new r("buffer is required.");switch(o=e(o,0),s=e(s,(a.byteLength-o)/i.getSizeInBytes(n)),n){case i.BYTE:return new Int8Array(a,o,s);case i.UNSIGNED_BYTE:return new Uint8Array(a,o,s);case i.SHORT:return new Int16Array(a,o,s);case i.UNSIGNED_SHORT:return new Uint16Array(a,o,s);case i.FLOAT:return new Float32Array(a,o,s);case i.DOUBLE:return new Float64Array(a,o,s);default:throw new r("componentDatatype is not a valid value.")}},i}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.attributes))throw new r("options.attributes is required.");if(!t(n.primitiveType))throw new r("options.primitiveType is required.");this.attributes=n.attributes,this.indices=n.indices,this.primitiveType=n.primitiveType,this.boundingSphere=n.boundingSphere};return n.computeNumberOfVertices=function(e){if(!t(e))throw new r("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&t(e.attributes[i])&&t(e.attributes[i].values)){var a=e.attributes[i],o=a.values.length/a.componentsPerAttribute;if(n!==o&&-1!==n)throw new r("All attribute lists must have the same number of attributes.");n=o}return n},n}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),define("Core/IndexDatatype",["./defined","./DeveloperError","./Math"],function(e,t,r){"use strict";var n={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return n.getSizeInBytes=function(e){switch(e){case n.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case n.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case n.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},n.validate=function(t){return e(t)&&(t===n.UNSIGNED_BYTE||t===n.UNSIGNED_SHORT||t===n.UNSIGNED_INT)},n.createTypedArray=function(n,i){if(!e(n))throw new t("numberOfVertices is required.");return n>r.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},n}),define("Core/PrimitiveType",[],function(){"use strict";var e={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(t){return t===e.POINTS||t===e.LINES||t===e.LINE_LOOP||t===e.LINE_STRIP||t===e.TRIANGLES||t===e.TRIANGLE_STRIP||t===e.TRIANGLE_FAN}};return e}),define("Core/VertexFormat",["./defaultValue","./freezeObject"],function(e,t){"use strict";var r=function(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.binormal=e(t.binormal,!1),this.tangent=e(t.tangent,!1)};return r.POSITION_ONLY=t(new r({position:!0})),r.POSITION_AND_NORMAL=t(new r({position:!0,normal:!0})),r.POSITION_NORMAL_AND_ST=t(new r({position:!0,normal:!0,st:!0})),r.POSITION_AND_ST=t(new r({position:!0,st:!0})),r.ALL=t(new r({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),r.DEFAULT=r.POSITION_NORMAL_AND_ST,r}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Intersect"],function(e,t,r,n,i){"use strict";var a=function(n,i,a){this.minimum=e.clone(t(n,e.ZERO)),this.maximum=e.clone(t(i,e.ZERO)),r(a)?a=e.clone(a):(a=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(a,.5,a)),this.center=a};a.fromPoints=function(t,n){if(r(n)||(n=new a),!r(t)||0===t.length)return n.minimum=e.clone(e.ZERO,n.minimum),n.maximum=e.clone(e.ZERO,n.maximum),n.center=e.clone(e.ZERO,n.center),n;for(var i=t[0].x,o=t[0].y,s=t[0].z,u=t[0].x,h=t[0].y,f=t[0].z,c=t.length,l=1;c>l;l++){var d=t[l],w=d.x,m=d.y,p=d.z;i=Math.min(w,i),u=Math.max(w,u),o=Math.min(m,o),h=Math.max(m,h),s=Math.min(p,s),f=Math.max(p,f)}var y=n.minimum;y.x=i,y.y=o,y.z=s;var v=n.maximum;v.x=u,v.y=h,v.z=f;var g=e.add(y,v,n.center);return e.multiplyByScalar(g,.5,g),n},a.clone=function(t,n){return r(t)?r(n)?(n.minimum=e.clone(t.minimum,n.minimum),n.maximum=e.clone(t.maximum,n.maximum),n.center=e.clone(t.center,n.center),n):new a(t.minimum,t.maximum):void 0},a.equals=function(t,n){return t===n||r(t)&&r(n)&&e.equals(t.center,n.center)&&e.equals(t.minimum,n.minimum)&&e.equals(t.maximum,n.maximum)};var o=new e;return a.intersect=function(t,a){if(!r(t))throw new n("box is required.");if(!r(a))throw new n("plane is required.");o=e.subtract(t.maximum,t.minimum,o);var s=e.multiplyByScalar(o,.5,o),u=s.x*Math.abs(a.x)+s.y*Math.abs(a.y)+s.z*Math.abs(a.z),h=e.dot(t.center,a)+a.w;return h-u>0?i.INSIDE:0>h+u?i.OUTSIDE:i.INTERSECTING},a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.intersect=function(e){return a.intersect(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i){"use strict";var a=function(t,r){this.x=e(t,0),this.y=e(r,0)};a.fromElements=function(e,r,n){return t(n)?(n.x=e,n.y=r,n):new a(e,r)},a.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r):new a(e.x,e.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(n,i,a){if(!t(n))throw new r("value is required");if(!t(i))throw new r("array is required");a=e(a,0),i[a++]=n.x,i[a]=n.y},a.unpack=function(n,i,o){if(!t(n))throw new r("array is required");return i=e(i,0),t(o)||(o=new a),o.x=n[i++],o.y=n[i],o},a.fromArray=a.unpack,a.getMaximumComponent=function(e){if(!t(e))throw new r("cartesian is required");return Math.max(e.x,e.y)},a.getMinimumComponent=function(e){if(!t(e))throw new r("cartesian is required");return Math.min(e.x,e.y)},a.getMinimumByComponent=function(e,n,i){if(!t(e))throw new r("first is required.");if(!t(n))throw new r("second is required.");if(!t(i))throw new r("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i},a.getMaximumByComponent=function(e,n,i){if(!t(e))throw new r("first is required.");if(!t(n))throw new r("second is required.");if(!t(i))throw new r("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i},a.magnitudeSquared=function(e){if(!t(e))throw new r("cartesian is required");return e.x*e.x+e.y*e.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!t(e)||!t(n))throw new r("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.normalize=function(e,n){if(!t(e))throw new r("cartesian is required");if(!t(n))throw new r("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n},a.dot=function(e,n){if(!t(e))throw new r("left is required");if(!t(n))throw new r("right is required");return e.x*n.x+e.y*n.y},a.multiplyComponents=function(e,n,i){if(!t(e))throw new r("left is required");if(!t(n))throw new r("right is required");if(!t(i))throw new r("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i},a.add=function(e,n,i){if(!t(e))throw new r("left is required");if(!t(n))throw new r("right is required");if(!t(i))throw new r("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i},a.subtract=function(e,n,i){if(!t(e))throw new r("left is required");if(!t(n))throw new r("right is required");if(!t(i))throw new r("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i},a.multiplyByScalar=function(e,n,i){if(!t(e))throw new r("cartesian is required");if("number"!=typeof n)throw new r("scalar is required and must be a number.");if(!t(i))throw new r("result is required");return i.x=e.x*n,i.y=e.y*n,i},a.divideByScalar=function(e,n,i){if(!t(e))throw new r("cartesian is required");if("number"!=typeof n)throw new r("scalar is required and must be a number.");if(!t(i))throw new r("result is required");return i.x=e.x/n,i.y=e.y/n,i},a.negate=function(e,n){if(!t(e))throw new r("cartesian is required");if(!t(n))throw new r("result is required");return n.x=-e.x,n.y=-e.y,n},a.abs=function(e,n){if(!t(e))throw new r("cartesian is required");if(!t(n))throw new r("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n};var s=new a;a.lerp=function(e,n,i,o){if(!t(e))throw new r("start is required.");if(!t(n))throw new r("end is required.");if("number"!=typeof i)throw new r("t is required and must be a number.");if(!t(o))throw new r("result is required.");return a.multiplyByScalar(n,i,s),o=a.multiplyByScalar(e,1-i,o),a.add(s,o,o)};var u=new a,h=new a;a.angleBetween=function(e,n){if(!t(e))throw new r("left is required");if(!t(n))throw new r("right is required");return a.normalize(e,u),a.normalize(n,h),i.acosClamped(a.dot(u,h))};var f=new a;return a.mostOrthogonalAxis=function(e,n){if(!t(e))throw new r("cartesian is required.");if(!t(n))throw new r("result is required.");var i=a.normalize(e,f);return a.abs(i,i),n=i.x<=i.y?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Y,n)},a.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new r("epsilon is required and must be a number.");return e===n||t(e)&&t(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i},a.ZERO=n(new a(0,0)),a.UNIT_X=n(new a(1,0)),a.UNIT_Y=n(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t){return a.equalsEpsilon(this,e,t)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var i=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(r)))<n?0:i}var n={};return n.discriminant=function(t,r,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=r*r-4*t*n;return i},n.realRoots=function(n,i,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");var o;if(0===n)return 0===i?[]:[-a/i];if(0===i){if(0===a)return[0,0];var s=Math.abs(a),u=Math.abs(n);if(u>s&&s/u<t.EPSILON14)return[0,0];if(s>u&&u/s<t.EPSILON14)return[];if(o=-a/n,0>o)return[];var h=Math.sqrt(o);return[-h,h]}if(0===a)return o=-i/n,0>o?[o,0]:[0,o];var f=i*i,c=4*n*a,l=r(f,-c,t.EPSILON14);if(0>l)return[];var d=-.5*r(i,t.sign(i)*Math.sqrt(l),t.EPSILON14);return i>0?[d/n,a/d]:[a/d,d/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var i,a,o=e,s=t/3,u=r/3,h=n,f=o*u,c=s*h,l=s*s,d=u*u,w=o*u-l,m=o*h-s*u,p=s*h-d,y=4*w*p-m*m;if(0>y){var v,g,q;l*c>=f*d?(v=o,g=w,q=-2*s*w+o*m):(v=h,g=p,q=-h*m+2*u*p);var x=0>q?-1:1,E=-x*Math.abs(v)*Math.sqrt(-y);a=-q+E;var b=a/2,S=0>b?-Math.pow(-b,1/3):Math.pow(b,1/3),M=a===E?-S:-g/S;return i=0>=g?S+M:-q/(S*S+M*M+g),l*c>=f*d?[(i-s)/o]:[-h/(i+u)]}var _=w,O=-2*s*w+o*m,P=p,T=-h*m+2*u*p,C=Math.sqrt(y),N=Math.sqrt(3)/2,R=Math.abs(Math.atan2(o*C,-O)/3);i=2*Math.sqrt(-_);var I=Math.cos(R);a=i*I;var A=i*(-I/2-N*Math.sin(R)),D=a+A>2*s?a-s:A-s,z=o,U=D/z;R=Math.abs(Math.atan2(h*C,-T)/3),i=2*Math.sqrt(-P),I=Math.cos(R),a=i*I,A=i*(-I/2-N*Math.sin(R));var L=-h,W=2*u>a+A?a+u:A+u,B=L/W,F=z*W,G=-D*W-z*L,V=D*L,Y=(u*G-s*V)/(-s*G+u*F);return Y>=U?B>=U?B>=Y?[U,Y,B]:[U,B,Y]:[B,U,Y]:B>=U?[Y,U,B]:B>=Y?[Y,B,U]:[B,Y,U]}var n={};return n.discriminant=function(t,r,n,i){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var a=t*t,o=r*r,s=n*n,u=i*i,h=18*t*r*n*i+o*s-27*a*u-4*(t*s*n+o*r*i);return h},n.realRoots=function(n,i,a,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var s,u;if(0===n)return t.realRoots(i,a,o);if(0===i){if(0===a){if(0===o)return[0,0,0];u=-o/n;var h=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[h,h,h]}return 0===o?(s=t.realRoots(n,0,a),0===s.Length?[0]:[s[0],0,s[1]]):r(n,0,a,o)}return 0===a?0===o?(u=-i/n,0>u?[u,0,0]:[0,0,u]):r(n,i,0,o):0===o?(s=t.realRoots(n,i,a),0===s.length?[0]:s[1]<=0?[s[0],s[1],0]:s[0]>=0?[0,s[0],s[1]]:[s[0],0,s[1]]):r(n,i,a,o)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function i(t,i,a,o){var s=t*t,u=i-3*s/8,h=a-i*t/2+s*t/8,f=o-a*t/4+i*s/16-3*s*s/256,c=e.realRoots(1,2*u,u*u-4*f,-h*h);if(c.length>0){var l=-t/4,d=c[c.length-1];if(Math.abs(d)<r.EPSILON14){var w=n.realRoots(1,u,f);if(2===w.length){var m,p=w[0],y=w[1];if(p>=0&&y>=0){var v=Math.sqrt(p),g=Math.sqrt(y);return[l-g,l-v,l+v,l+g]}if(p>=0&&0>y)return m=Math.sqrt(p),[l-m,l+m];if(0>p&&y>=0)return m=Math.sqrt(y),[l-m,l+m]}return[]}if(d>0){var q=Math.sqrt(d),x=(u+d-h/q)/2,E=(u+d+h/q)/2,b=n.realRoots(1,q,x),S=n.realRoots(1,-q,E);return 0!==b.length?(b[0]+=l,b[1]+=l,0!==S.length?(S[0]+=l,S[1]+=l,b[1]<=S[0]?[b[0],b[1],S[0],S[1]]:S[1]<=b[0]?[S[0],S[1],b[0],b[1]]:b[0]>=S[0]&&b[1]<=S[1]?[S[0],b[0],b[1],S[1]]:S[0]>=b[0]&&S[1]<=b[1]?[b[0],S[0],S[1],b[1]]:b[0]>S[0]&&b[0]<S[1]?[S[0],b[0],S[1],b[1]]:[b[0],S[0],b[1],S[1]]):b):0!==S.length?(S[0]+=l,S[1]+=l,S):[]}}return[]}function a(t,i,a,o){var s=a*a,u=i*i,h=t*t,f=-2*i,c=a*t+u-4*o,l=h*o-a*i*t+s,d=e.realRoots(1,f,c,l);if(d.length>0){var w,m,p=d[0],y=i-p,v=y*y,g=t/2,q=y/2,x=v-4*o,E=v+4*Math.abs(o),b=h-4*p,S=h+4*Math.abs(p);if(0>p||b*E>x*S){var M=Math.sqrt(b);w=M/2,m=0===M?0:(t*q-a)/M}else{var _=Math.sqrt(x);w=0===_?0:(t*q-a)/_,m=_/2}var O,P;0===g&&0===w?(O=0,P=0):r.sign(g)===r.sign(w)?(O=g+w,P=p/O):(P=g-w,O=p/P);var T,C;0===q&&0===m?(T=0,C=0):r.sign(q)===r.sign(m)?(T=q+m,C=o/T):(C=q-m,T=o/C);var N=n.realRoots(1,O,T),R=n.realRoots(1,P,C);if(0!==N.length)return 0!==R.length?N[1]<=R[0]?[N[0],N[1],R[0],R[1]]:R[1]<=N[0]?[R[0],R[1],N[0],N[1]]:N[0]>=R[0]&&N[1]<=R[1]?[R[0],N[0],N[1],R[1]]:R[0]>=N[0]&&R[1]<=N[1]?[N[0],R[0],R[1],N[1]]:N[0]>R[0]&&N[0]<R[1]?[R[0],N[0],R[1],N[1]]:[N[0],R[0],N[1],R[1]]:N;if(0!==R.length)return R}return[]}var o={};return o.discriminant=function(e,r,n,i,a){if("number"!=typeof e)throw new t("a is a required number.");if("number"!=typeof r)throw new t("b is a required number.");if("number"!=typeof n)throw new t("c is a required number.");if("number"!=typeof i)throw new t("d is a required number.");if("number"!=typeof a)throw new t("e is a required number.");var o=e*e,s=o*e,u=r*r,h=u*r,f=n*n,c=f*n,l=i*i,d=l*i,w=a*a,m=w*a,p=u*f*l-4*h*d-4*e*c*l+18*e*r*n*d-27*o*l*l+256*s*m+a*(18*h*n*i-4*u*c+16*e*f*f-80*e*r*f*i-6*e*u*l+144*o*n*l)+w*(144*e*u*n-27*u*u-128*o*f-192*o*r*i);return p},o.realRoots=function(n,o,s,u,h){if("number"!=typeof n)throw new t("a is a required number.");if("number"!=typeof o)throw new t("b is a required number.");if("number"!=typeof s)throw new t("c is a required number.");if("number"!=typeof u)throw new t("d is a required number.");if("number"!=typeof h)throw new t("e is a required number.");if(Math.abs(n)<r.EPSILON15)return e.realRoots(o,s,u,h);var f=o/n,c=s/n,l=u/n,d=h/n,w=0>f?1:0;switch(w+=0>c?w+1:w,w+=0>l?w+1:w,w+=0>d?w+1:w){case 0:return i(f,c,l,d);case 1:return a(f,c,l,d);case 2:return a(f,c,l,d);case 3:return i(f,c,l,d);case 4:return i(f,c,l,d);case 5:return a(f,c,l,d);case 6:return i(f,c,l,d);case 7:return i(f,c,l,d);case 8:return a(f,c,l,d);case 9:return i(f,c,l,d);case 10:return i(f,c,l,d);case 11:return a(f,c,l,d);case 12:return i(f,c,l,d);case 13:return i(f,c,l,d);case 14:return i(f,c,l,d);case 15:return i(f,c,l,d);default:return void 0}},o}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial"],function(e,t,r,n,i,a,o,s){"use strict";function u(e,t,r){var n=e+t;return i.sign(e)!==i.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function h(t,r,n,h,f){var c,l=h*h,d=f*f,w=(t[a.COLUMN1ROW1]-t[a.COLUMN2ROW2])*d,m=f*(h*u(t[a.COLUMN1ROW0],t[a.COLUMN0ROW1],i.EPSILON15)+r.y),p=t[a.COLUMN0ROW0]*l+t[a.COLUMN2ROW2]*d+h*r.x+n,y=d*u(t[a.COLUMN2ROW1],t[a.COLUMN1ROW2],i.EPSILON15),v=f*(h*u(t[a.COLUMN2ROW0],t[a.COLUMN0ROW2])+r.z),g=[];if(0===v&&0===y){if(c=o.realRoots(w,m,p),0===c.length)return g;var q=c[0],x=Math.sqrt(Math.max(1-q*q,0));if(g.push(new e(h,f*q,f*-x)),g.push(new e(h,f*q,f*x)),2===c.length){var E=c[1],b=Math.sqrt(Math.max(1-E*E,0));g.push(new e(h,f*E,f*-b)),g.push(new e(h,f*E,f*b))}return g}var S=v*v,M=y*y,_=w*w,O=v*y,P=_+M,T=2*(m*w+O),C=2*p*w+m*m-M+S,N=2*(p*m-O),R=p*p-S;if(0===P&&0===T&&0===C&&0===N)return g;c=s.realRoots(P,T,C,N,R);var I=c.length;if(0===I)return g;for(var A=0;I>A;++A){var D,z=c[A],U=z*z,L=Math.max(1-U,0),W=Math.sqrt(L);D=i.sign(w)===i.sign(p)?u(w*U+p,m*z,i.EPSILON12):i.sign(p)===i.sign(m*z)?u(w*U,m*z+p,i.EPSILON12):u(w*U+m*z,p,i.EPSILON12);var B=u(y*z,v,i.EPSILON15),F=D*B;0>F?g.push(new e(h,f*z,f*W)):F>0?g.push(new e(h,f*z,f*-W)):0!==W?(g.push(new e(h,f*z,f*-W)),g.push(new e(h,f*z,f*W)),++A):g.push(new e(h,f*z,f*W))}return g}var f={};f.rayPlane=function(t,a,o){if(!r(t))throw new n("ray is required.");if(!r(a))throw new n("plane is required.");r(o)||(o=new e);var s=t.origin,u=t.direction,h=a.normal,f=e.dot(h,u);if(Math.abs(f)<i.EPSILON15)return void 0;var c=(-a.distance-e.dot(h,s))/f;return 0>c?void 0:(o=e.multiplyByScalar(u,c,o),e.add(s,o,o))};var c=new e,l=new e;f.rayEllipsoid=function(t,i){if(!r(t))throw new n("ray is required.");if(!r(i))throw new n("ellipsoid is required.");var a,o,s,u,h,f=i.oneOverRadii,d=e.multiplyComponents(f,t.origin,c),w=e.multiplyComponents(f,t.direction,l),m=e.magnitudeSquared(d),p=e.dot(d,w);if(m>1){if(p>=0)return void 0;var y=p*p;if(a=m-1,o=e.magnitudeSquared(w),s=o*a,s>y)return void 0;if(y>s){u=p*p-s,h=-p+Math.sqrt(u);var v=h/o,g=a/h;return g>v?{start:v,stop:g}:{start:g,stop:v}}var q=Math.sqrt(a/o);return{start:q,stop:q}}return 1>m?(a=m-1,o=e.magnitudeSquared(w),s=o*a,u=p*p-s,h=-p+Math.sqrt(u),{start:0,stop:h/o}):0>p?(o=e.magnitudeSquared(w),{start:0,stop:-p/o}):void 0};var d=new e,w=new e,m=new e,p=new e;f.grazingAltitudeLocation=function(o,s){if(!r(o))throw new n("ray is required.");if(!r(s))throw new n("ellipsoid is required.");var u=o.origin,f=o.direction,c=s.geodeticSurfaceNormal(u);if(e.dot(f,c)>=0)return u;var l,y,v=r(this.rayEllipsoid(o,s)),g=s.transformPositionToScaledSpace(f),q=e.normalize(g,d),x=e.mostOrthogonalAxis(g,p),E=e.normalize(e.cross(x,q,w),w),b=e.normalize(e.cross(q,E,m),m),S=new a(q.x,E.x,b.x,q.y,E.y,b.y,q.z,E.z,b.z),M=a.transpose(S),_=a.fromScale(s.radii),O=a.fromScale(s.oneOverRadii),P=new a(0,f.z,-f.y,-f.z,0,f.x,f.y,-f.x,0),T=a.multiply(a.multiply(M,O),P),C=a.multiply(a.multiply(T,_),S),N=a.multiplyByVector(T,u),R=h(C,e.negate(N,d),0,0,1),I=R.length;if(I>0){for(var A=e.ZERO,D=Number.NEGATIVE_INFINITY,z=0;I>z;++z){l=a.multiplyByVector(_,a.multiplyByVector(S,R[z]));var U=e.normalize(e.subtract(l,u,p),p),L=e.dot(U,f);L>D&&(D=L,A=l)}var W=s.cartesianToCartographic(A);return D=i.clamp(D,0,1),y=e.magnitude(e.subtract(A,u,p))*Math.sqrt(1-D*D),y=v?-y:y,s.cartographicToCartesian(new t(W.longitude,W.latitude,y))}return void 0};var y=new e;return f.lineSegmentPlane=function(t,a,o,s){if(!r(t))throw new n("endPoint0 is required.");if(!r(a))throw new n("endPoint1 is required.");if(!r(o))throw new n("plane is required.");r(s)||(s=new e);var u=e.subtract(a,t,y),h=o.normal,f=e.dot(h,u);if(Math.abs(f)<i.EPSILON6)return void 0;var c=e.dot(h,t),l=-(o.distance+c)/f;return 0>l||l>1?void 0:(e.multiplyByScalar(u,l,s),e.add(t,s,s),s)},f.trianglePlaneIntersection=function(t,i,a,o){if(!(r(t)&&r(i)&&r(a)&&r(o)))throw new n("p0, p1, p2, and plane are required.");var s=o.normal,u=o.distance,h=e.dot(s,t)+u<0,c=e.dot(s,i)+u<0,l=e.dot(s,a)+u<0,d=0;d+=h?1:0,d+=c?1:0,d+=l?1:0;var w,m;if((1===d||2===d)&&(w=new e,m=new e),1===d){if(h)return f.lineSegmentPlane(t,i,o,w),f.lineSegmentPlane(t,a,o,m),{positions:[t,i,a,w,m],indices:[0,3,4,1,2,4,1,4,3]};if(c)return f.lineSegmentPlane(i,a,o,w),f.lineSegmentPlane(i,t,o,m),{positions:[t,i,a,w,m],indices:[1,3,4,2,0,4,2,4,3]};if(l)return f.lineSegmentPlane(a,t,o,w),f.lineSegmentPlane(a,i,o,m),{positions:[t,i,a,w,m],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===d){if(!h)return f.lineSegmentPlane(i,t,o,w),f.lineSegmentPlane(a,t,o,m),{positions:[t,i,a,w,m],indices:[1,2,4,1,4,3,0,3,4]};if(!c)return f.lineSegmentPlane(a,i,o,w),f.lineSegmentPlane(t,i,o,m),{positions:[t,i,a,w,m],indices:[2,0,4,2,4,3,1,3,4]};if(!l)return f.lineSegmentPlane(t,a,o,w),f.lineSegmentPlane(i,a,o,m),{positions:[t,i,a,w,m],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},f}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(n,i){if(!t(n))throw new r("normal is required.");if(!t(i))throw new r("distance is required.");this.normal=e.clone(n),this.distance=i};return n.fromPointNormal=function(i,a,o){if(!t(i))throw new r("point is required.");if(!t(a))throw new r("normal is required.");var s=-e.dot(a,i);return t(o)?(e.clone(a,o.normal),o.distance=s,o):new n(a,s)},n.getPointDistance=function(n,i){if(!t(n))throw new r("plane is required.");if(!t(i))throw new r("point is required.");return e.dot(n.normal,i)+n.distance},n}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var i=function(r,n){n=e.clone(t(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(t(r,e.ZERO)),this.direction=n};return i.getPoint=function(t,i,a){if(!r(t))throw new n("ray is requred");if("number"!=typeof i)throw new n("t is a required number");return r(a)||(a=new e),a=e.multiplyByScalar(t.direction,i,a),e.add(t.origin,a,a)},i}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,n,i){return t(e).then(r,n,i)}function t(e){var t,r;return e instanceof n?t=e:s(e)?(r=o(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=i(e),t}function r(t){return e(t,a)}function n(e){this.then=e}function i(e){var r=new n(function(r){try{return t(r?r(e):e)}catch(n){return a(n)}});return r}function a(e){var r=new n(function(r,n){try{return n?t(n(e)):a(e)}catch(i){return a(i)}});return r}function o(){function e(e,t,r){return l(e,t,r)}function r(e){return w(e)}function i(e){return w(a(e))}function s(e){return d(e)}var u,h,f,c,l,d,w;return h=new n(e),u={then:e,resolve:r,reject:i,progress:s,promise:h,resolver:{resolve:r,reject:i,progress:s}},f=[],c=[],l=function(e,t,r){var n,i;return n=o(),i="function"==typeof r?function(e){try{n.progress(r(e))}catch(t){n.progress(t)}}:function(e){n.progress(e)},f.push(function(r){r.then(e,t).then(n.resolve,n.reject,i)}),c.push(i),n.promise},d=function(e){return m(c,e),e},w=function(e){return e=t(e),l=e.then,w=t,d=y,m(f,e),c=f=x,e},u}function s(e){return e&&"function"==typeof e.then}function u(t,r,n,i,a){return p(2,arguments),e(t,function(t){function s(e){m(e)}function u(e){w(e)}var h,f,c,l,d,w,m,p,v,g;if(v=t.length>>>0,h=Math.max(0,Math.min(r,v)),c=[],f=v-h+1,l=[],d=o(),h)for(p=d.progress,m=function(e){l.push(e),--f||(w=m=y,d.reject(l))},w=function(e){c.push(e),--h||(w=m=y,d.resolve(c))},g=0;v>g;++g)g in t&&e(t[g],u,s,p);else d.resolve(c);return d.then(n,i,a)})}function h(e,t,r,n){function i(e){return t?t(e[0]):e[0]}return u(e,1,i,r,n)}function f(e,t,r,n){return p(1,arguments),l(e,v).then(t,r,n)}function c(){return l(arguments,v)}function l(t,r){return e(t,function(t){var n,i,a,s,u,h;if(a=i=t.length>>>0,n=[],h=o(),a)for(s=function(t,i){e(t,r).then(function(e){n[i]=e,--a||h.resolve(n)},h.reject)},u=0;i>u;u++)u in t?s(t[u],u):--a;else h.resolve(n);return h.promise})}function d(t,r){var n=q.call(arguments,1);return e(t,function(t){var i;return i=t.length,n[0]=function(t,n,a){return e(t,function(t){return e(n,function(e){return r(t,e,a,i)})})},g.apply(t,n)})}function w(t,r,n){var i=arguments.length>2;return e(t,function(e){return e=i?n:e,r.resolve(e),e},function(e){return r.reject(e),a(e)},r.progress)}function m(e,t){for(var r,n=0;r=e[n++];)r(t)}function p(e,t){for(var r,n=t.length;n>e;)if(r=t[--n],null!=r&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function y(){}function v(e){return e}var g,q,x;return e.defer=o,e.resolve=t,e.reject=r,e.join=c,e.all=f,e.map=l,e.reduce=d,e.any=h,e.some=u,e.chain=w,e.isPromise=s,n.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(x,e)},yield:function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return f(t,function(t){return e.apply(x,t)})})}},q=[].slice,g=[].reduce||function(e){var t,r,n,i,a;if(a=0,t=Object(this),i=t.length>>>0,r=arguments,r.length<=1)for(;;){if(a in t){n=t[a++];break}if(++a>=i)throw new TypeError}else n=r[1];for(;i>a;++a)a in t&&(n=e(n,t[a],a,t));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,t){"use strict";var r=function(r,n,i){if(!e(r))throw new t("array is required.");if(!e(n))throw new t("itemToFind is required.");if(!e(i))throw new t("comparator is required.");for(var a,o,s=0,u=r.length-1;u>=s;)if(a=~~((s+u)/2),o=i(r[a],n),0>o)s=a+1;else{if(!(o>0))return a;u=a-1}return~(u+1)};return r}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,t,r,n,i){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=i};return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],i=function(e,t,r,n){r||(r=" ");var i=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+i:i+e},a=function(e,t,r,n,a,o){var s=n-e.length;
return s>0&&(e=r||!a?i(e,n,o,r):e.slice(0,t.length)+i("",s,"0",!0)+e.slice(t.length)),e},o=function(e,t,r,n,o,s,u){var h=e>>>0;return r=r&&h&&{2:"0b",8:"0",16:"0x"}[t]||"",e=r+i(h.toString(t),s||0,"0",!1),a(e,r,n,o,u)},s=function(e,t,r,n,i,o){return null!=n&&(e=e.slice(0,n)),a(e,"",t,r,i,o)},u=function(e,n,u,h,f,c,l){var d,w,m,p,y;if("%%"==e)return"%";for(var v=!1,g="",q=!1,x=!1,E=" ",b=u.length,S=0;u&&b>S;S++)switch(u.charAt(S)){case" ":g=" ";break;case"+":g="+";break;case"-":v=!0;break;case"'":E=u.charAt(S+1);break;case"0":q=!0;break;case"#":x=!0}if(h=h?"*"==h?+t[r++]:"*"==h.charAt(0)?+t[h.slice(1,-1)]:+h:0,0>h&&(h=-h,v=!0),!isFinite(h))throw new Error("sprintf: (minimum-)width must be finite");switch(c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:"fFeE".indexOf(l)>-1?6:"d"==l?0:void 0,y=n?t[n.slice(0,-1)]:t[r++],l){case"s":return s(String(y),v,h,c,q,E);case"c":return s(String.fromCharCode(+y),v,h,c,q);case"b":return o(y,2,x,v,h,c,q);case"o":return o(y,8,x,v,h,c,q);case"x":return o(y,16,x,v,h,c,q);case"X":return o(y,16,x,v,h,c,q).toUpperCase();case"u":return o(y,10,x,v,h,c,q);case"i":case"d":return d=+y||0,d=Math.round(d-d%1),w=0>d?"-":g,y=w+i(String(Math.abs(d)),c,"0",!1),a(y,w,v,h,q);case"e":case"E":case"f":case"F":case"g":case"G":return d=+y,w=0>d?"-":g,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(l.toLowerCase())],p=["toString","toUpperCase"]["eEfFgG".indexOf(l)%2],y=w+Math.abs(d)[m](c),a(y,w,v,h,q)[p]();default:return e}};return n.replace(e,u)}return e}),define("Core/GregorianDate",[],function(){"use strict";var e=function(e,t,r,n,i,a,o,s){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=i,this.second=a,this.millisecond=o,this.isLeapSecond=s};return e}),define("Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(t){if(null===t||isNaN(t))throw new e("year is required and must be a number.");return 0===t%4&&0!==t%100||0===t%400}return t}),define("Core/LeapSecond",[],function(){"use strict";var e=function(e,t){this.julianDate=e,this.offset=t};return e}),define("Core/TimeConstants",[],function(){"use strict";var e={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e}),define("Core/TimeStandard",[],function(){"use strict";var e={UTC:0,TAI:1};return e}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./defineProperties","./DeveloperError","./GregorianDate","./isArray","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,r,n,i,a,o,s,u,h,f,c){"use strict";function l(e,t){return N.compare(e.julianDate,t.julianDate)}function d(e){q.julianDate=e;var r=N.leapSeconds,n=t(r,q,l);0>n&&(n=~n),n>=r.length&&(n=r.length-1);var i=r[n].offset;if(n>0){var a=N.getSecondsDifference(r[n].julianDate,e);a>i&&(n--,i=r[n].offset)}N.addSeconds(e,i,e)}function w(e,r){q.julianDate=e;var n=N.leapSeconds,i=t(n,q,l);if(0>i&&(i=~i),0===i)return N.addSeconds(e,-n[0].offset,r);if(i>=n.length)return N.addSeconds(e,-n[i-1].offset,r);var a=N.getSecondsDifference(n[i].julianDate,e);return 0===a?N.addSeconds(e,-n[i].offset,r):1>=a?void 0:N.addSeconds(e,-n[--i].offset,r)}function m(e,t,r){var n=0|t/f.SECONDS_PER_DAY;return e+=n,t-=f.SECONDS_PER_DAY*n,0>t&&(e--,t+=f.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function p(e,t,r,n,i,a,o){var s=0|(t-14)/12,u=e+4800+s,h=(0|1461*u/4)+(0|367*(t-2-12*s)/12)-(0|3*((u+100)/100)/4)+r-32075;n-=12,0>n&&(n+=24);var c=a+(n*f.SECONDS_PER_HOUR+i*f.SECONDS_PER_MINUTE+o*f.SECONDS_PER_MILLISECOND);return c>=43200&&(h-=1),[h,c]}var y=new o,v=[31,28,31,30,31,30,31,31,30,31,30,31],g=29,q=new h,x=/^(\d{4})$/,E=/^(\d{4})-(\d{2})$/,b=/^(\d{4})-?(\d{3})$/,S=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,M=/^(\d{4})-?(\d{2})-?(\d{2})$/,_=/([Z+\-])?(\d{2})?:?(\d{2})?$/,O=/^(\d{2})(\.\d+)?/.source+_.source,P=/^(\d{2}):?(\d{2})(\.\d+)?/.source+_.source,T=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+_.source,C="Invalid ISO 8601 date.",N=function(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var i=0|e;t+=(e-i)*f.SECONDS_PER_DAY,m(i,t,this),n===c.UTC&&d(this)};N.fromDate=function(e,t){if(!(e instanceof Date)||isNaN(e.getTime()))throw new a("date must be a valid JavaScript Date.");var r=p(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(m(r[0],r[1],t),d(t),t):new N(r[0],r[1],c.UTC)},N.fromIso8601=function(e,t){if("string"!=typeof e)throw new a(C);e=e.replace(",",".");var r,i,o,s=e.split("T"),h=1,f=1,l=0,w=0,y=0,q=0,_=s[0],R=s[1];if(!n(_))throw new a(C);var I;if(s=_.match(M),null!==s){if(I=_.split("-").length-1,I>0&&2!==I)throw new a(C);r=+s[1],h=+s[2],f=+s[3]}else if(s=_.match(E),null!==s)r=+s[1],h=+s[2];else if(s=_.match(x),null!==s)r=+s[1];else{var A;if(s=_.match(b),null!==s){if(r=+s[1],A=+s[2],o=u(r),1>A||o&&A>366||!o&&A>365)throw new a(C)}else{if(s=_.match(S),null===s)throw new a(C);r=+s[1];var D=+s[2],z=+s[3]||0;if(I=_.split("-").length-1,I>0&&(!n(s[3])&&1!==I||n(s[3])&&2!==I))throw new a(C);var U=new Date(Date.UTC(r,0,4));A=7*D+z-U.getUTCDay()-3}i=new Date(Date.UTC(r,0,1)),i.setUTCDate(A),h=i.getUTCMonth()+1,f=i.getUTCDate()}if(o=u(r),1>h||h>12||1>f||(2!==h||!o)&&f>v[h-1]||o&&2===h&&f>g)throw new a(C);var L;if(n(R)){if(s=R.match(T),null!==s){if(I=R.split(":").length-1,I>0&&2!==I&&3!==I)throw new a(C);l=+s[1],w=+s[2],y=+s[3],q=1e3*+(s[4]||0),L=5}else if(s=R.match(P),null!==s){if(I=R.split(":").length-1,I>0&&1!==I)throw new a(C);l=+s[1],w=+s[2],y=60*+(s[3]||0),L=4}else{if(s=R.match(O),null===s)throw new a(C);l=+s[1],w=60*+(s[2]||0),L=3}if(w>=60||y>=61||l>24||24===l&&(w>0||y>0||q>0))throw new a(C);var W=s[L],B=+s[L+1],F=+(s[L+2]||0);switch(W){case"+":l-=B,w-=F;break;case"-":l+=B,w+=F;break;case"Z":break;default:w+=new Date(Date.UTC(r,h-1,f,l,w)).getTimezoneOffset()}}else w+=new Date(Date.UTC(r,h-1,f)).getTimezoneOffset();var G=60===y;for(G&&y--;w>=60;)w-=60,l++;for(;l>=24;)l-=24,f++;for(i=o&&2===h?g:v[h-1];f>i;)f-=i,h++,h>12&&(h-=12,r++),i=o&&2===h?g:v[h-1];for(;0>w;)w+=60,l--;for(;0>l;)l+=24,f--;for(;1>f;)h--,1>h&&(h+=12,r--),i=o&&2===h?g:v[h-1],f+=i;var V=p(r,h,f,l,w,y,q);return n(t)?(m(V[0],V[1],t),d(t)):t=new N(V[0],V[1],c.UTC),G&&N.addSeconds(t,1,t),t},N.now=function(e){return N.fromDate(new Date,e)};var R=new N(0,0,c.TAI);return N.toGregorianDate=function(e,t){if(!n(e))throw new a("julianDate is required.");var r=!1,i=w(e,R);n(i)||(N.addSeconds(e,-1,R),i=w(R,R),r=!0);var s=i.dayNumber,u=i.secondsOfDay;u>=43200&&(s+=1);var h=0|s+68569,c=0|4*h/146097;h=0|h-(0|(146097*c+3)/4);var l=0|4e3*(h+1)/1461001;h=0|h-(0|1461*l/4)+31;var d=0|80*h/2447,m=0|h-(0|2447*d/80);h=0|d/11;var p=0|d+2-12*h,y=0|100*(c-49)+l+h,v=0|u/f.SECONDS_PER_HOUR,g=u-v*f.SECONDS_PER_HOUR,q=0|g/f.SECONDS_PER_MINUTE;g-=q*f.SECONDS_PER_MINUTE;var x=0|g,E=(g-x)/f.SECONDS_PER_MILLISECOND;return v+=12,v>23&&(v-=24),r&&(x+=1),n(t)?(t.year=y,t.month=p,t.day=m,t.hour=v,t.minute=q,t.second=x,t.millisecond=E,t.isLeapSecond=r,t):new o(y,p,m,v,q,x,E,r)},N.toDate=function(e){if(!n(e))throw new a("julianDate is required.");var t=N.toGregorianDate(e,y),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},N.toIso8601=function(t,r){if(!n(t))throw new a("julianDate is required.");var i,o=N.toGregorianDate(t,o);return n(r)||0===o.millisecond?n(r)&&0!==r?(i=(.01*o.millisecond).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,i)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",o.year,o.month,o.day,o.hour,o.minute,o.second):(i=(.01*o.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,i))},N.clone=function(e,t){return n(e)?n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new N(e.dayNumber,e.secondsOfDay,c.TAI):void 0},N.compare=function(e,t){if(!n(e))throw new a("left is required.");if(!n(t))throw new a("right is required.");var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},N.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},N.equalsEpsilon=function(e,t,r){if(!n(r))throw new a("epsilon is required.");return e===t||n(e)&&n(t)&&Math.abs(N.getSecondsDifference(e,t))<=r},N.getTotalDays=function(e){if(!n(e))throw new a("julianDate is required.");return e.dayNumber+e.secondsOfDay/f.SECONDS_PER_DAY},N.getSecondsDifference=function(e,t){if(!n(e))throw new a("left is required.");if(!n(t))throw new a("right is required.");var r=(e.dayNumber-t.dayNumber)*f.SECONDS_PER_DAY;return r+(e.secondsOfDay-t.secondsOfDay)},N.getDaysDifference=function(e,t){if(!n(e))throw new a("left is required.");if(!n(t))throw new a("right is required.");var r=e.dayNumber-t.dayNumber,i=(e.secondsOfDay-t.secondsOfDay)/f.SECONDS_PER_DAY;return r+i},N.getTaiMinusUtc=function(e){q.julianDate=e;var r=N.leapSeconds,n=t(r,q,l);return 0>n&&(n=~n,--n,0>n&&(n=0)),r[n].offset},N.addSeconds=function(e,t,r){if(!n(e))throw new a("julianDate is required.");if(!n(t))throw new a("seconds is required.");if(!n(r))throw new a("result is required.");return m(e.dayNumber,e.secondsOfDay+t,r)},N.addMinutes=function(e,t,r){if(!n(e))throw new a("julianDate is required.");if(!n(t))throw new a("minutes is required.");if(!n(r))throw new a("result is required.");var i=e.secondsOfDay+t*f.SECONDS_PER_MINUTE;return m(e.dayNumber,i,r)},N.addHours=function(e,t,r){if(!n(e))throw new a("julianDate is required.");if(!n(t))throw new a("hours is required.");if(!n(r))throw new a("result is required.");var i=e.secondsOfDay+t*f.SECONDS_PER_HOUR;return m(e.dayNumber,i,r)},N.addDays=function(e,t,r){if(!n(e))throw new a("julianDate is required.");if(!n(t))throw new a("days is required.");if(!n(r))throw new a("result is required.");var i=e.dayNumber+t;return m(i,e.secondsOfDay,r)},N.lessThan=function(e,t){return N.compare(e,t)<0},N.lessThanOrEquals=function(e,t){return N.compare(e,t)<=0},N.greaterThan=function(e,t){return N.compare(e,t)>0},N.greaterThanOrEquals=function(e,t){return N.compare(e,t)>=0},N.prototype.clone=function(e){return N.clone(this,e)},N.prototype.equals=function(e){return N.equals(this,e)},N.prototype.equalsEpsilon=function(e,t){return N.equalsEpsilon(this,e,t)},N.leapSeconds=[new h(new N(2441317,43210,c.TAI),10),new h(new N(2441499,43211,c.TAI),11),new h(new N(2441683,43212,c.TAI),12),new h(new N(2442048,43213,c.TAI),13),new h(new N(2442413,43214,c.TAI),14),new h(new N(2442778,43215,c.TAI),15),new h(new N(2443144,43216,c.TAI),16),new h(new N(2443509,43217,c.TAI),17),new h(new N(2443874,43218,c.TAI),18),new h(new N(2444239,43219,c.TAI),19),new h(new N(2444786,43220,c.TAI),20),new h(new N(2445151,43221,c.TAI),21),new h(new N(2445516,43222,c.TAI),22),new h(new N(2446247,43223,c.TAI),23),new h(new N(2447161,43224,c.TAI),24),new h(new N(2447892,43225,c.TAI),25),new h(new N(2448257,43226,c.TAI),26),new h(new N(2448804,43227,c.TAI),27),new h(new N(2449169,43228,c.TAI),28),new h(new N(2449534,43229,c.TAI),29),new h(new N(2450083,43230,c.TAI),30),new h(new N(2450630,43231,c.TAI),31),new h(new N(2451179,43232,c.TAI),32),new h(new N(2453736,43233,c.TAI),33),new h(new N(2454832,43234,c.TAI),34),new h(new N(2456109,43235,c.TAI),35)],N}),define("Core/clone",["./defaultValue"],function(e){"use strict";var t=function(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var i=new r.constructor;for(var a in r)if(r.hasOwnProperty(a)){var o=r[a];n&&(o=t(o,n)),i[a]=o}return i};return t}),define("Core/parseResponseHeaders",[],function(){"use strict";var e=function(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var i=r[n],a=i.indexOf(": ");if(a>0){var o=i.substring(0,a),s=i.substring(a+2);t[o]=s}}return t};return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";var r=function(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))};return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent"],function(e,t,r,n,i){"use strict";function a(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function o(e,t){for(var r=a(e,t),n=new ArrayBuffer(r.length),i=new Uint8Array(n),o=0;o<r.length;o++)i[o]=r.charCodeAt(o);return n}function s(e,r){r=t(r,"");var i=e[1],s=!!e[2],u=e[3];switch(r){case"":case"text":return a(s,u);case"arraybuffer":return o(s,u);case"blob":var h=o(s,u);return new Blob([h],{type:i});case"document":var f=new DOMParser;return f.parseFromString(a(s,u),i);case"json":return JSON.parse(a(s,u));default:throw new n("Unhandled responseType: "+r)}}var u=function(i){if(i=t(i,t.EMPTY_OBJECT),!r(i.url))throw new n("options.url is required.");var a=i.responseType,o=t(i.method,"GET"),s=i.data,h=i.headers,f=i.overrideMimeType;return e(i.url,function(t){var r=e.defer();return u.load(t,a,o,s,h,r,f),r.promise})},h=/^data:(.*?)(;base64)?,(.*)$/;return u.load=function(e,t,n,a,o,u,f){var c=h.exec(e);if(null!==c)return u.resolve(s(c,t)),void 0;var l=new XMLHttpRequest;if(r(f)&&l.overrideMimeType(f),l.open(n,e,!0),r(o))for(var d in o)o.hasOwnProperty(d)&&l.setRequestHeader(d,o[d]);r(t)&&(l.responseType=t),l.onload=function(){200===l.status?u.resolve(l.response):u.reject(new i(l.status,l.response,l.getAllResponseHeaders()))},l.onerror=function(){u.reject(new i)},l.send(a)},u.defaultLoad=u.load,u}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";var t=function(t,r){return e({url:t,headers:r})};return t}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,t,r,n){"use strict";var i={Accept:"application/json,*/*;q=0.01"},a=function(a,o){if(!t(a))throw new r("url is required.");return t(o)?t(o.Accept)||(o=e(o),o.Accept=i.Accept):o=i,n(a,o).then(function(e){return JSON.parse(e)})};return a}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,r,n,i,a,o,s,u,h,f,c){"use strict";function l(e,t){return o.compare(e.julianDate,t)}function d(e,r){if(!n(r.columnNames))return e._dataError="Error in loaded EOP data: The columnNames property is required.",void 0;if(!n(r.samples))return e._dataError="Error in loaded EOP data: The samples property is required.",void 0;var i=r.columnNames.indexOf("modifiedJulianDateUtc"),a=r.columnNames.indexOf("xPoleWanderRadians"),u=r.columnNames.indexOf("yPoleWanderRadians"),h=r.columnNames.indexOf("ut1MinusUtcSeconds"),d=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),w=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=r.columnNames.indexOf("taiMinusUtcSeconds");if(0>i||0>a||0>u||0>h||0>d||0>w||0>m)return e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns",void 0;var p=e._samples=r.samples,y=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=a,e._yPoleWanderRadiansColumn=u,e._ut1MinusUtcSecondsColumn=h,e._xCelestialPoleOffsetRadiansColumn=d,e._yCelestialPoleOffsetRadiansColumn=w,e._taiMinusUtcSecondsColumn=m,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var v,g=e._addNewLeapSeconds,q=0,x=p.length;x>q;q+=e._columnCount){var E=p[q+i],b=p[q+m],S=E+f.MODIFIED_JULIAN_DATE_DIFFERENCE,M=new o(S,b,c.TAI);if(y.push(M),g){if(b!==v&&n(v)){var _=o.leapSeconds,O=t(_,M,l);if(0>O){var P=new s(M,b);_.splice(~O,0,P)}}v=b}}}function w(e,t,r,n,i){var a=r*n;i.xPoleWander=t[a+e._xPoleWanderRadiansColumn],i.yPoleWander=t[a+e._yPoleWanderRadiansColumn],i.xPoleOffset=t[a+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=t[a+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=t[a+e._ut1MinusUtcSecondsColumn]}function m(e,t,r){return t+e*(r-t)}function p(e,t,r,n,i,a,s){var u=e._columnCount;if(a>t.length-1)return s.xPoleWander=0,s.yPoleWander=0,s.xPoleOffset=0,s.yPoleOffset=0,s.ut1MinusUtc=0,s;var h=t[i],f=t[a];if(h.equals(f)||n.equals(h))return w(e,r,i,u,s),s;if(n.equals(f))return w(e,r,a,u,s),s;var c=o.getSecondsDifference(n,h)/o.getSecondsDifference(f,h),l=i*u,d=a*u,p=r[l+e._ut1MinusUtcSecondsColumn],y=r[d+e._ut1MinusUtcSecondsColumn],v=y-p;if(v>.5||-.5>v){var g=r[l+e._taiMinusUtcSecondsColumn],q=r[d+e._taiMinusUtcSecondsColumn];g!==q&&(f.equals(n)?p=y:y-=q-g)}return s.xPoleWander=m(c,r[l+e._xPoleWanderRadiansColumn],r[d+e._xPoleWanderRadiansColumn]),s.yPoleWander=m(c,r[l+e._yPoleWanderRadiansColumn],r[d+e._yPoleWanderRadiansColumn]),s.xPoleOffset=m(c,r[l+e._xCelestialPoleOffsetRadiansColumn],r[d+e._xCelestialPoleOffsetRadiansColumn]),s.yPoleOffset=m(c,r[l+e._yCelestialPoleOffsetRadiansColumn],r[d+e._yCelestialPoleOffsetRadiansColumn]),s.ut1MinusUtc=m(c,p,y),s}var y=function(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))d(this,t.data);else if(n(t.url)){var i=this;this._downloadPromise=e(u(t.url),function(e){d(i,e)},function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else d(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return y.NONE=a({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new i(0,0,0,0,0),t}}),y.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},y.prototype.compute=function(e,r){if(!n(this._samples)){if(n(this._dataError))throw new h(this._dataError);return void 0}if(n(r)||(r=new i(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var a=this._dates,s=this._lastIndex,u=0,f=0;if(n(s)){var c=a[s],l=a[s+1],d=o.lessThanOrEquals(c,e),w=!n(l),m=w||o.greaterThanOrEquals(l,e);if(d&&m)return u=s,!w&&l.equals(e)&&++u,f=u+1,p(this,a,this._samples,e,u,f,r),r}var y=t(a,e,o.compare,this._dateColumn);return y>=0?(y<a.length-1&&a[y+1].equals(e)&&++y,u=y,f=y):(f=~y,u=f-1,0>u&&(u=0)),this._lastIndex=u,p(this,a,this._samples,e,u,f,r),r},y}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var r=n.exec(t);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function t(e){var t=unescape(e);return a.test(t)?t:e.toUpperCase()}function r(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,r).replace(i,t)),this.path&&(this.path=this.path.replace(i,t)),this.query&&(this.query=this.query.replace(i,t)),this.fragment&&(this.fragment=this.fragment.replace(i,t))};var i=/%[0-9a-z]{2}/gi,a=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(r.path=t.authority&&""==t.path?"/"+this.path:t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];for(n&&t.shift(),""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?r.pop():"."!=e&&r.push(e);("."==e||".."==e)&&r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,t,r,n){"use strict";function i(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;r>t;++t){var n=e[t].getAttribute("src"),i=c.exec(n);if(null!==i)return i[1]}return void 0}function a(){if(t(u))return u;var n;if(n="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:i(),!t(n))throw new r("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return u=new e(n).resolve(new e(document.location.href))}function o(e){return n.toUrl("../"+e)}function s(t){return new e(t).resolve(a()).toString()}var u,h,f,c=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,l=function(e){t(h)||(h=t(n.toUrl)?o:s),t(f)||(f=document.createElement("a"));var r=h(e);return f.href=r,f.href=f.href,f.href};return l._cesiumScriptRegex=c,l}),define("Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,t,r){this.x=e,this.y=t,this.s=r};return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,t,r,n,i,a,o,s){"use strict";function u(e,t,r){var n=c;return n.dayNumber=t,n.secondsOfDay=r,a.getDaysDifference(n,e._sampleZeroDateTT)}function h(r,i){if(r._chunkDownloadsInProgress[i])return r._chunkDownloadsInProgress[i];var a=e.defer();r._chunkDownloadsInProgress[i]=a;var s,u=r._xysFileUrlTemplate;return s=n(u)?u.replace("{0}",i):t("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json"),e(o(s),function(e){r._chunkDownloadsInProgress[i]=!1;for(var t=r._samples,n=e.samples,o=3*i*r._samplesPerXysFile,s=0,u=n.length;u>s;++s)t[o+s]=n[s];a.resolve()}),a.promise}var f=function(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new a(this._sampleZeroJulianEphemerisDate,0,s.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),i=this._xTable=new Array(t+1),o=Math.pow(this._stepSizeDays,t),u=0;t>=u;++u){n[u]=o,i[u]=u*this._stepSizeDays;for(var h=0;t>=h;++h)h!==u&&(n[u]*=u-h);n[u]=1/n[u]}this._work=new Array(t+1),this._coef=new Array(t+1)},c=new a(0,0,s.TAI);return f.prototype.preload=function(t,r,n,i){var a=u(this,t,r),o=u(this,n,i),s=0|a/this._stepSizeDays-this._interpolationOrder/2;0>s&&(s=0);var f=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;f>=this._totalSamples&&(f=this._totalSamples-1);for(var c=0|s/this._samplesPerXysFile,l=0|f/this._samplesPerXysFile,d=[],w=c;l>=w;++w)d.push(h(this,w));return e.all(d)},f.prototype.computeXysRadians=function(e,t,r){var a=u(this,e,t);if(0>a)return void 0;var o=0|a/this._stepSizeDays;if(o>=this._totalSamples)return void 0;var s=this._interpolationOrder,f=o-(0|s/2);0>f&&(f=0);var c=f+s;c>=this._totalSamples&&(c=this._totalSamples-1,f=c-s,0>f&&(f=0));var l=!1,d=this._samples;if(n(d[3*f])||(h(this,0|f/this._samplesPerXysFile),l=!0),n(d[3*c])||(h(this,0|c/this._samplesPerXysFile),l=!0),l)return void 0;n(r)?(r.x=0,r.y=0,r.s=0):r=new i(0,0,0);var w,m,p=a-f*this._stepSizeDays,y=this._work,v=this._denominators,g=this._coef,q=this._xTable;for(w=0;s>=w;++w)y[w]=p-q[w];for(w=0;s>=w;++w){for(g[w]=1,m=0;s>=m;++m)m!==w&&(g[w]*=y[m]);g[w]*=v[w];var x=3*(f+w);r.x+=g[w]*d[x++],r.y+=g[w]*d[x++],r.s+=g[w]*d[x]}return r},f}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./TimeConstants"],function(e,t,r,n,i,a,o,s,u,h,f,c,l,d,w,m,p){"use strict";var y={},v=new r,g=new r,q=new r;y.eastNorthUpToFixedFrame=function(e,t,n){if(!a(e))throw new o("origin is required.");if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var s=d.sign(e.z);return a(n)?(n[0]=0,n[1]=1,n[2]=0,n[3]=0,n[4]=-s,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=s,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(0,-s,0,e.x,1,0,0,e.y,0,0,s,e.z,0,0,0,1)}var u=v,f=g,c=q;return t=i(t,h.WGS84),t.geodeticSurfaceNormal(e,u),f.x=-e.y,f.y=e.x,f.z=0,r.normalize(f,f),r.cross(u,f,c),a(n)?(n[0]=f.x,n[1]=f.y,n[2]=f.z,n[3]=0,n[4]=c.x,n[5]=c.y,n[6]=c.z,n[7]=0,n[8]=u.x,n[9]=u.y,n[10]=u.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(f.x,c.x,u.x,e.x,f.y,c.y,u.y,e.y,f.z,c.z,u.z,e.z,0,0,0,1)};var x=new r,E=new r,b=new r;y.northEastDownToFixedFrame=function(e,t,n){if(!a(e))throw new o("origin is required.");if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var s=d.sign(e.z);return a(n)?(n[0]=-s,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=1,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=-s,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(-s,0,0,e.x,0,1,0,e.y,0,0,-s,e.z,0,0,0,1)}var u=x,f=E,c=b;return t=i(t,h.WGS84),t.geodeticSurfaceNormal(e,u),f.x=-e.y,f.y=e.x,f.z=0,r.normalize(f,f),r.cross(u,f,c),a(n)?(n[0]=c.x,n[1]=c.y,n[2]=c.z,n[3]=0,n[4]=f.x,n[5]=f.y,n[6]=f.z,n[7]=0,n[8]=-u.x,n[9]=-u.y,n[10]=-u.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(c.x,f.x,-u.x,e.x,c.y,f.y,-u.y,e.y,c.z,f.z,-u.z,e.z,0,0,0,1)};var S=24110.54841,M=8640184.812866,_=.093104,O=-62e-7,P=1.1772758384668e-19,T=72921158553e-15,C=d.TWO_PI/86400,N=new l;y.computeTemeToPseudoFixedMatrix=function(e,t){if(!a(e))throw new o("date is required.");N=l.addSeconds(e,-l.getTaiMinusUtc(e),N);var r,n=N.dayNumber,i=N.secondsOfDay,s=n-2451545;r=i>=43200?(s+.5)/p.DAYS_PER_JULIAN_CENTURY:(s-.5)/p.DAYS_PER_JULIAN_CENTURY;var u=S+r*(M+r*(_+r*O)),h=u*C%d.TWO_PI,f=T+P*(n-2451545.5),c=(i+.5*p.SECONDS_PER_DAY)%p.SECONDS_PER_DAY,m=h+f*c,y=Math.cos(m),v=Math.sin(m);return a(t)?(t[0]=y,t[1]=-v,t[2]=0,t[3]=v,t[4]=y,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new w(y,v,0,-v,y,0,0,0,1)},y.iau2006XysData=new f,y.earthOrientationParameters=s.NONE;var R=32.184,I=2451545;y.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+R,i=t.stop.dayNumber,a=t.stop.secondsOfDay+R,o=y.iau2006XysData.preload(r,n,i,a),s=y.earthOrientationParameters.getPromiseToLoad();return e.all([o,s])},y.computeIcrfToFixedMatrix=function(e,t){if(!a(e))throw new o("date is required.");var r=y.computeFixedToIcrfMatrix(e,t);return a(r)?w.transpose(r,t):void 0};var A=new c(0,0,0),D=new u(0,0,0,0,0,0),z=new w,U=new w;y.computeFixedToIcrfMatrix=function(e,t){if(!a(e))throw new o("date is required.");var r=y.earthOrientationParameters.compute(e,D);if(!a(r))return void 0;var n=e.dayNumber,i=e.secondsOfDay+R,s=y.iau2006XysData.computeXysRadians(n,i,A);if(!a(s))return void 0;var u=s.x+r.xPoleOffset,h=s.y+r.yPoleOffset,f=1/(1+Math.sqrt(1-u*u-h*h)),c=z;c[0]=1-f*u*u,c[3]=-f*u*h,c[6]=u,c[1]=-f*u*h,c[4]=1-f*h*h,c[7]=h,c[2]=-u,c[5]=-h,c[8]=1-f*(u*u+h*h);var m=w.fromRotationZ(-s.s,U),v=w.multiply(c,m,z),g=e.dayNumber,q=e.secondsOfDay-l.getTaiMinusUtc(e)+r.ut1MinusUtc,x=g-2451545,E=q/p.SECONDS_PER_DAY,b=.779057273264+E+.00273781191135448*(x+E);b=b%1*d.TWO_PI;var S=w.fromRotationZ(b,U),M=w.multiply(v,S,z),_=Math.cos(r.xPoleWander),O=Math.cos(r.yPoleWander),P=Math.sin(r.xPoleWander),T=Math.sin(r.yPoleWander),C=n-I+i/p.SECONDS_PER_DAY;C/=36525;var N=-47e-6*C*d.RADIANS_PER_DEGREE/3600,L=Math.cos(N),W=Math.sin(N),B=U;return B[0]=_*L,B[1]=_*W,B[2]=P,B[3]=-O*W+T*P*L,B[4]=O*L+T*P*W,B[5]=-T*_,B[6]=-T*W-O*P*L,B[7]=T*L-O*P*W,B[8]=O*_,w.multiply(M,B,t)};var L=new n;return y.pointToWindowCoordinates=function(e,r,i,s){if(!a(e))throw new o("modelViewProjectionMatrix is required.");if(!a(r))throw new o("viewportTransformation is required.");if(!a(i))throw new o("point is required.");a(s)||(s=new t);var u=L;return m.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,u),u),n.multiplyByScalar(u,1/u.w,u),m.multiplyByVector(r,u,u),t.fromCartesian4(u,s)},y}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,r,n,i,a,o,s,u,h,f,c,l){"use strict";var d=function(e,t){if(!i(e))throw new o("origin is required.");if(t=n(t,s.WGS84),e=t.scaleToGeodeticSurface(e),!i(e))throw new o("origin must not be at the center of the ellipsoid.");var a=l.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=r.fromCartesian4(h.getColumn(a,0)),this._yAxis=r.fromCartesian4(h.getColumn(a,1));var u=r.fromCartesian4(h.getColumn(a,2));this._plane=f.fromPointNormal(e,u)};a(d.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}}});var w=new e;d.fromPoints=function(t,r){if(!i(t))throw new o("cartesians is required.");var n=e.fromPoints(t,w);return new d(n.center,r)};var m=new c,p=new r;d.prototype.projectPointOntoPlane=function(e,n){if(!i(e))throw new o("cartesian is required.");var a=m;a.origin=e,r.normalize(e,a.direction);var s=u.rayPlane(a,this._plane,p);if(i(s)||(r.negate(a.direction,a.direction),s=u.rayPlane(a,this._plane,p)),i(s)){var h=r.subtract(s,this._origin,s),f=r.dot(this._xAxis,h),c=r.dot(this._yAxis,h);return i(n)?(n.x=f,n.y=c,n):new t(f,c)}return void 0},d.prototype.projectPointsOntoPlane=function(e,t){if(!i(e))throw new o("cartesians is required.");i(t)||(t=[]);for(var r=0,n=e.length,a=0;n>a;a++){var s=this.projectPointOntoPlane(e[a],t[r]);i(s)&&(t[r]=s,r++)}return t.length=r,t};var y=new r;return d.prototype.projectPointsOntoEllipsoid=function(e,t){if(!i(e))throw new o("cartesians is required.");var n=e.length;i(t)?t.length=n:t=new Array(n);for(var a=this._ellipsoid,s=this._origin,u=this._xAxis,h=this._yAxis,f=y,c=0;n>c;++c){var l=e[c];r.multiplyByScalar(u,l.x,f),i(t[c])||(t[c]=new r);
var d=r.add(s,f,t[c]);r.multiplyByScalar(h,l.y,f),r.add(d,f,d),a.scaleToGeocentricSurface(d,d)}return t},d}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var i=new t,a=new t,o=new t,s=function(s,u,h,f,c){if(!(r(s)&&r(u)&&r(h)&&r(f)))throw new n("point, p0, p1, and p2 are required.");r(c)||(c=new t);var l,d,w,m,p,y,v,g;r(u.z)?(l=t.subtract(h,u,i),d=t.subtract(f,u,a),w=t.subtract(s,u,o),m=t.dot(l,l),p=t.dot(l,d),y=t.dot(l,w),v=t.dot(d,d),g=t.dot(d,w)):(l=e.subtract(h,u,i),d=e.subtract(f,u,a),w=e.subtract(s,u,o),m=e.dot(l,l),p=e.dot(l,d),y=e.dot(l,w),v=e.dot(d,d),g=e.dot(d,w));var q=1/(m*v-p*p);return c.y=(v*y-p*g)*q,c.z=(m*g-p*y)*q,c.x=1-c.y-c.z,c};return s}),define("Core/pointInsideTriangle",["./barycentricCoordinates","./Cartesian3"],function(e,t){"use strict";var r=new t,n=function(t,n,i,a){return e(t,n,i,a,r),r.x>0&&r.y>0&&r.z>0};return n}),define("Core/Queue",[],function(){"use strict";var e=function(){this._array=[],this._offset=0,this.length=0};return e.prototype.enqueue=function(e){this._array.push(e),this.length++},e.prototype.dequeue=function(){if(0===this.length)return void 0;var e=this._array,t=this._offset,r=e[t];return e[t]=void 0,t++,t>10&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this.length--,r},e.prototype.contains=function(e){return-1!==this._array.indexOf(e)},e.prototype.clear=function(){this._array.length=this._offset=this.length=0},e.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},e}),define("Core/WindingOrder",[],function(){"use strict";var e={CLOCKWISE:2304,COUNTER_CLOCKWISE:2305,validate:function(t){return t===e.CLOCKWISE||t===e.COUNTER_CLOCKWISE}};return e}),define("Core/PolygonPipeline",["./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./Math","./pointInsideTriangle","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,r,n,i,a,o,s,u,h,f,c,l,d,w){"use strict";function m(t,r,n){var i=e.subtract(r,t,L),a=e.subtract(n,r,W);return i.x*a.y-i.y*a.x>=0}function p(e){for(var t=e[0].x,r=0,n=0;n<e.length;n++)e[n].x>t&&(t=e[n].x,r=n);return r}function y(e){for(var t=e[0][0].x,r=0,n=0;n<e.length;n++){var i=e[n][p(e[n])].x;i>t&&(t=i,r=n)}return r}function v(e){for(var t=[],r=0;r<e.length;r++){var n=e[(r-1+e.length)%e.length],i=e[r],a=e[(r+1)%e.length];m(n,i,a)||t.push(i)}return t}function g(t,r){for(var n=0;n<t.length;n++)if(e.equals(r,t[n]))return n;return-1}function q(r,i,a){a=n(a,[]);var o=Number.MAX_VALUE,s=p(i),u=new e(i[s].x,r.y);a.push(s),a.push((s+1)%i.length);for(var h=i[0].x,f=h,c=1;c<i.length;++c)i[c].x<h?h=i[c].x:i[c].x>f&&(f=i[c].x);f+=f-h;var l=new t(f,r.y,0);for(c=0;c<i.length;c++){var d=i[c],w=i[(c+1)%i.length];if((d.x>=r.x||w.x>=r.x)&&(d.y>=r.y&&w.y<=r.y||d.y<=r.y&&w.y>=r.y)){var m=(w.y-d.y)*(l.x-r.x)-(w.x-d.x)*(l.y-r.y);if(0!==m){m=1/m;var y=((w.x-d.x)*(r.y-d.y)-(w.y-d.y)*(r.x-d.x))*m,v=((l.x-r.x)*(r.y-d.y)-(l.y-r.y)*(r.x-d.x))*m;if(y>=0&&1>=y&&v>=0&&1>=v){var g=new e(r.x+y*(l.x-r.x),r.y+y*(l.y-r.y)),q=e.subtract(g,r,B);m=e.magnitudeSquared(q),o>m&&(u=g,o=m,a[0]=c,a[1]=(c+1)%i.length)}}}}return u}function x(t,r){var n=y(r),i=r[n],a=p(i),o=i[a],s=[],u=q(o,t,s),h=g(t,u);if(-1!==h)return h;var l=e.magnitudeSquared(e.subtract(t[s[0]],o,F)),d=e.magnitudeSquared(e.subtract(t[s[1]],o,F)),w=d>l?t[s[0]]:t[s[1]],m=v(t),x=m.indexOf(w);-1!==x&&m.splice(x,1);for(var E=[],b=0;b<m.length;b++){var S=m[b];c(S,o,u,w)&&E.push(S)}var M=Number.MAX_VALUE;if(E.length>0){var _=e.fromElements(1,0,F);for(b=0;b<E.length;b++){var O=e.subtract(E[b],o,G),P=e.magnitude(_)*e.magnitudeSquared(O);if(0!==P){var T=Math.abs(f.acosClamped(e.dot(_,O)/P));M>T&&(M=T,w=E[b])}}}return t.indexOf(w)}function E(e,r,n){for(var i=st.computeWindingOrder2D(e),a=0;a<r.length;a++){var o=r[a];t.equals(o[0],o[o.length-1])||o.push(o[0]);var u=st.computeWindingOrder2D(o);u===i&&o.reverse()}var h=s.fromPoints(e,n),f=h.projectPointsOntoPlane(e),c=[];for(a=0;a<r.length;a++)c.push(h.projectPointsOntoPlane(r[a]));var l=x(f,c),d=y(c),w=p(c[d]),m=r[d],v=[];for(a=0;a<e.length;a++)v.push(e[a]);var g,q=[];if(0!==w)for(g=0;g<=m.length;g++){var E=(g+w)%m.length;0!==E&&q.push(m[E])}else for(g=0;g<m.length;g++)q.push(m[(g+w)%m.length]);var b=v.lastIndexOf(e[l]);q.push(e[b]);var S=v.slice(0,b+1),M=v.slice(b+1);return v=S.concat(q,M),r.splice(d,1),v}function b(e){var t="0."+Math.sin(V).toString().substr(5);V+=.2;var r=Math.floor(t*e);return r===e&&r--,r}function S(t,r,n){return M(t,r,n)&&M(r,t,n)&&!A(n[t].position,n[r].position,n)&&!e.equals(n[t].position,n[r].position)}function M(t,r,n){P(t,n);var i=n[t],a=n[r],o=O(t,n,Y),s=O(t,n,j),u=e.subtract(n[o].position,i.position,H),h=e.subtract(n[s].position,i.position,k),f=e.subtract(a.position,i.position,X);return T(u,f)?_(u,f):T(h,f)?_(h,f):C(u,h)?I(u,h,f)?!0:!1:N(u,h)?R(u,h,f)?!1:!0:void 0}function _(t,r){return e.magnitude(r)<e.magnitude(t)}function O(e,t,r){var n=e+r;return 0>n&&(n=t.length-1),n===t.length&&(n=0),P(n,t),n}function P(t,r){var n=t-1,i=t+1;0>n&&(n=r.length-1),i===r.length&&(i=0);var o=e.subtract(r[n].position,r[t].position,Z),s=e.subtract(r[i].position,r[t].position,J);if(T(o,s)){var u=new a("Superfluous vertex found.");throw u.vertexIndex=t,u}}function T(e,r){return 0===t.cross(e,r,K).z}function C(e,r){return t.cross(e,r,$).z<0}function N(e,r){return t.cross(e,r,Q).z>0}function R(e,r,n){return t.cross(e,n,et).z>0&&t.cross(n,r,et).z>0}function I(e,r,n){return t.cross(e,n,tt).z<0&&t.cross(n,r,tt).z<0}function A(t,r,n){for(var i=0;i<n.length;i++){var a,o=n[i].position;if(a=i<n.length-1?n[i+1].position:n[0].position,!(e.equals(t,o)||e.equals(r,a)||e.equals(t,a)||e.equals(r,o))){var s=(r.y-t.y)/(r.x-t.x),u=(a.y-o.y)/(a.x-o.x);if(!(s===u||isNaN(s)&&isNaN(u))){var h;h=isNaN(s)?t.x:isNaN(u)?o.x:(t.y-o.y-s*t.x+u*o.x)/(u-s);var f=s*h+t.y-s*t.x,c=e.fromElements(h,f,rt);if(!(e.equals(c,t)||e.equals(c,r)||e.equals(c,o)||e.equals(c,a))){var l=z(h,t.x,r.x)&&z(f,t.y,r.y)&&z(h,o.x,a.x)&&z(f,o.y,a.y);if(l)return!0}}}}return!1}function D(t){var r=t[0].position,n=t[1].position,i=t[2].position,a=e.subtract(n,r,nt),o=e.subtract(i,r,it);return T(a,o)}function z(e,t,r){return(e>t||e>r)&&(t>e||r>e)||t===r&&t===e}function U(e){var t=e.length;if(3===t)return D(e)?[]:[e[0].index,e[1].index,e[2].index];if(e.length<3)throw new a("Invalid polygon: must have at least three vertices.");for(var r=!1,n=0;!r;){var i=10*e.length;if(n>i)return[];n++;for(var o=b(e.length),s=o+1;Math.abs(o-s)<2||Math.abs(o-s)>e.length-2;)s=b(e.length);if(o>s){var u=o;o=s,s=u}try{if(S(o,s,e)){var h=e.splice(o,s-o+1,e[o],e[s]);return U(e).concat(U(h))}}catch(f){if(f.hasOwnProperty("vertexIndex"))return e.splice(f.vertexIndex,1),U(e);throw f}}}var L=new e,W=new e,B=new e,F=new e(1,0),G=new e,V=0,Y=-1,j=1,H=new t,k=new t,X=new t,Z=new t,J=new t,K=new t,$=new t,Q=new t,et=new t,tt=new t,rt=new e,nt=new t,it=new t,at=new t,ot=new t,st={};return st.removeDuplicates=function(e){if(!i(e))throw new a("positions is required.");if(e.length<3)throw new a("At least three positions are required.");for(var r=e.length,n=[],o=r-1,s=0;r>s;o=s++){var u=e[o],h=e[s];t.equals(u,h)||n.push(h)}return n},st.computeArea2D=function(e){if(!i(e))throw new a("positions is required.");if(e.length<3)throw new a("At least three positions are required.");for(var t=e.length,r=0,n=t-1,o=0;t>o;n=o++){var s=e[n],u=e[o];r+=s.x*u.y-u.x*s.y}return.5*r},st.computeWindingOrder2D=function(e){var t=st.computeArea2D(e);return t>0?w.COUNTER_CLOCKWISE:w.CLOCKWISE},st.triangulate=function(e){if(!i(e))throw new a("positions is required.");if(e.length<3)throw new a("At least three positions are required.");for(var t=e.length,r=[],n=0;t>n;++n)r[n]={position:e[n],index:n};return U(r)},st.resetSeed=function(e){V=n(e,0)},st.computeSubdivision=function(e,o,s){if(s=n(s,f.RADIANS_PER_DEGREE),!i(e))throw new a("positions is required.");if(!i(o))throw new a("indices is required.");if(o.length<3)throw new a("At least three indices are required.");if(0!==o.length%3)throw new a("The number of indices must be divisable by three.");if(0>=s)throw new a("granularity must be greater than zero.");for(var c=new d,w=o.length,m=0;w>m;m+=3)c.enqueue({i0:o[m],i1:o[m+1],i2:o[m+2]});for(var p,y=e.slice(0),v=[],g={};c.length>0;){var q,x,E=c.dequeue(),b=y[E.i0],S=y[E.i1],M=y[E.i2],_=t.angleBetween(b,S),O=t.angleBetween(S,M),P=t.angleBetween(M,b),T=Math.max(_,Math.max(O,P));T>s?_===T?(q=Math.min(E.i0,E.i1).toString()+" "+Math.max(E.i0,E.i1).toString(),p=g[q],p||(x=t.add(b,S,new t),t.multiplyByScalar(x,.5,x),y.push(x),p=y.length-1,g[q]=p),c.enqueue({i0:E.i0,i1:p,i2:E.i2}),c.enqueue({i0:p,i1:E.i1,i2:E.i2})):O===T?(q=Math.min(E.i1,E.i2).toString()+" "+Math.max(E.i1,E.i2).toString(),p=g[q],p||(x=t.add(S,M,new t),t.multiplyByScalar(x,.5,x),y.push(x),p=y.length-1,g[q]=p),c.enqueue({i0:E.i1,i1:p,i2:E.i0}),c.enqueue({i0:p,i1:E.i2,i2:E.i0})):P===T&&(q=Math.min(E.i2,E.i0).toString()+" "+Math.max(E.i2,E.i0).toString(),p=g[q],p||(x=t.add(M,b,new t),t.multiplyByScalar(x,.5,x),y.push(x),p=y.length-1,g[q]=p),c.enqueue({i0:E.i2,i1:p,i2:E.i1}),c.enqueue({i0:p,i1:E.i0,i2:E.i1})):(v.push(E.i0),v.push(E.i1),v.push(E.i2))}var C=y.length,N=new Array(3*C),R=0;for(p=0;C>p;p++){var I=y[p];N[R++]=I.x,N[R++]=I.y,N[R++]=I.z}return new u({attributes:{position:new h({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:N})},indices:v,primitiveType:l.TRIANGLES})},st.scaleToGeodeticHeight=function(e,r,a,s){a=n(a,o.WGS84);var u=at,h=ot;if(r=n(r,0),s=n(s,!0),i(e)&&i(e.attributes)&&i(e.attributes.position))for(var f=e.attributes.position.values,c=f.length,l=0;c>l;l+=3)t.fromArray(f,l,h),s&&(h=a.scaleToGeodeticSurface(h,h)),u=a.geodeticSurfaceNormal(h,u),t.multiplyByScalar(u,r,u),t.add(h,u,h),f[l]=h.x,f[l+1]=h.y,f[l+2]=h.z;return e},st.eliminateHoles=function(e,r,s){if(!i(e))throw new a("outerRing is required.");if(0===e.length)throw new a("outerRing must not be empty.");if(!i(r))throw new a("innerRings is required.");s=n(s,o.WGS84);for(var u=[],h=0;h<r.length;h++){for(var f=[],c=0;c<r[h].length;c++)f.push(t.clone(r[h][c]));u.push(f)}for(var l=e;u.length>0;)l=E(l,u,s);return l},st}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,r,n,i,a,o,s){"use strict";function u(e){var t=e._uSquared,r=e._ellipsoid.maximumRadius,n=e._ellipsoid.minimumRadius,i=(r-n)/r,a=Math.cos(e._startHeading),o=Math.sin(e._startHeading),s=(1-i)*Math.tan(e._start.latitude),u=1/Math.sqrt(1+s*s),h=u*s,f=Math.atan2(s,a),c=u*o,l=c*c,d=1-l,w=Math.sqrt(d),m=t/4,p=m*m,y=p*m,v=p*p,g=1+m-3*p/4+5*y/4-175*v/64,q=1-m+15*p/8-35*y/8,x=1-3*m+35*p/4,E=1-5*m,b=g*f-q*Math.sin(2*f)*m/2-x*Math.sin(4*f)*p/16-E*Math.sin(6*f)*y/48-5*Math.sin(8*f)*v/512,S=e._constants;S.a=r,S.b=n,S.f=i,S.cosineHeading=a,S.sineHeading=o,S.tanU=s,S.cosineU=u,S.sineU=h,S.sigma=f,S.sineAlpha=c,S.sineSquaredAlpha=l,S.cosineSquaredAlpha=d,S.cosineAlpha=w,S.u2Over4=m,S.u4Over16=p,S.u6Over64=y,S.u8Over256=v,S.a0=g,S.a1=q,S.a2=x,S.a3=E,S.distanceRatio=b}function h(e,t){return e*t*(4+e*(4-3*t))/16}function f(e,t,r,n,i,a,o){var s=h(e,r);return(1-s)*e*t*(n+s*i*(o+s*a*(2*o*o-1)))}function c(e,t,r,n,i,a,o){var u,h,c,l,d,w=(t-r)/t,m=a-n,p=Math.atan((1-w)*Math.tan(i)),y=Math.atan((1-w)*Math.tan(o)),v=Math.cos(p),g=Math.sin(p),q=Math.cos(y),x=Math.sin(y),E=v*q,b=v*x,S=g*x,M=g*q,_=m,O=s.TWO_PI,P=Math.cos(_),T=Math.sin(_);do{P=Math.cos(_),T=Math.sin(_);var C=b-M*P;c=Math.sqrt(q*q*T*T+C*C),h=S+E*P,u=Math.atan2(c,h);var N;0===c?(N=0,l=1):(N=E*T/c,l=1-N*N),O=_,d=h-2*S/l,isNaN(d)&&(d=0),_=m+f(w,N,l,u,c,h,d)}while(Math.abs(_-O)>s.EPSILON12);var R=l*(t*t-r*r)/(r*r),I=1+R*(4096+R*(R*(320-175*R)-768))/16384,A=R*(256+R*(R*(74-47*R)-128))/1024,D=d*d,z=A*c*(d+A*(h*(2*D-1)-A*d*(4*c*c-3)*(4*D-3)/6)/4),U=r*I*(u-z),L=Math.atan2(q*T,b-M*P),W=Math.atan2(v*T,b*P-M);e._distance=U,e._startHeading=L,e._endHeading=W,e._uSquared=R}function l(r,n,i,o){var s=e.normalize(o.cartographicToCartesian(n,w),d),h=e.normalize(o.cartographicToCartesian(i,w),w);if(Math.abs(Math.abs(e.angleBetween(s,h))-Math.PI)<.0125)throw new a("geodesic position is not unique");c(r,o.maximumRadius,o.minimumRadius,n.longitude,n.latitude,i.longitude,i.latitude),n.height=0,i.height=0,r._start=t.clone(n,r._start),r._end=t.clone(i,r._end),u(r)}var d=new e,w=new e,m=function(e,i,a){var s=r(a,o.WGS84);this._ellipsoid=s,this._start=new t,this._end=new t,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,n(e)&&n(i)&&l(this,e,i,s)};return i(m.prototype,{surfaceDistance:{get:function(){if(!n(this._distance))throw new a("set end positions before getting surfaceDistance");return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){if(!n(this._distance))throw new a("set end positions before getting startHeading");return this._startHeading}},endHeading:{get:function(){if(!n(this._distance))throw new a("set end positions before getting endHeading");return this._endHeading}}}),m.prototype.setEndPoints=function(e,t){if(!n(e))throw new a("start cartographic position is required");if(!n(t))throw new a("end cartgraphic position is required");l(this,e,t,this._ellipsoid)},m.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},m.prototype.interpolateUsingSurfaceDistance=function(e,r){if(!n(this._distance))throw new a("start and end must be set before calling funciton interpolateUsingSurfaceDistance");var i=this._constants,o=i.distanceRatio+e/i.b,s=Math.cos(2*o),u=Math.cos(4*o),h=Math.cos(6*o),c=Math.sin(2*o),l=Math.sin(4*o),d=Math.sin(6*o),w=Math.sin(8*o),m=o*o,p=o*m,y=i.u8Over256,v=i.u2Over4,g=i.u6Over64,q=i.u4Over16,x=2*p*y*s/3+o*(1-v+7*q/4-15*g/4+579*y/64-(q-15*g/4+187*y/16)*s-(5*g/4-115*y/16)*u-29*y*h/16)+(v/2-q+71*g/32-85*y/16)*c+(5*q/16-5*g/4+383*y/96)*l-m*((g-11*y/2)*c+5*y*l/2)+(29*g/96-29*y/16)*d+539*y*w/1536,E=Math.asin(Math.sin(x)*i.cosineAlpha),b=Math.atan(i.a/i.b*Math.tan(E));x-=i.sigma;var S=Math.cos(2*i.sigma+x),M=Math.sin(x),_=Math.cos(x),O=i.cosineU*_,P=i.sineU*M,T=Math.atan2(M*i.sineHeading,O-P*i.cosineHeading),C=T-f(i.f,i.sineAlpha,i.cosineSquaredAlpha,x,M,_,S);return n(r)?(r.longitude=this._start.longitude+C,r.latitude=b,r.height=0,r):new t(this._start.longitude+C,b,0)},m}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,t,r,n,i,a,o,s,u,h,f,c){"use strict";function l(t,r,n,i){var a=i.scaleToGeodeticSurface(t,_),o=i.scaleToGeodeticSurface(r,O),s=e.angleBetween(a,o),u=Math.ceil(s/n),h=new Array(3*u),f=i.cartesianToCartographic(a,b),c=i.cartesianToCartographic(o,S);P.setEndPoints(f,c);var l=P.surfaceDistance/u,d=0;f.height=0;var w=i.cartographicToCartesian(f,M);h[d++]=w.x,h[d++]=w.y,h[d++]=w.z;for(var m=1;u>m;m++){var p=P.interpolateUsingSurfaceDistance(m*l,S);w=i.cartographicToCartesian(p,M),h[d++]=w.x,h[d++]=w.y,h[d++]=w.z}return h}function d(t,r,n){var i=T;return n.geodeticSurfaceNormal(t,i),e.multiplyByScalar(i,r,i),e.add(t,i,t),t}var w={},m=new f,p=new e,y=new e,v=new c(e.ZERO,0),g=new e,q=new c(e.ZERO,0),x=new e,E=new e,b=new t,S=new t,M=new e,_=new e,O=new e,P=new o,T=new e,C=new e;return w.wrapLongitude=function(t,i){var a=[],o=[];if(n(t)&&t.length>0){i=r(i,f.IDENTITY);var u=f.inverseTransformation(i,m),h=f.multiplyByPoint(u,e.ZERO,p),l=f.multiplyByPointAsVector(u,e.UNIT_Y,y),d=c.fromPointNormal(h,l,v),w=f.multiplyByPointAsVector(u,e.UNIT_X,g),b=c.fromPointNormal(h,w,q),S=1;a.push(e.clone(t[0]));for(var M=a[0],_=t.length,O=1;_>O;++O){var P=t[O];if(c.getPointDistance(b,M)<0||c.getPointDistance(b,P)<0){var T=s.lineSegmentPlane(M,P,d,x);if(n(T)){var C=e.multiplyByScalar(l,5e-9,E);c.getPointDistance(d,M)<0&&e.negate(C,C),a.push(e.add(T,C,new e)),o.push(S+1),e.negate(C,C),a.push(e.add(T,C,new e)),S=1}}a.push(e.clone(t[O])),S++,M=P}o.push(S)}return{positions:a,lengths:o}},w.removeDuplicates=function(t){if(!n(t))throw new i("positions is required.");var r=t.length;if(2>r)return t.slice(0);var a=[];a.push(t[0]);for(var o=1;r>o;++o){var s=t[o-1],u=t[o];e.equals(s,u)||a.push(u)}return a},w.scaleToSurface=function(e,t,o){if(!n(e))throw new i("positions is required");t=r(t,h.RADIANS_PER_DEGREE),o=r(o,a.WGS84);for(var s=e.length,u=[],f=0;s-1>f;f++){var c=e[f],d=e[f+1];u=u.concat(l(c,d,t,o))}var w=e[s-1],m=o.cartesianToCartographic(w,b);m.height=0;var p=o.cartographicToCartesian(m,M);return u.push(p.x,p.y,p.z),u},w.scaleToGeodeticHeight=function(t,o,s,h){if(!n(t))throw new i("positions must be defined.");if(!n(o))throw new i("height must be defined");s=r(s,a.WGS84);var f,c,l=t.length,w=C;if(n(h)){if(h.length!==t.length)throw new i("result.length must be equal to positions.length");c=h}else c=new Array(t.length);if(0===o){for(f=0;l>f;f+=3)w=s.scaleToGeodeticSurface(e.fromArray(t,f,w),w),c[f]=w.x,c[f+1]=w.y,c[f+2]=w.z;return c}var m;if(u(o)){if(o.length!==l/3)throw new i("height.length must be equal to positions.length");for(f=0;l>f;f+=3)m=o[f/3],w=e.fromArray(t,f,w),w=d(w,m,s),c[f]=w.x,c[f+1]=w.y,c[f+2]=w.z}else for(m=o,f=0;l>f;f+=3)w=e.fromArray(t,f,w),w=d(w,m,s),c[f]=w.x,c[f+1]=w.y,c[f+2]=w.z;return c},w}),define("Core/WallGeometryLibrary",["./Cartesian3","./Cartographic","./defined","./DeveloperError","./EllipsoidTangentPlane","./Math","./PolygonPipeline","./PolylinePipeline","./WindingOrder"],function(e,t,r,n,i,a,o,s,u){"use strict";function h(t,r,n,i,a){var o,s=e.angleBetween(t,r),u=Math.ceil(s/a),h=new Array(u);if(n===i){for(o=0;u>o;o++)h[o]=n;return h}var f=i-n,c=f/u;for(o=1;u>o;o++){var l=n+o*c;h[o]=l}return h[0]=n,h}function f(e,t){return a.equalsEpsilon(e.latitude,t.latitude,a.EPSILON14)&&a.equalsEpsilon(e.longitude,t.longitude,a.EPSILON14)}function c(e,n,i,a){var o=r(a),s=r(i),u=[],h=[],c=o?[]:void 0,l=n.length;if(2>l)return{positions:n};var m=n[0];u.push(m);var p=e.cartesianToCartographic(m,d);s&&(p.height=i[0]),h.push(p.height),o&&c.push(a[0]);for(var y=1;l>y;++y){var v=n[y],g=e.cartesianToCartographic(v,w);s&&(g.height=i[y]),f(p,g)?p.height<g.height&&(h[h.length-1]=g.height):(u.push(v),h.push(g.height),o&&c.push(a[y])),t.clone(g,p)}return{positions:u,topHeights:h,bottomHeights:c}}var l={},d=new t,w=new t;return l.computePositions=function(e,t,a,f,l,d){var w=c(e,t,a,f);if(t=w.positions,a=w.topHeights,f=w.bottomHeights,t.length<2)throw new n("unique positions must be greater than or equal to 2");var m=r(f);if(t.length>=3){var p=i.fromPoints(t,e),y=p.projectPointsOntoPlane(t);o.computeWindingOrder2D(y)===u.CLOCKWISE&&(t.reverse(),a.reverse(),m&&f.reverse())}var v,g=t.length,q=[],x=m?[]:void 0,E=[];for(v=0;g-1>v;v++){var b=t[v],S=t[v+1],M=a[v],_=a[v+1];q=q.concat(h(b,S,M,_,l)),d&&q.push(_),m&&(b=t[v],S=t[v+1],M=f[v],_=f[v+1],x=x.concat(h(b,S,M,_,l)),d&&x.push(_)),d&&(E=E.concat(s.scaleToSurface([b,S],l,e)))}d||(E=s.scaleToSurface(t,l,e),q.push(a[g-1]),m&&x.push(f[g-1]));var O=m?s.scaleToGeodeticHeight(E,x,e):E.slice(0),P=s.scaleToGeodeticHeight(E,q,e);return{newWallPositions:E,bottomPositions:O,topPositions:P}},l}),define("Core/WallGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat","./WallGeometryLibrary"],function(e,t,r,n,i,a,o,s,u,h,f,c,l,d,w){"use strict";var m=new t,p=new t,y=new t,v=new t,g=new t,q=new t,x=new t,E=new t,b=function(e){e=n(e,n.EMPTY_OBJECT);var t=e.positions,r=e.maximumHeights,s=e.minimumHeights;if(!i(t))throw new a("options.positions is required.");if(i(r)&&r.length!==t.length)throw new a("options.positions and options.maximumHeights must have the same length.");if(i(s)&&s.length!==t.length)throw new a("options.positions and options.minimumHeights must have the same length.");var u=n(e.vertexFormat,d.DEFAULT),h=n(e.granularity,c.RADIANS_PER_DEGREE),f=n(e.ellipsoid,o.WGS84);this._positions=t,this._minimumHeights=s,this._maximumHeights=r,this._vertexFormat=u,this._granularity=h,this._ellipsoid=f,this._workerName="createWallGeometry"};return b.fromConstantHeights=function(e){e=n(e,n.EMPTY_OBJECT);var t=e.positions;if(!i(t))throw new a("options.positions is required.");var r,o,s=e.minimumHeight,u=e.maximumHeight,h=i(s),f=i(u);if(h||f){var c=t.length;r=h?new Array(c):void 0,o=f?new Array(c):void 0;for(var l=0;c>l;++l)h&&(r[l]=s),f&&(o[l]=u)}var d={positions:t,maximumHeights:o,minimumHeights:r,ellipsoid:e.ellipsoid,vertexFormat:e.vertexFormat};return new b(d)},b.createGeometry=function(n){var i=n._positions,a=n._minimumHeights,o=n._maximumHeights,d=n._vertexFormat,b=n._granularity,S=n._ellipsoid,M=w.computePositions(S,i,o,a,b,!0),_=M.newWallPositions,O=M.bottomPositions,P=M.topPositions,T=_.length,C=2*T,N=d.position?new Float64Array(C):void 0,R=d.normal?new Float32Array(C):void 0,I=d.tangent?new Float32Array(C):void 0,A=d.binormal?new Float32Array(C):void 0,D=d.st?new Float32Array(2*(C/3)):void 0,z=0,U=0,L=0,W=0,B=0,F=E,G=x,V=q,Y=!0;T/=3;var j;for(j=0;T>j;++j){var H=3*j,k=t.fromArray(P,H,m),X=t.fromArray(O,H,p);if(d.position&&(N[z++]=X.x,N[z++]=X.y,N[z++]=X.z,N[z++]=k.x,N[z++]=k.y,N[z++]=k.z),d.normal||d.tangent||d.binormal){var Z,J=new t,K=t.fromArray(_,H,p);if(T>j+1&&(Z=t.fromArray(_,H+3,y),J=t.fromArray(P,H+3,g)),Y){var $=t.subtract(J,k,v),Q=t.subtract(K,k,m);F=t.normalize(t.cross(Q,$,F),F),Y=!1}t.equalsEpsilon(Z,K,c.EPSILON6)?Y=!0:(d.tangent&&(G=t.normalize(t.subtract(Z,K,G),G)),d.binormal&&(V=t.normalize(t.cross(F,G,V),V))),d.normal&&(R[U++]=F.x,R[U++]=F.y,R[U++]=F.z,R[U++]=F.x,R[U++]=F.y,R[U++]=F.z),d.tangent&&(I[W++]=G.x,I[W++]=G.y,I[W++]=G.z,I[W++]=G.x,I[W++]=G.y,I[W++]=G.z),d.binormal&&(A[L++]=V.x,A[L++]=V.y,A[L++]=V.z,A[L++]=V.x,A[L++]=V.y,A[L++]=V.z)}if(d.st){var et=j/(T-1);D[B++]=et,D[B++]=0,D[B++]=et,D[B++]=1}}var tt=new h;d.position&&(tt.position=new u({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:N})),d.normal&&(tt.normal=new u({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:R})),d.tangent&&(tt.tangent=new u({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:I})),d.binormal&&(tt.binormal=new u({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:A})),d.st&&(tt.st=new u({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:D}));var rt=C/3;C-=6;var nt=f.createTypedArray(rt,C),it=0;for(j=0;rt-2>j;j+=2){var at=j,ot=j+2,st=t.fromArray(N,3*at,m),ut=t.fromArray(N,3*ot,p);if(!t.equalsEpsilon(st,ut,c.EPSILON6)){var ht=j+1,ft=j+3;nt[it++]=ht,nt[it++]=at,nt[it++]=ft,nt[it++]=ft,nt[it++]=at,nt[it++]=ot}}return new s({attributes:tt,indices:nt,primitiveType:l.TRIANGLES,boundingSphere:new e.fromVertices(N)})},b}),define("Workers/createWallGeometry",["../Core/Ellipsoid","../Core/WallGeometry"],function(e,t){"use strict";function r(r){return r._ellipsoid=e.clone(r._ellipsoid),t.createGeometry(r)}return r})}();