/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2014 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,i){"use strict";var n={};n.EPSILON1=.1,n.EPSILON2=.01,n.EPSILON3=.001,n.EPSILON4=1e-4,n.EPSILON5=1e-5,n.EPSILON6=1e-6,n.EPSILON7=1e-7,n.EPSILON8=1e-8,n.EPSILON9=1e-9,n.EPSILON10=1e-10,n.EPSILON11=1e-11,n.EPSILON12=1e-12,n.EPSILON13=1e-13,n.EPSILON14=1e-14,n.EPSILON15=1e-15,n.EPSILON16=1e-16,n.EPSILON17=1e-17,n.EPSILON18=1e-18,n.EPSILON19=1e-19,n.EPSILON20=1e-20,n.GRAVITATIONALPARAMETER=3986004418e5,n.SOLAR_RADIUS=6955e5,n.LUNAR_RADIUS=1737400,n.SIXTY_FOUR_KILOBYTES=65536,n.sign=function(e){return e>0?1:0>e?-1:0},n.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},n.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},n.lerp=function(e,r,t){return(1-t)*e+t*r},n.PI=Math.PI,n.ONE_OVER_PI=1/Math.PI,n.PI_OVER_TWO=.5*Math.PI,n.PI_OVER_THREE=Math.PI/3,n.PI_OVER_FOUR=Math.PI/4,n.PI_OVER_SIX=Math.PI/6,n.THREE_PI_OVER_TWO=.5*3*Math.PI,n.TWO_PI=2*Math.PI,n.ONE_OVER_TWO_PI=1/(2*Math.PI),n.RADIANS_PER_DEGREE=Math.PI/180,n.DEGREES_PER_RADIAN=180/Math.PI,n.RADIANS_PER_ARCSECOND=n.RADIANS_PER_DEGREE/3600,n.toRadians=function(e){if(!t(e))throw new i("degrees is required.");return e*n.RADIANS_PER_DEGREE},n.toDegrees=function(e){if(!t(e))throw new i("radians is required.");return e*n.DEGREES_PER_RADIAN},n.convertLongitudeRange=function(e){if(!t(e))throw new i("angle is required.");var r=n.TWO_PI,a=e-Math.floor(e/r)*r;return a<-Math.PI?a+r:a>=Math.PI?a-r:a},n.negativePiToPi=function(e){if(!t(e))throw new i("x is required.");for(var r=n.EPSILON10,a=n.PI,o=n.TWO_PI;-(a+r)>e;)e+=o;if(-a>e)return-a;for(;e>a+r;)e-=o;return e>a?a:e},n.zeroToTwoPi=function(e){if(!t(e))throw new i("x is required.");var r=e%n.TWO_PI;return 0>r?(r+n.TWO_PI)%n.TWO_PI:r},n.equalsEpsilon=function(e,n,a){if(!t(e))throw new i("left is required.");if(!t(n))throw new i("right is required.");return a=r(a,0),Math.abs(e-n)<=a};var a=[1];n.factorial=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");var r=a.length;if(e>=r)for(var t=a[r-1],n=r;e>=n;n++)a.push(t*n);return a[e]},n.incrementWrap=function(e,n,a){if(a=r(a,0),!t(e))throw new i("n is required.");if(a>=n)throw new i("maximumValue must be greater than minimumValue.");return++e,e>n&&(e=a),e},n.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},n.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},n.clamp=function(e,r,n){if(!t(e))throw new i("value is required");if(!t(r))throw new i("min is required.");if(!t(n))throw new i("max is required.");return r>e?r:e>n?n:e};var o=new e;return n.setRandomNumberSeed=function(r){if(!t(r))throw new i("seed is required.");o=new e(r)},n.nextRandomNumber=function(){return o.random()},n.acosClamped=function(e){return Math.acos(n.clamp(e,-1,1))},n.asinClamped=function(e){return Math.asin(n.clamp(e,-1,1))},n}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var a=function(r,t,i){this.x=e(r,0),this.y=e(t,0),this.z=e(i,0)};a.fromSpherical=function(i,n){if(!r(i))throw new t("spherical is required");r(n)||(n=new a);var o=i.clock,u=i.cone,s=e(i.magnitude,1),h=s*Math.sin(u);return n.x=h*Math.cos(o),n.y=h*Math.sin(o),n.z=s*Math.cos(u),n},a.fromElements=function(e,t,i,n){return r(n)?(n.x=e,n.y=t,n.z=i,n):new a(e,t,i)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(i,n,a){if(!r(i))throw new t("value is required");if(!r(n))throw new t("array is required");a=e(a,0),n[a++]=i.x,n[a++]=i.y,n[a]=i.z},a.unpack=function(i,n,o){if(!r(i))throw new t("array is required");return n=e(n,0),r(o)||(o=new a),o.x=i[n++],o.y=i[n++],o.z=i[n],o},a.fromArray=a.unpack,a.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},a.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},a.getMinimumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.min(e.x,i.x),n.y=Math.min(e.y,i.y),n.z=Math.min(e.z,i.z),n},a.getMaximumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.max(e.x,i.x),n.y=Math.max(e.y,i.y),n.z=Math.max(e.z,i.z),n},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return a.subtract(e,i,o),a.magnitude(o)},a.normalize=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");var n=a.magnitude(e);return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},a.dot=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");return e.x*i.x+e.y*i.y+e.z*i.z},a.multiplyComponents=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x*i.x,n.y=e.y*i.y,n.z=e.z*i.z,n},a.add=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x+i.x,n.y=e.y+i.y,n.z=e.z+i.z,n},a.subtract=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x-i.x,n.y=e.y-i.y,n.z=e.z-i.z,n},a.multiplyByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x*i,n.y=e.y*i,n.z=e.z*i,n},a.divideByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},a.negate=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=-e.x,i.y=-e.y,i.z=-e.z,i},a.abs=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=Math.abs(e.x),i.y=Math.abs(e.y),i.z=Math.abs(e.z),i};var u=new a;a.lerp=function(e,i,n,o){if(!r(e))throw new t("start is required.");if(!r(i))throw new t("end is required.");if("number"!=typeof n)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(i,n,u),o=a.multiplyByScalar(e,1-n,o),a.add(u,o,o)};var s=new a,h=new a;a.angleBetween=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");a.normalize(e,s),a.normalize(i,h);var n=a.dot(s,h),o=a.magnitude(a.cross(s,h,s));return Math.atan2(o,n)};var d=new a;a.mostOrthogonalAxis=function(e,i){if(!r(e))throw new t("cartesian is required.");if(!r(i))throw new t("result is required.");var n=a.normalize(e,d);return a.abs(n,n),i=n.x<=n.y?n.x<=n.z?a.clone(a.UNIT_X,i):a.clone(a.UNIT_Z,i):n.y<=n.z?a.clone(a.UNIT_Y,i):a.clone(a.UNIT_Z,i)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsEpsilon=function(e,i,n){if("number"!=typeof n)throw new t("epsilon is required and must be a number.");return e===i||r(e)&&r(i)&&Math.abs(e.x-i.x)<=n&&Math.abs(e.y-i.y)<=n&&Math.abs(e.z-i.z)<=n},a.cross=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");var a=e.x,o=e.y,u=e.z,s=i.x,h=i.y,d=i.z,f=o*d-u*h,c=u*s-a*d,l=a*h-o*s;return n.x=f,n.y=c,n.z=l,n},a.fromDegrees=function(e,i,o,u,s){if(!r(e))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");var h=n.toRadians(e),d=n.toRadians(i);return a.fromRadians(h,d,o,u,s)};var f=new a,c=new a,l=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(i,n,o,u,s){if(!r(i))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");o=e(o,0);var h=r(u)?u.radiiSquared:l,d=Math.cos(n);f.x=d*Math.cos(i),f.y=d*Math.sin(i),f.z=Math.sin(n),f=a.normalize(f,f),a.multiplyComponents(h,f,c);var w=Math.sqrt(a.dot(f,c));return c=a.divideByScalar(c,w,c),f=a.multiplyByScalar(f,o,f),r(s)||(s=new a),a.add(c,f,s)},a.fromDegreesArray=function(e,i,o){if(!r(e))throw new t("positions is required.");for(var u=new Array(e.length),s=0;s<e.length;s++)u[s]=n.toRadians(e[s]);return a.fromRadiansArray(u,i,o)},a.fromRadiansArray=function(e,i,n){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(0!==e.length%2)throw new t("positions length must be a multiple of 2.");var o=e.length;r(n)?n.length=o/2:n=new Array(o/2);for(var u=0;o>u;u+=2){var s=e[u],h=e[u+1];n[u/2]=a.fromRadians(s,h,0,i,n[u/2])}return n},a.fromDegreesArrayHeights=function(e,i,o){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");for(var u=new Array(e.length),s=0;s<e.length;s+=3)u[s]=n.toRadians(e[s]),u[s+1]=n.toRadians(e[s+1]),u[s+2]=e[s+2];return a.fromRadiansArrayHeights(u,i,o)},a.fromRadiansArrayHeights=function(e,i,n){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");var o=e.length;r(n)?n.length=o/3:n=new Array(o/3);for(var u=0;o>u;u+=3){var s=e[u],h=e[u+1],d=e[u+2];n[u/3]=a.fromRadians(s,h,d,i,n[u/3])}return n},a.ZERO=i(new a(0,0,0)),a.UNIT_X=i(new a(1,0,0)),a.UNIT_Y=i(new a(0,1,0)),a.UNIT_Z=i(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var a=function(r,t,i){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(i,0)};return a.fromRadians=function(i,n,o,u){if(!r(i))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return o=e(o,0),r(u)?(u.longitude=i,u.latitude=n,u.height=o,u):new a(i,n,o)},a.fromDegrees=function(e,i,o,u){if(!r(e))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return e=n.toRadians(e),i=n.toRadians(i),a.fromRadians(e,i,o,u)},a.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new a(e.longitude,e.latitude,e.height):void 0},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},a.equalsEpsilon=function(e,i,n){if("number"!=typeof n)throw new t("epsilon is required and must be a number.");return e===i||r(e)&&r(i)&&Math.abs(e.longitude-i.longitude)<=n&&Math.abs(e.latitude-i.latitude)<=n&&Math.abs(e.height-i.height)<=n},a.toString=function(e){if(!r(e))throw new t("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},a.ZERO=i(new a(0,0,0)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return a.toString(this)},a}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n,a,o,u){"use strict";var s=function(r,i,n){if(r=t(r,0),i=t(i,0),n=t(n,0),0>r||0>i||0>n)throw new a("All radii components must be greater than or equal to zero.");this._radii=new e(r,i,n),this._radiiSquared=new e(r*r,i*i,n*n),this._radiiToTheFourth=new e(r*r*r*r,i*i*i*i,n*n*n*n),this._oneOverRadii=new e(0===r?0:1/r,0===i?0:1/i,0===n?0:1/n),this._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===i?0:1/(i*i),0===n?0:1/(n*n)),this._minimumRadius=Math.min(r,i,n),this._maximumRadius=Math.max(r,i,n),this._centerToleranceSquared=u.EPSILON1};n(s.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),s.clone=function(r,t){if(!i(r))return void 0;var n=r._radii;return i(t)?(e.clone(n,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new s(n.x,n.y,n.z)},s.fromCartesian3=function(e){return i(e)?new s(e.x,e.y,e.z):new s},s.WGS84=o(new s(6378137,6378137,6356752.314245179)),s.UNIT_SPHERE=o(new s(1,1,1)),s.MOON=o(new s(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.geocentricSurfaceNormal=e.normalize,s.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!i(r))throw new a("cartographic is required.");var n=r.longitude,o=r.latitude,u=Math.cos(o),s=u*Math.cos(n),h=u*Math.sin(n),d=Math.sin(o);return i(t)||(t=new e),t.x=s,t.y=h,t.z=d,e.normalize(t,t)},s.prototype.geodeticSurfaceNormal=function(r,t){return i(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var h=new e,d=new e;s.prototype.cartographicToCartesian=function(r,t){var n=h,a=d;this.geodeticSurfaceNormalCartographic(r,n),e.multiplyComponents(this._radiiSquared,n,a);var o=Math.sqrt(e.dot(n,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(n,r.height,n),i(t)||(t=new e),e.add(a,n,t)},s.prototype.cartographicArrayToCartesianArray=function(e,r){if(!i(e))throw new a("cartographics is required.");var t=e.length;i(r)?r.length=t:r=new Array(t);for(var n=0;t>n;n++)r[n]=this.cartographicToCartesian(e[n],r[n]);return r};var f=new e,c=new e,l=new e;s.prototype.cartesianToCartographic=function(t,n){var a=this.scaleToGeodeticSurface(t,c);if(!i(a))return void 0;var o=this.geodeticSurfaceNormal(a,f),s=e.subtract(t,a,l),h=Math.atan2(o.y,o.x),d=Math.asin(o.z),w=u.sign(e.dot(s,t))*e.magnitude(s);return i(n)?(n.longitude=h,n.latitude=d,n.height=w,n):new r(h,d,w)},s.prototype.cartesianArrayToCartographicArray=function(e,r){if(!i(e))throw new a("cartesians is required.");var t=e.length;i(r)?r.length=t:r=new Array(t);for(var n=0;t>n;++n)r[n]=this.cartesianToCartographic(e[n],r[n]);return r};var w=new e,m=new e;return s.prototype.scaleToGeodeticSurface=function(r,t){if(!i(r))throw new a("cartesian is required.");var n=r.x,o=r.y,s=r.z,h=this._oneOverRadii,d=h.x,f=h.y,c=h.z,l=n*n*d*d,g=o*o*f*f,p=s*s*c*c,y=l+g+p,q=Math.sqrt(1/y),v=e.multiplyByScalar(r,q,w);if(y<this._centerToleranceSquared)return isFinite(q)?e.clone(v,t):void 0;var S=this._oneOverRadiiSquared,_=S.x,R=S.y,E=S.z,M=m;M.x=2*v.x*_,M.y=2*v.y*R,M.z=2*v.z*E;var I,x,P,z,O,T,A,b,N,C,L,D=(1-q)*e.magnitude(r)/(.5*e.magnitude(M)),U=0;do{D-=U,P=1/(1+D*_),z=1/(1+D*R),O=1/(1+D*E),T=P*P,A=z*z,b=O*O,N=T*P,C=A*z,L=b*O,I=l*T+g*A+p*b-1,x=l*N*_+g*C*R+p*L*E;var k=-2*x;U=I/k}while(Math.abs(I)>u.EPSILON12);return i(t)?(t.x=n*P,t.y=o*z,t.z=s*O,t):new e(n*P,o*z,s*O)},s.prototype.scaleToGeocentricSurface=function(r,t){if(!i(r))throw new a("cartesian is required.");i(t)||(t=new e);var n=r.x,o=r.y,u=r.z,s=this._oneOverRadiiSquared,h=1/Math.sqrt(n*n*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(r,h,t)},s.prototype.transformPositionToScaledSpace=function(r,t){return i(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},s.prototype.transformPositionFromScaledSpace=function(r,t){return i(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},s.prototype.equals=function(r){return this===r||i(r)&&e.equals(this._radii,r._radii)},s.prototype.toString=function(){return this._radii.toString()},s}),define("Core/formatError",["./defined"],function(e){"use strict";var r=function(r){var t,i=r.name,n=r.message;t=e(i)&&e(n)?i+": "+n:r.toString();var a=r.stack;return e(a)&&(t+="\n"+a),t};return r}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,r,t){"use strict";var i=function(i){var n,a=[],o={id:void 0,result:void 0,error:void 0};return function(u){var s=u.data;a.length=0,o.id=s.id,o.error=void 0,o.result=void 0;try{o.result=i(s.parameters,a)}catch(h){o.error=h instanceof Error?{name:h.name,message:h.message,stack:h.stack}:h}r(n)||(n=e(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(a.length=0);try{n(o,a)}catch(h){o.result=void 0,o.error="postMessage failed with error: "+t(h)+"\n  with responseMessage: "+JSON.stringify(o),n(o)}}};return i}),define("Workers/createVerticesFromQuantizedTerrainMesh",["../Core/Cartesian3","../Core/Cartographic","../Core/Ellipsoid","../Core/Math","./createTaskProcessorWorker"],function(e,r,t,i,n){"use strict";function a(e,r){for(var n=e.quantizedVertices,a=n.length/3,p=e.westIndices.length+e.eastIndices.length+e.southIndices.length+e.northIndices.length,y=e.minimumHeight,q=e.maximumHeight,v=e.relativeToCenter,S=e.rectangle,_=S.west,R=S.south,E=S.east,M=S.north,I=t.clone(e.ellipsoid),x=n.subarray(0,a),P=n.subarray(a,2*a),z=n.subarray(2*a,3*a),O=new Float32Array(a*u+p*u),T=0,A=0;a>T;++T,A+=u){var b=x[T]/s,N=P[T]/s,C=i.lerp(y,q,z[T]/s);g.longitude=i.lerp(_,E,b),g.latitude=i.lerp(R,M,N),g.height=C,I.cartographicToCartesian(g,m),O[A+h]=m.x-v.x,O[A+d]=m.y-v.y,O[A+f]=m.z-v.z,O[A+c]=C,O[A+l]=b,O[A+w]=N}var L=Math.max(0,2*(p-4)),D=new Uint16Array(e.indices.length+3*L);D.set(e.indices,0);var U=a*u,k=e.indices.length;return k=o(O,U,D,k,e.westIndices,v,I,S,e.westSkirtHeight,!0),U+=e.westIndices.length*u,k=o(O,U,D,k,e.southIndices,v,I,S,e.southSkirtHeight,!1),U+=e.southIndices.length*u,k=o(O,U,D,k,e.eastIndices,v,I,S,e.eastSkirtHeight,!1),U+=e.eastIndices.length*u,k=o(O,U,D,k,e.northIndices,v,I,S,e.northSkirtHeight,!0),U+=e.northIndices.length*u,r.push(O.buffer,D.buffer),{vertices:O.buffer,indices:D.buffer}}function o(r,t,n,a,o,s,h,d,f,p){var y,q,v;p?(y=o.length-1,q=-1,v=-1):(y=0,q=o.length,v=1);for(var S=-1,_=t/u,R=y;R!==q;R+=v){var E=o[R],M=E*u,I=r[M+l],x=r[M+w],P=r[M+c];g.longitude=i.lerp(d.west,d.east,I),g.latitude=i.lerp(d.south,d.north,x),g.height=P-f;var z=h.cartographicToCartesian(g,m);e.subtract(z,s,z),r[t++]=z.x,r[t++]=z.y,r[t++]=z.z,r[t++]=g.height,r[t++]=I,r[t++]=x,-1!==S&&(n[a++]=S,n[a++]=_-1,n[a++]=E,n[a++]=_-1,n[a++]=_,n[a++]=E),S=E,++_}return a}var u=6,s=32767,h=0,d=1,f=2,c=3,l=4,w=5,m=new e,g=new r;return n(a)})}();