/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2014 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,i){"use strict";var n={};n.EPSILON1=.1,n.EPSILON2=.01,n.EPSILON3=.001,n.EPSILON4=1e-4,n.EPSILON5=1e-5,n.EPSILON6=1e-6,n.EPSILON7=1e-7,n.EPSILON8=1e-8,n.EPSILON9=1e-9,n.EPSILON10=1e-10,n.EPSILON11=1e-11,n.EPSILON12=1e-12,n.EPSILON13=1e-13,n.EPSILON14=1e-14,n.EPSILON15=1e-15,n.EPSILON16=1e-16,n.EPSILON17=1e-17,n.EPSILON18=1e-18,n.EPSILON19=1e-19,n.EPSILON20=1e-20,n.GRAVITATIONALPARAMETER=3986004418e5,n.SOLAR_RADIUS=6955e5,n.LUNAR_RADIUS=1737400,n.SIXTY_FOUR_KILOBYTES=65536,n.sign=function(e){return e>0?1:0>e?-1:0},n.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},n.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},n.lerp=function(e,r,t){return(1-t)*e+t*r},n.PI=Math.PI,n.ONE_OVER_PI=1/Math.PI,n.PI_OVER_TWO=.5*Math.PI,n.PI_OVER_THREE=Math.PI/3,n.PI_OVER_FOUR=Math.PI/4,n.PI_OVER_SIX=Math.PI/6,n.THREE_PI_OVER_TWO=.5*3*Math.PI,n.TWO_PI=2*Math.PI,n.ONE_OVER_TWO_PI=1/(2*Math.PI),n.RADIANS_PER_DEGREE=Math.PI/180,n.DEGREES_PER_RADIAN=180/Math.PI,n.RADIANS_PER_ARCSECOND=n.RADIANS_PER_DEGREE/3600,n.toRadians=function(e){if(!t(e))throw new i("degrees is required.");return e*n.RADIANS_PER_DEGREE},n.toDegrees=function(e){if(!t(e))throw new i("radians is required.");return e*n.DEGREES_PER_RADIAN},n.convertLongitudeRange=function(e){if(!t(e))throw new i("angle is required.");var r=n.TWO_PI,a=e-Math.floor(e/r)*r;return a<-Math.PI?a+r:a>=Math.PI?a-r:a},n.negativePiToPi=function(e){if(!t(e))throw new i("x is required.");for(var r=n.EPSILON10,a=n.PI,o=n.TWO_PI;-(a+r)>e;)e+=o;if(-a>e)return-a;for(;e>a+r;)e-=o;return e>a?a:e},n.zeroToTwoPi=function(e){if(!t(e))throw new i("x is required.");var r=e%n.TWO_PI;return 0>r?(r+n.TWO_PI)%n.TWO_PI:r},n.equalsEpsilon=function(e,n,a){if(!t(e))throw new i("left is required.");if(!t(n))throw new i("right is required.");return a=r(a,0),Math.abs(e-n)<=a};var a=[1];n.factorial=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");var r=a.length;if(e>=r)for(var t=a[r-1],n=r;e>=n;n++)a.push(t*n);return a[e]},n.incrementWrap=function(e,n,a){if(a=r(a,0),!t(e))throw new i("n is required.");if(a>=n)throw new i("maximumValue must be greater than minimumValue.");return++e,e>n&&(e=a),e},n.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},n.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},n.clamp=function(e,r,n){if(!t(e))throw new i("value is required");if(!t(r))throw new i("min is required.");if(!t(n))throw new i("max is required.");return r>e?r:e>n?n:e};var o=new e;return n.setRandomNumberSeed=function(r){if(!t(r))throw new i("seed is required.");o=new e(r)},n.nextRandomNumber=function(){return o.random()},n.acosClamped=function(e){return Math.acos(n.clamp(e,-1,1))},n.asinClamped=function(e){return Math.asin(n.clamp(e,-1,1))},n}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var a=function(r,t,i){this.x=e(r,0),this.y=e(t,0),this.z=e(i,0)};a.fromSpherical=function(i,n){if(!r(i))throw new t("spherical is required");r(n)||(n=new a);var o=i.clock,u=i.cone,s=e(i.magnitude,1),h=s*Math.sin(u);return n.x=h*Math.cos(o),n.y=h*Math.sin(o),n.z=s*Math.cos(u),n},a.fromElements=function(e,t,i,n){return r(n)?(n.x=e,n.y=t,n.z=i,n):new a(e,t,i)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(i,n,a){if(!r(i))throw new t("value is required");if(!r(n))throw new t("array is required");a=e(a,0),n[a++]=i.x,n[a++]=i.y,n[a]=i.z},a.unpack=function(i,n,o){if(!r(i))throw new t("array is required");return n=e(n,0),r(o)||(o=new a),o.x=i[n++],o.y=i[n++],o.z=i[n],o},a.fromArray=a.unpack,a.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},a.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},a.getMinimumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.min(e.x,i.x),n.y=Math.min(e.y,i.y),n.z=Math.min(e.z,i.z),n},a.getMaximumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.max(e.x,i.x),n.y=Math.max(e.y,i.y),n.z=Math.max(e.z,i.z),n},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return a.subtract(e,i,o),a.magnitude(o)},a.normalize=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");var n=a.magnitude(e);return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},a.dot=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");return e.x*i.x+e.y*i.y+e.z*i.z},a.multiplyComponents=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x*i.x,n.y=e.y*i.y,n.z=e.z*i.z,n},a.add=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x+i.x,n.y=e.y+i.y,n.z=e.z+i.z,n},a.subtract=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x-i.x,n.y=e.y-i.y,n.z=e.z-i.z,n},a.multiplyByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x*i,n.y=e.y*i,n.z=e.z*i,n},a.divideByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},a.negate=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=-e.x,i.y=-e.y,i.z=-e.z,i},a.abs=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=Math.abs(e.x),i.y=Math.abs(e.y),i.z=Math.abs(e.z),i};var u=new a;a.lerp=function(e,i,n,o){if(!r(e))throw new t("start is required.");if(!r(i))throw new t("end is required.");if("number"!=typeof n)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(i,n,u),o=a.multiplyByScalar(e,1-n,o),a.add(u,o,o)};var s=new a,h=new a;a.angleBetween=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");a.normalize(e,s),a.normalize(i,h);var n=a.dot(s,h),o=a.magnitude(a.cross(s,h,s));return Math.atan2(o,n)};var w=new a;a.mostOrthogonalAxis=function(e,i){if(!r(e))throw new t("cartesian is required.");if(!r(i))throw new t("result is required.");var n=a.normalize(e,w);return a.abs(n,n),i=n.x<=n.y?n.x<=n.z?a.clone(a.UNIT_X,i):a.clone(a.UNIT_Z,i):n.y<=n.z?a.clone(a.UNIT_Y,i):a.clone(a.UNIT_Z,i)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsEpsilon=function(e,i,n){if("number"!=typeof n)throw new t("epsilon is required and must be a number.");return e===i||r(e)&&r(i)&&Math.abs(e.x-i.x)<=n&&Math.abs(e.y-i.y)<=n&&Math.abs(e.z-i.z)<=n},a.cross=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");var a=e.x,o=e.y,u=e.z,s=i.x,h=i.y,w=i.z,f=o*w-u*h,c=u*s-a*w,d=a*h-o*s;return n.x=f,n.y=c,n.z=d,n},a.fromDegrees=function(e,i,o,u,s){if(!r(e))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");var h=n.toRadians(e),w=n.toRadians(i);return a.fromRadians(h,w,o,u,s)};var f=new a,c=new a,d=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(i,n,o,u,s){if(!r(i))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");o=e(o,0);var h=r(u)?u.radiiSquared:d,w=Math.cos(n);f.x=w*Math.cos(i),f.y=w*Math.sin(i),f.z=Math.sin(n),f=a.normalize(f,f),a.multiplyComponents(h,f,c);var l=Math.sqrt(a.dot(f,c));return c=a.divideByScalar(c,l,c),f=a.multiplyByScalar(f,o,f),r(s)||(s=new a),a.add(c,f,s)},a.fromDegreesArray=function(e,i,o){if(!r(e))throw new t("positions is required.");for(var u=new Array(e.length),s=0;s<e.length;s++)u[s]=n.toRadians(e[s]);return a.fromRadiansArray(u,i,o)},a.fromRadiansArray=function(e,i,n){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(0!==e.length%2)throw new t("positions length must be a multiple of 2.");var o=e.length;r(n)?n.length=o/2:n=new Array(o/2);for(var u=0;o>u;u+=2){var s=e[u],h=e[u+1];n[u/2]=a.fromRadians(s,h,0,i,n[u/2])}return n},a.fromDegreesArrayHeights=function(e,i,o){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");for(var u=new Array(e.length),s=0;s<e.length;s+=3)u[s]=n.toRadians(e[s]),u[s+1]=n.toRadians(e[s+1]),u[s+2]=e[s+2];return a.fromRadiansArrayHeights(u,i,o)},a.fromRadiansArrayHeights=function(e,i,n){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");var o=e.length;r(n)?n.length=o/3:n=new Array(o/3);for(var u=0;o>u;u+=3){var s=e[u],h=e[u+1],w=e[u+2];n[u/3]=a.fromRadians(s,h,w,i,n[u/3])}return n},a.ZERO=i(new a(0,0,0)),a.UNIT_X=i(new a(1,0,0)),a.UNIT_Y=i(new a(0,1,0)),a.UNIT_Z=i(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var a=function(r,t,i){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(i,0)};return a.fromRadians=function(i,n,o,u){if(!r(i))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return o=e(o,0),r(u)?(u.longitude=i,u.latitude=n,u.height=o,u):new a(i,n,o)},a.fromDegrees=function(e,i,o,u){if(!r(e))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return e=n.toRadians(e),i=n.toRadians(i),a.fromRadians(e,i,o,u)},a.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new a(e.longitude,e.latitude,e.height):void 0},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},a.equalsEpsilon=function(e,i,n){if("number"!=typeof n)throw new t("epsilon is required and must be a number.");return e===i||r(e)&&r(i)&&Math.abs(e.longitude-i.longitude)<=n&&Math.abs(e.latitude-i.latitude)<=n&&Math.abs(e.height-i.height)<=n},a.toString=function(e){if(!r(e))throw new t("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},a.ZERO=i(new a(0,0,0)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return a.toString(this)},a}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n,a,o,u){"use strict";var s=function(r,i,n){if(r=t(r,0),i=t(i,0),n=t(n,0),0>r||0>i||0>n)throw new a("All radii components must be greater than or equal to zero.");this._radii=new e(r,i,n),this._radiiSquared=new e(r*r,i*i,n*n),this._radiiToTheFourth=new e(r*r*r*r,i*i*i*i,n*n*n*n),this._oneOverRadii=new e(0===r?0:1/r,0===i?0:1/i,0===n?0:1/n),this._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===i?0:1/(i*i),0===n?0:1/(n*n)),this._minimumRadius=Math.min(r,i,n),this._maximumRadius=Math.max(r,i,n),this._centerToleranceSquared=u.EPSILON1};n(s.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),s.clone=function(r,t){if(!i(r))return void 0;var n=r._radii;return i(t)?(e.clone(n,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new s(n.x,n.y,n.z)},s.fromCartesian3=function(e){return i(e)?new s(e.x,e.y,e.z):new s},s.WGS84=o(new s(6378137,6378137,6356752.314245179)),s.UNIT_SPHERE=o(new s(1,1,1)),s.MOON=o(new s(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.geocentricSurfaceNormal=e.normalize,s.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!i(r))throw new a("cartographic is required.");var n=r.longitude,o=r.latitude,u=Math.cos(o),s=u*Math.cos(n),h=u*Math.sin(n),w=Math.sin(o);return i(t)||(t=new e),t.x=s,t.y=h,t.z=w,e.normalize(t,t)},s.prototype.geodeticSurfaceNormal=function(r,t){return i(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var h=new e,w=new e;s.prototype.cartographicToCartesian=function(r,t){var n=h,a=w;this.geodeticSurfaceNormalCartographic(r,n),e.multiplyComponents(this._radiiSquared,n,a);var o=Math.sqrt(e.dot(n,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(n,r.height,n),i(t)||(t=new e),e.add(a,n,t)},s.prototype.cartographicArrayToCartesianArray=function(e,r){if(!i(e))throw new a("cartographics is required.");var t=e.length;i(r)?r.length=t:r=new Array(t);for(var n=0;t>n;n++)r[n]=this.cartographicToCartesian(e[n],r[n]);return r};var f=new e,c=new e,d=new e;s.prototype.cartesianToCartographic=function(t,n){var a=this.scaleToGeodeticSurface(t,c);if(!i(a))return void 0;var o=this.geodeticSurfaceNormal(a,f),s=e.subtract(t,a,d),h=Math.atan2(o.y,o.x),w=Math.asin(o.z),l=u.sign(e.dot(s,t))*e.magnitude(s);return i(n)?(n.longitude=h,n.latitude=w,n.height=l,n):new r(h,w,l)},s.prototype.cartesianArrayToCartographicArray=function(e,r){if(!i(e))throw new a("cartesians is required.");var t=e.length;i(r)?r.length=t:r=new Array(t);for(var n=0;t>n;++n)r[n]=this.cartesianToCartographic(e[n],r[n]);return r};var l=new e,m=new e;return s.prototype.scaleToGeodeticSurface=function(r,t){if(!i(r))throw new a("cartesian is required.");var n=r.x,o=r.y,s=r.z,h=this._oneOverRadii,w=h.x,f=h.y,c=h.z,d=n*n*w*w,p=o*o*f*f,y=s*s*c*c,g=d+p+y,q=Math.sqrt(1/g),v=e.multiplyByScalar(r,q,l);if(g<this._centerToleranceSquared)return isFinite(q)?e.clone(v,t):void 0;var x=this._oneOverRadiiSquared,M=x.x,b=x.y,z=x.z,S=m;S.x=2*v.x*M,S.y=2*v.y*b,S.z=2*v.z*z;var E,R,O,_,T,P,I,C,N,A,U,L=(1-q)*e.magnitude(r)/(.5*e.magnitude(S)),W=0;do{L-=W,O=1/(1+L*M),_=1/(1+L*b),T=1/(1+L*z),P=O*O,I=_*_,C=T*T,N=P*O,A=I*_,U=C*T,E=d*P+p*I+y*C-1,R=d*N*M+p*A*b+y*U*z;var D=-2*R;W=E/D}while(Math.abs(E)>u.EPSILON12);return i(t)?(t.x=n*O,t.y=o*_,t.z=s*T,t):new e(n*O,o*_,s*T)},s.prototype.scaleToGeocentricSurface=function(r,t){if(!i(r))throw new a("cartesian is required.");i(t)||(t=new e);var n=r.x,o=r.y,u=r.z,s=this._oneOverRadiiSquared,h=1/Math.sqrt(n*n*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(r,h,t)},s.prototype.transformPositionToScaledSpace=function(r,t){return i(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},s.prototype.transformPositionFromScaledSpace=function(r,t){return i(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},s.prototype.equals=function(r){return this===r||i(r)&&e.equals(this._radii,r._radii)},s.prototype.toString=function(){return this._radii.toString()},s}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,i,n,a,o){"use strict";var u=function(e){this._ellipsoid=t(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return n(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(r,t){var n=this._semimajorAxis,a=r.longitude*n,o=r.latitude*n,u=r.height;return i(t)?(t.x=a,t.y=o,t.z=u,t):new e(a,o,u)},u.prototype.unproject=function(e,t){if(!i(e))throw new a("cartesian is required");var n=this._oneOverSemimajorAxis,o=e.x*n,u=e.y*n,s=e.z;return i(t)?(t.longitude=o,t.latitude=u,t.height=s,t):new r(o,u,s)},u}),define("Core/Intersect",[],function(){"use strict";var e={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,i){"use strict";var n=function(r,t,i,n){this.x=e(r,0),this.y=e(t,0),this.z=e(i,0),this.w=e(n,0)};n.fromElements=function(e,t,i,a,o){return r(o)?(o.x=e,o.y=t,o.z=i,o.w=a,o):new n(e,t,i,a)},n.fromColor=function(e,i){if(!r(e))throw new t("color is required");return r(i)?(i.x=e.red,i.y=e.green,i.z=e.blue,i.w=e.alpha,i):new n(e.red,e.green,e.blue,e.alpha)},n.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new n(e.x,e.y,e.z,e.w):void 0},n.packedLength=4,n.pack=function(i,n,a){if(!r(i))throw new t("value is required");if(!r(n))throw new t("array is required");a=e(a,0),n[a++]=i.x,n[a++]=i.y,n[a++]=i.z,n[a]=i.w},n.unpack=function(i,a,o){if(!r(i))throw new t("array is required");return a=e(a,0),r(o)||(o=new n),o.x=i[a++],o.y=i[a++],o.z=i[a++],o.w=i[a],o},n.fromArray=n.unpack,n.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},n.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},n.getMinimumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.min(e.x,i.x),n.y=Math.min(e.y,i.y),n.z=Math.min(e.z,i.z),n.w=Math.min(e.w,i.w),n},n.getMaximumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.max(e.x,i.x),n.y=Math.max(e.y,i.y),n.z=Math.max(e.z,i.z),n.w=Math.max(e.w,i.w),n},n.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},n.magnitude=function(e){return Math.sqrt(n.magnitudeSquared(e))};var a=new n;n.distance=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return n.subtract(e,i,a),n.magnitude(a)},n.normalize=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");var a=n.magnitude(e);return i.x=e.x/a,i.y=e.y/a,i.z=e.z/a,i.w=e.w/a,i},n.dot=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");return e.x*i.x+e.y*i.y+e.z*i.z+e.w*i.w},n.multiplyComponents=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x*i.x,n.y=e.y*i.y,n.z=e.z*i.z,n.w=e.w*i.w,n},n.add=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x+i.x,n.y=e.y+i.y,n.z=e.z+i.z,n.w=e.w+i.w,n},n.subtract=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x-i.x,n.y=e.y-i.y,n.z=e.z-i.z,n.w=e.w-i.w,n},n.multiplyByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x*i,n.y=e.y*i,n.z=e.z*i,n.w=e.w*i,n},n.divideByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n.w=e.w/i,n},n.negate=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=-e.x,i.y=-e.y,i.z=-e.z,i.w=-e.w,i},n.abs=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=Math.abs(e.x),i.y=Math.abs(e.y),i.z=Math.abs(e.z),i.w=Math.abs(e.w),i};var o=new n;n.lerp=function(e,i,a,u){if(!r(e))throw new t("start is required.");if(!r(i))throw new t("end is required.");if("number"!=typeof a)throw new t("t is required and must be a number.");if(!r(u))throw new t("result is required.");return n.multiplyByScalar(i,a,o),u=n.multiplyByScalar(e,1-a,u),n.add(o,u,u)};var u=new n;return n.mostOrthogonalAxis=function(e,i){if(!r(e))throw new t("cartesian is required.");if(!r(i))throw new t("result is required.");var a=n.normalize(e,u);return n.abs(a,a),i=a.x<=a.y?a.x<=a.z?a.x<=a.w?n.clone(n.UNIT_X,i):n.clone(n.UNIT_W,i):a.z<=a.w?n.clone(n.UNIT_Z,i):n.clone(n.UNIT_W,i):a.y<=a.z?a.y<=a.w?n.clone(n.UNIT_Y,i):n.clone(n.UNIT_W,i):a.z<=a.w?n.clone(n.UNIT_Z,i):n.clone(n.UNIT_W,i)},n.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},n.equalsEpsilon=function(e,i,n){if("number"!=typeof n)throw new t("epsilon is required and must be a number.");return e===i||r(e)&&r(i)&&Math.abs(e.x-i.x)<=n&&Math.abs(e.y-i.y)<=n&&Math.abs(e.z-i.z)<=n&&Math.abs(e.w-i.w)<=n},n.ZERO=i(new n(0,0,0,0)),n.UNIT_X=i(new n(1,0,0,0)),n.UNIT_Y=i(new n(0,1,0,0)),n.UNIT_Z=i(new n(0,0,1,0)),n.UNIT_W=i(new n(0,0,0,1)),n.prototype.clone=function(e){return n.clone(this,e)},n.prototype.equals=function(e){return n.equals(this,e)},n.prototype.equalsEpsilon=function(e,r){return n.equalsEpsilon(this,e,r)},n.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},n}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n,a){"use strict";function o(e){for(var r=0,t=0;9>t;++t){var i=e[t];r+=i*i}return Math.sqrt(r)}function u(e){for(var r=0,t=0;3>t;++t){var i=e[h.getElementIndex(d[t],c[t])];r+=2*i*i}return Math.sqrt(r)}function s(e,r){for(var t=a.EPSILON15,i=0,n=1,o=0;3>o;++o){var u=Math.abs(e[h.getElementIndex(d[o],c[o])]);u>i&&(n=o,i=u)}var s=1,w=0,f=c[n],l=d[n];if(Math.abs(e[h.getElementIndex(l,f)])>t){var m,p=e[h.getElementIndex(l,l)],y=e[h.getElementIndex(f,f)],g=e[h.getElementIndex(l,f)],q=(p-y)/2/g;m=0>q?-1/(-q+Math.sqrt(1+q*q)):1/(q+Math.sqrt(1+q*q)),s=1/Math.sqrt(1+m*m),w=m*s}return r=h.clone(h.IDENTITY,r),r[h.getElementIndex(f,f)]=r[h.getElementIndex(l,l)]=s,r[h.getElementIndex(l,f)]=w,r[h.getElementIndex(f,l)]=-w,r}var h=function(e,t,i,n,a,o,u,s,h){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(s,0),this[6]=r(i,0),this[7]=r(o,0),this[8]=r(h,0)};h.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new h(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},h.fromArray=function(e,n,a){if(!t(e))throw new i("array is required");return n=r(n,0),t(a)||(a=new h),a[0]=e[n],a[1]=e[n+1],a[2]=e[n+2],a[3]=e[n+3],a[4]=e[n+4],a[5]=e[n+5],a[6]=e[n+6],a[7]=e[n+7],a[8]=e[n+8],a[9]=e[n+9],a},h.fromColumnMajorArray=function(e,r){if(!t(e))throw new i("values parameter is required");return h.clone(e,r)},h.fromRowMajorArray=function(e,r){if(!t(e))throw new i("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new h(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},h.fromQuaternion=function(e,r){if(!t(e))throw new i("quaternion is required");var n=e.x*e.x,a=e.x*e.y,o=e.x*e.z,u=e.x*e.w,s=e.y*e.y,w=e.y*e.z,f=e.y*e.w,c=e.z*e.z,d=e.z*e.w,l=e.w*e.w,m=n-s-c+l,p=2*(a-d),y=2*(o+f),g=2*(a+d),q=-n+s-c+l,v=2*(w-u),x=2*(o-f),M=2*(w+u),b=-n-s+c+l;return t(r)?(r[0]=m,r[1]=g,r[2]=x,r[3]=p,r[4]=q,r[5]=M,r[6]=y,r[7]=v,r[8]=b,r):new h(m,p,y,g,q,v,x,M,b)},h.fromScale=function(e,r){if(!t(e))throw new i("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new h(e.x,0,0,0,e.y,0,0,0,e.z)},h.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new h(e,0,0,0,e,0,0,0,e)},h.fromRotationX=function(e,r){if(!t(e))throw new i("angle is required.");var n=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=n,r[5]=a,r[6]=0,r[7]=-a,r[8]=n,r):new h(1,0,0,0,n,-a,0,a,n)},h.fromRotationY=function(e,r){if(!t(e))throw new i("angle is required.");var n=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=n,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=n,r):new h(n,0,a,0,1,0,-a,0,n)},h.fromRotationZ=function(e,r){if(!t(e))throw new i("angle is required.");var n=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=n,r[1]=a,r[2]=0,r[3]=-a,r[4]=n,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new h(n,-a,0,a,n,0,0,0,1)},h.toArray=function(e,r){if(!t(e))throw new i("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},h.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new i("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new i("column must be 0, 1, or 2.");return 3*e+r},h.getColumn=function(r,n,a){if(!t(r))throw new i("matrix is required.");if("number"!=typeof n||0>n||n>2)throw new i("index must be 0, 1, or 2.");var o=3*n,u=r[o],s=r[o+1],h=r[o+2];return t(a)?(a.x=u,a.y=s,a.z=h,a):new e(u,s,h)},h.setColumn=function(e,r,n,a){if(!t(e))throw new i("matrix is required");if(!t(n))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new i("index must be 0, 1, or 2.");a=h.clone(e,a);var o=3*r;return a[o]=n.x,a[o+1]=n.y,a[o+2]=n.z,a},h.getRow=function(r,n,a){if(!t(r))throw new i("matrix is required.");if("number"!=typeof n||0>n||n>2)throw new i("index must be 0, 1, or 2.");var o=r[n],u=r[n+3],s=r[n+6];return t(a)?(a.x=o,a.y=u,a.z=s,a):new e(o,u,s)},h.setRow=function(e,r,n,a){if(!t(e))throw new i("matrix is required");if(!t(n))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new i("index must be 0, 1, or 2.");return a=h.clone(e,a),a[r]=n.x,a[r+3]=n.y,a[r+6]=n.z,a};var w=new e;h.getScale=function(r,n){if(!t(r))throw new i("matrix is required.");return t(n)||(n=new e),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],w)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],w)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],w)),n};var f=new e;h.getMaximumScale=function(r){return h.getScale(r,f),e.getMaximumComponent(f)},h.multiply=function(e,r,n){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");var a=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],o=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],u=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],w=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],f=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],c=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],d=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],l=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return t(n)?(n[0]=a,n[1]=o,n[2]=u,n[3]=s,n[4]=w,n[5]=f,n[6]=c,n[7]=d,n[8]=l,n):new h(a,s,c,o,w,d,u,f,l)},h.multiplyByVector=function(r,n,a){if(!t(r))throw new i("matrix is required");if(!t(n))throw new i("cartesian is required");var o=n.x,u=n.y,s=n.z,h=r[0]*o+r[3]*u+r[6]*s,w=r[1]*o+r[4]*u+r[7]*s,f=r[2]*o+r[5]*u+r[8]*s;return t(a)?(a.x=h,a.y=w,a.z=f,a):new e(h,w,f)},h.multiplyByScalar=function(e,r,n){if(!t(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");return t(n)?(n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n):new h(e[0]*r,e[3]*r,e[6]*r,e[1]*r,e[4]*r,e[7]*r,e[2]*r,e[5]*r,e[8]*r)},h.negate=function(e,r){if(!t(e))throw new i("matrix is required");return t(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r):new h(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},h.transpose=function(e,r){if(!t(e))throw new i("matrix is required");var n=e[0],a=e[3],o=e[6],u=e[1],s=e[4],w=e[7],f=e[2],c=e[5],d=e[8];return t(r)?(r[0]=n,r[1]=a,r[2]=o,r[3]=u,r[4]=s,r[5]=w,r[6]=f,r[7]=c,r[8]=d,r):new h(n,u,f,a,s,c,o,w,d)};var c=[1,0,0],d=[2,2,1],l=new h,m=new h;return h.getEigenDecomposition=function(e,r){if(!t(e))throw new i("matrix is required.");var n=a.EPSILON20,w=10,f=0,c=0;
t(r)||(r={});for(var d=r.unitary=h.clone(h.IDENTITY,r.unitary),p=r.diagonal=h.clone(e,r.diagonal),y=n*o(p);w>c&&u(p)>y;)s(p,l),h.transpose(l,m),h.multiply(p,l,p),h.multiply(m,p,p),h.multiply(d,l,d),++f>2&&(++c,f=0);return r},h.abs=function(e,r){if(!t(e))throw new i("matrix is required");return t(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r):new h(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},h.determinant=function(e){if(!t(e))throw new i("matrix is required");var r=e[0],n=e[3],a=e[6],o=e[1],u=e[4],s=e[7],h=e[2],w=e[5],f=e[8];return r*(u*f-w*s)+o*(w*a-n*f)+h*(n*s-u*a)},h.inverse=function(e,r){if(!t(e))throw new i("matrix is required");var n=e[0],o=e[1],u=e[2],s=e[3],w=e[4],f=e[5],c=e[6],d=e[7],l=e[8],m=h.determinant(e);if(Math.abs(m)<=a.EPSILON15)throw new i("matrix is not invertible");t(r)||(r=new h),r[0]=w*l-d*f,r[1]=d*u-o*l,r[2]=o*f-w*u,r[3]=c*f-s*l,r[4]=n*l-c*u,r[5]=s*u-n*f,r[6]=s*d-c*w,r[7]=c*o-n*d,r[8]=n*w-s*o;var p=1/m;return h.multiplyByScalar(r,p,r)},h.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},h.equalsEpsilon=function(e,r,n){if("number"!=typeof n)throw new i("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=n&&Math.abs(e[1]-r[1])<=n&&Math.abs(e[2]-r[2])<=n&&Math.abs(e[3]-r[3])<=n&&Math.abs(e[4]-r[4])<=n&&Math.abs(e[5]-r[5])<=n&&Math.abs(e[6]-r[6])<=n&&Math.abs(e[7]-r[7])<=n&&Math.abs(e[8]-r[8])<=n},h.IDENTITY=n(new h(1,0,0,0,1,0,0,0,1)),h.COLUMN0ROW0=0,h.COLUMN0ROW1=1,h.COLUMN0ROW2=2,h.COLUMN1ROW0=3,h.COLUMN1ROW1=4,h.COLUMN1ROW2=5,h.COLUMN2ROW0=6,h.COLUMN2ROW1=7,h.COLUMN2ROW2=8,h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.equalsEpsilon=function(e,r){return h.equalsEpsilon(this,e,r)},h.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},h}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,i,n,a,o,u,s){"use strict";var h=function(e,r,i,n,a,o,u,s,h,w,f,c,d,l,m,p){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(h,0),this[3]=t(d,0),this[4]=t(r,0),this[5]=t(o,0),this[6]=t(w,0),this[7]=t(l,0),this[8]=t(i,0),this[9]=t(u,0),this[10]=t(f,0),this[11]=t(m,0),this[12]=t(n,0),this[13]=t(s,0),this[14]=t(c,0),this[15]=t(p,0)};h.packedLength=16,h.pack=function(e,r,a){if(!i(e))throw new n("value is required");if(!i(r))throw new n("array is required");a=t(a,0),r[a++]=e[0],r[a++]=e[1],r[a++]=e[2],r[a++]=e[3],r[a++]=e[4],r[a++]=e[5],r[a++]=e[6],r[a++]=e[7],r[a++]=e[8],r[a++]=e[9],r[a++]=e[10],r[a++]=e[11],r[a++]=e[12],r[a++]=e[13],r[a++]=e[14],r[a]=e[15]},h.unpack=function(e,r,a){if(!i(e))throw new n("array is required");return r=t(r,0),i(a)||(a=new h),a[0]=e[r++],a[1]=e[r++],a[2]=e[r++],a[3]=e[r++],a[4]=e[r++],a[5]=e[r++],a[6]=e[r++],a[7]=e[r++],a[8]=e[r++],a[9]=e[r++],a[10]=e[r++],a[11]=e[r++],a[12]=e[r++],a[13]=e[r++],a[14]=e[r++],a[15]=e[r],a},h.clone=function(e,r){return i(e)?i(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new h(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},h.fromArray=h.unpack,h.fromColumnMajorArray=function(e,r){if(!i(e))throw new n("values is required");return h.clone(e,r)},h.fromRowMajorArray=function(e,r){if(!i(e))throw new n("values is required.");return i(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new h(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},h.fromRotationTranslation=function(e,r,t){if(!i(e))throw new n("rotation is required.");if(!i(r))throw new n("translation is required.");return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=0,t[4]=e[3],t[5]=e[4],t[6]=e[5],t[7]=0,t[8]=e[6],t[9]=e[7],t[10]=e[8],t[11]=0,t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=1,t):new h(e[0],e[3],e[6],r.x,e[1],e[4],e[7],r.y,e[2],e[5],e[8],r.z,0,0,0,1)},new u,h.fromTranslationQuaternionRotationScale=function(e,r,t,a){if(!i(e))throw new n("translation is required.");if(!i(r))throw new n("rotation is required.");if(!i(t))throw new n("scale is required.");i(a)||(a=new h);var o=t.x,u=t.y,s=t.z,w=r.x*r.x,f=r.x*r.y,c=r.x*r.z,d=r.x*r.w,l=r.y*r.y,m=r.y*r.z,p=r.y*r.w,y=r.z*r.z,g=r.z*r.w,q=r.w*r.w,v=w-l-y+q,x=2*(f-g),M=2*(c+p),b=2*(f+g),z=-w+l-y+q,S=2*(m-d),E=2*(c-p),R=2*(m+d),O=-w-l+y+q;return a[0]=v*o,a[1]=b*o,a[2]=E*o,a[3]=0,a[4]=x*u,a[5]=z*u,a[6]=R*u,a[7]=0,a[8]=M*s,a[9]=S*s,a[10]=O*s,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},h.fromTranslation=function(e,r){return h.fromRotationTranslation(u.IDENTITY,e,r)},h.fromScale=function(e,r){if(!i(e))throw new n("scale is required.");return i(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new h(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},h.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return i(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new h(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var w=new e,f=new e,c=new e;h.fromCamera=function(r,t){if(!i(r))throw new n("camera is required.");var a=r.eye,o=r.target,u=r.up;if(!i(a))throw new n("camera.eye is required.");if(!i(o))throw new n("camera.target is required.");if(!i(u))throw new n("camera.up is required.");e.normalize(e.subtract(o,a,w),w),e.normalize(e.cross(w,u,f),f),e.normalize(e.cross(f,w,c),c);var s=f.x,d=f.y,l=f.z,m=w.x,p=w.y,y=w.z,g=c.x,q=c.y,v=c.z,x=a.x,M=a.y,b=a.z,z=s*-x+d*-M+l*-b,S=g*-x+q*-M+v*-b,E=m*x+p*M+y*b;return i(t)?(t[0]=s,t[1]=g,t[2]=-m,t[3]=0,t[4]=d,t[5]=q,t[6]=-p,t[7]=0,t[8]=l,t[9]=v,t[10]=-y,t[11]=0,t[12]=z,t[13]=S,t[14]=E,t[15]=1,t):new h(s,d,l,z,g,q,v,S,-m,-p,-y,E,0,0,0,1)},h.computePerspectiveFieldOfView=function(e,r,t,a,o){if(0>=e||e>Math.PI)throw new n("fovY must be in [0, PI).");if(0>=r)throw new n("aspectRatio must be greater than zero.");if(0>=t)throw new n("near must be greater than zero.");if(0>=a)throw new n("far must be greater than zero.");var u=Math.tan(.5*e),s=1/u,w=s/r,f=(a+t)/(t-a),c=2*a*t/(t-a);return i(o)?(o[0]=w,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=f,o[11]=-1,o[12]=0,o[13]=0,o[14]=c,o[15]=0,o):new h(w,0,0,0,0,s,0,0,0,0,f,c,0,0,-1,0)},h.computeOrthographicOffCenter=function(e,r,t,a,o,u,s){if(!i(e))throw new n("left is required.");if(!i(r))throw new n("right is required.");if(!i(t))throw new n("bottom is required.");if(!i(a))throw new n("top is required.");if(!i(o))throw new n("near is required.");if(!i(u))throw new n("far is required.");var w=1/(r-e),f=1/(a-t),c=1/(u-o),d=-(r+e)*w,l=-(a+t)*f,m=-(u+o)*c;return w*=2,f*=2,c*=-2,i(s)?(s[0]=w,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=f,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=c,s[11]=0,s[12]=d,s[13]=l,s[14]=m,s[15]=1,s):new h(w,0,0,d,0,f,0,l,0,0,c,m,0,0,0,1)},h.computePerspectiveOffCenter=function(e,r,t,a,o,u,s){if(!i(e))throw new n("left is required.");if(!i(r))throw new n("right is required.");if(!i(t))throw new n("bottom is required.");if(!i(a))throw new n("top is required.");if(!i(o))throw new n("near is required.");if(!i(u))throw new n("far is required.");var w=2*o/(r-e),f=2*o/(a-t),c=(r+e)/(r-e),d=(a+t)/(a-t),l=-(u+o)/(u-o),m=-1,p=-2*u*o/(u-o);return i(s)?(s[0]=w,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=f,s[6]=0,s[7]=0,s[8]=c,s[9]=d,s[10]=l,s[11]=m,s[12]=0,s[13]=0,s[14]=p,s[15]=0,s):new h(w,0,c,0,0,f,d,0,0,0,l,p,0,0,m,0)},h.computeInfinitePerspectiveOffCenter=function(e,r,t,a,o,u){if(!i(e))throw new n("left is required.");if(!i(r))throw new n("right is required.");if(!i(t))throw new n("bottom is required.");if(!i(a))throw new n("top is required.");if(!i(o))throw new n("near is required.");var s=2*o/(r-e),w=2*o/(a-t),f=(r+e)/(r-e),c=(a+t)/(a-t),d=-1,l=-1,m=-2*o;return i(u)?(u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=w,u[6]=0,u[7]=0,u[8]=f,u[9]=c,u[10]=d,u[11]=l,u[12]=0,u[13]=0,u[14]=m,u[15]=0,u):new h(s,0,f,0,0,w,c,0,0,0,d,m,0,0,l,0)},h.computeViewportTransformation=function(e,r,n,a){e=t(e,t.EMPTY_OBJECT);var o=t(e.x,0),u=t(e.y,0),s=t(e.width,0),w=t(e.height,0);r=t(r,0),n=t(n,1);var f=.5*s,c=.5*w,d=.5*(n-r),l=f,m=c,p=d,y=o+f,g=u+c,q=r+d,v=1;return i(a)?(a[0]=l,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=m,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=p,a[11]=0,a[12]=y,a[13]=g,a[14]=q,a[15]=v,a):new h(l,0,0,y,0,m,0,g,0,0,p,q,0,0,0,v)},h.toArray=function(e,r){if(!i(e))throw new n("matrix is required");return i(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},h.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new n("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new n("column must be 0, 1, 2, or 3.");return 4*e+r},h.getColumn=function(e,t,a){if(!i(e))throw new n("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new n("index must be 0, 1, 2, or 3.");var o=4*t,u=e[o],s=e[o+1],h=e[o+2],w=e[o+3];return i(a)?(a.x=u,a.y=s,a.z=h,a.w=w,a):new r(u,s,h,w)},h.setColumn=function(e,r,t,a){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new n("index must be 0, 1, 2, or 3.");a=h.clone(e,a);var o=4*r;return a[o]=t.x,a[o+1]=t.y,a[o+2]=t.z,a[o+3]=t.w,a},h.getRow=function(e,t,a){if(!i(e))throw new n("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new n("index must be 0, 1, 2, or 3.");var o=e[t],u=e[t+4],s=e[t+8],h=e[t+12];return i(a)?(a.x=o,a.y=u,a.z=s,a.w=h,a):new r(o,u,s,h)},h.setRow=function(e,r,t,a){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new n("index must be 0, 1, 2, or 3.");return a=h.clone(e,a),a[r]=t.x,a[r+4]=t.y,a[r+8]=t.z,a[r+12]=t.w,a};var d=new e;h.getScale=function(r,t){if(!i(r))throw new n("matrix is required.");return i(t)||(t=new e),t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],d)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],d)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],d)),t};var l=new e;h.getMaximumScale=function(r){return h.getScale(r,l),e.getMaximumComponent(l)},h.multiply=function(e,r,t){if(!i(e))throw new n("left is required");if(!i(r))throw new n("right is required");var a=e[0],o=e[1],u=e[2],s=e[3],w=e[4],f=e[5],c=e[6],d=e[7],l=e[8],m=e[9],p=e[10],y=e[11],g=e[12],q=e[13],v=e[14],x=e[15],M=r[0],b=r[1],z=r[2],S=r[3],E=r[4],R=r[5],O=r[6],_=r[7],T=r[8],P=r[9],I=r[10],C=r[11],N=r[12],A=r[13],U=r[14],L=r[15],W=a*M+w*b+l*z+g*S,D=o*M+f*b+m*z+q*S,V=u*M+c*b+p*z+v*S,B=s*M+d*b+y*z+x*S,k=a*E+w*R+l*O+g*_,j=o*E+f*R+m*O+q*_,H=u*E+c*R+p*O+v*_,F=s*E+d*R+y*O+x*_,G=a*T+w*P+l*I+g*C,Z=o*T+f*P+m*I+q*C,Y=u*T+c*P+p*I+v*C,X=s*T+d*P+y*I+x*C,K=a*N+w*A+l*U+g*L,J=o*N+f*A+m*U+q*L,Q=u*N+c*A+p*U+v*L,$=s*N+d*A+y*U+x*L;return i(t)?(t[0]=W,t[1]=D,t[2]=V,t[3]=B,t[4]=k,t[5]=j,t[6]=H,t[7]=F,t[8]=G,t[9]=Z,t[10]=Y,t[11]=X,t[12]=K,t[13]=J,t[14]=Q,t[15]=$,t):new h(W,k,G,K,D,j,Z,J,V,H,Y,Q,B,F,X,$)},h.multiplyTransformation=function(e,r,t){if(!i(e))throw new n("left is required");if(!i(r))throw new n("right is required");var a=e[0],o=e[1],u=e[2],s=e[4],w=e[5],f=e[6],c=e[8],d=e[9],l=e[10],m=e[12],p=e[13],y=e[14],g=r[0],q=r[1],v=r[2],x=r[4],M=r[5],b=r[6],z=r[8],S=r[9],E=r[10],R=r[12],O=r[13],_=r[14],T=a*g+s*q+c*v,P=o*g+w*q+d*v,I=u*g+f*q+l*v,C=a*x+s*M+c*b,N=o*x+w*M+d*b,A=u*x+f*M+l*b,U=a*z+s*S+c*E,L=o*z+w*S+d*E,W=u*z+f*S+l*E,D=a*R+s*O+c*_+m,V=o*R+w*O+d*_+p,B=u*R+f*O+l*_+y;return i(t)?(t[0]=T,t[1]=P,t[2]=I,t[3]=0,t[4]=C,t[5]=N,t[6]=A,t[7]=0,t[8]=U,t[9]=L,t[10]=W,t[11]=0,t[12]=D,t[13]=V,t[14]=B,t[15]=1,t):new h(T,C,U,D,P,N,L,V,I,A,W,B,0,0,0,1)},h.multiplyByTranslation=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("translation is required");var a=r.x,o=r.y,u=r.z,s=a*e[0]+o*e[4]+u*e[8]+e[12],w=a*e[1]+o*e[5]+u*e[9]+e[13],f=a*e[2]+o*e[6]+u*e[10]+e[14];return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=s,t[13]=w,t[14]=f,t[15]=e[15],t):new h(e[0],e[4],e[8],s,e[1],e[5],e[9],w,e[2],e[6],e[10],f,e[3],e[7],e[11],e[15])};var m=new e;return h.multiplyByUniformScale=function(e,r,t){if("number"!=typeof r)throw new n("scale is required");return m.x=r,m.y=r,m.z=r,h.multiplyByScale(e,m,t)},h.multiplyByScale=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("scale is required");var a=r.x,o=r.y,u=r.z;return 1===a&&1===o&&1===u?h.clone(e,t):i(t)?(t[0]=a*e[0],t[1]=a*e[1],t[2]=a*e[2],t[3]=0,t[4]=o*e[4],t[5]=o*e[5],t[6]=o*e[6],t[7]=0,t[8]=u*e[8],t[9]=u*e[9],t[10]=u*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t):new h(a*e[0],o*e[4],u*e[8],e[12],a*e[1],o*e[5],u*e[9],e[13],a*e[2],o*e[6],u*e[10],e[14],0,0,0,1)},h.multiplyByVector=function(e,t,a){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");var o=t.x,u=t.y,s=t.z,h=t.w,w=e[0]*o+e[4]*u+e[8]*s+e[12]*h,f=e[1]*o+e[5]*u+e[9]*s+e[13]*h,c=e[2]*o+e[6]*u+e[10]*s+e[14]*h,d=e[3]*o+e[7]*u+e[11]*s+e[15]*h;return i(a)?(a.x=w,a.y=f,a.z=c,a.w=d,a):new r(w,f,c,d)},h.multiplyByPointAsVector=function(r,t,a){if(!i(r))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");var o=t.x,u=t.y,s=t.z,h=r[0]*o+r[4]*u+r[8]*s,w=r[1]*o+r[5]*u+r[9]*s,f=r[2]*o+r[6]*u+r[10]*s;return i(a)?(a.x=h,a.y=w,a.z=f,a):new e(h,w,f)},h.multiplyByPoint=function(r,t,a){if(!i(r))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");var o=t.x,u=t.y,s=t.z,h=r[0]*o+r[4]*u+r[8]*s+r[12],w=r[1]*o+r[5]*u+r[9]*s+r[13],f=r[2]*o+r[6]*u+r[10]*s+r[14];return i(a)?(a.x=h,a.y=w,a.z=f,a):new e(h,w,f)},h.multiplyByScalar=function(e,r,t){if(!i(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");return i(t)?(t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t):new h(e[0]*r,e[4]*r,e[8]*r,e[12]*r,e[1]*r,e[5]*r,e[9]*r,e[13]*r,e[2]*r,e[6]*r,e[10]*r,e[14]*r,e[3]*r,e[7]*r,e[11]*r,e[15]*r)},h.negate=function(e,r){if(!i(e))throw new n("matrix is required");return i(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r):new h(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},h.transpose=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))return new h(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var t=e[1],a=e[2],o=e[3],u=e[6],s=e[7],w=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=a,r[9]=u,r[10]=e[10],r[11]=e[14],r[12]=o,r[13]=s,r[14]=w,r[15]=e[15],r},h.abs=function(e,r){if(!i(e))throw new n("matrix is required");return i(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r):new h(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},h.equals=function(e,r){return e===r||i(e)&&i(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[11]===r[11]&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[15]===r[15]},h.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new n("epsilon must be a number");return e===r||i(e)&&i(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},h.getTranslation=function(r,t){if(!i(r))throw new n("matrix is required");return i(t)?(t.x=r[12],t.y=r[13],t.z=r[14],t):new e(r[12],r[13],r[14])},h.getRotation=function(e,r){if(!i(e))throw new n("matrix is required");return i(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r):new u(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},h.inverse=function(e,r){if(!i(e))throw new n("matrix is required");var t=e[0],a=e[4],u=e[8],w=e[12],f=e[1],c=e[5],d=e[9],l=e[13],m=e[2],p=e[6],y=e[10],g=e[14],q=e[3],v=e[7],x=e[11],M=e[15],b=y*M,z=g*x,S=p*M,E=g*v,R=p*x,O=y*v,_=m*M,T=g*q,P=m*x,I=y*q,C=m*v,N=p*q,A=b*c+E*d+R*l-(z*c+S*d+O*l),U=z*f+_*d+I*l-(b*f+T*d+P*l),L=S*f+T*c+C*l-(E*f+_*c+N*l),W=O*f+P*c+N*d-(R*f+I*c+C*d),D=z*a+S*u+O*w-(b*a+E*u+R*w),V=b*t+T*u+P*w-(z*t+_*u+I*w),B=E*t+_*a+N*w-(S*t+T*a+C*w),k=R*t+I*a+C*u-(O*t+P*a+N*u);b=u*l,z=w*d,S=a*l,E=w*c,R=a*d,O=u*c,_=t*l,T=w*f,P=t*d,I=u*f,C=t*c,N=a*f;var j=b*v+E*x+R*M-(z*v+S*x+O*M),H=z*q+_*x+I*M-(b*q+T*x+P*M),F=S*q+T*v+C*M-(E*q+_*v+N*M),G=O*q+P*v+N*x-(R*q+I*v+C*x),Z=S*y+O*g+z*p-(R*g+b*p+E*y),Y=P*g+b*m+T*y-(_*y+I*g+z*m),X=_*p+N*g+E*m-(C*g+S*m+T*p),K=C*y+R*m+I*p-(P*p+N*y+O*m),J=t*A+a*U+u*L+w*W;if(Math.abs(J)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return J=1/J,i(r)?(r[0]=A*J,r[1]=U*J,r[2]=L*J,r[3]=W*J,r[4]=D*J,r[5]=V*J,r[6]=B*J,r[7]=k*J,r[8]=j*J,r[9]=H*J,r[10]=F*J,r[11]=G*J,r[12]=Z*J,r[13]=Y*J,r[14]=X*J,r[15]=K*J,r):new h(A*J,D*J,j*J,Z*J,U*J,V*J,H*J,Y*J,L*J,B*J,F*J,X*J,W*J,k*J,G*J,K*J)},h.inverseTransformation=function(e,r){if(!i(e))throw new n("matrix is required");var t=e[0],a=e[1],o=e[2],u=e[4],s=e[5],w=e[6],f=e[8],c=e[9],d=e[10],l=e[12],m=e[13],p=e[14],y=-t*l-a*m-o*p,g=-u*l-s*m-w*p,q=-f*l-c*m-d*p;return i(r)?(r[0]=t,r[1]=u,r[2]=f,r[3]=0,r[4]=a,r[5]=s,r[6]=c,r[7]=0,r[8]=o,r[9]=w,r[10]=d,r[11]=0,r[12]=y,r[13]=g,r[14]=q,r[15]=1,r):new h(t,a,o,y,u,s,w,g,f,c,d,q,0,0,0,1)},h.IDENTITY=a(new h(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),h.COLUMN0ROW0=0,h.COLUMN0ROW1=1,h.COLUMN0ROW2=2,h.COLUMN0ROW3=3,h.COLUMN1ROW0=4,h.COLUMN1ROW1=5,h.COLUMN1ROW2=6,h.COLUMN1ROW3=7,h.COLUMN2ROW0=8,h.COLUMN2ROW1=9,h.COLUMN2ROW2=10,h.COLUMN2ROW3=11,h.COLUMN3ROW0=12,h.COLUMN3ROW1=13,h.COLUMN3ROW2=14,h.COLUMN3ROW3=15,h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.equalsEpsilon=function(e,r){return h.equalsEpsilon(this,e,r)},h.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},h}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,i,n,a,o){"use strict";var u=function(e,t,i,n){this.west=r(e,0),this.south=r(t,0),this.east=r(i,0),this.north=r(n,0)};u.fromDegrees=function(e,i,n,a,s){return e=o.toRadians(r(e,0)),i=o.toRadians(r(i,0)),n=o.toRadians(r(n,0)),a=o.toRadians(r(a,0)),t(s)?(s.west=e,s.south=i,s.east=n,s.north=a,s):new u(e,i,n,a)},u.fromCartographicArray=function(e,r){if(!t(e))throw new i("cartographics is required.");for(var n=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,s=-Number.MAX_VALUE,h=0,w=e.length;w>h;h++){var f=e[h];n=Math.min(n,f.longitude),a=Math.max(a,f.longitude),o=Math.min(o,f.latitude),s=Math.max(s,f.latitude)}return t(r)?(r.west=n,r.south=o,r.east=a,r.north=s,r):new u(n,o,a,s)},u.packedLength=4,u.pack=function(e,n,a){if(!t(e))throw new i("value is required");if(!t(n))throw new i("array is required");a=r(a,0),n[a++]=e.west,n[a++]=e.south,n[a++]=e.east,n[a]=e.north},u.unpack=function(e,n,a){if(!t(e))throw new i("array is required");return n=r(n,0),t(a)||(a=new u),a.west=e[n++],a.south=e[n++],a.east=e[n++],a.north=e[n],a},u.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new u(e.west,e.south,e.east,e.north):void 0},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},u.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new i("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},u.validate=function(e){if(!t(e))throw new i("rectangle is required");var r=e.north;if("number"!=typeof r)throw new i("north is required to be a number.");if(r<-o.PI_OVER_TWO||r>o.PI_OVER_TWO)throw new i("north must be in the interval [-Pi/2, Pi/2].");var n=e.south;if("number"!=typeof n)throw new i("south is required to be a number.");if(n<-o.PI_OVER_TWO||n>o.PI_OVER_TWO)throw new i("south must be in the interval [-Pi/2, Pi/2].");var a=e.west;if("number"!=typeof a)throw new i("west is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new i("west must be in the interval [-Pi, Pi].");var u=e.east;if("number"!=typeof u)throw new i("east is required to be a number.");if(u<-Math.PI||u>Math.PI)throw new i("east must be in the interval [-Pi, Pi].")},u.getSouthwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.south,n.height=0,n):new e(r.west,r.south)},u.getNorthwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.north,n.height=0,n):new e(r.west,r.north)},u.getNortheast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.north,n.height=0,n):new e(r.east,r.north)},u.getSoutheast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.south,n.height=0,n):new e(r.east,r.south)},u.getCenter=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=.5*(r.west+r.east),n.latitude=.5*(r.south+r.north),n.height=0,n):new e(.5*(r.west+r.east),.5*(r.south+r.north))},u.intersectWith=function(e,r,n){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("otherRectangle is required.");var a=Math.max(e.west,r.west),o=Math.max(e.south,r.south),s=Math.min(e.east,r.east),h=Math.min(e.north,r.north);return t(n)?(n.west=a,n.south=o,n.east=s,n.north=h,n):new u(a,o,s,h)},u.contains=function(e,r){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("cartographic is required.");return r.longitude>=e.west&&r.longitude<=e.east&&r.latitude>=e.south&&r.latitude<=e.north},u.isEmpty=function(e){if(!t(e))throw new i("rectangle is required");return e.west>=e.east||e.south>=e.north};var s=new e;return u.subsample=function(e,a,u,h){if(!t(e))throw new i("rectangle is required");a=r(a,n.WGS84),u=r(u,0),t(h)||(h=[]);var w=0,f=e.north,c=e.south,d=e.east,l=e.west,m=s;m.height=u,m.longitude=l,m.latitude=f,h[w]=a.cartographicToCartesian(m,h[w]),w++,m.longitude=d,h[w]=a.cartographicToCartesian(m,h[w]),w++,m.latitude=c,h[w]=a.cartographicToCartesian(m,h[w]),w++,m.longitude=l,h[w]=a.cartographicToCartesian(m,h[w]),w++,m.latitude=0>f?f:c>0?c:0;for(var p=1;8>p;++p){var y=-Math.PI+p*o.PI_OVER_TWO;y>l&&d>y&&(m.longitude=y,h[w]=a.cartographicToCartesian(m,h[w]),w++)}return 0===m.latitude&&(m.longitude=l,h[w]=a.cartographicToCartesian(m,h[w]),w++,m.longitude=d,h[w]=a.cartographicToCartesian(m,h[w]),w++),h.length=w,h},u.MAX_VALUE=a(new u(-Math.PI,-o.PI_OVER_TWO,Math.PI,o.PI_OVER_TWO)),u}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,r,t,i,n,a,o,u,s,h,w){"use strict";var f=function(r,i){this.center=e.clone(t(r,e.ZERO)),this.radius=t(i,0)},c=new e,d=new e,l=new e,m=new e,p=new e,y=new e,g=new e,q=new e,v=new e,x=new e,M=new e,b=new e;f.fromPoints=function(r,t){if(i(t)||(t=new f),!i(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var n=e.clone(r[0],g),a=e.clone(n,c),o=e.clone(n,d),u=e.clone(n,l),s=e.clone(n,m),h=e.clone(n,p),w=e.clone(n,y),z=r.length,S=1;z>S;S++){e.clone(r[S],n);var E=n.x,R=n.y,O=n.z;E<a.x&&e.clone(n,a),E>s.x&&e.clone(n,s),R<o.y&&e.clone(n,o),R>h.y&&e.clone(n,h),O<u.z&&e.clone(n,u),O>w.z&&e.clone(n,w)}var _=e.magnitudeSquared(e.subtract(s,a,q)),T=e.magnitudeSquared(e.subtract(h,o,q)),P=e.magnitudeSquared(e.subtract(w,u,q)),I=a,C=s,N=_;T>N&&(N=T,I=o,C=h),P>N&&(N=P,I=u,C=w);var A=v;A.x=.5*(I.x+C.x),A.y=.5*(I.y+C.y),A.z=.5*(I.z+C.z);var U=e.magnitudeSquared(e.subtract(C,A,q)),L=Math.sqrt(U),W=x;W.x=a.x,W.y=o.y,W.z=u.z;var D=M;D.x=s.x,D.y=h.y,D.z=w.z;var V=e.multiplyByScalar(e.add(W,D,q),.5,b),B=0;for(S=0;z>S;S++){e.clone(r[S],n);var k=e.magnitude(e.subtract(n,V,q));k>B&&(B=k);var j=e.magnitudeSquared(e.subtract(n,A,q));if(j>U){var H=Math.sqrt(j);L=.5*(L+H),U=L*L;var F=H-L;A.x=(L*A.x+F*n.x)/H,A.y=(L*A.y+F*n.y)/H,A.z=(L*A.z+F*n.z)/H}}return B>L?(e.clone(A,t.center),t.radius=L):(e.clone(V,t.center),t.radius=B),t};var z=new o,S=new e,E=new e,R=new r,O=new r;f.fromRectangle2D=function(e,r,t){return f.fromRectangleWithHeights2D(e,r,0,0,t)},f.fromRectangleWithHeights2D=function(r,n,a,o,u){if(i(u)||(u=new f),!i(r))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;n=t(n,z),w.getSouthwest(r,R),R.height=a,w.getNortheast(r,O),O.height=o;var s=n.project(R,S),h=n.project(O,E),c=h.x-s.x,d=h.y-s.y,l=h.z-s.z;u.radius=.5*Math.sqrt(c*c+d*d+l*l);var m=u.center;return m.x=s.x+.5*c,m.y=s.y+.5*d,m.z=s.z+.5*l,u};var _=[];f.fromRectangle3D=function(e,r,n,o){r=t(r,a.WGS84),n=t(n,0);var u;return i(e)&&(u=w.subsample(e,r,n,_)),f.fromPoints(u,o)},f.fromVertices=function(r,a,o,u){if(i(u)||(u=new f),!i(r)||0===r.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;if(a=t(a,e.ZERO),o=t(o,3),3>o)throw new n("stride must be 3 or greater.");var s=g;s.x=r[0]+a.x,s.y=r[1]+a.y,s.z=r[2]+a.z;for(var h=e.clone(s,c),w=e.clone(s,d),z=e.clone(s,l),S=e.clone(s,m),E=e.clone(s,p),R=e.clone(s,y),O=r.length,_=0;O>_;_+=o){var T=r[_]+a.x,P=r[_+1]+a.y,I=r[_+2]+a.z;s.x=T,s.y=P,s.z=I,T<h.x&&e.clone(s,h),T>S.x&&e.clone(s,S),P<w.y&&e.clone(s,w),P>E.y&&e.clone(s,E),I<z.z&&e.clone(s,z),I>R.z&&e.clone(s,R)}var C=e.magnitudeSquared(e.subtract(S,h,q)),N=e.magnitudeSquared(e.subtract(E,w,q)),A=e.magnitudeSquared(e.subtract(R,z,q)),U=h,L=S,W=C;N>W&&(W=N,U=w,L=E),A>W&&(W=A,U=z,L=R);var D=v;D.x=.5*(U.x+L.x),D.y=.5*(U.y+L.y),D.z=.5*(U.z+L.z);var V=e.magnitudeSquared(e.subtract(L,D,q)),B=Math.sqrt(V),k=x;k.x=h.x,k.y=w.y,k.z=z.z;var j=M;j.x=S.x,j.y=E.y,j.z=R.z;var H=e.multiplyByScalar(e.add(k,j,q),.5,b),F=0;for(_=0;O>_;_+=o){s.x=r[_]+a.x,s.y=r[_+1]+a.y,s.z=r[_+2]+a.z;var G=e.magnitude(e.subtract(s,H,q));G>F&&(F=G);var Z=e.magnitudeSquared(e.subtract(s,D,q));if(Z>V){var Y=Math.sqrt(Z);B=.5*(B+Y),V=B*B;var X=Y-B;D.x=(B*D.x+X*s.x)/Y,D.y=(B*D.y+X*s.y)/Y,D.z=(B*D.z+X*s.z)/Y}}return F>B?(e.clone(D,u.center),u.radius=B):(e.clone(H,u.center),u.radius=F),u},f.fromCornerPoints=function(r,t,a){if(!i(r)||!i(t))throw new n("corner and oppositeCorner are required.");i(a)||(a=new f);var o=a.center;return e.add(r,t,o),e.multiplyByScalar(o,.5,o),a.radius=e.distance(o,t),a},f.fromEllipsoid=function(r,t){if(!i(r))throw new n("ellipsoid is required.");return i(t)||(t=new f),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t},f.clone=function(r,t){return i(r)?i(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new f(r.center,r.radius):void 0},f.packedLength=4,f.pack=function(e,r,a){if(!i(e))throw new n("value is required");if(!i(r))throw new n("array is required");a=t(a,0);var o=e.center;r[a++]=o.x,r[a++]=o.y,r[a++]=o.z,r[a]=e.radius},f.unpack=function(e,r,a){if(!i(e))throw new n("array is required");r=t(r,0),i(a)||(a=new f);var o=a.center;return o.x=e[r++],o.y=e[r++],o.z=e[r++],a.radius=e[r],a};var T=new e,P=new e;f.union=function(r,t,a){if(!i(r))throw new n("left is required.");if(!i(t))throw new n("right is required.");i(a)||(a=new f);var o=r.center,u=t.center;e.add(o,u,P);var s=e.multiplyByScalar(P,.5,P),h=e.magnitude(e.subtract(o,s,T))+r.radius,w=e.magnitude(e.subtract(u,s,T))+t.radius;return a.radius=Math.max(h,w),e.clone(s,a.center),a};var I=new e;f.expand=function(r,t,a){if(!i(r))throw new n("sphere is required.");if(!i(t))throw new n("point is required.");a=f.clone(r,a);var o=e.magnitude(e.subtract(t,a.center,I));return o>a.radius&&(a.radius=o),a},f.intersect=function(r,t){if(!i(r))throw new n("sphere is required.");if(!i(t))throw new n("plane is required.");var a=r.center,o=r.radius,s=e.dot(t,a)+t.w;return-o>s?u.OUTSIDE:o>s?u.INTERSECTING:u.INSIDE},f.transform=function(e,r,t){if(!i(e))throw new n("sphere is required.");if(!i(r))throw new n("transform is required.");return i(t)||(t=new f),t.center=h.multiplyByPoint(r,e.center,t.center),t.radius=h.getMaximumScale(r)*e.radius,t};var C=new e;f.distanceSquaredTo=function(r,t){if(!i(r))throw new n("sphere is required.");if(!i(t))throw new n("cartesian is required.");var a=e.subtract(r.center,t,C);return e.magnitudeSquared(a)-r.radius*r.radius},f.transformWithoutScale=function(e,r,t){if(!i(e))throw new n("sphere is required.");if(!i(r))throw new n("transform is required.");return i(t)||(t=new f),t.center=h.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var N=new e;f.getPlaneDistances=function(r,t,a,o){if(!i(r))throw new n("sphere is required.");if(!i(t))throw new n("position is required.");if(!i(a))throw new n("direction is required.");i(o)||(o=new s);var u=e.subtract(r.center,t,N),h=e.multiplyByScalar(a,e.dot(a,u),N),w=e.magnitude(h);return o.start=w-r.radius,o.stop=w+r.radius,o};for(var A=new e,U=new e,L=new e,W=new e,D=new e,V=new r,B=new Array(8),k=0;8>k;++k)B[k]=new e;var j=new o;return f.projectTo2D=function(r,a,o){if(!i(r))throw new n("sphere is required.");a=t(a,j);var u=a.ellipsoid,s=r.center,h=r.radius,w=u.geodeticSurfaceNormal(s,A),c=e.cross(e.UNIT_Z,w,U);e.normalize(c,c);var d=e.cross(w,c,L);e.normalize(d,d),e.multiplyByScalar(w,h,w),e.multiplyByScalar(d,h,d),e.multiplyByScalar(c,h,c);var l=e.negate(d,D),m=e.negate(c,W),p=B,y=p[0];e.add(w,d,y),e.add(y,c,y),y=p[1],e.add(w,d,y),e.add(y,m,y),y=p[2],e.add(w,l,y),e.add(y,m,y),y=p[3],e.add(w,l,y),e.add(y,c,y),e.negate(w,w),y=p[4],e.add(w,d,y),e.add(y,c,y),y=p[5],e.add(w,d,y),e.add(y,m,y),y=p[6],e.add(w,l,y),e.add(y,m,y),y=p[7],e.add(w,l,y),e.add(y,c,y);for(var g=p.length,q=0;g>q;++q){var v=p[q];e.add(s,v,v);var x=u.cartesianToCartographic(v,V);a.project(x,v)}o=f.fromPoints(p,o),s=o.center;var M=s.x,b=s.y,z=s.z;return s.x=z,s.y=M,s.z=b,o},f.equals=function(r,t){return r===t||i(r)&&i(t)&&e.equals(r.center,t.center)&&r.radius===t.radius
},f.prototype.intersect=function(e){return f.intersect(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.clone=function(e){return f.clone(this,e)},f}),define("Core/EllipsoidalOccluder",["./BoundingSphere","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Rectangle"],function(e,r,t,i,n,a,o){"use strict";function u(e,t,i){var n=e.transformPositionToScaledSpace(t,l),a=r.magnitudeSquared(n),o=Math.sqrt(a),u=r.divideByScalar(n,o,m);a=Math.max(1,a),o=Math.max(1,o);var s=r.dot(u,i),h=r.magnitude(r.cross(u,i,u)),w=1/o,f=Math.sqrt(a-1)*w;return 1/(s*w-h*f)}function s(e,t,i){return 0>=t||t===1/0||t!==t?void 0:r.multiplyByScalar(e,t,i)}function h(e,t){return e.transformPositionToScaledSpace(t,p),r.normalize(p,p)}var w=function(e,t){if(!i(e))throw new a("ellipsoid is required.");this._ellipsoid=e,this._cameraPosition=new r,this._cameraPositionInScaledSpace=new r,this._distanceToLimbInScaledSpaceSquared=0,i(t)&&(this.cameraPosition=t)};n(w.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){var t=this._ellipsoid,i=t.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),n=r.magnitudeSquared(i)-1;r.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=i,this._distanceToLimbInScaledSpaceSquared=n}}});var f=new r;w.prototype.isPointVisible=function(e){var r=this._ellipsoid,t=r.transformPositionToScaledSpace(e,f);return this.isScaledSpacePointVisible(t)},w.prototype.isScaledSpacePointVisible=function(e){var t=this._cameraPositionInScaledSpace,i=this._distanceToLimbInScaledSpaceSquared,n=r.subtract(e,t,f),a=-r.dot(n,t),o=a>i&&a*a/r.magnitudeSquared(n)>i;return!o},w.prototype.computeHorizonCullingPoint=function(e,t,n){if(!i(e))throw new a("directionToPoint is required");if(!i(t))throw new a("positions is required");i(n)||(n=new r);for(var o=this._ellipsoid,w=h(o,e),f=0,c=0,d=t.length;d>c;++c){var l=t[c],m=u(o,l,w);f=Math.max(f,m)}return s(w,f,n)};var c=new r;w.prototype.computeHorizonCullingPointFromVertices=function(e,n,o,w,f){if(!i(e))throw new a("directionToPoint is required");if(!i(n))throw new a("vertices is required");if(!i(o))throw new a("stride is required");i(f)||(f=new r),w=t(w,r.ZERO);for(var d=this._ellipsoid,l=h(d,e),m=0,p=0,y=n.length;y>p;p+=o){c.x=n[p]+w.x,c.y=n[p+1]+w.y,c.z=n[p+2]+w.z;var g=u(d,c,l);m=Math.max(m,g)}return s(l,m,f)};var d=[];w.prototype.computeHorizonCullingPointFromRectangle=function(t,n,u){if(!i(t))throw new a("rectangle is required.");var s=o.subsample(t,n,0,d),h=e.fromPoints(s);return r.magnitude(h.center)<.1*n.minimumRadius?void 0:this.computeHorizonCullingPoint(h.center,s,u)};var l=new r,m=new r,p=new r;return w}),define("Core/HeightmapTessellator",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,i,n,a,o){"use strict";var u={};return u.DEFAULT_STRUCTURE=a({heightScale:1,heightOffset:0,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1}),u.computeVertices=function(a){if(!t(a)||!t(a.heightmap))throw new i("options.heightmap is required.");if(!t(a.width)||!t(a.height))throw new i("options.width and options.height are required.");if(!t(a.vertices))throw new i("options.vertices is required.");if(!t(a.nativeRectangle))throw new i("options.nativeRectangle is required.");if(!t(a.skirtHeight))throw new i("options.skirtHeight is required.");var s,h,w,f,c=Math.cos,d=Math.sin,l=Math.sqrt,m=Math.atan,p=Math.exp,y=o.PI_OVER_TWO,g=o.toRadians,q=a.vertices,v=a.heightmap,x=a.width,M=a.height,b=a.skirtHeight,z=r(a.isGeographic,!0),S=r(a.ellipsoid,n.WGS84),E=1/S.maximumRadius,R=a.nativeRectangle,O=a.rectangle;t(O)?(s=O.west,h=O.south,w=O.east,f=O.north):z?(s=g(R.west),h=g(R.south),w=g(R.east),f=g(R.north)):(s=R.west*E,h=y-2*m(p(-R.south*E)),w=R.east*E,f=y-2*m(p(-R.north*E)));var _=r(a.relativeToCenter,e.ZERO),T=r(a.structure,u.DEFAULT_STRUCTURE),P=r(T.heightScale,u.DEFAULT_STRUCTURE.heightScale),I=r(T.heightOffset,u.DEFAULT_STRUCTURE.heightOffset),C=r(T.elementsPerHeight,u.DEFAULT_STRUCTURE.elementsPerHeight),N=r(T.stride,u.DEFAULT_STRUCTURE.stride),A=r(T.elementMultiplier,u.DEFAULT_STRUCTURE.elementMultiplier),U=r(T.isBigEndian,u.DEFAULT_STRUCTURE.isBigEndian),L=(R.east-R.west)/(x-1),W=(R.north-R.south)/(M-1),D=S.radiiSquared,V=D.x,B=D.y,k=D.z,j=0,H=65536,F=-65536,G=0,Z=M,Y=0,X=x;b>0&&(--G,++Z,--Y,++X);for(var K=G;Z>K;++K){var J=K;0>J&&(J=0),J>=M&&(J=M-1);var Q=R.north-W*J;Q=z?g(Q):y-2*m(p(-Q*E));for(var $=c(Q),er=d(Q),rr=k*er,tr=(Q-h)/(f-h),ir=Y;X>ir;++ir){var nr=ir;0>nr&&(nr=0),nr>=x&&(nr=x-1);var ar=R.west+L*nr;z?ar=g(ar):ar*=E;var or,ur=J*x*N+nr*N;if(1===C)or=v[ur];else{or=0;var sr;if(U)for(sr=0;C>sr;++sr)or=or*A+v[ur+sr];else for(sr=C-1;sr>=0;--sr)or=or*A+v[ur+sr]}or=or*P+I,F=Math.max(F,or),H=Math.min(H,or),(ir!==nr||K!==J)&&(or-=b);var hr=$*c(ar),wr=$*d(ar),fr=V*hr,cr=B*wr,dr=l(fr*hr+cr*wr+rr*er),lr=1/dr,mr=fr*lr,pr=cr*lr,yr=rr*lr;q[j++]=mr+hr*or-_.x,q[j++]=pr+wr*or-_.y,q[j++]=yr+er*or-_.z,q[j++]=or;var gr=(ar-s)/(w-s);q[j++]=gr,q[j++]=tr}}return{maximumHeight:F,minimumHeight:H}},u}),define("Core/formatError",["./defined"],function(e){"use strict";var r=function(r){var t,i=r.name,n=r.message;t=e(i)&&e(n)?i+": "+n:r.toString();var a=r.stack;return e(a)&&(t+="\n"+a),t};return r}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,r,t){"use strict";var i=function(i){var n,a=[],o={id:void 0,result:void 0,error:void 0};return function(u){var s=u.data;a.length=0,o.id=s.id,o.error=void 0,o.result=void 0;try{o.result=i(s.parameters,a)}catch(h){o.error=h instanceof Error?{name:h.name,message:h.message,stack:h.stack}:h}r(n)||(n=e(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(a.length=0);try{n(o,a)}catch(h){o.result=void 0,o.error="postMessage failed with error: "+t(h)+"\n  with responseMessage: "+JSON.stringify(o),n(o)}}};return i}),define("Workers/createVerticesFromHeightmap",["../Core/BoundingSphere","../Core/Ellipsoid","../Core/EllipsoidalOccluder","../Core/HeightmapTessellator","../Core/Rectangle","./createTaskProcessorWorker"],function(e,r,t,i,n,a){"use strict";function o(a,o){var u=6,s=a.width,h=a.height;a.skirtHeight>0&&(s+=2,h+=2);var w=new Float32Array(s*h*u);o.push(w.buffer),a.ellipsoid=r.clone(a.ellipsoid),a.rectangle=n.clone(a.rectangle),a.vertices=w;var f=i.computeVertices(a),c=e.fromVertices(w,a.relativeToCenter,u),d=a.ellipsoid,l=new t(d),m=l.computeHorizonCullingPointFromVertices(a.relativeToCenter,w,u,a.relativeToCenter);return{vertices:w.buffer,numberOfAttributes:u,minimumHeight:f.minimumHeight,maximumHeight:f.maximumHeight,gridWidth:s,gridHeight:h,boundingSphere3D:c,occludeePointInScaledSpace:m}}return a(o)})}();