/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2014 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=.5*3*Math.PI,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,o=e-Math.floor(e/r)*r;return o<-Math.PI?o+r:o>=Math.PI?o-r:o},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");for(var r=i.EPSILON10,o=i.PI,a=i.TWO_PI;-(o+r)>e;)e+=a;if(-o>e)return-o;for(;e>o+r;)e-=a;return e>o?o:e},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=e%i.TWO_PI;return 0>r?(r+i.TWO_PI)%i.TWO_PI:r},i.equalsEpsilon=function(e,i,o){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");return o=r(o,0),Math.abs(e-i)<=o};var o=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=o.length;if(e>=r)for(var t=o[r-1],i=r;e>=i;i++)o.push(t*i);return o[e]},i.incrementWrap=function(e,i,o){if(o=r(o,0),!t(e))throw new n("n is required.");if(o>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=o),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var a=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");a=new e(r)},i.nextRandomNumber=function(){return a.random()},i.acosClamped=function(e){return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){return Math.asin(i.clamp(e,-1,1))},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};o.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new o);var a=n.clock,s=n.cone,u=e(n.magnitude,1),f=u*Math.sin(s);return i.x=f*Math.cos(a),i.y=f*Math.sin(a),i.z=u*Math.cos(s),i},o.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new o(e,t,n)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o]=n.z},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i],a},o.fromArray=o.unpack,o.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},o.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},o.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},o.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var s=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,s),a=o.multiplyByScalar(e,1-i,a),o.add(s,a,a)};var u=new o,f=new o;o.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");o.normalize(e,u),o.normalize(n,f);var i=o.dot(u,f),a=o.magnitude(o.cross(u,f,u));return Math.atan2(a,i)};var l=new o;o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,l);return o.abs(i,i),n=i.x<=i.y?i.x<=i.z?o.clone(o.UNIT_X,n):o.clone(o.UNIT_Z,n):i.y<=i.z?o.clone(o.UNIT_Y,n):o.clone(o.UNIT_Z,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i},o.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var o=e.x,a=e.y,s=e.z,u=n.x,f=n.y,l=n.z,h=a*l-s*f,c=s*u-o*l,w=o*f-a*u;return i.x=h,i.y=c,i.z=w,i},o.fromDegrees=function(e,n,a,s,u){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var f=i.toRadians(e),l=i.toRadians(n);return o.fromRadians(f,l,a,s,u)};var h=new o,c=new o,w=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(n,i,a,s,u){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");a=e(a,0);var f=r(s)?s.radiiSquared:w,l=Math.cos(i);h.x=l*Math.cos(n),h.y=l*Math.sin(n),h.z=Math.sin(i),h=o.normalize(h,h),o.multiplyComponents(f,h,c);var d=Math.sqrt(o.dot(h,c));return c=o.divideByScalar(c,d,c),h=o.multiplyByScalar(h,a,h),r(u)||(u=new o),o.add(c,h,u)},o.fromDegreesArray=function(e,n,a){if(!r(e))throw new t("positions is required.");for(var s=new Array(e.length),u=0;u<e.length;u++)s[u]=i.toRadians(e[u]);return o.fromRadiansArray(s,n,a)},o.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(0!==e.length%2)throw new t("positions length must be a multiple of 2.");var a=e.length;r(i)?i.length=a/2:i=new Array(a/2);for(var s=0;a>s;s+=2){var u=e[s],f=e[s+1];i[s/2]=o.fromRadians(u,f,0,n,i[s/2])}return i},o.fromDegreesArrayHeights=function(e,n,a){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");for(var s=new Array(e.length),u=0;u<e.length;u+=3)s[u]=i.toRadians(e[u]),s[u+1]=i.toRadians(e[u+1]),s[u+2]=e[u+2];return o.fromRadiansArrayHeights(s,n,a)},o.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");var a=e.length;r(i)?i.length=a/3:i=new Array(a/3);for(var s=0;a>s;s+=3){var u=e[s],f=e[s+1],l=e[s+2];i[s/3]=o.fromRadians(u,f,l,n,i[s/3])}return i},o.ZERO=n(new o(0,0,0)),o.UNIT_X=n(new o(1,0,0)),o.UNIT_Y=n(new o(0,1,0)),o.UNIT_Z=n(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return o.fromRadians=function(n,i,a,s){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return a=e(a,0),r(s)?(s.longitude=n,s.latitude=i,s.height=a,s):new o(n,i,a)},o.fromDegrees=function(e,n,a,s){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),o.fromRadians(e,n,a,s)},o.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},o.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},o.toString=function(e){if(!r(e))throw new t("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},o.ZERO=n(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return o.toString(this)},o}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o,a,s){"use strict";var u=function(r,n,i){if(r=t(r,0),n=t(n,0),i=t(i,0),0>r||0>n||0>i)throw new o("All radii components must be greater than or equal to zero.");this._radii=new e(r,n,i),this._radiiSquared=new e(r*r,n*n,i*i),this._radiiToTheFourth=new e(r*r*r*r,n*n*n*n,i*i*i*i),this._oneOverRadii=new e(0===r?0:1/r,0===n?0:1/n,0===i?0:1/i),this._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===n?0:1/(n*n),0===i?0:1/(i*i)),this._minimumRadius=Math.min(r,n,i),this._maximumRadius=Math.max(r,n,i),this._centerToleranceSquared=s.EPSILON1};i(u.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),u.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new u(i.x,i.y,i.z)},u.fromCartesian3=function(e){return n(e)?new u(e.x,e.y,e.z):new u},u.WGS84=a(new u(6378137,6378137,6356752.314245179)),u.UNIT_SPHERE=a(new u(1,1,1)),u.MOON=a(new u(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.geocentricSurfaceNormal=e.normalize,u.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new o("cartographic is required.");var i=r.longitude,a=r.latitude,s=Math.cos(a),u=s*Math.cos(i),f=s*Math.sin(i),l=Math.sin(a);return n(t)||(t=new e),t.x=u,t.y=f,t.z=l,e.normalize(t,t)},u.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var f=new e,l=new e;u.prototype.cartographicToCartesian=function(r,t){var i=f,o=l;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,o);var a=Math.sqrt(e.dot(i,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(o,i,t)},u.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new o("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var h=new e,c=new e,w=new e;u.prototype.cartesianToCartographic=function(t,i){var o=this.scaleToGeodeticSurface(t,c);if(!n(o))return void 0;var a=this.geodeticSurfaceNormal(o,h),u=e.subtract(t,o,w),f=Math.atan2(a.y,a.x),l=Math.asin(a.z),d=s.sign(e.dot(u,t))*e.magnitude(u);return n(i)?(i.longitude=f,i.latitude=l,i.height=d,i):new r(f,l,d)},u.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new o("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var d=new e,m=new e;return u.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");var i=r.x,a=r.y,u=r.z,f=this._oneOverRadii,l=f.x,h=f.y,c=f.z,w=i*i*l*l,p=a*a*h*h,y=u*u*c*c,E=w+p+y,g=Math.sqrt(1/E),C=e.multiplyByScalar(r,g,d);if(E<this._centerToleranceSquared)return isFinite(g)?e.clone(C,t):void 0;var S=this._oneOverRadiiSquared,q=S.x,v=S.y,b=S.z,M=m;M.x=2*C.x*q,M.y=2*C.y*v,M.z=2*C.z*b;var x,A,R,I,T,O,N,F,z,D,L,_=(1-g)*e.magnitude(r)/(.5*e.magnitude(M)),B=0;do{_-=B,R=1/(1+_*q),I=1/(1+_*v),T=1/(1+_*b),O=R*R,N=I*I,F=T*T,z=O*R,D=N*I,L=F*T,x=w*O+p*N+y*F-1,A=w*z*q+p*D*v+y*L*b;var P=-2*A;B=x/P}while(Math.abs(x)>s.EPSILON12);return n(t)?(t.x=i*R,t.y=a*I,t.z=u*T,t):new e(i*R,a*I,u*T)},u.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");n(t)||(t=new e);var i=r.x,a=r.y,s=r.z,u=this._oneOverRadiiSquared,f=1/Math.sqrt(i*i*u.x+a*a*u.y+s*s*u.z);return e.multiplyByScalar(r,f,t)},u.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},u.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},u.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},u.prototype.toString=function(){return this._radii.toString()},u}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,o,a){"use strict";var s=function(e){this._ellipsoid=t(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(r,t){var i=this._semimajorAxis,o=r.longitude*i,a=r.latitude*i,s=r.height;return n(t)?(t.x=o,t.y=a,t.z=s,t):new e(o,a,s)},s.prototype.unproject=function(e,t){if(!n(e))throw new o("cartesian is required");var i=this._oneOverSemimajorAxis,a=e.x*i,s=e.y*i,u=e.z;return n(t)?(t.longitude=a,t.latitude=s,t.height=u,t):new r(a,s,u)},s}),define("Core/Intersect",[],function(){"use strict";var e={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};i.fromElements=function(e,t,n,o,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=o,a):new i(e,t,n,o)},i.fromColor=function(e,n){if(!r(e))throw new t("color is required");return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o++]=n.z,i[o]=n.w},i.unpack=function(n,o,a){if(!r(n))throw new t("array is required");return o=e(o,0),r(a)||(a=new i),a.x=n[o++],a.y=n[o++],a.z=n[o++],a.w=n[o],a},i.fromArray=i.unpack,i.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},i.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},i.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},i.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},i.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return i.subtract(e,n,o),i.magnitude(o)},i.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var o=i.magnitude(e);return n.x=e.x/o,n.y=e.y/o,n.z=e.z/o,n.w=e.w/o,n},i.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},i.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},i.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},i.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},i.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},i.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},i.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},i.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var a=new i;i.lerp=function(e,n,o,s){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof o)throw new t("t is required and must be a number.");if(!r(s))throw new t("result is required.");return i.multiplyByScalar(n,o,a),s=i.multiplyByScalar(e,1-o,s),i.add(a,s,s)};var s=new i;return i.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var o=i.normalize(e,s);return i.abs(o,o),n=o.x<=o.y?o.x<=o.z?o.x<=o.w?i.clone(i.UNIT_X,n):i.clone(i.UNIT_W,n):o.z<=o.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n):o.y<=o.z?o.y<=o.w?i.clone(i.UNIT_Y,n):i.clone(i.UNIT_W,n):o.z<=o.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},i.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i&&Math.abs(e.w-n.w)<=i},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,r){return i.equalsEpsilon(this,e,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o){"use strict";function a(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function s(e){for(var r=0,t=0;3>t;++t){var n=e[f.getElementIndex(w[t],c[t])];r+=2*n*n}return Math.sqrt(r)}function u(e,r){for(var t=o.EPSILON15,n=0,i=1,a=0;3>a;++a){var s=Math.abs(e[f.getElementIndex(w[a],c[a])]);s>n&&(i=a,n=s)}var u=1,l=0,h=c[i],d=w[i];if(Math.abs(e[f.getElementIndex(d,h)])>t){var m,p=e[f.getElementIndex(d,d)],y=e[f.getElementIndex(h,h)],E=e[f.getElementIndex(d,h)],g=(p-y)/2/E;m=0>g?-1/(-g+Math.sqrt(1+g*g)):1/(g+Math.sqrt(1+g*g)),u=1/Math.sqrt(1+m*m),l=m*u}return r=f.clone(f.IDENTITY,r),r[f.getElementIndex(h,h)]=r[f.getElementIndex(d,d)]=u,r[f.getElementIndex(d,h)]=l,r[f.getElementIndex(h,d)]=-l,r}var f=function(e,t,n,i,o,a,s,u,f){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(s,0),this[3]=r(t,0),this[4]=r(o,0),this[5]=r(u,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(f,0)};f.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new f(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},f.fromArray=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new f),o[0]=e[i],o[1]=e[i+1],o[2]=e[i+2],o[3]=e[i+3],o[4]=e[i+4],o[5]=e[i+5],o[6]=e[i+6],o[7]=e[i+7],o[8]=e[i+8],o[9]=e[i+9],o},f.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},f.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,o=e.x*e.y,a=e.x*e.z,s=e.x*e.w,u=e.y*e.y,l=e.y*e.z,h=e.y*e.w,c=e.z*e.z,w=e.z*e.w,d=e.w*e.w,m=i-u-c+d,p=2*(o-w),y=2*(a+h),E=2*(o+w),g=-i+u-c+d,C=2*(l-s),S=2*(a-h),q=2*(l+s),v=-i-u+c+d;return t(r)?(r[0]=m,r[1]=E,r[2]=S,r[3]=p,r[4]=g,r[5]=q,r[6]=y,r[7]=C,r[8]=v,r):new f(m,p,y,E,g,C,S,q,v)},f.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new f(e.x,0,0,0,e.y,0,0,0,e.z)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new f(e,0,0,0,e,0,0,0,e)},f.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=o,r[6]=0,r[7]=-o,r[8]=i,r):new f(1,0,0,0,i,-o,0,o,i)},f.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=i,r):new f(i,0,o,0,1,0,-o,0,i)},f.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=o,r[2]=0,r[3]=-o,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new f(i,-o,0,o,i,0,0,0,1)},f.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},f.getColumn=function(r,i,o){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var a=3*i,s=r[a],u=r[a+1],f=r[a+2];return t(o)?(o.x=s,o.y=u,o.z=f,o):new e(s,u,f)},f.setColumn=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");o=f.clone(e,o);var a=3*r;return o[a]=i.x,o[a+1]=i.y,o[a+2]=i.z,o},f.getRow=function(r,i,o){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var a=r[i],s=r[i+3],u=r[i+6];return t(o)?(o.x=a,o.y=s,o.z=u,o):new e(a,s,u)},f.setRow=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");return o=f.clone(e,o),o[r]=i.x,o[r+3]=i.y,o[r+6]=i.z,o};var l=new e;f.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");return t(i)||(i=new e),i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],l)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],l)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],l)),i};var h=new e;f.getMaximumScale=function(r){return f.getScale(r,h),e.getMaximumComponent(h)},f.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],s=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],l=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],h=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],c=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],w=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],d=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return t(i)?(i[0]=o,i[1]=a,i[2]=s,i[3]=u,i[4]=l,i[5]=h,i[6]=c,i[7]=w,i[8]=d,i):new f(o,u,c,a,l,w,s,h,d)},f.multiplyByVector=function(r,i,o){if(!t(r))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");var a=i.x,s=i.y,u=i.z,f=r[0]*a+r[3]*s+r[6]*u,l=r[1]*a+r[4]*s+r[7]*u,h=r[2]*a+r[5]*s+r[8]*u;return t(o)?(o.x=f,o.y=l,o.z=h,o):new e(f,l,h)},f.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");return t(i)?(i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i):new f(e[0]*r,e[3]*r,e[6]*r,e[1]*r,e[4]*r,e[7]*r,e[2]*r,e[5]*r,e[8]*r)},f.negate=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r):new f(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},f.transpose=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],o=e[3],a=e[6],s=e[1],u=e[4],l=e[7],h=e[2],c=e[5],w=e[8];return t(r)?(r[0]=i,r[1]=o,r[2]=a,r[3]=s,r[4]=u,r[5]=l,r[6]=h,r[7]=c,r[8]=w,r):new f(i,s,h,o,u,c,a,l,w)};var c=[1,0,0],w=[2,2,1],d=new f,m=new f;return f.getEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=o.EPSILON20,l=10,h=0,c=0;
t(r)||(r={});for(var w=r.unitary=f.clone(f.IDENTITY,r.unitary),p=r.diagonal=f.clone(e,r.diagonal),y=i*a(p);l>c&&s(p)>y;)u(p,d),f.transpose(d,m),f.multiply(p,d,p),f.multiply(m,p,p),f.multiply(w,d,w),++h>2&&(++c,h=0);return r},f.abs=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r):new f(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},f.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],o=e[6],a=e[1],s=e[4],u=e[7],f=e[2],l=e[5],h=e[8];return r*(s*h-l*u)+a*(l*o-i*h)+f*(i*u-s*o)},f.inverse=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],a=e[1],s=e[2],u=e[3],l=e[4],h=e[5],c=e[6],w=e[7],d=e[8],m=f.determinant(e);if(Math.abs(m)<=o.EPSILON15)throw new n("matrix is not invertible");t(r)||(r=new f),r[0]=l*d-w*h,r[1]=w*s-a*d,r[2]=a*h-l*s,r[3]=c*h-u*d,r[4]=i*d-c*s,r[5]=u*s-i*h,r[6]=u*w-c*l,r[7]=c*a-i*w,r[8]=i*l-u*a;var p=1/m;return f.multiplyByScalar(r,p,r)},f.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},f.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},f.IDENTITY=i(new f(1,0,0,0,1,0,0,0,1)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN1ROW0=3,f.COLUMN1ROW1=4,f.COLUMN1ROW2=5,f.COLUMN2ROW0=6,f.COLUMN2ROW1=7,f.COLUMN2ROW2=8,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},f}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,o,a,s,u){"use strict";var f=function(e,r,n,i,o,a,s,u,f,l,h,c,w,d,m,p){this[0]=t(e,0),this[1]=t(o,0),this[2]=t(f,0),this[3]=t(w,0),this[4]=t(r,0),this[5]=t(a,0),this[6]=t(l,0),this[7]=t(d,0),this[8]=t(n,0),this[9]=t(s,0),this[10]=t(h,0),this[11]=t(m,0),this[12]=t(i,0),this[13]=t(u,0),this[14]=t(c,0),this[15]=t(p,0)};f.packedLength=16,f.pack=function(e,r,o){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");o=t(o,0),r[o++]=e[0],r[o++]=e[1],r[o++]=e[2],r[o++]=e[3],r[o++]=e[4],r[o++]=e[5],r[o++]=e[6],r[o++]=e[7],r[o++]=e[8],r[o++]=e[9],r[o++]=e[10],r[o++]=e[11],r[o++]=e[12],r[o++]=e[13],r[o++]=e[14],r[o]=e[15]},f.unpack=function(e,r,o){if(!n(e))throw new i("array is required");return r=t(r,0),n(o)||(o=new f),o[0]=e[r++],o[1]=e[r++],o[2]=e[r++],o[3]=e[r++],o[4]=e[r++],o[5]=e[r++],o[6]=e[r++],o[7]=e[r++],o[8]=e[r++],o[9]=e[r++],o[10]=e[r++],o[11]=e[r++],o[12]=e[r++],o[13]=e[r++],o[14]=e[r++],o[15]=e[r],o},f.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(e,r,t){if(!n(e))throw new i("rotation is required.");if(!n(r))throw new i("translation is required.");return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=0,t[4]=e[3],t[5]=e[4],t[6]=e[5],t[7]=0,t[8]=e[6],t[9]=e[7],t[10]=e[8],t[11]=0,t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=1,t):new f(e[0],e[3],e[6],r.x,e[1],e[4],e[7],r.y,e[2],e[5],e[8],r.z,0,0,0,1)},new s,f.fromTranslationQuaternionRotationScale=function(e,r,t,o){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(o)||(o=new f);var a=t.x,s=t.y,u=t.z,l=r.x*r.x,h=r.x*r.y,c=r.x*r.z,w=r.x*r.w,d=r.y*r.y,m=r.y*r.z,p=r.y*r.w,y=r.z*r.z,E=r.z*r.w,g=r.w*r.w,C=l-d-y+g,S=2*(h-E),q=2*(c+p),v=2*(h+E),b=-l+d-y+g,M=2*(m-w),x=2*(c-p),A=2*(m+w),R=-l-d+y+g;return o[0]=C*a,o[1]=v*a,o[2]=x*a,o[3]=0,o[4]=S*s,o[5]=b*s,o[6]=A*s,o[7]=0,o[8]=q*u,o[9]=M*u,o[10]=R*u,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},f.fromTranslation=function(e,r){return f.fromRotationTranslation(s.IDENTITY,e,r)},f.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,h=new e,c=new e;f.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var o=r.eye,a=r.target,s=r.up;if(!n(o))throw new i("camera.eye is required.");if(!n(a))throw new i("camera.target is required.");if(!n(s))throw new i("camera.up is required.");e.normalize(e.subtract(a,o,l),l),e.normalize(e.cross(l,s,h),h),e.normalize(e.cross(h,l,c),c);var u=h.x,w=h.y,d=h.z,m=l.x,p=l.y,y=l.z,E=c.x,g=c.y,C=c.z,S=o.x,q=o.y,v=o.z,b=u*-S+w*-q+d*-v,M=E*-S+g*-q+C*-v,x=m*S+p*q+y*v;return n(t)?(t[0]=u,t[1]=E,t[2]=-m,t[3]=0,t[4]=w,t[5]=g,t[6]=-p,t[7]=0,t[8]=d,t[9]=C,t[10]=-y,t[11]=0,t[12]=b,t[13]=M,t[14]=x,t[15]=1,t):new f(u,w,d,b,E,g,C,M,-m,-p,-y,x,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,r,t,o,a){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=o)throw new i("far must be greater than zero.");var s=Math.tan(.5*e),u=1/s,l=u/r,h=(o+t)/(t-o),c=2*o*t/(t-o);return n(a)?(a[0]=l,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=h,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a):new f(l,0,0,0,0,u,0,0,0,0,h,c,0,0,-1,0)},f.computeOrthographicOffCenter=function(e,r,t,o,a,s,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(s))throw new i("far is required.");var l=1/(r-e),h=1/(o-t),c=1/(s-a),w=-(r+e)*l,d=-(o+t)*h,m=-(s+a)*c;return l*=2,h*=2,c*=-2,n(u)?(u[0]=l,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=h,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=c,u[11]=0,u[12]=w,u[13]=d,u[14]=m,u[15]=1,u):new f(l,0,0,w,0,h,0,d,0,0,c,m,0,0,0,1)},f.computePerspectiveOffCenter=function(e,r,t,o,a,s,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(s))throw new i("far is required.");var l=2*a/(r-e),h=2*a/(o-t),c=(r+e)/(r-e),w=(o+t)/(o-t),d=-(s+a)/(s-a),m=-1,p=-2*s*a/(s-a);return n(u)?(u[0]=l,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=h,u[6]=0,u[7]=0,u[8]=c,u[9]=w,u[10]=d,u[11]=m,u[12]=0,u[13]=0,u[14]=p,u[15]=0,u):new f(l,0,c,0,0,h,w,0,0,0,d,p,0,0,m,0)},f.computeInfinitePerspectiveOffCenter=function(e,r,t,o,a,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");var u=2*a/(r-e),l=2*a/(o-t),h=(r+e)/(r-e),c=(o+t)/(o-t),w=-1,d=-1,m=-2*a;return n(s)?(s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=l,s[6]=0,s[7]=0,s[8]=h,s[9]=c,s[10]=w,s[11]=d,s[12]=0,s[13]=0,s[14]=m,s[15]=0,s):new f(u,0,h,0,0,l,c,0,0,0,w,m,0,0,d,0)},f.computeViewportTransformation=function(e,r,i,o){e=t(e,t.EMPTY_OBJECT);var a=t(e.x,0),s=t(e.y,0),u=t(e.width,0),l=t(e.height,0);r=t(r,0),i=t(i,1);var h=.5*u,c=.5*l,w=.5*(i-r),d=h,m=c,p=w,y=a+h,E=s+c,g=r+w,C=1;return n(o)?(o[0]=d,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=m,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=p,o[11]=0,o[12]=y,o[13]=E,o[14]=g,o[15]=C,o):new f(d,0,0,y,0,m,0,E,0,0,p,g,0,0,0,C)},f.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},f.getColumn=function(e,t,o){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var a=4*t,s=e[a],u=e[a+1],f=e[a+2],l=e[a+3];return n(o)?(o.x=s,o.y=u,o.z=f,o.w=l,o):new r(s,u,f,l)},f.setColumn=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");o=f.clone(e,o);var a=4*r;return o[a]=t.x,o[a+1]=t.y,o[a+2]=t.z,o[a+3]=t.w,o},f.getRow=function(e,t,o){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var a=e[t],s=e[t+4],u=e[t+8],f=e[t+12];return n(o)?(o.x=a,o.y=s,o.z=u,o.w=f,o):new r(a,s,u,f)},f.setRow=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");return o=f.clone(e,o),o[r]=t.x,o[r+4]=t.y,o[r+8]=t.z,o[r+12]=t.w,o};var w=new e;f.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");return n(t)||(t=new e),t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],w)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],w)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],w)),t};var d=new e;f.getMaximumScale=function(r){return f.getScale(r,d),e.getMaximumComponent(d)},f.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var o=e[0],a=e[1],s=e[2],u=e[3],l=e[4],h=e[5],c=e[6],w=e[7],d=e[8],m=e[9],p=e[10],y=e[11],E=e[12],g=e[13],C=e[14],S=e[15],q=r[0],v=r[1],b=r[2],M=r[3],x=r[4],A=r[5],R=r[6],I=r[7],T=r[8],O=r[9],N=r[10],F=r[11],z=r[12],D=r[13],L=r[14],_=r[15],B=o*q+l*v+d*b+E*M,P=a*q+h*v+m*b+g*M,U=s*q+c*v+p*b+C*M,G=u*q+w*v+y*b+S*M,Y=o*x+l*A+d*R+E*I,W=a*x+h*A+m*R+g*I,V=s*x+c*A+p*R+C*I,H=u*x+w*A+y*R+S*I,K=o*T+l*O+d*N+E*F,k=a*T+h*O+m*N+g*F,j=s*T+c*O+p*N+C*F,Z=u*T+w*O+y*N+S*F,X=o*z+l*D+d*L+E*_,Q=a*z+h*D+m*L+g*_,J=s*z+c*D+p*L+C*_,$=u*z+w*D+y*L+S*_;return n(t)?(t[0]=B,t[1]=P,t[2]=U,t[3]=G,t[4]=Y,t[5]=W,t[6]=V,t[7]=H,t[8]=K,t[9]=k,t[10]=j,t[11]=Z,t[12]=X,t[13]=Q,t[14]=J,t[15]=$,t):new f(B,Y,K,X,P,W,k,Q,U,V,j,J,G,H,Z,$)},f.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var o=e[0],a=e[1],s=e[2],u=e[4],l=e[5],h=e[6],c=e[8],w=e[9],d=e[10],m=e[12],p=e[13],y=e[14],E=r[0],g=r[1],C=r[2],S=r[4],q=r[5],v=r[6],b=r[8],M=r[9],x=r[10],A=r[12],R=r[13],I=r[14],T=o*E+u*g+c*C,O=a*E+l*g+w*C,N=s*E+h*g+d*C,F=o*S+u*q+c*v,z=a*S+l*q+w*v,D=s*S+h*q+d*v,L=o*b+u*M+c*x,_=a*b+l*M+w*x,B=s*b+h*M+d*x,P=o*A+u*R+c*I+m,U=a*A+l*R+w*I+p,G=s*A+h*R+d*I+y;return n(t)?(t[0]=T,t[1]=O,t[2]=N,t[3]=0,t[4]=F,t[5]=z,t[6]=D,t[7]=0,t[8]=L,t[9]=_,t[10]=B,t[11]=0,t[12]=P,t[13]=U,t[14]=G,t[15]=1,t):new f(T,F,L,P,O,z,_,U,N,D,B,G,0,0,0,1)},f.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");var o=r.x,a=r.y,s=r.z,u=o*e[0]+a*e[4]+s*e[8]+e[12],l=o*e[1]+a*e[5]+s*e[9]+e[13],h=o*e[2]+a*e[6]+s*e[10]+e[14];return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=u,t[13]=l,t[14]=h,t[15]=e[15],t):new f(e[0],e[4],e[8],u,e[1],e[5],e[9],l,e[2],e[6],e[10],h,e[3],e[7],e[11],e[15])};var m=new e;return f.multiplyByUniformScale=function(e,r,t){if("number"!=typeof r)throw new i("scale is required");return m.x=r,m.y=r,m.z=r,f.multiplyByScale(e,m,t)},f.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");var o=r.x,a=r.y,s=r.z;return 1===o&&1===a&&1===s?f.clone(e,t):n(t)?(t[0]=o*e[0],t[1]=o*e[1],t[2]=o*e[2],t[3]=0,t[4]=a*e[4],t[5]=a*e[5],t[6]=a*e[6],t[7]=0,t[8]=s*e[8],t[9]=s*e[9],t[10]=s*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t):new f(o*e[0],a*e[4],s*e[8],e[12],o*e[1],a*e[5],s*e[9],e[13],o*e[2],a*e[6],s*e[10],e[14],0,0,0,1)},f.multiplyByVector=function(e,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var a=t.x,s=t.y,u=t.z,f=t.w,l=e[0]*a+e[4]*s+e[8]*u+e[12]*f,h=e[1]*a+e[5]*s+e[9]*u+e[13]*f,c=e[2]*a+e[6]*s+e[10]*u+e[14]*f,w=e[3]*a+e[7]*s+e[11]*u+e[15]*f;return n(o)?(o.x=l,o.y=h,o.z=c,o.w=w,o):new r(l,h,c,w)},f.multiplyByPointAsVector=function(r,t,o){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var a=t.x,s=t.y,u=t.z,f=r[0]*a+r[4]*s+r[8]*u,l=r[1]*a+r[5]*s+r[9]*u,h=r[2]*a+r[6]*s+r[10]*u;return n(o)?(o.x=f,o.y=l,o.z=h,o):new e(f,l,h)},f.multiplyByPoint=function(r,t,o){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var a=t.x,s=t.y,u=t.z,f=r[0]*a+r[4]*s+r[8]*u+r[12],l=r[1]*a+r[5]*s+r[9]*u+r[13],h=r[2]*a+r[6]*s+r[10]*u+r[14];return n(o)?(o.x=f,o.y=l,o.z=h,o):new e(f,l,h)},f.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");return n(t)?(t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t):new f(e[0]*r,e[4]*r,e[8]*r,e[12]*r,e[1]*r,e[5]*r,e[9]*r,e[13]*r,e[2]*r,e[6]*r,e[10]*r,e[14]*r,e[3]*r,e[7]*r,e[11]*r,e[15]*r)},f.negate=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r):new f(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},f.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))return new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var t=e[1],o=e[2],a=e[3],s=e[6],u=e[7],l=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=o,r[9]=s,r[10]=e[10],r[11]=e[14],r[12]=a,r[13]=u,r[14]=l,r[15]=e[15],r},f.abs=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r):new f(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},f.equals=function(e,r){return e===r||n(e)&&n(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[11]===r[11]&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[15]===r[15]},f.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},f.getTranslation=function(r,t){if(!n(r))throw new i("matrix is required");return n(t)?(t.x=r[12],t.y=r[13],t.z=r[14],t):new e(r[12],r[13],r[14])},f.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r):new s(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},f.inverse=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],o=e[4],s=e[8],l=e[12],h=e[1],c=e[5],w=e[9],d=e[13],m=e[2],p=e[6],y=e[10],E=e[14],g=e[3],C=e[7],S=e[11],q=e[15],v=y*q,b=E*S,M=p*q,x=E*C,A=p*S,R=y*C,I=m*q,T=E*g,O=m*S,N=y*g,F=m*C,z=p*g,D=v*c+x*w+A*d-(b*c+M*w+R*d),L=b*h+I*w+N*d-(v*h+T*w+O*d),_=M*h+T*c+F*d-(x*h+I*c+z*d),B=R*h+O*c+z*w-(A*h+N*c+F*w),P=b*o+M*s+R*l-(v*o+x*s+A*l),U=v*t+T*s+O*l-(b*t+I*s+N*l),G=x*t+I*o+z*l-(M*t+T*o+F*l),Y=A*t+N*o+F*s-(R*t+O*o+z*s);v=s*d,b=l*w,M=o*d,x=l*c,A=o*w,R=s*c,I=t*d,T=l*h,O=t*w,N=s*h,F=t*c,z=o*h;var W=v*C+x*S+A*q-(b*C+M*S+R*q),V=b*g+I*S+N*q-(v*g+T*S+O*q),H=M*g+T*C+F*q-(x*g+I*C+z*q),K=R*g+O*C+z*S-(A*g+N*C+F*S),k=M*y+R*E+b*p-(A*E+v*p+x*y),j=O*E+v*m+T*y-(I*y+N*E+b*m),Z=I*p+z*E+x*m-(F*E+M*m+T*p),X=F*y+A*m+N*p-(O*p+z*y+R*m),Q=t*D+o*L+s*_+l*B;if(Math.abs(Q)<a.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return Q=1/Q,n(r)?(r[0]=D*Q,r[1]=L*Q,r[2]=_*Q,r[3]=B*Q,r[4]=P*Q,r[5]=U*Q,r[6]=G*Q,r[7]=Y*Q,r[8]=W*Q,r[9]=V*Q,r[10]=H*Q,r[11]=K*Q,r[12]=k*Q,r[13]=j*Q,r[14]=Z*Q,r[15]=X*Q,r):new f(D*Q,P*Q,W*Q,k*Q,L*Q,U*Q,V*Q,j*Q,_*Q,G*Q,H*Q,Z*Q,B*Q,Y*Q,K*Q,X*Q)},f.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],o=e[1],a=e[2],s=e[4],u=e[5],l=e[6],h=e[8],c=e[9],w=e[10],d=e[12],m=e[13],p=e[14],y=-t*d-o*m-a*p,E=-s*d-u*m-l*p,g=-h*d-c*m-w*p;return n(r)?(r[0]=t,r[1]=s,r[2]=h,r[3]=0,r[4]=o,r[5]=u,r[6]=c,r[7]=0,r[8]=a,r[9]=l,r[10]=w,r[11]=0,r[12]=y,r[13]=E,r[14]=g,r[15]=1,r):new f(t,o,a,y,s,u,l,E,h,c,w,g,0,0,0,1)},f.IDENTITY=o(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,o,a){"use strict";var s=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};s.fromDegrees=function(e,n,i,o,u){return e=a.toRadians(r(e,0)),n=a.toRadians(r(n,0)),i=a.toRadians(r(i,0)),o=a.toRadians(r(o,0)),t(u)?(u.west=e,u.south=n,u.east=i,u.north=o,u):new s(e,n,i,o)},s.fromCartographicArray=function(e,r){if(!t(e))throw new n("cartographics is required.");for(var i=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,u=-Number.MAX_VALUE,f=0,l=e.length;l>f;f++){var h=e[f];i=Math.min(i,h.longitude),o=Math.max(o,h.longitude),a=Math.min(a,h.latitude),u=Math.max(u,h.latitude)}return t(r)?(r.west=i,r.south=a,r.east=o,r.north=u,r):new s(i,a,o,u)},s.packedLength=4,s.pack=function(e,i,o){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");o=r(o,0),i[o++]=e.west,i[o++]=e.south,i[o++]=e.east,i[o]=e.north},s.unpack=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new s),o.west=e[i++],o.south=e[i++],o.east=e[i++],o.north=e[i],o},s.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},s.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new n("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){if(!t(e))throw new n("rectangle is required");var r=e.north;if("number"!=typeof r)throw new n("north is required to be a number.");if(r<-a.PI_OVER_TWO||r>a.PI_OVER_TWO)throw new n("north must be in the interval [-Pi/2, Pi/2].");var i=e.south;if("number"!=typeof i)throw new n("south is required to be a number.");if(i<-a.PI_OVER_TWO||i>a.PI_OVER_TWO)throw new n("south must be in the interval [-Pi/2, Pi/2].");var o=e.west;if("number"!=typeof o)throw new n("west is required to be a number.");if(o<-Math.PI||o>Math.PI)throw new n("west must be in the interval [-Pi, Pi].");var s=e.east;if("number"!=typeof s)throw new n("east is required to be a number.");if(s<-Math.PI||s>Math.PI)throw new n("east must be in the interval [-Pi, Pi].")},s.getSouthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.getNorthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.getNortheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.getSoutheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.getCenter=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=.5*(r.west+r.east),i.latitude=.5*(r.south+r.north),i.height=0,i):new e(.5*(r.west+r.east),.5*(r.south+r.north))},s.intersectWith=function(e,r,i){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("otherRectangle is required.");var o=Math.max(e.west,r.west),a=Math.max(e.south,r.south),u=Math.min(e.east,r.east),f=Math.min(e.north,r.north);return t(i)?(i.west=o,i.south=a,i.east=u,i.north=f,i):new s(o,a,u,f)},s.contains=function(e,r){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("cartographic is required.");return r.longitude>=e.west&&r.longitude<=e.east&&r.latitude>=e.south&&r.latitude<=e.north},s.isEmpty=function(e){if(!t(e))throw new n("rectangle is required");return e.west>=e.east||e.south>=e.north};var u=new e;return s.subsample=function(e,o,s,f){if(!t(e))throw new n("rectangle is required");o=r(o,i.WGS84),s=r(s,0),t(f)||(f=[]);var l=0,h=e.north,c=e.south,w=e.east,d=e.west,m=u;m.height=s,m.longitude=d,m.latitude=h,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.longitude=w,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.latitude=c,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.longitude=d,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.latitude=0>h?h:c>0?c:0;for(var p=1;8>p;++p){var y=-Math.PI+p*a.PI_OVER_TWO;y>d&&w>y&&(m.longitude=y,f[l]=o.cartographicToCartesian(m,f[l]),l++)}return 0===m.latitude&&(m.longitude=d,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.longitude=w,f[l]=o.cartographicToCartesian(m,f[l]),l++),f.length=l,f},s.MAX_VALUE=o(new s(-Math.PI,-a.PI_OVER_TWO,Math.PI,a.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,r,t,n,i,o,a,s,u,f,l){"use strict";var h=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},c=new e,w=new e,d=new e,m=new e,p=new e,y=new e,E=new e,g=new e,C=new e,S=new e,q=new e,v=new e;h.fromPoints=function(r,t){if(n(t)||(t=new h),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],E),o=e.clone(i,c),a=e.clone(i,w),s=e.clone(i,d),u=e.clone(i,m),f=e.clone(i,p),l=e.clone(i,y),b=r.length,M=1;b>M;M++){e.clone(r[M],i);var x=i.x,A=i.y,R=i.z;x<o.x&&e.clone(i,o),x>u.x&&e.clone(i,u),A<a.y&&e.clone(i,a),A>f.y&&e.clone(i,f),R<s.z&&e.clone(i,s),R>l.z&&e.clone(i,l)}var I=e.magnitudeSquared(e.subtract(u,o,g)),T=e.magnitudeSquared(e.subtract(f,a,g)),O=e.magnitudeSquared(e.subtract(l,s,g)),N=o,F=u,z=I;T>z&&(z=T,N=a,F=f),O>z&&(z=O,N=s,F=l);var D=C;D.x=.5*(N.x+F.x),D.y=.5*(N.y+F.y),D.z=.5*(N.z+F.z);var L=e.magnitudeSquared(e.subtract(F,D,g)),_=Math.sqrt(L),B=S;B.x=o.x,B.y=a.y,B.z=s.z;var P=q;P.x=u.x,P.y=f.y,P.z=l.z;var U=e.multiplyByScalar(e.add(B,P,g),.5,v),G=0;for(M=0;b>M;M++){e.clone(r[M],i);var Y=e.magnitude(e.subtract(i,U,g));Y>G&&(G=Y);var W=e.magnitudeSquared(e.subtract(i,D,g));if(W>L){var V=Math.sqrt(W);_=.5*(_+V),L=_*_;var H=V-_;D.x=(_*D.x+H*i.x)/V,D.y=(_*D.y+H*i.y)/V,D.z=(_*D.z+H*i.z)/V}}return G>_?(e.clone(D,t.center),t.radius=_):(e.clone(U,t.center),t.radius=G),t};var b=new a,M=new e,x=new e,A=new r,R=new r;h.fromRectangle2D=function(e,r,t){return h.fromRectangleWithHeights2D(e,r,0,0,t)},h.fromRectangleWithHeights2D=function(r,i,o,a,s){if(n(s)||(s=new h),!n(r))return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;i=t(i,b),l.getSouthwest(r,A),A.height=o,l.getNortheast(r,R),R.height=a;var u=i.project(A,M),f=i.project(R,x),c=f.x-u.x,w=f.y-u.y,d=f.z-u.z;s.radius=.5*Math.sqrt(c*c+w*w+d*d);var m=s.center;return m.x=u.x+.5*c,m.y=u.y+.5*w,m.z=u.z+.5*d,s};var I=[];h.fromRectangle3D=function(e,r,i,a){r=t(r,o.WGS84),i=t(i,0);var s;return n(e)&&(s=l.subsample(e,r,i,I)),h.fromPoints(s,a)},h.fromVertices=function(r,o,a,s){if(n(s)||(s=new h),!n(r)||0===r.length)return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;if(o=t(o,e.ZERO),a=t(a,3),3>a)throw new i("stride must be 3 or greater.");var u=E;u.x=r[0]+o.x,u.y=r[1]+o.y,u.z=r[2]+o.z;for(var f=e.clone(u,c),l=e.clone(u,w),b=e.clone(u,d),M=e.clone(u,m),x=e.clone(u,p),A=e.clone(u,y),R=r.length,I=0;R>I;I+=a){var T=r[I]+o.x,O=r[I+1]+o.y,N=r[I+2]+o.z;u.x=T,u.y=O,u.z=N,T<f.x&&e.clone(u,f),T>M.x&&e.clone(u,M),O<l.y&&e.clone(u,l),O>x.y&&e.clone(u,x),N<b.z&&e.clone(u,b),N>A.z&&e.clone(u,A)}var F=e.magnitudeSquared(e.subtract(M,f,g)),z=e.magnitudeSquared(e.subtract(x,l,g)),D=e.magnitudeSquared(e.subtract(A,b,g)),L=f,_=M,B=F;z>B&&(B=z,L=l,_=x),D>B&&(B=D,L=b,_=A);var P=C;P.x=.5*(L.x+_.x),P.y=.5*(L.y+_.y),P.z=.5*(L.z+_.z);var U=e.magnitudeSquared(e.subtract(_,P,g)),G=Math.sqrt(U),Y=S;Y.x=f.x,Y.y=l.y,Y.z=b.z;var W=q;W.x=M.x,W.y=x.y,W.z=A.z;var V=e.multiplyByScalar(e.add(Y,W,g),.5,v),H=0;for(I=0;R>I;I+=a){u.x=r[I]+o.x,u.y=r[I+1]+o.y,u.z=r[I+2]+o.z;var K=e.magnitude(e.subtract(u,V,g));K>H&&(H=K);var k=e.magnitudeSquared(e.subtract(u,P,g));if(k>U){var j=Math.sqrt(k);G=.5*(G+j),U=G*G;var Z=j-G;P.x=(G*P.x+Z*u.x)/j,P.y=(G*P.y+Z*u.y)/j,P.z=(G*P.z+Z*u.z)/j}}return H>G?(e.clone(P,s.center),s.radius=G):(e.clone(V,s.center),s.radius=H),s},h.fromCornerPoints=function(r,t,o){if(!n(r)||!n(t))throw new i("corner and oppositeCorner are required.");n(o)||(o=new h);var a=o.center;return e.add(r,t,a),e.multiplyByScalar(a,.5,a),o.radius=e.distance(a,t),o},h.fromEllipsoid=function(r,t){if(!n(r))throw new i("ellipsoid is required.");return n(t)||(t=new h),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t},h.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new h(r.center,r.radius):void 0},h.packedLength=4,h.pack=function(e,r,o){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");o=t(o,0);var a=e.center;r[o++]=a.x,r[o++]=a.y,r[o++]=a.z,r[o]=e.radius},h.unpack=function(e,r,o){if(!n(e))throw new i("array is required");r=t(r,0),n(o)||(o=new h);var a=o.center;return a.x=e[r++],a.y=e[r++],a.z=e[r++],o.radius=e[r],o};var T=new e,O=new e;h.union=function(r,t,o){if(!n(r))throw new i("left is required.");if(!n(t))throw new i("right is required.");n(o)||(o=new h);var a=r.center,s=t.center;e.add(a,s,O);var u=e.multiplyByScalar(O,.5,O),f=e.magnitude(e.subtract(a,u,T))+r.radius,l=e.magnitude(e.subtract(s,u,T))+t.radius;return o.radius=Math.max(f,l),e.clone(u,o.center),o};var N=new e;h.expand=function(r,t,o){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("point is required.");o=h.clone(r,o);var a=e.magnitude(e.subtract(t,o.center,N));return a>o.radius&&(o.radius=a),o},h.intersect=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("plane is required.");var o=r.center,a=r.radius,u=e.dot(t,o)+t.w;return-a>u?s.OUTSIDE:a>u?s.INTERSECTING:s.INSIDE},h.transform=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new h),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=f.getMaximumScale(r)*e.radius,t};var F=new e;h.distanceSquaredTo=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("cartesian is required.");var o=e.subtract(r.center,t,F);return e.magnitudeSquared(o)-r.radius*r.radius},h.transformWithoutScale=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new h),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var z=new e;h.getPlaneDistances=function(r,t,o,a){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("position is required.");if(!n(o))throw new i("direction is required.");n(a)||(a=new u);var s=e.subtract(r.center,t,z),f=e.multiplyByScalar(o,e.dot(o,s),z),l=e.magnitude(f);return a.start=l-r.radius,a.stop=l+r.radius,a};for(var D=new e,L=new e,_=new e,B=new e,P=new e,U=new r,G=new Array(8),Y=0;8>Y;++Y)G[Y]=new e;var W=new a;return h.projectTo2D=function(r,o,a){if(!n(r))throw new i("sphere is required.");o=t(o,W);var s=o.ellipsoid,u=r.center,f=r.radius,l=s.geodeticSurfaceNormal(u,D),c=e.cross(e.UNIT_Z,l,L);e.normalize(c,c);var w=e.cross(l,c,_);e.normalize(w,w),e.multiplyByScalar(l,f,l),e.multiplyByScalar(w,f,w),e.multiplyByScalar(c,f,c);var d=e.negate(w,P),m=e.negate(c,B),p=G,y=p[0];e.add(l,w,y),e.add(y,c,y),y=p[1],e.add(l,w,y),e.add(y,m,y),y=p[2],e.add(l,d,y),e.add(y,m,y),y=p[3],e.add(l,d,y),e.add(y,c,y),e.negate(l,l),y=p[4],e.add(l,w,y),e.add(y,c,y),y=p[5],e.add(l,w,y),e.add(y,m,y),y=p[6],e.add(l,d,y),e.add(y,m,y),y=p[7],e.add(l,d,y),e.add(y,c,y);for(var E=p.length,g=0;E>g;++g){var C=p[g];e.add(u,C,C);var S=s.cartesianToCartographic(C,U);o.project(S,C)}a=h.fromPoints(p,a),u=a.center;var q=u.x,v=u.y,b=u.z;return u.x=b,u.y=q,u.z=v,a},h.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius
},h.prototype.intersect=function(e){return h.intersect(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.clone=function(e){return h.clone(this,e)},h}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,o=["webkit","moz","o","ms","khtml"],a=0,s=o.length;s>a;++a){var u=o[a];i=u+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=u+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=u+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=u+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=u+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=u+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=u+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=u+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=u+"fullscreenchange",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=u+"fullscreenerror",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(c)){var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null===e?c=!1:(c=!0,w=n(e[1]))}return c}function o(){return i()&&w}function a(){if(!r(d))if(i()||!/ Safari\/[\.0-9]+/.test(navigator.userAgent))d=!1;else{var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null===e?d=!1:(d=!0,m=n(e[1]))}return d}function s(){return a()&&m}function u(){if(!r(p)){var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null===e?p=!1:(p=!0,y=n(e[1]),y.isNightly=!!e[2])}return p}function f(){return u()&&y}function l(){if(!r(E)){var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(E=!0,g=n(e[1]))):"Netscape"===navigator.appName?(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(E=!0,g=n(e[1]))):E=!1}return E}function h(){return l()&&g}var c,w,d,m,p,y,E,g,C={isChrome:i,chromeVersion:o,isSafari:a,safariVersion:s,isWebkit:u,webkitVersion:f,isInternetExplorer:l,internetExplorerVersion:h,hardwareConcurrency:e(navigator.hardwareConcurrency,3)};return C.supportsFullscreen=function(){return t.supportsFullscreen()},C.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},C}),define("Core/Color",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math"],function(e,r,t,n,i,o){"use strict";function a(e,r,t){return 0>t&&(t+=1),t>1&&(t-=1),1>6*t?e+6*(r-e)*t:1>2*t?r:2>3*t?e+6*(r-e)*(2/3-t):e}var s=function(r,t,n,i){this.red=e(r,1),this.green=e(t,1),this.blue=e(n,1),this.alpha=e(i,1)};s.fromCartesian4=function(e,n){if(!r(e))throw new t("cartesian is required");return r(n)?(n.red=e.x,n.green=e.y,n.blue=e.z,n.alpha=e.w,n):new s(e.x,e.y,e.z,e.w)},s.fromBytes=function(r,t,n,i){return r=s.byteToFloat(e(r,255)),t=s.byteToFloat(e(t,255)),n=s.byteToFloat(e(n,255)),i=s.byteToFloat(e(i,255)),new s(r,t,n,i)};var u,f,l;n.supportsTypedArrays()&&(u=new ArrayBuffer(4),f=new Uint32Array(u),l=new Uint8Array(u)),s.fromRgba=function(e){return f[0]=e,s.fromBytes(l[0],l[1],l[2],l[3])},s.fromHsl=function(r,t,n,i){r=e(r,0)%1,t=e(t,0),n=e(n,0),i=e(i,1);var o=n,u=n,f=n;if(0!==t){var l;l=.5>n?n*(1+t):n+t-n*t;var h=2*n-l;o=a(h,l,r+1/3),u=a(h,l,r),f=a(h,l,r-1/3)}return new s(o,u,f,i)},s.fromRandom=function(n,i){n=e(n,e.EMPTY_OBJECT);var a=n.red;if(!r(a)){var u=e(n.minimumRed,0),f=e(n.maximumRed,1);if(u>f)throw new t("minimumRed must be less than or equal to maximumRed");a=u+o.nextRandomNumber()*(f-u)}var l=n.green;if(!r(l)){var h=e(n.minimumGreen,0),c=e(n.maximumGreen,1);if(h>c)throw new t("minimumGreen must be less than or equal to maximumGreen");l=h+o.nextRandomNumber()*(c-h)}var w=n.blue;if(!r(w)){var d=e(n.minimumBlue,0),m=e(n.maximumBlue,1);if(d>m)throw new t("minimumBlue must be less than or equal to maximumBlue");w=d+o.nextRandomNumber()*(m-d)}var p=n.alpha;if(!r(p)){var y=e(n.minimumAlpha,0),E=e(n.maximumAlpha,1);if(y>E)throw new t("minimumAlpha must be less than or equal to maximumAlpha");p=y+o.nextRandomNumber()*(E-y)}return r(i)?(i.red=a,i.green=l,i.blue=w,i.alpha=p,i):new s(a,l,w,p)};var h=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,c=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,w=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,d=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(n){if(!r(n))throw new t("color is required");var i=s[n.toUpperCase()];if(r(i))return s.clone(i);var o=h.exec(n);return null!==o?new s(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=c.exec(n),null!==o?new s(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=w.exec(n),null!==o?new s(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(e(o[4],"1.0"))):(o=d.exec(n),null!==o?s.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(e(o[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.red,i[o++]=n.green,i[o++]=n.blue,i[o]=n.alpha},s.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new s),o.red=n[i++],o.green=n[i++],o.blue=n[i++],o.alpha=n[i],o},s.byteToFloat=function(e){return e/255},s.floatToByte=function(e){return 1===e?255:0|256*e},s.clone=function(e,t){return r(e)?r(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new s(e.red,e.green,e.blue,e.alpha):void 0},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return this===e||r(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var e=s.floatToByte(this.red),r=s.floatToByte(this.green),t=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+r+","+t+")":"rgba("+e+","+r+","+t+","+this.alpha+")"},s.prototype.toBytes=function(e){var t=s.floatToByte(this.red),n=s.floatToByte(this.green),i=s.floatToByte(this.blue),o=s.floatToByte(this.alpha);return r(e)?(e[0]=t,e[1]=n,e[2]=i,e[3]=o,e):[t,n,i,o]},s.prototype.toRgba=function(){return l[0]=s.floatToByte(this.red),l[1]=s.floatToByte(this.green),l[2]=s.floatToByte(this.blue),l[3]=s.floatToByte(this.alpha),f[0]},s.ALICEBLUE=i(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=i(s.fromCssColorString("#FAEBD7")),s.AQUA=i(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=i(s.fromCssColorString("#7FFFD4")),s.AZURE=i(s.fromCssColorString("#F0FFFF")),s.BEIGE=i(s.fromCssColorString("#F5F5DC")),s.BISQUE=i(s.fromCssColorString("#FFE4C4")),s.BLACK=i(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=i(s.fromCssColorString("#FFEBCD")),s.BLUE=i(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=i(s.fromCssColorString("#8A2BE2")),s.BROWN=i(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=i(s.fromCssColorString("#DEB887")),s.CADETBLUE=i(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=i(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=i(s.fromCssColorString("#D2691E")),s.CORAL=i(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=i(s.fromCssColorString("#6495ED")),s.CORNSILK=i(s.fromCssColorString("#FFF8DC")),s.CRIMSON=i(s.fromCssColorString("#DC143C")),s.CYAN=i(s.fromCssColorString("#00FFFF")),s.DARKBLUE=i(s.fromCssColorString("#00008B")),s.DARKCYAN=i(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=i(s.fromCssColorString("#B8860B")),s.DARKGRAY=i(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=i(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=i(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=i(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=i(s.fromCssColorString("#556B2F")),s.DARKORANGE=i(s.fromCssColorString("#FF8C00")),s.DARKORCHID=i(s.fromCssColorString("#9932CC")),s.DARKRED=i(s.fromCssColorString("#8B0000")),s.DARKSALMON=i(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=i(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=i(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=i(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=i(s.fromCssColorString("#00CED1")),s.DARKVIOLET=i(s.fromCssColorString("#9400D3")),s.DEEPPINK=i(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=i(s.fromCssColorString("#00BFFF")),s.DIMGRAY=i(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=i(s.fromCssColorString("#1E90FF")),s.FIREBRICK=i(s.fromCssColorString("#B22222")),s.FLORALWHITE=i(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=i(s.fromCssColorString("#228B22")),s.FUSCHIA=i(s.fromCssColorString("#FF00FF")),s.GAINSBORO=i(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=i(s.fromCssColorString("#F8F8FF")),s.GOLD=i(s.fromCssColorString("#FFD700")),s.GOLDENROD=i(s.fromCssColorString("#DAA520")),s.GRAY=i(s.fromCssColorString("#808080")),s.GREEN=i(s.fromCssColorString("#008000")),s.GREENYELLOW=i(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=i(s.fromCssColorString("#F0FFF0")),s.HOTPINK=i(s.fromCssColorString("#FF69B4")),s.INDIANRED=i(s.fromCssColorString("#CD5C5C")),s.INDIGO=i(s.fromCssColorString("#4B0082")),s.IVORY=i(s.fromCssColorString("#FFFFF0")),s.KHAKI=i(s.fromCssColorString("#F0E68C")),s.LAVENDER=i(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=i(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=i(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=i(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=i(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=i(s.fromCssColorString("#F08080")),s.LIGHTCYAN=i(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=i(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=i(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=i(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=i(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=i(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=i(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=i(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=i(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=i(s.fromCssColorString("#FFFFE0")),s.LIME=i(s.fromCssColorString("#00FF00")),s.LIMEGREEN=i(s.fromCssColorString("#32CD32")),s.LINEN=i(s.fromCssColorString("#FAF0E6")),s.MAGENTA=i(s.fromCssColorString("#FF00FF")),s.MAROON=i(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=i(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=i(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=i(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=i(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=i(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=i(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=i(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=i(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=i(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=i(s.fromCssColorString("#191970")),s.MINTCREAM=i(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=i(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=i(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=i(s.fromCssColorString("#FFDEAD")),s.NAVY=i(s.fromCssColorString("#000080")),s.OLDLACE=i(s.fromCssColorString("#FDF5E6")),s.OLIVE=i(s.fromCssColorString("#808000")),s.OLIVEDRAB=i(s.fromCssColorString("#6B8E23")),s.ORANGE=i(s.fromCssColorString("#FFA500")),s.ORANGERED=i(s.fromCssColorString("#FF4500")),s.ORCHID=i(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=i(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=i(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=i(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=i(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=i(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=i(s.fromCssColorString("#FFDAB9")),s.PERU=i(s.fromCssColorString("#CD853F")),s.PINK=i(s.fromCssColorString("#FFC0CB")),s.PLUM=i(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=i(s.fromCssColorString("#B0E0E6")),s.PURPLE=i(s.fromCssColorString("#800080")),s.RED=i(s.fromCssColorString("#FF0000")),s.ROSYBROWN=i(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=i(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=i(s.fromCssColorString("#8B4513")),s.SALMON=i(s.fromCssColorString("#FA8072")),s.SANDYBROWN=i(s.fromCssColorString("#F4A460")),s.SEAGREEN=i(s.fromCssColorString("#2E8B57")),s.SEASHELL=i(s.fromCssColorString("#FFF5EE")),s.SIENNA=i(s.fromCssColorString("#A0522D")),s.SILVER=i(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=i(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=i(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=i(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=i(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=i(s.fromCssColorString("#00FF7F")),s.STEELBLUE=i(s.fromCssColorString("#4682B4")),s.TAN=i(s.fromCssColorString("#D2B48C")),s.TEAL=i(s.fromCssColorString("#008080")),s.THISTLE=i(s.fromCssColorString("#D8BFD8")),s.TOMATO=i(s.fromCssColorString("#FF6347")),s.TURQUOISE=i(s.fromCssColorString("#40E0D0")),s.VIOLET=i(s.fromCssColorString("#EE82EE")),s.WHEAT=i(s.fromCssColorString("#F5DEB3")),s.WHITE=i(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=i(s.fromCssColorString("#F5F5F5")),s.YELLOW=i(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=i(s.fromCssColorString("#9ACD32")),s}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection"],function(e,r,t,n){"use strict";if(!n.supportsTypedArrays())return{};var i={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return i.getSizeInBytes=function(e){if(!r(e))throw new t("value is required.");switch(e){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new t("componentDatatype is not a valid value.")}},i.fromTypedArray=function(e){return e instanceof Int8Array?i.BYTE:e instanceof Uint8Array?i.UNSIGNED_BYTE:e instanceof Int16Array?i.SHORT:e instanceof Uint16Array?i.UNSIGNED_SHORT:e instanceof Float32Array?i.FLOAT:e instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(e){return r(e)&&(e===i.BYTE||e===i.UNSIGNED_BYTE||e===i.SHORT||e===i.UNSIGNED_SHORT||e===i.FLOAT||e===i.DOUBLE)},i.createTypedArray=function(e,n){if(!r(e))throw new t("componentDatatype is required.");if(!r(n))throw new t("valuesOrLength is required.");switch(e){case i.BYTE:return new Int8Array(n);case i.UNSIGNED_BYTE:return new Uint8Array(n);case i.SHORT:return new Int16Array(n);case i.UNSIGNED_SHORT:return new Uint16Array(n);case i.FLOAT:return new Float32Array(n);case i.DOUBLE:return new Float64Array(n);default:throw new t("componentDatatype is not a valid value.")}},i.createArrayBufferView=function(n,o,a,s){if(!r(n))throw new t("componentDatatype is required.");if(!r(o))throw new t("buffer is required.");switch(a=e(a,0),s=e(s,(o.byteLength-a)/i.getSizeInBytes(n)),n){case i.BYTE:return new Int8Array(o,a,s);case i.UNSIGNED_BYTE:return new Uint8Array(o,a,s);case i.SHORT:return new Int16Array(o,a,s);case i.UNSIGNED_SHORT:return new Uint16Array(o,a,s);case i.FLOAT:return new Float32Array(o,a,s);case i.DOUBLE:return new Float64Array(o,a,s);default:throw new t("componentDatatype is not a valid value.")}},i}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.attributes))throw new t("options.attributes is required.");if(!r(n.primitiveType))throw new t("options.primitiveType is required.");this.attributes=n.attributes,this.indices=n.indices,this.primitiveType=n.primitiveType,this.boundingSphere=n.boundingSphere};return n.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&r(e.attributes[i])&&r(e.attributes[i].values)){var o=e.attributes[i],a=o.values.length/o.componentsPerAttribute;if(n!==a&&-1!==n)throw new t("All attribute lists must have the same number of attributes.");n=a}return n},n}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(n.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(n.values))throw new t("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/IndexDatatype",["./defined","./DeveloperError","./Math"],function(e,r,t){"use strict";var n={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return n.getSizeInBytes=function(e){switch(e){case n.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case n.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case n.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new r("indexDatatype is required and must be a valid IndexDatatype constant.")},n.validate=function(r){return e(r)&&(r===n.UNSIGNED_BYTE||r===n.UNSIGNED_SHORT||r===n.UNSIGNED_INT)},n.createTypedArray=function(n,i){if(!e(n))throw new r("numberOfVertices is required.");return n>t.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},n}),define("Core/PrimitiveType",[],function(){"use strict";var e={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(r){return r===e.POINTS||r===e.LINES||r===e.LINE_LOOP||r===e.LINE_STRIP||r===e.TRIANGLES||r===e.TRIANGLE_STRIP||r===e.TRIANGLE_FAN}};return e}),define("Core/SimplePolylineGeometry",["./BoundingSphere","./Cartesian3","./Color","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./PrimitiveType"],function(e,r,t,n,i,o,a,s,u,f,l,h){"use strict";var c=function(e){e=i(e,i.EMPTY_OBJECT);var r=e.positions,t=e.colors,n=i(e.colorsPerVertex,!1);if(!o(r)||r.length<2)throw new a("At least two positions are required.");if(o(t)&&(n&&t.length<r.length||!n&&t.length<r.length-1))throw new a("colors has an invalid length.");this._positions=r,this._colors=t,this._perVertex=n,this._workerName="createSimplePolylineGeometry"};return c.createGeometry=function(i){var a,c=i._positions,w=i._colors,d=i._perVertex,m=o(w)&&!d,p=0,y=0,E=c.length,g=m?2*c.length-2:c.length,C=new Float64Array(3*g),S=o(w)?new Uint8Array(4*g):void 0;for(a=0;E>a;++a){var q,v=c[a];if(m&&a>0&&(r.pack(v,C,p),p+=3,q=w[a-1],S[y++]=t.floatToByte(q.red),S[y++]=t.floatToByte(q.green),S[y++]=t.floatToByte(q.blue),S[y++]=t.floatToByte(q.alpha)),m&&a===E-1)break;r.pack(v,C,p),p+=3,o(w)&&(q=w[a],S[y++]=t.floatToByte(q.red),S[y++]=t.floatToByte(q.green),S[y++]=t.floatToByte(q.blue),S[y++]=t.floatToByte(q.alpha))}var b=new f;b.position=new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:C}),o(w)&&(b.color=new u({componentDatatype:n.UNSIGNED_BYTE,componentsPerAttribute:4,values:S,normalize:!0}));var M=m?g:2*(g-1),x=l.createTypedArray(g,M),A=m?2:1;for(p=0,a=0;g-1>a;a+=A)x[p++]=a,x[p++]=a+1;return new s({attributes:b,indices:x,primitiveType:h.LINES,boundingSphere:e.fromPoints(c)})},c}),define("Workers/createSimplePolylineGeometry",["../Core/SimplePolylineGeometry"],function(e){"use strict";return e.createGeometry})}();