/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2014 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=.5*3*Math.PI,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,a=e-Math.floor(e/r)*r;return a<-Math.PI?a+r:a>=Math.PI?a-r:a},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");for(var r=i.EPSILON10,a=i.PI,o=i.TWO_PI;-(a+r)>e;)e+=o;if(-a>e)return-a;for(;e>a+r;)e-=o;return e>a?a:e},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=e%i.TWO_PI;return 0>r?(r+i.TWO_PI)%i.TWO_PI:r},i.equalsEpsilon=function(e,i,a){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");return a=r(a,0),Math.abs(e-i)<=a};var a=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=a.length;if(e>=r)for(var t=a[r-1],i=r;e>=i;i++)a.push(t*i);return a[e]},i.incrementWrap=function(e,i,a){if(a=r(a,0),!t(e))throw new n("n is required.");if(a>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=a),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var o=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");o=new e(r)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){return Math.asin(i.clamp(e,-1,1))},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};a.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new a);var o=n.clock,u=n.cone,s=e(n.magnitude,1),f=s*Math.sin(u);return i.x=f*Math.cos(o),i.y=f*Math.sin(o),i.z=s*Math.cos(u),i},a.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new a(e,t,n)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a]=n.z},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i],o},a.fromArray=a.unpack,a.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},a.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},a.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},a.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var u=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,u),o=a.multiplyByScalar(e,1-i,o),a.add(u,o,o)};var s=new a,f=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");a.normalize(e,s),a.normalize(n,f);var i=a.dot(s,f),o=a.magnitude(a.cross(s,f,s));return Math.atan2(o,i)};var c=new a;a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,c);return a.abs(i,i),n=i.x<=i.y?i.x<=i.z?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Z,n):i.y<=i.z?a.clone(a.UNIT_Y,n):a.clone(a.UNIT_Z,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i},a.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var a=e.x,o=e.y,u=e.z,s=n.x,f=n.y,c=n.z,l=o*c-u*f,w=u*s-a*c,h=a*f-o*s;return i.x=l,i.y=w,i.z=h,i},a.fromDegrees=function(e,n,o,u,s){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var f=i.toRadians(e),c=i.toRadians(n);return a.fromRadians(f,c,o,u,s)};var l=new a,w=new a,h=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,i,o,u,s){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");o=e(o,0);var f=r(u)?u.radiiSquared:h,c=Math.cos(i);l.x=c*Math.cos(n),l.y=c*Math.sin(n),l.z=Math.sin(i),l=a.normalize(l,l),a.multiplyComponents(f,l,w);var d=Math.sqrt(a.dot(l,w));return w=a.divideByScalar(w,d,w),l=a.multiplyByScalar(l,o,l),r(s)||(s=new a),a.add(w,l,s)},a.fromDegreesArray=function(e,n,o){if(!r(e))throw new t("positions is required.");for(var u=new Array(e.length),s=0;s<e.length;s++)u[s]=i.toRadians(e[s]);return a.fromRadiansArray(u,n,o)},a.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(0!==e.length%2)throw new t("positions length must be a multiple of 2.");var o=e.length;r(i)?i.length=o/2:i=new Array(o/2);for(var u=0;o>u;u+=2){var s=e[u],f=e[u+1];i[u/2]=a.fromRadians(s,f,0,n,i[u/2])}return i},a.fromDegreesArrayHeights=function(e,n,o){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");for(var u=new Array(e.length),s=0;s<e.length;s+=3)u[s]=i.toRadians(e[s]),u[s+1]=i.toRadians(e[s+1]),u[s+2]=e[s+2];return a.fromRadiansArrayHeights(u,n,o)},a.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");var o=e.length;r(i)?i.length=o/3:i=new Array(o/3);for(var u=0;o>u;u+=3){var s=e[u],f=e[u+1],c=e[u+2];i[u/3]=a.fromRadians(s,f,c,n,i[u/3])}return i},a.ZERO=n(new a(0,0,0)),a.UNIT_X=n(new a(1,0,0)),a.UNIT_Y=n(new a(0,1,0)),a.UNIT_Z=n(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return a.fromRadians=function(n,i,o,u){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return o=e(o,0),r(u)?(u.longitude=n,u.latitude=i,u.height=o,u):new a(n,i,o)},a.fromDegrees=function(e,n,o,u){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),a.fromRadians(e,n,o,u)},a.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new a(e.longitude,e.latitude,e.height):void 0},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},a.toString=function(e){if(!r(e))throw new t("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},a.ZERO=n(new a(0,0,0)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return a.toString(this)},a}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a,o,u){"use strict";var s=function(r,n,i){if(r=t(r,0),n=t(n,0),i=t(i,0),0>r||0>n||0>i)throw new a("All radii components must be greater than or equal to zero.");this._radii=new e(r,n,i),this._radiiSquared=new e(r*r,n*n,i*i),this._radiiToTheFourth=new e(r*r*r*r,n*n*n*n,i*i*i*i),this._oneOverRadii=new e(0===r?0:1/r,0===n?0:1/n,0===i?0:1/i),this._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===n?0:1/(n*n),0===i?0:1/(i*i)),this._minimumRadius=Math.min(r,n,i),this._maximumRadius=Math.max(r,n,i),this._centerToleranceSquared=u.EPSILON1};i(s.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),s.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new s(i.x,i.y,i.z)},s.fromCartesian3=function(e){return n(e)?new s(e.x,e.y,e.z):new s},s.WGS84=o(new s(6378137,6378137,6356752.314245179)),s.UNIT_SPHERE=o(new s(1,1,1)),s.MOON=o(new s(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.geocentricSurfaceNormal=e.normalize,s.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new a("cartographic is required.");var i=r.longitude,o=r.latitude,u=Math.cos(o),s=u*Math.cos(i),f=u*Math.sin(i),c=Math.sin(o);return n(t)||(t=new e),t.x=s,t.y=f,t.z=c,e.normalize(t,t)},s.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var f=new e,c=new e;s.prototype.cartographicToCartesian=function(r,t){var i=f,a=c;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(a,i,t)},s.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new a("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var l=new e,w=new e,h=new e;s.prototype.cartesianToCartographic=function(t,i){var a=this.scaleToGeodeticSurface(t,w);if(!n(a))return void 0;var o=this.geodeticSurfaceNormal(a,l),s=e.subtract(t,a,h),f=Math.atan2(o.y,o.x),c=Math.asin(o.z),d=u.sign(e.dot(s,t))*e.magnitude(s);return n(i)?(i.longitude=f,i.latitude=c,i.height=d,i):new r(f,c,d)},s.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new a("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var d=new e,m=new e;return s.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");var i=r.x,o=r.y,s=r.z,f=this._oneOverRadii,c=f.x,l=f.y,w=f.z,h=i*i*c*c,y=o*o*l*l,p=s*s*w*w,v=h+y+p,g=Math.sqrt(1/v),b=e.multiplyByScalar(r,g,d);if(v<this._centerToleranceSquared)return isFinite(g)?e.clone(b,t):void 0;var q=this._oneOverRadiiSquared,x=q.x,M=q.y,E=q.z,S=m;S.x=2*b.x*x,S.y=2*b.y*M,S.z=2*b.z*E;var T,z,O,N,A,I,R,P,_,L,C,D=(1-g)*e.magnitude(r)/(.5*e.magnitude(S)),U=0;do{D-=U,O=1/(1+D*x),N=1/(1+D*M),A=1/(1+D*E),I=O*O,R=N*N,P=A*A,_=I*O,L=R*N,C=P*A,T=h*I+y*R+p*P-1,z=h*_*x+y*L*M+p*C*E;var B=-2*z;U=T/B}while(Math.abs(T)>u.EPSILON12);return n(t)?(t.x=i*O,t.y=o*N,t.z=s*A,t):new e(i*O,o*N,s*A)},s.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");n(t)||(t=new e);var i=r.x,o=r.y,u=r.z,s=this._oneOverRadiiSquared,f=1/Math.sqrt(i*i*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(r,f,t)},s.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},s.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},s.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},s.prototype.toString=function(){return this._radii.toString()},s}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,a,o){"use strict";var u=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};u.fromDegrees=function(e,n,i,a,s){return e=o.toRadians(r(e,0)),n=o.toRadians(r(n,0)),i=o.toRadians(r(i,0)),a=o.toRadians(r(a,0)),t(s)?(s.west=e,s.south=n,s.east=i,s.north=a,s):new u(e,n,i,a)},u.fromCartographicArray=function(e,r){if(!t(e))throw new n("cartographics is required.");for(var i=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,s=-Number.MAX_VALUE,f=0,c=e.length;c>f;f++){var l=e[f];i=Math.min(i,l.longitude),a=Math.max(a,l.longitude),o=Math.min(o,l.latitude),s=Math.max(s,l.latitude)}return t(r)?(r.west=i,r.south=o,r.east=a,r.north=s,r):new u(i,o,a,s)},u.packedLength=4,u.pack=function(e,i,a){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");a=r(a,0),i[a++]=e.west,i[a++]=e.south,i[a++]=e.east,i[a]=e.north},u.unpack=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new u),a.west=e[i++],a.south=e[i++],a.east=e[i++],a.north=e[i],a},u.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new u(e.west,e.south,e.east,e.north):void 0},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},u.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new n("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},u.validate=function(e){if(!t(e))throw new n("rectangle is required");var r=e.north;if("number"!=typeof r)throw new n("north is required to be a number.");if(r<-o.PI_OVER_TWO||r>o.PI_OVER_TWO)throw new n("north must be in the interval [-Pi/2, Pi/2].");var i=e.south;if("number"!=typeof i)throw new n("south is required to be a number.");if(i<-o.PI_OVER_TWO||i>o.PI_OVER_TWO)throw new n("south must be in the interval [-Pi/2, Pi/2].");var a=e.west;if("number"!=typeof a)throw new n("west is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new n("west must be in the interval [-Pi, Pi].");var u=e.east;if("number"!=typeof u)throw new n("east is required to be a number.");if(u<-Math.PI||u>Math.PI)throw new n("east must be in the interval [-Pi, Pi].")},u.getSouthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},u.getNorthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},u.getNortheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},u.getSoutheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},u.getCenter=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=.5*(r.west+r.east),i.latitude=.5*(r.south+r.north),i.height=0,i):new e(.5*(r.west+r.east),.5*(r.south+r.north))},u.intersectWith=function(e,r,i){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("otherRectangle is required.");var a=Math.max(e.west,r.west),o=Math.max(e.south,r.south),s=Math.min(e.east,r.east),f=Math.min(e.north,r.north);return t(i)?(i.west=a,i.south=o,i.east=s,i.north=f,i):new u(a,o,s,f)},u.contains=function(e,r){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("cartographic is required.");return r.longitude>=e.west&&r.longitude<=e.east&&r.latitude>=e.south&&r.latitude<=e.north},u.isEmpty=function(e){if(!t(e))throw new n("rectangle is required");return e.west>=e.east||e.south>=e.north};var s=new e;return u.subsample=function(e,a,u,f){if(!t(e))throw new n("rectangle is required");a=r(a,i.WGS84),u=r(u,0),t(f)||(f=[]);var c=0,l=e.north,w=e.south,h=e.east,d=e.west,m=s;m.height=u,m.longitude=d,m.latitude=l,f[c]=a.cartographicToCartesian(m,f[c]),c++,m.longitude=h,f[c]=a.cartographicToCartesian(m,f[c]),c++,m.latitude=w,f[c]=a.cartographicToCartesian(m,f[c]),c++,m.longitude=d,f[c]=a.cartographicToCartesian(m,f[c]),c++,m.latitude=0>l?l:w>0?w:0;for(var y=1;8>y;++y){var p=-Math.PI+y*o.PI_OVER_TWO;p>d&&h>p&&(m.longitude=p,f[c]=a.cartographicToCartesian(m,f[c]),c++)}return 0===m.latitude&&(m.longitude=d,f[c]=a.cartographicToCartesian(m,f[c]),c++,m.longitude=h,f[c]=a.cartographicToCartesian(m,f[c]),c++),f.length=c,f},u.MAX_VALUE=a(new u(-Math.PI,-o.PI_OVER_TWO,Math.PI,o.PI_OVER_TWO)),u}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,a,o){"use strict";var u=function(e){this._ellipsoid=t(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(r,t){var i=this._semimajorAxis,a=r.longitude*i,o=r.latitude*i,u=r.height;return n(t)?(t.x=a,t.y=o,t.z=u,t):new e(a,o,u)},u.prototype.unproject=function(e,t){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=e.y*i,s=e.z;return n(t)?(t.longitude=o,t.latitude=u,t.height=s,t):new r(o,u,s)},u}),define("Core/Intersect",[],function(){"use strict";var e={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};i.fromElements=function(e,t,n,a,o){return r(o)?(o.x=e,o.y=t,o.z=n,o.w=a,o):new i(e,t,n,a)},i.fromColor=function(e,n){if(!r(e))throw new t("color is required");return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a++]=n.z,i[a]=n.w},i.unpack=function(n,a,o){if(!r(n))throw new t("array is required");return a=e(a,0),r(o)||(o=new i),o.x=n[a++],o.y=n[a++],o.z=n[a++],o.w=n[a],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},i.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},i.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},i.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},i.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return i.subtract(e,n,a),i.magnitude(a)},i.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var a=i.magnitude(e);return n.x=e.x/a,n.y=e.y/a,n.z=e.z/a,n.w=e.w/a,n},i.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},i.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},i.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},i.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},i.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},i.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},i.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},i.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var o=new i;i.lerp=function(e,n,a,u){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof a)throw new t("t is required and must be a number.");if(!r(u))throw new t("result is required.");return i.multiplyByScalar(n,a,o),u=i.multiplyByScalar(e,1-a,u),i.add(o,u,u)};var u=new i;return i.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var a=i.normalize(e,u);return i.abs(a,a),n=a.x<=a.y?a.x<=a.z?a.x<=a.w?i.clone(i.UNIT_X,n):i.clone(i.UNIT_W,n):a.z<=a.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n):a.y<=a.z?a.y<=a.w?i.clone(i.UNIT_Y,n):i.clone(i.UNIT_W,n):a.z<=a.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},i.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i&&Math.abs(e.w-n.w)<=i},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,r){return i.equalsEpsilon(this,e,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a){"use strict";function o(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function u(e){for(var r=0,t=0;3>t;++t){var n=e[f.getElementIndex(h[t],w[t])];r+=2*n*n}return Math.sqrt(r)}function s(e,r){for(var t=a.EPSILON15,n=0,i=1,o=0;3>o;++o){var u=Math.abs(e[f.getElementIndex(h[o],w[o])]);u>n&&(i=o,n=u)}var s=1,c=0,l=w[i],d=h[i];if(Math.abs(e[f.getElementIndex(d,l)])>t){var m,y=e[f.getElementIndex(d,d)],p=e[f.getElementIndex(l,l)],v=e[f.getElementIndex(d,l)],g=(y-p)/2/v;m=0>g?-1/(-g+Math.sqrt(1+g*g)):1/(g+Math.sqrt(1+g*g)),s=1/Math.sqrt(1+m*m),c=m*s}return r=f.clone(f.IDENTITY,r),r[f.getElementIndex(l,l)]=r[f.getElementIndex(d,d)]=s,r[f.getElementIndex(d,l)]=c,r[f.getElementIndex(l,d)]=-c,r}var f=function(e,t,n,i,a,o,u,s,f){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(f,0)};f.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new f(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},f.fromArray=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new f),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a[9]=e[i+9],a},f.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])
},f.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,u=e.x*e.w,s=e.y*e.y,c=e.y*e.z,l=e.y*e.w,w=e.z*e.z,h=e.z*e.w,d=e.w*e.w,m=i-s-w+d,y=2*(a-h),p=2*(o+l),v=2*(a+h),g=-i+s-w+d,b=2*(c-u),q=2*(o-l),x=2*(c+u),M=-i-s+w+d;return t(r)?(r[0]=m,r[1]=v,r[2]=q,r[3]=y,r[4]=g,r[5]=x,r[6]=p,r[7]=b,r[8]=M,r):new f(m,y,p,v,g,b,q,x,M)},f.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new f(e.x,0,0,0,e.y,0,0,0,e.z)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new f(e,0,0,0,e,0,0,0,e)},f.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=a,r[6]=0,r[7]=-a,r[8]=i,r):new f(1,0,0,0,i,-a,0,a,i)},f.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=i,r):new f(i,0,a,0,1,0,-a,0,i)},f.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=a,r[2]=0,r[3]=-a,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new f(i,-a,0,a,i,0,0,0,1)},f.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},f.getColumn=function(r,i,a){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var o=3*i,u=r[o],s=r[o+1],f=r[o+2];return t(a)?(a.x=u,a.y=s,a.z=f,a):new e(u,s,f)},f.setColumn=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");a=f.clone(e,a);var o=3*r;return a[o]=i.x,a[o+1]=i.y,a[o+2]=i.z,a},f.getRow=function(r,i,a){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var o=r[i],u=r[i+3],s=r[i+6];return t(a)?(a.x=o,a.y=u,a.z=s,a):new e(o,u,s)},f.setRow=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");return a=f.clone(e,a),a[r]=i.x,a[r+3]=i.y,a[r+6]=i.z,a};var c=new e;f.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");return t(i)||(i=new e),i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],c)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],c)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],c)),i};var l=new e;f.getMaximumScale=function(r){return f.getScale(r,l),e.getMaximumComponent(l)},f.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");var a=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],o=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],u=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],c=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],l=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],w=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],h=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],d=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return t(i)?(i[0]=a,i[1]=o,i[2]=u,i[3]=s,i[4]=c,i[5]=l,i[6]=w,i[7]=h,i[8]=d,i):new f(a,s,w,o,c,h,u,l,d)},f.multiplyByVector=function(r,i,a){if(!t(r))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");var o=i.x,u=i.y,s=i.z,f=r[0]*o+r[3]*u+r[6]*s,c=r[1]*o+r[4]*u+r[7]*s,l=r[2]*o+r[5]*u+r[8]*s;return t(a)?(a.x=f,a.y=c,a.z=l,a):new e(f,c,l)},f.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");return t(i)?(i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i):new f(e[0]*r,e[3]*r,e[6]*r,e[1]*r,e[4]*r,e[7]*r,e[2]*r,e[5]*r,e[8]*r)},f.negate=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r):new f(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},f.transpose=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],a=e[3],o=e[6],u=e[1],s=e[4],c=e[7],l=e[2],w=e[5],h=e[8];return t(r)?(r[0]=i,r[1]=a,r[2]=o,r[3]=u,r[4]=s,r[5]=c,r[6]=l,r[7]=w,r[8]=h,r):new f(i,u,l,a,s,w,o,c,h)};var w=[1,0,0],h=[2,2,1],d=new f,m=new f;return f.getEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=a.EPSILON20,c=10,l=0,w=0;t(r)||(r={});for(var h=r.unitary=f.clone(f.IDENTITY,r.unitary),y=r.diagonal=f.clone(e,r.diagonal),p=i*o(y);c>w&&u(y)>p;)s(y,d),f.transpose(d,m),f.multiply(y,d,y),f.multiply(m,y,y),f.multiply(h,d,h),++l>2&&(++w,l=0);return r},f.abs=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r):new f(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},f.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],a=e[6],o=e[1],u=e[4],s=e[7],f=e[2],c=e[5],l=e[8];return r*(u*l-c*s)+o*(c*a-i*l)+f*(i*s-u*a)},f.inverse=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],o=e[1],u=e[2],s=e[3],c=e[4],l=e[5],w=e[6],h=e[7],d=e[8],m=f.determinant(e);if(Math.abs(m)<=a.EPSILON15)throw new n("matrix is not invertible");t(r)||(r=new f),r[0]=c*d-h*l,r[1]=h*u-o*d,r[2]=o*l-c*u,r[3]=w*l-s*d,r[4]=i*d-w*u,r[5]=s*u-i*l,r[6]=s*h-w*c,r[7]=w*o-i*h,r[8]=i*c-s*o;var y=1/m;return f.multiplyByScalar(r,y,r)},f.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},f.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},f.IDENTITY=i(new f(1,0,0,0,1,0,0,0,1)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN1ROW0=3,f.COLUMN1ROW1=4,f.COLUMN1ROW2=5,f.COLUMN2ROW0=6,f.COLUMN2ROW1=7,f.COLUMN2ROW2=8,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},f}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,a,o,u,s){"use strict";var f=function(e,r,n,i,a,o,u,s,f,c,l,w,h,d,m,y){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(f,0),this[3]=t(h,0),this[4]=t(r,0),this[5]=t(o,0),this[6]=t(c,0),this[7]=t(d,0),this[8]=t(n,0),this[9]=t(u,0),this[10]=t(l,0),this[11]=t(m,0),this[12]=t(i,0),this[13]=t(s,0),this[14]=t(w,0),this[15]=t(y,0)};f.packedLength=16,f.pack=function(e,r,a){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");a=t(a,0),r[a++]=e[0],r[a++]=e[1],r[a++]=e[2],r[a++]=e[3],r[a++]=e[4],r[a++]=e[5],r[a++]=e[6],r[a++]=e[7],r[a++]=e[8],r[a++]=e[9],r[a++]=e[10],r[a++]=e[11],r[a++]=e[12],r[a++]=e[13],r[a++]=e[14],r[a]=e[15]},f.unpack=function(e,r,a){if(!n(e))throw new i("array is required");return r=t(r,0),n(a)||(a=new f),a[0]=e[r++],a[1]=e[r++],a[2]=e[r++],a[3]=e[r++],a[4]=e[r++],a[5]=e[r++],a[6]=e[r++],a[7]=e[r++],a[8]=e[r++],a[9]=e[r++],a[10]=e[r++],a[11]=e[r++],a[12]=e[r++],a[13]=e[r++],a[14]=e[r++],a[15]=e[r],a},f.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(e,r,t){if(!n(e))throw new i("rotation is required.");if(!n(r))throw new i("translation is required.");return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=0,t[4]=e[3],t[5]=e[4],t[6]=e[5],t[7]=0,t[8]=e[6],t[9]=e[7],t[10]=e[8],t[11]=0,t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=1,t):new f(e[0],e[3],e[6],r.x,e[1],e[4],e[7],r.y,e[2],e[5],e[8],r.z,0,0,0,1)},new u,f.fromTranslationQuaternionRotationScale=function(e,r,t,a){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(a)||(a=new f);var o=t.x,u=t.y,s=t.z,c=r.x*r.x,l=r.x*r.y,w=r.x*r.z,h=r.x*r.w,d=r.y*r.y,m=r.y*r.z,y=r.y*r.w,p=r.z*r.z,v=r.z*r.w,g=r.w*r.w,b=c-d-p+g,q=2*(l-v),x=2*(w+y),M=2*(l+v),E=-c+d-p+g,S=2*(m-h),T=2*(w-y),z=2*(m+h),O=-c-d+p+g;return a[0]=b*o,a[1]=M*o,a[2]=T*o,a[3]=0,a[4]=q*u,a[5]=E*u,a[6]=z*u,a[7]=0,a[8]=x*s,a[9]=S*s,a[10]=O*s,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},f.fromTranslation=function(e,r){return f.fromRotationTranslation(u.IDENTITY,e,r)},f.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var c=new e,l=new e,w=new e;f.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var a=r.eye,o=r.target,u=r.up;if(!n(a))throw new i("camera.eye is required.");if(!n(o))throw new i("camera.target is required.");if(!n(u))throw new i("camera.up is required.");e.normalize(e.subtract(o,a,c),c),e.normalize(e.cross(c,u,l),l),e.normalize(e.cross(l,c,w),w);var s=l.x,h=l.y,d=l.z,m=c.x,y=c.y,p=c.z,v=w.x,g=w.y,b=w.z,q=a.x,x=a.y,M=a.z,E=s*-q+h*-x+d*-M,S=v*-q+g*-x+b*-M,T=m*q+y*x+p*M;return n(t)?(t[0]=s,t[1]=v,t[2]=-m,t[3]=0,t[4]=h,t[5]=g,t[6]=-y,t[7]=0,t[8]=d,t[9]=b,t[10]=-p,t[11]=0,t[12]=E,t[13]=S,t[14]=T,t[15]=1,t):new f(s,h,d,E,v,g,b,S,-m,-y,-p,T,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,r,t,a,o){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=a)throw new i("far must be greater than zero.");var u=Math.tan(.5*e),s=1/u,c=s/r,l=(a+t)/(t-a),w=2*a*t/(t-a);return n(o)?(o[0]=c,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=l,o[11]=-1,o[12]=0,o[13]=0,o[14]=w,o[15]=0,o):new f(c,0,0,0,0,s,0,0,0,0,l,w,0,0,-1,0)},f.computeOrthographicOffCenter=function(e,r,t,a,o,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(u))throw new i("far is required.");var c=1/(r-e),l=1/(a-t),w=1/(u-o),h=-(r+e)*c,d=-(a+t)*l,m=-(u+o)*w;return c*=2,l*=2,w*=-2,n(s)?(s[0]=c,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=l,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=w,s[11]=0,s[12]=h,s[13]=d,s[14]=m,s[15]=1,s):new f(c,0,0,h,0,l,0,d,0,0,w,m,0,0,0,1)},f.computePerspectiveOffCenter=function(e,r,t,a,o,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(u))throw new i("far is required.");var c=2*o/(r-e),l=2*o/(a-t),w=(r+e)/(r-e),h=(a+t)/(a-t),d=-(u+o)/(u-o),m=-1,y=-2*u*o/(u-o);return n(s)?(s[0]=c,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=l,s[6]=0,s[7]=0,s[8]=w,s[9]=h,s[10]=d,s[11]=m,s[12]=0,s[13]=0,s[14]=y,s[15]=0,s):new f(c,0,w,0,0,l,h,0,0,0,d,y,0,0,m,0)},f.computeInfinitePerspectiveOffCenter=function(e,r,t,a,o,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");var s=2*o/(r-e),c=2*o/(a-t),l=(r+e)/(r-e),w=(a+t)/(a-t),h=-1,d=-1,m=-2*o;return n(u)?(u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=l,u[9]=w,u[10]=h,u[11]=d,u[12]=0,u[13]=0,u[14]=m,u[15]=0,u):new f(s,0,l,0,0,c,w,0,0,0,h,m,0,0,d,0)},f.computeViewportTransformation=function(e,r,i,a){e=t(e,t.EMPTY_OBJECT);var o=t(e.x,0),u=t(e.y,0),s=t(e.width,0),c=t(e.height,0);r=t(r,0),i=t(i,1);var l=.5*s,w=.5*c,h=.5*(i-r),d=l,m=w,y=h,p=o+l,v=u+w,g=r+h,b=1;return n(a)?(a[0]=d,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=m,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=y,a[11]=0,a[12]=p,a[13]=v,a[14]=g,a[15]=b,a):new f(d,0,0,p,0,m,0,v,0,0,y,g,0,0,0,b)},f.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},f.getColumn=function(e,t,a){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var o=4*t,u=e[o],s=e[o+1],f=e[o+2],c=e[o+3];return n(a)?(a.x=u,a.y=s,a.z=f,a.w=c,a):new r(u,s,f,c)},f.setColumn=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");a=f.clone(e,a);var o=4*r;return a[o]=t.x,a[o+1]=t.y,a[o+2]=t.z,a[o+3]=t.w,a},f.getRow=function(e,t,a){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var o=e[t],u=e[t+4],s=e[t+8],f=e[t+12];return n(a)?(a.x=o,a.y=u,a.z=s,a.w=f,a):new r(o,u,s,f)},f.setRow=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");return a=f.clone(e,a),a[r]=t.x,a[r+4]=t.y,a[r+8]=t.z,a[r+12]=t.w,a};var h=new e;f.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");return n(t)||(t=new e),t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],h)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],h)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],h)),t};var d=new e;f.getMaximumScale=function(r){return f.getScale(r,d),e.getMaximumComponent(d)},f.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var a=e[0],o=e[1],u=e[2],s=e[3],c=e[4],l=e[5],w=e[6],h=e[7],d=e[8],m=e[9],y=e[10],p=e[11],v=e[12],g=e[13],b=e[14],q=e[15],x=r[0],M=r[1],E=r[2],S=r[3],T=r[4],z=r[5],O=r[6],N=r[7],A=r[8],I=r[9],R=r[10],P=r[11],_=r[12],L=r[13],C=r[14],D=r[15],U=a*x+c*M+d*E+v*S,B=o*x+l*M+m*E+g*S,F=u*x+w*M+y*E+b*S,V=s*x+h*M+p*E+q*S,W=a*T+c*z+d*O+v*N,G=o*T+l*z+m*O+g*N,Y=u*T+w*z+y*O+b*N,k=s*T+h*z+p*O+q*N,j=a*A+c*I+d*R+v*P,H=o*A+l*I+m*R+g*P,Z=u*A+w*I+y*R+b*P,X=s*A+h*I+p*R+q*P,K=a*_+c*L+d*C+v*D,Q=o*_+l*L+m*C+g*D,J=u*_+w*L+y*C+b*D,$=s*_+h*L+p*C+q*D;return n(t)?(t[0]=U,t[1]=B,t[2]=F,t[3]=V,t[4]=W,t[5]=G,t[6]=Y,t[7]=k,t[8]=j,t[9]=H,t[10]=Z,t[11]=X,t[12]=K,t[13]=Q,t[14]=J,t[15]=$,t):new f(U,W,j,K,B,G,H,Q,F,Y,Z,J,V,k,X,$)},f.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var a=e[0],o=e[1],u=e[2],s=e[4],c=e[5],l=e[6],w=e[8],h=e[9],d=e[10],m=e[12],y=e[13],p=e[14],v=r[0],g=r[1],b=r[2],q=r[4],x=r[5],M=r[6],E=r[8],S=r[9],T=r[10],z=r[12],O=r[13],N=r[14],A=a*v+s*g+w*b,I=o*v+c*g+h*b,R=u*v+l*g+d*b,P=a*q+s*x+w*M,_=o*q+c*x+h*M,L=u*q+l*x+d*M,C=a*E+s*S+w*T,D=o*E+c*S+h*T,U=u*E+l*S+d*T,B=a*z+s*O+w*N+m,F=o*z+c*O+h*N+y,V=u*z+l*O+d*N+p;return n(t)?(t[0]=A,t[1]=I,t[2]=R,t[3]=0,t[4]=P,t[5]=_,t[6]=L,t[7]=0,t[8]=C,t[9]=D,t[10]=U,t[11]=0,t[12]=B,t[13]=F,t[14]=V,t[15]=1,t):new f(A,P,C,B,I,_,D,F,R,L,U,V,0,0,0,1)},f.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");var a=r.x,o=r.y,u=r.z,s=a*e[0]+o*e[4]+u*e[8]+e[12],c=a*e[1]+o*e[5]+u*e[9]+e[13],l=a*e[2]+o*e[6]+u*e[10]+e[14];return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=s,t[13]=c,t[14]=l,t[15]=e[15],t):new f(e[0],e[4],e[8],s,e[1],e[5],e[9],c,e[2],e[6],e[10],l,e[3],e[7],e[11],e[15])};var m=new e;return f.multiplyByUniformScale=function(e,r,t){if("number"!=typeof r)throw new i("scale is required");return m.x=r,m.y=r,m.z=r,f.multiplyByScale(e,m,t)},f.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");var a=r.x,o=r.y,u=r.z;return 1===a&&1===o&&1===u?f.clone(e,t):n(t)?(t[0]=a*e[0],t[1]=a*e[1],t[2]=a*e[2],t[3]=0,t[4]=o*e[4],t[5]=o*e[5],t[6]=o*e[6],t[7]=0,t[8]=u*e[8],t[9]=u*e[9],t[10]=u*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t):new f(a*e[0],o*e[4],u*e[8],e[12],a*e[1],o*e[5],u*e[9],e[13],a*e[2],o*e[6],u*e[10],e[14],0,0,0,1)},f.multiplyByVector=function(e,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,u=t.y,s=t.z,f=t.w,c=e[0]*o+e[4]*u+e[8]*s+e[12]*f,l=e[1]*o+e[5]*u+e[9]*s+e[13]*f,w=e[2]*o+e[6]*u+e[10]*s+e[14]*f,h=e[3]*o+e[7]*u+e[11]*s+e[15]*f;return n(a)?(a.x=c,a.y=l,a.z=w,a.w=h,a):new r(c,l,w,h)},f.multiplyByPointAsVector=function(r,t,a){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,u=t.y,s=t.z,f=r[0]*o+r[4]*u+r[8]*s,c=r[1]*o+r[5]*u+r[9]*s,l=r[2]*o+r[6]*u+r[10]*s;return n(a)?(a.x=f,a.y=c,a.z=l,a):new e(f,c,l)},f.multiplyByPoint=function(r,t,a){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,u=t.y,s=t.z,f=r[0]*o+r[4]*u+r[8]*s+r[12],c=r[1]*o+r[5]*u+r[9]*s+r[13],l=r[2]*o+r[6]*u+r[10]*s+r[14];return n(a)?(a.x=f,a.y=c,a.z=l,a):new e(f,c,l)},f.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");return n(t)?(t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t):new f(e[0]*r,e[4]*r,e[8]*r,e[12]*r,e[1]*r,e[5]*r,e[9]*r,e[13]*r,e[2]*r,e[6]*r,e[10]*r,e[14]*r,e[3]*r,e[7]*r,e[11]*r,e[15]*r)},f.negate=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r):new f(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},f.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))return new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var t=e[1],a=e[2],o=e[3],u=e[6],s=e[7],c=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=a,r[9]=u,r[10]=e[10],r[11]=e[14],r[12]=o,r[13]=s,r[14]=c,r[15]=e[15],r},f.abs=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r):new f(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},f.equals=function(e,r){return e===r||n(e)&&n(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[11]===r[11]&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[15]===r[15]},f.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},f.getTranslation=function(r,t){if(!n(r))throw new i("matrix is required");return n(t)?(t.x=r[12],t.y=r[13],t.z=r[14],t):new e(r[12],r[13],r[14])},f.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r):new u(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},f.inverse=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],a=e[4],u=e[8],c=e[12],l=e[1],w=e[5],h=e[9],d=e[13],m=e[2],y=e[6],p=e[10],v=e[14],g=e[3],b=e[7],q=e[11],x=e[15],M=p*x,E=v*q,S=y*x,T=v*b,z=y*q,O=p*b,N=m*x,A=v*g,I=m*q,R=p*g,P=m*b,_=y*g,L=M*w+T*h+z*d-(E*w+S*h+O*d),C=E*l+N*h+R*d-(M*l+A*h+I*d),D=S*l+A*w+P*d-(T*l+N*w+_*d),U=O*l+I*w+_*h-(z*l+R*w+P*h),B=E*a+S*u+O*c-(M*a+T*u+z*c),F=M*t+A*u+I*c-(E*t+N*u+R*c),V=T*t+N*a+_*c-(S*t+A*a+P*c),W=z*t+R*a+P*u-(O*t+I*a+_*u);M=u*d,E=c*h,S=a*d,T=c*w,z=a*h,O=u*w,N=t*d,A=c*l,I=t*h,R=u*l,P=t*w,_=a*l;var G=M*b+T*q+z*x-(E*b+S*q+O*x),Y=E*g+N*q+R*x-(M*g+A*q+I*x),k=S*g+A*b+P*x-(T*g+N*b+_*x),j=O*g+I*b+_*q-(z*g+R*b+P*q),H=S*p+O*v+E*y-(z*v+M*y+T*p),Z=I*v+M*m+A*p-(N*p+R*v+E*m),X=N*y+_*v+T*m-(P*v+S*m+A*y),K=P*p+z*m+R*y-(I*y+_*p+O*m),Q=t*L+a*C+u*D+c*U;if(Math.abs(Q)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return Q=1/Q,n(r)?(r[0]=L*Q,r[1]=C*Q,r[2]=D*Q,r[3]=U*Q,r[4]=B*Q,r[5]=F*Q,r[6]=V*Q,r[7]=W*Q,r[8]=G*Q,r[9]=Y*Q,r[10]=k*Q,r[11]=j*Q,r[12]=H*Q,r[13]=Z*Q,r[14]=X*Q,r[15]=K*Q,r):new f(L*Q,B*Q,G*Q,H*Q,C*Q,F*Q,Y*Q,Z*Q,D*Q,V*Q,k*Q,X*Q,U*Q,W*Q,j*Q,K*Q)},f.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],a=e[1],o=e[2],u=e[4],s=e[5],c=e[6],l=e[8],w=e[9],h=e[10],d=e[12],m=e[13],y=e[14],p=-t*d-a*m-o*y,v=-u*d-s*m-c*y,g=-l*d-w*m-h*y;return n(r)?(r[0]=t,r[1]=u,r[2]=l,r[3]=0,r[4]=a,r[5]=s,r[6]=w,r[7]=0,r[8]=o,r[9]=c,r[10]=h,r[11]=0,r[12]=p,r[13]=v,r[14]=g,r[15]=1,r):new f(t,a,o,p,u,s,c,v,l,w,h,g,0,0,0,1)},f.IDENTITY=a(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,r,t,n,i,a,o,u,s,f,c){"use strict";var l=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},w=new e,h=new e,d=new e,m=new e,y=new e,p=new e,v=new e,g=new e,b=new e,q=new e,x=new e,M=new e;l.fromPoints=function(r,t){if(n(t)||(t=new l),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],v),a=e.clone(i,w),o=e.clone(i,h),u=e.clone(i,d),s=e.clone(i,m),f=e.clone(i,y),c=e.clone(i,p),E=r.length,S=1;E>S;S++){e.clone(r[S],i);var T=i.x,z=i.y,O=i.z;T<a.x&&e.clone(i,a),T>s.x&&e.clone(i,s),z<o.y&&e.clone(i,o),z>f.y&&e.clone(i,f),O<u.z&&e.clone(i,u),O>c.z&&e.clone(i,c)}var N=e.magnitudeSquared(e.subtract(s,a,g)),A=e.magnitudeSquared(e.subtract(f,o,g)),I=e.magnitudeSquared(e.subtract(c,u,g)),R=a,P=s,_=N;A>_&&(_=A,R=o,P=f),I>_&&(_=I,R=u,P=c);var L=b;L.x=.5*(R.x+P.x),L.y=.5*(R.y+P.y),L.z=.5*(R.z+P.z);var C=e.magnitudeSquared(e.subtract(P,L,g)),D=Math.sqrt(C),U=q;U.x=a.x,U.y=o.y,U.z=u.z;var B=x;B.x=s.x,B.y=f.y,B.z=c.z;var F=e.multiplyByScalar(e.add(U,B,g),.5,M),V=0;for(S=0;E>S;S++){e.clone(r[S],i);var W=e.magnitude(e.subtract(i,F,g));W>V&&(V=W);var G=e.magnitudeSquared(e.subtract(i,L,g));if(G>C){var Y=Math.sqrt(G);D=.5*(D+Y),C=D*D;var k=Y-D;L.x=(D*L.x+k*i.x)/Y,L.y=(D*L.y+k*i.y)/Y,L.z=(D*L.z+k*i.z)/Y}}return V>D?(e.clone(L,t.center),t.radius=D):(e.clone(F,t.center),t.radius=V),t};var E=new o,S=new e,T=new e,z=new r,O=new r;l.fromRectangle2D=function(e,r,t){return l.fromRectangleWithHeights2D(e,r,0,0,t)},l.fromRectangleWithHeights2D=function(r,i,a,o,u){if(n(u)||(u=new l),!n(r))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=t(i,E),c.getSouthwest(r,z),z.height=a,c.getNortheast(r,O),O.height=o;var s=i.project(z,S),f=i.project(O,T),w=f.x-s.x,h=f.y-s.y,d=f.z-s.z;u.radius=.5*Math.sqrt(w*w+h*h+d*d);var m=u.center;return m.x=s.x+.5*w,m.y=s.y+.5*h,m.z=s.z+.5*d,u};var N=[];l.fromRectangle3D=function(e,r,i,o){r=t(r,a.WGS84),i=t(i,0);var u;return n(e)&&(u=c.subsample(e,r,i,N)),l.fromPoints(u,o)},l.fromVertices=function(r,a,o,u){if(n(u)||(u=new l),!n(r)||0===r.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;if(a=t(a,e.ZERO),o=t(o,3),3>o)throw new i("stride must be 3 or greater.");var s=v;s.x=r[0]+a.x,s.y=r[1]+a.y,s.z=r[2]+a.z;for(var f=e.clone(s,w),c=e.clone(s,h),E=e.clone(s,d),S=e.clone(s,m),T=e.clone(s,y),z=e.clone(s,p),O=r.length,N=0;O>N;N+=o){var A=r[N]+a.x,I=r[N+1]+a.y,R=r[N+2]+a.z;s.x=A,s.y=I,s.z=R,A<f.x&&e.clone(s,f),A>S.x&&e.clone(s,S),I<c.y&&e.clone(s,c),I>T.y&&e.clone(s,T),R<E.z&&e.clone(s,E),R>z.z&&e.clone(s,z)}var P=e.magnitudeSquared(e.subtract(S,f,g)),_=e.magnitudeSquared(e.subtract(T,c,g)),L=e.magnitudeSquared(e.subtract(z,E,g)),C=f,D=S,U=P;_>U&&(U=_,C=c,D=T),L>U&&(U=L,C=E,D=z);var B=b;B.x=.5*(C.x+D.x),B.y=.5*(C.y+D.y),B.z=.5*(C.z+D.z);var F=e.magnitudeSquared(e.subtract(D,B,g)),V=Math.sqrt(F),W=q;W.x=f.x,W.y=c.y,W.z=E.z;var G=x;G.x=S.x,G.y=T.y,G.z=z.z;var Y=e.multiplyByScalar(e.add(W,G,g),.5,M),k=0;for(N=0;O>N;N+=o){s.x=r[N]+a.x,s.y=r[N+1]+a.y,s.z=r[N+2]+a.z;var j=e.magnitude(e.subtract(s,Y,g));j>k&&(k=j);var H=e.magnitudeSquared(e.subtract(s,B,g));if(H>F){var Z=Math.sqrt(H);V=.5*(V+Z),F=V*V;var X=Z-V;B.x=(V*B.x+X*s.x)/Z,B.y=(V*B.y+X*s.y)/Z,B.z=(V*B.z+X*s.z)/Z}}return k>V?(e.clone(B,u.center),u.radius=V):(e.clone(Y,u.center),u.radius=k),u},l.fromCornerPoints=function(r,t,a){if(!n(r)||!n(t))throw new i("corner and oppositeCorner are required.");n(a)||(a=new l);var o=a.center;return e.add(r,t,o),e.multiplyByScalar(o,.5,o),a.radius=e.distance(o,t),a},l.fromEllipsoid=function(r,t){if(!n(r))throw new i("ellipsoid is required.");return n(t)||(t=new l),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t},l.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new l(r.center,r.radius):void 0},l.packedLength=4,l.pack=function(e,r,a){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");a=t(a,0);var o=e.center;r[a++]=o.x,r[a++]=o.y,r[a++]=o.z,r[a]=e.radius},l.unpack=function(e,r,a){if(!n(e))throw new i("array is required");r=t(r,0),n(a)||(a=new l);var o=a.center;return o.x=e[r++],o.y=e[r++],o.z=e[r++],a.radius=e[r],a};var A=new e,I=new e;l.union=function(r,t,a){if(!n(r))throw new i("left is required.");if(!n(t))throw new i("right is required.");n(a)||(a=new l);var o=r.center,u=t.center;e.add(o,u,I);var s=e.multiplyByScalar(I,.5,I),f=e.magnitude(e.subtract(o,s,A))+r.radius,c=e.magnitude(e.subtract(u,s,A))+t.radius;return a.radius=Math.max(f,c),e.clone(s,a.center),a};var R=new e;l.expand=function(r,t,a){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("point is required.");a=l.clone(r,a);var o=e.magnitude(e.subtract(t,a.center,R));return o>a.radius&&(a.radius=o),a},l.intersect=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("plane is required.");var a=r.center,o=r.radius,s=e.dot(t,a)+t.w;return-o>s?u.OUTSIDE:o>s?u.INTERSECTING:u.INSIDE},l.transform=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new l),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=f.getMaximumScale(r)*e.radius,t};var P=new e;l.distanceSquaredTo=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("cartesian is required.");var a=e.subtract(r.center,t,P);return e.magnitudeSquared(a)-r.radius*r.radius},l.transformWithoutScale=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new l),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var _=new e;l.getPlaneDistances=function(r,t,a,o){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("position is required.");if(!n(a))throw new i("direction is required.");n(o)||(o=new s);var u=e.subtract(r.center,t,_),f=e.multiplyByScalar(a,e.dot(a,u),_),c=e.magnitude(f);return o.start=c-r.radius,o.stop=c+r.radius,o};for(var L=new e,C=new e,D=new e,U=new e,B=new e,F=new r,V=new Array(8),W=0;8>W;++W)V[W]=new e;var G=new o;return l.projectTo2D=function(r,a,o){if(!n(r))throw new i("sphere is required.");a=t(a,G);var u=a.ellipsoid,s=r.center,f=r.radius,c=u.geodeticSurfaceNormal(s,L),w=e.cross(e.UNIT_Z,c,C);e.normalize(w,w);var h=e.cross(c,w,D);e.normalize(h,h),e.multiplyByScalar(c,f,c),e.multiplyByScalar(h,f,h),e.multiplyByScalar(w,f,w);var d=e.negate(h,B),m=e.negate(w,U),y=V,p=y[0];e.add(c,h,p),e.add(p,w,p),p=y[1],e.add(c,h,p),e.add(p,m,p),p=y[2],e.add(c,d,p),e.add(p,m,p),p=y[3],e.add(c,d,p),e.add(p,w,p),e.negate(c,c),p=y[4],e.add(c,h,p),e.add(p,w,p),p=y[5],e.add(c,h,p),e.add(p,m,p),p=y[6],e.add(c,d,p),e.add(p,m,p),p=y[7],e.add(c,d,p),e.add(p,w,p);for(var v=y.length,g=0;v>g;++g){var b=y[g];e.add(s,b,b);var q=u.cartesianToCartographic(b,F);a.project(q,b)}o=l.fromPoints(y,o),s=o.center;var x=s.x,M=s.y,E=s.z;return s.x=E,s.y=x,s.z=M,o},l.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius
},l.prototype.intersect=function(e){return l.intersect(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.clone=function(e){return l.clone(this,e)},l}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t){this.x=e(r,0),this.y=e(t,0)};a.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new a(e,t)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a]=n.y},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i],o},a.fromArray=a.unpack,a.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y)},a.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y)},a.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i},a.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n};var u=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,u),o=a.multiplyByScalar(e,1-i,o),a.add(u,o,o)};var s=new a,f=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return a.normalize(e,s),a.normalize(n,f),i.acosClamped(a.dot(s,f))};var c=new a;return a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,c);return a.abs(i,i),n=i.x<=i.y?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Y,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i},a.ZERO=n(new a(0,0)),a.UNIT_X=n(new a(1,0)),a.UNIT_Y=n(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;u>o;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=s+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=s+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=s+"fullscreenchange",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(w)){var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null===e?w=!1:(w=!0,h=n(e[1]))}return w}function a(){return i()&&h}function o(){if(!r(d))if(i()||!/ Safari\/[\.0-9]+/.test(navigator.userAgent))d=!1;else{var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null===e?d=!1:(d=!0,m=n(e[1]))}return d}function u(){return o()&&m}function s(){if(!r(y)){var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null===e?y=!1:(y=!0,p=n(e[1]),p.isNightly=!!e[2])}return y}function f(){return s()&&p}function c(){if(!r(v)){var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(v=!0,g=n(e[1]))):"Netscape"===navigator.appName?(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(v=!0,g=n(e[1]))):v=!1}return v}function l(){return c()&&g}var w,h,d,m,y,p,v,g,b={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:f,isInternetExplorer:c,internetExplorerVersion:l,hardwareConcurrency:e(navigator.hardwareConcurrency,3)};return b.supportsFullscreen=function(){return t.supportsFullscreen()},b.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},b}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection"],function(e,r,t,n){"use strict";if(!n.supportsTypedArrays())return{};var i={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return i.getSizeInBytes=function(e){if(!r(e))throw new t("value is required.");switch(e){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new t("componentDatatype is not a valid value.")}},i.fromTypedArray=function(e){return e instanceof Int8Array?i.BYTE:e instanceof Uint8Array?i.UNSIGNED_BYTE:e instanceof Int16Array?i.SHORT:e instanceof Uint16Array?i.UNSIGNED_SHORT:e instanceof Float32Array?i.FLOAT:e instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(e){return r(e)&&(e===i.BYTE||e===i.UNSIGNED_BYTE||e===i.SHORT||e===i.UNSIGNED_SHORT||e===i.FLOAT||e===i.DOUBLE)},i.createTypedArray=function(e,n){if(!r(e))throw new t("componentDatatype is required.");if(!r(n))throw new t("valuesOrLength is required.");switch(e){case i.BYTE:return new Int8Array(n);case i.UNSIGNED_BYTE:return new Uint8Array(n);case i.SHORT:return new Int16Array(n);case i.UNSIGNED_SHORT:return new Uint16Array(n);case i.FLOAT:return new Float32Array(n);case i.DOUBLE:return new Float64Array(n);default:throw new t("componentDatatype is not a valid value.")}},i.createArrayBufferView=function(n,a,o,u){if(!r(n))throw new t("componentDatatype is required.");if(!r(a))throw new t("buffer is required.");switch(o=e(o,0),u=e(u,(a.byteLength-o)/i.getSizeInBytes(n)),n){case i.BYTE:return new Int8Array(a,o,u);case i.UNSIGNED_BYTE:return new Uint8Array(a,o,u);case i.SHORT:return new Int16Array(a,o,u);case i.UNSIGNED_SHORT:return new Uint16Array(a,o,u);case i.FLOAT:return new Float32Array(a,o,u);case i.DOUBLE:return new Float64Array(a,o,u);default:throw new t("componentDatatype is not a valid value.")}},i}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.attributes))throw new t("options.attributes is required.");if(!r(n.primitiveType))throw new t("options.primitiveType is required.");this.attributes=n.attributes,this.indices=n.indices,this.primitiveType=n.primitiveType,this.boundingSphere=n.boundingSphere};return n.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&r(e.attributes[i])&&r(e.attributes[i].values)){var a=e.attributes[i],o=a.values.length/a.componentsPerAttribute;if(n!==o&&-1!==n)throw new t("All attribute lists must have the same number of attributes.");n=o}return n},n}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(n.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(n.values))throw new t("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,r,t,n){"use strict";var i=function(i){if(i=e(i,e.EMPTY_OBJECT),!r(i.geometry))throw new t("options.geometry is required.");this.geometry=i.geometry,this.modelMatrix=n.clone(e(i.modelMatrix,n.IDENTITY)),this.id=i.id,this.pickPrimitive=i.pickPrimitive,this.attributes=e(i.attributes,{})};return i}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=new r,a=new r,o=new r,u=function(u,s,f,c,l){if(!(t(u)&&t(s)&&t(f)&&t(c)))throw new n("point, p0, p1, and p2 are required.");t(l)||(l=new r);var w,h,d,m,y,p,v,g;t(s.z)?(w=r.subtract(f,s,i),h=r.subtract(c,s,a),d=r.subtract(u,s,o),m=r.dot(w,w),y=r.dot(w,h),p=r.dot(w,d),v=r.dot(h,h),g=r.dot(h,d)):(w=e.subtract(f,s,i),h=e.subtract(c,s,a),d=e.subtract(u,s,o),m=e.dot(w,w),y=e.dot(w,h),p=e.dot(w,d),v=e.dot(h,h),g=e.dot(h,d));var b=1/(m*v-y*y);return l.y=(v*p-y*g)*b,l.z=(m*g-y*p)*b,l.x=1-l.y-l.z,l};return u}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};n.encode=function(e,n){if(!r(e))throw new t("value is required");r(n)||(n={high:0,low:0});var i;return e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,a){if(!r(e))throw new t("cartesian is required");r(a)||(a=new n);var o=a.high,u=a.low;return n.encode(e.x,i),o.x=i.high,u.x=i.low,n.encode(e.y,i),o.y=i.high,u.y=i.low,n.encode(e.z,i),o.z=i.high,u.z=i.low,a};var a=new n;return n.writeElements=function(e,i,o){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("cartesianArray is required");if("number"!=typeof o||0>o)throw new t("index must be a number greater than or equal to 0.");n.fromCartesian(e,a);var u=a.high,s=a.low;i[o]=u.x,i[o+1]=u.y,i[o+2]=u.z,i[o+3]=s.x,i[o+4]=s.y,i[o+5]=s.z},n}),define("Core/IndexDatatype",["./defined","./DeveloperError","./Math"],function(e,r,t){"use strict";var n={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return n.getSizeInBytes=function(e){switch(e){case n.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case n.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case n.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new r("indexDatatype is required and must be a valid IndexDatatype constant.")},n.validate=function(r){return e(r)&&(r===n.UNSIGNED_BYTE||r===n.UNSIGNED_SHORT||r===n.UNSIGNED_INT)},n.createTypedArray=function(n,i){if(!e(n))throw new r("numberOfVertices is required.");return n>t.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},n}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,r){"use strict";function t(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}var n={};return n.discriminant=function(r,t,n){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=t*t-4*r*n;return i},n.realRoots=function(n,i,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");var o;if(0===n)return 0===i?[]:[-a/i];if(0===i){if(0===a)return[0,0];var u=Math.abs(a),s=Math.abs(n);if(s>u&&u/s<r.EPSILON14)return[0,0];if(u>s&&s/u<r.EPSILON14)return[];if(o=-a/n,0>o)return[];var f=Math.sqrt(o);return[-f,f]}if(0===a)return o=-i/n,0>o?[o,0]:[0,o];var c=i*i,l=4*n*a,w=t(c,-l,r.EPSILON14);if(0>w)return[];var h=-.5*t(i,r.sign(i)*Math.sqrt(w),r.EPSILON14);return i>0?[h/n,a/h]:[a/h,h/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,r){"use strict";function t(e,r,t,n){var i,a,o=e,u=r/3,s=t/3,f=n,c=o*s,l=u*f,w=u*u,h=s*s,d=o*s-w,m=o*f-u*s,y=u*f-h,p=4*d*y-m*m;if(0>p){var v,g,b;w*l>=c*h?(v=o,g=d,b=-2*u*d+o*m):(v=f,g=y,b=-f*m+2*s*y);var q=0>b?-1:1,x=-q*Math.abs(v)*Math.sqrt(-p);a=-b+x;var M=a/2,E=0>M?-Math.pow(-M,1/3):Math.pow(M,1/3),S=a===x?-E:-g/E;return i=0>=g?E+S:-b/(E*E+S*S+g),w*l>=c*h?[(i-u)/o]:[-f/(i+s)]}var T=d,z=-2*u*d+o*m,O=y,N=-f*m+2*s*y,A=Math.sqrt(p),I=Math.sqrt(3)/2,R=Math.abs(Math.atan2(o*A,-z)/3);i=2*Math.sqrt(-T);var P=Math.cos(R);a=i*P;var _=i*(-P/2-I*Math.sin(R)),L=a+_>2*u?a-u:_-u,C=o,D=L/C;R=Math.abs(Math.atan2(f*A,-N)/3),i=2*Math.sqrt(-O),P=Math.cos(R),a=i*P,_=i*(-P/2-I*Math.sin(R));var U=-f,B=2*s>a+_?a+s:_+s,F=U/B,V=C*B,W=-L*B-C*U,G=L*U,Y=(s*W-u*G)/(-u*W+s*V);return Y>=D?F>=D?F>=Y?[D,Y,F]:[D,F,Y]:[F,D,Y]:F>=D?[Y,D,F]:F>=Y?[Y,F,D]:[F,Y,D]}var n={};return n.discriminant=function(r,t,n,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var a=r*r,o=t*t,u=n*n,s=i*i,f=18*r*t*n*i+o*u-27*a*s-4*(r*u*n+o*t*i);return f},n.realRoots=function(n,i,a,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var u,s;if(0===n)return r.realRoots(i,a,o);if(0===i){if(0===a){if(0===o)return[0,0,0];s=-o/n;var f=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[f,f,f]}return 0===o?(u=r.realRoots(n,0,a),0===u.Length?[0]:[u[0],0,u[1]]):t(n,0,a,o)}return 0===a?0===o?(s=-i/n,0>s?[s,0,0]:[0,0,s]):t(n,i,0,o):0===o?(u=r.realRoots(n,i,a),0===u.length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]):t(n,i,a,o)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,r,t,n){"use strict";function i(r,i,a,o){var u=r*r,s=i-3*u/8,f=a-i*r/2+u*r/8,c=o-a*r/4+i*u/16-3*u*u/256,l=e.realRoots(1,2*s,s*s-4*c,-f*f);if(l.length>0){var w=-r/4,h=l[l.length-1];if(Math.abs(h)<t.EPSILON14){var d=n.realRoots(1,s,c);if(2===d.length){var m,y=d[0],p=d[1];if(y>=0&&p>=0){var v=Math.sqrt(y),g=Math.sqrt(p);return[w-g,w-v,w+v,w+g]}if(y>=0&&0>p)return m=Math.sqrt(y),[w-m,w+m];if(0>y&&p>=0)return m=Math.sqrt(p),[w-m,w+m]}return[]}if(h>0){var b=Math.sqrt(h),q=(s+h-f/b)/2,x=(s+h+f/b)/2,M=n.realRoots(1,b,q),E=n.realRoots(1,-b,x);return 0!==M.length?(M[0]+=w,M[1]+=w,0!==E.length?(E[0]+=w,E[1]+=w,M[1]<=E[0]?[M[0],M[1],E[0],E[1]]:E[1]<=M[0]?[E[0],E[1],M[0],M[1]]:M[0]>=E[0]&&M[1]<=E[1]?[E[0],M[0],M[1],E[1]]:E[0]>=M[0]&&E[1]<=M[1]?[M[0],E[0],E[1],M[1]]:M[0]>E[0]&&M[0]<E[1]?[E[0],M[0],E[1],M[1]]:[M[0],E[0],M[1],E[1]]):M):0!==E.length?(E[0]+=w,E[1]+=w,E):[]}}return[]}function a(r,i,a,o){var u=a*a,s=i*i,f=r*r,c=-2*i,l=a*r+s-4*o,w=f*o-a*i*r+u,h=e.realRoots(1,c,l,w);if(h.length>0){var d,m,y=h[0],p=i-y,v=p*p,g=r/2,b=p/2,q=v-4*o,x=v+4*Math.abs(o),M=f-4*y,E=f+4*Math.abs(y);if(0>y||M*x>q*E){var S=Math.sqrt(M);d=S/2,m=0===S?0:(r*b-a)/S}else{var T=Math.sqrt(q);d=0===T?0:(r*b-a)/T,m=T/2}var z,O;0===g&&0===d?(z=0,O=0):t.sign(g)===t.sign(d)?(z=g+d,O=y/z):(O=g-d,z=y/O);var N,A;0===b&&0===m?(N=0,A=0):t.sign(b)===t.sign(m)?(N=b+m,A=o/N):(A=b-m,N=o/A);var I=n.realRoots(1,z,N),R=n.realRoots(1,O,A);if(0!==I.length)return 0!==R.length?I[1]<=R[0]?[I[0],I[1],R[0],R[1]]:R[1]<=I[0]?[R[0],R[1],I[0],I[1]]:I[0]>=R[0]&&I[1]<=R[1]?[R[0],I[0],I[1],R[1]]:R[0]>=I[0]&&R[1]<=I[1]?[I[0],R[0],R[1],I[1]]:I[0]>R[0]&&I[0]<R[1]?[R[0],I[0],R[1],I[1]]:[I[0],R[0],I[1],R[1]]:I;if(0!==R.length)return R}return[]}var o={};return o.discriminant=function(e,t,n,i,a){if("number"!=typeof e)throw new r("a is a required number.");if("number"!=typeof t)throw new r("b is a required number.");if("number"!=typeof n)throw new r("c is a required number.");if("number"!=typeof i)throw new r("d is a required number.");if("number"!=typeof a)throw new r("e is a required number.");var o=e*e,u=o*e,s=t*t,f=s*t,c=n*n,l=c*n,w=i*i,h=w*i,d=a*a,m=d*a,y=s*c*w-4*f*h-4*e*l*w+18*e*t*n*h-27*o*w*w+256*u*m+a*(18*f*n*i-4*s*l+16*e*c*c-80*e*t*c*i-6*e*s*w+144*o*n*w)+d*(144*e*s*n-27*s*s-128*o*c-192*o*t*i);return y},o.realRoots=function(n,o,u,s,f){if("number"!=typeof n)throw new r("a is a required number.");if("number"!=typeof o)throw new r("b is a required number.");if("number"!=typeof u)throw new r("c is a required number.");if("number"!=typeof s)throw new r("d is a required number.");if("number"!=typeof f)throw new r("e is a required number.");if(Math.abs(n)<t.EPSILON15)return e.realRoots(o,u,s,f);var c=o/n,l=u/n,w=s/n,h=f/n,d=0>c?1:0;switch(d+=0>l?d+1:d,d+=0>w?d+1:d,d+=0>h?d+1:d){case 0:return i(c,l,w,h);case 1:return a(c,l,w,h);case 2:return a(c,l,w,h);case 3:return i(c,l,w,h);case 4:return i(c,l,w,h);case 5:return a(c,l,w,h);case 6:return i(c,l,w,h);case 7:return i(c,l,w,h);case 8:return a(c,l,w,h);case 9:return i(c,l,w,h);case 10:return i(c,l,w,h);case 11:return a(c,l,w,h);case 12:return i(c,l,w,h);case 13:return i(c,l,w,h);case 14:return i(c,l,w,h);case 15:return i(c,l,w,h);default:return void 0}},o}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial"],function(e,r,t,n,i,a,o,u){"use strict";function s(e,r,t){var n=e+r;return i.sign(e)!==i.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<t?0:n}function f(r,t,n,f,c){var l,w=f*f,h=c*c,d=(r[a.COLUMN1ROW1]-r[a.COLUMN2ROW2])*h,m=c*(f*s(r[a.COLUMN1ROW0],r[a.COLUMN0ROW1],i.EPSILON15)+t.y),y=r[a.COLUMN0ROW0]*w+r[a.COLUMN2ROW2]*h+f*t.x+n,p=h*s(r[a.COLUMN2ROW1],r[a.COLUMN1ROW2],i.EPSILON15),v=c*(f*s(r[a.COLUMN2ROW0],r[a.COLUMN0ROW2])+t.z),g=[];if(0===v&&0===p){if(l=o.realRoots(d,m,y),0===l.length)return g;var b=l[0],q=Math.sqrt(Math.max(1-b*b,0));if(g.push(new e(f,c*b,c*-q)),g.push(new e(f,c*b,c*q)),2===l.length){var x=l[1],M=Math.sqrt(Math.max(1-x*x,0));g.push(new e(f,c*x,c*-M)),g.push(new e(f,c*x,c*M))}return g}var E=v*v,S=p*p,T=d*d,z=v*p,O=T+S,N=2*(m*d+z),A=2*y*d+m*m-S+E,I=2*(y*m-z),R=y*y-E;if(0===O&&0===N&&0===A&&0===I)return g;l=u.realRoots(O,N,A,I,R);var P=l.length;if(0===P)return g;for(var _=0;P>_;++_){var L,C=l[_],D=C*C,U=Math.max(1-D,0),B=Math.sqrt(U);L=i.sign(d)===i.sign(y)?s(d*D+y,m*C,i.EPSILON12):i.sign(y)===i.sign(m*C)?s(d*D,m*C+y,i.EPSILON12):s(d*D+m*C,y,i.EPSILON12);var F=s(p*C,v,i.EPSILON15),V=L*F;0>V?g.push(new e(f,c*C,c*B)):V>0?g.push(new e(f,c*C,c*-B)):0!==B?(g.push(new e(f,c*C,c*-B)),g.push(new e(f,c*C,c*B)),++_):g.push(new e(f,c*C,c*B))}return g}var c={};c.rayPlane=function(r,a,o){if(!t(r))throw new n("ray is required.");if(!t(a))throw new n("plane is required.");t(o)||(o=new e);var u=r.origin,s=r.direction,f=a.normal,c=e.dot(f,s);if(Math.abs(c)<i.EPSILON15)return void 0;var l=(-a.distance-e.dot(f,u))/c;return 0>l?void 0:(o=e.multiplyByScalar(s,l,o),e.add(u,o,o))};var l=new e,w=new e;c.rayEllipsoid=function(r,i){if(!t(r))throw new n("ray is required.");if(!t(i))throw new n("ellipsoid is required.");var a,o,u,s,f,c=i.oneOverRadii,h=e.multiplyComponents(c,r.origin,l),d=e.multiplyComponents(c,r.direction,w),m=e.magnitudeSquared(h),y=e.dot(h,d);if(m>1){if(y>=0)return void 0;var p=y*y;if(a=m-1,o=e.magnitudeSquared(d),u=o*a,u>p)return void 0;if(p>u){s=y*y-u,f=-y+Math.sqrt(s);var v=f/o,g=a/f;return g>v?{start:v,stop:g}:{start:g,stop:v}}var b=Math.sqrt(a/o);return{start:b,stop:b}}return 1>m?(a=m-1,o=e.magnitudeSquared(d),u=o*a,s=y*y-u,f=-y+Math.sqrt(s),{start:0,stop:f/o}):0>y?(o=e.magnitudeSquared(d),{start:0,stop:-y/o}):void 0};var h=new e,d=new e,m=new e,y=new e;c.grazingAltitudeLocation=function(o,u){if(!t(o))throw new n("ray is required.");if(!t(u))throw new n("ellipsoid is required.");var s=o.origin,c=o.direction,l=u.geodeticSurfaceNormal(s);if(e.dot(c,l)>=0)return s;var w,p,v=t(this.rayEllipsoid(o,u)),g=u.transformPositionToScaledSpace(c),b=e.normalize(g,h),q=e.mostOrthogonalAxis(g,y),x=e.normalize(e.cross(q,b,d),d),M=e.normalize(e.cross(b,x,m),m),E=new a(b.x,x.x,M.x,b.y,x.y,M.y,b.z,x.z,M.z),S=a.transpose(E),T=a.fromScale(u.radii),z=a.fromScale(u.oneOverRadii),O=new a(0,c.z,-c.y,-c.z,0,c.x,c.y,-c.x,0),N=a.multiply(a.multiply(S,z),O),A=a.multiply(a.multiply(N,T),E),I=a.multiplyByVector(N,s),R=f(A,e.negate(I,h),0,0,1),P=R.length;if(P>0){for(var _=e.ZERO,L=Number.NEGATIVE_INFINITY,C=0;P>C;++C){w=a.multiplyByVector(T,a.multiplyByVector(E,R[C]));var D=e.normalize(e.subtract(w,s,y),y),U=e.dot(D,c);U>L&&(L=U,_=w)}var B=u.cartesianToCartographic(_);return L=i.clamp(L,0,1),p=e.magnitude(e.subtract(_,s,y))*Math.sqrt(1-L*L),p=v?-p:p,u.cartographicToCartesian(new r(B.longitude,B.latitude,p))}return void 0};var p=new e;return c.lineSegmentPlane=function(r,a,o,u){if(!t(r))throw new n("endPoint0 is required.");if(!t(a))throw new n("endPoint1 is required.");if(!t(o))throw new n("plane is required.");t(u)||(u=new e);var s=e.subtract(a,r,p),f=o.normal,c=e.dot(f,s);if(Math.abs(c)<i.EPSILON6)return void 0;var l=e.dot(f,r),w=-(o.distance+l)/c;return 0>w||w>1?void 0:(e.multiplyByScalar(s,w,u),e.add(r,u,u),u)},c.trianglePlaneIntersection=function(r,i,a,o){if(!(t(r)&&t(i)&&t(a)&&t(o)))throw new n("p0, p1, p2, and plane are required.");var u=o.normal,s=o.distance,f=e.dot(u,r)+s<0,l=e.dot(u,i)+s<0,w=e.dot(u,a)+s<0,h=0;h+=f?1:0,h+=l?1:0,h+=w?1:0;var d,m;if((1===h||2===h)&&(d=new e,m=new e),1===h){if(f)return c.lineSegmentPlane(r,i,o,d),c.lineSegmentPlane(r,a,o,m),{positions:[r,i,a,d,m],indices:[0,3,4,1,2,4,1,4,3]};if(l)return c.lineSegmentPlane(i,a,o,d),c.lineSegmentPlane(i,r,o,m),{positions:[r,i,a,d,m],indices:[1,3,4,2,0,4,2,4,3]};if(w)return c.lineSegmentPlane(a,r,o,d),c.lineSegmentPlane(a,i,o,m),{positions:[r,i,a,d,m],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===h){if(!f)return c.lineSegmentPlane(i,r,o,d),c.lineSegmentPlane(a,r,o,m),{positions:[r,i,a,d,m],indices:[1,2,4,1,4,3,0,3,4]};if(!l)return c.lineSegmentPlane(a,i,o,d),c.lineSegmentPlane(r,i,o,m),{positions:[r,i,a,d,m],indices:[2,0,4,2,4,3,1,3,4]};if(!w)return c.lineSegmentPlane(r,a,o,d),c.lineSegmentPlane(i,a,o,m),{positions:[r,i,a,d,m],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},c}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n,i){if(!r(n))throw new t("normal is required.");if(!r(i))throw new t("distance is required.");this.normal=e.clone(n),this.distance=i};return n.fromPointNormal=function(i,a,o){if(!r(i))throw new t("point is required.");if(!r(a))throw new t("normal is required.");var u=-e.dot(a,i);return r(o)?(e.clone(a,o.normal),o.distance=u,o):new n(a,u)},n.getPointDistance=function(n,i){if(!r(n))throw new t("plane is required.");if(!r(i))throw new t("point is required.");return e.dot(n.normal,i)+n.distance},n}),define("Core/PrimitiveType",[],function(){"use strict";var e={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(r){return r===e.POINTS||r===e.LINES||r===e.LINE_LOOP||r===e.LINE_STRIP||r===e.TRIANGLES||r===e.TRIANGLE_STRIP||r===e.TRIANGLE_FAN}};return e}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n={};return n.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var i=n.indices,a=n.maximumIndex,o=e(n.cacheSize,24);if(!r(i))throw new t("indices is required.");var u=i.length;if(3>u||0!==u%3)throw new t("indices length must be a multiple of three.");if(0>=a)throw new t("maximumIndex must be greater than zero.");if(3>o)throw new t("cacheSize must be greater than two.");if(!r(a)){a=0;for(var s=0,f=i[s];u>s;)f>a&&(a=f),++s,f=i[s]}for(var c=[],l=0;a+1>l;l++)c[l]=0;for(var w=o+1,h=0;u>h;++h)w-c[i[h]]>o&&(c[i[h]]=w,++w);return(w-o+1)/(u/3)},n.tipsify=function(n){function i(e,r,t,n){for(;r.length>=1;){var i=r[r.length-1];if(r.splice(r.length-1,1),e[i].numLiveTriangles>0)return i}for(;n>o;){if(e[o].numLiveTriangles>0)return++o,o-1;++o}return-1}function a(e,r,t,n,a,o,u){for(var s,f=-1,c=-1,l=0;l<t.length;){var w=t[l];n[w].numLiveTriangles&&(s=0,a-n[w].timeStamp+2*n[w].numLiveTriangles<=r&&(s=a-n[w].timeStamp),(s>c||-1===c)&&(c=s,f=w)),++l}return-1===f?i(n,o,e,u):f}n=e(n,e.EMPTY_OBJECT);var o,u=n.indices,s=n.maximumIndex,f=e(n.cacheSize,24);if(!r(u))throw new t("indices is required.");var c=u.length;if(3>c||0!==c%3)throw new t("indices length must be a multiple of three.");if(0>=s)throw new t("maximumIndex must be greater than zero.");if(3>f)throw new t("cacheSize must be greater than two.");var l=0,w=0,h=u[w],d=c;if(r(s))l=s+1;else{for(;d>w;)h>l&&(l=h),++w,h=u[w];if(-1===l)return 0;++l}for(var m=[],y=0;l>y;y++)m[y]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};w=0;for(var p=0;d>w;)m[u[w]].vertexTriangles.push(p),++m[u[w]].numLiveTriangles,m[u[w+1]].vertexTriangles.push(p),++m[u[w+1]].numLiveTriangles,m[u[w+2]].vertexTriangles.push(p),++m[u[w+2]].numLiveTriangles,++p,w+=3;var v=0,g=f+1;o=1;var b,q,x=[],M=[],E=0,S=[],T=c/3,z=[];for(y=0;T>y;y++)z[y]=!1;for(var O,N;-1!==v;){x=[],q=m[v],N=q.vertexTriangles.length;for(var A=0;N>A;++A)if(p=q.vertexTriangles[A],!z[p]){z[p]=!0,w=p+p+p;for(var I=0;3>I;++I)O=u[w],x.push(O),M.push(O),S[E]=O,++E,b=m[O],--b.numLiveTriangles,g-b.timeStamp>f&&(b.timeStamp=g,++g),++w}v=a(u,f,x,m,g,M,l)}return S},n}),define("Core/GeometryPipeline",["./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,r,t,n,i,a,o,u,s,f,c,l,w,h,d,m,y,p,v,g,b,q,x){"use strict";function M(e,r,t,n,i){e[r++]=t,e[r++]=n,e[r++]=n,e[r++]=i,e[r++]=i,e[r]=t}function E(e){for(var r=e.length,t=6*(r/3),n=d.createTypedArray(r,t),i=0,a=0;r>a;a+=3,i+=6)M(n,i,e[a],e[a+1],e[a+2]);return n}function S(e){var r=e.length;if(r>=3){var t=6*(r-2),n=d.createTypedArray(r,t);M(n,0,e[0],e[1],e[2]);for(var i=6,a=3;r>a;++a,i+=6)M(n,i,e[a-1],e[a],e[a-2]);return n}return new Uint16Array}function T(e){if(e.length>0){for(var r=e.length-1,t=6*(r-1),n=d.createTypedArray(r,t),i=e[0],a=0,o=1;r>o;++o,a+=6)M(n,a,i,e[o],e[o+1]);return n}return new Uint16Array}function z(e){var r={};for(var t in e)if(e.hasOwnProperty(t)&&s(e[t])&&s(e[t].values)){var n=e[t];r[t]=new h({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return r}function O(e,r,t){for(var n in r)if(r.hasOwnProperty(n)&&s(r[n])&&s(r[n].values))for(var i=r[n],a=0;a<i.componentsPerAttribute;++a)e[n].values.push(i.values[t*i.componentsPerAttribute+a])}function N(e,r){if(s(r))for(var t=r.values,i=t.length,a=0;i>a;a+=3)n.unpack(t,a,X),g.multiplyByPoint(e,X,X),n.pack(X,t,a)}function A(e,r){if(s(r))for(var t=r.values,i=t.length,a=0;i>a;a+=3)n.unpack(t,a,X),v.multiplyByVector(e,X,X),X=n.normalize(X,X),n.pack(X,t,a)}function I(e){var r,t=e.length,n={},i=e[0].geometry.attributes;for(r in i)if(i.hasOwnProperty(r)&&s(i[r])&&s(i[r].values)){for(var a=i[r],u=a.values.length,f=!0,c=1;t>c;++c){var l=e[c].geometry.attributes[r];if(!s(l)||a.componentDatatype!==l.componentDatatype||a.componentsPerAttribute!==l.componentsPerAttribute||a.normalize!==l.normalize){f=!1;break}u+=l.values.length}f&&(n[r]=new h({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:o.createTypedArray(a.componentDatatype,u)}))}return n}function R(e){if(s(e.indices))return e;var r=w.computeNumberOfVertices(e);if(3>r)throw new f("The number of vertices must be at least three.");if(0!==r%3)throw new f("The number of vertices must be a multiple of three.");for(var t=d.createTypedArray(r,r),n=0;r>n;++n)t[n]=n;return e.indices=t,e}function P(e){var r=w.computeNumberOfVertices(e);if(3>r)throw new f("The number of vertices must be at least three.");
var t=d.createTypedArray(r,3*(r-2));t[0]=1,t[1]=0,t[2]=2;for(var n=3,i=3;r>i;++i)t[n++]=i-1,t[n++]=0,t[n++]=i;return e.indices=t,e.primitiveType=q.TRIANGLES,e}function _(e){var r=w.computeNumberOfVertices(e);if(3>r)throw new f("The number of vertices must be at least 3.");var t=d.createTypedArray(r,3*(r-2));t[0]=0,t[1]=1,t[2]=2,r>3&&(t[3]=0,t[4]=2,t[5]=3);for(var n=6,i=3;r-1>i;i+=2)t[n++]=i,t[n++]=i-1,t[n++]=i+1,r>i+2&&(t[n++]=i,t[n++]=i+1,t[n++]=i+2);return e.indices=t,e.primitiveType=q.TRIANGLES,e}function L(e){if(s(e.indices))return e;var r=w.computeNumberOfVertices(e);if(2>r)throw new f("The number of vertices must be at least two.");if(0!==r%2)throw new f("The number of vertices must be a multiple of 2.");for(var t=d.createTypedArray(r,r),n=0;r>n;++n)t[n]=n;return e.indices=t,e}function C(e){var r=w.computeNumberOfVertices(e);if(2>r)throw new f("The number of vertices must be at least two.");var t=d.createTypedArray(r,2*(r-1));t[0]=0,t[1]=1;for(var n=2,i=2;r>i;++i)t[n++]=i-1,t[n++]=i;return e.indices=t,e.primitiveType=q.LINES,e}function D(e){var r=w.computeNumberOfVertices(e);if(2>r)throw new f("The number of vertices must be at least two.");var t=d.createTypedArray(r,2*r);t[0]=0,t[1]=1;for(var n=2,i=2;r>i;++i)t[n++]=i-1,t[n++]=i;return t[n++]=r-1,t[n]=0,e.indices=t,e.primitiveType=q.LINES,e}function U(e){switch(e.primitiveType){case q.TRIANGLE_FAN:return P(e);case q.TRIANGLE_STRIP:return _(e);case q.TRIANGLES:return R(e);case q.LINE_STRIP:return C(e);case q.LINE_LOOP:return D(e);case q.LINES:return L(e)}return e}function B(e,r){Math.abs(e.y)<p.EPSILON11&&(e.y=r?-p.EPSILON11:p.EPSILON11)}function F(e,r,t,i){n.add(e,n.multiplyByScalar(n.subtract(r,e,or),e.y/(e.y-r.y),or),t),n.clone(t,i),B(t,!0),B(i,!1)}function V(e,r,t){if(e.x>=0||r.x>=0||t.x>=0)return void 0;var n=e.y<0,i=r.y<0,a=t.y<0;B(e,n),B(r,i),B(t,a);var o=0;o+=n?1:0,o+=i?1:0,o+=a?1:0;var u=lr.indices;1===o?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(F(e,r,ur,fr),F(e,t,sr,cr),u[0]=0,u[3]=1,u[4]=2,u[6]=1):i?(F(r,t,ur,fr),F(r,e,sr,cr),u[0]=1,u[3]=2,u[4]=0,u[6]=2):a&&(F(t,e,ur,fr),F(t,r,sr,cr),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===o&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?i?a||(F(t,e,ur,fr),F(t,r,sr,cr),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(F(r,t,ur,fr),F(r,e,sr,cr),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(F(e,r,ur,fr),F(e,t,sr,cr),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=lr.positions;return s[0]=e,s[1]=r,s[2]=t,lr.length=3,(1===o||2===o)&&(s[3]=ur,s[4]=sr,s[5]=fr,s[6]=cr,lr.length=7),lr}function W(r,i,a,o,u,f,c,l){if(s(u)||s(f)||s(c)||s(l)){var w,h,d,m,y,p,v,g,b,q,x,M,E=o.positions,S=E[0],T=E[1],z=E[2],O=mr,N=yr,A=pr,I=wr,R=hr,P=dr;s(u)&&(w=n.fromArray(u,3*r),h=n.fromArray(u,3*i),d=n.fromArray(u,3*a)),s(f)&&(m=n.fromArray(f,3*r),y=n.fromArray(f,3*i),p=n.fromArray(f,3*a)),s(c)&&(v=n.fromArray(c,3*r),g=n.fromArray(c,3*i),b=n.fromArray(c,3*a)),s(l)&&(q=t.fromArray(l,2*r),x=t.fromArray(l,2*i),M=t.fromArray(l,2*a));for(var _=3;_<E.length;++_){var L=E[_],C=e(L,S,T,z);if(s(u)){O=n.multiplyByScalar(w,C.x,O),N=n.multiplyByScalar(h,C.y,N),A=n.multiplyByScalar(d,C.z,A);var D=n.add(O,N,vr);n.add(D,A,D),n.normalize(D,D),u.push(D.x,D.y,D.z)}if(s(f)){O=n.multiplyByScalar(m,C.x,O),N=n.multiplyByScalar(y,C.y,N),A=n.multiplyByScalar(p,C.z,A);var U=n.add(O,N,vr);n.add(U,A,U),n.normalize(U,U),f.push(U.x,U.y,U.z)}if(s(c)){O=n.multiplyByScalar(v,C.x,O),N=n.multiplyByScalar(g,C.y,N),A=n.multiplyByScalar(b,C.z,A);var B=n.add(O,N,vr);n.add(B,A,B),n.normalize(B,B),c.push(B.x,B.y,B.z)}if(s(l)){I=t.multiplyByScalar(q,C.x,I),R=t.multiplyByScalar(x,C.y,R),P=t.multiplyByScalar(M,C.z,P);var F=t.add(I,R,I);t.add(F,P,F),l.push(F.x,F.y)}}}}function G(e){for(var r=e.attributes,t=r.position.values,i=s(r.normal)?r.normal.values:void 0,a=s(r.binormal)?r.binormal.values:void 0,u=s(r.tangent)?r.tangent.values:void 0,f=s(r.st)?r.st.values:void 0,c=e.indices,l=Array.prototype.slice.call(t,0),h=s(i)?Array.prototype.slice.call(i,0):void 0,m=s(a)?Array.prototype.slice.call(a,0):void 0,y=s(u)?Array.prototype.slice.call(u,0):void 0,p=s(f)?Array.prototype.slice.call(f,0):void 0,v=[],g=c.length,b=0;g>b;b+=3){var q=c[b],x=c[b+1],M=c[b+2],E=n.fromArray(t,3*q),S=n.fromArray(t,3*x),T=n.fromArray(t,3*M),z=V(E,S,T);if(s(z))if(l[3*q+1]=z.positions[0].y,l[3*x+1]=z.positions[1].y,l[3*M+1]=z.positions[2].y,z.length>3){for(var O=l.length/3,N=0;N<z.indices.length;++N){var A=z.indices[N];3>A?v.push(c[b+A]):v.push(A-3+O)}for(var I=3;I<z.positions.length;++I){var R=z.positions[I];l.push(R.x,R.y,R.z)}W(q,x,M,z,h,m,y,p)}else v.push(q,x,M);else v.push(q,x,M)}e.attributes.position.values=new Float64Array(l),s(h)&&(r.normal.values=o.createTypedArray(r.normal.componentDatatype,h)),s(m)&&(r.binormal.values=o.createTypedArray(r.binormal.componentDatatype,m)),s(y)&&(r.tangent.values=o.createTypedArray(r.tangent.componentDatatype,y)),s(p)&&(r.st.values=o.createTypedArray(r.st.componentDatatype,p));var P=w.computeNumberOfVertices(e);e.indices=d.createTypedArray(P,v)}function Y(e){for(var r=e.attributes,t=r.position.values,i=e.indices,a=Array.prototype.slice.call(t,0),o=[],u=b.fromPointNormal(n.ZERO,n.UNIT_Y),f=i.length,c=0;f>c;c+=2){var l=i[c],h=i[c+1],m=n.fromArray(t,3*l),v=n.fromArray(t,3*h);if(Math.abs(m.y)<p.EPSILON6&&(m.y=m.y<0?-p.EPSILON6:p.EPSILON6,a[3*l+1]=m.y),Math.abs(v.y)<p.EPSILON6&&(v.y=v.y<0?-p.EPSILON6:p.EPSILON6,a[3*h+1]=v.y),o.push(l),m.x<0||v.x<0){var g=y.lineSegmentPlane(m,v,u);if(s(g)){var q=n.multiplyByScalar(n.UNIT_Y,5*p.EPSILON9,gr);m.y<0&&n.negate(q,q);var x=a.length/3;o.push(x,x+1);var M=n.add(g,q,br);a.push(M.x,M.y,M.z),n.negate(q,q),n.add(g,q,M),a.push(M.x,M.y,M.z)}}o.push(h)}e.attributes.position.values=new Float64Array(a);var E=w.computeNumberOfVertices(e);e.indices=d.createTypedArray(E,o)}var k={};k.toWireframe=function(e){if(!s(e))throw new f("geometry is required.");var r=e.indices;if(s(r)){switch(e.primitiveType){case q.TRIANGLES:e.indices=E(r);break;case q.TRIANGLE_STRIP:e.indices=S(r);break;case q.TRIANGLE_FAN:e.indices=T(r);break;default:throw new f("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=q.LINES}return e},k.createLineSegmentsForVectors=function(e,t,n){if(t=u(t,"normal"),!s(e))throw new f("geometry is required.");if(!s(e.attributes.position))throw new f("geometry.attributes.position is required.");if(!s(e.attributes[t]))throw new f("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+t+".");n=u(n,1e4);for(var i=e.attributes.position.values,a=e.attributes[t].values,c=i.length,l=new Float64Array(2*c),d=0,m=0;c>m;m+=3)l[d++]=i[m],l[d++]=i[m+1],l[d++]=i[m+2],l[d++]=i[m]+a[m]*n,l[d++]=i[m+1]+a[m+1]*n,l[d++]=i[m+2]+a[m+2]*n;var y,p=e.boundingSphere;return s(p)&&(y=new r(p.center,p.radius+n)),new w({attributes:{position:new h({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:q.LINES,boundingSphere:y})},k.createAttributeLocations=function(e){if(!s(e))throw new f("geometry is required.");var r,t=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent"],n=e.attributes,i={},a=0,o=t.length;for(r=0;o>r;++r){var u=t[r];s(n[u])&&(i[u]=a++)}for(var c in n)n.hasOwnProperty(c)&&!s(i[c])&&(i[c]=a++);return i},k.reorderForPreVertexCache=function(e){if(!s(e))throw new f("geometry is required.");var r=w.computeNumberOfVertices(e),t=e.indices;if(s(t)){for(var n=new Int32Array(r),i=0;r>i;i++)n[i]=-1;for(var a,u=t,c=u.length,l=d.createTypedArray(r,c),h=0,m=0,y=0;c>h;)a=n[u[h]],-1!==a?l[m]=a:(a=u[h],n[a]=y,l[m]=y,++y),++h,++m;e.indices=l;var p=e.attributes;for(var v in p)if(p.hasOwnProperty(v)&&s(p[v])&&s(p[v].values)){for(var g=p[v],b=g.values,q=0,x=g.componentsPerAttribute,M=o.createTypedArray(g.componentDatatype,y*x);r>q;){var E=n[q];if(-1!==E)for(i=0;x>i;i++)M[x*E+i]=b[x*q+i];++q}g.values=M}}return e},k.reorderForPostVertexCache=function(e,r){if(!s(e))throw new f("geometry is required.");var t=e.indices;if(e.primitiveType===q.TRIANGLES&&s(t)){for(var n=t.length,i=0,a=0;n>a;a++)t[a]>i&&(i=t[a]);e.indices=x.tipsify({indices:t,maximumIndex:i,cacheSize:r})}return e},k.fitToUnsignedShortIndices=function(e){if(!s(e))throw new f("geometry is required.");if(s(e.indices)&&e.primitiveType!==q.TRIANGLES&&e.primitiveType!==q.LINES&&e.primitiveType!==q.POINTS)throw new f("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var r=[],t=w.computeNumberOfVertices(e);if(s(e.indices)&&t>p.SIXTY_FOUR_KILOBYTES){var n,i=[],a=[],o=0,u=z(e.attributes),c=e.indices,l=c.length;e.primitiveType===q.TRIANGLES?n=3:e.primitiveType===q.LINES?n=2:e.primitiveType===q.POINTS&&(n=1);for(var h=0;l>h;h+=n){for(var d=0;n>d;++d){var m=c[h+d],y=i[m];s(y)||(y=o++,i[m]=y,O(u,e.attributes,m)),a.push(y)}o+n>p.SIXTY_FOUR_KILOBYTES&&(r.push(new w({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere})),i=[],a=[],o=0,u=z(e.attributes))}0!==a.length&&r.push(new w({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere}))}else r.push(e);return r};var j=new n,H=new a;k.projectTo2D=function(e,r,t,i,a){if(!s(e))throw new f("geometry is required.");if(!s(r))throw new f("attributeName is required.");if(!s(t))throw new f("attributeName3D is required.");if(!s(i))throw new f("attributeName2D is required.");if(!s(e.attributes[r]))throw new f("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==o.DOUBLE)throw new f("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");var u=e.attributes[r];a=s(a)?a:new l;for(var c=a.ellipsoid,w=u.values,d=new Float64Array(w.length),m=0,y=0;y<w.length;y+=3){var p=n.fromArray(w,y,j),v=c.cartesianToCartographic(p,H);if(!s(v))throw new f("Could not project point ("+p.x+", "+p.y+", "+p.z+") to 2D.");var g=a.project(v,j);d[m++]=g.x,d[m++]=g.y,d[m++]=g.z}return e.attributes[t]=u,e.attributes[i]=new h({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:d}),delete e.attributes[r],e};var Z={high:0,low:0};k.encodeAttribute=function(e,r,t,n){if(!s(e))throw new f("geometry is required.");if(!s(r))throw new f("attributeName is required.");if(!s(t))throw new f("attributeHighName is required.");if(!s(n))throw new f("attributeLowName is required.");if(!s(e.attributes[r]))throw new f("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==o.DOUBLE)throw new f("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var i=e.attributes[r],a=i.values,u=a.length,l=new Float32Array(u),w=new Float32Array(u),d=0;u>d;++d)c.encode(a[d],Z),l[d]=Z.high,w[d]=Z.low;var m=i.componentsPerAttribute;return e.attributes[t]=new h({componentDatatype:o.FLOAT,componentsPerAttribute:m,values:l}),e.attributes[n]=new h({componentDatatype:o.FLOAT,componentsPerAttribute:m,values:w}),delete e.attributes[r],e};var X=new n,K=new g,Q=new v;k.transformToWorldCoordinates=function(e){if(!s(e))throw new f("instance is required.");var t=e.modelMatrix;if(g.equals(t,g.IDENTITY))return e;var n=e.geometry.attributes;N(t,n.position),N(t,n.prevPosition),N(t,n.nextPosition),(s(n.normal)||s(n.binormal)||s(n.tangent))&&(g.inverse(t,K),g.transpose(K,K),g.getRotation(K,Q),A(Q,n.normal),A(Q,n.binormal),A(Q,n.tangent));var i=e.geometry.boundingSphere;return s(i)&&(e.geometry.boundingSphere=r.transform(i,t,i)),e.modelMatrix=g.clone(g.IDENTITY),e};var J=new n;k.combine=function(e){if(!s(e)||e.length<1)throw new f("instances is required and must have length greater than zero.");var t,i,a,o,u=e.length,c=e[0].modelMatrix,l=s(e[0].geometry.indices),h=e[0].geometry.primitiveType;for(i=1;u>i;++i){if(!g.equals(e[i].modelMatrix,c))throw new f("All instances must have the same modelMatrix.");if(s(e[i].geometry.indices)!==l)throw new f("All instance geometries must have an indices or not have one.");if(e[i].geometry.primitiveType!==h)throw new f("All instance geometries must have the same primitiveType.")}var m,y,p,v=I(e);for(t in v)if(v.hasOwnProperty(t))for(m=v[t].values,o=0,i=0;u>i;++i)for(y=e[i].geometry.attributes[t].values,p=y.length,a=0;p>a;++a)m[o++]=y[a];var b;if(l){var x=0;for(i=0;u>i;++i)x+=e[i].geometry.indices.length;var M=w.computeNumberOfVertices(new w({attributes:v,primitiveType:q.POINTS})),E=d.createTypedArray(M,x),S=0,T=0;for(i=0;u>i;++i){var z=e[i].geometry.indices,O=z.length;for(o=0;O>o;++o)E[S++]=T+z[o];T+=w.computeNumberOfVertices(e[i].geometry)}b=E}var N,A=new n,R=0;for(i=0;u>i;++i){if(N=e[i].geometry.boundingSphere,!s(N)){A=void 0;break}n.add(N.center,A,A)}if(s(A))for(n.divideByScalar(A,u,A),i=0;u>i;++i){N=e[i].geometry.boundingSphere;var P=n.magnitude(n.subtract(N.center,A,J))+N.radius;P>R&&(R=P)}return new w({attributes:v,indices:b,primitiveType:h,boundingSphere:s(A)?new r(A,R):void 0})};var $=new n,er=new n,rr=new n,tr=new n;k.computeNormal=function(e){if(!s(e))throw new f("geometry is required.");if(!s(e.attributes.position)||!s(e.attributes.position.values))throw new f("geometry.attributes.position.values is required.");if(!s(e.indices))throw new f("geometry.indices is required.");if(e.indices.length<2||0!==e.indices.length%3)throw new f("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==q.TRIANGLES)throw new f("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var r=e.indices,t=e.attributes,i=t.position.values,a=t.position.values.length/3,u=r.length,c=new Array(a),l=new Array(u/3),w=new Array(u),d=0;a>d;d++)c[d]={indexOffset:0,count:0,currentCount:0};var m=0;for(d=0;u>d;d+=3){var y=r[d],p=r[d+1],v=r[d+2],g=3*y,b=3*p,x=3*v;er.x=i[g],er.y=i[g+1],er.z=i[g+2],rr.x=i[b],rr.y=i[b+1],rr.z=i[b+2],tr.x=i[x],tr.y=i[x+1],tr.z=i[x+2],c[y].count++,c[p].count++,c[v].count++,n.subtract(rr,er,rr),n.subtract(tr,er,tr),l[m]=n.cross(rr,tr,new n),m++}var M=0;for(d=0;a>d;d++)c[d].indexOffset+=M,M+=c[d].count;m=0;var E;for(d=0;u>d;d+=3){E=c[r[d]];var S=E.indexOffset+E.currentCount;w[S]=m,E.currentCount++,E=c[r[d+1]],S=E.indexOffset+E.currentCount,w[S]=m,E.currentCount++,E=c[r[d+2]],S=E.indexOffset+E.currentCount,w[S]=m,E.currentCount++,m++}var T=new Float32Array(3*a);for(d=0;a>d;d++){var z=3*d;if(E=c[d],E.count>0){for(n.clone(n.ZERO,$),m=0;m<E.count;m++)n.add($,l[w[E.indexOffset+m]],$);n.normalize($,$),T[z]=$.x,T[z+1]=$.y,T[z+2]=$.z}else T[z]=0,T[z+1]=0,T[z+2]=1}return e.attributes.normal=new h({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:T}),e};var nr=new n,ir=new n,ar=new n;k.computeBinormalAndTangent=function(e){if(!s(e))throw new f("geometry is required.");var r=e.attributes,t=e.indices;if(!s(r.position)||!s(r.position.values))throw new f("geometry.attributes.position.values is required.");if(!s(r.normal)||!s(r.normal.values))throw new f("geometry.attributes.normal.values is required.");if(!s(r.st)||!s(r.st.values))throw new f("geometry.attributes.st.values is required.");if(!s(t))throw new f("geometry.indices is required.");if(t.length<2||0!==t.length%3)throw new f("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==q.TRIANGLES)throw new f("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var i=e.attributes.position.values,a=e.attributes.normal.values,u=e.attributes.st.values,c=e.attributes.position.values.length/3,l=t.length,w=new Array(3*c),d=0;d<w.length;d++)w[d]=0;var m,y,p;for(d=0;l>d;d+=3){var v=t[d],g=t[d+1],b=t[d+2];m=3*v,y=3*g,p=3*b;var x=2*v,M=2*g,E=2*b,S=i[m],T=i[m+1],z=i[m+2],O=u[x],N=u[x+1],A=u[M+1]-N,I=u[E+1]-N,R=1/((u[M]-O)*I-(u[E]-O)*A),P=(I*(i[y]-S)-A*(i[p]-S))*R,_=(I*(i[y+1]-T)-A*(i[p+1]-T))*R,L=(I*(i[y+2]-z)-A*(i[p+2]-z))*R;w[m]+=P,w[m+1]+=_,w[m+2]+=L,w[y]+=P,w[y+1]+=_,w[y+2]+=L,w[p]+=P,w[p+1]+=_,w[p+2]+=L}var C=new Float32Array(3*c),D=new Float32Array(3*c);for(d=0;c>d;d++){m=3*d,y=m+1,p=m+2;var U=n.fromArray(a,m,nr),B=n.fromArray(w,m,ar),F=n.dot(U,B);n.multiplyByScalar(U,F,ir),n.normalize(n.subtract(B,ir,B),B),D[m]=B.x,D[y]=B.y,D[p]=B.z,n.normalize(n.cross(U,B,B),B),C[m]=B.x,C[y]=B.y,C[p]=B.z}return e.attributes.tangent=new h({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:D}),e.attributes.binormal=new h({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:C}),e};var or=new n,ur=new n,sr=new n,fr=new n,cr=new n,lr={positions:new Array(7),indices:new Array(9)},wr=new t,hr=new t,dr=new t,mr=new n,yr=new n,pr=new n,vr=new n,gr=new n,br=new n;return k.wrapLongitude=function(e){if(!s(e))throw new f("geometry is required.");var t=e.boundingSphere;if(s(t)){var n=t.center.x-t.radius;if(n>0||r.intersect(t,i.UNIT_Y)!==m.INTERSECTING)return e}return U(e),e.primitiveType===q.TRIANGLES?G(e):e.primitiveType===q.LINES&&Y(e),e},k}),define("Core/Matrix2",["./Cartesian2","./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n,i){"use strict";var a=function(e,t,n,i){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(t,0),this[3]=r(i,0)};a.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r):new a(e[0],e[2],e[1],e[3]):void 0},a.fromArray=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new a),o[0]=e[i],o[1]=e[i+1],o[2]=e[i+2],o[3]=e[i+3],o},a.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return a.clone(e,r)},a.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[2],r[2]=e[1],r[3]=e[3],r):new a(e[0],e[1],e[2],e[3])},a.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=e.y,r):new a(e.x,0,0,e.y)},a.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=e,r):new a(e,0,0,e)},a.fromRotation=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=o,r[2]=-o,r[3]=i,r):new a(i,-o,o,i)},a.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r):[e[0],e[1],e[2],e[3]]},a.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>1)throw new n("row must be 0 or 1.");if("number"!=typeof e||0>e||e>1)throw new n("column must be 0 or 1.");return 2*e+r},a.getColumn=function(r,i,a){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>1)throw new n("index must be 0 or 1.");var o=2*i,u=r[o],s=r[o+1];return t(a)?(a.x=u,a.y=s,a):new e(u,s)},a.setColumn=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>1)throw new n("index must be 0 or 1.");o=a.clone(e,o);var u=2*r;return o[u]=i.x,o[u+1]=i.y,o},a.getRow=function(r,i,a){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>1)throw new n("index must be 0 or 1.");var o=r[i],u=r[i+2];return t(a)?(a.x=o,a.y=u,a):new e(o,u)},a.setRow=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>1)throw new n("index must be 0 or 1.");return o=a.clone(e,o),o[r]=i.x,o[r+2]=i.y,o};var o=new e;a.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");return t(i)||(i=new e),i.x=e.magnitude(e.fromElements(r[0],r[1],o)),i.y=e.magnitude(e.fromElements(r[2],r[3],o)),i};var u=new e;return a.getMaximumScale=function(r){return a.getScale(r,u),e.getMaximumComponent(u)},a.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");var o=e[0]*r[0]+e[2]*r[1],u=e[0]*r[2]+e[2]*r[3],s=e[1]*r[0]+e[3]*r[1],f=e[1]*r[2]+e[3]*r[3];return t(i)?(i[0]=o,i[1]=s,i[2]=u,i[3]=f,i):new a(o,u,s,f)},a.multiplyByVector=function(r,i,a){if(!t(r))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");var o=r[0]*i.x+r[2]*i.y,u=r[1]*i.x+r[3]*i.y;return t(a)?(a.x=o,a.y=u,a):new e(o,u)},a.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar is required and must be a number");return t(i)?(i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i):new a(e[0]*r,e[2]*r,e[1]*r,e[3]*r)},a.negate=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r):new a(-e[0],-e[2],-e[1],-e[3])},a.transpose=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],o=e[2],u=e[1],s=e[3];return t(r)?(r[0]=i,r[1]=o,r[2]=u,r[3]=s,r):new a(i,u,o,s)},a.abs=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r):new a(Math.abs(e[0]),Math.abs(e[2]),Math.abs(e[1]),Math.abs(e[3]))},a.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]},a.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i},a.IDENTITY=i(new a(1,0,0,1)),a.COLUMN0ROW0=0,a.COLUMN0ROW1=1,a.COLUMN1ROW0=2,a.COLUMN1ROW1=3,a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n"+"("+this[1]+", "+this[3]+")"},a}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,r,t,n,i,a,o,u){"use strict";var s=function(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)},f=new e;s.fromAxisAngle=function(r,i,a){if(!t(r))throw new n("axis is required.");if("number"!=typeof i)throw new n("angle is required and must be a number.");var o=i/2,u=Math.sin(o);f=e.normalize(r,f);var c=f.x*u,l=f.y*u,w=f.z*u,h=Math.cos(o);return t(a)?(a.x=c,a.y=l,a.z=w,a.w=h,a):new s(c,l,w,h)};var c=[1,2,0],l=new Array(3);s.fromRotationMatrix=function(e,r){if(!t(e))throw new n("matrix is required.");var i,a,o,f,w,h=e[u.COLUMN0ROW0],d=e[u.COLUMN1ROW1],m=e[u.COLUMN2ROW2],y=h+d+m;if(y>0)i=Math.sqrt(y+1),w=.5*i,i=.5/i,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*i,o=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*i,f=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*i;else{var p=c,v=0;d>h&&(v=1),m>h&&m>d&&(v=2);var g=p[v],b=p[g];i=Math.sqrt(e[u.getElementIndex(v,v)]-e[u.getElementIndex(g,g)]-e[u.getElementIndex(b,b)]+1);var q=l;q[v]=.5*i,i=.5/i,w=(e[u.getElementIndex(b,g)]-e[u.getElementIndex(g,b)])*i,q[g]=(e[u.getElementIndex(g,v)]+e[u.getElementIndex(v,g)])*i,q[b]=(e[u.getElementIndex(b,v)]+e[u.getElementIndex(v,b)])*i,a=-q[0],o=-q[1],f=-q[2]}return t(r)?(r.x=a,r.y=o,r.z=f,r.w=w,r):new s(a,o,f,w)};var w=new e,h=new e,d=new s,m=new s,y=new s;s.packedLength=4,s.pack=function(e,i,a){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");a=r(a,0),i[a++]=e.x,i[a++]=e.y,i[a++]=e.z,i[a]=e.w},s.unpack=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new s),a.x=e[i],a.y=e[i+1],a.z=e[i+2],a.w=e[i+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,r,t,n){s.unpack(e,4*t,y),s.conjugate(y,y);for(var i=0,a=t-r+1;a>i;i++){var o=3*i;s.unpack(e,4*(r+i),d),s.multiply(d,y,d),d.w<0&&s.negate(d,d),s.getAxis(d,w);var u=s.getAngle(d);n[o]=w.x*u,n[o+1]=w.y*u,n[o+2]=w.z*u}},s.unpackInterpolationResult=function(r,n,i,a,o){t(o)||(o=new s),e.fromArray(r,0,h);var u=e.magnitude(h);return s.unpack(n,4*a,m),0===u?s.clone(s.IDENTITY,d):s.fromAxisAngle(h,u,d),s.multiply(d,m,o)},s.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,r){if(!t(e))throw new n("quaternion is required");return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r):new s(-e.x,-e.y,-e.z,e.w)},s.magnitudeSquared=function(e){if(!t(e))throw new n("quaternion is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){var n=1/s.magnitude(e),i=e.x*n,a=e.y*n,o=e.z*n,u=e.w*n;return t(r)?(r.x=i,r.y=a,r.z=o,r.w=u,r):new s(i,a,o,u)},s.inverse=function(e,r){var t=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/t,r)},s.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");return t(i)?(i.x=e.x+r.x,i.y=e.y+r.y,i.z=e.z+r.z,i.w=e.w+r.w,i):new s(e.x+r.x,e.y+r.y,e.z+r.z,e.w+r.w)},s.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");return t(i)?(i.x=e.x-r.x,i.y=e.y-r.y,i.z=e.z-r.z,i.w=e.w-r.w,i):new s(e.x-r.x,e.y-r.y,e.z-r.z,e.w-r.w)},s.negate=function(e,r){if(!t(e))throw new n("quaternion is required");return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r):new s(-e.x,-e.y,-e.z,-e.w)},s.dot=function(e,r){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");return e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");var a=e.x,o=e.y,u=e.z,f=e.w,c=r.x,l=r.y,w=r.z,h=r.w,d=f*c+a*h+o*w-u*l,m=f*l-a*w+o*h+u*c,y=f*w+a*l-o*c+u*h,p=f*h-a*c-o*l-u*w;return t(i)?(i.x=d,i.y=m,i.z=y,i.w=p,i):new s(d,m,y,p)},s.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");return t(i)?(i.x=e.x*r,i.y=e.y*r,i.z=e.z*r,i.w=e.w*r,i):new s(e.x*r,e.y*r,e.z*r,e.w*r)},s.divideByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");return t(i)?(i.x=e.x/r,i.y=e.y/r,i.z=e.z/r,i.w=e.w/r,i):new s(e.x/r,e.y/r,e.z/r,e.w/r)},s.getAxis=function(r,i){if(!t(r))throw new n("quaternion is required");var a=r.w;if(Math.abs(a-1)<o.EPSILON6)return t(i)?(i.x=i.y=i.z=0,i):new e;var u=1/Math.sqrt(1-a*a);return t(i)?(i.x=r.x*u,i.y=r.y*u,i.z=r.z*u,i):new e(r.x*u,r.y*u,r.z*u)},s.getAngle=function(e){if(!t(e))throw new n("quaternion is required");return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var p;s.lerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");return p=s.multiplyByScalar(r,i,p),a=s.multiplyByScalar(e,1-i,a),s.add(p,a,a)};var v,g,b;s.slerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");var u=s.dot(e,r),f=r;if(0>u&&(u=-u,f=v=s.negate(r,v)),1-u<o.EPSILON6)return s.lerp(e,f,i,a);var c=Math.acos(u);return g=s.multiplyByScalar(e,Math.sin((1-i)*c),g),b=s.multiplyByScalar(f,Math.sin(i*c),b),a=s.add(g,b,a),s.multiplyByScalar(a,1/Math.sin(c),a)},s.log=function(r,i){if(!t(r))throw new n("quaternion is required.");var a=o.acosClamped(r.w),u=0;return 0!==a&&(u=a/Math.sin(a)),t(i)||(i=new e),e.multiplyByScalar(r,u,i)},s.exp=function(r,i){if(!t(r))throw new n("cartesian is required.");var a=e.magnitude(r),o=0;return 0!==a&&(o=Math.sin(a)/a),t(i)||(i=new s),i.x=r.x*o,i.y=r.y*o,i.z=r.z*o,i.w=Math.cos(a),i};var q=new e,x=new e,M=new s,E=new s;s.innerQuadrangle=function(r,i,a,o){if(!t(r)||!t(i)||!t(a))throw new n("q0, q1, and q2 are required.");var u=s.conjugate(i,M);s.multiply(u,a,E);var f=s.log(E,q);s.multiply(u,r,E);var c=s.log(E,x);return e.add(f,c,f),e.multiplyByScalar(f,.25,f),e.negate(f,f),s.exp(f,M),s.multiply(i,M,o)},s.squad=function(e,r,i,a,o,u){if(!(t(e)&&t(r)&&t(i)&&t(a)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof o)throw new n("t is required and must be a number.");var f=s.slerp(e,r,o,M),c=s.slerp(i,a,o,E);return s.slerp(f,c,2*o*(1-o),u)};for(var S=new s,T=1.9011074535173003,z=i.supportsTypedArrays()?new Float32Array(8):[],O=i.supportsTypedArrays()?new Float32Array(8):[],N=i.supportsTypedArrays()?new Float32Array(8):[],A=i.supportsTypedArrays()?new Float32Array(8):[],I=0;7>I;++I){var R=I+1,P=2*R+1;z[I]=1/(R*P),O[I]=R/P}return z[7]=T/136,O[7]=8*T/17,s.fastSlerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");t(a)||(a=new s);var o,u=s.dot(e,r);u>=0?o=1:(o=-1,u=-u);for(var f=u-1,c=1-i,l=i*i,w=c*c,h=7;h>=0;--h)N[h]=(z[h]*l-O[h])*f,A[h]=(z[h]*w-O[h])*f;var d=o*i*(1+N[0]*(1+N[1]*(1+N[2]*(1+N[3]*(1+N[4]*(1+N[5]*(1+N[6]*(1+N[7])))))))),m=c*(1+A[0]*(1+A[1]*(1+A[2]*(1+A[3]*(1+A[4]*(1+A[5]*(1+A[6]*(1+A[7])))))))),y=s.multiplyByScalar(e,m,S);return s.multiplyByScalar(r,d,a),s.add(y,a,a)},s.fastSquad=function(e,r,i,a,o,u){if(!(t(e)&&t(r)&&t(i)&&t(a)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof o)throw new n("t is required and must be a number.");var f=s.fastSlerp(e,r,o,M),c=s.fastSlerp(i,a,o,E);return s.fastSlerp(f,c,2*o*(1-o),u)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},s.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon is required and must be a number.");return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},s.ZERO=a(new s(0,0,0,0)),s.IDENTITY=a(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return s.equalsEpsilon(this,e,r)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/VertexFormat",["./defaultValue","./freezeObject"],function(e,r){"use strict";var t=function(r){r=e(r,e.EMPTY_OBJECT),this.position=e(r.position,!1),this.normal=e(r.normal,!1),this.st=e(r.st,!1),this.binormal=e(r.binormal,!1),this.tangent=e(r.tangent,!1)};return t.POSITION_ONLY=r(new t({position:!0})),t.POSITION_AND_NORMAL=r(new t({position:!0,normal:!0})),t.POSITION_NORMAL_AND_ST=r(new t({position:!0,normal:!0,st:!0})),t.POSITION_AND_ST=r(new t({position:!0,st:!0})),t.ALL=r(new t({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),t.DEFAULT=t.POSITION_NORMAL_AND_ST,t}),define("Core/RectangleGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix2","./Matrix3","./PrimitiveType","./Quaternion","./Rectangle","./VertexFormat"],function(e,r,t,n,i,a,o,u,s,f,c,l,w,h,d,m,y,p,v,g,b,q,x){"use strict";function M(e,r){return e<-y.PI_OVER_TWO||e>y.PI_OVER_TWO?!1:r>y.PI||r<-y.PI?!1:!0}function E(e,r,t,n,i){var a=e.radiiSquared;R=L.latitude-e.granYCos*r+t*e.granXSin;var u=er(R),s=rr(R),f=a.z*s;P=L.longitude+r*e.granYSin+t*e.granXCos;var c=u*er(P),l=u*rr(P),w=a.x*c,h=a.y*l,d=tr(w*c+h*l+f*s),m=w/d,y=h/d,p=f/d;o(n)&&(G.x=m+c*n,G.y=y+l*n,G.z=p+s*n),o(i)&&(H.x=m+c*i,H.y=y+l*i,H.z=p+s*i)}function S(e,r){var t=new c({attributes:new w,primitiveType:g.TRIANGLES});return e.position&&(t.attributes.position=new l({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:r.positions})),e.normal&&(t.attributes.normal=new l({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:r.normals})),e.tangent&&(t.attributes.tangent=new l({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:r.tangents})),e.binormal&&(t.attributes.binormal=new l({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:r.binormals})),t}function T(e,r,n,i,a){var o=e.length,u=r.normal?new Float32Array(o):void 0,s=r.tangent?new Float32Array(o):void 0,f=r.binormal?new Float32Array(o):void 0,c=0,l=i?o/2:0;o=i&&a?o/2:o;for(var w=0;o>w;w+=3){var h=t.fromArray(e,w,G),d=c+1,m=c+2;(r.normal||r.tangent||r.binormal)&&(Y=n.geodeticSurfaceNormal(h,Y),(r.tangent||r.binormal)&&(t.cross(t.UNIT_Z,Y,k),v.multiplyByVector(V,k,k),t.normalize(k,k),r.binormal&&t.normalize(t.cross(Y,k,j),j)),i&&(r.normal&&(u[c]=Y.x,u[d]=Y.y,u[m]=Y.z),r.tangent&&(s[c]=k.x,s[d]=k.y,s[m]=k.z),r.binormal&&(f[c]=j.x,f[d]=j.y,f[m]=j.z)),a&&(r.normal&&(u[c+l]=-Y.x,u[d+l]=-Y.y,u[m+l]=-Y.z),r.tangent&&(s[c+l]=-k.x,s[d+l]=-k.y,s[m+l]=-k.z),r.binormal&&(f[c+l]=j.x,f[d+l]=j.y,f[m+l]=j.z))),c+=3
}return S(r,{positions:e,normals:u,tangents:s,binormals:f})}function z(e,r,n){for(var i=e.length,a=r.normal?new Float32Array(i):void 0,o=r.tangent?new Float32Array(i):void 0,u=r.binormal?new Float32Array(i):void 0,s=0,f=!0,c=i/2,l=0;c>l;l+=3){var w=t.fromArray(e,l,G),h=s+1,d=s+2;if(r.normal||r.tangent||r.binormal){var m=t.fromArray(e,l+3,K);if(f){var p=t.fromArray(e,l+c,Q);t.subtract(m,w,m),t.subtract(p,w,p),Y=t.normalize(t.cross(p,m,Y),Y),f=!1}t.equalsEpsilon(m,w,y.EPSILON10)&&(f=!0),(r.tangent||r.binormal)&&(j=n.geodeticSurfaceNormal(w,j),r.tangent&&(k=t.normalize(t.cross(j,Y,k),k))),r.normal&&(a[s]=Y.x,a[h]=Y.y,a[d]=Y.z,a[s+c]=Y.x,a[h+c]=Y.y,a[d+c]=Y.z),r.tangent&&(o[s]=k.x,o[h]=k.y,o[d]=k.z,o[s+c]=k.x,o[h+c]=k.y,o[d+c]=k.z),r.binormal&&(u[s]=j.x,u[h]=j.y,u[d]=j.z,u[s+c]=j.x,u[h+c]=j.y,u[d+c]=j.z)}s+=3}return S(r,{positions:e,normals:a,tangents:o,binormals:u})}function O(e,r,t,n,i){return J.x=(P-U.west)*n.lonScalar-.5,J.y=(R-U.south)*n.latScalar-.5,p.multiplyByVector(B,J,J),J.x+=.5,J.y+=.5,o(i)&&(t[r+i]=J.x,t[r+1+i]=J.y),t[r++]=J.x,t[r++]=J.y,r}function N(e,r,t){return e[r+t]=H.x,e[r++]=G.x,e[r+t]=H.y,e[r++]=G.y,e[r+t]=H.z,e[r++]=G.z,e}function A(r,t){for(var n=t.ellipsoid,a=t.size,o=t.height,u=t.width,s=t.surfaceHeight,f=0,c=r.position?new Float64Array(3*a):void 0,w=r.st?new Float32Array(2*a):void 0,h=0,d=0;o>d;++d)for(var y=0;u>y;++y)E(t,d,y,s),c[h++]=G.x,c[h++]=G.y,c[h++]=G.z,r.st&&(J.x=(P-U.west)*t.lonScalar-.5,J.y=(R-U.south)*t.latScalar-.5,p.multiplyByVector(B,J,J),J.x+=.5,J.y+=.5,w[f++]=J.x,w[f++]=J.y);for(var v=T(c,r,n,!0,!1),g=6*(u-1)*(o-1),b=m.createTypedArray(a,g),q=0,x=0,M=0;o-1>M;++M){for(var S=0;u-1>S;++S){var z=q,O=z+u,N=O+1,A=z+1;b[x++]=z,b[x++]=O,b[x++]=A,b[x++]=A,b[x++]=O,b[x++]=N,++q}++q}return v.indices=b,r.st&&(v.attributes.st=new l({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:w})),{boundingSphere:e.fromRectangle3D(t.rectangle,n,s),geometry:v}}function I(r,n){var o=n.surfaceHeight,u=n.extrudedHeight,s=Math.min(u,o),f=Math.max(u,o);if(y.equalsEpsilon(s,f,.1))return A(r,n);var c,w=n.height,p=n.width,v=n.size,g=n.ellipsoid,b=a(n.closeTop,!0),q=a(n.closeBottom,!0),x=2*p+2*w-4,M=2*(x+4),S=new Float64Array(3*M),I=r.st?new Float32Array(2*M):void 0,R=0,P=0,_=0,L=3*(M/2);for(c=0;w>c;c++)E(n,c,R,f,s),S=N(S,P,L),P+=3,r.st&&(_=O(r,_,I,n,M));for(c=w-1,R=0;p>R;R++)E(n,c,R,f,s),S=N(S,P,L),P+=3,r.st&&(_=O(r,_,I,n,M));for(R=p-1,c=w-1;c>=0;c--)E(n,c,R,f,s),S=N(S,P,L),P+=3,r.st&&(_=O(r,_,I,n,M));for(c=0,R=p-1;R>=0;R--)E(n,c,R,f,s),S=N(S,P,L),P+=3,r.st&&(_=O(r,_,I,n,M));var C=z(S,r,g);r.st&&(C.attributes.st=new l({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:I}));var D,U,B,F,V,W=m.createTypedArray(M,6*x),Y=S.length/6,k=0;for(V=0;Y-1>V;V++){D=V,F=D+1;var j=t.fromArray(S,3*D,K),J=t.fromArray(S,3*F,Q);t.equalsEpsilon(j,J,y.EPSILON10)||(U=D+Y,B=U+1,W[k++]=D,W[k++]=U,W[k++]=F,W[k++]=F,W[k++]=U,W[k++]=B)}if(C.indices=W,q||b){var $,er,rr=0,tr=0;b&&(rr+=v,tr+=6*(p-1)*(w-1),$=f),q&&(rr+=v,tr+=6*(p-1)*(w-1),er=s);var nr=new Float64Array(3*rr),ir=r.st?new Float32Array(2*rr):void 0,ar=m.createTypedArray(rr,tr);for(P=0,_=0,L=q&&b?3*v:0,c=0;w>c;++c)for(R=0;p>R;++R)E(n,c,R,$,er),q&&(nr[P+L]=H.x,nr[P+1+L]=H.y,nr[P+2+L]=H.z),b&&(nr[P]=G.x,nr[P+1]=G.y,nr[P+2]=G.z),r.st&&(_=O(r,_,ir,n,2*v)),P+=3;var or=T(nr,r,g,b,q);r.st&&(or.attributes.st=new l({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:ir}));var ur=0;for(k=0,L/=3,V=0;w-1>V;++V){for(var sr=0;p-1>sr;++sr)D=k,U=D+p,B=U+1,F=D+1,q&&(ar[ur++]=F+L,ar[ur++]=U+L,ar[ur++]=D+L,ar[ur++]=B+L,ar[ur++]=U+L,ar[ur++]=F+L),b&&(ar[ur++]=D,ar[ur++]=U,ar[ur++]=F,ar[ur++]=F,ar[ur++]=U,ar[ur++]=B),++k;++k}or.indices=ar,C=d.combine([new h({geometry:or}),new h({geometry:C})])}var fr=e.fromRectangle3D(n.rectangle,g,f,X),cr=e.fromRectangle3D(n.rectangle,g,s,Z),lr=e.union(fr,cr);return{boundingSphere:lr,geometry:C}}var R,P,_=new t,L=new n,C=new n,D=new t,U=new q,B=new p,F=new p,V=new v,W=new f,G=new t,Y=new t,k=new t,j=new t,H=new t,Z=new e,X=new e,K=new t,Q=new t,J=new r,$=new b,er=Math.cos,rr=Math.sin,tr=Math.sqrt,nr=function(e){e=a(e,a.EMPTY_OBJECT);var r=e.rectangle,t=a(e.granularity,y.RADIANS_PER_DEGREE),n=a(e.ellipsoid,s.WGS84),i=a(e.height,0),f=e.rotation,c=e.stRotation,l=a(e.vertexFormat,x.DEFAULT);if(!o(r))throw new u("rectangle is required.");if(q.validate(r),r.east<r.west)throw new u("options.rectangle.east must be greater than options.rectangle.west");if(r.north<r.south)throw new u("options.rectangle.north must be greater than options.rectangle.south");this._rectangle=r,this._granularity=t,this._ellipsoid=n,this._surfaceHeight=i,this._rotation=f,this._stRotation=c,this._vertexFormat=l,this._extrudedHeight=e.extrudedHeight,this._closeTop=e.closeTop,this._closeBottom=e.closeBottom,this._workerName="createRectangleGeometry"};return nr.createGeometry=function(e){var r=e._rectangle,n=e._granularity,i=e._ellipsoid,a=e._surfaceHeight,s=e._rotation,f=e._stRotation,l=e._vertexFormat,h=e._extrudedHeight,d=e._closeTop,m=e._closeBottom,y=Math.ceil((r.east-r.west)/n)+1,g=Math.ceil((r.north-r.south)/n)+1,x=(r.east-r.west)/(y-1),E=(r.north-r.south)/(g-1),S=i.radiiSquared;q.clone(r,U),q.getNorthwest(r,L),q.getCenter(r,C);var T=E,z=x,O=0,N=0;if(o(s)){var R=er(s);T*=R,z*=R;var P=rr(s);O=E*P,N=x*P,W.project(L,_),W.project(C,D),t.subtract(_,D,_),p.fromRotation(s,F),p.multiplyByVector(F,_,_),t.add(_,D,_),W.unproject(_,L);var G=L.latitude,Y=G+(y-1)*N,k=G-T*(g-1),j=G-T*(g-1)+(y-1)*N,H=Math.max(G,Y,k,j),Z=Math.min(G,Y,k,j),X=L.longitude,Q=X+(y-1)*z,J=X+(g-1)*O,tr=X+(g-1)*O+(y-1)*z,nr=Math.max(X,Q,J,tr),ir=Math.min(X,Q,J,tr);if(!(M(H,ir)&&M(H,nr)&&M(Z,ir)&&M(Z,nr)))throw new u("Rotated rectangle is invalid.");U.north=H,U.south=Z,U.east=nr,U.west=ir}var ar=1/(U.east-U.west),or=1/(U.north-U.south),ur=y*g;if(o(f)){p.fromRotation(-f,B);var sr=i.cartographicToCartesian(C,K);t.normalize(sr,sr),b.fromAxisAngle(sr,-f,$),v.fromQuaternion($,V)}else p.clone(p.IDENTITY,B),v.clone(v.IDENTITY,V);var fr,cr={granYCos:T,granYSin:O,granXCos:z,granXSin:N,radiiSquared:S,ellipsoid:i,lonScalar:ar,latScalar:or,rectangle:r,width:y,height:g,surfaceHeight:a,size:ur,extrudedHeight:h,closeTop:d,closeBottom:m};fr=o(h)?I(l,cr):A(l,cr);var lr=fr.boundingSphere;return fr=fr.geometry,new c({attributes:new w(fr.attributes),indices:fr.indices,primitiveType:fr.primitiveType,boundingSphere:lr})},nr}),define("Workers/createRectangleGeometry",["../Core/Ellipsoid","../Core/Rectangle","../Core/RectangleGeometry"],function(e,r,t){"use strict";function n(n){return n._ellipsoid=e.clone(n._ellipsoid),n._rectangle=r.clone(n._rectangle),t.createGeometry(n)}return n})}();