/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2014 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=.5*3*Math.PI,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,a=e-Math.floor(e/r)*r;return a<-Math.PI?a+r:a>=Math.PI?a-r:a},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");for(var r=i.EPSILON10,a=i.PI,o=i.TWO_PI;-(a+r)>e;)e+=o;if(-a>e)return-a;for(;e>a+r;)e-=o;return e>a?a:e},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=e%i.TWO_PI;return 0>r?(r+i.TWO_PI)%i.TWO_PI:r},i.equalsEpsilon=function(e,i,a){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");return a=r(a,0),Math.abs(e-i)<=a};var a=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=a.length;if(e>=r)for(var t=a[r-1],i=r;e>=i;i++)a.push(t*i);return a[e]},i.incrementWrap=function(e,i,a){if(a=r(a,0),!t(e))throw new n("n is required.");if(a>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=a),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var o=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");o=new e(r)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){return Math.asin(i.clamp(e,-1,1))},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};a.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new a);var o=n.clock,u=n.cone,s=e(n.magnitude,1),f=s*Math.sin(u);return i.x=f*Math.cos(o),i.y=f*Math.sin(o),i.z=s*Math.cos(u),i},a.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new a(e,t,n)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a]=n.z},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i],o},a.fromArray=a.unpack,a.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},a.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},a.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},a.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var u=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,u),o=a.multiplyByScalar(e,1-i,o),a.add(u,o,o)};var s=new a,f=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");a.normalize(e,s),a.normalize(n,f);var i=a.dot(s,f),o=a.magnitude(a.cross(s,f,s));return Math.atan2(o,i)};var h=new a;a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,h);return a.abs(i,i),n=i.x<=i.y?i.x<=i.z?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Z,n):i.y<=i.z?a.clone(a.UNIT_Y,n):a.clone(a.UNIT_Z,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i},a.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var a=e.x,o=e.y,u=e.z,s=n.x,f=n.y,h=n.z,l=o*h-u*f,c=u*s-a*h,d=a*f-o*s;return i.x=l,i.y=c,i.z=d,i},a.fromDegrees=function(e,n,o,u,s){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var f=i.toRadians(e),h=i.toRadians(n);return a.fromRadians(f,h,o,u,s)};var l=new a,c=new a,d=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,i,o,u,s){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");o=e(o,0);var f=r(u)?u.radiiSquared:d,h=Math.cos(i);l.x=h*Math.cos(n),l.y=h*Math.sin(n),l.z=Math.sin(i),l=a.normalize(l,l),a.multiplyComponents(f,l,c);var w=Math.sqrt(a.dot(l,c));return c=a.divideByScalar(c,w,c),l=a.multiplyByScalar(l,o,l),r(s)||(s=new a),a.add(c,l,s)},a.fromDegreesArray=function(e,n,o){if(!r(e))throw new t("positions is required.");for(var u=new Array(e.length),s=0;s<e.length;s++)u[s]=i.toRadians(e[s]);return a.fromRadiansArray(u,n,o)},a.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(0!==e.length%2)throw new t("positions length must be a multiple of 2.");var o=e.length;r(i)?i.length=o/2:i=new Array(o/2);for(var u=0;o>u;u+=2){var s=e[u],f=e[u+1];i[u/2]=a.fromRadians(s,f,0,n,i[u/2])}return i},a.fromDegreesArrayHeights=function(e,n,o){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");for(var u=new Array(e.length),s=0;s<e.length;s+=3)u[s]=i.toRadians(e[s]),u[s+1]=i.toRadians(e[s+1]),u[s+2]=e[s+2];return a.fromRadiansArrayHeights(u,n,o)},a.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");var o=e.length;r(i)?i.length=o/3:i=new Array(o/3);for(var u=0;o>u;u+=3){var s=e[u],f=e[u+1],h=e[u+2];i[u/3]=a.fromRadians(s,f,h,n,i[u/3])}return i},a.ZERO=n(new a(0,0,0)),a.UNIT_X=n(new a(1,0,0)),a.UNIT_Y=n(new a(0,1,0)),a.UNIT_Z=n(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return a.fromRadians=function(n,i,o,u){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return o=e(o,0),r(u)?(u.longitude=n,u.latitude=i,u.height=o,u):new a(n,i,o)},a.fromDegrees=function(e,n,o,u){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),a.fromRadians(e,n,o,u)},a.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new a(e.longitude,e.latitude,e.height):void 0},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},a.toString=function(e){if(!r(e))throw new t("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},a.ZERO=n(new a(0,0,0)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return a.toString(this)},a}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a,o,u){"use strict";var s=function(r,n,i){if(r=t(r,0),n=t(n,0),i=t(i,0),0>r||0>n||0>i)throw new a("All radii components must be greater than or equal to zero.");this._radii=new e(r,n,i),this._radiiSquared=new e(r*r,n*n,i*i),this._radiiToTheFourth=new e(r*r*r*r,n*n*n*n,i*i*i*i),this._oneOverRadii=new e(0===r?0:1/r,0===n?0:1/n,0===i?0:1/i),this._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===n?0:1/(n*n),0===i?0:1/(i*i)),this._minimumRadius=Math.min(r,n,i),this._maximumRadius=Math.max(r,n,i),this._centerToleranceSquared=u.EPSILON1};i(s.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),s.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new s(i.x,i.y,i.z)},s.fromCartesian3=function(e){return n(e)?new s(e.x,e.y,e.z):new s},s.WGS84=o(new s(6378137,6378137,6356752.314245179)),s.UNIT_SPHERE=o(new s(1,1,1)),s.MOON=o(new s(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.geocentricSurfaceNormal=e.normalize,s.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new a("cartographic is required.");var i=r.longitude,o=r.latitude,u=Math.cos(o),s=u*Math.cos(i),f=u*Math.sin(i),h=Math.sin(o);return n(t)||(t=new e),t.x=s,t.y=f,t.z=h,e.normalize(t,t)},s.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var f=new e,h=new e;s.prototype.cartographicToCartesian=function(r,t){var i=f,a=h;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(a,i,t)},s.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new a("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var l=new e,c=new e,d=new e;s.prototype.cartesianToCartographic=function(t,i){var a=this.scaleToGeodeticSurface(t,c);if(!n(a))return void 0;var o=this.geodeticSurfaceNormal(a,l),s=e.subtract(t,a,d),f=Math.atan2(o.y,o.x),h=Math.asin(o.z),w=u.sign(e.dot(s,t))*e.magnitude(s);return n(i)?(i.longitude=f,i.latitude=h,i.height=w,i):new r(f,h,w)},s.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new a("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var w=new e,m=new e;return s.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");var i=r.x,o=r.y,s=r.z,f=this._oneOverRadii,h=f.x,l=f.y,c=f.z,d=i*i*h*h,p=o*o*l*l,y=s*s*c*c,g=d+p+y,v=Math.sqrt(1/g),q=e.multiplyByScalar(r,v,w);if(g<this._centerToleranceSquared)return isFinite(v)?e.clone(q,t):void 0;var x=this._oneOverRadiiSquared,E=x.x,b=x.y,S=x.z,M=m;M.x=2*q.x*E,M.y=2*q.y*b,M.z=2*q.z*S;var _,O,P,T,C,R,N,I,z,D,A,U=(1-v)*e.magnitude(r)/(.5*e.magnitude(M)),L=0;do{U-=L,P=1/(1+U*E),T=1/(1+U*b),C=1/(1+U*S),R=P*P,N=T*T,I=C*C,z=R*P,D=N*T,A=I*C,_=d*R+p*N+y*I-1,O=d*z*E+p*D*b+y*A*S;var B=-2*O;L=_/B}while(Math.abs(_)>u.EPSILON12);return n(t)?(t.x=i*P,t.y=o*T,t.z=s*C,t):new e(i*P,o*T,s*C)},s.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");n(t)||(t=new e);var i=r.x,o=r.y,u=r.z,s=this._oneOverRadiiSquared,f=1/Math.sqrt(i*i*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(r,f,t)},s.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},s.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},s.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},s.prototype.toString=function(){return this._radii.toString()},s}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t){this.x=e(r,0),this.y=e(t,0)};a.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new a(e,t)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a]=n.y},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i],o},a.fromArray=a.unpack,a.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y)},a.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y)},a.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i},a.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n};var u=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,u),o=a.multiplyByScalar(e,1-i,o),a.add(u,o,o)};var s=new a,f=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return a.normalize(e,s),a.normalize(n,f),i.acosClamped(a.dot(s,f))};var h=new a;return a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,h);return a.abs(i,i),n=i.x<=i.y?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Y,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i},a.ZERO=n(new a(0,0)),a.UNIT_X=n(new a(1,0)),a.UNIT_Y=n(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,a,o){"use strict";var u=function(e){this._ellipsoid=t(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(r,t){var i=this._semimajorAxis,a=r.longitude*i,o=r.latitude*i,u=r.height;return n(t)?(t.x=a,t.y=o,t.z=u,t):new e(a,o,u)},u.prototype.unproject=function(e,t){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=e.y*i,s=e.z;return n(t)?(t.longitude=o,t.latitude=u,t.height=s,t):new r(o,u,s)},u}),define("Core/Intersect",[],function(){"use strict";var e={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,a,o){"use strict";var u=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};u.fromDegrees=function(e,n,i,a,s){return e=o.toRadians(r(e,0)),n=o.toRadians(r(n,0)),i=o.toRadians(r(i,0)),a=o.toRadians(r(a,0)),t(s)?(s.west=e,s.south=n,s.east=i,s.north=a,s):new u(e,n,i,a)},u.fromCartographicArray=function(e,r){if(!t(e))throw new n("cartographics is required.");for(var i=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,s=-Number.MAX_VALUE,f=0,h=e.length;h>f;f++){var l=e[f];i=Math.min(i,l.longitude),a=Math.max(a,l.longitude),o=Math.min(o,l.latitude),s=Math.max(s,l.latitude)}return t(r)?(r.west=i,r.south=o,r.east=a,r.north=s,r):new u(i,o,a,s)},u.packedLength=4,u.pack=function(e,i,a){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");a=r(a,0),i[a++]=e.west,i[a++]=e.south,i[a++]=e.east,i[a]=e.north},u.unpack=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new u),a.west=e[i++],a.south=e[i++],a.east=e[i++],a.north=e[i],a},u.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new u(e.west,e.south,e.east,e.north):void 0},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},u.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new n("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},u.validate=function(e){if(!t(e))throw new n("rectangle is required");var r=e.north;if("number"!=typeof r)throw new n("north is required to be a number.");if(r<-o.PI_OVER_TWO||r>o.PI_OVER_TWO)throw new n("north must be in the interval [-Pi/2, Pi/2].");var i=e.south;if("number"!=typeof i)throw new n("south is required to be a number.");if(i<-o.PI_OVER_TWO||i>o.PI_OVER_TWO)throw new n("south must be in the interval [-Pi/2, Pi/2].");var a=e.west;if("number"!=typeof a)throw new n("west is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new n("west must be in the interval [-Pi, Pi].");var u=e.east;if("number"!=typeof u)throw new n("east is required to be a number.");if(u<-Math.PI||u>Math.PI)throw new n("east must be in the interval [-Pi, Pi].")},u.getSouthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},u.getNorthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},u.getNortheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},u.getSoutheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},u.getCenter=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=.5*(r.west+r.east),i.latitude=.5*(r.south+r.north),i.height=0,i):new e(.5*(r.west+r.east),.5*(r.south+r.north))},u.intersectWith=function(e,r,i){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("otherRectangle is required.");var a=Math.max(e.west,r.west),o=Math.max(e.south,r.south),s=Math.min(e.east,r.east),f=Math.min(e.north,r.north);return t(i)?(i.west=a,i.south=o,i.east=s,i.north=f,i):new u(a,o,s,f)},u.contains=function(e,r){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("cartographic is required.");return r.longitude>=e.west&&r.longitude<=e.east&&r.latitude>=e.south&&r.latitude<=e.north},u.isEmpty=function(e){if(!t(e))throw new n("rectangle is required");return e.west>=e.east||e.south>=e.north};var s=new e;return u.subsample=function(e,a,u,f){if(!t(e))throw new n("rectangle is required");a=r(a,i.WGS84),u=r(u,0),t(f)||(f=[]);var h=0,l=e.north,c=e.south,d=e.east,w=e.west,m=s;m.height=u,m.longitude=w,m.latitude=l,f[h]=a.cartographicToCartesian(m,f[h]),h++,m.longitude=d,f[h]=a.cartographicToCartesian(m,f[h]),h++,m.latitude=c,f[h]=a.cartographicToCartesian(m,f[h]),h++,m.longitude=w,f[h]=a.cartographicToCartesian(m,f[h]),h++,m.latitude=0>l?l:c>0?c:0;for(var p=1;8>p;++p){var y=-Math.PI+p*o.PI_OVER_TWO;y>w&&d>y&&(m.longitude=y,f[h]=a.cartographicToCartesian(m,f[h]),h++)}return 0===m.latitude&&(m.longitude=w,f[h]=a.cartographicToCartesian(m,f[h]),h++,m.longitude=d,f[h]=a.cartographicToCartesian(m,f[h]),h++),f.length=h,f},u.MAX_VALUE=a(new u(-Math.PI,-o.PI_OVER_TWO,Math.PI,o.PI_OVER_TWO)),u}),define("Core/BoundingRectangle",["./Cartesian2","./Cartographic","./defaultValue","./defined","./DeveloperError","./GeographicProjection","./Intersect","./Rectangle"],function(e,r,t,n,i,a,o,u){"use strict";var s=function(e,r,n,i){this.x=t(e,0),this.y=t(r,0),this.width=t(n,0),this.height=t(i,0)};s.fromPoints=function(e,r){if(n(r)||(r=new s),!n(e)||0===e.length)return r.x=0,r.y=0,r.width=0,r.height=0,r;for(var t=e.length,i=e[0].x,a=e[0].y,o=e[0].x,u=e[0].y,f=1;t>f;f++){var h=e[f],l=h.x,c=h.y;i=Math.min(l,i),o=Math.max(l,o),a=Math.min(c,a),u=Math.max(c,u)}return r.x=i,r.y=a,r.width=o-i,r.height=u-a,r};var f=new a,h=new r,l=new r;return s.fromRectangle=function(r,i,a){if(n(a)||(a=new s),!n(r))return a.x=0,a.y=0,a.width=0,a.height=0,a;i=t(i,f);var o=i.project(u.getSouthwest(r,h)),c=i.project(u.getNortheast(r,l));return e.subtract(c,o,c),a.x=o.x,a.y=o.y,a.width=c.x,a.height=c.y,a},s.clone=function(e,r){return n(e)?n(r)?(r.x=e.x,r.y=e.y,r.width=e.width,r.height=e.height,r):new s(e.x,e.y,e.width,e.height):void 0},s.union=function(e,r,t){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");n(t)||(t=new s);var a=Math.min(e.x,r.x),o=Math.min(e.y,r.y),u=Math.max(e.x+e.width,r.x+r.width),f=Math.max(e.y+e.height,r.y+r.height);return t.x=a,t.y=o,t.width=u-a,t.height=f-o,t},s.expand=function(e,r,t){if(!n(e))throw new i("rectangle is required.");if(!n(r))throw new i("point is required.");t=s.clone(e,t);var a=r.x-t.x,o=r.y-t.y;return a>t.width?t.width=a:0>a&&(t.width-=a,t.x=r.x),o>t.height?t.height=o:0>o&&(t.height-=o,t.y=r.y),t},s.intersect=function(e,r){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");var t=e.x,a=e.y,u=r.x,s=r.y;return t>u+r.width||t+e.width<u||a+e.height<s||a>s+r.height?o.OUTSIDE:o.INTERSECTING},s.equals=function(e,r){return e===r||n(e)&&n(r)&&e.x===r.x&&e.y===r.y&&e.width===r.width&&e.height===r.height},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.intersect=function(e){return s.intersect(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};i.fromElements=function(e,t,n,a,o){return r(o)?(o.x=e,o.y=t,o.z=n,o.w=a,o):new i(e,t,n,a)},i.fromColor=function(e,n){if(!r(e))throw new t("color is required");
return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a++]=n.z,i[a]=n.w},i.unpack=function(n,a,o){if(!r(n))throw new t("array is required");return a=e(a,0),r(o)||(o=new i),o.x=n[a++],o.y=n[a++],o.z=n[a++],o.w=n[a],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},i.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},i.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},i.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},i.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return i.subtract(e,n,a),i.magnitude(a)},i.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var a=i.magnitude(e);return n.x=e.x/a,n.y=e.y/a,n.z=e.z/a,n.w=e.w/a,n},i.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},i.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},i.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},i.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},i.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},i.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},i.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},i.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var o=new i;i.lerp=function(e,n,a,u){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof a)throw new t("t is required and must be a number.");if(!r(u))throw new t("result is required.");return i.multiplyByScalar(n,a,o),u=i.multiplyByScalar(e,1-a,u),i.add(o,u,u)};var u=new i;return i.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var a=i.normalize(e,u);return i.abs(a,a),n=a.x<=a.y?a.x<=a.z?a.x<=a.w?i.clone(i.UNIT_X,n):i.clone(i.UNIT_W,n):a.z<=a.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n):a.y<=a.z?a.y<=a.w?i.clone(i.UNIT_Y,n):i.clone(i.UNIT_W,n):a.z<=a.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},i.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i&&Math.abs(e.w-n.w)<=i},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,r){return i.equalsEpsilon(this,e,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a){"use strict";function o(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function u(e){for(var r=0,t=0;3>t;++t){var n=e[f.getElementIndex(d[t],c[t])];r+=2*n*n}return Math.sqrt(r)}function s(e,r){for(var t=a.EPSILON15,n=0,i=1,o=0;3>o;++o){var u=Math.abs(e[f.getElementIndex(d[o],c[o])]);u>n&&(i=o,n=u)}var s=1,h=0,l=c[i],w=d[i];if(Math.abs(e[f.getElementIndex(w,l)])>t){var m,p=e[f.getElementIndex(w,w)],y=e[f.getElementIndex(l,l)],g=e[f.getElementIndex(w,l)],v=(p-y)/2/g;m=0>v?-1/(-v+Math.sqrt(1+v*v)):1/(v+Math.sqrt(1+v*v)),s=1/Math.sqrt(1+m*m),h=m*s}return r=f.clone(f.IDENTITY,r),r[f.getElementIndex(l,l)]=r[f.getElementIndex(w,w)]=s,r[f.getElementIndex(w,l)]=h,r[f.getElementIndex(l,w)]=-h,r}var f=function(e,t,n,i,a,o,u,s,f){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(f,0)};f.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new f(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},f.fromArray=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new f),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a[9]=e[i+9],a},f.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},f.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,u=e.x*e.w,s=e.y*e.y,h=e.y*e.z,l=e.y*e.w,c=e.z*e.z,d=e.z*e.w,w=e.w*e.w,m=i-s-c+w,p=2*(a-d),y=2*(o+l),g=2*(a+d),v=-i+s-c+w,q=2*(h-u),x=2*(o-l),E=2*(h+u),b=-i-s+c+w;return t(r)?(r[0]=m,r[1]=g,r[2]=x,r[3]=p,r[4]=v,r[5]=E,r[6]=y,r[7]=q,r[8]=b,r):new f(m,p,y,g,v,q,x,E,b)},f.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new f(e.x,0,0,0,e.y,0,0,0,e.z)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new f(e,0,0,0,e,0,0,0,e)},f.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=a,r[6]=0,r[7]=-a,r[8]=i,r):new f(1,0,0,0,i,-a,0,a,i)},f.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=i,r):new f(i,0,a,0,1,0,-a,0,i)},f.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=a,r[2]=0,r[3]=-a,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new f(i,-a,0,a,i,0,0,0,1)},f.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},f.getColumn=function(r,i,a){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var o=3*i,u=r[o],s=r[o+1],f=r[o+2];return t(a)?(a.x=u,a.y=s,a.z=f,a):new e(u,s,f)},f.setColumn=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");a=f.clone(e,a);var o=3*r;return a[o]=i.x,a[o+1]=i.y,a[o+2]=i.z,a},f.getRow=function(r,i,a){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var o=r[i],u=r[i+3],s=r[i+6];return t(a)?(a.x=o,a.y=u,a.z=s,a):new e(o,u,s)},f.setRow=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");return a=f.clone(e,a),a[r]=i.x,a[r+3]=i.y,a[r+6]=i.z,a};var h=new e;f.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");return t(i)||(i=new e),i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],h)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],h)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],h)),i};var l=new e;f.getMaximumScale=function(r){return f.getScale(r,l),e.getMaximumComponent(l)},f.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");var a=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],o=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],u=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],h=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],l=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],c=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],d=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],w=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return t(i)?(i[0]=a,i[1]=o,i[2]=u,i[3]=s,i[4]=h,i[5]=l,i[6]=c,i[7]=d,i[8]=w,i):new f(a,s,c,o,h,d,u,l,w)},f.multiplyByVector=function(r,i,a){if(!t(r))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");var o=i.x,u=i.y,s=i.z,f=r[0]*o+r[3]*u+r[6]*s,h=r[1]*o+r[4]*u+r[7]*s,l=r[2]*o+r[5]*u+r[8]*s;return t(a)?(a.x=f,a.y=h,a.z=l,a):new e(f,h,l)},f.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");return t(i)?(i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i):new f(e[0]*r,e[3]*r,e[6]*r,e[1]*r,e[4]*r,e[7]*r,e[2]*r,e[5]*r,e[8]*r)},f.negate=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r):new f(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},f.transpose=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],a=e[3],o=e[6],u=e[1],s=e[4],h=e[7],l=e[2],c=e[5],d=e[8];return t(r)?(r[0]=i,r[1]=a,r[2]=o,r[3]=u,r[4]=s,r[5]=h,r[6]=l,r[7]=c,r[8]=d,r):new f(i,u,l,a,s,c,o,h,d)};var c=[1,0,0],d=[2,2,1],w=new f,m=new f;return f.getEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=a.EPSILON20,h=10,l=0,c=0;t(r)||(r={});for(var d=r.unitary=f.clone(f.IDENTITY,r.unitary),p=r.diagonal=f.clone(e,r.diagonal),y=i*o(p);h>c&&u(p)>y;)s(p,w),f.transpose(w,m),f.multiply(p,w,p),f.multiply(m,p,p),f.multiply(d,w,d),++l>2&&(++c,l=0);return r},f.abs=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r):new f(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},f.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],a=e[6],o=e[1],u=e[4],s=e[7],f=e[2],h=e[5],l=e[8];return r*(u*l-h*s)+o*(h*a-i*l)+f*(i*s-u*a)},f.inverse=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],o=e[1],u=e[2],s=e[3],h=e[4],l=e[5],c=e[6],d=e[7],w=e[8],m=f.determinant(e);if(Math.abs(m)<=a.EPSILON15)throw new n("matrix is not invertible");t(r)||(r=new f),r[0]=h*w-d*l,r[1]=d*u-o*w,r[2]=o*l-h*u,r[3]=c*l-s*w,r[4]=i*w-c*u,r[5]=s*u-i*l,r[6]=s*d-c*h,r[7]=c*o-i*d,r[8]=i*h-s*o;var p=1/m;return f.multiplyByScalar(r,p,r)},f.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},f.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},f.IDENTITY=i(new f(1,0,0,0,1,0,0,0,1)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN1ROW0=3,f.COLUMN1ROW1=4,f.COLUMN1ROW2=5,f.COLUMN2ROW0=6,f.COLUMN2ROW1=7,f.COLUMN2ROW2=8,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},f}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,a,o,u,s){"use strict";var f=function(e,r,n,i,a,o,u,s,f,h,l,c,d,w,m,p){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(f,0),this[3]=t(d,0),this[4]=t(r,0),this[5]=t(o,0),this[6]=t(h,0),this[7]=t(w,0),this[8]=t(n,0),this[9]=t(u,0),this[10]=t(l,0),this[11]=t(m,0),this[12]=t(i,0),this[13]=t(s,0),this[14]=t(c,0),this[15]=t(p,0)};f.packedLength=16,f.pack=function(e,r,a){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");a=t(a,0),r[a++]=e[0],r[a++]=e[1],r[a++]=e[2],r[a++]=e[3],r[a++]=e[4],r[a++]=e[5],r[a++]=e[6],r[a++]=e[7],r[a++]=e[8],r[a++]=e[9],r[a++]=e[10],r[a++]=e[11],r[a++]=e[12],r[a++]=e[13],r[a++]=e[14],r[a]=e[15]},f.unpack=function(e,r,a){if(!n(e))throw new i("array is required");return r=t(r,0),n(a)||(a=new f),a[0]=e[r++],a[1]=e[r++],a[2]=e[r++],a[3]=e[r++],a[4]=e[r++],a[5]=e[r++],a[6]=e[r++],a[7]=e[r++],a[8]=e[r++],a[9]=e[r++],a[10]=e[r++],a[11]=e[r++],a[12]=e[r++],a[13]=e[r++],a[14]=e[r++],a[15]=e[r],a},f.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(e,r,t){if(!n(e))throw new i("rotation is required.");if(!n(r))throw new i("translation is required.");return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=0,t[4]=e[3],t[5]=e[4],t[6]=e[5],t[7]=0,t[8]=e[6],t[9]=e[7],t[10]=e[8],t[11]=0,t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=1,t):new f(e[0],e[3],e[6],r.x,e[1],e[4],e[7],r.y,e[2],e[5],e[8],r.z,0,0,0,1)},new u,f.fromTranslationQuaternionRotationScale=function(e,r,t,a){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(a)||(a=new f);var o=t.x,u=t.y,s=t.z,h=r.x*r.x,l=r.x*r.y,c=r.x*r.z,d=r.x*r.w,w=r.y*r.y,m=r.y*r.z,p=r.y*r.w,y=r.z*r.z,g=r.z*r.w,v=r.w*r.w,q=h-w-y+v,x=2*(l-g),E=2*(c+p),b=2*(l+g),S=-h+w-y+v,M=2*(m-d),_=2*(c-p),O=2*(m+d),P=-h-w+y+v;return a[0]=q*o,a[1]=b*o,a[2]=_*o,a[3]=0,a[4]=x*u,a[5]=S*u,a[6]=O*u,a[7]=0,a[8]=E*s,a[9]=M*s,a[10]=P*s,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},f.fromTranslation=function(e,r){return f.fromRotationTranslation(u.IDENTITY,e,r)},f.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var h=new e,l=new e,c=new e;f.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var a=r.eye,o=r.target,u=r.up;if(!n(a))throw new i("camera.eye is required.");if(!n(o))throw new i("camera.target is required.");if(!n(u))throw new i("camera.up is required.");e.normalize(e.subtract(o,a,h),h),e.normalize(e.cross(h,u,l),l),e.normalize(e.cross(l,h,c),c);var s=l.x,d=l.y,w=l.z,m=h.x,p=h.y,y=h.z,g=c.x,v=c.y,q=c.z,x=a.x,E=a.y,b=a.z,S=s*-x+d*-E+w*-b,M=g*-x+v*-E+q*-b,_=m*x+p*E+y*b;return n(t)?(t[0]=s,t[1]=g,t[2]=-m,t[3]=0,t[4]=d,t[5]=v,t[6]=-p,t[7]=0,t[8]=w,t[9]=q,t[10]=-y,t[11]=0,t[12]=S,t[13]=M,t[14]=_,t[15]=1,t):new f(s,d,w,S,g,v,q,M,-m,-p,-y,_,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,r,t,a,o){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=a)throw new i("far must be greater than zero.");var u=Math.tan(.5*e),s=1/u,h=s/r,l=(a+t)/(t-a),c=2*a*t/(t-a);return n(o)?(o[0]=h,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=l,o[11]=-1,o[12]=0,o[13]=0,o[14]=c,o[15]=0,o):new f(h,0,0,0,0,s,0,0,0,0,l,c,0,0,-1,0)},f.computeOrthographicOffCenter=function(e,r,t,a,o,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(u))throw new i("far is required.");var h=1/(r-e),l=1/(a-t),c=1/(u-o),d=-(r+e)*h,w=-(a+t)*l,m=-(u+o)*c;return h*=2,l*=2,c*=-2,n(s)?(s[0]=h,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=l,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=c,s[11]=0,s[12]=d,s[13]=w,s[14]=m,s[15]=1,s):new f(h,0,0,d,0,l,0,w,0,0,c,m,0,0,0,1)},f.computePerspectiveOffCenter=function(e,r,t,a,o,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(u))throw new i("far is required.");var h=2*o/(r-e),l=2*o/(a-t),c=(r+e)/(r-e),d=(a+t)/(a-t),w=-(u+o)/(u-o),m=-1,p=-2*u*o/(u-o);return n(s)?(s[0]=h,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=l,s[6]=0,s[7]=0,s[8]=c,s[9]=d,s[10]=w,s[11]=m,s[12]=0,s[13]=0,s[14]=p,s[15]=0,s):new f(h,0,c,0,0,l,d,0,0,0,w,p,0,0,m,0)},f.computeInfinitePerspectiveOffCenter=function(e,r,t,a,o,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");var s=2*o/(r-e),h=2*o/(a-t),l=(r+e)/(r-e),c=(a+t)/(a-t),d=-1,w=-1,m=-2*o;return n(u)?(u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=h,u[6]=0,u[7]=0,u[8]=l,u[9]=c,u[10]=d,u[11]=w,u[12]=0,u[13]=0,u[14]=m,u[15]=0,u):new f(s,0,l,0,0,h,c,0,0,0,d,m,0,0,w,0)},f.computeViewportTransformation=function(e,r,i,a){e=t(e,t.EMPTY_OBJECT);var o=t(e.x,0),u=t(e.y,0),s=t(e.width,0),h=t(e.height,0);r=t(r,0),i=t(i,1);var l=.5*s,c=.5*h,d=.5*(i-r),w=l,m=c,p=d,y=o+l,g=u+c,v=r+d,q=1;return n(a)?(a[0]=w,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=m,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=p,a[11]=0,a[12]=y,a[13]=g,a[14]=v,a[15]=q,a):new f(w,0,0,y,0,m,0,g,0,0,p,v,0,0,0,q)},f.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},f.getColumn=function(e,t,a){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var o=4*t,u=e[o],s=e[o+1],f=e[o+2],h=e[o+3];return n(a)?(a.x=u,a.y=s,a.z=f,a.w=h,a):new r(u,s,f,h)},f.setColumn=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");a=f.clone(e,a);var o=4*r;return a[o]=t.x,a[o+1]=t.y,a[o+2]=t.z,a[o+3]=t.w,a},f.getRow=function(e,t,a){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var o=e[t],u=e[t+4],s=e[t+8],f=e[t+12];return n(a)?(a.x=o,a.y=u,a.z=s,a.w=f,a):new r(o,u,s,f)},f.setRow=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");return a=f.clone(e,a),a[r]=t.x,a[r+4]=t.y,a[r+8]=t.z,a[r+12]=t.w,a};var d=new e;f.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");return n(t)||(t=new e),t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],d)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],d)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],d)),t};var w=new e;f.getMaximumScale=function(r){return f.getScale(r,w),e.getMaximumComponent(w)},f.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var a=e[0],o=e[1],u=e[2],s=e[3],h=e[4],l=e[5],c=e[6],d=e[7],w=e[8],m=e[9],p=e[10],y=e[11],g=e[12],v=e[13],q=e[14],x=e[15],E=r[0],b=r[1],S=r[2],M=r[3],_=r[4],O=r[5],P=r[6],T=r[7],C=r[8],R=r[9],N=r[10],I=r[11],z=r[12],D=r[13],A=r[14],U=r[15],L=a*E+h*b+w*S+g*M,B=o*E+l*b+m*S+v*M,W=u*E+c*b+p*S+q*M,F=s*E+d*b+y*S+x*M,G=a*_+h*O+w*P+g*T,V=o*_+l*O+m*P+v*T,j=u*_+c*O+p*P+q*T,Y=s*_+d*O+y*P+x*T,k=a*C+h*R+w*N+g*I,H=o*C+l*R+m*N+v*I,Z=u*C+c*R+p*N+q*I,X=s*C+d*R+y*N+x*I,J=a*z+h*D+w*A+g*U,K=o*z+l*D+m*A+v*U,Q=u*z+c*D+p*A+q*U,$=s*z+d*D+y*A+x*U;return n(t)?(t[0]=L,t[1]=B,t[2]=W,t[3]=F,t[4]=G,t[5]=V,t[6]=j,t[7]=Y,t[8]=k,t[9]=H,t[10]=Z,t[11]=X,t[12]=J,t[13]=K,t[14]=Q,t[15]=$,t):new f(L,G,k,J,B,V,H,K,W,j,Z,Q,F,Y,X,$)},f.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var a=e[0],o=e[1],u=e[2],s=e[4],h=e[5],l=e[6],c=e[8],d=e[9],w=e[10],m=e[12],p=e[13],y=e[14],g=r[0],v=r[1],q=r[2],x=r[4],E=r[5],b=r[6],S=r[8],M=r[9],_=r[10],O=r[12],P=r[13],T=r[14],C=a*g+s*v+c*q,R=o*g+h*v+d*q,N=u*g+l*v+w*q,I=a*x+s*E+c*b,z=o*x+h*E+d*b,D=u*x+l*E+w*b,A=a*S+s*M+c*_,U=o*S+h*M+d*_,L=u*S+l*M+w*_,B=a*O+s*P+c*T+m,W=o*O+h*P+d*T+p,F=u*O+l*P+w*T+y;return n(t)?(t[0]=C,t[1]=R,t[2]=N,t[3]=0,t[4]=I,t[5]=z,t[6]=D,t[7]=0,t[8]=A,t[9]=U,t[10]=L,t[11]=0,t[12]=B,t[13]=W,t[14]=F,t[15]=1,t):new f(C,I,A,B,R,z,U,W,N,D,L,F,0,0,0,1)},f.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");var a=r.x,o=r.y,u=r.z,s=a*e[0]+o*e[4]+u*e[8]+e[12],h=a*e[1]+o*e[5]+u*e[9]+e[13],l=a*e[2]+o*e[6]+u*e[10]+e[14];return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=s,t[13]=h,t[14]=l,t[15]=e[15],t):new f(e[0],e[4],e[8],s,e[1],e[5],e[9],h,e[2],e[6],e[10],l,e[3],e[7],e[11],e[15])};var m=new e;return f.multiplyByUniformScale=function(e,r,t){if("number"!=typeof r)throw new i("scale is required");return m.x=r,m.y=r,m.z=r,f.multiplyByScale(e,m,t)},f.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");var a=r.x,o=r.y,u=r.z;return 1===a&&1===o&&1===u?f.clone(e,t):n(t)?(t[0]=a*e[0],t[1]=a*e[1],t[2]=a*e[2],t[3]=0,t[4]=o*e[4],t[5]=o*e[5],t[6]=o*e[6],t[7]=0,t[8]=u*e[8],t[9]=u*e[9],t[10]=u*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t):new f(a*e[0],o*e[4],u*e[8],e[12],a*e[1],o*e[5],u*e[9],e[13],a*e[2],o*e[6],u*e[10],e[14],0,0,0,1)},f.multiplyByVector=function(e,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,u=t.y,s=t.z,f=t.w,h=e[0]*o+e[4]*u+e[8]*s+e[12]*f,l=e[1]*o+e[5]*u+e[9]*s+e[13]*f,c=e[2]*o+e[6]*u+e[10]*s+e[14]*f,d=e[3]*o+e[7]*u+e[11]*s+e[15]*f;return n(a)?(a.x=h,a.y=l,a.z=c,a.w=d,a):new r(h,l,c,d)},f.multiplyByPointAsVector=function(r,t,a){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,u=t.y,s=t.z,f=r[0]*o+r[4]*u+r[8]*s,h=r[1]*o+r[5]*u+r[9]*s,l=r[2]*o+r[6]*u+r[10]*s;return n(a)?(a.x=f,a.y=h,a.z=l,a):new e(f,h,l)},f.multiplyByPoint=function(r,t,a){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,u=t.y,s=t.z,f=r[0]*o+r[4]*u+r[8]*s+r[12],h=r[1]*o+r[5]*u+r[9]*s+r[13],l=r[2]*o+r[6]*u+r[10]*s+r[14];return n(a)?(a.x=f,a.y=h,a.z=l,a):new e(f,h,l)},f.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");return n(t)?(t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t):new f(e[0]*r,e[4]*r,e[8]*r,e[12]*r,e[1]*r,e[5]*r,e[9]*r,e[13]*r,e[2]*r,e[6]*r,e[10]*r,e[14]*r,e[3]*r,e[7]*r,e[11]*r,e[15]*r)},f.negate=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r):new f(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},f.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))return new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var t=e[1],a=e[2],o=e[3],u=e[6],s=e[7],h=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=a,r[9]=u,r[10]=e[10],r[11]=e[14],r[12]=o,r[13]=s,r[14]=h,r[15]=e[15],r},f.abs=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r):new f(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},f.equals=function(e,r){return e===r||n(e)&&n(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[11]===r[11]&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[15]===r[15]},f.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},f.getTranslation=function(r,t){if(!n(r))throw new i("matrix is required");return n(t)?(t.x=r[12],t.y=r[13],t.z=r[14],t):new e(r[12],r[13],r[14])},f.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r):new u(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},f.inverse=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],a=e[4],u=e[8],h=e[12],l=e[1],c=e[5],d=e[9],w=e[13],m=e[2],p=e[6],y=e[10],g=e[14],v=e[3],q=e[7],x=e[11],E=e[15],b=y*E,S=g*x,M=p*E,_=g*q,O=p*x,P=y*q,T=m*E,C=g*v,R=m*x,N=y*v,I=m*q,z=p*v,D=b*c+_*d+O*w-(S*c+M*d+P*w),A=S*l+T*d+N*w-(b*l+C*d+R*w),U=M*l+C*c+I*w-(_*l+T*c+z*w),L=P*l+R*c+z*d-(O*l+N*c+I*d),B=S*a+M*u+P*h-(b*a+_*u+O*h),W=b*t+C*u+R*h-(S*t+T*u+N*h),F=_*t+T*a+z*h-(M*t+C*a+I*h),G=O*t+N*a+I*u-(P*t+R*a+z*u);b=u*w,S=h*d,M=a*w,_=h*c,O=a*d,P=u*c,T=t*w,C=h*l,R=t*d,N=u*l,I=t*c,z=a*l;var V=b*q+_*x+O*E-(S*q+M*x+P*E),j=S*v+T*x+N*E-(b*v+C*x+R*E),Y=M*v+C*q+I*E-(_*v+T*q+z*E),k=P*v+R*q+z*x-(O*v+N*q+I*x),H=M*y+P*g+S*p-(O*g+b*p+_*y),Z=R*g+b*m+C*y-(T*y+N*g+S*m),X=T*p+z*g+_*m-(I*g+M*m+C*p),J=I*y+O*m+N*p-(R*p+z*y+P*m),K=t*D+a*A+u*U+h*L;if(Math.abs(K)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return K=1/K,n(r)?(r[0]=D*K,r[1]=A*K,r[2]=U*K,r[3]=L*K,r[4]=B*K,r[5]=W*K,r[6]=F*K,r[7]=G*K,r[8]=V*K,r[9]=j*K,r[10]=Y*K,r[11]=k*K,r[12]=H*K,r[13]=Z*K,r[14]=X*K,r[15]=J*K,r):new f(D*K,B*K,V*K,H*K,A*K,W*K,j*K,Z*K,U*K,F*K,Y*K,X*K,L*K,G*K,k*K,J*K)},f.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],a=e[1],o=e[2],u=e[4],s=e[5],h=e[6],l=e[8],c=e[9],d=e[10],w=e[12],m=e[13],p=e[14],y=-t*w-a*m-o*p,g=-u*w-s*m-h*p,v=-l*w-c*m-d*p;return n(r)?(r[0]=t,r[1]=u,r[2]=l,r[3]=0,r[4]=a,r[5]=s,r[6]=c,r[7]=0,r[8]=o,r[9]=h,r[10]=d,r[11]=0,r[12]=y,r[13]=g,r[14]=v,r[15]=1,r):new f(t,a,o,y,u,s,h,g,l,c,d,v,0,0,0,1)},f.IDENTITY=a(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,r,t,n,i,a,o,u,s,f,h){"use strict";var l=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},c=new e,d=new e,w=new e,m=new e,p=new e,y=new e,g=new e,v=new e,q=new e,x=new e,E=new e,b=new e;
l.fromPoints=function(r,t){if(n(t)||(t=new l),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],g),a=e.clone(i,c),o=e.clone(i,d),u=e.clone(i,w),s=e.clone(i,m),f=e.clone(i,p),h=e.clone(i,y),S=r.length,M=1;S>M;M++){e.clone(r[M],i);var _=i.x,O=i.y,P=i.z;_<a.x&&e.clone(i,a),_>s.x&&e.clone(i,s),O<o.y&&e.clone(i,o),O>f.y&&e.clone(i,f),P<u.z&&e.clone(i,u),P>h.z&&e.clone(i,h)}var T=e.magnitudeSquared(e.subtract(s,a,v)),C=e.magnitudeSquared(e.subtract(f,o,v)),R=e.magnitudeSquared(e.subtract(h,u,v)),N=a,I=s,z=T;C>z&&(z=C,N=o,I=f),R>z&&(z=R,N=u,I=h);var D=q;D.x=.5*(N.x+I.x),D.y=.5*(N.y+I.y),D.z=.5*(N.z+I.z);var A=e.magnitudeSquared(e.subtract(I,D,v)),U=Math.sqrt(A),L=x;L.x=a.x,L.y=o.y,L.z=u.z;var B=E;B.x=s.x,B.y=f.y,B.z=h.z;var W=e.multiplyByScalar(e.add(L,B,v),.5,b),F=0;for(M=0;S>M;M++){e.clone(r[M],i);var G=e.magnitude(e.subtract(i,W,v));G>F&&(F=G);var V=e.magnitudeSquared(e.subtract(i,D,v));if(V>A){var j=Math.sqrt(V);U=.5*(U+j),A=U*U;var Y=j-U;D.x=(U*D.x+Y*i.x)/j,D.y=(U*D.y+Y*i.y)/j,D.z=(U*D.z+Y*i.z)/j}}return F>U?(e.clone(D,t.center),t.radius=U):(e.clone(W,t.center),t.radius=F),t};var S=new o,M=new e,_=new e,O=new r,P=new r;l.fromRectangle2D=function(e,r,t){return l.fromRectangleWithHeights2D(e,r,0,0,t)},l.fromRectangleWithHeights2D=function(r,i,a,o,u){if(n(u)||(u=new l),!n(r))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=t(i,S),h.getSouthwest(r,O),O.height=a,h.getNortheast(r,P),P.height=o;var s=i.project(O,M),f=i.project(P,_),c=f.x-s.x,d=f.y-s.y,w=f.z-s.z;u.radius=.5*Math.sqrt(c*c+d*d+w*w);var m=u.center;return m.x=s.x+.5*c,m.y=s.y+.5*d,m.z=s.z+.5*w,u};var T=[];l.fromRectangle3D=function(e,r,i,o){r=t(r,a.WGS84),i=t(i,0);var u;return n(e)&&(u=h.subsample(e,r,i,T)),l.fromPoints(u,o)},l.fromVertices=function(r,a,o,u){if(n(u)||(u=new l),!n(r)||0===r.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;if(a=t(a,e.ZERO),o=t(o,3),3>o)throw new i("stride must be 3 or greater.");var s=g;s.x=r[0]+a.x,s.y=r[1]+a.y,s.z=r[2]+a.z;for(var f=e.clone(s,c),h=e.clone(s,d),S=e.clone(s,w),M=e.clone(s,m),_=e.clone(s,p),O=e.clone(s,y),P=r.length,T=0;P>T;T+=o){var C=r[T]+a.x,R=r[T+1]+a.y,N=r[T+2]+a.z;s.x=C,s.y=R,s.z=N,C<f.x&&e.clone(s,f),C>M.x&&e.clone(s,M),R<h.y&&e.clone(s,h),R>_.y&&e.clone(s,_),N<S.z&&e.clone(s,S),N>O.z&&e.clone(s,O)}var I=e.magnitudeSquared(e.subtract(M,f,v)),z=e.magnitudeSquared(e.subtract(_,h,v)),D=e.magnitudeSquared(e.subtract(O,S,v)),A=f,U=M,L=I;z>L&&(L=z,A=h,U=_),D>L&&(L=D,A=S,U=O);var B=q;B.x=.5*(A.x+U.x),B.y=.5*(A.y+U.y),B.z=.5*(A.z+U.z);var W=e.magnitudeSquared(e.subtract(U,B,v)),F=Math.sqrt(W),G=x;G.x=f.x,G.y=h.y,G.z=S.z;var V=E;V.x=M.x,V.y=_.y,V.z=O.z;var j=e.multiplyByScalar(e.add(G,V,v),.5,b),Y=0;for(T=0;P>T;T+=o){s.x=r[T]+a.x,s.y=r[T+1]+a.y,s.z=r[T+2]+a.z;var k=e.magnitude(e.subtract(s,j,v));k>Y&&(Y=k);var H=e.magnitudeSquared(e.subtract(s,B,v));if(H>W){var Z=Math.sqrt(H);F=.5*(F+Z),W=F*F;var X=Z-F;B.x=(F*B.x+X*s.x)/Z,B.y=(F*B.y+X*s.y)/Z,B.z=(F*B.z+X*s.z)/Z}}return Y>F?(e.clone(B,u.center),u.radius=F):(e.clone(j,u.center),u.radius=Y),u},l.fromCornerPoints=function(r,t,a){if(!n(r)||!n(t))throw new i("corner and oppositeCorner are required.");n(a)||(a=new l);var o=a.center;return e.add(r,t,o),e.multiplyByScalar(o,.5,o),a.radius=e.distance(o,t),a},l.fromEllipsoid=function(r,t){if(!n(r))throw new i("ellipsoid is required.");return n(t)||(t=new l),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t},l.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new l(r.center,r.radius):void 0},l.packedLength=4,l.pack=function(e,r,a){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");a=t(a,0);var o=e.center;r[a++]=o.x,r[a++]=o.y,r[a++]=o.z,r[a]=e.radius},l.unpack=function(e,r,a){if(!n(e))throw new i("array is required");r=t(r,0),n(a)||(a=new l);var o=a.center;return o.x=e[r++],o.y=e[r++],o.z=e[r++],a.radius=e[r],a};var C=new e,R=new e;l.union=function(r,t,a){if(!n(r))throw new i("left is required.");if(!n(t))throw new i("right is required.");n(a)||(a=new l);var o=r.center,u=t.center;e.add(o,u,R);var s=e.multiplyByScalar(R,.5,R),f=e.magnitude(e.subtract(o,s,C))+r.radius,h=e.magnitude(e.subtract(u,s,C))+t.radius;return a.radius=Math.max(f,h),e.clone(s,a.center),a};var N=new e;l.expand=function(r,t,a){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("point is required.");a=l.clone(r,a);var o=e.magnitude(e.subtract(t,a.center,N));return o>a.radius&&(a.radius=o),a},l.intersect=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("plane is required.");var a=r.center,o=r.radius,s=e.dot(t,a)+t.w;return-o>s?u.OUTSIDE:o>s?u.INTERSECTING:u.INSIDE},l.transform=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new l),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=f.getMaximumScale(r)*e.radius,t};var I=new e;l.distanceSquaredTo=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("cartesian is required.");var a=e.subtract(r.center,t,I);return e.magnitudeSquared(a)-r.radius*r.radius},l.transformWithoutScale=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new l),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var z=new e;l.getPlaneDistances=function(r,t,a,o){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("position is required.");if(!n(a))throw new i("direction is required.");n(o)||(o=new s);var u=e.subtract(r.center,t,z),f=e.multiplyByScalar(a,e.dot(a,u),z),h=e.magnitude(f);return o.start=h-r.radius,o.stop=h+r.radius,o};for(var D=new e,A=new e,U=new e,L=new e,B=new e,W=new r,F=new Array(8),G=0;8>G;++G)F[G]=new e;var V=new o;return l.projectTo2D=function(r,a,o){if(!n(r))throw new i("sphere is required.");a=t(a,V);var u=a.ellipsoid,s=r.center,f=r.radius,h=u.geodeticSurfaceNormal(s,D),c=e.cross(e.UNIT_Z,h,A);e.normalize(c,c);var d=e.cross(h,c,U);e.normalize(d,d),e.multiplyByScalar(h,f,h),e.multiplyByScalar(d,f,d),e.multiplyByScalar(c,f,c);var w=e.negate(d,B),m=e.negate(c,L),p=F,y=p[0];e.add(h,d,y),e.add(y,c,y),y=p[1],e.add(h,d,y),e.add(y,m,y),y=p[2],e.add(h,w,y),e.add(y,m,y),y=p[3],e.add(h,w,y),e.add(y,c,y),e.negate(h,h),y=p[4],e.add(h,d,y),e.add(y,c,y),y=p[5],e.add(h,d,y),e.add(y,m,y),y=p[6],e.add(h,w,y),e.add(y,m,y),y=p[7],e.add(h,w,y),e.add(y,c,y);for(var g=p.length,v=0;g>v;++v){var q=p[v];e.add(s,q,q);var x=u.cartesianToCartographic(q,W);a.project(x,q)}o=l.fromPoints(p,o),s=o.center;var E=s.x,b=s.y,S=s.z;return s.x=S,s.y=E,s.z=b,o},l.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius},l.prototype.intersect=function(e){return l.intersect(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.clone=function(e){return l.clone(this,e)},l}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;u>o;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=s+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=s+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=s+"fullscreenchange",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(c)){var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null===e?c=!1:(c=!0,d=n(e[1]))}return c}function a(){return i()&&d}function o(){if(!r(w))if(i()||!/ Safari\/[\.0-9]+/.test(navigator.userAgent))w=!1;else{var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null===e?w=!1:(w=!0,m=n(e[1]))}return w}function u(){return o()&&m}function s(){if(!r(p)){var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null===e?p=!1:(p=!0,y=n(e[1]),y.isNightly=!!e[2])}return p}function f(){return s()&&y}function h(){if(!r(g)){var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(g=!0,v=n(e[1]))):"Netscape"===navigator.appName?(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(g=!0,v=n(e[1]))):g=!1}return g}function l(){return h()&&v}var c,d,w,m,p,y,g,v,q={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:f,isInternetExplorer:h,internetExplorerVersion:l,hardwareConcurrency:e(navigator.hardwareConcurrency,3)};return q.supportsFullscreen=function(){return t.supportsFullscreen()},q.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},q}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection"],function(e,r,t,n){"use strict";if(!n.supportsTypedArrays())return{};var i={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return i.getSizeInBytes=function(e){if(!r(e))throw new t("value is required.");switch(e){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new t("componentDatatype is not a valid value.")}},i.fromTypedArray=function(e){return e instanceof Int8Array?i.BYTE:e instanceof Uint8Array?i.UNSIGNED_BYTE:e instanceof Int16Array?i.SHORT:e instanceof Uint16Array?i.UNSIGNED_SHORT:e instanceof Float32Array?i.FLOAT:e instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(e){return r(e)&&(e===i.BYTE||e===i.UNSIGNED_BYTE||e===i.SHORT||e===i.UNSIGNED_SHORT||e===i.FLOAT||e===i.DOUBLE)},i.createTypedArray=function(e,n){if(!r(e))throw new t("componentDatatype is required.");if(!r(n))throw new t("valuesOrLength is required.");switch(e){case i.BYTE:return new Int8Array(n);case i.UNSIGNED_BYTE:return new Uint8Array(n);case i.SHORT:return new Int16Array(n);case i.UNSIGNED_SHORT:return new Uint16Array(n);case i.FLOAT:return new Float32Array(n);case i.DOUBLE:return new Float64Array(n);default:throw new t("componentDatatype is not a valid value.")}},i.createArrayBufferView=function(n,a,o,u){if(!r(n))throw new t("componentDatatype is required.");if(!r(a))throw new t("buffer is required.");switch(o=e(o,0),u=e(u,(a.byteLength-o)/i.getSizeInBytes(n)),n){case i.BYTE:return new Int8Array(a,o,u);case i.UNSIGNED_BYTE:return new Uint8Array(a,o,u);case i.SHORT:return new Int16Array(a,o,u);case i.UNSIGNED_SHORT:return new Uint16Array(a,o,u);case i.FLOAT:return new Float32Array(a,o,u);case i.DOUBLE:return new Float64Array(a,o,u);default:throw new t("componentDatatype is not a valid value.")}},i}),define("Core/CornerType",[],function(){"use strict";var e={ROUNDED:0,MITERED:1,BEVELED:2};return e}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.attributes))throw new t("options.attributes is required.");if(!r(n.primitiveType))throw new t("options.primitiveType is required.");this.attributes=n.attributes,this.indices=n.indices,this.primitiveType=n.primitiveType,this.boundingSphere=n.boundingSphere};return n.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&r(e.attributes[i])&&r(e.attributes[i].values)){var a=e.attributes[i],o=a.values.length/a.componentsPerAttribute;if(n!==o&&-1!==n)throw new t("All attribute lists must have the same number of attributes.");n=o}return n},n}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(n.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(n.values))throw new t("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/IndexDatatype",["./defined","./DeveloperError","./Math"],function(e,r,t){"use strict";var n={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return n.getSizeInBytes=function(e){switch(e){case n.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case n.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case n.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new r("indexDatatype is required and must be a valid IndexDatatype constant.")},n.validate=function(r){return e(r)&&(r===n.UNSIGNED_BYTE||r===n.UNSIGNED_SHORT||r===n.UNSIGNED_INT)},n.createTypedArray=function(n,i){if(!e(n))throw new r("numberOfVertices is required.");return n>t.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},n}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Intersect"],function(e,r,t,n,i){"use strict";var a=function(n,i,a){this.minimum=e.clone(r(n,e.ZERO)),this.maximum=e.clone(r(i,e.ZERO)),t(a)?a=e.clone(a):(a=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(a,.5,a)),this.center=a};a.fromPoints=function(r,n){if(t(n)||(n=new a),!t(r)||0===r.length)return n.minimum=e.clone(e.ZERO,n.minimum),n.maximum=e.clone(e.ZERO,n.maximum),n.center=e.clone(e.ZERO,n.center),n;for(var i=r[0].x,o=r[0].y,u=r[0].z,s=r[0].x,f=r[0].y,h=r[0].z,l=r.length,c=1;l>c;c++){var d=r[c],w=d.x,m=d.y,p=d.z;i=Math.min(w,i),s=Math.max(w,s),o=Math.min(m,o),f=Math.max(m,f),u=Math.min(p,u),h=Math.max(p,h)}var y=n.minimum;y.x=i,y.y=o,y.z=u;var g=n.maximum;g.x=s,g.y=f,g.z=h;var v=e.add(y,g,n.center);return e.multiplyByScalar(v,.5,v),n},a.clone=function(r,n){return t(r)?t(n)?(n.minimum=e.clone(r.minimum,n.minimum),n.maximum=e.clone(r.maximum,n.maximum),n.center=e.clone(r.center,n.center),n):new a(r.minimum,r.maximum):void 0},a.equals=function(r,n){return r===n||t(r)&&t(n)&&e.equals(r.center,n.center)&&e.equals(r.minimum,n.minimum)&&e.equals(r.maximum,n.maximum)};var o=new e;return a.intersect=function(r,a){if(!t(r))throw new n("box is required.");if(!t(a))throw new n("plane is required.");o=e.subtract(r.maximum,r.minimum,o);var u=e.multiplyByScalar(o,.5,o),s=u.x*Math.abs(a.x)+u.y*Math.abs(a.y)+u.z*Math.abs(a.z),f=e.dot(r.center,a)+a.w;return f-s>0?i.INSIDE:0>f+s?i.OUTSIDE:i.INTERSECTING},a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.intersect=function(e){return a.intersect(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,r){"use strict";function t(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}var n={};return n.discriminant=function(r,t,n){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=t*t-4*r*n;return i},n.realRoots=function(n,i,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");var o;if(0===n)return 0===i?[]:[-a/i];if(0===i){if(0===a)return[0,0];var u=Math.abs(a),s=Math.abs(n);if(s>u&&u/s<r.EPSILON14)return[0,0];if(u>s&&s/u<r.EPSILON14)return[];if(o=-a/n,0>o)return[];var f=Math.sqrt(o);return[-f,f]}if(0===a)return o=-i/n,0>o?[o,0]:[0,o];var h=i*i,l=4*n*a,c=t(h,-l,r.EPSILON14);if(0>c)return[];var d=-.5*t(i,r.sign(i)*Math.sqrt(c),r.EPSILON14);return i>0?[d/n,a/d]:[a/d,d/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,r){"use strict";function t(e,r,t,n){var i,a,o=e,u=r/3,s=t/3,f=n,h=o*s,l=u*f,c=u*u,d=s*s,w=o*s-c,m=o*f-u*s,p=u*f-d,y=4*w*p-m*m;if(0>y){var g,v,q;c*l>=h*d?(g=o,v=w,q=-2*u*w+o*m):(g=f,v=p,q=-f*m+2*s*p);var x=0>q?-1:1,E=-x*Math.abs(g)*Math.sqrt(-y);a=-q+E;var b=a/2,S=0>b?-Math.pow(-b,1/3):Math.pow(b,1/3),M=a===E?-S:-v/S;return i=0>=v?S+M:-q/(S*S+M*M+v),c*l>=h*d?[(i-u)/o]:[-f/(i+s)]}var _=w,O=-2*u*w+o*m,P=p,T=-f*m+2*s*p,C=Math.sqrt(y),R=Math.sqrt(3)/2,N=Math.abs(Math.atan2(o*C,-O)/3);i=2*Math.sqrt(-_);var I=Math.cos(N);a=i*I;var z=i*(-I/2-R*Math.sin(N)),D=a+z>2*u?a-u:z-u,A=o,U=D/A;N=Math.abs(Math.atan2(f*C,-T)/3),i=2*Math.sqrt(-P),I=Math.cos(N),a=i*I,z=i*(-I/2-R*Math.sin(N));var L=-f,B=2*s>a+z?a+s:z+s,W=L/B,F=A*B,G=-D*B-A*L,V=D*L,j=(s*G-u*V)/(-u*G+s*F);return j>=U?W>=U?W>=j?[U,j,W]:[U,W,j]:[W,U,j]:W>=U?[j,U,W]:W>=j?[j,W,U]:[W,j,U]}var n={};return n.discriminant=function(r,t,n,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var a=r*r,o=t*t,u=n*n,s=i*i,f=18*r*t*n*i+o*u-27*a*s-4*(r*u*n+o*t*i);return f},n.realRoots=function(n,i,a,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var u,s;if(0===n)return r.realRoots(i,a,o);if(0===i){if(0===a){if(0===o)return[0,0,0];s=-o/n;var f=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[f,f,f]}return 0===o?(u=r.realRoots(n,0,a),0===u.Length?[0]:[u[0],0,u[1]]):t(n,0,a,o)}return 0===a?0===o?(s=-i/n,0>s?[s,0,0]:[0,0,s]):t(n,i,0,o):0===o?(u=r.realRoots(n,i,a),0===u.length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]):t(n,i,a,o)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,r,t,n){"use strict";function i(r,i,a,o){var u=r*r,s=i-3*u/8,f=a-i*r/2+u*r/8,h=o-a*r/4+i*u/16-3*u*u/256,l=e.realRoots(1,2*s,s*s-4*h,-f*f);if(l.length>0){var c=-r/4,d=l[l.length-1];if(Math.abs(d)<t.EPSILON14){var w=n.realRoots(1,s,h);if(2===w.length){var m,p=w[0],y=w[1];if(p>=0&&y>=0){var g=Math.sqrt(p),v=Math.sqrt(y);return[c-v,c-g,c+g,c+v]}if(p>=0&&0>y)return m=Math.sqrt(p),[c-m,c+m];if(0>p&&y>=0)return m=Math.sqrt(y),[c-m,c+m]}return[]}if(d>0){var q=Math.sqrt(d),x=(s+d-f/q)/2,E=(s+d+f/q)/2,b=n.realRoots(1,q,x),S=n.realRoots(1,-q,E);return 0!==b.length?(b[0]+=c,b[1]+=c,0!==S.length?(S[0]+=c,S[1]+=c,b[1]<=S[0]?[b[0],b[1],S[0],S[1]]:S[1]<=b[0]?[S[0],S[1],b[0],b[1]]:b[0]>=S[0]&&b[1]<=S[1]?[S[0],b[0],b[1],S[1]]:S[0]>=b[0]&&S[1]<=b[1]?[b[0],S[0],S[1],b[1]]:b[0]>S[0]&&b[0]<S[1]?[S[0],b[0],S[1],b[1]]:[b[0],S[0],b[1],S[1]]):b):0!==S.length?(S[0]+=c,S[1]+=c,S):[]}}return[]}function a(r,i,a,o){var u=a*a,s=i*i,f=r*r,h=-2*i,l=a*r+s-4*o,c=f*o-a*i*r+u,d=e.realRoots(1,h,l,c);if(d.length>0){var w,m,p=d[0],y=i-p,g=y*y,v=r/2,q=y/2,x=g-4*o,E=g+4*Math.abs(o),b=f-4*p,S=f+4*Math.abs(p);if(0>p||b*E>x*S){var M=Math.sqrt(b);w=M/2,m=0===M?0:(r*q-a)/M}else{var _=Math.sqrt(x);w=0===_?0:(r*q-a)/_,m=_/2}var O,P;0===v&&0===w?(O=0,P=0):t.sign(v)===t.sign(w)?(O=v+w,P=p/O):(P=v-w,O=p/P);var T,C;0===q&&0===m?(T=0,C=0):t.sign(q)===t.sign(m)?(T=q+m,C=o/T):(C=q-m,T=o/C);var R=n.realRoots(1,O,T),N=n.realRoots(1,P,C);if(0!==R.length)return 0!==N.length?R[1]<=N[0]?[R[0],R[1],N[0],N[1]]:N[1]<=R[0]?[N[0],N[1],R[0],R[1]]:R[0]>=N[0]&&R[1]<=N[1]?[N[0],R[0],R[1],N[1]]:N[0]>=R[0]&&N[1]<=R[1]?[R[0],N[0],N[1],R[1]]:R[0]>N[0]&&R[0]<N[1]?[N[0],R[0],N[1],R[1]]:[R[0],N[0],R[1],N[1]]:R;if(0!==N.length)return N}return[]}var o={};return o.discriminant=function(e,t,n,i,a){if("number"!=typeof e)throw new r("a is a required number.");if("number"!=typeof t)throw new r("b is a required number.");if("number"!=typeof n)throw new r("c is a required number.");if("number"!=typeof i)throw new r("d is a required number.");if("number"!=typeof a)throw new r("e is a required number.");var o=e*e,u=o*e,s=t*t,f=s*t,h=n*n,l=h*n,c=i*i,d=c*i,w=a*a,m=w*a,p=s*h*c-4*f*d-4*e*l*c+18*e*t*n*d-27*o*c*c+256*u*m+a*(18*f*n*i-4*s*l+16*e*h*h-80*e*t*h*i-6*e*s*c+144*o*n*c)+w*(144*e*s*n-27*s*s-128*o*h-192*o*t*i);return p},o.realRoots=function(n,o,u,s,f){if("number"!=typeof n)throw new r("a is a required number.");if("number"!=typeof o)throw new r("b is a required number.");if("number"!=typeof u)throw new r("c is a required number.");if("number"!=typeof s)throw new r("d is a required number.");if("number"!=typeof f)throw new r("e is a required number.");if(Math.abs(n)<t.EPSILON15)return e.realRoots(o,u,s,f);var h=o/n,l=u/n,c=s/n,d=f/n,w=0>h?1:0;switch(w+=0>l?w+1:w,w+=0>c?w+1:w,w+=0>d?w+1:w){case 0:return i(h,l,c,d);case 1:return a(h,l,c,d);case 2:return a(h,l,c,d);case 3:return i(h,l,c,d);case 4:return i(h,l,c,d);case 5:return a(h,l,c,d);case 6:return i(h,l,c,d);case 7:return i(h,l,c,d);case 8:return a(h,l,c,d);case 9:return i(h,l,c,d);case 10:return i(h,l,c,d);case 11:return a(h,l,c,d);case 12:return i(h,l,c,d);case 13:return i(h,l,c,d);case 14:return i(h,l,c,d);case 15:return i(h,l,c,d);default:return void 0}},o}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial"],function(e,r,t,n,i,a,o,u){"use strict";function s(e,r,t){var n=e+r;return i.sign(e)!==i.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<t?0:n}function f(r,t,n,f,h){var l,c=f*f,d=h*h,w=(r[a.COLUMN1ROW1]-r[a.COLUMN2ROW2])*d,m=h*(f*s(r[a.COLUMN1ROW0],r[a.COLUMN0ROW1],i.EPSILON15)+t.y),p=r[a.COLUMN0ROW0]*c+r[a.COLUMN2ROW2]*d+f*t.x+n,y=d*s(r[a.COLUMN2ROW1],r[a.COLUMN1ROW2],i.EPSILON15),g=h*(f*s(r[a.COLUMN2ROW0],r[a.COLUMN0ROW2])+t.z),v=[];if(0===g&&0===y){if(l=o.realRoots(w,m,p),0===l.length)return v;var q=l[0],x=Math.sqrt(Math.max(1-q*q,0));if(v.push(new e(f,h*q,h*-x)),v.push(new e(f,h*q,h*x)),2===l.length){var E=l[1],b=Math.sqrt(Math.max(1-E*E,0));v.push(new e(f,h*E,h*-b)),v.push(new e(f,h*E,h*b))}return v}var S=g*g,M=y*y,_=w*w,O=g*y,P=_+M,T=2*(m*w+O),C=2*p*w+m*m-M+S,R=2*(p*m-O),N=p*p-S;if(0===P&&0===T&&0===C&&0===R)return v;l=u.realRoots(P,T,C,R,N);var I=l.length;if(0===I)return v;for(var z=0;I>z;++z){var D,A=l[z],U=A*A,L=Math.max(1-U,0),B=Math.sqrt(L);D=i.sign(w)===i.sign(p)?s(w*U+p,m*A,i.EPSILON12):i.sign(p)===i.sign(m*A)?s(w*U,m*A+p,i.EPSILON12):s(w*U+m*A,p,i.EPSILON12);var W=s(y*A,g,i.EPSILON15),F=D*W;0>F?v.push(new e(f,h*A,h*B)):F>0?v.push(new e(f,h*A,h*-B)):0!==B?(v.push(new e(f,h*A,h*-B)),v.push(new e(f,h*A,h*B)),++z):v.push(new e(f,h*A,h*B))}return v}var h={};h.rayPlane=function(r,a,o){if(!t(r))throw new n("ray is required.");if(!t(a))throw new n("plane is required.");t(o)||(o=new e);var u=r.origin,s=r.direction,f=a.normal,h=e.dot(f,s);if(Math.abs(h)<i.EPSILON15)return void 0;var l=(-a.distance-e.dot(f,u))/h;return 0>l?void 0:(o=e.multiplyByScalar(s,l,o),e.add(u,o,o))};var l=new e,c=new e;h.rayEllipsoid=function(r,i){if(!t(r))throw new n("ray is required.");if(!t(i))throw new n("ellipsoid is required.");var a,o,u,s,f,h=i.oneOverRadii,d=e.multiplyComponents(h,r.origin,l),w=e.multiplyComponents(h,r.direction,c),m=e.magnitudeSquared(d),p=e.dot(d,w);if(m>1){if(p>=0)return void 0;var y=p*p;if(a=m-1,o=e.magnitudeSquared(w),u=o*a,u>y)return void 0;if(y>u){s=p*p-u,f=-p+Math.sqrt(s);var g=f/o,v=a/f;return v>g?{start:g,stop:v}:{start:v,stop:g}}var q=Math.sqrt(a/o);return{start:q,stop:q}}return 1>m?(a=m-1,o=e.magnitudeSquared(w),u=o*a,s=p*p-u,f=-p+Math.sqrt(s),{start:0,stop:f/o}):0>p?(o=e.magnitudeSquared(w),{start:0,stop:-p/o}):void 0};var d=new e,w=new e,m=new e,p=new e;h.grazingAltitudeLocation=function(o,u){if(!t(o))throw new n("ray is required.");if(!t(u))throw new n("ellipsoid is required.");var s=o.origin,h=o.direction,l=u.geodeticSurfaceNormal(s);if(e.dot(h,l)>=0)return s;var c,y,g=t(this.rayEllipsoid(o,u)),v=u.transformPositionToScaledSpace(h),q=e.normalize(v,d),x=e.mostOrthogonalAxis(v,p),E=e.normalize(e.cross(x,q,w),w),b=e.normalize(e.cross(q,E,m),m),S=new a(q.x,E.x,b.x,q.y,E.y,b.y,q.z,E.z,b.z),M=a.transpose(S),_=a.fromScale(u.radii),O=a.fromScale(u.oneOverRadii),P=new a(0,h.z,-h.y,-h.z,0,h.x,h.y,-h.x,0),T=a.multiply(a.multiply(M,O),P),C=a.multiply(a.multiply(T,_),S),R=a.multiplyByVector(T,s),N=f(C,e.negate(R,d),0,0,1),I=N.length;if(I>0){for(var z=e.ZERO,D=Number.NEGATIVE_INFINITY,A=0;I>A;++A){c=a.multiplyByVector(_,a.multiplyByVector(S,N[A]));var U=e.normalize(e.subtract(c,s,p),p),L=e.dot(U,h);L>D&&(D=L,z=c)}var B=u.cartesianToCartographic(z);return D=i.clamp(D,0,1),y=e.magnitude(e.subtract(z,s,p))*Math.sqrt(1-D*D),y=g?-y:y,u.cartographicToCartesian(new r(B.longitude,B.latitude,y))}return void 0};var y=new e;return h.lineSegmentPlane=function(r,a,o,u){if(!t(r))throw new n("endPoint0 is required.");if(!t(a))throw new n("endPoint1 is required.");if(!t(o))throw new n("plane is required.");t(u)||(u=new e);var s=e.subtract(a,r,y),f=o.normal,h=e.dot(f,s);if(Math.abs(h)<i.EPSILON6)return void 0;var l=e.dot(f,r),c=-(o.distance+l)/h;return 0>c||c>1?void 0:(e.multiplyByScalar(s,c,u),e.add(r,u,u),u)},h.trianglePlaneIntersection=function(r,i,a,o){if(!(t(r)&&t(i)&&t(a)&&t(o)))throw new n("p0, p1, p2, and plane are required.");var u=o.normal,s=o.distance,f=e.dot(u,r)+s<0,l=e.dot(u,i)+s<0,c=e.dot(u,a)+s<0,d=0;d+=f?1:0,d+=l?1:0,d+=c?1:0;var w,m;if((1===d||2===d)&&(w=new e,m=new e),1===d){if(f)return h.lineSegmentPlane(r,i,o,w),h.lineSegmentPlane(r,a,o,m),{positions:[r,i,a,w,m],indices:[0,3,4,1,2,4,1,4,3]};if(l)return h.lineSegmentPlane(i,a,o,w),h.lineSegmentPlane(i,r,o,m),{positions:[r,i,a,w,m],indices:[1,3,4,2,0,4,2,4,3]};if(c)return h.lineSegmentPlane(a,r,o,w),h.lineSegmentPlane(a,i,o,m),{positions:[r,i,a,w,m],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===d){if(!f)return h.lineSegmentPlane(i,r,o,w),h.lineSegmentPlane(a,r,o,m),{positions:[r,i,a,w,m],indices:[1,2,4,1,4,3,0,3,4]};if(!l)return h.lineSegmentPlane(a,i,o,w),h.lineSegmentPlane(r,i,o,m),{positions:[r,i,a,w,m],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return h.lineSegmentPlane(r,a,o,w),h.lineSegmentPlane(i,a,o,m),{positions:[r,i,a,w,m],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},h}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n,i){if(!r(n))throw new t("normal is required.");if(!r(i))throw new t("distance is required.");this.normal=e.clone(n),this.distance=i};return n.fromPointNormal=function(i,a,o){if(!r(i))throw new t("point is required.");if(!r(a))throw new t("normal is required.");var u=-e.dot(a,i);return r(o)?(e.clone(a,o.normal),o.distance=u,o):new n(a,u)},n.getPointDistance=function(n,i){if(!r(n))throw new t("plane is required.");if(!r(i))throw new t("point is required.");return e.dot(n.normal,i)+n.distance},n}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=function(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n};return i.getPoint=function(r,i,a){if(!t(r))throw new n("ray is requred");if("number"!=typeof i)throw new n("t is a required number");return t(a)||(a=new e),a=e.multiplyByScalar(r.direction,i,a),e.add(r.origin,a,a)},i}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,t,n,i){return r(e).then(t,n,i)}function r(e){var r,t;return e instanceof n?r=e:u(e)?(t=o(),e.then(function(e){t.resolve(e)},function(e){t.reject(e)},function(e){t.progress(e)}),r=t.promise):r=i(e),r}function t(r){return e(r,a)}function n(e){this.then=e}function i(e){var t=new n(function(t){try{return r(t?t(e):e)}catch(n){return a(n)}});return t}function a(e){var t=new n(function(t,n){try{return n?r(n(e)):a(e)}catch(i){return a(i)}});return t}function o(){function e(e,r,t){return c(e,r,t)}function t(e){return w(e)}function i(e){return w(a(e))}function u(e){return d(e)}var s,f,h,l,c,d,w;return f=new n(e),s={then:e,resolve:t,reject:i,progress:u,promise:f,resolver:{resolve:t,reject:i,progress:u}},h=[],l=[],c=function(e,r,t){var n,i;return n=o(),i="function"==typeof t?function(e){try{n.progress(t(e))}catch(r){n.progress(r)}}:function(e){n.progress(e)},h.push(function(t){t.then(e,r).then(n.resolve,n.reject,i)}),l.push(i),n.promise},d=function(e){return m(l,e),e},w=function(e){return e=r(e),c=e.then,w=r,d=y,m(h,e),l=h=x,e},s}function u(e){return e&&"function"==typeof e.then}function s(r,t,n,i,a){return p(2,arguments),e(r,function(r){function u(e){m(e)}function s(e){w(e)}var f,h,l,c,d,w,m,p,g,v;if(g=r.length>>>0,f=Math.max(0,Math.min(t,g)),l=[],h=g-f+1,c=[],d=o(),f)for(p=d.progress,m=function(e){c.push(e),--h||(w=m=y,d.reject(c))},w=function(e){l.push(e),--f||(w=m=y,d.resolve(l))},v=0;g>v;++v)v in r&&e(r[v],s,u,p);else d.resolve(l);return d.then(n,i,a)})}function f(e,r,t,n){function i(e){return r?r(e[0]):e[0]}return s(e,1,i,t,n)}function h(e,r,t,n){return p(1,arguments),c(e,g).then(r,t,n)}function l(){return c(arguments,g)}function c(r,t){return e(r,function(r){var n,i,a,u,s,f;if(a=i=r.length>>>0,n=[],f=o(),a)for(u=function(r,i){e(r,t).then(function(e){n[i]=e,--a||f.resolve(n)},f.reject)},s=0;i>s;s++)s in r?u(r[s],s):--a;else f.resolve(n);return f.promise})}function d(r,t){var n=q.call(arguments,1);return e(r,function(r){var i;return i=r.length,n[0]=function(r,n,a){return e(r,function(r){return e(n,function(e){return t(r,e,a,i)})})},v.apply(r,n)})}function w(r,t,n){var i=arguments.length>2;return e(r,function(e){return e=i?n:e,t.resolve(e),e},function(e){return t.reject(e),a(e)},t.progress)}function m(e,r){for(var t,n=0;t=e[n++];)t(r)}function p(e,r){for(var t,n=r.length;n>e;)if(t=r[--n],null!=t&&"function"!=typeof t)throw new Error("arg "+n+" must be a function")}function y(){}function g(e){return e}var v,q,x;return e.defer=o,e.resolve=r,e.reject=t,e.join=l,e.all=h,e.map=c,e.reduce=d,e.any=f,e.some=s,e.chain=w,e.isPromise=u,n.prototype={always:function(e,r){return this.then(e,e,r)},otherwise:function(e){return this.then(x,e)},yield:function(e){return this.then(function(){return e
})},spread:function(e){return this.then(function(r){return h(r,function(r){return e.apply(x,r)})})}},q=[].slice,v=[].reduce||function(e){var r,t,n,i,a;if(a=0,r=Object(this),i=r.length>>>0,t=arguments,t.length<=1)for(;;){if(a in r){n=r[a++];break}if(++a>=i)throw new TypeError}else n=t[1];for(;i>a;++a)a in r&&(n=e(n,r[a],a,r));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,r){"use strict";var t=function(t,n,i){if(!e(t))throw new r("array is required.");if(!e(n))throw new r("itemToFind is required.");if(!e(i))throw new r("comparator is required.");for(var a,o,u=0,s=t.length-1;s>=u;)if(a=~~((u+s)/2),o=i(t[a],n),0>o)u=a+1;else{if(!(o>0))return a;s=a-1}return~(s+1)};return t}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,r,t,n,i){this.xPoleWander=e,this.yPoleWander=r,this.xPoleOffset=t,this.yPoleOffset=n,this.ut1MinusUtc=i};return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,r=arguments,t=0,n=r[t++],i=function(e,r,t,n){t||(t=" ");var i=e.length>=r?"":Array(1+r-e.length>>>0).join(t);return n?e+i:i+e},a=function(e,r,t,n,a,o){var u=n-e.length;return u>0&&(e=t||!a?i(e,n,o,t):e.slice(0,r.length)+i("",u,"0",!0)+e.slice(r.length)),e},o=function(e,r,t,n,o,u,s){var f=e>>>0;return t=t&&f&&{2:"0b",8:"0",16:"0x"}[r]||"",e=t+i(f.toString(r),u||0,"0",!1),a(e,t,n,o,s)},u=function(e,r,t,n,i,o){return null!=n&&(e=e.slice(0,n)),a(e,"",r,t,i,o)},s=function(e,n,s,f,h,l,c){var d,w,m,p,y;if("%%"==e)return"%";for(var g=!1,v="",q=!1,x=!1,E=" ",b=s.length,S=0;s&&b>S;S++)switch(s.charAt(S)){case" ":v=" ";break;case"+":v="+";break;case"-":g=!0;break;case"'":E=s.charAt(S+1);break;case"0":q=!0;break;case"#":x=!0}if(f=f?"*"==f?+r[t++]:"*"==f.charAt(0)?+r[f.slice(1,-1)]:+f:0,0>f&&(f=-f,g=!0),!isFinite(f))throw new Error("sprintf: (minimum-)width must be finite");switch(l=l?"*"==l?+r[t++]:"*"==l.charAt(0)?+r[l.slice(1,-1)]:+l:"fFeE".indexOf(c)>-1?6:"d"==c?0:void 0,y=n?r[n.slice(0,-1)]:r[t++],c){case"s":return u(String(y),g,f,l,q,E);case"c":return u(String.fromCharCode(+y),g,f,l,q);case"b":return o(y,2,x,g,f,l,q);case"o":return o(y,8,x,g,f,l,q);case"x":return o(y,16,x,g,f,l,q);case"X":return o(y,16,x,g,f,l,q).toUpperCase();case"u":return o(y,10,x,g,f,l,q);case"i":case"d":return d=+y||0,d=Math.round(d-d%1),w=0>d?"-":v,y=w+i(String(Math.abs(d)),l,"0",!1),a(y,w,g,f,q);case"e":case"E":case"f":case"F":case"g":case"G":return d=+y,w=0>d?"-":v,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(c.toLowerCase())],p=["toString","toUpperCase"]["eEfFgG".indexOf(c)%2],y=w+Math.abs(d)[m](l),a(y,w,g,f,q)[p]();default:return e}};return n.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";var e=function(e,r,t,n,i,a,o,u){this.year=e,this.month=r,this.day=t,this.hour=n,this.minute=i,this.second=a,this.millisecond=o,this.isLeapSecond=u};return e}),define("Core/isArray",["./defined"],function(e){"use strict";var r=Array.isArray;return e(r)||(r=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),r}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function r(r){if(null===r||isNaN(r))throw new e("year is required and must be a number.");return 0===r%4&&0!==r%100||0===r%400}return r}),define("Core/LeapSecond",[],function(){"use strict";var e=function(e,r){this.julianDate=e,this.offset=r};return e}),define("Core/TimeConstants",[],function(){"use strict";var e={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e}),define("Core/TimeStandard",[],function(){"use strict";var e={UTC:0,TAI:1};return e}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./defineProperties","./DeveloperError","./GregorianDate","./isArray","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,r,t,n,i,a,o,u,s,f,h,l){"use strict";function c(e,r){return R.compare(e.julianDate,r.julianDate)}function d(e){q.julianDate=e;var t=R.leapSeconds,n=r(t,q,c);0>n&&(n=~n),n>=t.length&&(n=t.length-1);var i=t[n].offset;if(n>0){var a=R.getSecondsDifference(t[n].julianDate,e);a>i&&(n--,i=t[n].offset)}R.addSeconds(e,i,e)}function w(e,t){q.julianDate=e;var n=R.leapSeconds,i=r(n,q,c);if(0>i&&(i=~i),0===i)return R.addSeconds(e,-n[0].offset,t);if(i>=n.length)return R.addSeconds(e,-n[i-1].offset,t);var a=R.getSecondsDifference(n[i].julianDate,e);return 0===a?R.addSeconds(e,-n[i].offset,t):1>=a?void 0:R.addSeconds(e,-n[--i].offset,t)}function m(e,r,t){var n=0|r/h.SECONDS_PER_DAY;return e+=n,r-=h.SECONDS_PER_DAY*n,0>r&&(e--,r+=h.SECONDS_PER_DAY),t.dayNumber=e,t.secondsOfDay=r,t}function p(e,r,t,n,i,a,o){var u=0|(r-14)/12,s=e+4800+u,f=(0|1461*s/4)+(0|367*(r-2-12*u)/12)-(0|3*((s+100)/100)/4)+t-32075;n-=12,0>n&&(n+=24);var l=a+(n*h.SECONDS_PER_HOUR+i*h.SECONDS_PER_MINUTE+o*h.SECONDS_PER_MILLISECOND);return l>=43200&&(f-=1),[f,l]}var y=new o,g=[31,28,31,30,31,30,31,31,30,31,30,31],v=29,q=new f,x=/^(\d{4})$/,E=/^(\d{4})-(\d{2})$/,b=/^(\d{4})-?(\d{3})$/,S=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,M=/^(\d{4})-?(\d{2})-?(\d{2})$/,_=/([Z+\-])?(\d{2})?:?(\d{2})?$/,O=/^(\d{2})(\.\d+)?/.source+_.source,P=/^(\d{2}):?(\d{2})(\.\d+)?/.source+_.source,T=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+_.source,C="Invalid ISO 8601 date.",R=function(e,r,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=t(e,0),r=t(r,0),n=t(n,l.UTC);var i=0|e;r+=(e-i)*h.SECONDS_PER_DAY,m(i,r,this),n===l.UTC&&d(this)};R.fromDate=function(e,r){if(!(e instanceof Date)||isNaN(e.getTime()))throw new a("date must be a valid JavaScript Date.");var t=p(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(r)?(m(t[0],t[1],r),d(r),r):new R(t[0],t[1],l.UTC)},R.fromIso8601=function(e,r){if("string"!=typeof e)throw new a(C);e=e.replace(",",".");var t,i,o,u=e.split("T"),f=1,h=1,c=0,w=0,y=0,q=0,_=u[0],N=u[1];if(!n(_))throw new a(C);var I;if(u=_.match(M),null!==u){if(I=_.split("-").length-1,I>0&&2!==I)throw new a(C);t=+u[1],f=+u[2],h=+u[3]}else if(u=_.match(E),null!==u)t=+u[1],f=+u[2];else if(u=_.match(x),null!==u)t=+u[1];else{var z;if(u=_.match(b),null!==u){if(t=+u[1],z=+u[2],o=s(t),1>z||o&&z>366||!o&&z>365)throw new a(C)}else{if(u=_.match(S),null===u)throw new a(C);t=+u[1];var D=+u[2],A=+u[3]||0;if(I=_.split("-").length-1,I>0&&(!n(u[3])&&1!==I||n(u[3])&&2!==I))throw new a(C);var U=new Date(Date.UTC(t,0,4));z=7*D+A-U.getUTCDay()-3}i=new Date(Date.UTC(t,0,1)),i.setUTCDate(z),f=i.getUTCMonth()+1,h=i.getUTCDate()}if(o=s(t),1>f||f>12||1>h||(2!==f||!o)&&h>g[f-1]||o&&2===f&&h>v)throw new a(C);var L;if(n(N)){if(u=N.match(T),null!==u){if(I=N.split(":").length-1,I>0&&2!==I&&3!==I)throw new a(C);c=+u[1],w=+u[2],y=+u[3],q=1e3*+(u[4]||0),L=5}else if(u=N.match(P),null!==u){if(I=N.split(":").length-1,I>0&&1!==I)throw new a(C);c=+u[1],w=+u[2],y=60*+(u[3]||0),L=4}else{if(u=N.match(O),null===u)throw new a(C);c=+u[1],w=60*+(u[2]||0),L=3}if(w>=60||y>=61||c>24||24===c&&(w>0||y>0||q>0))throw new a(C);var B=u[L],W=+u[L+1],F=+(u[L+2]||0);switch(B){case"+":c-=W,w-=F;break;case"-":c+=W,w+=F;break;case"Z":break;default:w+=new Date(Date.UTC(t,f-1,h,c,w)).getTimezoneOffset()}}else w+=new Date(Date.UTC(t,f-1,h)).getTimezoneOffset();var G=60===y;for(G&&y--;w>=60;)w-=60,c++;for(;c>=24;)c-=24,h++;for(i=o&&2===f?v:g[f-1];h>i;)h-=i,f++,f>12&&(f-=12,t++),i=o&&2===f?v:g[f-1];for(;0>w;)w+=60,c--;for(;0>c;)c+=24,h--;for(;1>h;)f--,1>f&&(f+=12,t--),i=o&&2===f?v:g[f-1],h+=i;var V=p(t,f,h,c,w,y,q);return n(r)?(m(V[0],V[1],r),d(r)):r=new R(V[0],V[1],l.UTC),G&&R.addSeconds(r,1,r),r},R.now=function(e){return R.fromDate(new Date,e)};var N=new R(0,0,l.TAI);return R.toGregorianDate=function(e,r){if(!n(e))throw new a("julianDate is required.");var t=!1,i=w(e,N);n(i)||(R.addSeconds(e,-1,N),i=w(N,N),t=!0);var u=i.dayNumber,s=i.secondsOfDay;s>=43200&&(u+=1);var f=0|u+68569,l=0|4*f/146097;f=0|f-(0|(146097*l+3)/4);var c=0|4e3*(f+1)/1461001;f=0|f-(0|1461*c/4)+31;var d=0|80*f/2447,m=0|f-(0|2447*d/80);f=0|d/11;var p=0|d+2-12*f,y=0|100*(l-49)+c+f,g=0|s/h.SECONDS_PER_HOUR,v=s-g*h.SECONDS_PER_HOUR,q=0|v/h.SECONDS_PER_MINUTE;v-=q*h.SECONDS_PER_MINUTE;var x=0|v,E=(v-x)/h.SECONDS_PER_MILLISECOND;return g+=12,g>23&&(g-=24),t&&(x+=1),n(r)?(r.year=y,r.month=p,r.day=m,r.hour=g,r.minute=q,r.second=x,r.millisecond=E,r.isLeapSecond=t,r):new o(y,p,m,g,q,x,E,t)},R.toDate=function(e){if(!n(e))throw new a("julianDate is required.");var r=R.toGregorianDate(e,y),t=r.second;return r.isLeapSecond&&(t-=1),new Date(Date.UTC(r.year,r.month-1,r.day,r.hour,r.minute,t,r.millisecond))},R.toIso8601=function(r,t){if(!n(r))throw new a("julianDate is required.");var i,o=R.toGregorianDate(r,o);return n(t)||0===o.millisecond?n(t)&&0!==t?(i=(.01*o.millisecond).toFixed(t).replace(".","").slice(0,t),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,i)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",o.year,o.month,o.day,o.hour,o.minute,o.second):(i=(.01*o.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,i))},R.clone=function(e,r){return n(e)?n(r)?(r.dayNumber=e.dayNumber,r.secondsOfDay=e.secondsOfDay,r):new R(e.dayNumber,e.secondsOfDay,l.TAI):void 0},R.compare=function(e,r){if(!n(e))throw new a("left is required.");if(!n(r))throw new a("right is required.");var t=e.dayNumber-r.dayNumber;return 0!==t?t:e.secondsOfDay-r.secondsOfDay},R.equals=function(e,r){return e===r||n(e)&&n(r)&&e.dayNumber===r.dayNumber&&e.secondsOfDay===r.secondsOfDay},R.equalsEpsilon=function(e,r,t){if(!n(t))throw new a("epsilon is required.");return e===r||n(e)&&n(r)&&Math.abs(R.getSecondsDifference(e,r))<=t},R.getTotalDays=function(e){if(!n(e))throw new a("julianDate is required.");return e.dayNumber+e.secondsOfDay/h.SECONDS_PER_DAY},R.getSecondsDifference=function(e,r){if(!n(e))throw new a("left is required.");if(!n(r))throw new a("right is required.");var t=(e.dayNumber-r.dayNumber)*h.SECONDS_PER_DAY;return t+(e.secondsOfDay-r.secondsOfDay)},R.getDaysDifference=function(e,r){if(!n(e))throw new a("left is required.");if(!n(r))throw new a("right is required.");var t=e.dayNumber-r.dayNumber,i=(e.secondsOfDay-r.secondsOfDay)/h.SECONDS_PER_DAY;return t+i},R.getTaiMinusUtc=function(e){q.julianDate=e;var t=R.leapSeconds,n=r(t,q,c);return 0>n&&(n=~n,--n,0>n&&(n=0)),t[n].offset},R.addSeconds=function(e,r,t){if(!n(e))throw new a("julianDate is required.");if(!n(r))throw new a("seconds is required.");if(!n(t))throw new a("result is required.");return m(e.dayNumber,e.secondsOfDay+r,t)},R.addMinutes=function(e,r,t){if(!n(e))throw new a("julianDate is required.");if(!n(r))throw new a("minutes is required.");if(!n(t))throw new a("result is required.");var i=e.secondsOfDay+r*h.SECONDS_PER_MINUTE;return m(e.dayNumber,i,t)},R.addHours=function(e,r,t){if(!n(e))throw new a("julianDate is required.");if(!n(r))throw new a("hours is required.");if(!n(t))throw new a("result is required.");var i=e.secondsOfDay+r*h.SECONDS_PER_HOUR;return m(e.dayNumber,i,t)},R.addDays=function(e,r,t){if(!n(e))throw new a("julianDate is required.");if(!n(r))throw new a("days is required.");if(!n(t))throw new a("result is required.");var i=e.dayNumber+r;return m(i,e.secondsOfDay,t)},R.lessThan=function(e,r){return R.compare(e,r)<0},R.lessThanOrEquals=function(e,r){return R.compare(e,r)<=0},R.greaterThan=function(e,r){return R.compare(e,r)>0},R.greaterThanOrEquals=function(e,r){return R.compare(e,r)>=0},R.prototype.clone=function(e){return R.clone(this,e)},R.prototype.equals=function(e){return R.equals(this,e)},R.prototype.equalsEpsilon=function(e,r){return R.equalsEpsilon(this,e,r)},R.leapSeconds=[new f(new R(2441317,43210,l.TAI),10),new f(new R(2441499,43211,l.TAI),11),new f(new R(2441683,43212,l.TAI),12),new f(new R(2442048,43213,l.TAI),13),new f(new R(2442413,43214,l.TAI),14),new f(new R(2442778,43215,l.TAI),15),new f(new R(2443144,43216,l.TAI),16),new f(new R(2443509,43217,l.TAI),17),new f(new R(2443874,43218,l.TAI),18),new f(new R(2444239,43219,l.TAI),19),new f(new R(2444786,43220,l.TAI),20),new f(new R(2445151,43221,l.TAI),21),new f(new R(2445516,43222,l.TAI),22),new f(new R(2446247,43223,l.TAI),23),new f(new R(2447161,43224,l.TAI),24),new f(new R(2447892,43225,l.TAI),25),new f(new R(2448257,43226,l.TAI),26),new f(new R(2448804,43227,l.TAI),27),new f(new R(2449169,43228,l.TAI),28),new f(new R(2449534,43229,l.TAI),29),new f(new R(2450083,43230,l.TAI),30),new f(new R(2450630,43231,l.TAI),31),new f(new R(2451179,43232,l.TAI),32),new f(new R(2453736,43233,l.TAI),33),new f(new R(2454832,43234,l.TAI),34),new f(new R(2456109,43235,l.TAI),35)],R}),define("Core/clone",["./defaultValue"],function(e){"use strict";var r=function(t,n){if(null===t||"object"!=typeof t)return t;n=e(n,!1);var i=new t.constructor;for(var a in t)if(t.hasOwnProperty(a)){var o=t[a];n&&(o=r(o,n)),i[a]=o}return i};return r}),define("Core/parseResponseHeaders",[],function(){"use strict";var e=function(e){var r={};if(!e)return r;for(var t=e.split("\r\n"),n=0;n<t.length;++n){var i=t[n],a=i.indexOf(": ");if(a>0){var o=i.substring(0,a),u=i.substring(a+2);r[o]=u}}return r};return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,r){"use strict";var t=function(e,t,n){this.statusCode=e,this.response=t,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=r(this.responseHeaders))};return t.prototype.toString=function(){var r="Request has failed.";return e(this.statusCode)&&(r+=" Status Code: "+this.statusCode),r},t}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent"],function(e,r,t,n,i){"use strict";function a(e,r){var t=decodeURIComponent(r);return e?atob(t):t}function o(e,r){for(var t=a(e,r),n=new ArrayBuffer(t.length),i=new Uint8Array(n),o=0;o<t.length;o++)i[o]=t.charCodeAt(o);return n}function u(e,t){t=r(t,"");var i=e[1],u=!!e[2],s=e[3];switch(t){case"":case"text":return a(u,s);case"arraybuffer":return o(u,s);case"blob":var f=o(u,s);return new Blob([f],{type:i});case"document":var h=new DOMParser;return h.parseFromString(a(u,s),i);case"json":return JSON.parse(a(u,s));default:throw new n("Unhandled responseType: "+t)}}var s=function(i){if(i=r(i,r.EMPTY_OBJECT),!t(i.url))throw new n("options.url is required.");var a=i.responseType,o=r(i.method,"GET"),u=i.data,f=i.headers,h=i.overrideMimeType;return e(i.url,function(r){var t=e.defer();return s.load(r,a,o,u,f,t,h),t.promise})},f=/^data:(.*?)(;base64)?,(.*)$/;return s.load=function(e,r,n,a,o,s,h){var l=f.exec(e);if(null!==l)return s.resolve(u(l,r)),void 0;var c=new XMLHttpRequest;if(t(h)&&c.overrideMimeType(h),c.open(n,e,!0),t(o))for(var d in o)o.hasOwnProperty(d)&&c.setRequestHeader(d,o[d]);t(r)&&(c.responseType=r),c.onload=function(){200===c.status?s.resolve(c.response):s.reject(new i(c.status,c.response,c.getAllResponseHeaders()))},c.onerror=function(){s.reject(new i)},c.send(a)},s.defaultLoad=s.load,s}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";var r=function(r,t){return e({url:r,headers:t})};return r}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,r,t,n){"use strict";var i={Accept:"application/json,*/*;q=0.01"},a=function(a,o){if(!r(a))throw new t("url is required.");return r(o)?r(o.Accept)||(o=e(o),o.Accept=i.Accept):o=i,n(a,o).then(function(e){return JSON.parse(e)})};return a}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,r,t,n,i,a,o,u,s,f,h,l){"use strict";function c(e,r){return o.compare(e.julianDate,r)}function d(e,t){if(!n(t.columnNames))return e._dataError="Error in loaded EOP data: The columnNames property is required.",void 0;if(!n(t.samples))return e._dataError="Error in loaded EOP data: The samples property is required.",void 0;var i=t.columnNames.indexOf("modifiedJulianDateUtc"),a=t.columnNames.indexOf("xPoleWanderRadians"),s=t.columnNames.indexOf("yPoleWanderRadians"),f=t.columnNames.indexOf("ut1MinusUtcSeconds"),d=t.columnNames.indexOf("xCelestialPoleOffsetRadians"),w=t.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=t.columnNames.indexOf("taiMinusUtcSeconds");if(0>i||0>a||0>s||0>f||0>d||0>w||0>m)return e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns",void 0;var p=e._samples=t.samples,y=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=a,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=f,e._xCelestialPoleOffsetRadiansColumn=d,e._yCelestialPoleOffsetRadiansColumn=w,e._taiMinusUtcSecondsColumn=m,e._columnCount=t.columnNames.length,e._lastIndex=void 0;for(var g,v=e._addNewLeapSeconds,q=0,x=p.length;x>q;q+=e._columnCount){var E=p[q+i],b=p[q+m],S=E+h.MODIFIED_JULIAN_DATE_DIFFERENCE,M=new o(S,b,l.TAI);if(y.push(M),v){if(b!==g&&n(g)){var _=o.leapSeconds,O=r(_,M,c);if(0>O){var P=new u(M,b);_.splice(~O,0,P)}}g=b}}}function w(e,r,t,n,i){var a=t*n;i.xPoleWander=r[a+e._xPoleWanderRadiansColumn],i.yPoleWander=r[a+e._yPoleWanderRadiansColumn],i.xPoleOffset=r[a+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=r[a+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=r[a+e._ut1MinusUtcSecondsColumn]}function m(e,r,t){return r+e*(t-r)}function p(e,r,t,n,i,a,u){var s=e._columnCount;if(a>r.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var f=r[i],h=r[a];if(f.equals(h)||n.equals(f))return w(e,t,i,s,u),u;if(n.equals(h))return w(e,t,a,s,u),u;var l=o.getSecondsDifference(n,f)/o.getSecondsDifference(h,f),c=i*s,d=a*s,p=t[c+e._ut1MinusUtcSecondsColumn],y=t[d+e._ut1MinusUtcSecondsColumn],g=y-p;if(g>.5||-.5>g){var v=t[c+e._taiMinusUtcSecondsColumn],q=t[d+e._taiMinusUtcSecondsColumn];v!==q&&(h.equals(n)?p=y:y-=q-v)}return u.xPoleWander=m(l,t[c+e._xPoleWanderRadiansColumn],t[d+e._xPoleWanderRadiansColumn]),u.yPoleWander=m(l,t[c+e._yPoleWanderRadiansColumn],t[d+e._yPoleWanderRadiansColumn]),u.xPoleOffset=m(l,t[c+e._xCelestialPoleOffsetRadiansColumn],t[d+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=m(l,t[c+e._yCelestialPoleOffsetRadiansColumn],t[d+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=m(l,p,y),u}var y=function(r){if(r=t(r,t.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=t(r.addNewLeapSeconds,!0),n(r.data))d(this,r.data);else if(n(r.url)){var i=this;this._downloadPromise=e(s(r.url),function(e){d(i,e)},function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+r.url+"."})}else d(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return y.NONE=a({getPromiseToLoad:function(){return e()},compute:function(e,r){return n(r)?(r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0):r=new i(0,0,0,0,0),r}}),y.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},y.prototype.compute=function(e,t){if(!n(this._samples)){if(n(this._dataError))throw new f(this._dataError);return void 0}if(n(t)||(t=new i(0,0,0,0,0)),0===this._samples.length)return t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0,t;var a=this._dates,u=this._lastIndex,s=0,h=0;if(n(u)){var l=a[u],c=a[u+1],d=o.lessThanOrEquals(l,e),w=!n(c),m=w||o.greaterThanOrEquals(c,e);if(d&&m)return s=u,!w&&c.equals(e)&&++s,h=s+1,p(this,a,this._samples,e,s,h,t),t}var y=r(a,e,o.compare,this._dateColumn);return y>=0?(y<a.length-1&&a[y+1].equals(e)&&++y,s=y,h=y):(h=~y,s=h-1,0>s&&(s=0)),this._lastIndex=s,p(this,a,this._samples,e,s,h,t),t},y}),define("ThirdParty/Uri",[],function(){function e(r){if(r instanceof e)this.scheme=r.scheme,this.authority=r.authority,this.path=r.path,this.query=r.query,this.fragment=r.fragment;else if(r){var t=n.exec(r);this.scheme=t[1],this.authority=t[2],this.path=t[3],this.query=t[4],this.fragment=t[5]}}function r(e){var r=unescape(e);return a.test(r)?r:e.toUpperCase()}function t(e,r,t,n){return(r||"")+t.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,t).replace(i,r)),this.path&&(this.path=this.path.replace(i,r)),this.query&&(this.query=this.query.replace(i,r)),this.fragment&&(this.fragment=this.fragment.replace(i,r))};var i=/%[0-9a-z]{2}/gi,a=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(r){var t=new e;return this.scheme?(t.scheme=this.scheme,t.authority=this.authority,t.path=this.path,t.query=this.query):(t.scheme=r.scheme,this.authority?(t.authority=this.authority,t.path=this.path,t.query=this.query):(t.authority=r.authority,""==this.path?(t.path=r.path,t.query=this.query||r.query):("/"==this.path.charAt(0)?(t.path=this.path,t.removeDotSegments()):(t.path=r.authority&&""==r.path?"/"+this.path:r.path.substring(0,r.path.lastIndexOf("/")+1)+this.path,t.removeDotSegments()),t.query=this.query))),t.fragment=this.fragment,t},e.prototype.removeDotSegments=function(){var e,r=this.path.split("/"),t=[],n=""==r[0];for(n&&r.shift(),""==r[0]?r.shift():null;r.length;)e=r.shift(),".."==e?t.pop():"."!=e&&t.push(e);("."==e||".."==e)&&t.push(""),n&&t.unshift(""),this.path=t.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,r,t,n){"use strict";function i(){for(var e=document.getElementsByTagName("script"),r=0,t=e.length;t>r;++r){var n=e[r].getAttribute("src"),i=l.exec(n);if(null!==i)return i[1]}return void 0}function a(){if(r(s))return s;var n;if(n="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:i(),!r(n))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return s=new e(n).resolve(new e(document.location.href))}function o(e){return n.toUrl("../"+e)}function u(r){return new e(r).resolve(a()).toString()}var s,f,h,l=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,c=function(e){r(f)||(f=r(n.toUrl)?o:u),r(h)||(h=document.createElement("a"));var t=f(e);return h.href=t,h.href=h.href,h.href};return c._cesiumScriptRegex=l,c}),define("Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,r,t){this.x=e,this.y=r,this.s=t};return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,r,t,n,i,a,o,u){"use strict";function s(e,r,t){var n=l;return n.dayNumber=r,n.secondsOfDay=t,a.getDaysDifference(n,e._sampleZeroDateTT)}function f(t,i){if(t._chunkDownloadsInProgress[i])return t._chunkDownloadsInProgress[i];var a=e.defer();t._chunkDownloadsInProgress[i]=a;var u,s=t._xysFileUrlTemplate;return u=n(s)?s.replace("{0}",i):r("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json"),e(o(u),function(e){t._chunkDownloadsInProgress[i]=!1;for(var r=t._samples,n=e.samples,o=3*i*t._samplesPerXysFile,u=0,s=n.length;s>u;++u)r[o+u]=n[u];a.resolve()}),a.promise}var h=function(e){e=t(e,t.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=t(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=t(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new a(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=t(e.stepSizeDays,1),this._samplesPerXysFile=t(e.samplesPerXysFile,1e3),this._totalSamples=t(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var r=this._interpolationOrder,n=this._denominators=new Array(r+1),i=this._xTable=new Array(r+1),o=Math.pow(this._stepSizeDays,r),s=0;r>=s;++s){n[s]=o,i[s]=s*this._stepSizeDays;for(var f=0;r>=f;++f)f!==s&&(n[s]*=s-f);n[s]=1/n[s]}this._work=new Array(r+1),this._coef=new Array(r+1)},l=new a(0,0,u.TAI);return h.prototype.preload=function(r,t,n,i){var a=s(this,r,t),o=s(this,n,i),u=0|a/this._stepSizeDays-this._interpolationOrder/2;0>u&&(u=0);var h=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;h>=this._totalSamples&&(h=this._totalSamples-1);for(var l=0|u/this._samplesPerXysFile,c=0|h/this._samplesPerXysFile,d=[],w=l;c>=w;++w)d.push(f(this,w));return e.all(d)},h.prototype.computeXysRadians=function(e,r,t){var a=s(this,e,r);if(0>a)return void 0;var o=0|a/this._stepSizeDays;if(o>=this._totalSamples)return void 0;var u=this._interpolationOrder,h=o-(0|u/2);0>h&&(h=0);var l=h+u;l>=this._totalSamples&&(l=this._totalSamples-1,h=l-u,0>h&&(h=0));var c=!1,d=this._samples;if(n(d[3*h])||(f(this,0|h/this._samplesPerXysFile),c=!0),n(d[3*l])||(f(this,0|l/this._samplesPerXysFile),c=!0),c)return void 0;n(t)?(t.x=0,t.y=0,t.s=0):t=new i(0,0,0);var w,m,p=a-h*this._stepSizeDays,y=this._work,g=this._denominators,v=this._coef,q=this._xTable;for(w=0;u>=w;++w)y[w]=p-q[w];for(w=0;u>=w;++w){for(v[w]=1,m=0;u>=m;++m)m!==w&&(v[w]*=y[m]);v[w]*=g[w];var x=3*(h+w);t.x+=v[w]*d[x++],t.y+=v[w]*d[x++],t.s+=v[w]*d[x]}return t},h}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./TimeConstants"],function(e,r,t,n,i,a,o,u,s,f,h,l,c,d,w,m,p){"use strict";var y={},g=new t,v=new t,q=new t;y.eastNorthUpToFixedFrame=function(e,r,n){if(!a(e))throw new o("origin is required.");if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var u=d.sign(e.z);return a(n)?(n[0]=0,n[1]=1,n[2]=0,n[3]=0,n[4]=-u,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=u,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(0,-u,0,e.x,1,0,0,e.y,0,0,u,e.z,0,0,0,1)}var s=g,h=v,l=q;return r=i(r,f.WGS84),r.geodeticSurfaceNormal(e,s),h.x=-e.y,h.y=e.x,h.z=0,t.normalize(h,h),t.cross(s,h,l),a(n)?(n[0]=h.x,n[1]=h.y,n[2]=h.z,n[3]=0,n[4]=l.x,n[5]=l.y,n[6]=l.z,n[7]=0,n[8]=s.x,n[9]=s.y,n[10]=s.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(h.x,l.x,s.x,e.x,h.y,l.y,s.y,e.y,h.z,l.z,s.z,e.z,0,0,0,1)};var x=new t,E=new t,b=new t;y.northEastDownToFixedFrame=function(e,r,n){if(!a(e))throw new o("origin is required.");if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var u=d.sign(e.z);return a(n)?(n[0]=-u,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=1,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=-u,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(-u,0,0,e.x,0,1,0,e.y,0,0,-u,e.z,0,0,0,1)}var s=x,h=E,l=b;return r=i(r,f.WGS84),r.geodeticSurfaceNormal(e,s),h.x=-e.y,h.y=e.x,h.z=0,t.normalize(h,h),t.cross(s,h,l),a(n)?(n[0]=l.x,n[1]=l.y,n[2]=l.z,n[3]=0,n[4]=h.x,n[5]=h.y,n[6]=h.z,n[7]=0,n[8]=-s.x,n[9]=-s.y,n[10]=-s.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(l.x,h.x,-s.x,e.x,l.y,h.y,-s.y,e.y,l.z,h.z,-s.z,e.z,0,0,0,1)};var S=24110.54841,M=8640184.812866,_=.093104,O=-62e-7,P=1.1772758384668e-19,T=72921158553e-15,C=d.TWO_PI/86400,R=new c;y.computeTemeToPseudoFixedMatrix=function(e,r){if(!a(e))throw new o("date is required.");R=c.addSeconds(e,-c.getTaiMinusUtc(e),R);var t,n=R.dayNumber,i=R.secondsOfDay,u=n-2451545;t=i>=43200?(u+.5)/p.DAYS_PER_JULIAN_CENTURY:(u-.5)/p.DAYS_PER_JULIAN_CENTURY;var s=S+t*(M+t*(_+t*O)),f=s*C%d.TWO_PI,h=T+P*(n-2451545.5),l=(i+.5*p.SECONDS_PER_DAY)%p.SECONDS_PER_DAY,m=f+h*l,y=Math.cos(m),g=Math.sin(m);return a(r)?(r[0]=y,r[1]=-g,r[2]=0,r[3]=g,r[4]=y,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new w(y,g,0,-g,y,0,0,0,1)},y.iau2006XysData=new h,y.earthOrientationParameters=u.NONE;var N=32.184,I=2451545;y.preloadIcrfFixed=function(r){var t=r.start.dayNumber,n=r.start.secondsOfDay+N,i=r.stop.dayNumber,a=r.stop.secondsOfDay+N,o=y.iau2006XysData.preload(t,n,i,a),u=y.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},y.computeIcrfToFixedMatrix=function(e,r){if(!a(e))throw new o("date is required.");var t=y.computeFixedToIcrfMatrix(e,r);return a(t)?w.transpose(t,r):void 0};var z=new l(0,0,0),D=new s(0,0,0,0,0,0),A=new w,U=new w;y.computeFixedToIcrfMatrix=function(e,r){if(!a(e))throw new o("date is required.");var t=y.earthOrientationParameters.compute(e,D);if(!a(t))return void 0;var n=e.dayNumber,i=e.secondsOfDay+N,u=y.iau2006XysData.computeXysRadians(n,i,z);if(!a(u))return void 0;var s=u.x+t.xPoleOffset,f=u.y+t.yPoleOffset,h=1/(1+Math.sqrt(1-s*s-f*f)),l=A;l[0]=1-h*s*s,l[3]=-h*s*f,l[6]=s,l[1]=-h*s*f,l[4]=1-h*f*f,l[7]=f,l[2]=-s,l[5]=-f,l[8]=1-h*(s*s+f*f);var m=w.fromRotationZ(-u.s,U),g=w.multiply(l,m,A),v=e.dayNumber,q=e.secondsOfDay-c.getTaiMinusUtc(e)+t.ut1MinusUtc,x=v-2451545,E=q/p.SECONDS_PER_DAY,b=.779057273264+E+.00273781191135448*(x+E);b=b%1*d.TWO_PI;var S=w.fromRotationZ(b,U),M=w.multiply(g,S,A),_=Math.cos(t.xPoleWander),O=Math.cos(t.yPoleWander),P=Math.sin(t.xPoleWander),T=Math.sin(t.yPoleWander),C=n-I+i/p.SECONDS_PER_DAY;C/=36525;var R=-47e-6*C*d.RADIANS_PER_DEGREE/3600,L=Math.cos(R),B=Math.sin(R),W=U;return W[0]=_*L,W[1]=_*B,W[2]=P,W[3]=-O*B+T*P*L,W[4]=O*L+T*P*B,W[5]=-T*_,W[6]=-T*B-O*P*L,W[7]=T*L-O*P*B,W[8]=O*_,w.multiply(M,W,r)};var L=new n;return y.pointToWindowCoordinates=function(e,t,i,u){if(!a(e))throw new o("modelViewProjectionMatrix is required.");if(!a(t))throw new o("viewportTransformation is required.");if(!a(i))throw new o("point is required.");a(u)||(u=new r);var s=L;return m.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,s),s),n.multiplyByScalar(s,1/s.w,s),m.multiplyByVector(t,s,s),r.fromCartesian4(s,u)},y}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix4","./Plane","./Ray","./Transforms"],function(e,r,t,n,i,a,o,u,s,f,h,l,c){"use strict";var d=function(e,r){if(!i(e))throw new o("origin is required.");if(r=n(r,u.WGS84),e=r.scaleToGeodeticSurface(e),!i(e))throw new o("origin must not be at the center of the ellipsoid.");var a=c.eastNorthUpToFixedFrame(e,r);this._ellipsoid=r,this._origin=e,this._xAxis=t.fromCartesian4(f.getColumn(a,0)),this._yAxis=t.fromCartesian4(f.getColumn(a,1));
var s=t.fromCartesian4(f.getColumn(a,2));this._plane=h.fromPointNormal(e,s)};a(d.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}}});var w=new e;d.fromPoints=function(r,t){if(!i(r))throw new o("cartesians is required.");var n=e.fromPoints(r,w);return new d(n.center,t)};var m=new l,p=new t;d.prototype.projectPointOntoPlane=function(e,n){if(!i(e))throw new o("cartesian is required.");var a=m;a.origin=e,t.normalize(e,a.direction);var u=s.rayPlane(a,this._plane,p);if(i(u)||(t.negate(a.direction,a.direction),u=s.rayPlane(a,this._plane,p)),i(u)){var f=t.subtract(u,this._origin,u),h=t.dot(this._xAxis,f),l=t.dot(this._yAxis,f);return i(n)?(n.x=h,n.y=l,n):new r(h,l)}return void 0},d.prototype.projectPointsOntoPlane=function(e,r){if(!i(e))throw new o("cartesians is required.");i(r)||(r=[]);for(var t=0,n=e.length,a=0;n>a;a++){var u=this.projectPointOntoPlane(e[a],r[t]);i(u)&&(r[t]=u,t++)}return r.length=t,r};var y=new t;return d.prototype.projectPointsOntoEllipsoid=function(e,r){if(!i(e))throw new o("cartesians is required.");var n=e.length;i(r)?r.length=n:r=new Array(n);for(var a=this._ellipsoid,u=this._origin,s=this._xAxis,f=this._yAxis,h=y,l=0;n>l;++l){var c=e[l];t.multiplyByScalar(s,c.x,h),i(r[l])||(r[l]=new t);var d=t.add(u,h,r[l]);t.multiplyByScalar(f,c.y,h),t.add(d,h,d),a.scaleToGeocentricSurface(d,d)}return r},d}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=new r,a=new r,o=new r,u=function(u,s,f,h,l){if(!(t(u)&&t(s)&&t(f)&&t(h)))throw new n("point, p0, p1, and p2 are required.");t(l)||(l=new r);var c,d,w,m,p,y,g,v;t(s.z)?(c=r.subtract(f,s,i),d=r.subtract(h,s,a),w=r.subtract(u,s,o),m=r.dot(c,c),p=r.dot(c,d),y=r.dot(c,w),g=r.dot(d,d),v=r.dot(d,w)):(c=e.subtract(f,s,i),d=e.subtract(h,s,a),w=e.subtract(u,s,o),m=e.dot(c,c),p=e.dot(c,d),y=e.dot(c,w),g=e.dot(d,d),v=e.dot(d,w));var q=1/(m*g-p*p);return l.y=(g*y-p*v)*q,l.z=(m*v-p*y)*q,l.x=1-l.y-l.z,l};return u}),define("Core/pointInsideTriangle",["./barycentricCoordinates","./Cartesian3"],function(e,r){"use strict";var t=new r,n=function(r,n,i,a){return e(r,n,i,a,t),t.x>0&&t.y>0&&t.z>0};return n}),define("Core/PrimitiveType",[],function(){"use strict";var e={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(r){return r===e.POINTS||r===e.LINES||r===e.LINE_LOOP||r===e.LINE_STRIP||r===e.TRIANGLES||r===e.TRIANGLE_STRIP||r===e.TRIANGLE_FAN}};return e}),define("Core/Queue",[],function(){"use strict";var e=function(){this._array=[],this._offset=0,this.length=0};return e.prototype.enqueue=function(e){this._array.push(e),this.length++},e.prototype.dequeue=function(){if(0===this.length)return void 0;var e=this._array,r=this._offset,t=e[r];return e[r]=void 0,r++,r>10&&2*r>e.length&&(this._array=e.slice(r),r=0),this._offset=r,this.length--,t},e.prototype.contains=function(e){return-1!==this._array.indexOf(e)},e.prototype.clear=function(){this._array.length=this._offset=this.length=0},e.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},e}),define("Core/WindingOrder",[],function(){"use strict";var e={CLOCKWISE:2304,COUNTER_CLOCKWISE:2305,validate:function(r){return r===e.CLOCKWISE||r===e.COUNTER_CLOCKWISE}};return e}),define("Core/PolygonPipeline",["./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./Math","./pointInsideTriangle","./PrimitiveType","./Queue","./WindingOrder"],function(e,r,t,n,i,a,o,u,s,f,h,l,c,d,w){"use strict";function m(r,t,n){var i=e.subtract(t,r,L),a=e.subtract(n,t,B);return i.x*a.y-i.y*a.x>=0}function p(e){for(var r=e[0].x,t=0,n=0;n<e.length;n++)e[n].x>r&&(r=e[n].x,t=n);return t}function y(e){for(var r=e[0][0].x,t=0,n=0;n<e.length;n++){var i=e[n][p(e[n])].x;i>r&&(r=i,t=n)}return t}function g(e){for(var r=[],t=0;t<e.length;t++){var n=e[(t-1+e.length)%e.length],i=e[t],a=e[(t+1)%e.length];m(n,i,a)||r.push(i)}return r}function v(r,t){for(var n=0;n<r.length;n++)if(e.equals(t,r[n]))return n;return-1}function q(t,i,a){a=n(a,[]);var o=Number.MAX_VALUE,u=p(i),s=new e(i[u].x,t.y);a.push(u),a.push((u+1)%i.length);for(var f=i[0].x,h=f,l=1;l<i.length;++l)i[l].x<f?f=i[l].x:i[l].x>h&&(h=i[l].x);h+=h-f;var c=new r(h,t.y,0);for(l=0;l<i.length;l++){var d=i[l],w=i[(l+1)%i.length];if((d.x>=t.x||w.x>=t.x)&&(d.y>=t.y&&w.y<=t.y||d.y<=t.y&&w.y>=t.y)){var m=(w.y-d.y)*(c.x-t.x)-(w.x-d.x)*(c.y-t.y);if(0!==m){m=1/m;var y=((w.x-d.x)*(t.y-d.y)-(w.y-d.y)*(t.x-d.x))*m,g=((c.x-t.x)*(t.y-d.y)-(c.y-t.y)*(t.x-d.x))*m;if(y>=0&&1>=y&&g>=0&&1>=g){var v=new e(t.x+y*(c.x-t.x),t.y+y*(c.y-t.y)),q=e.subtract(v,t,W);m=e.magnitudeSquared(q),o>m&&(s=v,o=m,a[0]=l,a[1]=(l+1)%i.length)}}}}return s}function x(r,t){var n=y(t),i=t[n],a=p(i),o=i[a],u=[],s=q(o,r,u),f=v(r,s);if(-1!==f)return f;var c=e.magnitudeSquared(e.subtract(r[u[0]],o,F)),d=e.magnitudeSquared(e.subtract(r[u[1]],o,F)),w=d>c?r[u[0]]:r[u[1]],m=g(r),x=m.indexOf(w);-1!==x&&m.splice(x,1);for(var E=[],b=0;b<m.length;b++){var S=m[b];l(S,o,s,w)&&E.push(S)}var M=Number.MAX_VALUE;if(E.length>0){var _=e.fromElements(1,0,F);for(b=0;b<E.length;b++){var O=e.subtract(E[b],o,G),P=e.magnitude(_)*e.magnitudeSquared(O);if(0!==P){var T=Math.abs(h.acosClamped(e.dot(_,O)/P));M>T&&(M=T,w=E[b])}}}return r.indexOf(w)}function E(e,t,n){for(var i=ur.computeWindingOrder2D(e),a=0;a<t.length;a++){var o=t[a];r.equals(o[0],o[o.length-1])||o.push(o[0]);var s=ur.computeWindingOrder2D(o);s===i&&o.reverse()}var f=u.fromPoints(e,n),h=f.projectPointsOntoPlane(e),l=[];for(a=0;a<t.length;a++)l.push(f.projectPointsOntoPlane(t[a]));var c=x(h,l),d=y(l),w=p(l[d]),m=t[d],g=[];for(a=0;a<e.length;a++)g.push(e[a]);var v,q=[];if(0!==w)for(v=0;v<=m.length;v++){var E=(v+w)%m.length;0!==E&&q.push(m[E])}else for(v=0;v<m.length;v++)q.push(m[(v+w)%m.length]);var b=g.lastIndexOf(e[c]);q.push(e[b]);var S=g.slice(0,b+1),M=g.slice(b+1);return g=S.concat(q,M),t.splice(d,1),g}function b(e){var r="0."+Math.sin(V).toString().substr(5);V+=.2;var t=Math.floor(r*e);return t===e&&t--,t}function S(r,t,n){return M(r,t,n)&&M(t,r,n)&&!z(n[r].position,n[t].position,n)&&!e.equals(n[r].position,n[t].position)}function M(r,t,n){P(r,n);var i=n[r],a=n[t],o=O(r,n,j),u=O(r,n,Y),s=e.subtract(n[o].position,i.position,k),f=e.subtract(n[u].position,i.position,H),h=e.subtract(a.position,i.position,Z);return T(s,h)?_(s,h):T(f,h)?_(f,h):C(s,f)?I(s,f,h)?!0:!1:R(s,f)?N(s,f,h)?!1:!0:void 0}function _(r,t){return e.magnitude(t)<e.magnitude(r)}function O(e,r,t){var n=e+t;return 0>n&&(n=r.length-1),n===r.length&&(n=0),P(n,r),n}function P(r,t){var n=r-1,i=r+1;0>n&&(n=t.length-1),i===t.length&&(i=0);var o=e.subtract(t[n].position,t[r].position,X),u=e.subtract(t[i].position,t[r].position,J);if(T(o,u)){var s=new a("Superfluous vertex found.");throw s.vertexIndex=r,s}}function T(e,t){return 0===r.cross(e,t,K).z}function C(e,t){return r.cross(e,t,Q).z<0}function R(e,t){return r.cross(e,t,$).z>0}function N(e,t,n){return r.cross(e,n,er).z>0&&r.cross(n,t,er).z>0}function I(e,t,n){return r.cross(e,n,rr).z<0&&r.cross(n,t,rr).z<0}function z(r,t,n){for(var i=0;i<n.length;i++){var a,o=n[i].position;if(a=i<n.length-1?n[i+1].position:n[0].position,!(e.equals(r,o)||e.equals(t,a)||e.equals(r,a)||e.equals(t,o))){var u=(t.y-r.y)/(t.x-r.x),s=(a.y-o.y)/(a.x-o.x);if(!(u===s||isNaN(u)&&isNaN(s))){var f;f=isNaN(u)?r.x:isNaN(s)?o.x:(r.y-o.y-u*r.x+s*o.x)/(s-u);var h=u*f+r.y-u*r.x,l=e.fromElements(f,h,tr);if(!(e.equals(l,r)||e.equals(l,t)||e.equals(l,o)||e.equals(l,a))){var c=A(f,r.x,t.x)&&A(h,r.y,t.y)&&A(f,o.x,a.x)&&A(h,o.y,a.y);if(c)return!0}}}}return!1}function D(r){var t=r[0].position,n=r[1].position,i=r[2].position,a=e.subtract(n,t,nr),o=e.subtract(i,t,ir);return T(a,o)}function A(e,r,t){return(e>r||e>t)&&(r>e||t>e)||r===t&&r===e}function U(e){var r=e.length;if(3===r)return D(e)?[]:[e[0].index,e[1].index,e[2].index];if(e.length<3)throw new a("Invalid polygon: must have at least three vertices.");for(var t=!1,n=0;!t;){var i=10*e.length;if(n>i)return[];n++;for(var o=b(e.length),u=o+1;Math.abs(o-u)<2||Math.abs(o-u)>e.length-2;)u=b(e.length);if(o>u){var s=o;o=u,u=s}try{if(S(o,u,e)){var f=e.splice(o,u-o+1,e[o],e[u]);return U(e).concat(U(f))}}catch(h){if(h.hasOwnProperty("vertexIndex"))return e.splice(h.vertexIndex,1),U(e);throw h}}}var L=new e,B=new e,W=new e,F=new e(1,0),G=new e,V=0,j=-1,Y=1,k=new r,H=new r,Z=new r,X=new r,J=new r,K=new r,Q=new r,$=new r,er=new r,rr=new r,tr=new e,nr=new r,ir=new r,ar=new r,or=new r,ur={};return ur.removeDuplicates=function(e){if(!i(e))throw new a("positions is required.");if(e.length<3)throw new a("At least three positions are required.");for(var t=e.length,n=[],o=t-1,u=0;t>u;o=u++){var s=e[o],f=e[u];r.equals(s,f)||n.push(f)}return n},ur.computeArea2D=function(e){if(!i(e))throw new a("positions is required.");if(e.length<3)throw new a("At least three positions are required.");for(var r=e.length,t=0,n=r-1,o=0;r>o;n=o++){var u=e[n],s=e[o];t+=u.x*s.y-s.x*u.y}return.5*t},ur.computeWindingOrder2D=function(e){var r=ur.computeArea2D(e);return r>0?w.COUNTER_CLOCKWISE:w.CLOCKWISE},ur.triangulate=function(e){if(!i(e))throw new a("positions is required.");if(e.length<3)throw new a("At least three positions are required.");for(var r=e.length,t=[],n=0;r>n;++n)t[n]={position:e[n],index:n};return U(t)},ur.resetSeed=function(e){V=n(e,0)},ur.computeSubdivision=function(e,o,u){if(u=n(u,h.RADIANS_PER_DEGREE),!i(e))throw new a("positions is required.");if(!i(o))throw new a("indices is required.");if(o.length<3)throw new a("At least three indices are required.");if(0!==o.length%3)throw new a("The number of indices must be divisable by three.");if(0>=u)throw new a("granularity must be greater than zero.");for(var l=new d,w=o.length,m=0;w>m;m+=3)l.enqueue({i0:o[m],i1:o[m+1],i2:o[m+2]});for(var p,y=e.slice(0),g=[],v={};l.length>0;){var q,x,E=l.dequeue(),b=y[E.i0],S=y[E.i1],M=y[E.i2],_=r.angleBetween(b,S),O=r.angleBetween(S,M),P=r.angleBetween(M,b),T=Math.max(_,Math.max(O,P));T>u?_===T?(q=Math.min(E.i0,E.i1).toString()+" "+Math.max(E.i0,E.i1).toString(),p=v[q],p||(x=r.add(b,S,new r),r.multiplyByScalar(x,.5,x),y.push(x),p=y.length-1,v[q]=p),l.enqueue({i0:E.i0,i1:p,i2:E.i2}),l.enqueue({i0:p,i1:E.i1,i2:E.i2})):O===T?(q=Math.min(E.i1,E.i2).toString()+" "+Math.max(E.i1,E.i2).toString(),p=v[q],p||(x=r.add(S,M,new r),r.multiplyByScalar(x,.5,x),y.push(x),p=y.length-1,v[q]=p),l.enqueue({i0:E.i1,i1:p,i2:E.i0}),l.enqueue({i0:p,i1:E.i2,i2:E.i0})):P===T&&(q=Math.min(E.i2,E.i0).toString()+" "+Math.max(E.i2,E.i0).toString(),p=v[q],p||(x=r.add(M,b,new r),r.multiplyByScalar(x,.5,x),y.push(x),p=y.length-1,v[q]=p),l.enqueue({i0:E.i2,i1:p,i2:E.i1}),l.enqueue({i0:p,i1:E.i0,i2:E.i1})):(g.push(E.i0),g.push(E.i1),g.push(E.i2))}var C=y.length,R=new Array(3*C),N=0;for(p=0;C>p;p++){var I=y[p];R[N++]=I.x,R[N++]=I.y,R[N++]=I.z}return new s({attributes:{position:new f({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:R})},indices:g,primitiveType:c.TRIANGLES})},ur.scaleToGeodeticHeight=function(e,t,a,u){a=n(a,o.WGS84);var s=ar,f=or;if(t=n(t,0),u=n(u,!0),i(e)&&i(e.attributes)&&i(e.attributes.position))for(var h=e.attributes.position.values,l=h.length,c=0;l>c;c+=3)r.fromArray(h,c,f),u&&(f=a.scaleToGeodeticSurface(f,f)),s=a.geodeticSurfaceNormal(f,s),r.multiplyByScalar(s,t,s),r.add(f,s,f),h[c]=f.x,h[c+1]=f.y,h[c+2]=f.z;return e},ur.eliminateHoles=function(e,t,u){if(!i(e))throw new a("outerRing is required.");if(0===e.length)throw new a("outerRing must not be empty.");if(!i(t))throw new a("innerRings is required.");u=n(u,o.WGS84);for(var s=[],f=0;f<t.length;f++){for(var h=[],l=0;l<t[f].length;l++)h.push(r.clone(t[f][l]));s.push(h)}for(var c=e;s.length>0;)c=E(c,s,u);return c},ur}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,r,t,n,i,a,o,u){"use strict";function s(e){var r=e._uSquared,t=e._ellipsoid.maximumRadius,n=e._ellipsoid.minimumRadius,i=(t-n)/t,a=Math.cos(e._startHeading),o=Math.sin(e._startHeading),u=(1-i)*Math.tan(e._start.latitude),s=1/Math.sqrt(1+u*u),f=s*u,h=Math.atan2(u,a),l=s*o,c=l*l,d=1-c,w=Math.sqrt(d),m=r/4,p=m*m,y=p*m,g=p*p,v=1+m-3*p/4+5*y/4-175*g/64,q=1-m+15*p/8-35*y/8,x=1-3*m+35*p/4,E=1-5*m,b=v*h-q*Math.sin(2*h)*m/2-x*Math.sin(4*h)*p/16-E*Math.sin(6*h)*y/48-5*Math.sin(8*h)*g/512,S=e._constants;S.a=t,S.b=n,S.f=i,S.cosineHeading=a,S.sineHeading=o,S.tanU=u,S.cosineU=s,S.sineU=f,S.sigma=h,S.sineAlpha=l,S.sineSquaredAlpha=c,S.cosineSquaredAlpha=d,S.cosineAlpha=w,S.u2Over4=m,S.u4Over16=p,S.u6Over64=y,S.u8Over256=g,S.a0=v,S.a1=q,S.a2=x,S.a3=E,S.distanceRatio=b}function f(e,r){return e*r*(4+e*(4-3*r))/16}function h(e,r,t,n,i,a,o){var u=f(e,t);return(1-u)*e*r*(n+u*i*(o+u*a*(2*o*o-1)))}function l(e,r,t,n,i,a,o){var s,f,l,c,d,w=(r-t)/r,m=a-n,p=Math.atan((1-w)*Math.tan(i)),y=Math.atan((1-w)*Math.tan(o)),g=Math.cos(p),v=Math.sin(p),q=Math.cos(y),x=Math.sin(y),E=g*q,b=g*x,S=v*x,M=v*q,_=m,O=u.TWO_PI,P=Math.cos(_),T=Math.sin(_);do{P=Math.cos(_),T=Math.sin(_);var C=b-M*P;l=Math.sqrt(q*q*T*T+C*C),f=S+E*P,s=Math.atan2(l,f);var R;0===l?(R=0,c=1):(R=E*T/l,c=1-R*R),O=_,d=f-2*S/c,isNaN(d)&&(d=0),_=m+h(w,R,c,s,l,f,d)}while(Math.abs(_-O)>u.EPSILON12);var N=c*(r*r-t*t)/(t*t),I=1+N*(4096+N*(N*(320-175*N)-768))/16384,z=N*(256+N*(N*(74-47*N)-128))/1024,D=d*d,A=z*l*(d+z*(f*(2*D-1)-z*d*(4*l*l-3)*(4*D-3)/6)/4),U=t*I*(s-A),L=Math.atan2(q*T,b-M*P),B=Math.atan2(g*T,b*P-M);e._distance=U,e._startHeading=L,e._endHeading=B,e._uSquared=N}function c(t,n,i,o){var u=e.normalize(o.cartographicToCartesian(n,w),d),f=e.normalize(o.cartographicToCartesian(i,w),w);if(Math.abs(Math.abs(e.angleBetween(u,f))-Math.PI)<.0125)throw new a("geodesic position is not unique");l(t,o.maximumRadius,o.minimumRadius,n.longitude,n.latitude,i.longitude,i.latitude),n.height=0,i.height=0,t._start=r.clone(n,t._start),t._end=r.clone(i,t._end),s(t)}var d=new e,w=new e,m=function(e,i,a){var u=t(a,o.WGS84);this._ellipsoid=u,this._start=new r,this._end=new r,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,n(e)&&n(i)&&c(this,e,i,u)};return i(m.prototype,{surfaceDistance:{get:function(){if(!n(this._distance))throw new a("set end positions before getting surfaceDistance");return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){if(!n(this._distance))throw new a("set end positions before getting startHeading");return this._startHeading}},endHeading:{get:function(){if(!n(this._distance))throw new a("set end positions before getting endHeading");return this._endHeading}}}),m.prototype.setEndPoints=function(e,r){if(!n(e))throw new a("start cartographic position is required");if(!n(r))throw new a("end cartgraphic position is required");c(this,e,r,this._ellipsoid)},m.prototype.interpolateUsingFraction=function(e,r){return this.interpolateUsingSurfaceDistance(this._distance*e,r)},m.prototype.interpolateUsingSurfaceDistance=function(e,t){if(!n(this._distance))throw new a("start and end must be set before calling funciton interpolateUsingSurfaceDistance");var i=this._constants,o=i.distanceRatio+e/i.b,u=Math.cos(2*o),s=Math.cos(4*o),f=Math.cos(6*o),l=Math.sin(2*o),c=Math.sin(4*o),d=Math.sin(6*o),w=Math.sin(8*o),m=o*o,p=o*m,y=i.u8Over256,g=i.u2Over4,v=i.u6Over64,q=i.u4Over16,x=2*p*y*u/3+o*(1-g+7*q/4-15*v/4+579*y/64-(q-15*v/4+187*y/16)*u-(5*v/4-115*y/16)*s-29*y*f/16)+(g/2-q+71*v/32-85*y/16)*l+(5*q/16-5*v/4+383*y/96)*c-m*((v-11*y/2)*l+5*y*c/2)+(29*v/96-29*y/16)*d+539*y*w/1536,E=Math.asin(Math.sin(x)*i.cosineAlpha),b=Math.atan(i.a/i.b*Math.tan(E));x-=i.sigma;var S=Math.cos(2*i.sigma+x),M=Math.sin(x),_=Math.cos(x),O=i.cosineU*_,P=i.sineU*M,T=Math.atan2(M*i.sineHeading,O-P*i.cosineHeading),C=T-h(i.f,i.sineAlpha,i.cosineSquaredAlpha,x,M,_,S);return n(t)?(t.longitude=this._start.longitude+C,t.latitude=b,t.height=0,t):new r(this._start.longitude+C,b,0)},m}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,r,t,n,i,a,o,u,s,f,h,l){"use strict";function c(r,t,n,i){var a=i.scaleToGeodeticSurface(r,_),o=i.scaleToGeodeticSurface(t,O),u=e.angleBetween(a,o),s=Math.ceil(u/n),f=new Array(3*s),h=i.cartesianToCartographic(a,b),l=i.cartesianToCartographic(o,S);P.setEndPoints(h,l);var c=P.surfaceDistance/s,d=0;h.height=0;var w=i.cartographicToCartesian(h,M);f[d++]=w.x,f[d++]=w.y,f[d++]=w.z;for(var m=1;s>m;m++){var p=P.interpolateUsingSurfaceDistance(m*c,S);w=i.cartographicToCartesian(p,M),f[d++]=w.x,f[d++]=w.y,f[d++]=w.z}return f}function d(r,t,n){var i=T;return n.geodeticSurfaceNormal(r,i),e.multiplyByScalar(i,t,i),e.add(r,i,r),r}var w={},m=new h,p=new e,y=new e,g=new l(e.ZERO,0),v=new e,q=new l(e.ZERO,0),x=new e,E=new e,b=new r,S=new r,M=new e,_=new e,O=new e,P=new o,T=new e,C=new e;return w.wrapLongitude=function(r,i){var a=[],o=[];if(n(r)&&r.length>0){i=t(i,h.IDENTITY);var s=h.inverseTransformation(i,m),f=h.multiplyByPoint(s,e.ZERO,p),c=h.multiplyByPointAsVector(s,e.UNIT_Y,y),d=l.fromPointNormal(f,c,g),w=h.multiplyByPointAsVector(s,e.UNIT_X,v),b=l.fromPointNormal(f,w,q),S=1;a.push(e.clone(r[0]));for(var M=a[0],_=r.length,O=1;_>O;++O){var P=r[O];if(l.getPointDistance(b,M)<0||l.getPointDistance(b,P)<0){var T=u.lineSegmentPlane(M,P,d,x);if(n(T)){var C=e.multiplyByScalar(c,5e-9,E);l.getPointDistance(d,M)<0&&e.negate(C,C),a.push(e.add(T,C,new e)),o.push(S+1),e.negate(C,C),a.push(e.add(T,C,new e)),S=1}}a.push(e.clone(r[O])),S++,M=P}o.push(S)}return{positions:a,lengths:o}},w.removeDuplicates=function(r){if(!n(r))throw new i("positions is required.");var t=r.length;if(2>t)return r.slice(0);var a=[];a.push(r[0]);for(var o=1;t>o;++o){var u=r[o-1],s=r[o];e.equals(u,s)||a.push(s)}return a},w.scaleToSurface=function(e,r,o){if(!n(e))throw new i("positions is required");r=t(r,f.RADIANS_PER_DEGREE),o=t(o,a.WGS84);for(var u=e.length,s=[],h=0;u-1>h;h++){var l=e[h],d=e[h+1];s=s.concat(c(l,d,r,o))}var w=e[u-1],m=o.cartesianToCartographic(w,b);m.height=0;var p=o.cartographicToCartesian(m,M);return s.push(p.x,p.y,p.z),s},w.scaleToGeodeticHeight=function(r,o,u,f){if(!n(r))throw new i("positions must be defined.");if(!n(o))throw new i("height must be defined");u=t(u,a.WGS84);var h,l,c=r.length,w=C;if(n(f)){if(f.length!==r.length)throw new i("result.length must be equal to positions.length");l=f}else l=new Array(r.length);if(0===o){for(h=0;c>h;h+=3)w=u.scaleToGeodeticSurface(e.fromArray(r,h,w),w),l[h]=w.x,l[h+1]=w.y,l[h+2]=w.z;return l}var m;if(s(o)){if(o.length!==c/3)throw new i("height.length must be equal to positions.length");for(h=0;c>h;h+=3)m=o[h/3],w=e.fromArray(r,h,w),w=d(w,m,u),l[h]=w.x,l[h+1]=w.y,l[h+2]=w.z}else for(m=o,h=0;c>h;h+=3)w=e.fromArray(r,h,w),w=d(w,m,u),l[h]=w.x,l[h+1]=w.y,l[h+2]=w.z;return l},w}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,r,t,n,i,a,o,u){"use strict";var s=function(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)},f=new e;s.fromAxisAngle=function(r,i,a){if(!t(r))throw new n("axis is required.");if("number"!=typeof i)throw new n("angle is required and must be a number.");var o=i/2,u=Math.sin(o);f=e.normalize(r,f);var h=f.x*u,l=f.y*u,c=f.z*u,d=Math.cos(o);return t(a)?(a.x=h,a.y=l,a.z=c,a.w=d,a):new s(h,l,c,d)};var h=[1,2,0],l=new Array(3);s.fromRotationMatrix=function(e,r){if(!t(e))throw new n("matrix is required.");var i,a,o,f,c,d=e[u.COLUMN0ROW0],w=e[u.COLUMN1ROW1],m=e[u.COLUMN2ROW2],p=d+w+m;if(p>0)i=Math.sqrt(p+1),c=.5*i,i=.5/i,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*i,o=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*i,f=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*i;else{var y=h,g=0;w>d&&(g=1),m>d&&m>w&&(g=2);var v=y[g],q=y[v];i=Math.sqrt(e[u.getElementIndex(g,g)]-e[u.getElementIndex(v,v)]-e[u.getElementIndex(q,q)]+1);var x=l;x[g]=.5*i,i=.5/i,c=(e[u.getElementIndex(q,v)]-e[u.getElementIndex(v,q)])*i,x[v]=(e[u.getElementIndex(v,g)]+e[u.getElementIndex(g,v)])*i,x[q]=(e[u.getElementIndex(q,g)]+e[u.getElementIndex(g,q)])*i,a=-x[0],o=-x[1],f=-x[2]}return t(r)?(r.x=a,r.y=o,r.z=f,r.w=c,r):new s(a,o,f,c)};var c=new e,d=new e,w=new s,m=new s,p=new s;s.packedLength=4,s.pack=function(e,i,a){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");a=r(a,0),i[a++]=e.x,i[a++]=e.y,i[a++]=e.z,i[a]=e.w},s.unpack=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new s),a.x=e[i],a.y=e[i+1],a.z=e[i+2],a.w=e[i+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,r,t,n){s.unpack(e,4*t,p),s.conjugate(p,p);for(var i=0,a=t-r+1;a>i;i++){var o=3*i;s.unpack(e,4*(r+i),w),s.multiply(w,p,w),w.w<0&&s.negate(w,w),s.getAxis(w,c);var u=s.getAngle(w);n[o]=c.x*u,n[o+1]=c.y*u,n[o+2]=c.z*u}},s.unpackInterpolationResult=function(r,n,i,a,o){t(o)||(o=new s),e.fromArray(r,0,d);var u=e.magnitude(d);return s.unpack(n,4*a,m),0===u?s.clone(s.IDENTITY,w):s.fromAxisAngle(d,u,w),s.multiply(w,m,o)},s.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,r){if(!t(e))throw new n("quaternion is required");return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r):new s(-e.x,-e.y,-e.z,e.w)},s.magnitudeSquared=function(e){if(!t(e))throw new n("quaternion is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){var n=1/s.magnitude(e),i=e.x*n,a=e.y*n,o=e.z*n,u=e.w*n;return t(r)?(r.x=i,r.y=a,r.z=o,r.w=u,r):new s(i,a,o,u)},s.inverse=function(e,r){var t=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/t,r)},s.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");return t(i)?(i.x=e.x+r.x,i.y=e.y+r.y,i.z=e.z+r.z,i.w=e.w+r.w,i):new s(e.x+r.x,e.y+r.y,e.z+r.z,e.w+r.w)},s.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");return t(i)?(i.x=e.x-r.x,i.y=e.y-r.y,i.z=e.z-r.z,i.w=e.w-r.w,i):new s(e.x-r.x,e.y-r.y,e.z-r.z,e.w-r.w)},s.negate=function(e,r){if(!t(e))throw new n("quaternion is required");return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r):new s(-e.x,-e.y,-e.z,-e.w)},s.dot=function(e,r){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");return e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");var a=e.x,o=e.y,u=e.z,f=e.w,h=r.x,l=r.y,c=r.z,d=r.w,w=f*h+a*d+o*c-u*l,m=f*l-a*c+o*d+u*h,p=f*c+a*l-o*h+u*d,y=f*d-a*h-o*l-u*c;return t(i)?(i.x=w,i.y=m,i.z=p,i.w=y,i):new s(w,m,p,y)},s.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");return t(i)?(i.x=e.x*r,i.y=e.y*r,i.z=e.z*r,i.w=e.w*r,i):new s(e.x*r,e.y*r,e.z*r,e.w*r)},s.divideByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");return t(i)?(i.x=e.x/r,i.y=e.y/r,i.z=e.z/r,i.w=e.w/r,i):new s(e.x/r,e.y/r,e.z/r,e.w/r)},s.getAxis=function(r,i){if(!t(r))throw new n("quaternion is required");var a=r.w;if(Math.abs(a-1)<o.EPSILON6)return t(i)?(i.x=i.y=i.z=0,i):new e;var u=1/Math.sqrt(1-a*a);return t(i)?(i.x=r.x*u,i.y=r.y*u,i.z=r.z*u,i):new e(r.x*u,r.y*u,r.z*u)},s.getAngle=function(e){if(!t(e))throw new n("quaternion is required");return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var y;s.lerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");return y=s.multiplyByScalar(r,i,y),a=s.multiplyByScalar(e,1-i,a),s.add(y,a,a)};var g,v,q;s.slerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");var u=s.dot(e,r),f=r;if(0>u&&(u=-u,f=g=s.negate(r,g)),1-u<o.EPSILON6)return s.lerp(e,f,i,a);var h=Math.acos(u);return v=s.multiplyByScalar(e,Math.sin((1-i)*h),v),q=s.multiplyByScalar(f,Math.sin(i*h),q),a=s.add(v,q,a),s.multiplyByScalar(a,1/Math.sin(h),a)},s.log=function(r,i){if(!t(r))throw new n("quaternion is required.");var a=o.acosClamped(r.w),u=0;return 0!==a&&(u=a/Math.sin(a)),t(i)||(i=new e),e.multiplyByScalar(r,u,i)},s.exp=function(r,i){if(!t(r))throw new n("cartesian is required.");var a=e.magnitude(r),o=0;return 0!==a&&(o=Math.sin(a)/a),t(i)||(i=new s),i.x=r.x*o,i.y=r.y*o,i.z=r.z*o,i.w=Math.cos(a),i};var x=new e,E=new e,b=new s,S=new s;s.innerQuadrangle=function(r,i,a,o){if(!t(r)||!t(i)||!t(a))throw new n("q0, q1, and q2 are required.");var u=s.conjugate(i,b);s.multiply(u,a,S);var f=s.log(S,x);s.multiply(u,r,S);var h=s.log(S,E);return e.add(f,h,f),e.multiplyByScalar(f,.25,f),e.negate(f,f),s.exp(f,b),s.multiply(i,b,o)},s.squad=function(e,r,i,a,o,u){if(!(t(e)&&t(r)&&t(i)&&t(a)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof o)throw new n("t is required and must be a number.");var f=s.slerp(e,r,o,b),h=s.slerp(i,a,o,S);return s.slerp(f,h,2*o*(1-o),u)};for(var M=new s,_=1.9011074535173003,O=i.supportsTypedArrays()?new Float32Array(8):[],P=i.supportsTypedArrays()?new Float32Array(8):[],T=i.supportsTypedArrays()?new Float32Array(8):[],C=i.supportsTypedArrays()?new Float32Array(8):[],R=0;7>R;++R){var N=R+1,I=2*N+1;O[R]=1/(N*I),P[R]=N/I}return O[7]=_/136,P[7]=8*_/17,s.fastSlerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");t(a)||(a=new s);var o,u=s.dot(e,r);u>=0?o=1:(o=-1,u=-u);for(var f=u-1,h=1-i,l=i*i,c=h*h,d=7;d>=0;--d)T[d]=(O[d]*l-P[d])*f,C[d]=(O[d]*c-P[d])*f;var w=o*i*(1+T[0]*(1+T[1]*(1+T[2]*(1+T[3]*(1+T[4]*(1+T[5]*(1+T[6]*(1+T[7])))))))),m=h*(1+C[0]*(1+C[1]*(1+C[2]*(1+C[3]*(1+C[4]*(1+C[5]*(1+C[6]*(1+C[7])))))))),p=s.multiplyByScalar(e,m,M);return s.multiplyByScalar(r,w,a),s.add(p,a,a)},s.fastSquad=function(e,r,i,a,o,u){if(!(t(e)&&t(r)&&t(i)&&t(a)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof o)throw new n("t is required and must be a number.");var f=s.fastSlerp(e,r,o,b),h=s.fastSlerp(i,a,o,S);return s.fastSlerp(f,h,2*o*(1-o),u)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},s.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon is required and must be a number.");return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},s.ZERO=a(new s(0,0,0,0)),s.IDENTITY=a(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return s.equalsEpsilon(this,e,r)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/PolylineVolumeGeometryLibrary",["./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./CornerType","./EllipsoidTangentPlane","./Math","./Matrix3","./Matrix4","./PolylinePipeline","./Quaternion","./Transforms"],function(e,r,t,n,i,a,o,u,s,f,h,l){"use strict";function c(e,r){for(var t=new Array(e.length),n=0;n<e.length;n++){var i=e[n];z=r.cartesianToCartographic(i,z),t[n]=z.height,e[n]=r.scaleToGeodeticSurface(i,i)}return t}function d(e,t,n,i){var a,o=e[0],u=e[1],s=r.angleBetween(o,u),f=Math.ceil(s/i),h=new Array(f);if(t===n){for(a=0;f>a;a++)h[a]=t;return h.push(n),h}var l=n-t,c=l/f;for(a=1;f>a;a++){var d=t+a*c;h[a]=d}return h[0]=t,h.push(n),h}function w(t,n,i,o){var u=new a(i,o),s=u.projectPointOntoPlane(r.add(i,t,H),H),f=u.projectPointOntoPlane(r.add(i,n,Z),Z),h=e.angleBetween(s,f);return f.x*s.y-f.y*s.x>=0?-h:h}function m(e,t,n,i,a,o,f,h){var c=W,d=F;A=l.eastNorthUpToFixedFrame(e,a,A),c=s.multiplyByPointAsVector(A,D,c),c=r.normalize(c,c);var m=w(c,t,e,a);L=u.fromRotationZ(m,L),G.z=o,A=s.multiplyTransformation(A,s.fromRotationTranslation(L,G,U),A);var p=B;p[0]=f;for(var y=0;h>y;y++)for(var g=0;g<n.length;g+=3)d=r.fromArray(n,g,d),d=u.multiplyByVector(p,d,d),d=s.multiplyByPoint(A,d,d),i.push(d.x,d.y,d.z);return i}function p(e,t,n,i,a,o,u){for(var s=0;s<e.length;s+=3){var f=r.fromArray(e,s,V);i=m(f,t,n,i,a,o[s/3],u,1)}return i}function y(e,r){var t=e.length,n=new Array(6*t),i=0,a=r.x+r.width/2,o=r.y+r.height/2,u=e[0];n[i++]=u.x-a,n[i++]=0,n[i++]=u.y-o;for(var s=1;t>s;s++){u=e[s];var f=u.x-a,h=u.y-o;n[i++]=f,n[i++]=0,n[i++]=h,n[i++]=f,n[i++]=0,n[i++]=h}return u=e[0],n[i++]=u.x-a,n[i++]=0,n[i++]=u.y-o,n}function g(e,r){for(var t=e.length,n=new Array(3*t),i=0,a=r.x+r.width/2,o=r.y+r.height/2,u=0;t>u;u++)n[i++]=e[u].x-a,n[i++]=0,n[i++]=e[u].y-o;return n}function v(e,t,n,a,s,f,l,c,d,w){var p,y=r.angleBetween(r.subtract(t,e,R),r.subtract(n,e,N)),g=a===i.BEVELED?0:Math.ceil(y/o.toRadians(5));p=s?u.fromQuaternion(h.fromAxisAngle(r.negate(e,R),y/(g+1),j),k):u.fromQuaternion(h.fromAxisAngle(e,y/(g+1),j),k);var v,q;if(t=r.clone(t,Y),g>0)for(var x=w?2:1,E=0;g>E;E++)t=u.multiplyByVector(p,t,t),v=r.subtract(t,e,R),v=r.normalize(v,v),s||(v=r.negate(v,v)),q=f.scaleToGeodeticSurface(t,N),l=m(q,v,c,l,f,d,1,x);else v=r.subtract(t,e,R),v=r.normalize(v,v),s||(v=r.negate(v,v)),q=f.scaleToGeodeticSurface(t,N),l=m(q,v,c,l,f,d,1,1),n=r.clone(n,Y),v=r.subtract(n,e,R),v=r.normalize(v,v),s||(v=r.negate(v,v)),q=f.scaleToGeodeticSurface(n,N),l=m(q,v,c,l,f,d,1,1);return l}function q(e,r){return o.equalsEpsilon(e.latitude,r.latitude,o.EPSILON6)&&o.equalsEpsilon(e.longitude,r.longitude,o.EPSILON6)}var x=[new r,new r],E=new r,b=new r,S=new r,M=new r,_=new r,O=new r,P=new r,T=new r,C=new r,R=new r,N=new r,I={},z=new n,D=new r(-1,0,0),A=new s,U=new s,L=new u,B=u.IDENTITY.clone(),W=new r,F=new t,G=new r,V=new r,j=new h,Y=new r,k=new u;I.removeDuplicatesFromShape=function(r){for(var t=r.length,n=[],i=t-1,a=0;t>a;i=a++){var o=r[i],u=r[a];e.equals(o,u)||n.push(u)}return n};var H=new r,Z=new r;I.angleIsGreaterThanPi=function(e,t,n,i){var o=new a(n,i),u=o.projectPointOntoPlane(r.add(n,e,H),H),s=o.projectPointOntoPlane(r.add(n,t,Z),Z);return s.x*u.y-s.y*u.x>=0};var X=new n,J=new n;return I.removeDuplicatesFromPositions=function(e,r){var t=e.length;if(2>t)return e.slice(0);var n=[];n.push(e[0]);for(var i=1;t>i;++i){var a=e[i-1],o=e[i],u=r.cartesianToCartographic(a,X),s=r.cartesianToCartographic(o,J);q(u,s)||n.push(o)}return n},I.computePositions=function(e,t,n,a,u){var s=a._ellipsoid,h=c(e,s),l=a._granularity,w=a._cornerType,q=u?y(t,n):g(t,n),N=u?g(t,n):void 0,z=n.height/2,D=n.width/2,A=e.length,U=[],L=u?[]:void 0,B=E,W=b,F=S,G=M,V=_,j=O,Y=P,k=T,H=C,Z=e[0],X=e[1];G=s.geodeticSurfaceNormal(Z,G),B=r.subtract(X,Z,B),B=r.normalize(B,B),k=r.cross(G,B,k),k=r.normalize(k,k);var J=h[0],K=h[1];u&&(L=m(Z,k,N,L,s,J+z,1,1)),H=r.clone(Z,H),Z=X,W=r.negate(B,W);for(var Q,$,er=1;A-1>er;er++){var rr=u?2:1;X=e[er+1],B=r.subtract(X,Z,B),B=r.normalize(B,B),F=r.add(B,W,F),F=r.normalize(F,F),G=s.geodeticSurfaceNormal(Z,G);var tr=!r.equalsEpsilon(r.negate(F,R),G,o.EPSILON2);if(tr){F=r.cross(F,G,F),F=r.cross(G,F,F),F=r.normalize(F,F);var nr=1/Math.max(.25,r.magnitude(r.cross(F,W,R))),ir=I.angleIsGreaterThanPi(B,W,Z,s);ir?(V=r.add(Z,r.multiplyByScalar(F,nr*D,F),V),j=r.add(V,r.multiplyByScalar(k,D,j),j),x[0]=r.clone(H,x[0]),x[1]=r.clone(j,x[1]),Q=d(x,J+z,K+z,l),$=f.scaleToSurface(x),U=p($,k,q,U,s,Q,1),k=r.cross(G,B,k),k=r.normalize(k,k),Y=r.add(V,r.multiplyByScalar(k,D,Y),Y),w===i.ROUNDED||w===i.BEVELED?v(V,j,Y,w,ir,s,U,q,K+z,u):(F=r.negate(F,F),U=m(Z,F,q,U,s,K+z,nr,rr)),H=r.clone(Y,H)):(V=r.add(Z,r.multiplyByScalar(F,nr*D,F),V),j=r.add(V,r.multiplyByScalar(k,-D,j),j),x[0]=r.clone(H,x[0]),x[1]=r.clone(j,x[1]),Q=d(x,J+z,K+z,l),$=f.scaleToSurface(x,l,s),U=p($,k,q,U,s,Q,1),k=r.cross(G,B,k),k=r.normalize(k,k),Y=r.add(V,r.multiplyByScalar(k,-D,Y),Y),w===i.ROUNDED||w===i.BEVELED?v(V,j,Y,w,ir,s,U,q,K+z,u):U=m(Z,F,q,U,s,K+z,nr,rr),H=r.clone(Y,H)),W=r.negate(B,W)
}else U=m(H,k,q,U,s,J+z,1,1),H=Z;J=K,K=h[er+1],Z=X}x[0]=r.clone(H,x[0]),x[1]=r.clone(Z,x[1]),Q=d(x,J+z,K+z,l),$=f.scaleToSurface(x,l,s),U=p($,k,q,U,s,Q,1),u&&(L=m(Z,k,N,L,s,K+z,1,1)),A=U.length;var ar=u?A+L.length:A,or=new Float64Array(ar);return or.set(U),u&&or.set(L,A),or},I}),define("Core/PolylineVolumeOutlineGeometry",["./BoundingRectangle","./BoundingSphere","./ComponentDatatype","./CornerType","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolygonPipeline","./PolylineVolumeGeometryLibrary","./PrimitiveType","./WindingOrder"],function(e,r,t,n,i,a,o,u,s,f,h,l,c,d,w,m,p){"use strict";function y(e,n){var i=new h;i.position=new f({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:e});var a,o,u=n.length,c=i.position.values.length/3,d=e.length/3,w=d/u,p=l.createTypedArray(c,2*u*(w+1)),y=0;a=0;var g=a*u;for(o=0;u-1>o;o++)p[y++]=o+g,p[y++]=o+g+1;for(p[y++]=u-1+g,p[y++]=g,a=w-1,g=a*u,o=0;u-1>o;o++)p[y++]=o+g,p[y++]=o+g+1;for(p[y++]=u-1+g,p[y++]=g,a=0;w-1>a;a++){var v=u*a,q=v+u;for(o=0;u>o;o++)p[y++]=o+v,p[y++]=o+q}var x=new s({attributes:i,indices:l.createTypedArray(c,p),boundingSphere:r.fromVertices(e),primitiveType:m.LINES});return x}var g=function(e){e=i(e,i.EMPTY_OBJECT);var r=e.polylinePositions,t=e.shapePositions;if(!a(r))throw new o("options.polylinePositions is required.");if(!a(t))throw new o("options.shapePositions is required.");this._positions=r,this._shape=t,this._ellipsoid=i(e.ellipsoid,u.WGS84),this._cornerType=i(e.cornerType,n.ROUNDED),this._granularity=i(e.granularity,c.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeOutlineGeometry"},v=new e;return g.createGeometry=function(r){var t=r._positions,n=w.removeDuplicatesFromPositions(t,r._ellipsoid),i=r._shape;if(i=w.removeDuplicatesFromShape(i),n.length<2)throw new o("Count of unique polyline positions must be greater than 1.");if(i.length<3)throw new o("Count of unique shape positions must be at least 3.");d.computeWindingOrder2D(i)===p.CLOCKWISE&&i.reverse();var a=e.fromPoints(i,v),u=w.computePositions(n,i,a,r,!1);return y(u,i)},g}),define("Workers/createPolylineVolumeOutlineGeometry",["../Core/Ellipsoid","../Core/PolylineVolumeOutlineGeometry"],function(e,r){"use strict";function t(t){return t._ellipsoid=e.clone(t._ellipsoid),r.createGeometry(t)}return t})}();