/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2014 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=.5*3*Math.PI,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,o=e-Math.floor(e/r)*r;return o<-Math.PI?o+r:o>=Math.PI?o-r:o},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");for(var r=i.EPSILON10,o=i.PI,a=i.TWO_PI;-(o+r)>e;)e+=a;if(-o>e)return-o;for(;e>o+r;)e-=a;return e>o?o:e},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=e%i.TWO_PI;return 0>r?(r+i.TWO_PI)%i.TWO_PI:r},i.equalsEpsilon=function(e,i,o){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");return o=r(o,0),Math.abs(e-i)<=o};var o=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=o.length;if(e>=r)for(var t=o[r-1],i=r;e>=i;i++)o.push(t*i);return o[e]},i.incrementWrap=function(e,i,o){if(o=r(o,0),!t(e))throw new n("n is required.");if(o>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=o),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var a=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");a=new e(r)},i.nextRandomNumber=function(){return a.random()},i.acosClamped=function(e){return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){return Math.asin(i.clamp(e,-1,1))},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};o.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new o);var a=n.clock,s=n.cone,u=e(n.magnitude,1),f=u*Math.sin(s);return i.x=f*Math.cos(a),i.y=f*Math.sin(a),i.z=u*Math.cos(s),i},o.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new o(e,t,n)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o]=n.z},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i],a},o.fromArray=o.unpack,o.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},o.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},o.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},o.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var s=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,s),a=o.multiplyByScalar(e,1-i,a),o.add(s,a,a)};var u=new o,f=new o;o.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");o.normalize(e,u),o.normalize(n,f);var i=o.dot(u,f),a=o.magnitude(o.cross(u,f,u));return Math.atan2(a,i)};var l=new o;o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,l);return o.abs(i,i),n=i.x<=i.y?i.x<=i.z?o.clone(o.UNIT_X,n):o.clone(o.UNIT_Z,n):i.y<=i.z?o.clone(o.UNIT_Y,n):o.clone(o.UNIT_Z,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i},o.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var o=e.x,a=e.y,s=e.z,u=n.x,f=n.y,l=n.z,h=a*l-s*f,c=s*u-o*l,w=o*f-a*u;return i.x=h,i.y=c,i.z=w,i},o.fromDegrees=function(e,n,a,s,u){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var f=i.toRadians(e),l=i.toRadians(n);return o.fromRadians(f,l,a,s,u)};var h=new o,c=new o,w=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(n,i,a,s,u){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");a=e(a,0);var f=r(s)?s.radiiSquared:w,l=Math.cos(i);h.x=l*Math.cos(n),h.y=l*Math.sin(n),h.z=Math.sin(i),h=o.normalize(h,h),o.multiplyComponents(f,h,c);var d=Math.sqrt(o.dot(h,c));return c=o.divideByScalar(c,d,c),h=o.multiplyByScalar(h,a,h),r(u)||(u=new o),o.add(c,h,u)},o.fromDegreesArray=function(e,n,a){if(!r(e))throw new t("positions is required.");for(var s=new Array(e.length),u=0;u<e.length;u++)s[u]=i.toRadians(e[u]);return o.fromRadiansArray(s,n,a)},o.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(0!==e.length%2)throw new t("positions length must be a multiple of 2.");var a=e.length;r(i)?i.length=a/2:i=new Array(a/2);for(var s=0;a>s;s+=2){var u=e[s],f=e[s+1];i[s/2]=o.fromRadians(u,f,0,n,i[s/2])}return i},o.fromDegreesArrayHeights=function(e,n,a){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");for(var s=new Array(e.length),u=0;u<e.length;u+=3)s[u]=i.toRadians(e[u]),s[u+1]=i.toRadians(e[u+1]),s[u+2]=e[u+2];return o.fromRadiansArrayHeights(s,n,a)},o.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");var a=e.length;r(i)?i.length=a/3:i=new Array(a/3);for(var s=0;a>s;s+=3){var u=e[s],f=e[s+1],l=e[s+2];i[s/3]=o.fromRadians(u,f,l,n,i[s/3])}return i},o.ZERO=n(new o(0,0,0)),o.UNIT_X=n(new o(1,0,0)),o.UNIT_Y=n(new o(0,1,0)),o.UNIT_Z=n(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return o.fromRadians=function(n,i,a,s){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return a=e(a,0),r(s)?(s.longitude=n,s.latitude=i,s.height=a,s):new o(n,i,a)},o.fromDegrees=function(e,n,a,s){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),o.fromRadians(e,n,a,s)},o.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},o.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},o.toString=function(e){if(!r(e))throw new t("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},o.ZERO=n(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return o.toString(this)},o}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o,a,s){"use strict";var u=function(r,n,i){if(r=t(r,0),n=t(n,0),i=t(i,0),0>r||0>n||0>i)throw new o("All radii components must be greater than or equal to zero.");this._radii=new e(r,n,i),this._radiiSquared=new e(r*r,n*n,i*i),this._radiiToTheFourth=new e(r*r*r*r,n*n*n*n,i*i*i*i),this._oneOverRadii=new e(0===r?0:1/r,0===n?0:1/n,0===i?0:1/i),this._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===n?0:1/(n*n),0===i?0:1/(i*i)),this._minimumRadius=Math.min(r,n,i),this._maximumRadius=Math.max(r,n,i),this._centerToleranceSquared=s.EPSILON1};i(u.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),u.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new u(i.x,i.y,i.z)},u.fromCartesian3=function(e){return n(e)?new u(e.x,e.y,e.z):new u},u.WGS84=a(new u(6378137,6378137,6356752.314245179)),u.UNIT_SPHERE=a(new u(1,1,1)),u.MOON=a(new u(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.geocentricSurfaceNormal=e.normalize,u.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new o("cartographic is required.");var i=r.longitude,a=r.latitude,s=Math.cos(a),u=s*Math.cos(i),f=s*Math.sin(i),l=Math.sin(a);return n(t)||(t=new e),t.x=u,t.y=f,t.z=l,e.normalize(t,t)},u.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var f=new e,l=new e;u.prototype.cartographicToCartesian=function(r,t){var i=f,o=l;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,o);var a=Math.sqrt(e.dot(i,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(o,i,t)},u.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new o("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var h=new e,c=new e,w=new e;u.prototype.cartesianToCartographic=function(t,i){var o=this.scaleToGeodeticSurface(t,c);if(!n(o))return void 0;var a=this.geodeticSurfaceNormal(o,h),u=e.subtract(t,o,w),f=Math.atan2(a.y,a.x),l=Math.asin(a.z),d=s.sign(e.dot(u,t))*e.magnitude(u);return n(i)?(i.longitude=f,i.latitude=l,i.height=d,i):new r(f,l,d)},u.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new o("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var d=new e,m=new e;return u.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");var i=r.x,a=r.y,u=r.z,f=this._oneOverRadii,l=f.x,h=f.y,c=f.z,w=i*i*l*l,p=a*a*h*h,g=u*u*c*c,y=w+p+g,E=Math.sqrt(1/y),C=e.multiplyByScalar(r,E,d);if(y<this._centerToleranceSquared)return isFinite(E)?e.clone(C,t):void 0;var v=this._oneOverRadiiSquared,S=v.x,q=v.y,b=v.z,M=m;M.x=2*C.x*S,M.y=2*C.y*q,M.z=2*C.z*b;var R,A,x,O,I,T,N,F,_,D,L,P=(1-E)*e.magnitude(r)/(.5*e.magnitude(M)),z=0;do{P-=z,x=1/(1+P*S),O=1/(1+P*q),I=1/(1+P*b),T=x*x,N=O*O,F=I*I,_=T*x,D=N*O,L=F*I,R=w*T+p*N+g*F-1,A=w*_*S+p*D*q+g*L*b;var B=-2*A;z=R/B}while(Math.abs(R)>s.EPSILON12);return n(t)?(t.x=i*x,t.y=a*O,t.z=u*I,t):new e(i*x,a*O,u*I)},u.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");n(t)||(t=new e);var i=r.x,a=r.y,s=r.z,u=this._oneOverRadiiSquared,f=1/Math.sqrt(i*i*u.x+a*a*u.y+s*s*u.z);return e.multiplyByScalar(r,f,t)},u.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},u.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},u.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},u.prototype.toString=function(){return this._radii.toString()},u}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,o,a){"use strict";var s=function(e){this._ellipsoid=t(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(r,t){var i=this._semimajorAxis,o=r.longitude*i,a=r.latitude*i,s=r.height;return n(t)?(t.x=o,t.y=a,t.z=s,t):new e(o,a,s)},s.prototype.unproject=function(e,t){if(!n(e))throw new o("cartesian is required");var i=this._oneOverSemimajorAxis,a=e.x*i,s=e.y*i,u=e.z;return n(t)?(t.longitude=a,t.latitude=s,t.height=u,t):new r(a,s,u)},s}),define("Core/Intersect",[],function(){"use strict";var e={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};i.fromElements=function(e,t,n,o,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=o,a):new i(e,t,n,o)},i.fromColor=function(e,n){if(!r(e))throw new t("color is required");return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o++]=n.z,i[o]=n.w},i.unpack=function(n,o,a){if(!r(n))throw new t("array is required");return o=e(o,0),r(a)||(a=new i),a.x=n[o++],a.y=n[o++],a.z=n[o++],a.w=n[o],a},i.fromArray=i.unpack,i.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},i.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},i.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},i.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},i.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return i.subtract(e,n,o),i.magnitude(o)},i.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var o=i.magnitude(e);return n.x=e.x/o,n.y=e.y/o,n.z=e.z/o,n.w=e.w/o,n},i.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},i.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},i.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},i.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},i.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},i.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},i.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},i.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var a=new i;i.lerp=function(e,n,o,s){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof o)throw new t("t is required and must be a number.");if(!r(s))throw new t("result is required.");return i.multiplyByScalar(n,o,a),s=i.multiplyByScalar(e,1-o,s),i.add(a,s,s)};var s=new i;return i.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var o=i.normalize(e,s);return i.abs(o,o),n=o.x<=o.y?o.x<=o.z?o.x<=o.w?i.clone(i.UNIT_X,n):i.clone(i.UNIT_W,n):o.z<=o.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n):o.y<=o.z?o.y<=o.w?i.clone(i.UNIT_Y,n):i.clone(i.UNIT_W,n):o.z<=o.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},i.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i&&Math.abs(e.w-n.w)<=i},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,r){return i.equalsEpsilon(this,e,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o){"use strict";function a(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function s(e){for(var r=0,t=0;3>t;++t){var n=e[f.getElementIndex(w[t],c[t])];r+=2*n*n}return Math.sqrt(r)}function u(e,r){for(var t=o.EPSILON15,n=0,i=1,a=0;3>a;++a){var s=Math.abs(e[f.getElementIndex(w[a],c[a])]);s>n&&(i=a,n=s)}var u=1,l=0,h=c[i],d=w[i];if(Math.abs(e[f.getElementIndex(d,h)])>t){var m,p=e[f.getElementIndex(d,d)],g=e[f.getElementIndex(h,h)],y=e[f.getElementIndex(d,h)],E=(p-g)/2/y;m=0>E?-1/(-E+Math.sqrt(1+E*E)):1/(E+Math.sqrt(1+E*E)),u=1/Math.sqrt(1+m*m),l=m*u}return r=f.clone(f.IDENTITY,r),r[f.getElementIndex(h,h)]=r[f.getElementIndex(d,d)]=u,r[f.getElementIndex(d,h)]=l,r[f.getElementIndex(h,d)]=-l,r}var f=function(e,t,n,i,o,a,s,u,f){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(s,0),this[3]=r(t,0),this[4]=r(o,0),this[5]=r(u,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(f,0)};f.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new f(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},f.fromArray=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new f),o[0]=e[i],o[1]=e[i+1],o[2]=e[i+2],o[3]=e[i+3],o[4]=e[i+4],o[5]=e[i+5],o[6]=e[i+6],o[7]=e[i+7],o[8]=e[i+8],o[9]=e[i+9],o},f.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},f.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,o=e.x*e.y,a=e.x*e.z,s=e.x*e.w,u=e.y*e.y,l=e.y*e.z,h=e.y*e.w,c=e.z*e.z,w=e.z*e.w,d=e.w*e.w,m=i-u-c+d,p=2*(o-w),g=2*(a+h),y=2*(o+w),E=-i+u-c+d,C=2*(l-s),v=2*(a-h),S=2*(l+s),q=-i-u+c+d;return t(r)?(r[0]=m,r[1]=y,r[2]=v,r[3]=p,r[4]=E,r[5]=S,r[6]=g,r[7]=C,r[8]=q,r):new f(m,p,g,y,E,C,v,S,q)},f.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new f(e.x,0,0,0,e.y,0,0,0,e.z)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new f(e,0,0,0,e,0,0,0,e)},f.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=o,r[6]=0,r[7]=-o,r[8]=i,r):new f(1,0,0,0,i,-o,0,o,i)},f.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=i,r):new f(i,0,o,0,1,0,-o,0,i)},f.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=o,r[2]=0,r[3]=-o,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new f(i,-o,0,o,i,0,0,0,1)},f.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},f.getColumn=function(r,i,o){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var a=3*i,s=r[a],u=r[a+1],f=r[a+2];return t(o)?(o.x=s,o.y=u,o.z=f,o):new e(s,u,f)},f.setColumn=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");o=f.clone(e,o);var a=3*r;return o[a]=i.x,o[a+1]=i.y,o[a+2]=i.z,o},f.getRow=function(r,i,o){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var a=r[i],s=r[i+3],u=r[i+6];return t(o)?(o.x=a,o.y=s,o.z=u,o):new e(a,s,u)},f.setRow=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");return o=f.clone(e,o),o[r]=i.x,o[r+3]=i.y,o[r+6]=i.z,o};var l=new e;f.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");return t(i)||(i=new e),i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],l)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],l)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],l)),i};var h=new e;f.getMaximumScale=function(r){return f.getScale(r,h),e.getMaximumComponent(h)},f.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],s=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],l=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],h=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],c=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],w=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],d=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return t(i)?(i[0]=o,i[1]=a,i[2]=s,i[3]=u,i[4]=l,i[5]=h,i[6]=c,i[7]=w,i[8]=d,i):new f(o,u,c,a,l,w,s,h,d)},f.multiplyByVector=function(r,i,o){if(!t(r))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");var a=i.x,s=i.y,u=i.z,f=r[0]*a+r[3]*s+r[6]*u,l=r[1]*a+r[4]*s+r[7]*u,h=r[2]*a+r[5]*s+r[8]*u;return t(o)?(o.x=f,o.y=l,o.z=h,o):new e(f,l,h)},f.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");return t(i)?(i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i):new f(e[0]*r,e[3]*r,e[6]*r,e[1]*r,e[4]*r,e[7]*r,e[2]*r,e[5]*r,e[8]*r)},f.negate=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r):new f(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},f.transpose=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],o=e[3],a=e[6],s=e[1],u=e[4],l=e[7],h=e[2],c=e[5],w=e[8];return t(r)?(r[0]=i,r[1]=o,r[2]=a,r[3]=s,r[4]=u,r[5]=l,r[6]=h,r[7]=c,r[8]=w,r):new f(i,s,h,o,u,c,a,l,w)};var c=[1,0,0],w=[2,2,1],d=new f,m=new f;return f.getEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=o.EPSILON20,l=10,h=0,c=0;
t(r)||(r={});for(var w=r.unitary=f.clone(f.IDENTITY,r.unitary),p=r.diagonal=f.clone(e,r.diagonal),g=i*a(p);l>c&&s(p)>g;)u(p,d),f.transpose(d,m),f.multiply(p,d,p),f.multiply(m,p,p),f.multiply(w,d,w),++h>2&&(++c,h=0);return r},f.abs=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r):new f(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},f.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],o=e[6],a=e[1],s=e[4],u=e[7],f=e[2],l=e[5],h=e[8];return r*(s*h-l*u)+a*(l*o-i*h)+f*(i*u-s*o)},f.inverse=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],a=e[1],s=e[2],u=e[3],l=e[4],h=e[5],c=e[6],w=e[7],d=e[8],m=f.determinant(e);if(Math.abs(m)<=o.EPSILON15)throw new n("matrix is not invertible");t(r)||(r=new f),r[0]=l*d-w*h,r[1]=w*s-a*d,r[2]=a*h-l*s,r[3]=c*h-u*d,r[4]=i*d-c*s,r[5]=u*s-i*h,r[6]=u*w-c*l,r[7]=c*a-i*w,r[8]=i*l-u*a;var p=1/m;return f.multiplyByScalar(r,p,r)},f.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},f.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},f.IDENTITY=i(new f(1,0,0,0,1,0,0,0,1)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN1ROW0=3,f.COLUMN1ROW1=4,f.COLUMN1ROW2=5,f.COLUMN2ROW0=6,f.COLUMN2ROW1=7,f.COLUMN2ROW2=8,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},f}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,o,a,s,u){"use strict";var f=function(e,r,n,i,o,a,s,u,f,l,h,c,w,d,m,p){this[0]=t(e,0),this[1]=t(o,0),this[2]=t(f,0),this[3]=t(w,0),this[4]=t(r,0),this[5]=t(a,0),this[6]=t(l,0),this[7]=t(d,0),this[8]=t(n,0),this[9]=t(s,0),this[10]=t(h,0),this[11]=t(m,0),this[12]=t(i,0),this[13]=t(u,0),this[14]=t(c,0),this[15]=t(p,0)};f.packedLength=16,f.pack=function(e,r,o){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");o=t(o,0),r[o++]=e[0],r[o++]=e[1],r[o++]=e[2],r[o++]=e[3],r[o++]=e[4],r[o++]=e[5],r[o++]=e[6],r[o++]=e[7],r[o++]=e[8],r[o++]=e[9],r[o++]=e[10],r[o++]=e[11],r[o++]=e[12],r[o++]=e[13],r[o++]=e[14],r[o]=e[15]},f.unpack=function(e,r,o){if(!n(e))throw new i("array is required");return r=t(r,0),n(o)||(o=new f),o[0]=e[r++],o[1]=e[r++],o[2]=e[r++],o[3]=e[r++],o[4]=e[r++],o[5]=e[r++],o[6]=e[r++],o[7]=e[r++],o[8]=e[r++],o[9]=e[r++],o[10]=e[r++],o[11]=e[r++],o[12]=e[r++],o[13]=e[r++],o[14]=e[r++],o[15]=e[r],o},f.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(e,r,t){if(!n(e))throw new i("rotation is required.");if(!n(r))throw new i("translation is required.");return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=0,t[4]=e[3],t[5]=e[4],t[6]=e[5],t[7]=0,t[8]=e[6],t[9]=e[7],t[10]=e[8],t[11]=0,t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=1,t):new f(e[0],e[3],e[6],r.x,e[1],e[4],e[7],r.y,e[2],e[5],e[8],r.z,0,0,0,1)},new s,f.fromTranslationQuaternionRotationScale=function(e,r,t,o){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(o)||(o=new f);var a=t.x,s=t.y,u=t.z,l=r.x*r.x,h=r.x*r.y,c=r.x*r.z,w=r.x*r.w,d=r.y*r.y,m=r.y*r.z,p=r.y*r.w,g=r.z*r.z,y=r.z*r.w,E=r.w*r.w,C=l-d-g+E,v=2*(h-y),S=2*(c+p),q=2*(h+y),b=-l+d-g+E,M=2*(m-w),R=2*(c-p),A=2*(m+w),x=-l-d+g+E;return o[0]=C*a,o[1]=q*a,o[2]=R*a,o[3]=0,o[4]=v*s,o[5]=b*s,o[6]=A*s,o[7]=0,o[8]=S*u,o[9]=M*u,o[10]=x*u,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},f.fromTranslation=function(e,r){return f.fromRotationTranslation(s.IDENTITY,e,r)},f.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,h=new e,c=new e;f.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var o=r.eye,a=r.target,s=r.up;if(!n(o))throw new i("camera.eye is required.");if(!n(a))throw new i("camera.target is required.");if(!n(s))throw new i("camera.up is required.");e.normalize(e.subtract(a,o,l),l),e.normalize(e.cross(l,s,h),h),e.normalize(e.cross(h,l,c),c);var u=h.x,w=h.y,d=h.z,m=l.x,p=l.y,g=l.z,y=c.x,E=c.y,C=c.z,v=o.x,S=o.y,q=o.z,b=u*-v+w*-S+d*-q,M=y*-v+E*-S+C*-q,R=m*v+p*S+g*q;return n(t)?(t[0]=u,t[1]=y,t[2]=-m,t[3]=0,t[4]=w,t[5]=E,t[6]=-p,t[7]=0,t[8]=d,t[9]=C,t[10]=-g,t[11]=0,t[12]=b,t[13]=M,t[14]=R,t[15]=1,t):new f(u,w,d,b,y,E,C,M,-m,-p,-g,R,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,r,t,o,a){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=o)throw new i("far must be greater than zero.");var s=Math.tan(.5*e),u=1/s,l=u/r,h=(o+t)/(t-o),c=2*o*t/(t-o);return n(a)?(a[0]=l,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=h,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a):new f(l,0,0,0,0,u,0,0,0,0,h,c,0,0,-1,0)},f.computeOrthographicOffCenter=function(e,r,t,o,a,s,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(s))throw new i("far is required.");var l=1/(r-e),h=1/(o-t),c=1/(s-a),w=-(r+e)*l,d=-(o+t)*h,m=-(s+a)*c;return l*=2,h*=2,c*=-2,n(u)?(u[0]=l,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=h,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=c,u[11]=0,u[12]=w,u[13]=d,u[14]=m,u[15]=1,u):new f(l,0,0,w,0,h,0,d,0,0,c,m,0,0,0,1)},f.computePerspectiveOffCenter=function(e,r,t,o,a,s,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(s))throw new i("far is required.");var l=2*a/(r-e),h=2*a/(o-t),c=(r+e)/(r-e),w=(o+t)/(o-t),d=-(s+a)/(s-a),m=-1,p=-2*s*a/(s-a);return n(u)?(u[0]=l,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=h,u[6]=0,u[7]=0,u[8]=c,u[9]=w,u[10]=d,u[11]=m,u[12]=0,u[13]=0,u[14]=p,u[15]=0,u):new f(l,0,c,0,0,h,w,0,0,0,d,p,0,0,m,0)},f.computeInfinitePerspectiveOffCenter=function(e,r,t,o,a,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");var u=2*a/(r-e),l=2*a/(o-t),h=(r+e)/(r-e),c=(o+t)/(o-t),w=-1,d=-1,m=-2*a;return n(s)?(s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=l,s[6]=0,s[7]=0,s[8]=h,s[9]=c,s[10]=w,s[11]=d,s[12]=0,s[13]=0,s[14]=m,s[15]=0,s):new f(u,0,h,0,0,l,c,0,0,0,w,m,0,0,d,0)},f.computeViewportTransformation=function(e,r,i,o){e=t(e,t.EMPTY_OBJECT);var a=t(e.x,0),s=t(e.y,0),u=t(e.width,0),l=t(e.height,0);r=t(r,0),i=t(i,1);var h=.5*u,c=.5*l,w=.5*(i-r),d=h,m=c,p=w,g=a+h,y=s+c,E=r+w,C=1;return n(o)?(o[0]=d,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=m,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=p,o[11]=0,o[12]=g,o[13]=y,o[14]=E,o[15]=C,o):new f(d,0,0,g,0,m,0,y,0,0,p,E,0,0,0,C)},f.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},f.getColumn=function(e,t,o){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var a=4*t,s=e[a],u=e[a+1],f=e[a+2],l=e[a+3];return n(o)?(o.x=s,o.y=u,o.z=f,o.w=l,o):new r(s,u,f,l)},f.setColumn=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");o=f.clone(e,o);var a=4*r;return o[a]=t.x,o[a+1]=t.y,o[a+2]=t.z,o[a+3]=t.w,o},f.getRow=function(e,t,o){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var a=e[t],s=e[t+4],u=e[t+8],f=e[t+12];return n(o)?(o.x=a,o.y=s,o.z=u,o.w=f,o):new r(a,s,u,f)},f.setRow=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");return o=f.clone(e,o),o[r]=t.x,o[r+4]=t.y,o[r+8]=t.z,o[r+12]=t.w,o};var w=new e;f.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");return n(t)||(t=new e),t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],w)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],w)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],w)),t};var d=new e;f.getMaximumScale=function(r){return f.getScale(r,d),e.getMaximumComponent(d)},f.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var o=e[0],a=e[1],s=e[2],u=e[3],l=e[4],h=e[5],c=e[6],w=e[7],d=e[8],m=e[9],p=e[10],g=e[11],y=e[12],E=e[13],C=e[14],v=e[15],S=r[0],q=r[1],b=r[2],M=r[3],R=r[4],A=r[5],x=r[6],O=r[7],I=r[8],T=r[9],N=r[10],F=r[11],_=r[12],D=r[13],L=r[14],P=r[15],z=o*S+l*q+d*b+y*M,B=a*S+h*q+m*b+E*M,U=s*S+c*q+p*b+C*M,G=u*S+w*q+g*b+v*M,W=o*R+l*A+d*x+y*O,Y=a*R+h*A+m*x+E*O,H=s*R+c*A+p*x+C*O,V=u*R+w*A+g*x+v*O,K=o*I+l*T+d*N+y*F,k=a*I+h*T+m*N+E*F,j=s*I+c*T+p*N+C*F,Z=u*I+w*T+g*N+v*F,Q=o*_+l*D+d*L+y*P,X=a*_+h*D+m*L+E*P,J=s*_+c*D+p*L+C*P,$=u*_+w*D+g*L+v*P;return n(t)?(t[0]=z,t[1]=B,t[2]=U,t[3]=G,t[4]=W,t[5]=Y,t[6]=H,t[7]=V,t[8]=K,t[9]=k,t[10]=j,t[11]=Z,t[12]=Q,t[13]=X,t[14]=J,t[15]=$,t):new f(z,W,K,Q,B,Y,k,X,U,H,j,J,G,V,Z,$)},f.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var o=e[0],a=e[1],s=e[2],u=e[4],l=e[5],h=e[6],c=e[8],w=e[9],d=e[10],m=e[12],p=e[13],g=e[14],y=r[0],E=r[1],C=r[2],v=r[4],S=r[5],q=r[6],b=r[8],M=r[9],R=r[10],A=r[12],x=r[13],O=r[14],I=o*y+u*E+c*C,T=a*y+l*E+w*C,N=s*y+h*E+d*C,F=o*v+u*S+c*q,_=a*v+l*S+w*q,D=s*v+h*S+d*q,L=o*b+u*M+c*R,P=a*b+l*M+w*R,z=s*b+h*M+d*R,B=o*A+u*x+c*O+m,U=a*A+l*x+w*O+p,G=s*A+h*x+d*O+g;return n(t)?(t[0]=I,t[1]=T,t[2]=N,t[3]=0,t[4]=F,t[5]=_,t[6]=D,t[7]=0,t[8]=L,t[9]=P,t[10]=z,t[11]=0,t[12]=B,t[13]=U,t[14]=G,t[15]=1,t):new f(I,F,L,B,T,_,P,U,N,D,z,G,0,0,0,1)},f.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");var o=r.x,a=r.y,s=r.z,u=o*e[0]+a*e[4]+s*e[8]+e[12],l=o*e[1]+a*e[5]+s*e[9]+e[13],h=o*e[2]+a*e[6]+s*e[10]+e[14];return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=u,t[13]=l,t[14]=h,t[15]=e[15],t):new f(e[0],e[4],e[8],u,e[1],e[5],e[9],l,e[2],e[6],e[10],h,e[3],e[7],e[11],e[15])};var m=new e;return f.multiplyByUniformScale=function(e,r,t){if("number"!=typeof r)throw new i("scale is required");return m.x=r,m.y=r,m.z=r,f.multiplyByScale(e,m,t)},f.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");var o=r.x,a=r.y,s=r.z;return 1===o&&1===a&&1===s?f.clone(e,t):n(t)?(t[0]=o*e[0],t[1]=o*e[1],t[2]=o*e[2],t[3]=0,t[4]=a*e[4],t[5]=a*e[5],t[6]=a*e[6],t[7]=0,t[8]=s*e[8],t[9]=s*e[9],t[10]=s*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t):new f(o*e[0],a*e[4],s*e[8],e[12],o*e[1],a*e[5],s*e[9],e[13],o*e[2],a*e[6],s*e[10],e[14],0,0,0,1)},f.multiplyByVector=function(e,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var a=t.x,s=t.y,u=t.z,f=t.w,l=e[0]*a+e[4]*s+e[8]*u+e[12]*f,h=e[1]*a+e[5]*s+e[9]*u+e[13]*f,c=e[2]*a+e[6]*s+e[10]*u+e[14]*f,w=e[3]*a+e[7]*s+e[11]*u+e[15]*f;return n(o)?(o.x=l,o.y=h,o.z=c,o.w=w,o):new r(l,h,c,w)},f.multiplyByPointAsVector=function(r,t,o){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var a=t.x,s=t.y,u=t.z,f=r[0]*a+r[4]*s+r[8]*u,l=r[1]*a+r[5]*s+r[9]*u,h=r[2]*a+r[6]*s+r[10]*u;return n(o)?(o.x=f,o.y=l,o.z=h,o):new e(f,l,h)},f.multiplyByPoint=function(r,t,o){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var a=t.x,s=t.y,u=t.z,f=r[0]*a+r[4]*s+r[8]*u+r[12],l=r[1]*a+r[5]*s+r[9]*u+r[13],h=r[2]*a+r[6]*s+r[10]*u+r[14];return n(o)?(o.x=f,o.y=l,o.z=h,o):new e(f,l,h)},f.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");return n(t)?(t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t):new f(e[0]*r,e[4]*r,e[8]*r,e[12]*r,e[1]*r,e[5]*r,e[9]*r,e[13]*r,e[2]*r,e[6]*r,e[10]*r,e[14]*r,e[3]*r,e[7]*r,e[11]*r,e[15]*r)},f.negate=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r):new f(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},f.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))return new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var t=e[1],o=e[2],a=e[3],s=e[6],u=e[7],l=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=o,r[9]=s,r[10]=e[10],r[11]=e[14],r[12]=a,r[13]=u,r[14]=l,r[15]=e[15],r},f.abs=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r):new f(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},f.equals=function(e,r){return e===r||n(e)&&n(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[11]===r[11]&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[15]===r[15]},f.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},f.getTranslation=function(r,t){if(!n(r))throw new i("matrix is required");return n(t)?(t.x=r[12],t.y=r[13],t.z=r[14],t):new e(r[12],r[13],r[14])},f.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r):new s(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},f.inverse=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],o=e[4],s=e[8],l=e[12],h=e[1],c=e[5],w=e[9],d=e[13],m=e[2],p=e[6],g=e[10],y=e[14],E=e[3],C=e[7],v=e[11],S=e[15],q=g*S,b=y*v,M=p*S,R=y*C,A=p*v,x=g*C,O=m*S,I=y*E,T=m*v,N=g*E,F=m*C,_=p*E,D=q*c+R*w+A*d-(b*c+M*w+x*d),L=b*h+O*w+N*d-(q*h+I*w+T*d),P=M*h+I*c+F*d-(R*h+O*c+_*d),z=x*h+T*c+_*w-(A*h+N*c+F*w),B=b*o+M*s+x*l-(q*o+R*s+A*l),U=q*t+I*s+T*l-(b*t+O*s+N*l),G=R*t+O*o+_*l-(M*t+I*o+F*l),W=A*t+N*o+F*s-(x*t+T*o+_*s);q=s*d,b=l*w,M=o*d,R=l*c,A=o*w,x=s*c,O=t*d,I=l*h,T=t*w,N=s*h,F=t*c,_=o*h;var Y=q*C+R*v+A*S-(b*C+M*v+x*S),H=b*E+O*v+N*S-(q*E+I*v+T*S),V=M*E+I*C+F*S-(R*E+O*C+_*S),K=x*E+T*C+_*v-(A*E+N*C+F*v),k=M*g+x*y+b*p-(A*y+q*p+R*g),j=T*y+q*m+I*g-(O*g+N*y+b*m),Z=O*p+_*y+R*m-(F*y+M*m+I*p),Q=F*g+A*m+N*p-(T*p+_*g+x*m),X=t*D+o*L+s*P+l*z;if(Math.abs(X)<a.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return X=1/X,n(r)?(r[0]=D*X,r[1]=L*X,r[2]=P*X,r[3]=z*X,r[4]=B*X,r[5]=U*X,r[6]=G*X,r[7]=W*X,r[8]=Y*X,r[9]=H*X,r[10]=V*X,r[11]=K*X,r[12]=k*X,r[13]=j*X,r[14]=Z*X,r[15]=Q*X,r):new f(D*X,B*X,Y*X,k*X,L*X,U*X,H*X,j*X,P*X,G*X,V*X,Z*X,z*X,W*X,K*X,Q*X)},f.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],o=e[1],a=e[2],s=e[4],u=e[5],l=e[6],h=e[8],c=e[9],w=e[10],d=e[12],m=e[13],p=e[14],g=-t*d-o*m-a*p,y=-s*d-u*m-l*p,E=-h*d-c*m-w*p;return n(r)?(r[0]=t,r[1]=s,r[2]=h,r[3]=0,r[4]=o,r[5]=u,r[6]=c,r[7]=0,r[8]=a,r[9]=l,r[10]=w,r[11]=0,r[12]=g,r[13]=y,r[14]=E,r[15]=1,r):new f(t,o,a,g,s,u,l,y,h,c,w,E,0,0,0,1)},f.IDENTITY=o(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,o,a){"use strict";var s=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};s.fromDegrees=function(e,n,i,o,u){return e=a.toRadians(r(e,0)),n=a.toRadians(r(n,0)),i=a.toRadians(r(i,0)),o=a.toRadians(r(o,0)),t(u)?(u.west=e,u.south=n,u.east=i,u.north=o,u):new s(e,n,i,o)},s.fromCartographicArray=function(e,r){if(!t(e))throw new n("cartographics is required.");for(var i=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,u=-Number.MAX_VALUE,f=0,l=e.length;l>f;f++){var h=e[f];i=Math.min(i,h.longitude),o=Math.max(o,h.longitude),a=Math.min(a,h.latitude),u=Math.max(u,h.latitude)}return t(r)?(r.west=i,r.south=a,r.east=o,r.north=u,r):new s(i,a,o,u)},s.packedLength=4,s.pack=function(e,i,o){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");o=r(o,0),i[o++]=e.west,i[o++]=e.south,i[o++]=e.east,i[o]=e.north},s.unpack=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new s),o.west=e[i++],o.south=e[i++],o.east=e[i++],o.north=e[i],o},s.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},s.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new n("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){if(!t(e))throw new n("rectangle is required");var r=e.north;if("number"!=typeof r)throw new n("north is required to be a number.");if(r<-a.PI_OVER_TWO||r>a.PI_OVER_TWO)throw new n("north must be in the interval [-Pi/2, Pi/2].");var i=e.south;if("number"!=typeof i)throw new n("south is required to be a number.");if(i<-a.PI_OVER_TWO||i>a.PI_OVER_TWO)throw new n("south must be in the interval [-Pi/2, Pi/2].");var o=e.west;if("number"!=typeof o)throw new n("west is required to be a number.");if(o<-Math.PI||o>Math.PI)throw new n("west must be in the interval [-Pi, Pi].");var s=e.east;if("number"!=typeof s)throw new n("east is required to be a number.");if(s<-Math.PI||s>Math.PI)throw new n("east must be in the interval [-Pi, Pi].")},s.getSouthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.getNorthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.getNortheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.getSoutheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.getCenter=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=.5*(r.west+r.east),i.latitude=.5*(r.south+r.north),i.height=0,i):new e(.5*(r.west+r.east),.5*(r.south+r.north))},s.intersectWith=function(e,r,i){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("otherRectangle is required.");var o=Math.max(e.west,r.west),a=Math.max(e.south,r.south),u=Math.min(e.east,r.east),f=Math.min(e.north,r.north);return t(i)?(i.west=o,i.south=a,i.east=u,i.north=f,i):new s(o,a,u,f)},s.contains=function(e,r){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("cartographic is required.");return r.longitude>=e.west&&r.longitude<=e.east&&r.latitude>=e.south&&r.latitude<=e.north},s.isEmpty=function(e){if(!t(e))throw new n("rectangle is required");return e.west>=e.east||e.south>=e.north};var u=new e;return s.subsample=function(e,o,s,f){if(!t(e))throw new n("rectangle is required");o=r(o,i.WGS84),s=r(s,0),t(f)||(f=[]);var l=0,h=e.north,c=e.south,w=e.east,d=e.west,m=u;m.height=s,m.longitude=d,m.latitude=h,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.longitude=w,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.latitude=c,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.longitude=d,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.latitude=0>h?h:c>0?c:0;for(var p=1;8>p;++p){var g=-Math.PI+p*a.PI_OVER_TWO;g>d&&w>g&&(m.longitude=g,f[l]=o.cartographicToCartesian(m,f[l]),l++)}return 0===m.latitude&&(m.longitude=d,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.longitude=w,f[l]=o.cartographicToCartesian(m,f[l]),l++),f.length=l,f},s.MAX_VALUE=o(new s(-Math.PI,-a.PI_OVER_TWO,Math.PI,a.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,r,t,n,i,o,a,s,u,f,l){"use strict";var h=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},c=new e,w=new e,d=new e,m=new e,p=new e,g=new e,y=new e,E=new e,C=new e,v=new e,S=new e,q=new e;h.fromPoints=function(r,t){if(n(t)||(t=new h),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],y),o=e.clone(i,c),a=e.clone(i,w),s=e.clone(i,d),u=e.clone(i,m),f=e.clone(i,p),l=e.clone(i,g),b=r.length,M=1;b>M;M++){e.clone(r[M],i);var R=i.x,A=i.y,x=i.z;R<o.x&&e.clone(i,o),R>u.x&&e.clone(i,u),A<a.y&&e.clone(i,a),A>f.y&&e.clone(i,f),x<s.z&&e.clone(i,s),x>l.z&&e.clone(i,l)}var O=e.magnitudeSquared(e.subtract(u,o,E)),I=e.magnitudeSquared(e.subtract(f,a,E)),T=e.magnitudeSquared(e.subtract(l,s,E)),N=o,F=u,_=O;I>_&&(_=I,N=a,F=f),T>_&&(_=T,N=s,F=l);var D=C;D.x=.5*(N.x+F.x),D.y=.5*(N.y+F.y),D.z=.5*(N.z+F.z);var L=e.magnitudeSquared(e.subtract(F,D,E)),P=Math.sqrt(L),z=v;z.x=o.x,z.y=a.y,z.z=s.z;var B=S;B.x=u.x,B.y=f.y,B.z=l.z;var U=e.multiplyByScalar(e.add(z,B,E),.5,q),G=0;for(M=0;b>M;M++){e.clone(r[M],i);var W=e.magnitude(e.subtract(i,U,E));W>G&&(G=W);var Y=e.magnitudeSquared(e.subtract(i,D,E));if(Y>L){var H=Math.sqrt(Y);P=.5*(P+H),L=P*P;var V=H-P;D.x=(P*D.x+V*i.x)/H,D.y=(P*D.y+V*i.y)/H,D.z=(P*D.z+V*i.z)/H}}return G>P?(e.clone(D,t.center),t.radius=P):(e.clone(U,t.center),t.radius=G),t};var b=new a,M=new e,R=new e,A=new r,x=new r;h.fromRectangle2D=function(e,r,t){return h.fromRectangleWithHeights2D(e,r,0,0,t)},h.fromRectangleWithHeights2D=function(r,i,o,a,s){if(n(s)||(s=new h),!n(r))return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;i=t(i,b),l.getSouthwest(r,A),A.height=o,l.getNortheast(r,x),x.height=a;var u=i.project(A,M),f=i.project(x,R),c=f.x-u.x,w=f.y-u.y,d=f.z-u.z;s.radius=.5*Math.sqrt(c*c+w*w+d*d);var m=s.center;return m.x=u.x+.5*c,m.y=u.y+.5*w,m.z=u.z+.5*d,s};var O=[];h.fromRectangle3D=function(e,r,i,a){r=t(r,o.WGS84),i=t(i,0);var s;return n(e)&&(s=l.subsample(e,r,i,O)),h.fromPoints(s,a)},h.fromVertices=function(r,o,a,s){if(n(s)||(s=new h),!n(r)||0===r.length)return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;if(o=t(o,e.ZERO),a=t(a,3),3>a)throw new i("stride must be 3 or greater.");var u=y;u.x=r[0]+o.x,u.y=r[1]+o.y,u.z=r[2]+o.z;for(var f=e.clone(u,c),l=e.clone(u,w),b=e.clone(u,d),M=e.clone(u,m),R=e.clone(u,p),A=e.clone(u,g),x=r.length,O=0;x>O;O+=a){var I=r[O]+o.x,T=r[O+1]+o.y,N=r[O+2]+o.z;u.x=I,u.y=T,u.z=N,I<f.x&&e.clone(u,f),I>M.x&&e.clone(u,M),T<l.y&&e.clone(u,l),T>R.y&&e.clone(u,R),N<b.z&&e.clone(u,b),N>A.z&&e.clone(u,A)}var F=e.magnitudeSquared(e.subtract(M,f,E)),_=e.magnitudeSquared(e.subtract(R,l,E)),D=e.magnitudeSquared(e.subtract(A,b,E)),L=f,P=M,z=F;_>z&&(z=_,L=l,P=R),D>z&&(z=D,L=b,P=A);var B=C;B.x=.5*(L.x+P.x),B.y=.5*(L.y+P.y),B.z=.5*(L.z+P.z);var U=e.magnitudeSquared(e.subtract(P,B,E)),G=Math.sqrt(U),W=v;W.x=f.x,W.y=l.y,W.z=b.z;var Y=S;Y.x=M.x,Y.y=R.y,Y.z=A.z;var H=e.multiplyByScalar(e.add(W,Y,E),.5,q),V=0;for(O=0;x>O;O+=a){u.x=r[O]+o.x,u.y=r[O+1]+o.y,u.z=r[O+2]+o.z;var K=e.magnitude(e.subtract(u,H,E));K>V&&(V=K);var k=e.magnitudeSquared(e.subtract(u,B,E));if(k>U){var j=Math.sqrt(k);G=.5*(G+j),U=G*G;var Z=j-G;B.x=(G*B.x+Z*u.x)/j,B.y=(G*B.y+Z*u.y)/j,B.z=(G*B.z+Z*u.z)/j}}return V>G?(e.clone(B,s.center),s.radius=G):(e.clone(H,s.center),s.radius=V),s},h.fromCornerPoints=function(r,t,o){if(!n(r)||!n(t))throw new i("corner and oppositeCorner are required.");n(o)||(o=new h);var a=o.center;return e.add(r,t,a),e.multiplyByScalar(a,.5,a),o.radius=e.distance(a,t),o},h.fromEllipsoid=function(r,t){if(!n(r))throw new i("ellipsoid is required.");return n(t)||(t=new h),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t},h.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new h(r.center,r.radius):void 0},h.packedLength=4,h.pack=function(e,r,o){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");o=t(o,0);var a=e.center;r[o++]=a.x,r[o++]=a.y,r[o++]=a.z,r[o]=e.radius},h.unpack=function(e,r,o){if(!n(e))throw new i("array is required");r=t(r,0),n(o)||(o=new h);var a=o.center;return a.x=e[r++],a.y=e[r++],a.z=e[r++],o.radius=e[r],o};var I=new e,T=new e;h.union=function(r,t,o){if(!n(r))throw new i("left is required.");if(!n(t))throw new i("right is required.");n(o)||(o=new h);var a=r.center,s=t.center;e.add(a,s,T);var u=e.multiplyByScalar(T,.5,T),f=e.magnitude(e.subtract(a,u,I))+r.radius,l=e.magnitude(e.subtract(s,u,I))+t.radius;return o.radius=Math.max(f,l),e.clone(u,o.center),o};var N=new e;h.expand=function(r,t,o){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("point is required.");o=h.clone(r,o);var a=e.magnitude(e.subtract(t,o.center,N));return a>o.radius&&(o.radius=a),o},h.intersect=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("plane is required.");var o=r.center,a=r.radius,u=e.dot(t,o)+t.w;return-a>u?s.OUTSIDE:a>u?s.INTERSECTING:s.INSIDE},h.transform=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new h),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=f.getMaximumScale(r)*e.radius,t};var F=new e;h.distanceSquaredTo=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("cartesian is required.");var o=e.subtract(r.center,t,F);return e.magnitudeSquared(o)-r.radius*r.radius},h.transformWithoutScale=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new h),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var _=new e;h.getPlaneDistances=function(r,t,o,a){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("position is required.");if(!n(o))throw new i("direction is required.");n(a)||(a=new u);var s=e.subtract(r.center,t,_),f=e.multiplyByScalar(o,e.dot(o,s),_),l=e.magnitude(f);return a.start=l-r.radius,a.stop=l+r.radius,a};for(var D=new e,L=new e,P=new e,z=new e,B=new e,U=new r,G=new Array(8),W=0;8>W;++W)G[W]=new e;var Y=new a;return h.projectTo2D=function(r,o,a){if(!n(r))throw new i("sphere is required.");o=t(o,Y);var s=o.ellipsoid,u=r.center,f=r.radius,l=s.geodeticSurfaceNormal(u,D),c=e.cross(e.UNIT_Z,l,L);e.normalize(c,c);var w=e.cross(l,c,P);e.normalize(w,w),e.multiplyByScalar(l,f,l),e.multiplyByScalar(w,f,w),e.multiplyByScalar(c,f,c);var d=e.negate(w,B),m=e.negate(c,z),p=G,g=p[0];e.add(l,w,g),e.add(g,c,g),g=p[1],e.add(l,w,g),e.add(g,m,g),g=p[2],e.add(l,d,g),e.add(g,m,g),g=p[3],e.add(l,d,g),e.add(g,c,g),e.negate(l,l),g=p[4],e.add(l,w,g),e.add(g,c,g),g=p[5],e.add(l,w,g),e.add(g,m,g),g=p[6],e.add(l,d,g),e.add(g,m,g),g=p[7],e.add(l,d,g),e.add(g,c,g);for(var y=p.length,E=0;y>E;++E){var C=p[E];e.add(u,C,C);var v=s.cartesianToCartographic(C,U);o.project(v,C)}a=h.fromPoints(p,a),u=a.center;var S=u.x,q=u.y,b=u.z;return u.x=b,u.y=S,u.z=q,a},h.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius
},h.prototype.intersect=function(e){return h.intersect(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.clone=function(e){return h.clone(this,e)},h}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,o=["webkit","moz","o","ms","khtml"],a=0,s=o.length;s>a;++a){var u=o[a];i=u+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=u+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=u+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=u+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=u+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=u+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=u+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=u+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=u+"fullscreenchange",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=u+"fullscreenerror",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(c)){var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null===e?c=!1:(c=!0,w=n(e[1]))}return c}function o(){return i()&&w}function a(){if(!r(d))if(i()||!/ Safari\/[\.0-9]+/.test(navigator.userAgent))d=!1;else{var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null===e?d=!1:(d=!0,m=n(e[1]))}return d}function s(){return a()&&m}function u(){if(!r(p)){var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null===e?p=!1:(p=!0,g=n(e[1]),g.isNightly=!!e[2])}return p}function f(){return u()&&g}function l(){if(!r(y)){var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(y=!0,E=n(e[1]))):"Netscape"===navigator.appName?(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(y=!0,E=n(e[1]))):y=!1}return y}function h(){return l()&&E}var c,w,d,m,p,g,y,E,C={isChrome:i,chromeVersion:o,isSafari:a,safariVersion:s,isWebkit:u,webkitVersion:f,isInternetExplorer:l,internetExplorerVersion:h,hardwareConcurrency:e(navigator.hardwareConcurrency,3)};return C.supportsFullscreen=function(){return t.supportsFullscreen()},C.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},C}),define("Core/Color",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math"],function(e,r,t,n,i,o){"use strict";function a(e,r,t){return 0>t&&(t+=1),t>1&&(t-=1),1>6*t?e+6*(r-e)*t:1>2*t?r:2>3*t?e+6*(r-e)*(2/3-t):e}var s=function(r,t,n,i){this.red=e(r,1),this.green=e(t,1),this.blue=e(n,1),this.alpha=e(i,1)};s.fromCartesian4=function(e,n){if(!r(e))throw new t("cartesian is required");return r(n)?(n.red=e.x,n.green=e.y,n.blue=e.z,n.alpha=e.w,n):new s(e.x,e.y,e.z,e.w)},s.fromBytes=function(r,t,n,i){return r=s.byteToFloat(e(r,255)),t=s.byteToFloat(e(t,255)),n=s.byteToFloat(e(n,255)),i=s.byteToFloat(e(i,255)),new s(r,t,n,i)};var u,f,l;n.supportsTypedArrays()&&(u=new ArrayBuffer(4),f=new Uint32Array(u),l=new Uint8Array(u)),s.fromRgba=function(e){return f[0]=e,s.fromBytes(l[0],l[1],l[2],l[3])},s.fromHsl=function(r,t,n,i){r=e(r,0)%1,t=e(t,0),n=e(n,0),i=e(i,1);var o=n,u=n,f=n;if(0!==t){var l;l=.5>n?n*(1+t):n+t-n*t;var h=2*n-l;o=a(h,l,r+1/3),u=a(h,l,r),f=a(h,l,r-1/3)}return new s(o,u,f,i)},s.fromRandom=function(n,i){n=e(n,e.EMPTY_OBJECT);var a=n.red;if(!r(a)){var u=e(n.minimumRed,0),f=e(n.maximumRed,1);if(u>f)throw new t("minimumRed must be less than or equal to maximumRed");a=u+o.nextRandomNumber()*(f-u)}var l=n.green;if(!r(l)){var h=e(n.minimumGreen,0),c=e(n.maximumGreen,1);if(h>c)throw new t("minimumGreen must be less than or equal to maximumGreen");l=h+o.nextRandomNumber()*(c-h)}var w=n.blue;if(!r(w)){var d=e(n.minimumBlue,0),m=e(n.maximumBlue,1);if(d>m)throw new t("minimumBlue must be less than or equal to maximumBlue");w=d+o.nextRandomNumber()*(m-d)}var p=n.alpha;if(!r(p)){var g=e(n.minimumAlpha,0),y=e(n.maximumAlpha,1);if(g>y)throw new t("minimumAlpha must be less than or equal to maximumAlpha");p=g+o.nextRandomNumber()*(y-g)}return r(i)?(i.red=a,i.green=l,i.blue=w,i.alpha=p,i):new s(a,l,w,p)};var h=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,c=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,w=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,d=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(n){if(!r(n))throw new t("color is required");var i=s[n.toUpperCase()];if(r(i))return s.clone(i);var o=h.exec(n);return null!==o?new s(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=c.exec(n),null!==o?new s(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=w.exec(n),null!==o?new s(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(e(o[4],"1.0"))):(o=d.exec(n),null!==o?s.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(e(o[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.red,i[o++]=n.green,i[o++]=n.blue,i[o]=n.alpha},s.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new s),o.red=n[i++],o.green=n[i++],o.blue=n[i++],o.alpha=n[i],o},s.byteToFloat=function(e){return e/255},s.floatToByte=function(e){return 1===e?255:0|256*e},s.clone=function(e,t){return r(e)?r(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new s(e.red,e.green,e.blue,e.alpha):void 0},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return this===e||r(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var e=s.floatToByte(this.red),r=s.floatToByte(this.green),t=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+r+","+t+")":"rgba("+e+","+r+","+t+","+this.alpha+")"},s.prototype.toBytes=function(e){var t=s.floatToByte(this.red),n=s.floatToByte(this.green),i=s.floatToByte(this.blue),o=s.floatToByte(this.alpha);return r(e)?(e[0]=t,e[1]=n,e[2]=i,e[3]=o,e):[t,n,i,o]},s.prototype.toRgba=function(){return l[0]=s.floatToByte(this.red),l[1]=s.floatToByte(this.green),l[2]=s.floatToByte(this.blue),l[3]=s.floatToByte(this.alpha),f[0]},s.ALICEBLUE=i(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=i(s.fromCssColorString("#FAEBD7")),s.AQUA=i(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=i(s.fromCssColorString("#7FFFD4")),s.AZURE=i(s.fromCssColorString("#F0FFFF")),s.BEIGE=i(s.fromCssColorString("#F5F5DC")),s.BISQUE=i(s.fromCssColorString("#FFE4C4")),s.BLACK=i(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=i(s.fromCssColorString("#FFEBCD")),s.BLUE=i(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=i(s.fromCssColorString("#8A2BE2")),s.BROWN=i(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=i(s.fromCssColorString("#DEB887")),s.CADETBLUE=i(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=i(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=i(s.fromCssColorString("#D2691E")),s.CORAL=i(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=i(s.fromCssColorString("#6495ED")),s.CORNSILK=i(s.fromCssColorString("#FFF8DC")),s.CRIMSON=i(s.fromCssColorString("#DC143C")),s.CYAN=i(s.fromCssColorString("#00FFFF")),s.DARKBLUE=i(s.fromCssColorString("#00008B")),s.DARKCYAN=i(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=i(s.fromCssColorString("#B8860B")),s.DARKGRAY=i(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=i(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=i(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=i(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=i(s.fromCssColorString("#556B2F")),s.DARKORANGE=i(s.fromCssColorString("#FF8C00")),s.DARKORCHID=i(s.fromCssColorString("#9932CC")),s.DARKRED=i(s.fromCssColorString("#8B0000")),s.DARKSALMON=i(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=i(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=i(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=i(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=i(s.fromCssColorString("#00CED1")),s.DARKVIOLET=i(s.fromCssColorString("#9400D3")),s.DEEPPINK=i(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=i(s.fromCssColorString("#00BFFF")),s.DIMGRAY=i(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=i(s.fromCssColorString("#1E90FF")),s.FIREBRICK=i(s.fromCssColorString("#B22222")),s.FLORALWHITE=i(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=i(s.fromCssColorString("#228B22")),s.FUSCHIA=i(s.fromCssColorString("#FF00FF")),s.GAINSBORO=i(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=i(s.fromCssColorString("#F8F8FF")),s.GOLD=i(s.fromCssColorString("#FFD700")),s.GOLDENROD=i(s.fromCssColorString("#DAA520")),s.GRAY=i(s.fromCssColorString("#808080")),s.GREEN=i(s.fromCssColorString("#008000")),s.GREENYELLOW=i(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=i(s.fromCssColorString("#F0FFF0")),s.HOTPINK=i(s.fromCssColorString("#FF69B4")),s.INDIANRED=i(s.fromCssColorString("#CD5C5C")),s.INDIGO=i(s.fromCssColorString("#4B0082")),s.IVORY=i(s.fromCssColorString("#FFFFF0")),s.KHAKI=i(s.fromCssColorString("#F0E68C")),s.LAVENDER=i(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=i(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=i(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=i(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=i(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=i(s.fromCssColorString("#F08080")),s.LIGHTCYAN=i(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=i(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=i(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=i(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=i(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=i(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=i(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=i(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=i(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=i(s.fromCssColorString("#FFFFE0")),s.LIME=i(s.fromCssColorString("#00FF00")),s.LIMEGREEN=i(s.fromCssColorString("#32CD32")),s.LINEN=i(s.fromCssColorString("#FAF0E6")),s.MAGENTA=i(s.fromCssColorString("#FF00FF")),s.MAROON=i(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=i(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=i(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=i(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=i(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=i(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=i(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=i(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=i(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=i(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=i(s.fromCssColorString("#191970")),s.MINTCREAM=i(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=i(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=i(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=i(s.fromCssColorString("#FFDEAD")),s.NAVY=i(s.fromCssColorString("#000080")),s.OLDLACE=i(s.fromCssColorString("#FDF5E6")),s.OLIVE=i(s.fromCssColorString("#808000")),s.OLIVEDRAB=i(s.fromCssColorString("#6B8E23")),s.ORANGE=i(s.fromCssColorString("#FFA500")),s.ORANGERED=i(s.fromCssColorString("#FF4500")),s.ORCHID=i(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=i(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=i(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=i(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=i(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=i(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=i(s.fromCssColorString("#FFDAB9")),s.PERU=i(s.fromCssColorString("#CD853F")),s.PINK=i(s.fromCssColorString("#FFC0CB")),s.PLUM=i(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=i(s.fromCssColorString("#B0E0E6")),s.PURPLE=i(s.fromCssColorString("#800080")),s.RED=i(s.fromCssColorString("#FF0000")),s.ROSYBROWN=i(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=i(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=i(s.fromCssColorString("#8B4513")),s.SALMON=i(s.fromCssColorString("#FA8072")),s.SANDYBROWN=i(s.fromCssColorString("#F4A460")),s.SEAGREEN=i(s.fromCssColorString("#2E8B57")),s.SEASHELL=i(s.fromCssColorString("#FFF5EE")),s.SIENNA=i(s.fromCssColorString("#A0522D")),s.SILVER=i(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=i(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=i(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=i(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=i(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=i(s.fromCssColorString("#00FF7F")),s.STEELBLUE=i(s.fromCssColorString("#4682B4")),s.TAN=i(s.fromCssColorString("#D2B48C")),s.TEAL=i(s.fromCssColorString("#008080")),s.THISTLE=i(s.fromCssColorString("#D8BFD8")),s.TOMATO=i(s.fromCssColorString("#FF6347")),s.TURQUOISE=i(s.fromCssColorString("#40E0D0")),s.VIOLET=i(s.fromCssColorString("#EE82EE")),s.WHEAT=i(s.fromCssColorString("#F5DEB3")),s.WHITE=i(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=i(s.fromCssColorString("#F5F5F5")),s.YELLOW=i(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=i(s.fromCssColorString("#9ACD32")),s}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection"],function(e,r,t,n){"use strict";if(!n.supportsTypedArrays())return{};var i={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return i.getSizeInBytes=function(e){if(!r(e))throw new t("value is required.");switch(e){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new t("componentDatatype is not a valid value.")}},i.fromTypedArray=function(e){return e instanceof Int8Array?i.BYTE:e instanceof Uint8Array?i.UNSIGNED_BYTE:e instanceof Int16Array?i.SHORT:e instanceof Uint16Array?i.UNSIGNED_SHORT:e instanceof Float32Array?i.FLOAT:e instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(e){return r(e)&&(e===i.BYTE||e===i.UNSIGNED_BYTE||e===i.SHORT||e===i.UNSIGNED_SHORT||e===i.FLOAT||e===i.DOUBLE)},i.createTypedArray=function(e,n){if(!r(e))throw new t("componentDatatype is required.");if(!r(n))throw new t("valuesOrLength is required.");switch(e){case i.BYTE:return new Int8Array(n);case i.UNSIGNED_BYTE:return new Uint8Array(n);case i.SHORT:return new Int16Array(n);case i.UNSIGNED_SHORT:return new Uint16Array(n);case i.FLOAT:return new Float32Array(n);case i.DOUBLE:return new Float64Array(n);default:throw new t("componentDatatype is not a valid value.")}},i.createArrayBufferView=function(n,o,a,s){if(!r(n))throw new t("componentDatatype is required.");if(!r(o))throw new t("buffer is required.");switch(a=e(a,0),s=e(s,(o.byteLength-a)/i.getSizeInBytes(n)),n){case i.BYTE:return new Int8Array(o,a,s);case i.UNSIGNED_BYTE:return new Uint8Array(o,a,s);case i.SHORT:return new Int16Array(o,a,s);case i.UNSIGNED_SHORT:return new Uint16Array(o,a,s);case i.FLOAT:return new Float32Array(o,a,s);case i.DOUBLE:return new Float64Array(o,a,s);default:throw new t("componentDatatype is not a valid value.")}},i}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.attributes))throw new t("options.attributes is required.");if(!r(n.primitiveType))throw new t("options.primitiveType is required.");this.attributes=n.attributes,this.indices=n.indices,this.primitiveType=n.primitiveType,this.boundingSphere=n.boundingSphere};return n.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&r(e.attributes[i])&&r(e.attributes[i].values)){var o=e.attributes[i],a=o.values.length/o.componentsPerAttribute;if(n!==a&&-1!==n)throw new t("All attribute lists must have the same number of attributes.");n=a}return n},n}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(n.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(n.values))throw new t("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/IndexDatatype",["./defined","./DeveloperError","./Math"],function(e,r,t){"use strict";var n={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return n.getSizeInBytes=function(e){switch(e){case n.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case n.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case n.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new r("indexDatatype is required and must be a valid IndexDatatype constant.")},n.validate=function(r){return e(r)&&(r===n.UNSIGNED_BYTE||r===n.UNSIGNED_SHORT||r===n.UNSIGNED_INT)},n.createTypedArray=function(n,i){if(!e(n))throw new r("numberOfVertices is required.");return n>t.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},n}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,r,t,n,i,o,a,s){"use strict";function u(e){var r=e._uSquared,t=e._ellipsoid.maximumRadius,n=e._ellipsoid.minimumRadius,i=(t-n)/t,o=Math.cos(e._startHeading),a=Math.sin(e._startHeading),s=(1-i)*Math.tan(e._start.latitude),u=1/Math.sqrt(1+s*s),f=u*s,l=Math.atan2(s,o),h=u*a,c=h*h,w=1-c,d=Math.sqrt(w),m=r/4,p=m*m,g=p*m,y=p*p,E=1+m-3*p/4+5*g/4-175*y/64,C=1-m+15*p/8-35*g/8,v=1-3*m+35*p/4,S=1-5*m,q=E*l-C*Math.sin(2*l)*m/2-v*Math.sin(4*l)*p/16-S*Math.sin(6*l)*g/48-5*Math.sin(8*l)*y/512,b=e._constants;b.a=t,b.b=n,b.f=i,b.cosineHeading=o,b.sineHeading=a,b.tanU=s,b.cosineU=u,b.sineU=f,b.sigma=l,b.sineAlpha=h,b.sineSquaredAlpha=c,b.cosineSquaredAlpha=w,b.cosineAlpha=d,b.u2Over4=m,b.u4Over16=p,b.u6Over64=g,b.u8Over256=y,b.a0=E,b.a1=C,b.a2=v,b.a3=S,b.distanceRatio=q}function f(e,r){return e*r*(4+e*(4-3*r))/16}function l(e,r,t,n,i,o,a){var s=f(e,t);return(1-s)*e*r*(n+s*i*(a+s*o*(2*a*a-1)))}function h(e,r,t,n,i,o,a){var u,f,h,c,w,d=(r-t)/r,m=o-n,p=Math.atan((1-d)*Math.tan(i)),g=Math.atan((1-d)*Math.tan(a)),y=Math.cos(p),E=Math.sin(p),C=Math.cos(g),v=Math.sin(g),S=y*C,q=y*v,b=E*v,M=E*C,R=m,A=s.TWO_PI,x=Math.cos(R),O=Math.sin(R);do{x=Math.cos(R),O=Math.sin(R);var I=q-M*x;h=Math.sqrt(C*C*O*O+I*I),f=b+S*x,u=Math.atan2(h,f);var T;0===h?(T=0,c=1):(T=S*O/h,c=1-T*T),A=R,w=f-2*b/c,isNaN(w)&&(w=0),R=m+l(d,T,c,u,h,f,w)}while(Math.abs(R-A)>s.EPSILON12);var N=c*(r*r-t*t)/(t*t),F=1+N*(4096+N*(N*(320-175*N)-768))/16384,_=N*(256+N*(N*(74-47*N)-128))/1024,D=w*w,L=_*h*(w+_*(f*(2*D-1)-_*w*(4*h*h-3)*(4*D-3)/6)/4),P=t*F*(u-L),z=Math.atan2(C*O,q-M*x),B=Math.atan2(y*O,q*x-M);e._distance=P,e._startHeading=z,e._endHeading=B,e._uSquared=N}function c(t,n,i,a){var s=e.normalize(a.cartographicToCartesian(n,d),w),f=e.normalize(a.cartographicToCartesian(i,d),d);if(Math.abs(Math.abs(e.angleBetween(s,f))-Math.PI)<.0125)throw new o("geodesic position is not unique");h(t,a.maximumRadius,a.minimumRadius,n.longitude,n.latitude,i.longitude,i.latitude),n.height=0,i.height=0,t._start=r.clone(n,t._start),t._end=r.clone(i,t._end),u(t)}var w=new e,d=new e,m=function(e,i,o){var s=t(o,a.WGS84);this._ellipsoid=s,this._start=new r,this._end=new r,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,n(e)&&n(i)&&c(this,e,i,s)};return i(m.prototype,{surfaceDistance:{get:function(){if(!n(this._distance))throw new o("set end positions before getting surfaceDistance");return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){if(!n(this._distance))throw new o("set end positions before getting startHeading");return this._startHeading}},endHeading:{get:function(){if(!n(this._distance))throw new o("set end positions before getting endHeading");return this._endHeading}}}),m.prototype.setEndPoints=function(e,r){if(!n(e))throw new o("start cartographic position is required");if(!n(r))throw new o("end cartgraphic position is required");c(this,e,r,this._ellipsoid)},m.prototype.interpolateUsingFraction=function(e,r){return this.interpolateUsingSurfaceDistance(this._distance*e,r)},m.prototype.interpolateUsingSurfaceDistance=function(e,t){if(!n(this._distance))throw new o("start and end must be set before calling funciton interpolateUsingSurfaceDistance");var i=this._constants,a=i.distanceRatio+e/i.b,s=Math.cos(2*a),u=Math.cos(4*a),f=Math.cos(6*a),h=Math.sin(2*a),c=Math.sin(4*a),w=Math.sin(6*a),d=Math.sin(8*a),m=a*a,p=a*m,g=i.u8Over256,y=i.u2Over4,E=i.u6Over64,C=i.u4Over16,v=2*p*g*s/3+a*(1-y+7*C/4-15*E/4+579*g/64-(C-15*E/4+187*g/16)*s-(5*E/4-115*g/16)*u-29*g*f/16)+(y/2-C+71*E/32-85*g/16)*h+(5*C/16-5*E/4+383*g/96)*c-m*((E-11*g/2)*h+5*g*c/2)+(29*E/96-29*g/16)*w+539*g*d/1536,S=Math.asin(Math.sin(v)*i.cosineAlpha),q=Math.atan(i.a/i.b*Math.tan(S));v-=i.sigma;var b=Math.cos(2*i.sigma+v),M=Math.sin(v),R=Math.cos(v),A=i.cosineU*R,x=i.sineU*M,O=Math.atan2(M*i.sineHeading,A-x*i.cosineHeading),I=O-l(i.f,i.sineAlpha,i.cosineSquaredAlpha,v,M,R,b);return n(t)?(t.longitude=this._start.longitude+I,t.latitude=q,t.height=0,t):new r(this._start.longitude+I,q,0)},m}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,r){"use strict";function t(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}var n={};return n.discriminant=function(r,t,n){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=t*t-4*r*n;return i},n.realRoots=function(n,i,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");var a;if(0===n)return 0===i?[]:[-o/i];if(0===i){if(0===o)return[0,0];var s=Math.abs(o),u=Math.abs(n);if(u>s&&s/u<r.EPSILON14)return[0,0];if(s>u&&u/s<r.EPSILON14)return[];if(a=-o/n,0>a)return[];var f=Math.sqrt(a);return[-f,f]}if(0===o)return a=-i/n,0>a?[a,0]:[0,a];var l=i*i,h=4*n*o,c=t(l,-h,r.EPSILON14);if(0>c)return[];var w=-.5*t(i,r.sign(i)*Math.sqrt(c),r.EPSILON14);return i>0?[w/n,o/w]:[o/w,w/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,r){"use strict";function t(e,r,t,n){var i,o,a=e,s=r/3,u=t/3,f=n,l=a*u,h=s*f,c=s*s,w=u*u,d=a*u-c,m=a*f-s*u,p=s*f-w,g=4*d*p-m*m;if(0>g){var y,E,C;c*h>=l*w?(y=a,E=d,C=-2*s*d+a*m):(y=f,E=p,C=-f*m+2*u*p);var v=0>C?-1:1,S=-v*Math.abs(y)*Math.sqrt(-g);o=-C+S;var q=o/2,b=0>q?-Math.pow(-q,1/3):Math.pow(q,1/3),M=o===S?-b:-E/b;return i=0>=E?b+M:-C/(b*b+M*M+E),c*h>=l*w?[(i-s)/a]:[-f/(i+u)]}var R=d,A=-2*s*d+a*m,x=p,O=-f*m+2*u*p,I=Math.sqrt(g),T=Math.sqrt(3)/2,N=Math.abs(Math.atan2(a*I,-A)/3);i=2*Math.sqrt(-R);var F=Math.cos(N);o=i*F;var _=i*(-F/2-T*Math.sin(N)),D=o+_>2*s?o-s:_-s,L=a,P=D/L;N=Math.abs(Math.atan2(f*I,-O)/3),i=2*Math.sqrt(-x),F=Math.cos(N),o=i*F,_=i*(-F/2-T*Math.sin(N));var z=-f,B=2*u>o+_?o+u:_+u,U=z/B,G=L*B,W=-D*B-L*z,Y=D*z,H=(u*W-s*Y)/(-s*W+u*G);return H>=P?U>=P?U>=H?[P,H,U]:[P,U,H]:[U,P,H]:U>=P?[H,P,U]:U>=H?[H,U,P]:[U,H,P]}var n={};return n.discriminant=function(r,t,n,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var o=r*r,a=t*t,s=n*n,u=i*i,f=18*r*t*n*i+a*s-27*o*u-4*(r*s*n+a*t*i);return f},n.realRoots=function(n,i,o,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var s,u;if(0===n)return r.realRoots(i,o,a);if(0===i){if(0===o){if(0===a)return[0,0,0];u=-a/n;var f=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[f,f,f]}return 0===a?(s=r.realRoots(n,0,o),0===s.Length?[0]:[s[0],0,s[1]]):t(n,0,o,a)}return 0===o?0===a?(u=-i/n,0>u?[u,0,0]:[0,0,u]):t(n,i,0,a):0===a?(s=r.realRoots(n,i,o),0===s.length?[0]:s[1]<=0?[s[0],s[1],0]:s[0]>=0?[0,s[0],s[1]]:[s[0],0,s[1]]):t(n,i,o,a)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,r,t,n){"use strict";function i(r,i,o,a){var s=r*r,u=i-3*s/8,f=o-i*r/2+s*r/8,l=a-o*r/4+i*s/16-3*s*s/256,h=e.realRoots(1,2*u,u*u-4*l,-f*f);if(h.length>0){var c=-r/4,w=h[h.length-1];if(Math.abs(w)<t.EPSILON14){var d=n.realRoots(1,u,l);if(2===d.length){var m,p=d[0],g=d[1];if(p>=0&&g>=0){var y=Math.sqrt(p),E=Math.sqrt(g);return[c-E,c-y,c+y,c+E]}if(p>=0&&0>g)return m=Math.sqrt(p),[c-m,c+m];if(0>p&&g>=0)return m=Math.sqrt(g),[c-m,c+m]}return[]}if(w>0){var C=Math.sqrt(w),v=(u+w-f/C)/2,S=(u+w+f/C)/2,q=n.realRoots(1,C,v),b=n.realRoots(1,-C,S);return 0!==q.length?(q[0]+=c,q[1]+=c,0!==b.length?(b[0]+=c,b[1]+=c,q[1]<=b[0]?[q[0],q[1],b[0],b[1]]:b[1]<=q[0]?[b[0],b[1],q[0],q[1]]:q[0]>=b[0]&&q[1]<=b[1]?[b[0],q[0],q[1],b[1]]:b[0]>=q[0]&&b[1]<=q[1]?[q[0],b[0],b[1],q[1]]:q[0]>b[0]&&q[0]<b[1]?[b[0],q[0],b[1],q[1]]:[q[0],b[0],q[1],b[1]]):q):0!==b.length?(b[0]+=c,b[1]+=c,b):[]}}return[]}function o(r,i,o,a){var s=o*o,u=i*i,f=r*r,l=-2*i,h=o*r+u-4*a,c=f*a-o*i*r+s,w=e.realRoots(1,l,h,c);if(w.length>0){var d,m,p=w[0],g=i-p,y=g*g,E=r/2,C=g/2,v=y-4*a,S=y+4*Math.abs(a),q=f-4*p,b=f+4*Math.abs(p);if(0>p||q*S>v*b){var M=Math.sqrt(q);d=M/2,m=0===M?0:(r*C-o)/M}else{var R=Math.sqrt(v);d=0===R?0:(r*C-o)/R,m=R/2}var A,x;0===E&&0===d?(A=0,x=0):t.sign(E)===t.sign(d)?(A=E+d,x=p/A):(x=E-d,A=p/x);var O,I;0===C&&0===m?(O=0,I=0):t.sign(C)===t.sign(m)?(O=C+m,I=a/O):(I=C-m,O=a/I);var T=n.realRoots(1,A,O),N=n.realRoots(1,x,I);if(0!==T.length)return 0!==N.length?T[1]<=N[0]?[T[0],T[1],N[0],N[1]]:N[1]<=T[0]?[N[0],N[1],T[0],T[1]]:T[0]>=N[0]&&T[1]<=N[1]?[N[0],T[0],T[1],N[1]]:N[0]>=T[0]&&N[1]<=T[1]?[T[0],N[0],N[1],T[1]]:T[0]>N[0]&&T[0]<N[1]?[N[0],T[0],N[1],T[1]]:[T[0],N[0],T[1],N[1]]:T;if(0!==N.length)return N}return[]}var a={};return a.discriminant=function(e,t,n,i,o){if("number"!=typeof e)throw new r("a is a required number.");if("number"!=typeof t)throw new r("b is a required number.");if("number"!=typeof n)throw new r("c is a required number.");if("number"!=typeof i)throw new r("d is a required number.");if("number"!=typeof o)throw new r("e is a required number.");var a=e*e,s=a*e,u=t*t,f=u*t,l=n*n,h=l*n,c=i*i,w=c*i,d=o*o,m=d*o,p=u*l*c-4*f*w-4*e*h*c+18*e*t*n*w-27*a*c*c+256*s*m+o*(18*f*n*i-4*u*h+16*e*l*l-80*e*t*l*i-6*e*u*c+144*a*n*c)+d*(144*e*u*n-27*u*u-128*a*l-192*a*t*i);return p},a.realRoots=function(n,a,s,u,f){if("number"!=typeof n)throw new r("a is a required number.");if("number"!=typeof a)throw new r("b is a required number.");if("number"!=typeof s)throw new r("c is a required number.");if("number"!=typeof u)throw new r("d is a required number.");if("number"!=typeof f)throw new r("e is a required number.");if(Math.abs(n)<t.EPSILON15)return e.realRoots(a,s,u,f);var l=a/n,h=s/n,c=u/n,w=f/n,d=0>l?1:0;switch(d+=0>h?d+1:d,d+=0>c?d+1:d,d+=0>w?d+1:d){case 0:return i(l,h,c,w);case 1:return o(l,h,c,w);case 2:return o(l,h,c,w);case 3:return i(l,h,c,w);case 4:return i(l,h,c,w);case 5:return o(l,h,c,w);case 6:return i(l,h,c,w);case 7:return i(l,h,c,w);case 8:return o(l,h,c,w);case 9:return i(l,h,c,w);case 10:return i(l,h,c,w);case 11:return o(l,h,c,w);case 12:return i(l,h,c,w);case 13:return i(l,h,c,w);case 14:return i(l,h,c,w);case 15:return i(l,h,c,w);default:return void 0}},a}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial"],function(e,r,t,n,i,o,a,s){"use strict";function u(e,r,t){var n=e+r;return i.sign(e)!==i.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<t?0:n}function f(r,t,n,f,l){var h,c=f*f,w=l*l,d=(r[o.COLUMN1ROW1]-r[o.COLUMN2ROW2])*w,m=l*(f*u(r[o.COLUMN1ROW0],r[o.COLUMN0ROW1],i.EPSILON15)+t.y),p=r[o.COLUMN0ROW0]*c+r[o.COLUMN2ROW2]*w+f*t.x+n,g=w*u(r[o.COLUMN2ROW1],r[o.COLUMN1ROW2],i.EPSILON15),y=l*(f*u(r[o.COLUMN2ROW0],r[o.COLUMN0ROW2])+t.z),E=[];if(0===y&&0===g){if(h=a.realRoots(d,m,p),0===h.length)return E;var C=h[0],v=Math.sqrt(Math.max(1-C*C,0));if(E.push(new e(f,l*C,l*-v)),E.push(new e(f,l*C,l*v)),2===h.length){var S=h[1],q=Math.sqrt(Math.max(1-S*S,0));E.push(new e(f,l*S,l*-q)),E.push(new e(f,l*S,l*q))}return E}var b=y*y,M=g*g,R=d*d,A=y*g,x=R+M,O=2*(m*d+A),I=2*p*d+m*m-M+b,T=2*(p*m-A),N=p*p-b;if(0===x&&0===O&&0===I&&0===T)return E;h=s.realRoots(x,O,I,T,N);var F=h.length;if(0===F)return E;for(var _=0;F>_;++_){var D,L=h[_],P=L*L,z=Math.max(1-P,0),B=Math.sqrt(z);D=i.sign(d)===i.sign(p)?u(d*P+p,m*L,i.EPSILON12):i.sign(p)===i.sign(m*L)?u(d*P,m*L+p,i.EPSILON12):u(d*P+m*L,p,i.EPSILON12);var U=u(g*L,y,i.EPSILON15),G=D*U;0>G?E.push(new e(f,l*L,l*B)):G>0?E.push(new e(f,l*L,l*-B)):0!==B?(E.push(new e(f,l*L,l*-B)),E.push(new e(f,l*L,l*B)),++_):E.push(new e(f,l*L,l*B))}return E}var l={};l.rayPlane=function(r,o,a){if(!t(r))throw new n("ray is required.");if(!t(o))throw new n("plane is required.");t(a)||(a=new e);var s=r.origin,u=r.direction,f=o.normal,l=e.dot(f,u);if(Math.abs(l)<i.EPSILON15)return void 0;var h=(-o.distance-e.dot(f,s))/l;return 0>h?void 0:(a=e.multiplyByScalar(u,h,a),e.add(s,a,a))};var h=new e,c=new e;l.rayEllipsoid=function(r,i){if(!t(r))throw new n("ray is required.");if(!t(i))throw new n("ellipsoid is required.");var o,a,s,u,f,l=i.oneOverRadii,w=e.multiplyComponents(l,r.origin,h),d=e.multiplyComponents(l,r.direction,c),m=e.magnitudeSquared(w),p=e.dot(w,d);
if(m>1){if(p>=0)return void 0;var g=p*p;if(o=m-1,a=e.magnitudeSquared(d),s=a*o,s>g)return void 0;if(g>s){u=p*p-s,f=-p+Math.sqrt(u);var y=f/a,E=o/f;return E>y?{start:y,stop:E}:{start:E,stop:y}}var C=Math.sqrt(o/a);return{start:C,stop:C}}return 1>m?(o=m-1,a=e.magnitudeSquared(d),s=a*o,u=p*p-s,f=-p+Math.sqrt(u),{start:0,stop:f/a}):0>p?(a=e.magnitudeSquared(d),{start:0,stop:-p/a}):void 0};var w=new e,d=new e,m=new e,p=new e;l.grazingAltitudeLocation=function(a,s){if(!t(a))throw new n("ray is required.");if(!t(s))throw new n("ellipsoid is required.");var u=a.origin,l=a.direction,h=s.geodeticSurfaceNormal(u);if(e.dot(l,h)>=0)return u;var c,g,y=t(this.rayEllipsoid(a,s)),E=s.transformPositionToScaledSpace(l),C=e.normalize(E,w),v=e.mostOrthogonalAxis(E,p),S=e.normalize(e.cross(v,C,d),d),q=e.normalize(e.cross(C,S,m),m),b=new o(C.x,S.x,q.x,C.y,S.y,q.y,C.z,S.z,q.z),M=o.transpose(b),R=o.fromScale(s.radii),A=o.fromScale(s.oneOverRadii),x=new o(0,l.z,-l.y,-l.z,0,l.x,l.y,-l.x,0),O=o.multiply(o.multiply(M,A),x),I=o.multiply(o.multiply(O,R),b),T=o.multiplyByVector(O,u),N=f(I,e.negate(T,w),0,0,1),F=N.length;if(F>0){for(var _=e.ZERO,D=Number.NEGATIVE_INFINITY,L=0;F>L;++L){c=o.multiplyByVector(R,o.multiplyByVector(b,N[L]));var P=e.normalize(e.subtract(c,u,p),p),z=e.dot(P,l);z>D&&(D=z,_=c)}var B=s.cartesianToCartographic(_);return D=i.clamp(D,0,1),g=e.magnitude(e.subtract(_,u,p))*Math.sqrt(1-D*D),g=y?-g:g,s.cartographicToCartesian(new r(B.longitude,B.latitude,g))}return void 0};var g=new e;return l.lineSegmentPlane=function(r,o,a,s){if(!t(r))throw new n("endPoint0 is required.");if(!t(o))throw new n("endPoint1 is required.");if(!t(a))throw new n("plane is required.");t(s)||(s=new e);var u=e.subtract(o,r,g),f=a.normal,l=e.dot(f,u);if(Math.abs(l)<i.EPSILON6)return void 0;var h=e.dot(f,r),c=-(a.distance+h)/l;return 0>c||c>1?void 0:(e.multiplyByScalar(u,c,s),e.add(r,s,s),s)},l.trianglePlaneIntersection=function(r,i,o,a){if(!(t(r)&&t(i)&&t(o)&&t(a)))throw new n("p0, p1, p2, and plane are required.");var s=a.normal,u=a.distance,f=e.dot(s,r)+u<0,h=e.dot(s,i)+u<0,c=e.dot(s,o)+u<0,w=0;w+=f?1:0,w+=h?1:0,w+=c?1:0;var d,m;if((1===w||2===w)&&(d=new e,m=new e),1===w){if(f)return l.lineSegmentPlane(r,i,a,d),l.lineSegmentPlane(r,o,a,m),{positions:[r,i,o,d,m],indices:[0,3,4,1,2,4,1,4,3]};if(h)return l.lineSegmentPlane(i,o,a,d),l.lineSegmentPlane(i,r,a,m),{positions:[r,i,o,d,m],indices:[1,3,4,2,0,4,2,4,3]};if(c)return l.lineSegmentPlane(o,r,a,d),l.lineSegmentPlane(o,i,a,m),{positions:[r,i,o,d,m],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===w){if(!f)return l.lineSegmentPlane(i,r,a,d),l.lineSegmentPlane(o,r,a,m),{positions:[r,i,o,d,m],indices:[1,2,4,1,4,3,0,3,4]};if(!h)return l.lineSegmentPlane(o,i,a,d),l.lineSegmentPlane(r,i,a,m),{positions:[r,i,o,d,m],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return l.lineSegmentPlane(r,o,a,d),l.lineSegmentPlane(i,o,a,m),{positions:[r,i,o,d,m],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},l}),define("Core/isArray",["./defined"],function(e){"use strict";var r=Array.isArray;return e(r)||(r=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),r}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n,i){if(!r(n))throw new t("normal is required.");if(!r(i))throw new t("distance is required.");this.normal=e.clone(n),this.distance=i};return n.fromPointNormal=function(i,o,a){if(!r(i))throw new t("point is required.");if(!r(o))throw new t("normal is required.");var s=-e.dot(o,i);return r(a)?(e.clone(o,a.normal),a.distance=s,a):new n(o,s)},n.getPointDistance=function(n,i){if(!r(n))throw new t("plane is required.");if(!r(i))throw new t("point is required.");return e.dot(n.normal,i)+n.distance},n}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,r,t,n,i,o,a,s,u,f,l,h){"use strict";function c(r,t,n,i){var o=i.scaleToGeodeticSurface(r,R),a=i.scaleToGeodeticSurface(t,A),s=e.angleBetween(o,a),u=Math.ceil(s/n),f=new Array(3*u),l=i.cartesianToCartographic(o,q),h=i.cartesianToCartographic(a,b);x.setEndPoints(l,h);var c=x.surfaceDistance/u,w=0;l.height=0;var d=i.cartographicToCartesian(l,M);f[w++]=d.x,f[w++]=d.y,f[w++]=d.z;for(var m=1;u>m;m++){var p=x.interpolateUsingSurfaceDistance(m*c,b);d=i.cartographicToCartesian(p,M),f[w++]=d.x,f[w++]=d.y,f[w++]=d.z}return f}function w(r,t,n){var i=O;return n.geodeticSurfaceNormal(r,i),e.multiplyByScalar(i,t,i),e.add(r,i,r),r}var d={},m=new l,p=new e,g=new e,y=new h(e.ZERO,0),E=new e,C=new h(e.ZERO,0),v=new e,S=new e,q=new r,b=new r,M=new e,R=new e,A=new e,x=new a,O=new e,I=new e;return d.wrapLongitude=function(r,i){var o=[],a=[];if(n(r)&&r.length>0){i=t(i,l.IDENTITY);var u=l.inverseTransformation(i,m),f=l.multiplyByPoint(u,e.ZERO,p),c=l.multiplyByPointAsVector(u,e.UNIT_Y,g),w=h.fromPointNormal(f,c,y),d=l.multiplyByPointAsVector(u,e.UNIT_X,E),q=h.fromPointNormal(f,d,C),b=1;o.push(e.clone(r[0]));for(var M=o[0],R=r.length,A=1;R>A;++A){var x=r[A];if(h.getPointDistance(q,M)<0||h.getPointDistance(q,x)<0){var O=s.lineSegmentPlane(M,x,w,v);if(n(O)){var I=e.multiplyByScalar(c,5e-9,S);h.getPointDistance(w,M)<0&&e.negate(I,I),o.push(e.add(O,I,new e)),a.push(b+1),e.negate(I,I),o.push(e.add(O,I,new e)),b=1}}o.push(e.clone(r[A])),b++,M=x}a.push(b)}return{positions:o,lengths:a}},d.removeDuplicates=function(r){if(!n(r))throw new i("positions is required.");var t=r.length;if(2>t)return r.slice(0);var o=[];o.push(r[0]);for(var a=1;t>a;++a){var s=r[a-1],u=r[a];e.equals(s,u)||o.push(u)}return o},d.scaleToSurface=function(e,r,a){if(!n(e))throw new i("positions is required");r=t(r,f.RADIANS_PER_DEGREE),a=t(a,o.WGS84);for(var s=e.length,u=[],l=0;s-1>l;l++){var h=e[l],w=e[l+1];u=u.concat(c(h,w,r,a))}var d=e[s-1],m=a.cartesianToCartographic(d,q);m.height=0;var p=a.cartographicToCartesian(m,M);return u.push(p.x,p.y,p.z),u},d.scaleToGeodeticHeight=function(r,a,s,f){if(!n(r))throw new i("positions must be defined.");if(!n(a))throw new i("height must be defined");s=t(s,o.WGS84);var l,h,c=r.length,d=I;if(n(f)){if(f.length!==r.length)throw new i("result.length must be equal to positions.length");h=f}else h=new Array(r.length);if(0===a){for(l=0;c>l;l+=3)d=s.scaleToGeodeticSurface(e.fromArray(r,l,d),d),h[l]=d.x,h[l+1]=d.y,h[l+2]=d.z;return h}var m;if(u(a)){if(a.length!==c/3)throw new i("height.length must be equal to positions.length");for(l=0;c>l;l+=3)m=a[l/3],d=e.fromArray(r,l,d),d=w(d,m,s),h[l]=d.x,h[l+1]=d.y,h[l+2]=d.z}else for(m=a,l=0;c>l;l+=3)d=e.fromArray(r,l,d),d=w(d,m,s),h[l]=d.x,h[l+1]=d.y,h[l+2]=d.z;return h},d}),define("Core/PrimitiveType",[],function(){"use strict";var e={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(r){return r===e.POINTS||r===e.LINES||r===e.LINE_LOOP||r===e.LINE_STRIP||r===e.TRIANGLES||r===e.TRIANGLE_STRIP||r===e.TRIANGLE_FAN}};return e}),define("Core/VertexFormat",["./defaultValue","./freezeObject"],function(e,r){"use strict";var t=function(r){r=e(r,e.EMPTY_OBJECT),this.position=e(r.position,!1),this.normal=e(r.normal,!1),this.st=e(r.st,!1),this.binormal=e(r.binormal,!1),this.tangent=e(r.tangent,!1)};return t.POSITION_ONLY=r(new t({position:!0})),t.POSITION_AND_NORMAL=r(new t({position:!0,normal:!0})),t.POSITION_NORMAL_AND_ST=r(new t({position:!0,normal:!0,st:!0})),t.POSITION_AND_ST=r(new t({position:!0,st:!0})),t.ALL=r(new t({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),t.DEFAULT=t.POSITION_NORMAL_AND_ST,t}),define("Core/PolylineGeometry",["./BoundingSphere","./Cartesian3","./Color","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./PolylinePipeline","./PrimitiveType","./VertexFormat"],function(e,r,t,n,i,o,a,s,u,f,l,h,c,w){"use strict";var d=function(e){e=i(e,i.EMPTY_OBJECT);var r=e.positions,t=e.colors,n=i(e.width,1),s=i(e.colorsPerVertex,!1);if(!o(r)||r.length<2)throw new a("At least two positions are required.");if(1>n)throw new a("width must be greater than or equal to one.");if(o(t)&&(s&&t.length<r.length||!s&&t.length<r.length-1))throw new a("colors has an invalid length.");this._positions=r,this._colors=t,this._width=n,this._perVertex=s,this._vertexFormat=i(e.vertexFormat,w.DEFAULT),this._workerName="createPolylineGeometry"},m=new r,p=new r,g=new r,y=new r;return d.createGeometry=function(i){var a,w,d,E=i._width,C=i._vertexFormat,v=i._colors,S=i._perVertex,q=h.wrapLongitude(i._positions),b=q.positions,M=q.lengths,R=0,A=M.length;for(a=0;A>a;++a)R+=4*M[a]-4;var x,O,I=new Float64Array(3*R),T=new Float64Array(3*R),N=new Float64Array(3*R),F=new Float32Array(2*R),_=C.st?new Float32Array(2*R):void 0,D=o(v)?new Uint8Array(4*R):void 0,L=0,P=0,z=0,B=0,U=0,G=0,W=b.length;for(w=0;W>w;++w){0===w?(O=m,r.subtract(b[0],b[1],O),r.add(b[0],O,O)):O=b[w-1],r.clone(O,g),r.clone(b[w],p),w===W-1?(O=m,r.subtract(b[W-1],b[W-2],O),r.add(b[W-1],O,O)):O=b[w+1],r.clone(O,y),x=M[U],w===G+x&&(G+=x,++U);var Y,H,V=0===w-G,K=w===G+M[U]-1,k=V?2:0,j=K?2:4;if(o(D)){var Z=w-U;Y=V||S?v[Z]:v[Z-1],K||(H=v[Z])}for(d=k;j>d;++d){r.pack(p,I,L),r.pack(g,T,L),r.pack(y,N,L),L+=3;var Q=0>d-2?-1:1;if(F[P++]=2*(d%2)-1,F[P++]=Q*E,C.st&&(_[z++]=w/(W-1),_[z++]=Math.max(F[P-2],0)),o(D)){var X=2>d?Y:H;D[B++]=t.floatToByte(X.red),D[B++]=t.floatToByte(X.green),D[B++]=t.floatToByte(X.blue),D[B++]=t.floatToByte(X.alpha)}}}var J=new f;J.position=new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:I}),J.prevPosition=new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:T}),J.nextPosition=new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:N}),J.expandAndWidth=new u({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:F}),C.st&&(J.st=new u({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:_})),o(D)&&(J.color=new u({componentDatatype:n.UNSIGNED_BYTE,componentsPerAttribute:4,values:D,normalize:!0})),A=M.length;var $=l.createTypedArray(R,6*b.length-6*A),er=0,rr=0;for(a=0;A>a;++a)for(x=M[a]-1,w=0;x>w;++w)$[rr++]=er,$[rr++]=er+2,$[rr++]=er+1,$[rr++]=er+1,$[rr++]=er+2,$[rr++]=er+3,er+=4;return new s({attributes:J,indices:$,primitiveType:c.TRIANGLES,boundingSphere:e.fromPoints(b)})},d}),define("Workers/createPolylineGeometry",["../Core/PolylineGeometry"],function(e){"use strict";return e.createGeometry})}();