/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2014 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=.5*3*Math.PI,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,a=e-Math.floor(e/r)*r;return a<-Math.PI?a+r:a>=Math.PI?a-r:a},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");for(var r=i.EPSILON10,a=i.PI,o=i.TWO_PI;-(a+r)>e;)e+=o;if(-a>e)return-a;for(;e>a+r;)e-=o;return e>a?a:e},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=e%i.TWO_PI;return 0>r?(r+i.TWO_PI)%i.TWO_PI:r},i.equalsEpsilon=function(e,i,a){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");return a=r(a,0),Math.abs(e-i)<=a};var a=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=a.length;if(e>=r)for(var t=a[r-1],i=r;e>=i;i++)a.push(t*i);return a[e]},i.incrementWrap=function(e,i,a){if(a=r(a,0),!t(e))throw new n("n is required.");if(a>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=a),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var o=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");o=new e(r)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){return Math.asin(i.clamp(e,-1,1))},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};a.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new a);var o=n.clock,u=n.cone,s=e(n.magnitude,1),f=s*Math.sin(u);return i.x=f*Math.cos(o),i.y=f*Math.sin(o),i.z=s*Math.cos(u),i},a.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new a(e,t,n)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a]=n.z},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i],o},a.fromArray=a.unpack,a.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},a.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},a.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},a.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var u=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,u),o=a.multiplyByScalar(e,1-i,o),a.add(u,o,o)};var s=new a,f=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");a.normalize(e,s),a.normalize(n,f);var i=a.dot(s,f),o=a.magnitude(a.cross(s,f,s));return Math.atan2(o,i)};var l=new a;a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,l);return a.abs(i,i),n=i.x<=i.y?i.x<=i.z?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Z,n):i.y<=i.z?a.clone(a.UNIT_Y,n):a.clone(a.UNIT_Z,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i},a.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var a=e.x,o=e.y,u=e.z,s=n.x,f=n.y,l=n.z,c=o*l-u*f,h=u*s-a*l,d=a*f-o*s;return i.x=c,i.y=h,i.z=d,i},a.fromDegrees=function(e,n,o,u,s){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var f=i.toRadians(e),l=i.toRadians(n);return a.fromRadians(f,l,o,u,s)};var c=new a,h=new a,d=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,i,o,u,s){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");o=e(o,0);var f=r(u)?u.radiiSquared:d,l=Math.cos(i);c.x=l*Math.cos(n),c.y=l*Math.sin(n),c.z=Math.sin(i),c=a.normalize(c,c),a.multiplyComponents(f,c,h);var w=Math.sqrt(a.dot(c,h));return h=a.divideByScalar(h,w,h),c=a.multiplyByScalar(c,o,c),r(s)||(s=new a),a.add(h,c,s)},a.fromDegreesArray=function(e,n,o){if(!r(e))throw new t("positions is required.");for(var u=new Array(e.length),s=0;s<e.length;s++)u[s]=i.toRadians(e[s]);return a.fromRadiansArray(u,n,o)},a.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(0!==e.length%2)throw new t("positions length must be a multiple of 2.");var o=e.length;r(i)?i.length=o/2:i=new Array(o/2);for(var u=0;o>u;u+=2){var s=e[u],f=e[u+1];i[u/2]=a.fromRadians(s,f,0,n,i[u/2])}return i},a.fromDegreesArrayHeights=function(e,n,o){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");for(var u=new Array(e.length),s=0;s<e.length;s+=3)u[s]=i.toRadians(e[s]),u[s+1]=i.toRadians(e[s+1]),u[s+2]=e[s+2];return a.fromRadiansArrayHeights(u,n,o)},a.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");var o=e.length;r(i)?i.length=o/3:i=new Array(o/3);for(var u=0;o>u;u+=3){var s=e[u],f=e[u+1],l=e[u+2];i[u/3]=a.fromRadians(s,f,l,n,i[u/3])}return i},a.ZERO=n(new a(0,0,0)),a.UNIT_X=n(new a(1,0,0)),a.UNIT_Y=n(new a(0,1,0)),a.UNIT_Z=n(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return a.fromRadians=function(n,i,o,u){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return o=e(o,0),r(u)?(u.longitude=n,u.latitude=i,u.height=o,u):new a(n,i,o)},a.fromDegrees=function(e,n,o,u){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),a.fromRadians(e,n,o,u)},a.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new a(e.longitude,e.latitude,e.height):void 0},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},a.toString=function(e){if(!r(e))throw new t("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},a.ZERO=n(new a(0,0,0)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return a.toString(this)},a}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a,o,u){"use strict";var s=function(r,n,i){if(r=t(r,0),n=t(n,0),i=t(i,0),0>r||0>n||0>i)throw new a("All radii components must be greater than or equal to zero.");this._radii=new e(r,n,i),this._radiiSquared=new e(r*r,n*n,i*i),this._radiiToTheFourth=new e(r*r*r*r,n*n*n*n,i*i*i*i),this._oneOverRadii=new e(0===r?0:1/r,0===n?0:1/n,0===i?0:1/i),this._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===n?0:1/(n*n),0===i?0:1/(i*i)),this._minimumRadius=Math.min(r,n,i),this._maximumRadius=Math.max(r,n,i),this._centerToleranceSquared=u.EPSILON1};i(s.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),s.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new s(i.x,i.y,i.z)},s.fromCartesian3=function(e){return n(e)?new s(e.x,e.y,e.z):new s},s.WGS84=o(new s(6378137,6378137,6356752.314245179)),s.UNIT_SPHERE=o(new s(1,1,1)),s.MOON=o(new s(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.geocentricSurfaceNormal=e.normalize,s.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new a("cartographic is required.");var i=r.longitude,o=r.latitude,u=Math.cos(o),s=u*Math.cos(i),f=u*Math.sin(i),l=Math.sin(o);return n(t)||(t=new e),t.x=s,t.y=f,t.z=l,e.normalize(t,t)},s.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var f=new e,l=new e;s.prototype.cartographicToCartesian=function(r,t){var i=f,a=l;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(a,i,t)},s.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new a("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var c=new e,h=new e,d=new e;s.prototype.cartesianToCartographic=function(t,i){var a=this.scaleToGeodeticSurface(t,h);if(!n(a))return void 0;var o=this.geodeticSurfaceNormal(a,c),s=e.subtract(t,a,d),f=Math.atan2(o.y,o.x),l=Math.asin(o.z),w=u.sign(e.dot(s,t))*e.magnitude(s);return n(i)?(i.longitude=f,i.latitude=l,i.height=w,i):new r(f,l,w)},s.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new a("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var w=new e,m=new e;return s.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");var i=r.x,o=r.y,s=r.z,f=this._oneOverRadii,l=f.x,c=f.y,h=f.z,d=i*i*l*l,p=o*o*c*c,y=s*s*h*h,v=d+p+y,g=Math.sqrt(1/v),x=e.multiplyByScalar(r,g,w);if(v<this._centerToleranceSquared)return isFinite(g)?e.clone(x,t):void 0;var b=this._oneOverRadiiSquared,q=b.x,E=b.y,S=b.z,T=m;T.x=2*x.x*q,T.y=2*x.y*E,T.z=2*x.z*S;var O,M,_,P,N,I,A,C,R,z,D,L=(1-g)*e.magnitude(r)/(.5*e.magnitude(T)),U=0;do{L-=U,_=1/(1+L*q),P=1/(1+L*E),N=1/(1+L*S),I=_*_,A=P*P,C=N*N,R=I*_,z=A*P,D=C*N,O=d*I+p*A+y*C-1,M=d*R*q+p*z*E+y*D*S;var B=-2*M;U=O/B}while(Math.abs(O)>u.EPSILON12);return n(t)?(t.x=i*_,t.y=o*P,t.z=s*N,t):new e(i*_,o*P,s*N)},s.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");n(t)||(t=new e);var i=r.x,o=r.y,u=r.z,s=this._oneOverRadiiSquared,f=1/Math.sqrt(i*i*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(r,f,t)},s.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},s.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},s.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},s.prototype.toString=function(){return this._radii.toString()},s}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t){this.x=e(r,0),this.y=e(t,0)};a.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new a(e,t)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a]=n.y},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i],o},a.fromArray=a.unpack,a.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y)},a.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y)},a.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i},a.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n};var u=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,u),o=a.multiplyByScalar(e,1-i,o),a.add(u,o,o)};var s=new a,f=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return a.normalize(e,s),a.normalize(n,f),i.acosClamped(a.dot(s,f))};var l=new a;return a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,l);return a.abs(i,i),n=i.x<=i.y?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Y,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i},a.ZERO=n(new a(0,0)),a.UNIT_X=n(new a(1,0)),a.UNIT_Y=n(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,a,o){"use strict";var u=function(e){this._ellipsoid=t(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(r,t){var i=this._semimajorAxis,a=r.longitude*i,o=r.latitude*i,u=r.height;return n(t)?(t.x=a,t.y=o,t.z=u,t):new e(a,o,u)},u.prototype.unproject=function(e,t){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=e.y*i,s=e.z;return n(t)?(t.longitude=o,t.latitude=u,t.height=s,t):new r(o,u,s)},u}),define("Core/Intersect",[],function(){"use strict";var e={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,a,o){"use strict";var u=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};u.fromDegrees=function(e,n,i,a,s){return e=o.toRadians(r(e,0)),n=o.toRadians(r(n,0)),i=o.toRadians(r(i,0)),a=o.toRadians(r(a,0)),t(s)?(s.west=e,s.south=n,s.east=i,s.north=a,s):new u(e,n,i,a)},u.fromCartographicArray=function(e,r){if(!t(e))throw new n("cartographics is required.");for(var i=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,s=-Number.MAX_VALUE,f=0,l=e.length;l>f;f++){var c=e[f];i=Math.min(i,c.longitude),a=Math.max(a,c.longitude),o=Math.min(o,c.latitude),s=Math.max(s,c.latitude)}return t(r)?(r.west=i,r.south=o,r.east=a,r.north=s,r):new u(i,o,a,s)},u.packedLength=4,u.pack=function(e,i,a){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");a=r(a,0),i[a++]=e.west,i[a++]=e.south,i[a++]=e.east,i[a]=e.north},u.unpack=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new u),a.west=e[i++],a.south=e[i++],a.east=e[i++],a.north=e[i],a},u.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new u(e.west,e.south,e.east,e.north):void 0},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},u.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new n("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},u.validate=function(e){if(!t(e))throw new n("rectangle is required");var r=e.north;if("number"!=typeof r)throw new n("north is required to be a number.");if(r<-o.PI_OVER_TWO||r>o.PI_OVER_TWO)throw new n("north must be in the interval [-Pi/2, Pi/2].");var i=e.south;if("number"!=typeof i)throw new n("south is required to be a number.");if(i<-o.PI_OVER_TWO||i>o.PI_OVER_TWO)throw new n("south must be in the interval [-Pi/2, Pi/2].");var a=e.west;if("number"!=typeof a)throw new n("west is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new n("west must be in the interval [-Pi, Pi].");var u=e.east;if("number"!=typeof u)throw new n("east is required to be a number.");if(u<-Math.PI||u>Math.PI)throw new n("east must be in the interval [-Pi, Pi].")},u.getSouthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},u.getNorthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},u.getNortheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},u.getSoutheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},u.getCenter=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=.5*(r.west+r.east),i.latitude=.5*(r.south+r.north),i.height=0,i):new e(.5*(r.west+r.east),.5*(r.south+r.north))},u.intersectWith=function(e,r,i){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("otherRectangle is required.");var a=Math.max(e.west,r.west),o=Math.max(e.south,r.south),s=Math.min(e.east,r.east),f=Math.min(e.north,r.north);return t(i)?(i.west=a,i.south=o,i.east=s,i.north=f,i):new u(a,o,s,f)},u.contains=function(e,r){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("cartographic is required.");return r.longitude>=e.west&&r.longitude<=e.east&&r.latitude>=e.south&&r.latitude<=e.north},u.isEmpty=function(e){if(!t(e))throw new n("rectangle is required");return e.west>=e.east||e.south>=e.north};var s=new e;return u.subsample=function(e,a,u,f){if(!t(e))throw new n("rectangle is required");a=r(a,i.WGS84),u=r(u,0),t(f)||(f=[]);var l=0,c=e.north,h=e.south,d=e.east,w=e.west,m=s;m.height=u,m.longitude=w,m.latitude=c,f[l]=a.cartographicToCartesian(m,f[l]),l++,m.longitude=d,f[l]=a.cartographicToCartesian(m,f[l]),l++,m.latitude=h,f[l]=a.cartographicToCartesian(m,f[l]),l++,m.longitude=w,f[l]=a.cartographicToCartesian(m,f[l]),l++,m.latitude=0>c?c:h>0?h:0;for(var p=1;8>p;++p){var y=-Math.PI+p*o.PI_OVER_TWO;y>w&&d>y&&(m.longitude=y,f[l]=a.cartographicToCartesian(m,f[l]),l++)}return 0===m.latitude&&(m.longitude=w,f[l]=a.cartographicToCartesian(m,f[l]),l++,m.longitude=d,f[l]=a.cartographicToCartesian(m,f[l]),l++),f.length=l,f},u.MAX_VALUE=a(new u(-Math.PI,-o.PI_OVER_TWO,Math.PI,o.PI_OVER_TWO)),u}),define("Core/BoundingRectangle",["./Cartesian2","./Cartographic","./defaultValue","./defined","./DeveloperError","./GeographicProjection","./Intersect","./Rectangle"],function(e,r,t,n,i,a,o,u){"use strict";var s=function(e,r,n,i){this.x=t(e,0),this.y=t(r,0),this.width=t(n,0),this.height=t(i,0)};s.fromPoints=function(e,r){if(n(r)||(r=new s),!n(e)||0===e.length)return r.x=0,r.y=0,r.width=0,r.height=0,r;for(var t=e.length,i=e[0].x,a=e[0].y,o=e[0].x,u=e[0].y,f=1;t>f;f++){var l=e[f],c=l.x,h=l.y;i=Math.min(c,i),o=Math.max(c,o),a=Math.min(h,a),u=Math.max(h,u)}return r.x=i,r.y=a,r.width=o-i,r.height=u-a,r};var f=new a,l=new r,c=new r;return s.fromRectangle=function(r,i,a){if(n(a)||(a=new s),!n(r))return a.x=0,a.y=0,a.width=0,a.height=0,a;i=t(i,f);var o=i.project(u.getSouthwest(r,l)),h=i.project(u.getNortheast(r,c));return e.subtract(h,o,h),a.x=o.x,a.y=o.y,a.width=h.x,a.height=h.y,a},s.clone=function(e,r){return n(e)?n(r)?(r.x=e.x,r.y=e.y,r.width=e.width,r.height=e.height,r):new s(e.x,e.y,e.width,e.height):void 0},s.union=function(e,r,t){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");n(t)||(t=new s);var a=Math.min(e.x,r.x),o=Math.min(e.y,r.y),u=Math.max(e.x+e.width,r.x+r.width),f=Math.max(e.y+e.height,r.y+r.height);return t.x=a,t.y=o,t.width=u-a,t.height=f-o,t},s.expand=function(e,r,t){if(!n(e))throw new i("rectangle is required.");if(!n(r))throw new i("point is required.");t=s.clone(e,t);var a=r.x-t.x,o=r.y-t.y;return a>t.width?t.width=a:0>a&&(t.width-=a,t.x=r.x),o>t.height?t.height=o:0>o&&(t.height-=o,t.y=r.y),t},s.intersect=function(e,r){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");var t=e.x,a=e.y,u=r.x,s=r.y;return t>u+r.width||t+e.width<u||a+e.height<s||a>s+r.height?o.OUTSIDE:o.INTERSECTING},s.equals=function(e,r){return e===r||n(e)&&n(r)&&e.x===r.x&&e.y===r.y&&e.width===r.width&&e.height===r.height},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.intersect=function(e){return s.intersect(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};i.fromElements=function(e,t,n,a,o){return r(o)?(o.x=e,o.y=t,o.z=n,o.w=a,o):new i(e,t,n,a)},i.fromColor=function(e,n){if(!r(e))throw new t("color is required");
return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a++]=n.z,i[a]=n.w},i.unpack=function(n,a,o){if(!r(n))throw new t("array is required");return a=e(a,0),r(o)||(o=new i),o.x=n[a++],o.y=n[a++],o.z=n[a++],o.w=n[a],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},i.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},i.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},i.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},i.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return i.subtract(e,n,a),i.magnitude(a)},i.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var a=i.magnitude(e);return n.x=e.x/a,n.y=e.y/a,n.z=e.z/a,n.w=e.w/a,n},i.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},i.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},i.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},i.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},i.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},i.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},i.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},i.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var o=new i;i.lerp=function(e,n,a,u){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof a)throw new t("t is required and must be a number.");if(!r(u))throw new t("result is required.");return i.multiplyByScalar(n,a,o),u=i.multiplyByScalar(e,1-a,u),i.add(o,u,u)};var u=new i;return i.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var a=i.normalize(e,u);return i.abs(a,a),n=a.x<=a.y?a.x<=a.z?a.x<=a.w?i.clone(i.UNIT_X,n):i.clone(i.UNIT_W,n):a.z<=a.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n):a.y<=a.z?a.y<=a.w?i.clone(i.UNIT_Y,n):i.clone(i.UNIT_W,n):a.z<=a.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},i.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i&&Math.abs(e.w-n.w)<=i},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,r){return i.equalsEpsilon(this,e,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a){"use strict";function o(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function u(e){for(var r=0,t=0;3>t;++t){var n=e[f.getElementIndex(d[t],h[t])];r+=2*n*n}return Math.sqrt(r)}function s(e,r){for(var t=a.EPSILON15,n=0,i=1,o=0;3>o;++o){var u=Math.abs(e[f.getElementIndex(d[o],h[o])]);u>n&&(i=o,n=u)}var s=1,l=0,c=h[i],w=d[i];if(Math.abs(e[f.getElementIndex(w,c)])>t){var m,p=e[f.getElementIndex(w,w)],y=e[f.getElementIndex(c,c)],v=e[f.getElementIndex(w,c)],g=(p-y)/2/v;m=0>g?-1/(-g+Math.sqrt(1+g*g)):1/(g+Math.sqrt(1+g*g)),s=1/Math.sqrt(1+m*m),l=m*s}return r=f.clone(f.IDENTITY,r),r[f.getElementIndex(c,c)]=r[f.getElementIndex(w,w)]=s,r[f.getElementIndex(w,c)]=l,r[f.getElementIndex(c,w)]=-l,r}var f=function(e,t,n,i,a,o,u,s,f){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(f,0)};f.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new f(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},f.fromArray=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new f),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a[9]=e[i+9],a},f.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},f.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,u=e.x*e.w,s=e.y*e.y,l=e.y*e.z,c=e.y*e.w,h=e.z*e.z,d=e.z*e.w,w=e.w*e.w,m=i-s-h+w,p=2*(a-d),y=2*(o+c),v=2*(a+d),g=-i+s-h+w,x=2*(l-u),b=2*(o-c),q=2*(l+u),E=-i-s+h+w;return t(r)?(r[0]=m,r[1]=v,r[2]=b,r[3]=p,r[4]=g,r[5]=q,r[6]=y,r[7]=x,r[8]=E,r):new f(m,p,y,v,g,x,b,q,E)},f.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new f(e.x,0,0,0,e.y,0,0,0,e.z)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new f(e,0,0,0,e,0,0,0,e)},f.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=a,r[6]=0,r[7]=-a,r[8]=i,r):new f(1,0,0,0,i,-a,0,a,i)},f.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=i,r):new f(i,0,a,0,1,0,-a,0,i)},f.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=a,r[2]=0,r[3]=-a,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new f(i,-a,0,a,i,0,0,0,1)},f.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},f.getColumn=function(r,i,a){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var o=3*i,u=r[o],s=r[o+1],f=r[o+2];return t(a)?(a.x=u,a.y=s,a.z=f,a):new e(u,s,f)},f.setColumn=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");a=f.clone(e,a);var o=3*r;return a[o]=i.x,a[o+1]=i.y,a[o+2]=i.z,a},f.getRow=function(r,i,a){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var o=r[i],u=r[i+3],s=r[i+6];return t(a)?(a.x=o,a.y=u,a.z=s,a):new e(o,u,s)},f.setRow=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");return a=f.clone(e,a),a[r]=i.x,a[r+3]=i.y,a[r+6]=i.z,a};var l=new e;f.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");return t(i)||(i=new e),i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],l)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],l)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],l)),i};var c=new e;f.getMaximumScale=function(r){return f.getScale(r,c),e.getMaximumComponent(c)},f.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");var a=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],o=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],u=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],l=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],h=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],d=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],w=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return t(i)?(i[0]=a,i[1]=o,i[2]=u,i[3]=s,i[4]=l,i[5]=c,i[6]=h,i[7]=d,i[8]=w,i):new f(a,s,h,o,l,d,u,c,w)},f.multiplyByVector=function(r,i,a){if(!t(r))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");var o=i.x,u=i.y,s=i.z,f=r[0]*o+r[3]*u+r[6]*s,l=r[1]*o+r[4]*u+r[7]*s,c=r[2]*o+r[5]*u+r[8]*s;return t(a)?(a.x=f,a.y=l,a.z=c,a):new e(f,l,c)},f.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");return t(i)?(i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i):new f(e[0]*r,e[3]*r,e[6]*r,e[1]*r,e[4]*r,e[7]*r,e[2]*r,e[5]*r,e[8]*r)},f.negate=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r):new f(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},f.transpose=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],a=e[3],o=e[6],u=e[1],s=e[4],l=e[7],c=e[2],h=e[5],d=e[8];return t(r)?(r[0]=i,r[1]=a,r[2]=o,r[3]=u,r[4]=s,r[5]=l,r[6]=c,r[7]=h,r[8]=d,r):new f(i,u,c,a,s,h,o,l,d)};var h=[1,0,0],d=[2,2,1],w=new f,m=new f;return f.getEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=a.EPSILON20,l=10,c=0,h=0;t(r)||(r={});for(var d=r.unitary=f.clone(f.IDENTITY,r.unitary),p=r.diagonal=f.clone(e,r.diagonal),y=i*o(p);l>h&&u(p)>y;)s(p,w),f.transpose(w,m),f.multiply(p,w,p),f.multiply(m,p,p),f.multiply(d,w,d),++c>2&&(++h,c=0);return r},f.abs=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r):new f(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},f.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],a=e[6],o=e[1],u=e[4],s=e[7],f=e[2],l=e[5],c=e[8];return r*(u*c-l*s)+o*(l*a-i*c)+f*(i*s-u*a)},f.inverse=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],o=e[1],u=e[2],s=e[3],l=e[4],c=e[5],h=e[6],d=e[7],w=e[8],m=f.determinant(e);if(Math.abs(m)<=a.EPSILON15)throw new n("matrix is not invertible");t(r)||(r=new f),r[0]=l*w-d*c,r[1]=d*u-o*w,r[2]=o*c-l*u,r[3]=h*c-s*w,r[4]=i*w-h*u,r[5]=s*u-i*c,r[6]=s*d-h*l,r[7]=h*o-i*d,r[8]=i*l-s*o;var p=1/m;return f.multiplyByScalar(r,p,r)},f.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},f.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},f.IDENTITY=i(new f(1,0,0,0,1,0,0,0,1)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN1ROW0=3,f.COLUMN1ROW1=4,f.COLUMN1ROW2=5,f.COLUMN2ROW0=6,f.COLUMN2ROW1=7,f.COLUMN2ROW2=8,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},f}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,a,o,u,s){"use strict";var f=function(e,r,n,i,a,o,u,s,f,l,c,h,d,w,m,p){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(f,0),this[3]=t(d,0),this[4]=t(r,0),this[5]=t(o,0),this[6]=t(l,0),this[7]=t(w,0),this[8]=t(n,0),this[9]=t(u,0),this[10]=t(c,0),this[11]=t(m,0),this[12]=t(i,0),this[13]=t(s,0),this[14]=t(h,0),this[15]=t(p,0)};f.packedLength=16,f.pack=function(e,r,a){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");a=t(a,0),r[a++]=e[0],r[a++]=e[1],r[a++]=e[2],r[a++]=e[3],r[a++]=e[4],r[a++]=e[5],r[a++]=e[6],r[a++]=e[7],r[a++]=e[8],r[a++]=e[9],r[a++]=e[10],r[a++]=e[11],r[a++]=e[12],r[a++]=e[13],r[a++]=e[14],r[a]=e[15]},f.unpack=function(e,r,a){if(!n(e))throw new i("array is required");return r=t(r,0),n(a)||(a=new f),a[0]=e[r++],a[1]=e[r++],a[2]=e[r++],a[3]=e[r++],a[4]=e[r++],a[5]=e[r++],a[6]=e[r++],a[7]=e[r++],a[8]=e[r++],a[9]=e[r++],a[10]=e[r++],a[11]=e[r++],a[12]=e[r++],a[13]=e[r++],a[14]=e[r++],a[15]=e[r],a},f.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(e,r,t){if(!n(e))throw new i("rotation is required.");if(!n(r))throw new i("translation is required.");return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=0,t[4]=e[3],t[5]=e[4],t[6]=e[5],t[7]=0,t[8]=e[6],t[9]=e[7],t[10]=e[8],t[11]=0,t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=1,t):new f(e[0],e[3],e[6],r.x,e[1],e[4],e[7],r.y,e[2],e[5],e[8],r.z,0,0,0,1)},new u,f.fromTranslationQuaternionRotationScale=function(e,r,t,a){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(a)||(a=new f);var o=t.x,u=t.y,s=t.z,l=r.x*r.x,c=r.x*r.y,h=r.x*r.z,d=r.x*r.w,w=r.y*r.y,m=r.y*r.z,p=r.y*r.w,y=r.z*r.z,v=r.z*r.w,g=r.w*r.w,x=l-w-y+g,b=2*(c-v),q=2*(h+p),E=2*(c+v),S=-l+w-y+g,T=2*(m-d),O=2*(h-p),M=2*(m+d),_=-l-w+y+g;return a[0]=x*o,a[1]=E*o,a[2]=O*o,a[3]=0,a[4]=b*u,a[5]=S*u,a[6]=M*u,a[7]=0,a[8]=q*s,a[9]=T*s,a[10]=_*s,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},f.fromTranslation=function(e,r){return f.fromRotationTranslation(u.IDENTITY,e,r)},f.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,c=new e,h=new e;f.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var a=r.eye,o=r.target,u=r.up;if(!n(a))throw new i("camera.eye is required.");if(!n(o))throw new i("camera.target is required.");if(!n(u))throw new i("camera.up is required.");e.normalize(e.subtract(o,a,l),l),e.normalize(e.cross(l,u,c),c),e.normalize(e.cross(c,l,h),h);var s=c.x,d=c.y,w=c.z,m=l.x,p=l.y,y=l.z,v=h.x,g=h.y,x=h.z,b=a.x,q=a.y,E=a.z,S=s*-b+d*-q+w*-E,T=v*-b+g*-q+x*-E,O=m*b+p*q+y*E;return n(t)?(t[0]=s,t[1]=v,t[2]=-m,t[3]=0,t[4]=d,t[5]=g,t[6]=-p,t[7]=0,t[8]=w,t[9]=x,t[10]=-y,t[11]=0,t[12]=S,t[13]=T,t[14]=O,t[15]=1,t):new f(s,d,w,S,v,g,x,T,-m,-p,-y,O,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,r,t,a,o){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=a)throw new i("far must be greater than zero.");var u=Math.tan(.5*e),s=1/u,l=s/r,c=(a+t)/(t-a),h=2*a*t/(t-a);return n(o)?(o[0]=l,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=-1,o[12]=0,o[13]=0,o[14]=h,o[15]=0,o):new f(l,0,0,0,0,s,0,0,0,0,c,h,0,0,-1,0)},f.computeOrthographicOffCenter=function(e,r,t,a,o,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(u))throw new i("far is required.");var l=1/(r-e),c=1/(a-t),h=1/(u-o),d=-(r+e)*l,w=-(a+t)*c,m=-(u+o)*h;return l*=2,c*=2,h*=-2,n(s)?(s[0]=l,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=h,s[11]=0,s[12]=d,s[13]=w,s[14]=m,s[15]=1,s):new f(l,0,0,d,0,c,0,w,0,0,h,m,0,0,0,1)},f.computePerspectiveOffCenter=function(e,r,t,a,o,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(u))throw new i("far is required.");var l=2*o/(r-e),c=2*o/(a-t),h=(r+e)/(r-e),d=(a+t)/(a-t),w=-(u+o)/(u-o),m=-1,p=-2*u*o/(u-o);return n(s)?(s[0]=l,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=h,s[9]=d,s[10]=w,s[11]=m,s[12]=0,s[13]=0,s[14]=p,s[15]=0,s):new f(l,0,h,0,0,c,d,0,0,0,w,p,0,0,m,0)},f.computeInfinitePerspectiveOffCenter=function(e,r,t,a,o,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");var s=2*o/(r-e),l=2*o/(a-t),c=(r+e)/(r-e),h=(a+t)/(a-t),d=-1,w=-1,m=-2*o;return n(u)?(u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=l,u[6]=0,u[7]=0,u[8]=c,u[9]=h,u[10]=d,u[11]=w,u[12]=0,u[13]=0,u[14]=m,u[15]=0,u):new f(s,0,c,0,0,l,h,0,0,0,d,m,0,0,w,0)},f.computeViewportTransformation=function(e,r,i,a){e=t(e,t.EMPTY_OBJECT);var o=t(e.x,0),u=t(e.y,0),s=t(e.width,0),l=t(e.height,0);r=t(r,0),i=t(i,1);var c=.5*s,h=.5*l,d=.5*(i-r),w=c,m=h,p=d,y=o+c,v=u+h,g=r+d,x=1;return n(a)?(a[0]=w,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=m,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=p,a[11]=0,a[12]=y,a[13]=v,a[14]=g,a[15]=x,a):new f(w,0,0,y,0,m,0,v,0,0,p,g,0,0,0,x)},f.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},f.getColumn=function(e,t,a){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var o=4*t,u=e[o],s=e[o+1],f=e[o+2],l=e[o+3];return n(a)?(a.x=u,a.y=s,a.z=f,a.w=l,a):new r(u,s,f,l)},f.setColumn=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");a=f.clone(e,a);var o=4*r;return a[o]=t.x,a[o+1]=t.y,a[o+2]=t.z,a[o+3]=t.w,a},f.getRow=function(e,t,a){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var o=e[t],u=e[t+4],s=e[t+8],f=e[t+12];return n(a)?(a.x=o,a.y=u,a.z=s,a.w=f,a):new r(o,u,s,f)},f.setRow=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");return a=f.clone(e,a),a[r]=t.x,a[r+4]=t.y,a[r+8]=t.z,a[r+12]=t.w,a};var d=new e;f.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");return n(t)||(t=new e),t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],d)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],d)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],d)),t};var w=new e;f.getMaximumScale=function(r){return f.getScale(r,w),e.getMaximumComponent(w)},f.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var a=e[0],o=e[1],u=e[2],s=e[3],l=e[4],c=e[5],h=e[6],d=e[7],w=e[8],m=e[9],p=e[10],y=e[11],v=e[12],g=e[13],x=e[14],b=e[15],q=r[0],E=r[1],S=r[2],T=r[3],O=r[4],M=r[5],_=r[6],P=r[7],N=r[8],I=r[9],A=r[10],C=r[11],R=r[12],z=r[13],D=r[14],L=r[15],U=a*q+l*E+w*S+v*T,B=o*q+c*E+m*S+g*T,F=u*q+h*E+p*S+x*T,W=s*q+d*E+y*S+b*T,G=a*O+l*M+w*_+v*P,V=o*O+c*M+m*_+g*P,Y=u*O+h*M+p*_+x*P,j=s*O+d*M+y*_+b*P,k=a*N+l*I+w*A+v*C,H=o*N+c*I+m*A+g*C,Z=u*N+h*I+p*A+x*C,X=s*N+d*I+y*A+b*C,J=a*R+l*z+w*D+v*L,K=o*R+c*z+m*D+g*L,Q=u*R+h*z+p*D+x*L,$=s*R+d*z+y*D+b*L;return n(t)?(t[0]=U,t[1]=B,t[2]=F,t[3]=W,t[4]=G,t[5]=V,t[6]=Y,t[7]=j,t[8]=k,t[9]=H,t[10]=Z,t[11]=X,t[12]=J,t[13]=K,t[14]=Q,t[15]=$,t):new f(U,G,k,J,B,V,H,K,F,Y,Z,Q,W,j,X,$)},f.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var a=e[0],o=e[1],u=e[2],s=e[4],l=e[5],c=e[6],h=e[8],d=e[9],w=e[10],m=e[12],p=e[13],y=e[14],v=r[0],g=r[1],x=r[2],b=r[4],q=r[5],E=r[6],S=r[8],T=r[9],O=r[10],M=r[12],_=r[13],P=r[14],N=a*v+s*g+h*x,I=o*v+l*g+d*x,A=u*v+c*g+w*x,C=a*b+s*q+h*E,R=o*b+l*q+d*E,z=u*b+c*q+w*E,D=a*S+s*T+h*O,L=o*S+l*T+d*O,U=u*S+c*T+w*O,B=a*M+s*_+h*P+m,F=o*M+l*_+d*P+p,W=u*M+c*_+w*P+y;return n(t)?(t[0]=N,t[1]=I,t[2]=A,t[3]=0,t[4]=C,t[5]=R,t[6]=z,t[7]=0,t[8]=D,t[9]=L,t[10]=U,t[11]=0,t[12]=B,t[13]=F,t[14]=W,t[15]=1,t):new f(N,C,D,B,I,R,L,F,A,z,U,W,0,0,0,1)},f.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");var a=r.x,o=r.y,u=r.z,s=a*e[0]+o*e[4]+u*e[8]+e[12],l=a*e[1]+o*e[5]+u*e[9]+e[13],c=a*e[2]+o*e[6]+u*e[10]+e[14];return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=s,t[13]=l,t[14]=c,t[15]=e[15],t):new f(e[0],e[4],e[8],s,e[1],e[5],e[9],l,e[2],e[6],e[10],c,e[3],e[7],e[11],e[15])};var m=new e;return f.multiplyByUniformScale=function(e,r,t){if("number"!=typeof r)throw new i("scale is required");return m.x=r,m.y=r,m.z=r,f.multiplyByScale(e,m,t)},f.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");var a=r.x,o=r.y,u=r.z;return 1===a&&1===o&&1===u?f.clone(e,t):n(t)?(t[0]=a*e[0],t[1]=a*e[1],t[2]=a*e[2],t[3]=0,t[4]=o*e[4],t[5]=o*e[5],t[6]=o*e[6],t[7]=0,t[8]=u*e[8],t[9]=u*e[9],t[10]=u*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t):new f(a*e[0],o*e[4],u*e[8],e[12],a*e[1],o*e[5],u*e[9],e[13],a*e[2],o*e[6],u*e[10],e[14],0,0,0,1)},f.multiplyByVector=function(e,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,u=t.y,s=t.z,f=t.w,l=e[0]*o+e[4]*u+e[8]*s+e[12]*f,c=e[1]*o+e[5]*u+e[9]*s+e[13]*f,h=e[2]*o+e[6]*u+e[10]*s+e[14]*f,d=e[3]*o+e[7]*u+e[11]*s+e[15]*f;return n(a)?(a.x=l,a.y=c,a.z=h,a.w=d,a):new r(l,c,h,d)},f.multiplyByPointAsVector=function(r,t,a){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,u=t.y,s=t.z,f=r[0]*o+r[4]*u+r[8]*s,l=r[1]*o+r[5]*u+r[9]*s,c=r[2]*o+r[6]*u+r[10]*s;return n(a)?(a.x=f,a.y=l,a.z=c,a):new e(f,l,c)},f.multiplyByPoint=function(r,t,a){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,u=t.y,s=t.z,f=r[0]*o+r[4]*u+r[8]*s+r[12],l=r[1]*o+r[5]*u+r[9]*s+r[13],c=r[2]*o+r[6]*u+r[10]*s+r[14];return n(a)?(a.x=f,a.y=l,a.z=c,a):new e(f,l,c)},f.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");return n(t)?(t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t):new f(e[0]*r,e[4]*r,e[8]*r,e[12]*r,e[1]*r,e[5]*r,e[9]*r,e[13]*r,e[2]*r,e[6]*r,e[10]*r,e[14]*r,e[3]*r,e[7]*r,e[11]*r,e[15]*r)},f.negate=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r):new f(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},f.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))return new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var t=e[1],a=e[2],o=e[3],u=e[6],s=e[7],l=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=a,r[9]=u,r[10]=e[10],r[11]=e[14],r[12]=o,r[13]=s,r[14]=l,r[15]=e[15],r},f.abs=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r):new f(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},f.equals=function(e,r){return e===r||n(e)&&n(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[11]===r[11]&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[15]===r[15]},f.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},f.getTranslation=function(r,t){if(!n(r))throw new i("matrix is required");return n(t)?(t.x=r[12],t.y=r[13],t.z=r[14],t):new e(r[12],r[13],r[14])},f.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r):new u(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},f.inverse=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],a=e[4],u=e[8],l=e[12],c=e[1],h=e[5],d=e[9],w=e[13],m=e[2],p=e[6],y=e[10],v=e[14],g=e[3],x=e[7],b=e[11],q=e[15],E=y*q,S=v*b,T=p*q,O=v*x,M=p*b,_=y*x,P=m*q,N=v*g,I=m*b,A=y*g,C=m*x,R=p*g,z=E*h+O*d+M*w-(S*h+T*d+_*w),D=S*c+P*d+A*w-(E*c+N*d+I*w),L=T*c+N*h+C*w-(O*c+P*h+R*w),U=_*c+I*h+R*d-(M*c+A*h+C*d),B=S*a+T*u+_*l-(E*a+O*u+M*l),F=E*t+N*u+I*l-(S*t+P*u+A*l),W=O*t+P*a+R*l-(T*t+N*a+C*l),G=M*t+A*a+C*u-(_*t+I*a+R*u);E=u*w,S=l*d,T=a*w,O=l*h,M=a*d,_=u*h,P=t*w,N=l*c,I=t*d,A=u*c,C=t*h,R=a*c;var V=E*x+O*b+M*q-(S*x+T*b+_*q),Y=S*g+P*b+A*q-(E*g+N*b+I*q),j=T*g+N*x+C*q-(O*g+P*x+R*q),k=_*g+I*x+R*b-(M*g+A*x+C*b),H=T*y+_*v+S*p-(M*v+E*p+O*y),Z=I*v+E*m+N*y-(P*y+A*v+S*m),X=P*p+R*v+O*m-(C*v+T*m+N*p),J=C*y+M*m+A*p-(I*p+R*y+_*m),K=t*z+a*D+u*L+l*U;if(Math.abs(K)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return K=1/K,n(r)?(r[0]=z*K,r[1]=D*K,r[2]=L*K,r[3]=U*K,r[4]=B*K,r[5]=F*K,r[6]=W*K,r[7]=G*K,r[8]=V*K,r[9]=Y*K,r[10]=j*K,r[11]=k*K,r[12]=H*K,r[13]=Z*K,r[14]=X*K,r[15]=J*K,r):new f(z*K,B*K,V*K,H*K,D*K,F*K,Y*K,Z*K,L*K,W*K,j*K,X*K,U*K,G*K,k*K,J*K)},f.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],a=e[1],o=e[2],u=e[4],s=e[5],l=e[6],c=e[8],h=e[9],d=e[10],w=e[12],m=e[13],p=e[14],y=-t*w-a*m-o*p,v=-u*w-s*m-l*p,g=-c*w-h*m-d*p;return n(r)?(r[0]=t,r[1]=u,r[2]=c,r[3]=0,r[4]=a,r[5]=s,r[6]=h,r[7]=0,r[8]=o,r[9]=l,r[10]=d,r[11]=0,r[12]=y,r[13]=v,r[14]=g,r[15]=1,r):new f(t,a,o,y,u,s,l,v,c,h,d,g,0,0,0,1)},f.IDENTITY=a(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,r,t,n,i,a,o,u,s,f,l){"use strict";var c=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},h=new e,d=new e,w=new e,m=new e,p=new e,y=new e,v=new e,g=new e,x=new e,b=new e,q=new e,E=new e;
c.fromPoints=function(r,t){if(n(t)||(t=new c),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],v),a=e.clone(i,h),o=e.clone(i,d),u=e.clone(i,w),s=e.clone(i,m),f=e.clone(i,p),l=e.clone(i,y),S=r.length,T=1;S>T;T++){e.clone(r[T],i);var O=i.x,M=i.y,_=i.z;O<a.x&&e.clone(i,a),O>s.x&&e.clone(i,s),M<o.y&&e.clone(i,o),M>f.y&&e.clone(i,f),_<u.z&&e.clone(i,u),_>l.z&&e.clone(i,l)}var P=e.magnitudeSquared(e.subtract(s,a,g)),N=e.magnitudeSquared(e.subtract(f,o,g)),I=e.magnitudeSquared(e.subtract(l,u,g)),A=a,C=s,R=P;N>R&&(R=N,A=o,C=f),I>R&&(R=I,A=u,C=l);var z=x;z.x=.5*(A.x+C.x),z.y=.5*(A.y+C.y),z.z=.5*(A.z+C.z);var D=e.magnitudeSquared(e.subtract(C,z,g)),L=Math.sqrt(D),U=b;U.x=a.x,U.y=o.y,U.z=u.z;var B=q;B.x=s.x,B.y=f.y,B.z=l.z;var F=e.multiplyByScalar(e.add(U,B,g),.5,E),W=0;for(T=0;S>T;T++){e.clone(r[T],i);var G=e.magnitude(e.subtract(i,F,g));G>W&&(W=G);var V=e.magnitudeSquared(e.subtract(i,z,g));if(V>D){var Y=Math.sqrt(V);L=.5*(L+Y),D=L*L;var j=Y-L;z.x=(L*z.x+j*i.x)/Y,z.y=(L*z.y+j*i.y)/Y,z.z=(L*z.z+j*i.z)/Y}}return W>L?(e.clone(z,t.center),t.radius=L):(e.clone(F,t.center),t.radius=W),t};var S=new o,T=new e,O=new e,M=new r,_=new r;c.fromRectangle2D=function(e,r,t){return c.fromRectangleWithHeights2D(e,r,0,0,t)},c.fromRectangleWithHeights2D=function(r,i,a,o,u){if(n(u)||(u=new c),!n(r))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=t(i,S),l.getSouthwest(r,M),M.height=a,l.getNortheast(r,_),_.height=o;var s=i.project(M,T),f=i.project(_,O),h=f.x-s.x,d=f.y-s.y,w=f.z-s.z;u.radius=.5*Math.sqrt(h*h+d*d+w*w);var m=u.center;return m.x=s.x+.5*h,m.y=s.y+.5*d,m.z=s.z+.5*w,u};var P=[];c.fromRectangle3D=function(e,r,i,o){r=t(r,a.WGS84),i=t(i,0);var u;return n(e)&&(u=l.subsample(e,r,i,P)),c.fromPoints(u,o)},c.fromVertices=function(r,a,o,u){if(n(u)||(u=new c),!n(r)||0===r.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;if(a=t(a,e.ZERO),o=t(o,3),3>o)throw new i("stride must be 3 or greater.");var s=v;s.x=r[0]+a.x,s.y=r[1]+a.y,s.z=r[2]+a.z;for(var f=e.clone(s,h),l=e.clone(s,d),S=e.clone(s,w),T=e.clone(s,m),O=e.clone(s,p),M=e.clone(s,y),_=r.length,P=0;_>P;P+=o){var N=r[P]+a.x,I=r[P+1]+a.y,A=r[P+2]+a.z;s.x=N,s.y=I,s.z=A,N<f.x&&e.clone(s,f),N>T.x&&e.clone(s,T),I<l.y&&e.clone(s,l),I>O.y&&e.clone(s,O),A<S.z&&e.clone(s,S),A>M.z&&e.clone(s,M)}var C=e.magnitudeSquared(e.subtract(T,f,g)),R=e.magnitudeSquared(e.subtract(O,l,g)),z=e.magnitudeSquared(e.subtract(M,S,g)),D=f,L=T,U=C;R>U&&(U=R,D=l,L=O),z>U&&(U=z,D=S,L=M);var B=x;B.x=.5*(D.x+L.x),B.y=.5*(D.y+L.y),B.z=.5*(D.z+L.z);var F=e.magnitudeSquared(e.subtract(L,B,g)),W=Math.sqrt(F),G=b;G.x=f.x,G.y=l.y,G.z=S.z;var V=q;V.x=T.x,V.y=O.y,V.z=M.z;var Y=e.multiplyByScalar(e.add(G,V,g),.5,E),j=0;for(P=0;_>P;P+=o){s.x=r[P]+a.x,s.y=r[P+1]+a.y,s.z=r[P+2]+a.z;var k=e.magnitude(e.subtract(s,Y,g));k>j&&(j=k);var H=e.magnitudeSquared(e.subtract(s,B,g));if(H>F){var Z=Math.sqrt(H);W=.5*(W+Z),F=W*W;var X=Z-W;B.x=(W*B.x+X*s.x)/Z,B.y=(W*B.y+X*s.y)/Z,B.z=(W*B.z+X*s.z)/Z}}return j>W?(e.clone(B,u.center),u.radius=W):(e.clone(Y,u.center),u.radius=j),u},c.fromCornerPoints=function(r,t,a){if(!n(r)||!n(t))throw new i("corner and oppositeCorner are required.");n(a)||(a=new c);var o=a.center;return e.add(r,t,o),e.multiplyByScalar(o,.5,o),a.radius=e.distance(o,t),a},c.fromEllipsoid=function(r,t){if(!n(r))throw new i("ellipsoid is required.");return n(t)||(t=new c),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t},c.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new c(r.center,r.radius):void 0},c.packedLength=4,c.pack=function(e,r,a){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");a=t(a,0);var o=e.center;r[a++]=o.x,r[a++]=o.y,r[a++]=o.z,r[a]=e.radius},c.unpack=function(e,r,a){if(!n(e))throw new i("array is required");r=t(r,0),n(a)||(a=new c);var o=a.center;return o.x=e[r++],o.y=e[r++],o.z=e[r++],a.radius=e[r],a};var N=new e,I=new e;c.union=function(r,t,a){if(!n(r))throw new i("left is required.");if(!n(t))throw new i("right is required.");n(a)||(a=new c);var o=r.center,u=t.center;e.add(o,u,I);var s=e.multiplyByScalar(I,.5,I),f=e.magnitude(e.subtract(o,s,N))+r.radius,l=e.magnitude(e.subtract(u,s,N))+t.radius;return a.radius=Math.max(f,l),e.clone(s,a.center),a};var A=new e;c.expand=function(r,t,a){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("point is required.");a=c.clone(r,a);var o=e.magnitude(e.subtract(t,a.center,A));return o>a.radius&&(a.radius=o),a},c.intersect=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("plane is required.");var a=r.center,o=r.radius,s=e.dot(t,a)+t.w;return-o>s?u.OUTSIDE:o>s?u.INTERSECTING:u.INSIDE},c.transform=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new c),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=f.getMaximumScale(r)*e.radius,t};var C=new e;c.distanceSquaredTo=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("cartesian is required.");var a=e.subtract(r.center,t,C);return e.magnitudeSquared(a)-r.radius*r.radius},c.transformWithoutScale=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new c),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var R=new e;c.getPlaneDistances=function(r,t,a,o){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("position is required.");if(!n(a))throw new i("direction is required.");n(o)||(o=new s);var u=e.subtract(r.center,t,R),f=e.multiplyByScalar(a,e.dot(a,u),R),l=e.magnitude(f);return o.start=l-r.radius,o.stop=l+r.radius,o};for(var z=new e,D=new e,L=new e,U=new e,B=new e,F=new r,W=new Array(8),G=0;8>G;++G)W[G]=new e;var V=new o;return c.projectTo2D=function(r,a,o){if(!n(r))throw new i("sphere is required.");a=t(a,V);var u=a.ellipsoid,s=r.center,f=r.radius,l=u.geodeticSurfaceNormal(s,z),h=e.cross(e.UNIT_Z,l,D);e.normalize(h,h);var d=e.cross(l,h,L);e.normalize(d,d),e.multiplyByScalar(l,f,l),e.multiplyByScalar(d,f,d),e.multiplyByScalar(h,f,h);var w=e.negate(d,B),m=e.negate(h,U),p=W,y=p[0];e.add(l,d,y),e.add(y,h,y),y=p[1],e.add(l,d,y),e.add(y,m,y),y=p[2],e.add(l,w,y),e.add(y,m,y),y=p[3],e.add(l,w,y),e.add(y,h,y),e.negate(l,l),y=p[4],e.add(l,d,y),e.add(y,h,y),y=p[5],e.add(l,d,y),e.add(y,m,y),y=p[6],e.add(l,w,y),e.add(y,m,y),y=p[7],e.add(l,w,y),e.add(y,h,y);for(var v=p.length,g=0;v>g;++g){var x=p[g];e.add(s,x,x);var b=u.cartesianToCartographic(x,F);a.project(b,x)}o=c.fromPoints(p,o),s=o.center;var q=s.x,E=s.y,S=s.z;return s.x=S,s.y=q,s.z=E,o},c.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius},c.prototype.intersect=function(e){return c.intersect(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.prototype.clone=function(e){return c.clone(this,e)},c}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;u>o;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=s+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=s+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=s+"fullscreenchange",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(h)){var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null===e?h=!1:(h=!0,d=n(e[1]))}return h}function a(){return i()&&d}function o(){if(!r(w))if(i()||!/ Safari\/[\.0-9]+/.test(navigator.userAgent))w=!1;else{var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null===e?w=!1:(w=!0,m=n(e[1]))}return w}function u(){return o()&&m}function s(){if(!r(p)){var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null===e?p=!1:(p=!0,y=n(e[1]),y.isNightly=!!e[2])}return p}function f(){return s()&&y}function l(){if(!r(v)){var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(v=!0,g=n(e[1]))):"Netscape"===navigator.appName?(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(v=!0,g=n(e[1]))):v=!1}return v}function c(){return l()&&g}var h,d,w,m,p,y,v,g,x={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:f,isInternetExplorer:l,internetExplorerVersion:c,hardwareConcurrency:e(navigator.hardwareConcurrency,3)};return x.supportsFullscreen=function(){return t.supportsFullscreen()},x.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},x}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection"],function(e,r,t,n){"use strict";if(!n.supportsTypedArrays())return{};var i={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return i.getSizeInBytes=function(e){if(!r(e))throw new t("value is required.");switch(e){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new t("componentDatatype is not a valid value.")}},i.fromTypedArray=function(e){return e instanceof Int8Array?i.BYTE:e instanceof Uint8Array?i.UNSIGNED_BYTE:e instanceof Int16Array?i.SHORT:e instanceof Uint16Array?i.UNSIGNED_SHORT:e instanceof Float32Array?i.FLOAT:e instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(e){return r(e)&&(e===i.BYTE||e===i.UNSIGNED_BYTE||e===i.SHORT||e===i.UNSIGNED_SHORT||e===i.FLOAT||e===i.DOUBLE)},i.createTypedArray=function(e,n){if(!r(e))throw new t("componentDatatype is required.");if(!r(n))throw new t("valuesOrLength is required.");switch(e){case i.BYTE:return new Int8Array(n);case i.UNSIGNED_BYTE:return new Uint8Array(n);case i.SHORT:return new Int16Array(n);case i.UNSIGNED_SHORT:return new Uint16Array(n);case i.FLOAT:return new Float32Array(n);case i.DOUBLE:return new Float64Array(n);default:throw new t("componentDatatype is not a valid value.")}},i.createArrayBufferView=function(n,a,o,u){if(!r(n))throw new t("componentDatatype is required.");if(!r(a))throw new t("buffer is required.");switch(o=e(o,0),u=e(u,(a.byteLength-o)/i.getSizeInBytes(n)),n){case i.BYTE:return new Int8Array(a,o,u);case i.UNSIGNED_BYTE:return new Uint8Array(a,o,u);case i.SHORT:return new Int16Array(a,o,u);case i.UNSIGNED_SHORT:return new Uint16Array(a,o,u);case i.FLOAT:return new Float32Array(a,o,u);case i.DOUBLE:return new Float64Array(a,o,u);default:throw new t("componentDatatype is not a valid value.")}},i}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Intersect"],function(e,r,t,n,i){"use strict";var a=function(n,i,a){this.minimum=e.clone(r(n,e.ZERO)),this.maximum=e.clone(r(i,e.ZERO)),t(a)?a=e.clone(a):(a=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(a,.5,a)),this.center=a};a.fromPoints=function(r,n){if(t(n)||(n=new a),!t(r)||0===r.length)return n.minimum=e.clone(e.ZERO,n.minimum),n.maximum=e.clone(e.ZERO,n.maximum),n.center=e.clone(e.ZERO,n.center),n;for(var i=r[0].x,o=r[0].y,u=r[0].z,s=r[0].x,f=r[0].y,l=r[0].z,c=r.length,h=1;c>h;h++){var d=r[h],w=d.x,m=d.y,p=d.z;i=Math.min(w,i),s=Math.max(w,s),o=Math.min(m,o),f=Math.max(m,f),u=Math.min(p,u),l=Math.max(p,l)}var y=n.minimum;y.x=i,y.y=o,y.z=u;var v=n.maximum;v.x=s,v.y=f,v.z=l;var g=e.add(y,v,n.center);return e.multiplyByScalar(g,.5,g),n},a.clone=function(r,n){return t(r)?t(n)?(n.minimum=e.clone(r.minimum,n.minimum),n.maximum=e.clone(r.maximum,n.maximum),n.center=e.clone(r.center,n.center),n):new a(r.minimum,r.maximum):void 0},a.equals=function(r,n){return r===n||t(r)&&t(n)&&e.equals(r.center,n.center)&&e.equals(r.minimum,n.minimum)&&e.equals(r.maximum,n.maximum)};var o=new e;return a.intersect=function(r,a){if(!t(r))throw new n("box is required.");if(!t(a))throw new n("plane is required.");o=e.subtract(r.maximum,r.minimum,o);var u=e.multiplyByScalar(o,.5,o),s=u.x*Math.abs(a.x)+u.y*Math.abs(a.y)+u.z*Math.abs(a.z),f=e.dot(r.center,a)+a.w;return f-s>0?i.INSIDE:0>f+s?i.OUTSIDE:i.INTERSECTING},a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.intersect=function(e){return a.intersect(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,r){"use strict";function t(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}var n={};return n.discriminant=function(r,t,n){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=t*t-4*r*n;return i},n.realRoots=function(n,i,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");var o;if(0===n)return 0===i?[]:[-a/i];if(0===i){if(0===a)return[0,0];var u=Math.abs(a),s=Math.abs(n);if(s>u&&u/s<r.EPSILON14)return[0,0];if(u>s&&s/u<r.EPSILON14)return[];if(o=-a/n,0>o)return[];var f=Math.sqrt(o);return[-f,f]}if(0===a)return o=-i/n,0>o?[o,0]:[0,o];var l=i*i,c=4*n*a,h=t(l,-c,r.EPSILON14);if(0>h)return[];var d=-.5*t(i,r.sign(i)*Math.sqrt(h),r.EPSILON14);return i>0?[d/n,a/d]:[a/d,d/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,r){"use strict";function t(e,r,t,n){var i,a,o=e,u=r/3,s=t/3,f=n,l=o*s,c=u*f,h=u*u,d=s*s,w=o*s-h,m=o*f-u*s,p=u*f-d,y=4*w*p-m*m;if(0>y){var v,g,x;h*c>=l*d?(v=o,g=w,x=-2*u*w+o*m):(v=f,g=p,x=-f*m+2*s*p);var b=0>x?-1:1,q=-b*Math.abs(v)*Math.sqrt(-y);a=-x+q;var E=a/2,S=0>E?-Math.pow(-E,1/3):Math.pow(E,1/3),T=a===q?-S:-g/S;return i=0>=g?S+T:-x/(S*S+T*T+g),h*c>=l*d?[(i-u)/o]:[-f/(i+s)]}var O=w,M=-2*u*w+o*m,_=p,P=-f*m+2*s*p,N=Math.sqrt(y),I=Math.sqrt(3)/2,A=Math.abs(Math.atan2(o*N,-M)/3);i=2*Math.sqrt(-O);var C=Math.cos(A);a=i*C;var R=i*(-C/2-I*Math.sin(A)),z=a+R>2*u?a-u:R-u,D=o,L=z/D;A=Math.abs(Math.atan2(f*N,-P)/3),i=2*Math.sqrt(-_),C=Math.cos(A),a=i*C,R=i*(-C/2-I*Math.sin(A));var U=-f,B=2*s>a+R?a+s:R+s,F=U/B,W=D*B,G=-z*B-D*U,V=z*U,Y=(s*G-u*V)/(-u*G+s*W);return Y>=L?F>=L?F>=Y?[L,Y,F]:[L,F,Y]:[F,L,Y]:F>=L?[Y,L,F]:F>=Y?[Y,F,L]:[F,Y,L]}var n={};return n.discriminant=function(r,t,n,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var a=r*r,o=t*t,u=n*n,s=i*i,f=18*r*t*n*i+o*u-27*a*s-4*(r*u*n+o*t*i);return f},n.realRoots=function(n,i,a,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var u,s;if(0===n)return r.realRoots(i,a,o);if(0===i){if(0===a){if(0===o)return[0,0,0];s=-o/n;var f=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[f,f,f]}return 0===o?(u=r.realRoots(n,0,a),0===u.Length?[0]:[u[0],0,u[1]]):t(n,0,a,o)}return 0===a?0===o?(s=-i/n,0>s?[s,0,0]:[0,0,s]):t(n,i,0,o):0===o?(u=r.realRoots(n,i,a),0===u.length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]):t(n,i,a,o)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,r,t,n){"use strict";function i(r,i,a,o){var u=r*r,s=i-3*u/8,f=a-i*r/2+u*r/8,l=o-a*r/4+i*u/16-3*u*u/256,c=e.realRoots(1,2*s,s*s-4*l,-f*f);if(c.length>0){var h=-r/4,d=c[c.length-1];if(Math.abs(d)<t.EPSILON14){var w=n.realRoots(1,s,l);if(2===w.length){var m,p=w[0],y=w[1];if(p>=0&&y>=0){var v=Math.sqrt(p),g=Math.sqrt(y);return[h-g,h-v,h+v,h+g]}if(p>=0&&0>y)return m=Math.sqrt(p),[h-m,h+m];if(0>p&&y>=0)return m=Math.sqrt(y),[h-m,h+m]}return[]}if(d>0){var x=Math.sqrt(d),b=(s+d-f/x)/2,q=(s+d+f/x)/2,E=n.realRoots(1,x,b),S=n.realRoots(1,-x,q);return 0!==E.length?(E[0]+=h,E[1]+=h,0!==S.length?(S[0]+=h,S[1]+=h,E[1]<=S[0]?[E[0],E[1],S[0],S[1]]:S[1]<=E[0]?[S[0],S[1],E[0],E[1]]:E[0]>=S[0]&&E[1]<=S[1]?[S[0],E[0],E[1],S[1]]:S[0]>=E[0]&&S[1]<=E[1]?[E[0],S[0],S[1],E[1]]:E[0]>S[0]&&E[0]<S[1]?[S[0],E[0],S[1],E[1]]:[E[0],S[0],E[1],S[1]]):E):0!==S.length?(S[0]+=h,S[1]+=h,S):[]}}return[]}function a(r,i,a,o){var u=a*a,s=i*i,f=r*r,l=-2*i,c=a*r+s-4*o,h=f*o-a*i*r+u,d=e.realRoots(1,l,c,h);if(d.length>0){var w,m,p=d[0],y=i-p,v=y*y,g=r/2,x=y/2,b=v-4*o,q=v+4*Math.abs(o),E=f-4*p,S=f+4*Math.abs(p);if(0>p||E*q>b*S){var T=Math.sqrt(E);w=T/2,m=0===T?0:(r*x-a)/T}else{var O=Math.sqrt(b);w=0===O?0:(r*x-a)/O,m=O/2}var M,_;0===g&&0===w?(M=0,_=0):t.sign(g)===t.sign(w)?(M=g+w,_=p/M):(_=g-w,M=p/_);var P,N;0===x&&0===m?(P=0,N=0):t.sign(x)===t.sign(m)?(P=x+m,N=o/P):(N=x-m,P=o/N);var I=n.realRoots(1,M,P),A=n.realRoots(1,_,N);if(0!==I.length)return 0!==A.length?I[1]<=A[0]?[I[0],I[1],A[0],A[1]]:A[1]<=I[0]?[A[0],A[1],I[0],I[1]]:I[0]>=A[0]&&I[1]<=A[1]?[A[0],I[0],I[1],A[1]]:A[0]>=I[0]&&A[1]<=I[1]?[I[0],A[0],A[1],I[1]]:I[0]>A[0]&&I[0]<A[1]?[A[0],I[0],A[1],I[1]]:[I[0],A[0],I[1],A[1]]:I;if(0!==A.length)return A}return[]}var o={};return o.discriminant=function(e,t,n,i,a){if("number"!=typeof e)throw new r("a is a required number.");if("number"!=typeof t)throw new r("b is a required number.");if("number"!=typeof n)throw new r("c is a required number.");if("number"!=typeof i)throw new r("d is a required number.");if("number"!=typeof a)throw new r("e is a required number.");var o=e*e,u=o*e,s=t*t,f=s*t,l=n*n,c=l*n,h=i*i,d=h*i,w=a*a,m=w*a,p=s*l*h-4*f*d-4*e*c*h+18*e*t*n*d-27*o*h*h+256*u*m+a*(18*f*n*i-4*s*c+16*e*l*l-80*e*t*l*i-6*e*s*h+144*o*n*h)+w*(144*e*s*n-27*s*s-128*o*l-192*o*t*i);return p},o.realRoots=function(n,o,u,s,f){if("number"!=typeof n)throw new r("a is a required number.");if("number"!=typeof o)throw new r("b is a required number.");if("number"!=typeof u)throw new r("c is a required number.");if("number"!=typeof s)throw new r("d is a required number.");if("number"!=typeof f)throw new r("e is a required number.");if(Math.abs(n)<t.EPSILON15)return e.realRoots(o,u,s,f);var l=o/n,c=u/n,h=s/n,d=f/n,w=0>l?1:0;switch(w+=0>c?w+1:w,w+=0>h?w+1:w,w+=0>d?w+1:w){case 0:return i(l,c,h,d);case 1:return a(l,c,h,d);case 2:return a(l,c,h,d);case 3:return i(l,c,h,d);case 4:return i(l,c,h,d);case 5:return a(l,c,h,d);case 6:return i(l,c,h,d);case 7:return i(l,c,h,d);case 8:return a(l,c,h,d);case 9:return i(l,c,h,d);case 10:return i(l,c,h,d);case 11:return a(l,c,h,d);case 12:return i(l,c,h,d);case 13:return i(l,c,h,d);case 14:return i(l,c,h,d);case 15:return i(l,c,h,d);default:return void 0}},o}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial"],function(e,r,t,n,i,a,o,u){"use strict";function s(e,r,t){var n=e+r;return i.sign(e)!==i.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<t?0:n}function f(r,t,n,f,l){var c,h=f*f,d=l*l,w=(r[a.COLUMN1ROW1]-r[a.COLUMN2ROW2])*d,m=l*(f*s(r[a.COLUMN1ROW0],r[a.COLUMN0ROW1],i.EPSILON15)+t.y),p=r[a.COLUMN0ROW0]*h+r[a.COLUMN2ROW2]*d+f*t.x+n,y=d*s(r[a.COLUMN2ROW1],r[a.COLUMN1ROW2],i.EPSILON15),v=l*(f*s(r[a.COLUMN2ROW0],r[a.COLUMN0ROW2])+t.z),g=[];if(0===v&&0===y){if(c=o.realRoots(w,m,p),0===c.length)return g;var x=c[0],b=Math.sqrt(Math.max(1-x*x,0));if(g.push(new e(f,l*x,l*-b)),g.push(new e(f,l*x,l*b)),2===c.length){var q=c[1],E=Math.sqrt(Math.max(1-q*q,0));g.push(new e(f,l*q,l*-E)),g.push(new e(f,l*q,l*E))}return g}var S=v*v,T=y*y,O=w*w,M=v*y,_=O+T,P=2*(m*w+M),N=2*p*w+m*m-T+S,I=2*(p*m-M),A=p*p-S;if(0===_&&0===P&&0===N&&0===I)return g;c=u.realRoots(_,P,N,I,A);var C=c.length;if(0===C)return g;for(var R=0;C>R;++R){var z,D=c[R],L=D*D,U=Math.max(1-L,0),B=Math.sqrt(U);z=i.sign(w)===i.sign(p)?s(w*L+p,m*D,i.EPSILON12):i.sign(p)===i.sign(m*D)?s(w*L,m*D+p,i.EPSILON12):s(w*L+m*D,p,i.EPSILON12);var F=s(y*D,v,i.EPSILON15),W=z*F;0>W?g.push(new e(f,l*D,l*B)):W>0?g.push(new e(f,l*D,l*-B)):0!==B?(g.push(new e(f,l*D,l*-B)),g.push(new e(f,l*D,l*B)),++R):g.push(new e(f,l*D,l*B))}return g}var l={};l.rayPlane=function(r,a,o){if(!t(r))throw new n("ray is required.");if(!t(a))throw new n("plane is required.");t(o)||(o=new e);var u=r.origin,s=r.direction,f=a.normal,l=e.dot(f,s);if(Math.abs(l)<i.EPSILON15)return void 0;var c=(-a.distance-e.dot(f,u))/l;return 0>c?void 0:(o=e.multiplyByScalar(s,c,o),e.add(u,o,o))};var c=new e,h=new e;l.rayEllipsoid=function(r,i){if(!t(r))throw new n("ray is required.");if(!t(i))throw new n("ellipsoid is required.");var a,o,u,s,f,l=i.oneOverRadii,d=e.multiplyComponents(l,r.origin,c),w=e.multiplyComponents(l,r.direction,h),m=e.magnitudeSquared(d),p=e.dot(d,w);if(m>1){if(p>=0)return void 0;var y=p*p;if(a=m-1,o=e.magnitudeSquared(w),u=o*a,u>y)return void 0;if(y>u){s=p*p-u,f=-p+Math.sqrt(s);var v=f/o,g=a/f;return g>v?{start:v,stop:g}:{start:g,stop:v}}var x=Math.sqrt(a/o);return{start:x,stop:x}}return 1>m?(a=m-1,o=e.magnitudeSquared(w),u=o*a,s=p*p-u,f=-p+Math.sqrt(s),{start:0,stop:f/o}):0>p?(o=e.magnitudeSquared(w),{start:0,stop:-p/o}):void 0};var d=new e,w=new e,m=new e,p=new e;l.grazingAltitudeLocation=function(o,u){if(!t(o))throw new n("ray is required.");if(!t(u))throw new n("ellipsoid is required.");var s=o.origin,l=o.direction,c=u.geodeticSurfaceNormal(s);if(e.dot(l,c)>=0)return s;var h,y,v=t(this.rayEllipsoid(o,u)),g=u.transformPositionToScaledSpace(l),x=e.normalize(g,d),b=e.mostOrthogonalAxis(g,p),q=e.normalize(e.cross(b,x,w),w),E=e.normalize(e.cross(x,q,m),m),S=new a(x.x,q.x,E.x,x.y,q.y,E.y,x.z,q.z,E.z),T=a.transpose(S),O=a.fromScale(u.radii),M=a.fromScale(u.oneOverRadii),_=new a(0,l.z,-l.y,-l.z,0,l.x,l.y,-l.x,0),P=a.multiply(a.multiply(T,M),_),N=a.multiply(a.multiply(P,O),S),I=a.multiplyByVector(P,s),A=f(N,e.negate(I,d),0,0,1),C=A.length;if(C>0){for(var R=e.ZERO,z=Number.NEGATIVE_INFINITY,D=0;C>D;++D){h=a.multiplyByVector(O,a.multiplyByVector(S,A[D]));var L=e.normalize(e.subtract(h,s,p),p),U=e.dot(L,l);U>z&&(z=U,R=h)}var B=u.cartesianToCartographic(R);return z=i.clamp(z,0,1),y=e.magnitude(e.subtract(R,s,p))*Math.sqrt(1-z*z),y=v?-y:y,u.cartographicToCartesian(new r(B.longitude,B.latitude,y))}return void 0};var y=new e;return l.lineSegmentPlane=function(r,a,o,u){if(!t(r))throw new n("endPoint0 is required.");if(!t(a))throw new n("endPoint1 is required.");if(!t(o))throw new n("plane is required.");t(u)||(u=new e);var s=e.subtract(a,r,y),f=o.normal,l=e.dot(f,s);if(Math.abs(l)<i.EPSILON6)return void 0;var c=e.dot(f,r),h=-(o.distance+c)/l;return 0>h||h>1?void 0:(e.multiplyByScalar(s,h,u),e.add(r,u,u),u)},l.trianglePlaneIntersection=function(r,i,a,o){if(!(t(r)&&t(i)&&t(a)&&t(o)))throw new n("p0, p1, p2, and plane are required.");var u=o.normal,s=o.distance,f=e.dot(u,r)+s<0,c=e.dot(u,i)+s<0,h=e.dot(u,a)+s<0,d=0;d+=f?1:0,d+=c?1:0,d+=h?1:0;var w,m;if((1===d||2===d)&&(w=new e,m=new e),1===d){if(f)return l.lineSegmentPlane(r,i,o,w),l.lineSegmentPlane(r,a,o,m),{positions:[r,i,a,w,m],indices:[0,3,4,1,2,4,1,4,3]};if(c)return l.lineSegmentPlane(i,a,o,w),l.lineSegmentPlane(i,r,o,m),{positions:[r,i,a,w,m],indices:[1,3,4,2,0,4,2,4,3]};if(h)return l.lineSegmentPlane(a,r,o,w),l.lineSegmentPlane(a,i,o,m),{positions:[r,i,a,w,m],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===d){if(!f)return l.lineSegmentPlane(i,r,o,w),l.lineSegmentPlane(a,r,o,m),{positions:[r,i,a,w,m],indices:[1,2,4,1,4,3,0,3,4]};if(!c)return l.lineSegmentPlane(a,i,o,w),l.lineSegmentPlane(r,i,o,m),{positions:[r,i,a,w,m],indices:[2,0,4,2,4,3,1,3,4]};if(!h)return l.lineSegmentPlane(r,a,o,w),l.lineSegmentPlane(i,a,o,m),{positions:[r,i,a,w,m],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},l}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n,i){if(!r(n))throw new t("normal is required.");if(!r(i))throw new t("distance is required.");this.normal=e.clone(n),this.distance=i};return n.fromPointNormal=function(i,a,o){if(!r(i))throw new t("point is required.");if(!r(a))throw new t("normal is required.");var u=-e.dot(a,i);return r(o)?(e.clone(a,o.normal),o.distance=u,o):new n(a,u)},n.getPointDistance=function(n,i){if(!r(n))throw new t("plane is required.");if(!r(i))throw new t("point is required.");return e.dot(n.normal,i)+n.distance},n}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=function(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n};return i.getPoint=function(r,i,a){if(!t(r))throw new n("ray is requred");if("number"!=typeof i)throw new n("t is a required number");return t(a)||(a=new e),a=e.multiplyByScalar(r.direction,i,a),e.add(r.origin,a,a)},i}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,t,n,i){return r(e).then(t,n,i)}function r(e){var r,t;return e instanceof n?r=e:u(e)?(t=o(),e.then(function(e){t.resolve(e)},function(e){t.reject(e)},function(e){t.progress(e)}),r=t.promise):r=i(e),r}function t(r){return e(r,a)}function n(e){this.then=e}function i(e){var t=new n(function(t){try{return r(t?t(e):e)}catch(n){return a(n)}});return t}function a(e){var t=new n(function(t,n){try{return n?r(n(e)):a(e)}catch(i){return a(i)}});return t}function o(){function e(e,r,t){return h(e,r,t)}function t(e){return w(e)}function i(e){return w(a(e))}function u(e){return d(e)}var s,f,l,c,h,d,w;return f=new n(e),s={then:e,resolve:t,reject:i,progress:u,promise:f,resolver:{resolve:t,reject:i,progress:u}},l=[],c=[],h=function(e,r,t){var n,i;return n=o(),i="function"==typeof t?function(e){try{n.progress(t(e))}catch(r){n.progress(r)}}:function(e){n.progress(e)},l.push(function(t){t.then(e,r).then(n.resolve,n.reject,i)}),c.push(i),n.promise},d=function(e){return m(c,e),e},w=function(e){return e=r(e),h=e.then,w=r,d=y,m(l,e),c=l=b,e},s}function u(e){return e&&"function"==typeof e.then}function s(r,t,n,i,a){return p(2,arguments),e(r,function(r){function u(e){m(e)}function s(e){w(e)}var f,l,c,h,d,w,m,p,v,g;if(v=r.length>>>0,f=Math.max(0,Math.min(t,v)),c=[],l=v-f+1,h=[],d=o(),f)for(p=d.progress,m=function(e){h.push(e),--l||(w=m=y,d.reject(h))},w=function(e){c.push(e),--f||(w=m=y,d.resolve(c))},g=0;v>g;++g)g in r&&e(r[g],s,u,p);else d.resolve(c);return d.then(n,i,a)})}function f(e,r,t,n){function i(e){return r?r(e[0]):e[0]}return s(e,1,i,t,n)}function l(e,r,t,n){return p(1,arguments),h(e,v).then(r,t,n)}function c(){return h(arguments,v)}function h(r,t){return e(r,function(r){var n,i,a,u,s,f;if(a=i=r.length>>>0,n=[],f=o(),a)for(u=function(r,i){e(r,t).then(function(e){n[i]=e,--a||f.resolve(n)},f.reject)},s=0;i>s;s++)s in r?u(r[s],s):--a;else f.resolve(n);return f.promise})}function d(r,t){var n=x.call(arguments,1);return e(r,function(r){var i;return i=r.length,n[0]=function(r,n,a){return e(r,function(r){return e(n,function(e){return t(r,e,a,i)})})},g.apply(r,n)})}function w(r,t,n){var i=arguments.length>2;return e(r,function(e){return e=i?n:e,t.resolve(e),e},function(e){return t.reject(e),a(e)},t.progress)}function m(e,r){for(var t,n=0;t=e[n++];)t(r)}function p(e,r){for(var t,n=r.length;n>e;)if(t=r[--n],null!=t&&"function"!=typeof t)throw new Error("arg "+n+" must be a function")}function y(){}function v(e){return e}var g,x,b;return e.defer=o,e.resolve=r,e.reject=t,e.join=c,e.all=l,e.map=h,e.reduce=d,e.any=f,e.some=s,e.chain=w,e.isPromise=u,n.prototype={always:function(e,r){return this.then(e,e,r)},otherwise:function(e){return this.then(b,e)},yield:function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(r){return l(r,function(r){return e.apply(b,r)})})}},x=[].slice,g=[].reduce||function(e){var r,t,n,i,a;if(a=0,r=Object(this),i=r.length>>>0,t=arguments,t.length<=1)for(;;){if(a in r){n=r[a++];break}if(++a>=i)throw new TypeError}else n=t[1];for(;i>a;++a)a in r&&(n=e(n,r[a],a,r));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,r){"use strict";var t=function(t,n,i){if(!e(t))throw new r("array is required.");if(!e(n))throw new r("itemToFind is required.");if(!e(i))throw new r("comparator is required.");for(var a,o,u=0,s=t.length-1;s>=u;)if(a=~~((u+s)/2),o=i(t[a],n),0>o)u=a+1;else{if(!(o>0))return a;s=a-1}return~(s+1)};return t}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,r,t,n,i){this.xPoleWander=e,this.yPoleWander=r,this.xPoleOffset=t,this.yPoleOffset=n,this.ut1MinusUtc=i};return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,r=arguments,t=0,n=r[t++],i=function(e,r,t,n){t||(t=" ");var i=e.length>=r?"":Array(1+r-e.length>>>0).join(t);return n?e+i:i+e},a=function(e,r,t,n,a,o){var u=n-e.length;return u>0&&(e=t||!a?i(e,n,o,t):e.slice(0,r.length)+i("",u,"0",!0)+e.slice(r.length)),e},o=function(e,r,t,n,o,u,s){var f=e>>>0;return t=t&&f&&{2:"0b",8:"0",16:"0x"}[r]||"",e=t+i(f.toString(r),u||0,"0",!1),a(e,t,n,o,s)},u=function(e,r,t,n,i,o){return null!=n&&(e=e.slice(0,n)),a(e,"",r,t,i,o)},s=function(e,n,s,f,l,c,h){var d,w,m,p,y;if("%%"==e)return"%";for(var v=!1,g="",x=!1,b=!1,q=" ",E=s.length,S=0;s&&E>S;S++)switch(s.charAt(S)){case" ":g=" ";break;case"+":g="+";break;case"-":v=!0;break;case"'":q=s.charAt(S+1);break;case"0":x=!0;break;case"#":b=!0}if(f=f?"*"==f?+r[t++]:"*"==f.charAt(0)?+r[f.slice(1,-1)]:+f:0,0>f&&(f=-f,v=!0),!isFinite(f))throw new Error("sprintf: (minimum-)width must be finite");switch(c=c?"*"==c?+r[t++]:"*"==c.charAt(0)?+r[c.slice(1,-1)]:+c:"fFeE".indexOf(h)>-1?6:"d"==h?0:void 0,y=n?r[n.slice(0,-1)]:r[t++],h){case"s":return u(String(y),v,f,c,x,q);case"c":return u(String.fromCharCode(+y),v,f,c,x);case"b":return o(y,2,b,v,f,c,x);case"o":return o(y,8,b,v,f,c,x);case"x":return o(y,16,b,v,f,c,x);case"X":return o(y,16,b,v,f,c,x).toUpperCase();case"u":return o(y,10,b,v,f,c,x);case"i":case"d":return d=+y||0,d=Math.round(d-d%1),w=0>d?"-":g,y=w+i(String(Math.abs(d)),c,"0",!1),a(y,w,v,f,x);
case"e":case"E":case"f":case"F":case"g":case"G":return d=+y,w=0>d?"-":g,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(h.toLowerCase())],p=["toString","toUpperCase"]["eEfFgG".indexOf(h)%2],y=w+Math.abs(d)[m](c),a(y,w,v,f,x)[p]();default:return e}};return n.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";var e=function(e,r,t,n,i,a,o,u){this.year=e,this.month=r,this.day=t,this.hour=n,this.minute=i,this.second=a,this.millisecond=o,this.isLeapSecond=u};return e}),define("Core/isArray",["./defined"],function(e){"use strict";var r=Array.isArray;return e(r)||(r=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),r}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function r(r){if(null===r||isNaN(r))throw new e("year is required and must be a number.");return 0===r%4&&0!==r%100||0===r%400}return r}),define("Core/LeapSecond",[],function(){"use strict";var e=function(e,r){this.julianDate=e,this.offset=r};return e}),define("Core/TimeConstants",[],function(){"use strict";var e={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e}),define("Core/TimeStandard",[],function(){"use strict";var e={UTC:0,TAI:1};return e}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./defineProperties","./DeveloperError","./GregorianDate","./isArray","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,r,t,n,i,a,o,u,s,f,l,c){"use strict";function h(e,r){return I.compare(e.julianDate,r.julianDate)}function d(e){x.julianDate=e;var t=I.leapSeconds,n=r(t,x,h);0>n&&(n=~n),n>=t.length&&(n=t.length-1);var i=t[n].offset;if(n>0){var a=I.getSecondsDifference(t[n].julianDate,e);a>i&&(n--,i=t[n].offset)}I.addSeconds(e,i,e)}function w(e,t){x.julianDate=e;var n=I.leapSeconds,i=r(n,x,h);if(0>i&&(i=~i),0===i)return I.addSeconds(e,-n[0].offset,t);if(i>=n.length)return I.addSeconds(e,-n[i-1].offset,t);var a=I.getSecondsDifference(n[i].julianDate,e);return 0===a?I.addSeconds(e,-n[i].offset,t):1>=a?void 0:I.addSeconds(e,-n[--i].offset,t)}function m(e,r,t){var n=0|r/l.SECONDS_PER_DAY;return e+=n,r-=l.SECONDS_PER_DAY*n,0>r&&(e--,r+=l.SECONDS_PER_DAY),t.dayNumber=e,t.secondsOfDay=r,t}function p(e,r,t,n,i,a,o){var u=0|(r-14)/12,s=e+4800+u,f=(0|1461*s/4)+(0|367*(r-2-12*u)/12)-(0|3*((s+100)/100)/4)+t-32075;n-=12,0>n&&(n+=24);var c=a+(n*l.SECONDS_PER_HOUR+i*l.SECONDS_PER_MINUTE+o*l.SECONDS_PER_MILLISECOND);return c>=43200&&(f-=1),[f,c]}var y=new o,v=[31,28,31,30,31,30,31,31,30,31,30,31],g=29,x=new f,b=/^(\d{4})$/,q=/^(\d{4})-(\d{2})$/,E=/^(\d{4})-?(\d{3})$/,S=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,T=/^(\d{4})-?(\d{2})-?(\d{2})$/,O=/([Z+\-])?(\d{2})?:?(\d{2})?$/,M=/^(\d{2})(\.\d+)?/.source+O.source,_=/^(\d{2}):?(\d{2})(\.\d+)?/.source+O.source,P=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+O.source,N="Invalid ISO 8601 date.",I=function(e,r,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=t(e,0),r=t(r,0),n=t(n,c.UTC);var i=0|e;r+=(e-i)*l.SECONDS_PER_DAY,m(i,r,this),n===c.UTC&&d(this)};I.fromDate=function(e,r){if(!(e instanceof Date)||isNaN(e.getTime()))throw new a("date must be a valid JavaScript Date.");var t=p(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(r)?(m(t[0],t[1],r),d(r),r):new I(t[0],t[1],c.UTC)},I.fromIso8601=function(e,r){if("string"!=typeof e)throw new a(N);e=e.replace(",",".");var t,i,o,u=e.split("T"),f=1,l=1,h=0,w=0,y=0,x=0,O=u[0],A=u[1];if(!n(O))throw new a(N);var C;if(u=O.match(T),null!==u){if(C=O.split("-").length-1,C>0&&2!==C)throw new a(N);t=+u[1],f=+u[2],l=+u[3]}else if(u=O.match(q),null!==u)t=+u[1],f=+u[2];else if(u=O.match(b),null!==u)t=+u[1];else{var R;if(u=O.match(E),null!==u){if(t=+u[1],R=+u[2],o=s(t),1>R||o&&R>366||!o&&R>365)throw new a(N)}else{if(u=O.match(S),null===u)throw new a(N);t=+u[1];var z=+u[2],D=+u[3]||0;if(C=O.split("-").length-1,C>0&&(!n(u[3])&&1!==C||n(u[3])&&2!==C))throw new a(N);var L=new Date(Date.UTC(t,0,4));R=7*z+D-L.getUTCDay()-3}i=new Date(Date.UTC(t,0,1)),i.setUTCDate(R),f=i.getUTCMonth()+1,l=i.getUTCDate()}if(o=s(t),1>f||f>12||1>l||(2!==f||!o)&&l>v[f-1]||o&&2===f&&l>g)throw new a(N);var U;if(n(A)){if(u=A.match(P),null!==u){if(C=A.split(":").length-1,C>0&&2!==C&&3!==C)throw new a(N);h=+u[1],w=+u[2],y=+u[3],x=1e3*+(u[4]||0),U=5}else if(u=A.match(_),null!==u){if(C=A.split(":").length-1,C>0&&1!==C)throw new a(N);h=+u[1],w=+u[2],y=60*+(u[3]||0),U=4}else{if(u=A.match(M),null===u)throw new a(N);h=+u[1],w=60*+(u[2]||0),U=3}if(w>=60||y>=61||h>24||24===h&&(w>0||y>0||x>0))throw new a(N);var B=u[U],F=+u[U+1],W=+(u[U+2]||0);switch(B){case"+":h-=F,w-=W;break;case"-":h+=F,w+=W;break;case"Z":break;default:w+=new Date(Date.UTC(t,f-1,l,h,w)).getTimezoneOffset()}}else w+=new Date(Date.UTC(t,f-1,l)).getTimezoneOffset();var G=60===y;for(G&&y--;w>=60;)w-=60,h++;for(;h>=24;)h-=24,l++;for(i=o&&2===f?g:v[f-1];l>i;)l-=i,f++,f>12&&(f-=12,t++),i=o&&2===f?g:v[f-1];for(;0>w;)w+=60,h--;for(;0>h;)h+=24,l--;for(;1>l;)f--,1>f&&(f+=12,t--),i=o&&2===f?g:v[f-1],l+=i;var V=p(t,f,l,h,w,y,x);return n(r)?(m(V[0],V[1],r),d(r)):r=new I(V[0],V[1],c.UTC),G&&I.addSeconds(r,1,r),r},I.now=function(e){return I.fromDate(new Date,e)};var A=new I(0,0,c.TAI);return I.toGregorianDate=function(e,r){if(!n(e))throw new a("julianDate is required.");var t=!1,i=w(e,A);n(i)||(I.addSeconds(e,-1,A),i=w(A,A),t=!0);var u=i.dayNumber,s=i.secondsOfDay;s>=43200&&(u+=1);var f=0|u+68569,c=0|4*f/146097;f=0|f-(0|(146097*c+3)/4);var h=0|4e3*(f+1)/1461001;f=0|f-(0|1461*h/4)+31;var d=0|80*f/2447,m=0|f-(0|2447*d/80);f=0|d/11;var p=0|d+2-12*f,y=0|100*(c-49)+h+f,v=0|s/l.SECONDS_PER_HOUR,g=s-v*l.SECONDS_PER_HOUR,x=0|g/l.SECONDS_PER_MINUTE;g-=x*l.SECONDS_PER_MINUTE;var b=0|g,q=(g-b)/l.SECONDS_PER_MILLISECOND;return v+=12,v>23&&(v-=24),t&&(b+=1),n(r)?(r.year=y,r.month=p,r.day=m,r.hour=v,r.minute=x,r.second=b,r.millisecond=q,r.isLeapSecond=t,r):new o(y,p,m,v,x,b,q,t)},I.toDate=function(e){if(!n(e))throw new a("julianDate is required.");var r=I.toGregorianDate(e,y),t=r.second;return r.isLeapSecond&&(t-=1),new Date(Date.UTC(r.year,r.month-1,r.day,r.hour,r.minute,t,r.millisecond))},I.toIso8601=function(r,t){if(!n(r))throw new a("julianDate is required.");var i,o=I.toGregorianDate(r,o);return n(t)||0===o.millisecond?n(t)&&0!==t?(i=(.01*o.millisecond).toFixed(t).replace(".","").slice(0,t),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,i)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",o.year,o.month,o.day,o.hour,o.minute,o.second):(i=(.01*o.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,i))},I.clone=function(e,r){return n(e)?n(r)?(r.dayNumber=e.dayNumber,r.secondsOfDay=e.secondsOfDay,r):new I(e.dayNumber,e.secondsOfDay,c.TAI):void 0},I.compare=function(e,r){if(!n(e))throw new a("left is required.");if(!n(r))throw new a("right is required.");var t=e.dayNumber-r.dayNumber;return 0!==t?t:e.secondsOfDay-r.secondsOfDay},I.equals=function(e,r){return e===r||n(e)&&n(r)&&e.dayNumber===r.dayNumber&&e.secondsOfDay===r.secondsOfDay},I.equalsEpsilon=function(e,r,t){if(!n(t))throw new a("epsilon is required.");return e===r||n(e)&&n(r)&&Math.abs(I.getSecondsDifference(e,r))<=t},I.getTotalDays=function(e){if(!n(e))throw new a("julianDate is required.");return e.dayNumber+e.secondsOfDay/l.SECONDS_PER_DAY},I.getSecondsDifference=function(e,r){if(!n(e))throw new a("left is required.");if(!n(r))throw new a("right is required.");var t=(e.dayNumber-r.dayNumber)*l.SECONDS_PER_DAY;return t+(e.secondsOfDay-r.secondsOfDay)},I.getDaysDifference=function(e,r){if(!n(e))throw new a("left is required.");if(!n(r))throw new a("right is required.");var t=e.dayNumber-r.dayNumber,i=(e.secondsOfDay-r.secondsOfDay)/l.SECONDS_PER_DAY;return t+i},I.getTaiMinusUtc=function(e){x.julianDate=e;var t=I.leapSeconds,n=r(t,x,h);return 0>n&&(n=~n,--n,0>n&&(n=0)),t[n].offset},I.addSeconds=function(e,r,t){if(!n(e))throw new a("julianDate is required.");if(!n(r))throw new a("seconds is required.");if(!n(t))throw new a("result is required.");return m(e.dayNumber,e.secondsOfDay+r,t)},I.addMinutes=function(e,r,t){if(!n(e))throw new a("julianDate is required.");if(!n(r))throw new a("minutes is required.");if(!n(t))throw new a("result is required.");var i=e.secondsOfDay+r*l.SECONDS_PER_MINUTE;return m(e.dayNumber,i,t)},I.addHours=function(e,r,t){if(!n(e))throw new a("julianDate is required.");if(!n(r))throw new a("hours is required.");if(!n(t))throw new a("result is required.");var i=e.secondsOfDay+r*l.SECONDS_PER_HOUR;return m(e.dayNumber,i,t)},I.addDays=function(e,r,t){if(!n(e))throw new a("julianDate is required.");if(!n(r))throw new a("days is required.");if(!n(t))throw new a("result is required.");var i=e.dayNumber+r;return m(i,e.secondsOfDay,t)},I.lessThan=function(e,r){return I.compare(e,r)<0},I.lessThanOrEquals=function(e,r){return I.compare(e,r)<=0},I.greaterThan=function(e,r){return I.compare(e,r)>0},I.greaterThanOrEquals=function(e,r){return I.compare(e,r)>=0},I.prototype.clone=function(e){return I.clone(this,e)},I.prototype.equals=function(e){return I.equals(this,e)},I.prototype.equalsEpsilon=function(e,r){return I.equalsEpsilon(this,e,r)},I.leapSeconds=[new f(new I(2441317,43210,c.TAI),10),new f(new I(2441499,43211,c.TAI),11),new f(new I(2441683,43212,c.TAI),12),new f(new I(2442048,43213,c.TAI),13),new f(new I(2442413,43214,c.TAI),14),new f(new I(2442778,43215,c.TAI),15),new f(new I(2443144,43216,c.TAI),16),new f(new I(2443509,43217,c.TAI),17),new f(new I(2443874,43218,c.TAI),18),new f(new I(2444239,43219,c.TAI),19),new f(new I(2444786,43220,c.TAI),20),new f(new I(2445151,43221,c.TAI),21),new f(new I(2445516,43222,c.TAI),22),new f(new I(2446247,43223,c.TAI),23),new f(new I(2447161,43224,c.TAI),24),new f(new I(2447892,43225,c.TAI),25),new f(new I(2448257,43226,c.TAI),26),new f(new I(2448804,43227,c.TAI),27),new f(new I(2449169,43228,c.TAI),28),new f(new I(2449534,43229,c.TAI),29),new f(new I(2450083,43230,c.TAI),30),new f(new I(2450630,43231,c.TAI),31),new f(new I(2451179,43232,c.TAI),32),new f(new I(2453736,43233,c.TAI),33),new f(new I(2454832,43234,c.TAI),34),new f(new I(2456109,43235,c.TAI),35)],I}),define("Core/clone",["./defaultValue"],function(e){"use strict";var r=function(t,n){if(null===t||"object"!=typeof t)return t;n=e(n,!1);var i=new t.constructor;for(var a in t)if(t.hasOwnProperty(a)){var o=t[a];n&&(o=r(o,n)),i[a]=o}return i};return r}),define("Core/parseResponseHeaders",[],function(){"use strict";var e=function(e){var r={};if(!e)return r;for(var t=e.split("\r\n"),n=0;n<t.length;++n){var i=t[n],a=i.indexOf(": ");if(a>0){var o=i.substring(0,a),u=i.substring(a+2);r[o]=u}}return r};return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,r){"use strict";var t=function(e,t,n){this.statusCode=e,this.response=t,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=r(this.responseHeaders))};return t.prototype.toString=function(){var r="Request has failed.";return e(this.statusCode)&&(r+=" Status Code: "+this.statusCode),r},t}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent"],function(e,r,t,n,i){"use strict";function a(e,r){var t=decodeURIComponent(r);return e?atob(t):t}function o(e,r){for(var t=a(e,r),n=new ArrayBuffer(t.length),i=new Uint8Array(n),o=0;o<t.length;o++)i[o]=t.charCodeAt(o);return n}function u(e,t){t=r(t,"");var i=e[1],u=!!e[2],s=e[3];switch(t){case"":case"text":return a(u,s);case"arraybuffer":return o(u,s);case"blob":var f=o(u,s);return new Blob([f],{type:i});case"document":var l=new DOMParser;return l.parseFromString(a(u,s),i);case"json":return JSON.parse(a(u,s));default:throw new n("Unhandled responseType: "+t)}}var s=function(i){if(i=r(i,r.EMPTY_OBJECT),!t(i.url))throw new n("options.url is required.");var a=i.responseType,o=r(i.method,"GET"),u=i.data,f=i.headers,l=i.overrideMimeType;return e(i.url,function(r){var t=e.defer();return s.load(r,a,o,u,f,t,l),t.promise})},f=/^data:(.*?)(;base64)?,(.*)$/;return s.load=function(e,r,n,a,o,s,l){var c=f.exec(e);if(null!==c)return s.resolve(u(c,r)),void 0;var h=new XMLHttpRequest;if(t(l)&&h.overrideMimeType(l),h.open(n,e,!0),t(o))for(var d in o)o.hasOwnProperty(d)&&h.setRequestHeader(d,o[d]);t(r)&&(h.responseType=r),h.onload=function(){200===h.status?s.resolve(h.response):s.reject(new i(h.status,h.response,h.getAllResponseHeaders()))},h.onerror=function(){s.reject(new i)},h.send(a)},s.defaultLoad=s.load,s}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";var r=function(r,t){return e({url:r,headers:t})};return r}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,r,t,n){"use strict";var i={Accept:"application/json,*/*;q=0.01"},a=function(a,o){if(!r(a))throw new t("url is required.");return r(o)?r(o.Accept)||(o=e(o),o.Accept=i.Accept):o=i,n(a,o).then(function(e){return JSON.parse(e)})};return a}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,r,t,n,i,a,o,u,s,f,l,c){"use strict";function h(e,r){return o.compare(e.julianDate,r)}function d(e,t){if(!n(t.columnNames))return e._dataError="Error in loaded EOP data: The columnNames property is required.",void 0;if(!n(t.samples))return e._dataError="Error in loaded EOP data: The samples property is required.",void 0;var i=t.columnNames.indexOf("modifiedJulianDateUtc"),a=t.columnNames.indexOf("xPoleWanderRadians"),s=t.columnNames.indexOf("yPoleWanderRadians"),f=t.columnNames.indexOf("ut1MinusUtcSeconds"),d=t.columnNames.indexOf("xCelestialPoleOffsetRadians"),w=t.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=t.columnNames.indexOf("taiMinusUtcSeconds");if(0>i||0>a||0>s||0>f||0>d||0>w||0>m)return e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns",void 0;var p=e._samples=t.samples,y=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=a,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=f,e._xCelestialPoleOffsetRadiansColumn=d,e._yCelestialPoleOffsetRadiansColumn=w,e._taiMinusUtcSecondsColumn=m,e._columnCount=t.columnNames.length,e._lastIndex=void 0;for(var v,g=e._addNewLeapSeconds,x=0,b=p.length;b>x;x+=e._columnCount){var q=p[x+i],E=p[x+m],S=q+l.MODIFIED_JULIAN_DATE_DIFFERENCE,T=new o(S,E,c.TAI);if(y.push(T),g){if(E!==v&&n(v)){var O=o.leapSeconds,M=r(O,T,h);if(0>M){var _=new u(T,E);O.splice(~M,0,_)}}v=E}}}function w(e,r,t,n,i){var a=t*n;i.xPoleWander=r[a+e._xPoleWanderRadiansColumn],i.yPoleWander=r[a+e._yPoleWanderRadiansColumn],i.xPoleOffset=r[a+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=r[a+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=r[a+e._ut1MinusUtcSecondsColumn]}function m(e,r,t){return r+e*(t-r)}function p(e,r,t,n,i,a,u){var s=e._columnCount;if(a>r.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var f=r[i],l=r[a];if(f.equals(l)||n.equals(f))return w(e,t,i,s,u),u;if(n.equals(l))return w(e,t,a,s,u),u;var c=o.getSecondsDifference(n,f)/o.getSecondsDifference(l,f),h=i*s,d=a*s,p=t[h+e._ut1MinusUtcSecondsColumn],y=t[d+e._ut1MinusUtcSecondsColumn],v=y-p;if(v>.5||-.5>v){var g=t[h+e._taiMinusUtcSecondsColumn],x=t[d+e._taiMinusUtcSecondsColumn];g!==x&&(l.equals(n)?p=y:y-=x-g)}return u.xPoleWander=m(c,t[h+e._xPoleWanderRadiansColumn],t[d+e._xPoleWanderRadiansColumn]),u.yPoleWander=m(c,t[h+e._yPoleWanderRadiansColumn],t[d+e._yPoleWanderRadiansColumn]),u.xPoleOffset=m(c,t[h+e._xCelestialPoleOffsetRadiansColumn],t[d+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=m(c,t[h+e._yCelestialPoleOffsetRadiansColumn],t[d+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=m(c,p,y),u}var y=function(r){if(r=t(r,t.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=t(r.addNewLeapSeconds,!0),n(r.data))d(this,r.data);else if(n(r.url)){var i=this;this._downloadPromise=e(s(r.url),function(e){d(i,e)},function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+r.url+"."})}else d(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return y.NONE=a({getPromiseToLoad:function(){return e()},compute:function(e,r){return n(r)?(r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0):r=new i(0,0,0,0,0),r}}),y.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},y.prototype.compute=function(e,t){if(!n(this._samples)){if(n(this._dataError))throw new f(this._dataError);return void 0}if(n(t)||(t=new i(0,0,0,0,0)),0===this._samples.length)return t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0,t;var a=this._dates,u=this._lastIndex,s=0,l=0;if(n(u)){var c=a[u],h=a[u+1],d=o.lessThanOrEquals(c,e),w=!n(h),m=w||o.greaterThanOrEquals(h,e);if(d&&m)return s=u,!w&&h.equals(e)&&++s,l=s+1,p(this,a,this._samples,e,s,l,t),t}var y=r(a,e,o.compare,this._dateColumn);return y>=0?(y<a.length-1&&a[y+1].equals(e)&&++y,s=y,l=y):(l=~y,s=l-1,0>s&&(s=0)),this._lastIndex=s,p(this,a,this._samples,e,s,l,t),t},y}),define("ThirdParty/Uri",[],function(){function e(r){if(r instanceof e)this.scheme=r.scheme,this.authority=r.authority,this.path=r.path,this.query=r.query,this.fragment=r.fragment;else if(r){var t=n.exec(r);this.scheme=t[1],this.authority=t[2],this.path=t[3],this.query=t[4],this.fragment=t[5]}}function r(e){var r=unescape(e);return a.test(r)?r:e.toUpperCase()}function t(e,r,t,n){return(r||"")+t.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,t).replace(i,r)),this.path&&(this.path=this.path.replace(i,r)),this.query&&(this.query=this.query.replace(i,r)),this.fragment&&(this.fragment=this.fragment.replace(i,r))};var i=/%[0-9a-z]{2}/gi,a=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(r){var t=new e;return this.scheme?(t.scheme=this.scheme,t.authority=this.authority,t.path=this.path,t.query=this.query):(t.scheme=r.scheme,this.authority?(t.authority=this.authority,t.path=this.path,t.query=this.query):(t.authority=r.authority,""==this.path?(t.path=r.path,t.query=this.query||r.query):("/"==this.path.charAt(0)?(t.path=this.path,t.removeDotSegments()):(t.path=r.authority&&""==r.path?"/"+this.path:r.path.substring(0,r.path.lastIndexOf("/")+1)+this.path,t.removeDotSegments()),t.query=this.query))),t.fragment=this.fragment,t},e.prototype.removeDotSegments=function(){var e,r=this.path.split("/"),t=[],n=""==r[0];for(n&&r.shift(),""==r[0]?r.shift():null;r.length;)e=r.shift(),".."==e?t.pop():"."!=e&&t.push(e);("."==e||".."==e)&&t.push(""),n&&t.unshift(""),this.path=t.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,r,t,n){"use strict";function i(){for(var e=document.getElementsByTagName("script"),r=0,t=e.length;t>r;++r){var n=e[r].getAttribute("src"),i=c.exec(n);if(null!==i)return i[1]}return void 0}function a(){if(r(s))return s;var n;if(n="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:i(),!r(n))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return s=new e(n).resolve(new e(document.location.href))}function o(e){return n.toUrl("../"+e)}function u(r){return new e(r).resolve(a()).toString()}var s,f,l,c=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,h=function(e){r(f)||(f=r(n.toUrl)?o:u),r(l)||(l=document.createElement("a"));var t=f(e);return l.href=t,l.href=l.href,l.href};return h._cesiumScriptRegex=c,h}),define("Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,r,t){this.x=e,this.y=r,this.s=t};return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,r,t,n,i,a,o,u){"use strict";function s(e,r,t){var n=c;return n.dayNumber=r,n.secondsOfDay=t,a.getDaysDifference(n,e._sampleZeroDateTT)}function f(t,i){if(t._chunkDownloadsInProgress[i])return t._chunkDownloadsInProgress[i];var a=e.defer();t._chunkDownloadsInProgress[i]=a;var u,s=t._xysFileUrlTemplate;return u=n(s)?s.replace("{0}",i):r("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json"),e(o(u),function(e){t._chunkDownloadsInProgress[i]=!1;for(var r=t._samples,n=e.samples,o=3*i*t._samplesPerXysFile,u=0,s=n.length;s>u;++u)r[o+u]=n[u];a.resolve()}),a.promise}var l=function(e){e=t(e,t.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=t(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=t(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new a(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=t(e.stepSizeDays,1),this._samplesPerXysFile=t(e.samplesPerXysFile,1e3),this._totalSamples=t(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var r=this._interpolationOrder,n=this._denominators=new Array(r+1),i=this._xTable=new Array(r+1),o=Math.pow(this._stepSizeDays,r),s=0;r>=s;++s){n[s]=o,i[s]=s*this._stepSizeDays;for(var f=0;r>=f;++f)f!==s&&(n[s]*=s-f);n[s]=1/n[s]}this._work=new Array(r+1),this._coef=new Array(r+1)},c=new a(0,0,u.TAI);return l.prototype.preload=function(r,t,n,i){var a=s(this,r,t),o=s(this,n,i),u=0|a/this._stepSizeDays-this._interpolationOrder/2;0>u&&(u=0);var l=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;l>=this._totalSamples&&(l=this._totalSamples-1);for(var c=0|u/this._samplesPerXysFile,h=0|l/this._samplesPerXysFile,d=[],w=c;h>=w;++w)d.push(f(this,w));return e.all(d)},l.prototype.computeXysRadians=function(e,r,t){var a=s(this,e,r);if(0>a)return void 0;var o=0|a/this._stepSizeDays;if(o>=this._totalSamples)return void 0;var u=this._interpolationOrder,l=o-(0|u/2);0>l&&(l=0);var c=l+u;c>=this._totalSamples&&(c=this._totalSamples-1,l=c-u,0>l&&(l=0));var h=!1,d=this._samples;if(n(d[3*l])||(f(this,0|l/this._samplesPerXysFile),h=!0),n(d[3*c])||(f(this,0|c/this._samplesPerXysFile),h=!0),h)return void 0;n(t)?(t.x=0,t.y=0,t.s=0):t=new i(0,0,0);var w,m,p=a-l*this._stepSizeDays,y=this._work,v=this._denominators,g=this._coef,x=this._xTable;for(w=0;u>=w;++w)y[w]=p-x[w];for(w=0;u>=w;++w){for(g[w]=1,m=0;u>=m;++m)m!==w&&(g[w]*=y[m]);g[w]*=v[w];var b=3*(l+w);t.x+=g[w]*d[b++],t.y+=g[w]*d[b++],t.s+=g[w]*d[b]}return t},l}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./TimeConstants"],function(e,r,t,n,i,a,o,u,s,f,l,c,h,d,w,m,p){"use strict";var y={},v=new t,g=new t,x=new t;y.eastNorthUpToFixedFrame=function(e,r,n){if(!a(e))throw new o("origin is required.");if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var u=d.sign(e.z);return a(n)?(n[0]=0,n[1]=1,n[2]=0,n[3]=0,n[4]=-u,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=u,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(0,-u,0,e.x,1,0,0,e.y,0,0,u,e.z,0,0,0,1)}var s=v,l=g,c=x;return r=i(r,f.WGS84),r.geodeticSurfaceNormal(e,s),l.x=-e.y,l.y=e.x,l.z=0,t.normalize(l,l),t.cross(s,l,c),a(n)?(n[0]=l.x,n[1]=l.y,n[2]=l.z,n[3]=0,n[4]=c.x,n[5]=c.y,n[6]=c.z,n[7]=0,n[8]=s.x,n[9]=s.y,n[10]=s.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(l.x,c.x,s.x,e.x,l.y,c.y,s.y,e.y,l.z,c.z,s.z,e.z,0,0,0,1)};var b=new t,q=new t,E=new t;y.northEastDownToFixedFrame=function(e,r,n){if(!a(e))throw new o("origin is required.");if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var u=d.sign(e.z);return a(n)?(n[0]=-u,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=1,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=-u,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(-u,0,0,e.x,0,1,0,e.y,0,0,-u,e.z,0,0,0,1)}var s=b,l=q,c=E;return r=i(r,f.WGS84),r.geodeticSurfaceNormal(e,s),l.x=-e.y,l.y=e.x,l.z=0,t.normalize(l,l),t.cross(s,l,c),a(n)?(n[0]=c.x,n[1]=c.y,n[2]=c.z,n[3]=0,n[4]=l.x,n[5]=l.y,n[6]=l.z,n[7]=0,n[8]=-s.x,n[9]=-s.y,n[10]=-s.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(c.x,l.x,-s.x,e.x,c.y,l.y,-s.y,e.y,c.z,l.z,-s.z,e.z,0,0,0,1)};var S=24110.54841,T=8640184.812866,O=.093104,M=-62e-7,_=1.1772758384668e-19,P=72921158553e-15,N=d.TWO_PI/86400,I=new h;y.computeTemeToPseudoFixedMatrix=function(e,r){if(!a(e))throw new o("date is required.");I=h.addSeconds(e,-h.getTaiMinusUtc(e),I);var t,n=I.dayNumber,i=I.secondsOfDay,u=n-2451545;t=i>=43200?(u+.5)/p.DAYS_PER_JULIAN_CENTURY:(u-.5)/p.DAYS_PER_JULIAN_CENTURY;var s=S+t*(T+t*(O+t*M)),f=s*N%d.TWO_PI,l=P+_*(n-2451545.5),c=(i+.5*p.SECONDS_PER_DAY)%p.SECONDS_PER_DAY,m=f+l*c,y=Math.cos(m),v=Math.sin(m);return a(r)?(r[0]=y,r[1]=-v,r[2]=0,r[3]=v,r[4]=y,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new w(y,v,0,-v,y,0,0,0,1)},y.iau2006XysData=new l,y.earthOrientationParameters=u.NONE;var A=32.184,C=2451545;y.preloadIcrfFixed=function(r){var t=r.start.dayNumber,n=r.start.secondsOfDay+A,i=r.stop.dayNumber,a=r.stop.secondsOfDay+A,o=y.iau2006XysData.preload(t,n,i,a),u=y.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},y.computeIcrfToFixedMatrix=function(e,r){if(!a(e))throw new o("date is required.");var t=y.computeFixedToIcrfMatrix(e,r);return a(t)?w.transpose(t,r):void 0};var R=new c(0,0,0),z=new s(0,0,0,0,0,0),D=new w,L=new w;y.computeFixedToIcrfMatrix=function(e,r){if(!a(e))throw new o("date is required.");var t=y.earthOrientationParameters.compute(e,z);if(!a(t))return void 0;var n=e.dayNumber,i=e.secondsOfDay+A,u=y.iau2006XysData.computeXysRadians(n,i,R);if(!a(u))return void 0;var s=u.x+t.xPoleOffset,f=u.y+t.yPoleOffset,l=1/(1+Math.sqrt(1-s*s-f*f)),c=D;c[0]=1-l*s*s,c[3]=-l*s*f,c[6]=s,c[1]=-l*s*f,c[4]=1-l*f*f,c[7]=f,c[2]=-s,c[5]=-f,c[8]=1-l*(s*s+f*f);var m=w.fromRotationZ(-u.s,L),v=w.multiply(c,m,D),g=e.dayNumber,x=e.secondsOfDay-h.getTaiMinusUtc(e)+t.ut1MinusUtc,b=g-2451545,q=x/p.SECONDS_PER_DAY,E=.779057273264+q+.00273781191135448*(b+q);E=E%1*d.TWO_PI;var S=w.fromRotationZ(E,L),T=w.multiply(v,S,D),O=Math.cos(t.xPoleWander),M=Math.cos(t.yPoleWander),_=Math.sin(t.xPoleWander),P=Math.sin(t.yPoleWander),N=n-C+i/p.SECONDS_PER_DAY;N/=36525;var I=-47e-6*N*d.RADIANS_PER_DEGREE/3600,U=Math.cos(I),B=Math.sin(I),F=L;return F[0]=O*U,F[1]=O*B,F[2]=_,F[3]=-M*B+P*_*U,F[4]=M*U+P*_*B,F[5]=-P*O,F[6]=-P*B-M*_*U,F[7]=P*U-M*_*B,F[8]=M*O,w.multiply(T,F,r)};var U=new n;return y.pointToWindowCoordinates=function(e,t,i,u){if(!a(e))throw new o("modelViewProjectionMatrix is required.");if(!a(t))throw new o("viewportTransformation is required.");if(!a(i))throw new o("point is required.");a(u)||(u=new r);var s=U;return m.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,s),s),n.multiplyByScalar(s,1/s.w,s),m.multiplyByVector(t,s,s),r.fromCartesian4(s,u)},y}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix4","./Plane","./Ray","./Transforms"],function(e,r,t,n,i,a,o,u,s,f,l,c,h){"use strict";var d=function(e,r){if(!i(e))throw new o("origin is required.");if(r=n(r,u.WGS84),e=r.scaleToGeodeticSurface(e),!i(e))throw new o("origin must not be at the center of the ellipsoid.");var a=h.eastNorthUpToFixedFrame(e,r);this._ellipsoid=r,this._origin=e,this._xAxis=t.fromCartesian4(f.getColumn(a,0)),this._yAxis=t.fromCartesian4(f.getColumn(a,1));var s=t.fromCartesian4(f.getColumn(a,2));this._plane=l.fromPointNormal(e,s)};a(d.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}}});var w=new e;d.fromPoints=function(r,t){if(!i(r))throw new o("cartesians is required.");var n=e.fromPoints(r,w);return new d(n.center,t)};var m=new c,p=new t;d.prototype.projectPointOntoPlane=function(e,n){if(!i(e))throw new o("cartesian is required.");var a=m;a.origin=e,t.normalize(e,a.direction);var u=s.rayPlane(a,this._plane,p);if(i(u)||(t.negate(a.direction,a.direction),u=s.rayPlane(a,this._plane,p)),i(u)){var f=t.subtract(u,this._origin,u),l=t.dot(this._xAxis,f),c=t.dot(this._yAxis,f);return i(n)?(n.x=l,n.y=c,n):new r(l,c)}return void 0},d.prototype.projectPointsOntoPlane=function(e,r){if(!i(e))throw new o("cartesians is required.");i(r)||(r=[]);for(var t=0,n=e.length,a=0;n>a;a++){var u=this.projectPointOntoPlane(e[a],r[t]);i(u)&&(r[t]=u,t++)}return r.length=t,r};var y=new t;return d.prototype.projectPointsOntoEllipsoid=function(e,r){if(!i(e))throw new o("cartesians is required.");var n=e.length;i(r)?r.length=n:r=new Array(n);for(var a=this._ellipsoid,u=this._origin,s=this._xAxis,f=this._yAxis,l=y,c=0;n>c;++c){var h=e[c];t.multiplyByScalar(s,h.x,l),i(r[c])||(r[c]=new t);var d=t.add(u,l,r[c]);t.multiplyByScalar(f,h.y,l),t.add(d,l,d),a.scaleToGeocentricSurface(d,d)}return r},d}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.attributes))throw new t("options.attributes is required.");if(!r(n.primitiveType))throw new t("options.primitiveType is required.");this.attributes=n.attributes,this.indices=n.indices,this.primitiveType=n.primitiveType,this.boundingSphere=n.boundingSphere};return n.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&r(e.attributes[i])&&r(e.attributes[i].values)){var a=e.attributes[i],o=a.values.length/a.componentsPerAttribute;if(n!==o&&-1!==n)throw new t("All attribute lists must have the same number of attributes.");n=o}return n},n}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(n.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");
if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(n.values))throw new t("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,r,t,n){"use strict";var i=function(i){if(i=e(i,e.EMPTY_OBJECT),!r(i.geometry))throw new t("options.geometry is required.");this.geometry=i.geometry,this.modelMatrix=n.clone(e(i.modelMatrix,n.IDENTITY)),this.id=i.id,this.pickPrimitive=i.pickPrimitive,this.attributes=e(i.attributes,{})};return i}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=new r,a=new r,o=new r,u=function(u,s,f,l,c){if(!(t(u)&&t(s)&&t(f)&&t(l)))throw new n("point, p0, p1, and p2 are required.");t(c)||(c=new r);var h,d,w,m,p,y,v,g;t(s.z)?(h=r.subtract(f,s,i),d=r.subtract(l,s,a),w=r.subtract(u,s,o),m=r.dot(h,h),p=r.dot(h,d),y=r.dot(h,w),v=r.dot(d,d),g=r.dot(d,w)):(h=e.subtract(f,s,i),d=e.subtract(l,s,a),w=e.subtract(u,s,o),m=e.dot(h,h),p=e.dot(h,d),y=e.dot(h,w),v=e.dot(d,d),g=e.dot(d,w));var x=1/(m*v-p*p);return c.y=(v*y-p*g)*x,c.z=(m*g-p*y)*x,c.x=1-c.y-c.z,c};return u}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};n.encode=function(e,n){if(!r(e))throw new t("value is required");r(n)||(n={high:0,low:0});var i;return e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,a){if(!r(e))throw new t("cartesian is required");r(a)||(a=new n);var o=a.high,u=a.low;return n.encode(e.x,i),o.x=i.high,u.x=i.low,n.encode(e.y,i),o.y=i.high,u.y=i.low,n.encode(e.z,i),o.z=i.high,u.z=i.low,a};var a=new n;return n.writeElements=function(e,i,o){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("cartesianArray is required");if("number"!=typeof o||0>o)throw new t("index must be a number greater than or equal to 0.");n.fromCartesian(e,a);var u=a.high,s=a.low;i[o]=u.x,i[o+1]=u.y,i[o+2]=u.z,i[o+3]=s.x,i[o+4]=s.y,i[o+5]=s.z},n}),define("Core/IndexDatatype",["./defined","./DeveloperError","./Math"],function(e,r,t){"use strict";var n={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return n.getSizeInBytes=function(e){switch(e){case n.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case n.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case n.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new r("indexDatatype is required and must be a valid IndexDatatype constant.")},n.validate=function(r){return e(r)&&(r===n.UNSIGNED_BYTE||r===n.UNSIGNED_SHORT||r===n.UNSIGNED_INT)},n.createTypedArray=function(n,i){if(!e(n))throw new r("numberOfVertices is required.");return n>t.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},n}),define("Core/PrimitiveType",[],function(){"use strict";var e={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(r){return r===e.POINTS||r===e.LINES||r===e.LINE_LOOP||r===e.LINE_STRIP||r===e.TRIANGLES||r===e.TRIANGLE_STRIP||r===e.TRIANGLE_FAN}};return e}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n={};return n.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var i=n.indices,a=n.maximumIndex,o=e(n.cacheSize,24);if(!r(i))throw new t("indices is required.");var u=i.length;if(3>u||0!==u%3)throw new t("indices length must be a multiple of three.");if(0>=a)throw new t("maximumIndex must be greater than zero.");if(3>o)throw new t("cacheSize must be greater than two.");if(!r(a)){a=0;for(var s=0,f=i[s];u>s;)f>a&&(a=f),++s,f=i[s]}for(var l=[],c=0;a+1>c;c++)l[c]=0;for(var h=o+1,d=0;u>d;++d)h-l[i[d]]>o&&(l[i[d]]=h,++h);return(h-o+1)/(u/3)},n.tipsify=function(n){function i(e,r,t,n){for(;r.length>=1;){var i=r[r.length-1];if(r.splice(r.length-1,1),e[i].numLiveTriangles>0)return i}for(;n>o;){if(e[o].numLiveTriangles>0)return++o,o-1;++o}return-1}function a(e,r,t,n,a,o,u){for(var s,f=-1,l=-1,c=0;c<t.length;){var h=t[c];n[h].numLiveTriangles&&(s=0,a-n[h].timeStamp+2*n[h].numLiveTriangles<=r&&(s=a-n[h].timeStamp),(s>l||-1===l)&&(l=s,f=h)),++c}return-1===f?i(n,o,e,u):f}n=e(n,e.EMPTY_OBJECT);var o,u=n.indices,s=n.maximumIndex,f=e(n.cacheSize,24);if(!r(u))throw new t("indices is required.");var l=u.length;if(3>l||0!==l%3)throw new t("indices length must be a multiple of three.");if(0>=s)throw new t("maximumIndex must be greater than zero.");if(3>f)throw new t("cacheSize must be greater than two.");var c=0,h=0,d=u[h],w=l;if(r(s))c=s+1;else{for(;w>h;)d>c&&(c=d),++h,d=u[h];if(-1===c)return 0;++c}for(var m=[],p=0;c>p;p++)m[p]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};h=0;for(var y=0;w>h;)m[u[h]].vertexTriangles.push(y),++m[u[h]].numLiveTriangles,m[u[h+1]].vertexTriangles.push(y),++m[u[h+1]].numLiveTriangles,m[u[h+2]].vertexTriangles.push(y),++m[u[h+2]].numLiveTriangles,++y,h+=3;var v=0,g=f+1;o=1;var x,b,q=[],E=[],S=0,T=[],O=l/3,M=[];for(p=0;O>p;p++)M[p]=!1;for(var _,P;-1!==v;){q=[],b=m[v],P=b.vertexTriangles.length;for(var N=0;P>N;++N)if(y=b.vertexTriangles[N],!M[y]){M[y]=!0,h=y+y+y;for(var I=0;3>I;++I)_=u[h],q.push(_),E.push(_),T[S]=_,++S,x=m[_],--x.numLiveTriangles,g-x.timeStamp>f&&(x.timeStamp=g,++g),++h}v=a(u,f,q,m,g,E,c)}return T},n}),define("Core/GeometryPipeline",["./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,r,t,n,i,a,o,u,s,f,l,c,h,d,w,m,p,y,v,g,x,b,q){"use strict";function E(e,r,t,n,i){e[r++]=t,e[r++]=n,e[r++]=n,e[r++]=i,e[r++]=i,e[r]=t}function S(e){for(var r=e.length,t=6*(r/3),n=w.createTypedArray(r,t),i=0,a=0;r>a;a+=3,i+=6)E(n,i,e[a],e[a+1],e[a+2]);return n}function T(e){var r=e.length;if(r>=3){var t=6*(r-2),n=w.createTypedArray(r,t);E(n,0,e[0],e[1],e[2]);for(var i=6,a=3;r>a;++a,i+=6)E(n,i,e[a-1],e[a],e[a-2]);return n}return new Uint16Array}function O(e){if(e.length>0){for(var r=e.length-1,t=6*(r-1),n=w.createTypedArray(r,t),i=e[0],a=0,o=1;r>o;++o,a+=6)E(n,a,i,e[o],e[o+1]);return n}return new Uint16Array}function M(e){var r={};for(var t in e)if(e.hasOwnProperty(t)&&s(e[t])&&s(e[t].values)){var n=e[t];r[t]=new d({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return r}function _(e,r,t){for(var n in r)if(r.hasOwnProperty(n)&&s(r[n])&&s(r[n].values))for(var i=r[n],a=0;a<i.componentsPerAttribute;++a)e[n].values.push(i.values[t*i.componentsPerAttribute+a])}function P(e,r){if(s(r))for(var t=r.values,i=t.length,a=0;i>a;a+=3)n.unpack(t,a,X),g.multiplyByPoint(e,X,X),n.pack(X,t,a)}function N(e,r){if(s(r))for(var t=r.values,i=t.length,a=0;i>a;a+=3)n.unpack(t,a,X),v.multiplyByVector(e,X,X),X=n.normalize(X,X),n.pack(X,t,a)}function I(e){var r,t=e.length,n={},i=e[0].geometry.attributes;for(r in i)if(i.hasOwnProperty(r)&&s(i[r])&&s(i[r].values)){for(var a=i[r],u=a.values.length,f=!0,l=1;t>l;++l){var c=e[l].geometry.attributes[r];if(!s(c)||a.componentDatatype!==c.componentDatatype||a.componentsPerAttribute!==c.componentsPerAttribute||a.normalize!==c.normalize){f=!1;break}u+=c.values.length}f&&(n[r]=new d({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:o.createTypedArray(a.componentDatatype,u)}))}return n}function A(e){if(s(e.indices))return e;var r=h.computeNumberOfVertices(e);if(3>r)throw new f("The number of vertices must be at least three.");if(0!==r%3)throw new f("The number of vertices must be a multiple of three.");for(var t=w.createTypedArray(r,r),n=0;r>n;++n)t[n]=n;return e.indices=t,e}function C(e){var r=h.computeNumberOfVertices(e);if(3>r)throw new f("The number of vertices must be at least three.");var t=w.createTypedArray(r,3*(r-2));t[0]=1,t[1]=0,t[2]=2;for(var n=3,i=3;r>i;++i)t[n++]=i-1,t[n++]=0,t[n++]=i;return e.indices=t,e.primitiveType=b.TRIANGLES,e}function R(e){var r=h.computeNumberOfVertices(e);if(3>r)throw new f("The number of vertices must be at least 3.");var t=w.createTypedArray(r,3*(r-2));t[0]=0,t[1]=1,t[2]=2,r>3&&(t[3]=0,t[4]=2,t[5]=3);for(var n=6,i=3;r-1>i;i+=2)t[n++]=i,t[n++]=i-1,t[n++]=i+1,r>i+2&&(t[n++]=i,t[n++]=i+1,t[n++]=i+2);return e.indices=t,e.primitiveType=b.TRIANGLES,e}function z(e){if(s(e.indices))return e;var r=h.computeNumberOfVertices(e);if(2>r)throw new f("The number of vertices must be at least two.");if(0!==r%2)throw new f("The number of vertices must be a multiple of 2.");for(var t=w.createTypedArray(r,r),n=0;r>n;++n)t[n]=n;return e.indices=t,e}function D(e){var r=h.computeNumberOfVertices(e);if(2>r)throw new f("The number of vertices must be at least two.");var t=w.createTypedArray(r,2*(r-1));t[0]=0,t[1]=1;for(var n=2,i=2;r>i;++i)t[n++]=i-1,t[n++]=i;return e.indices=t,e.primitiveType=b.LINES,e}function L(e){var r=h.computeNumberOfVertices(e);if(2>r)throw new f("The number of vertices must be at least two.");var t=w.createTypedArray(r,2*r);t[0]=0,t[1]=1;for(var n=2,i=2;r>i;++i)t[n++]=i-1,t[n++]=i;return t[n++]=r-1,t[n]=0,e.indices=t,e.primitiveType=b.LINES,e}function U(e){switch(e.primitiveType){case b.TRIANGLE_FAN:return C(e);case b.TRIANGLE_STRIP:return R(e);case b.TRIANGLES:return A(e);case b.LINE_STRIP:return D(e);case b.LINE_LOOP:return L(e);case b.LINES:return z(e)}return e}function B(e,r){Math.abs(e.y)<y.EPSILON11&&(e.y=r?-y.EPSILON11:y.EPSILON11)}function F(e,r,t,i){n.add(e,n.multiplyByScalar(n.subtract(r,e,or),e.y/(e.y-r.y),or),t),n.clone(t,i),B(t,!0),B(i,!1)}function W(e,r,t){if(e.x>=0||r.x>=0||t.x>=0)return void 0;var n=e.y<0,i=r.y<0,a=t.y<0;B(e,n),B(r,i),B(t,a);var o=0;o+=n?1:0,o+=i?1:0,o+=a?1:0;var u=cr.indices;1===o?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(F(e,r,ur,fr),F(e,t,sr,lr),u[0]=0,u[3]=1,u[4]=2,u[6]=1):i?(F(r,t,ur,fr),F(r,e,sr,lr),u[0]=1,u[3]=2,u[4]=0,u[6]=2):a&&(F(t,e,ur,fr),F(t,r,sr,lr),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===o&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?i?a||(F(t,e,ur,fr),F(t,r,sr,lr),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(F(r,t,ur,fr),F(r,e,sr,lr),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(F(e,r,ur,fr),F(e,t,sr,lr),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=cr.positions;return s[0]=e,s[1]=r,s[2]=t,cr.length=3,(1===o||2===o)&&(s[3]=ur,s[4]=sr,s[5]=fr,s[6]=lr,cr.length=7),cr}function G(r,i,a,o,u,f,l,c){if(s(u)||s(f)||s(l)||s(c)){var h,d,w,m,p,y,v,g,x,b,q,E,S=o.positions,T=S[0],O=S[1],M=S[2],_=mr,P=pr,N=yr,I=hr,A=dr,C=wr;s(u)&&(h=n.fromArray(u,3*r),d=n.fromArray(u,3*i),w=n.fromArray(u,3*a)),s(f)&&(m=n.fromArray(f,3*r),p=n.fromArray(f,3*i),y=n.fromArray(f,3*a)),s(l)&&(v=n.fromArray(l,3*r),g=n.fromArray(l,3*i),x=n.fromArray(l,3*a)),s(c)&&(b=t.fromArray(c,2*r),q=t.fromArray(c,2*i),E=t.fromArray(c,2*a));for(var R=3;R<S.length;++R){var z=S[R],D=e(z,T,O,M);if(s(u)){_=n.multiplyByScalar(h,D.x,_),P=n.multiplyByScalar(d,D.y,P),N=n.multiplyByScalar(w,D.z,N);var L=n.add(_,P,vr);n.add(L,N,L),n.normalize(L,L),u.push(L.x,L.y,L.z)}if(s(f)){_=n.multiplyByScalar(m,D.x,_),P=n.multiplyByScalar(p,D.y,P),N=n.multiplyByScalar(y,D.z,N);var U=n.add(_,P,vr);n.add(U,N,U),n.normalize(U,U),f.push(U.x,U.y,U.z)}if(s(l)){_=n.multiplyByScalar(v,D.x,_),P=n.multiplyByScalar(g,D.y,P),N=n.multiplyByScalar(x,D.z,N);var B=n.add(_,P,vr);n.add(B,N,B),n.normalize(B,B),l.push(B.x,B.y,B.z)}if(s(c)){I=t.multiplyByScalar(b,D.x,I),A=t.multiplyByScalar(q,D.y,A),C=t.multiplyByScalar(E,D.z,C);var F=t.add(I,A,I);t.add(F,C,F),c.push(F.x,F.y)}}}}function V(e){for(var r=e.attributes,t=r.position.values,i=s(r.normal)?r.normal.values:void 0,a=s(r.binormal)?r.binormal.values:void 0,u=s(r.tangent)?r.tangent.values:void 0,f=s(r.st)?r.st.values:void 0,l=e.indices,c=Array.prototype.slice.call(t,0),d=s(i)?Array.prototype.slice.call(i,0):void 0,m=s(a)?Array.prototype.slice.call(a,0):void 0,p=s(u)?Array.prototype.slice.call(u,0):void 0,y=s(f)?Array.prototype.slice.call(f,0):void 0,v=[],g=l.length,x=0;g>x;x+=3){var b=l[x],q=l[x+1],E=l[x+2],S=n.fromArray(t,3*b),T=n.fromArray(t,3*q),O=n.fromArray(t,3*E),M=W(S,T,O);if(s(M))if(c[3*b+1]=M.positions[0].y,c[3*q+1]=M.positions[1].y,c[3*E+1]=M.positions[2].y,M.length>3){for(var _=c.length/3,P=0;P<M.indices.length;++P){var N=M.indices[P];3>N?v.push(l[x+N]):v.push(N-3+_)}for(var I=3;I<M.positions.length;++I){var A=M.positions[I];c.push(A.x,A.y,A.z)}G(b,q,E,M,d,m,p,y)}else v.push(b,q,E);else v.push(b,q,E)}e.attributes.position.values=new Float64Array(c),s(d)&&(r.normal.values=o.createTypedArray(r.normal.componentDatatype,d)),s(m)&&(r.binormal.values=o.createTypedArray(r.binormal.componentDatatype,m)),s(p)&&(r.tangent.values=o.createTypedArray(r.tangent.componentDatatype,p)),s(y)&&(r.st.values=o.createTypedArray(r.st.componentDatatype,y));var C=h.computeNumberOfVertices(e);e.indices=w.createTypedArray(C,v)}function Y(e){for(var r=e.attributes,t=r.position.values,i=e.indices,a=Array.prototype.slice.call(t,0),o=[],u=x.fromPointNormal(n.ZERO,n.UNIT_Y),f=i.length,l=0;f>l;l+=2){var c=i[l],d=i[l+1],m=n.fromArray(t,3*c),v=n.fromArray(t,3*d);if(Math.abs(m.y)<y.EPSILON6&&(m.y=m.y<0?-y.EPSILON6:y.EPSILON6,a[3*c+1]=m.y),Math.abs(v.y)<y.EPSILON6&&(v.y=v.y<0?-y.EPSILON6:y.EPSILON6,a[3*d+1]=v.y),o.push(c),m.x<0||v.x<0){var g=p.lineSegmentPlane(m,v,u);if(s(g)){var b=n.multiplyByScalar(n.UNIT_Y,5*y.EPSILON9,gr);m.y<0&&n.negate(b,b);var q=a.length/3;o.push(q,q+1);var E=n.add(g,b,xr);a.push(E.x,E.y,E.z),n.negate(b,b),n.add(g,b,E),a.push(E.x,E.y,E.z)}}o.push(d)}e.attributes.position.values=new Float64Array(a);var S=h.computeNumberOfVertices(e);e.indices=w.createTypedArray(S,o)}var j={};j.toWireframe=function(e){if(!s(e))throw new f("geometry is required.");var r=e.indices;if(s(r)){switch(e.primitiveType){case b.TRIANGLES:e.indices=S(r);break;case b.TRIANGLE_STRIP:e.indices=T(r);break;case b.TRIANGLE_FAN:e.indices=O(r);break;default:throw new f("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=b.LINES}return e},j.createLineSegmentsForVectors=function(e,t,n){if(t=u(t,"normal"),!s(e))throw new f("geometry is required.");if(!s(e.attributes.position))throw new f("geometry.attributes.position is required.");if(!s(e.attributes[t]))throw new f("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+t+".");n=u(n,1e4);for(var i=e.attributes.position.values,a=e.attributes[t].values,l=i.length,c=new Float64Array(2*l),w=0,m=0;l>m;m+=3)c[w++]=i[m],c[w++]=i[m+1],c[w++]=i[m+2],c[w++]=i[m]+a[m]*n,c[w++]=i[m+1]+a[m+1]*n,c[w++]=i[m+2]+a[m+2]*n;var p,y=e.boundingSphere;return s(y)&&(p=new r(y.center,y.radius+n)),new h({attributes:{position:new d({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:c})},primitiveType:b.LINES,boundingSphere:p})},j.createAttributeLocations=function(e){if(!s(e))throw new f("geometry is required.");var r,t=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent"],n=e.attributes,i={},a=0,o=t.length;for(r=0;o>r;++r){var u=t[r];s(n[u])&&(i[u]=a++)}for(var l in n)n.hasOwnProperty(l)&&!s(i[l])&&(i[l]=a++);return i},j.reorderForPreVertexCache=function(e){if(!s(e))throw new f("geometry is required.");var r=h.computeNumberOfVertices(e),t=e.indices;if(s(t)){for(var n=new Int32Array(r),i=0;r>i;i++)n[i]=-1;for(var a,u=t,l=u.length,c=w.createTypedArray(r,l),d=0,m=0,p=0;l>d;)a=n[u[d]],-1!==a?c[m]=a:(a=u[d],n[a]=p,c[m]=p,++p),++d,++m;e.indices=c;var y=e.attributes;for(var v in y)if(y.hasOwnProperty(v)&&s(y[v])&&s(y[v].values)){for(var g=y[v],x=g.values,b=0,q=g.componentsPerAttribute,E=o.createTypedArray(g.componentDatatype,p*q);r>b;){var S=n[b];if(-1!==S)for(i=0;q>i;i++)E[q*S+i]=x[q*b+i];++b}g.values=E}}return e},j.reorderForPostVertexCache=function(e,r){if(!s(e))throw new f("geometry is required.");var t=e.indices;if(e.primitiveType===b.TRIANGLES&&s(t)){for(var n=t.length,i=0,a=0;n>a;a++)t[a]>i&&(i=t[a]);e.indices=q.tipsify({indices:t,maximumIndex:i,cacheSize:r})}return e},j.fitToUnsignedShortIndices=function(e){if(!s(e))throw new f("geometry is required.");if(s(e.indices)&&e.primitiveType!==b.TRIANGLES&&e.primitiveType!==b.LINES&&e.primitiveType!==b.POINTS)throw new f("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var r=[],t=h.computeNumberOfVertices(e);if(s(e.indices)&&t>y.SIXTY_FOUR_KILOBYTES){var n,i=[],a=[],o=0,u=M(e.attributes),l=e.indices,c=l.length;e.primitiveType===b.TRIANGLES?n=3:e.primitiveType===b.LINES?n=2:e.primitiveType===b.POINTS&&(n=1);for(var d=0;c>d;d+=n){for(var w=0;n>w;++w){var m=l[d+w],p=i[m];s(p)||(p=o++,i[m]=p,_(u,e.attributes,m)),a.push(p)}o+n>y.SIXTY_FOUR_KILOBYTES&&(r.push(new h({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere})),i=[],a=[],o=0,u=M(e.attributes))}0!==a.length&&r.push(new h({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere}))}else r.push(e);return r};var k=new n,H=new a;j.projectTo2D=function(e,r,t,i,a){if(!s(e))throw new f("geometry is required.");if(!s(r))throw new f("attributeName is required.");if(!s(t))throw new f("attributeName3D is required.");if(!s(i))throw new f("attributeName2D is required.");if(!s(e.attributes[r]))throw new f("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==o.DOUBLE)throw new f("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");var u=e.attributes[r];a=s(a)?a:new c;for(var l=a.ellipsoid,h=u.values,w=new Float64Array(h.length),m=0,p=0;p<h.length;p+=3){var y=n.fromArray(h,p,k),v=l.cartesianToCartographic(y,H);if(!s(v))throw new f("Could not project point ("+y.x+", "+y.y+", "+y.z+") to 2D.");var g=a.project(v,k);w[m++]=g.x,w[m++]=g.y,w[m++]=g.z}return e.attributes[t]=u,e.attributes[i]=new d({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:w}),delete e.attributes[r],e};var Z={high:0,low:0};j.encodeAttribute=function(e,r,t,n){if(!s(e))throw new f("geometry is required.");if(!s(r))throw new f("attributeName is required.");if(!s(t))throw new f("attributeHighName is required.");if(!s(n))throw new f("attributeLowName is required.");if(!s(e.attributes[r]))throw new f("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==o.DOUBLE)throw new f("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var i=e.attributes[r],a=i.values,u=a.length,c=new Float32Array(u),h=new Float32Array(u),w=0;u>w;++w)l.encode(a[w],Z),c[w]=Z.high,h[w]=Z.low;var m=i.componentsPerAttribute;return e.attributes[t]=new d({componentDatatype:o.FLOAT,componentsPerAttribute:m,values:c}),e.attributes[n]=new d({componentDatatype:o.FLOAT,componentsPerAttribute:m,values:h}),delete e.attributes[r],e};var X=new n,J=new g,K=new v;j.transformToWorldCoordinates=function(e){if(!s(e))throw new f("instance is required.");var t=e.modelMatrix;if(g.equals(t,g.IDENTITY))return e;var n=e.geometry.attributes;P(t,n.position),P(t,n.prevPosition),P(t,n.nextPosition),(s(n.normal)||s(n.binormal)||s(n.tangent))&&(g.inverse(t,J),g.transpose(J,J),g.getRotation(J,K),N(K,n.normal),N(K,n.binormal),N(K,n.tangent));var i=e.geometry.boundingSphere;return s(i)&&(e.geometry.boundingSphere=r.transform(i,t,i)),e.modelMatrix=g.clone(g.IDENTITY),e};var Q=new n;j.combine=function(e){if(!s(e)||e.length<1)throw new f("instances is required and must have length greater than zero.");var t,i,a,o,u=e.length,l=e[0].modelMatrix,c=s(e[0].geometry.indices),d=e[0].geometry.primitiveType;for(i=1;u>i;++i){if(!g.equals(e[i].modelMatrix,l))throw new f("All instances must have the same modelMatrix.");if(s(e[i].geometry.indices)!==c)throw new f("All instance geometries must have an indices or not have one.");if(e[i].geometry.primitiveType!==d)throw new f("All instance geometries must have the same primitiveType.")}var m,p,y,v=I(e);for(t in v)if(v.hasOwnProperty(t))for(m=v[t].values,o=0,i=0;u>i;++i)for(p=e[i].geometry.attributes[t].values,y=p.length,a=0;y>a;++a)m[o++]=p[a];var x;if(c){var q=0;for(i=0;u>i;++i)q+=e[i].geometry.indices.length;var E=h.computeNumberOfVertices(new h({attributes:v,primitiveType:b.POINTS})),S=w.createTypedArray(E,q),T=0,O=0;for(i=0;u>i;++i){var M=e[i].geometry.indices,_=M.length;for(o=0;_>o;++o)S[T++]=O+M[o];O+=h.computeNumberOfVertices(e[i].geometry)}x=S}var P,N=new n,A=0;for(i=0;u>i;++i){if(P=e[i].geometry.boundingSphere,!s(P)){N=void 0;break}n.add(P.center,N,N)}if(s(N))for(n.divideByScalar(N,u,N),i=0;u>i;++i){P=e[i].geometry.boundingSphere;var C=n.magnitude(n.subtract(P.center,N,Q))+P.radius;C>A&&(A=C)}return new h({attributes:v,indices:x,primitiveType:d,boundingSphere:s(N)?new r(N,A):void 0})};var $=new n,er=new n,rr=new n,tr=new n;j.computeNormal=function(e){if(!s(e))throw new f("geometry is required.");if(!s(e.attributes.position)||!s(e.attributes.position.values))throw new f("geometry.attributes.position.values is required.");if(!s(e.indices))throw new f("geometry.indices is required.");if(e.indices.length<2||0!==e.indices.length%3)throw new f("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==b.TRIANGLES)throw new f("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var r=e.indices,t=e.attributes,i=t.position.values,a=t.position.values.length/3,u=r.length,l=new Array(a),c=new Array(u/3),h=new Array(u),w=0;a>w;w++)l[w]={indexOffset:0,count:0,currentCount:0};var m=0;for(w=0;u>w;w+=3){var p=r[w],y=r[w+1],v=r[w+2],g=3*p,x=3*y,q=3*v;er.x=i[g],er.y=i[g+1],er.z=i[g+2],rr.x=i[x],rr.y=i[x+1],rr.z=i[x+2],tr.x=i[q],tr.y=i[q+1],tr.z=i[q+2],l[p].count++,l[y].count++,l[v].count++,n.subtract(rr,er,rr),n.subtract(tr,er,tr),c[m]=n.cross(rr,tr,new n),m++}var E=0;for(w=0;a>w;w++)l[w].indexOffset+=E,E+=l[w].count;m=0;var S;for(w=0;u>w;w+=3){S=l[r[w]];var T=S.indexOffset+S.currentCount;h[T]=m,S.currentCount++,S=l[r[w+1]],T=S.indexOffset+S.currentCount,h[T]=m,S.currentCount++,S=l[r[w+2]],T=S.indexOffset+S.currentCount,h[T]=m,S.currentCount++,m++}var O=new Float32Array(3*a);for(w=0;a>w;w++){var M=3*w;if(S=l[w],S.count>0){for(n.clone(n.ZERO,$),m=0;m<S.count;m++)n.add($,c[h[S.indexOffset+m]],$);n.normalize($,$),O[M]=$.x,O[M+1]=$.y,O[M+2]=$.z}else O[M]=0,O[M+1]=0,O[M+2]=1}return e.attributes.normal=new d({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:O}),e};var nr=new n,ir=new n,ar=new n;j.computeBinormalAndTangent=function(e){if(!s(e))throw new f("geometry is required.");var r=e.attributes,t=e.indices;if(!s(r.position)||!s(r.position.values))throw new f("geometry.attributes.position.values is required.");if(!s(r.normal)||!s(r.normal.values))throw new f("geometry.attributes.normal.values is required.");if(!s(r.st)||!s(r.st.values))throw new f("geometry.attributes.st.values is required.");if(!s(t))throw new f("geometry.indices is required.");if(t.length<2||0!==t.length%3)throw new f("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==b.TRIANGLES)throw new f("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var i=e.attributes.position.values,a=e.attributes.normal.values,u=e.attributes.st.values,l=e.attributes.position.values.length/3,c=t.length,h=new Array(3*l),w=0;w<h.length;w++)h[w]=0;var m,p,y;for(w=0;c>w;w+=3){var v=t[w],g=t[w+1],x=t[w+2];m=3*v,p=3*g,y=3*x;var q=2*v,E=2*g,S=2*x,T=i[m],O=i[m+1],M=i[m+2],_=u[q],P=u[q+1],N=u[E+1]-P,I=u[S+1]-P,A=1/((u[E]-_)*I-(u[S]-_)*N),C=(I*(i[p]-T)-N*(i[y]-T))*A,R=(I*(i[p+1]-O)-N*(i[y+1]-O))*A,z=(I*(i[p+2]-M)-N*(i[y+2]-M))*A;h[m]+=C,h[m+1]+=R,h[m+2]+=z,h[p]+=C,h[p+1]+=R,h[p+2]+=z,h[y]+=C,h[y+1]+=R,h[y+2]+=z}var D=new Float32Array(3*l),L=new Float32Array(3*l);for(w=0;l>w;w++){m=3*w,p=m+1,y=m+2;var U=n.fromArray(a,m,nr),B=n.fromArray(h,m,ar),F=n.dot(U,B);n.multiplyByScalar(U,F,ir),n.normalize(n.subtract(B,ir,B),B),L[m]=B.x,L[p]=B.y,L[y]=B.z,n.normalize(n.cross(U,B,B),B),D[m]=B.x,D[p]=B.y,D[y]=B.z}return e.attributes.tangent=new d({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:L}),e.attributes.binormal=new d({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:D}),e};var or=new n,ur=new n,sr=new n,fr=new n,lr=new n,cr={positions:new Array(7),indices:new Array(9)},hr=new t,dr=new t,wr=new t,mr=new n,pr=new n,yr=new n,vr=new n,gr=new n,xr=new n;return j.wrapLongitude=function(e){if(!s(e))throw new f("geometry is required.");var t=e.boundingSphere;if(s(t)){var n=t.center.x-t.radius;if(n>0||r.intersect(t,i.UNIT_Y)!==m.INTERSECTING)return e}return U(e),e.primitiveType===b.TRIANGLES?V(e):e.primitiveType===b.LINES&&Y(e),e},j}),define("Core/PolygonGeometryLibrary",["./Cartesian3","./defaultValue","./defined","./Ellipsoid"],function(e,r,t,n){"use strict";function i(r,t,n,i){return e.subtract(t,r,o),e.multiplyByScalar(o,n/i,o),e.add(r,o,o),[o.x,o.y,o.z]}var a={},o=new e;a.subdivideLine=function(r,t,n){var a=e.distance(r,t),o=e.angleBetween(r,t),u=o/n,s=Math.ceil(Math.log(u)/Math.log(2));1>s&&(s=0);var f=Math.pow(2,s),l=a/f,c=new Array(3*f),h=0;c[h++]=r.x,c[h++]=r.y,c[h++]=r.z;for(var d=1;f>d;d++){var w=i(r,t,d*l,a);c[h++]=w[0],c[h++]=w[1],c[h++]=w[2]}return c};var u=new e,s=new e,f=new e,l=new e;return a.scaleToGeodeticHeightExtruded=function(i,a,o,c,h){c=r(c,n.WGS84);var d=u,w=s,m=f,p=l;if(t(i)&&t(i.attributes)&&t(i.attributes.position))for(var y=i.attributes.position.values,v=y.length/2,g=0;v>g;g+=3)e.fromArray(y,g,m),c.geodeticSurfaceNormal(m,d),p=c.scaleToGeodeticSurface(m,p),w=e.multiplyByScalar(d,o,w),w=e.add(p,w,w),y[g+v]=w.x,y[g+1+v]=w.y,y[g+2+v]=w.z,h&&(p=e.clone(m,p)),w=e.multiplyByScalar(d,a,w),w=e.add(p,w,w),y[g]=w.x,y[g+1]=w.y,y[g+2]=w.z;return i},a}),define("Core/pointInsideTriangle",["./barycentricCoordinates","./Cartesian3"],function(e,r){"use strict";var t=new r,n=function(r,n,i,a){return e(r,n,i,a,t),t.x>0&&t.y>0&&t.z>0};return n}),define("Core/Queue",[],function(){"use strict";var e=function(){this._array=[],this._offset=0,this.length=0};return e.prototype.enqueue=function(e){this._array.push(e),this.length++},e.prototype.dequeue=function(){if(0===this.length)return void 0;var e=this._array,r=this._offset,t=e[r];return e[r]=void 0,r++,r>10&&2*r>e.length&&(this._array=e.slice(r),r=0),this._offset=r,this.length--,t},e.prototype.contains=function(e){return-1!==this._array.indexOf(e)},e.prototype.clear=function(){this._array.length=this._offset=this.length=0},e.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},e}),define("Core/WindingOrder",[],function(){"use strict";var e={CLOCKWISE:2304,COUNTER_CLOCKWISE:2305,validate:function(r){return r===e.CLOCKWISE||r===e.COUNTER_CLOCKWISE}};return e}),define("Core/PolygonPipeline",["./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./Math","./pointInsideTriangle","./PrimitiveType","./Queue","./WindingOrder"],function(e,r,t,n,i,a,o,u,s,f,l,c,h,d,w){"use strict";function m(r,t,n){var i=e.subtract(t,r,U),a=e.subtract(n,t,B);return i.x*a.y-i.y*a.x>=0}function p(e){for(var r=e[0].x,t=0,n=0;n<e.length;n++)e[n].x>r&&(r=e[n].x,t=n);return t}function y(e){for(var r=e[0][0].x,t=0,n=0;n<e.length;n++){var i=e[n][p(e[n])].x;i>r&&(r=i,t=n)}return t}function v(e){for(var r=[],t=0;t<e.length;t++){var n=e[(t-1+e.length)%e.length],i=e[t],a=e[(t+1)%e.length];m(n,i,a)||r.push(i)}return r}function g(r,t){for(var n=0;n<r.length;n++)if(e.equals(t,r[n]))return n;return-1}function x(t,i,a){a=n(a,[]);var o=Number.MAX_VALUE,u=p(i),s=new e(i[u].x,t.y);a.push(u),a.push((u+1)%i.length);for(var f=i[0].x,l=f,c=1;c<i.length;++c)i[c].x<f?f=i[c].x:i[c].x>l&&(l=i[c].x);l+=l-f;var h=new r(l,t.y,0);for(c=0;c<i.length;c++){var d=i[c],w=i[(c+1)%i.length];if((d.x>=t.x||w.x>=t.x)&&(d.y>=t.y&&w.y<=t.y||d.y<=t.y&&w.y>=t.y)){var m=(w.y-d.y)*(h.x-t.x)-(w.x-d.x)*(h.y-t.y);if(0!==m){m=1/m;var y=((w.x-d.x)*(t.y-d.y)-(w.y-d.y)*(t.x-d.x))*m,v=((h.x-t.x)*(t.y-d.y)-(h.y-t.y)*(t.x-d.x))*m;if(y>=0&&1>=y&&v>=0&&1>=v){var g=new e(t.x+y*(h.x-t.x),t.y+y*(h.y-t.y)),x=e.subtract(g,t,F);m=e.magnitudeSquared(x),o>m&&(s=g,o=m,a[0]=c,a[1]=(c+1)%i.length)}}}}return s}function b(r,t){var n=y(t),i=t[n],a=p(i),o=i[a],u=[],s=x(o,r,u),f=g(r,s);if(-1!==f)return f;var h=e.magnitudeSquared(e.subtract(r[u[0]],o,W)),d=e.magnitudeSquared(e.subtract(r[u[1]],o,W)),w=d>h?r[u[0]]:r[u[1]],m=v(r),b=m.indexOf(w);-1!==b&&m.splice(b,1);for(var q=[],E=0;E<m.length;E++){var S=m[E];c(S,o,s,w)&&q.push(S)}var T=Number.MAX_VALUE;if(q.length>0){var O=e.fromElements(1,0,W);for(E=0;E<q.length;E++){var M=e.subtract(q[E],o,G),_=e.magnitude(O)*e.magnitudeSquared(M);if(0!==_){var P=Math.abs(l.acosClamped(e.dot(O,M)/_));T>P&&(T=P,w=q[E])}}}return r.indexOf(w)}function q(e,t,n){for(var i=ur.computeWindingOrder2D(e),a=0;a<t.length;a++){var o=t[a];r.equals(o[0],o[o.length-1])||o.push(o[0]);var s=ur.computeWindingOrder2D(o);s===i&&o.reverse()}var f=u.fromPoints(e,n),l=f.projectPointsOntoPlane(e),c=[];for(a=0;a<t.length;a++)c.push(f.projectPointsOntoPlane(t[a]));var h=b(l,c),d=y(c),w=p(c[d]),m=t[d],v=[];for(a=0;a<e.length;a++)v.push(e[a]);var g,x=[];if(0!==w)for(g=0;g<=m.length;g++){var q=(g+w)%m.length;0!==q&&x.push(m[q])}else for(g=0;g<m.length;g++)x.push(m[(g+w)%m.length]);var E=v.lastIndexOf(e[h]);x.push(e[E]);var S=v.slice(0,E+1),T=v.slice(E+1);return v=S.concat(x,T),t.splice(d,1),v}function E(e){var r="0."+Math.sin(V).toString().substr(5);V+=.2;var t=Math.floor(r*e);return t===e&&t--,t}function S(r,t,n){return T(r,t,n)&&T(t,r,n)&&!R(n[r].position,n[t].position,n)&&!e.equals(n[r].position,n[t].position)}function T(r,t,n){_(r,n);var i=n[r],a=n[t],o=M(r,n,Y),u=M(r,n,j),s=e.subtract(n[o].position,i.position,k),f=e.subtract(n[u].position,i.position,H),l=e.subtract(a.position,i.position,Z);return P(s,l)?O(s,l):P(f,l)?O(f,l):N(s,f)?C(s,f,l)?!0:!1:I(s,f)?A(s,f,l)?!1:!0:void 0}function O(r,t){return e.magnitude(t)<e.magnitude(r)}function M(e,r,t){var n=e+t;return 0>n&&(n=r.length-1),n===r.length&&(n=0),_(n,r),n}function _(r,t){var n=r-1,i=r+1;0>n&&(n=t.length-1),i===t.length&&(i=0);var o=e.subtract(t[n].position,t[r].position,X),u=e.subtract(t[i].position,t[r].position,J);if(P(o,u)){var s=new a("Superfluous vertex found.");throw s.vertexIndex=r,s}}function P(e,t){return 0===r.cross(e,t,K).z}function N(e,t){return r.cross(e,t,Q).z<0}function I(e,t){return r.cross(e,t,$).z>0}function A(e,t,n){return r.cross(e,n,er).z>0&&r.cross(n,t,er).z>0}function C(e,t,n){return r.cross(e,n,rr).z<0&&r.cross(n,t,rr).z<0}function R(r,t,n){for(var i=0;i<n.length;i++){var a,o=n[i].position;if(a=i<n.length-1?n[i+1].position:n[0].position,!(e.equals(r,o)||e.equals(t,a)||e.equals(r,a)||e.equals(t,o))){var u=(t.y-r.y)/(t.x-r.x),s=(a.y-o.y)/(a.x-o.x);if(!(u===s||isNaN(u)&&isNaN(s))){var f;f=isNaN(u)?r.x:isNaN(s)?o.x:(r.y-o.y-u*r.x+s*o.x)/(s-u);var l=u*f+r.y-u*r.x,c=e.fromElements(f,l,tr);if(!(e.equals(c,r)||e.equals(c,t)||e.equals(c,o)||e.equals(c,a))){var h=D(f,r.x,t.x)&&D(l,r.y,t.y)&&D(f,o.x,a.x)&&D(l,o.y,a.y);if(h)return!0}}}}return!1}function z(r){var t=r[0].position,n=r[1].position,i=r[2].position,a=e.subtract(n,t,nr),o=e.subtract(i,t,ir);return P(a,o)}function D(e,r,t){return(e>r||e>t)&&(r>e||t>e)||r===t&&r===e}function L(e){var r=e.length;if(3===r)return z(e)?[]:[e[0].index,e[1].index,e[2].index];if(e.length<3)throw new a("Invalid polygon: must have at least three vertices.");
for(var t=!1,n=0;!t;){var i=10*e.length;if(n>i)return[];n++;for(var o=E(e.length),u=o+1;Math.abs(o-u)<2||Math.abs(o-u)>e.length-2;)u=E(e.length);if(o>u){var s=o;o=u,u=s}try{if(S(o,u,e)){var f=e.splice(o,u-o+1,e[o],e[u]);return L(e).concat(L(f))}}catch(l){if(l.hasOwnProperty("vertexIndex"))return e.splice(l.vertexIndex,1),L(e);throw l}}}var U=new e,B=new e,F=new e,W=new e(1,0),G=new e,V=0,Y=-1,j=1,k=new r,H=new r,Z=new r,X=new r,J=new r,K=new r,Q=new r,$=new r,er=new r,rr=new r,tr=new e,nr=new r,ir=new r,ar=new r,or=new r,ur={};return ur.removeDuplicates=function(e){if(!i(e))throw new a("positions is required.");if(e.length<3)throw new a("At least three positions are required.");for(var t=e.length,n=[],o=t-1,u=0;t>u;o=u++){var s=e[o],f=e[u];r.equals(s,f)||n.push(f)}return n},ur.computeArea2D=function(e){if(!i(e))throw new a("positions is required.");if(e.length<3)throw new a("At least three positions are required.");for(var r=e.length,t=0,n=r-1,o=0;r>o;n=o++){var u=e[n],s=e[o];t+=u.x*s.y-s.x*u.y}return.5*t},ur.computeWindingOrder2D=function(e){var r=ur.computeArea2D(e);return r>0?w.COUNTER_CLOCKWISE:w.CLOCKWISE},ur.triangulate=function(e){if(!i(e))throw new a("positions is required.");if(e.length<3)throw new a("At least three positions are required.");for(var r=e.length,t=[],n=0;r>n;++n)t[n]={position:e[n],index:n};return L(t)},ur.resetSeed=function(e){V=n(e,0)},ur.computeSubdivision=function(e,o,u){if(u=n(u,l.RADIANS_PER_DEGREE),!i(e))throw new a("positions is required.");if(!i(o))throw new a("indices is required.");if(o.length<3)throw new a("At least three indices are required.");if(0!==o.length%3)throw new a("The number of indices must be divisable by three.");if(0>=u)throw new a("granularity must be greater than zero.");for(var c=new d,w=o.length,m=0;w>m;m+=3)c.enqueue({i0:o[m],i1:o[m+1],i2:o[m+2]});for(var p,y=e.slice(0),v=[],g={};c.length>0;){var x,b,q=c.dequeue(),E=y[q.i0],S=y[q.i1],T=y[q.i2],O=r.angleBetween(E,S),M=r.angleBetween(S,T),_=r.angleBetween(T,E),P=Math.max(O,Math.max(M,_));P>u?O===P?(x=Math.min(q.i0,q.i1).toString()+" "+Math.max(q.i0,q.i1).toString(),p=g[x],p||(b=r.add(E,S,new r),r.multiplyByScalar(b,.5,b),y.push(b),p=y.length-1,g[x]=p),c.enqueue({i0:q.i0,i1:p,i2:q.i2}),c.enqueue({i0:p,i1:q.i1,i2:q.i2})):M===P?(x=Math.min(q.i1,q.i2).toString()+" "+Math.max(q.i1,q.i2).toString(),p=g[x],p||(b=r.add(S,T,new r),r.multiplyByScalar(b,.5,b),y.push(b),p=y.length-1,g[x]=p),c.enqueue({i0:q.i1,i1:p,i2:q.i0}),c.enqueue({i0:p,i1:q.i2,i2:q.i0})):_===P&&(x=Math.min(q.i2,q.i0).toString()+" "+Math.max(q.i2,q.i0).toString(),p=g[x],p||(b=r.add(T,E,new r),r.multiplyByScalar(b,.5,b),y.push(b),p=y.length-1,g[x]=p),c.enqueue({i0:q.i2,i1:p,i2:q.i1}),c.enqueue({i0:p,i1:q.i0,i2:q.i1})):(v.push(q.i0),v.push(q.i1),v.push(q.i2))}var N=y.length,I=new Array(3*N),A=0;for(p=0;N>p;p++){var C=y[p];I[A++]=C.x,I[A++]=C.y,I[A++]=C.z}return new s({attributes:{position:new f({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:I})},indices:v,primitiveType:h.TRIANGLES})},ur.scaleToGeodeticHeight=function(e,t,a,u){a=n(a,o.WGS84);var s=ar,f=or;if(t=n(t,0),u=n(u,!0),i(e)&&i(e.attributes)&&i(e.attributes.position))for(var l=e.attributes.position.values,c=l.length,h=0;c>h;h+=3)r.fromArray(l,h,f),u&&(f=a.scaleToGeodeticSurface(f,f)),s=a.geodeticSurfaceNormal(f,s),r.multiplyByScalar(s,t,s),r.add(f,s,f),l[h]=f.x,l[h+1]=f.y,l[h+2]=f.z;return e},ur.eliminateHoles=function(e,t,u){if(!i(e))throw new a("outerRing is required.");if(0===e.length)throw new a("outerRing must not be empty.");if(!i(t))throw new a("innerRings is required.");u=n(u,o.WGS84);for(var s=[],f=0;f<t.length;f++){for(var l=[],c=0;c<t[f].length;c++)l.push(r.clone(t[f][c]));s.push(l)}for(var h=e;s.length>0;)h=q(h,s,u);return h},ur}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,r,t,n,i,a,o,u){"use strict";var s=function(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)},f=new e;s.fromAxisAngle=function(r,i,a){if(!t(r))throw new n("axis is required.");if("number"!=typeof i)throw new n("angle is required and must be a number.");var o=i/2,u=Math.sin(o);f=e.normalize(r,f);var l=f.x*u,c=f.y*u,h=f.z*u,d=Math.cos(o);return t(a)?(a.x=l,a.y=c,a.z=h,a.w=d,a):new s(l,c,h,d)};var l=[1,2,0],c=new Array(3);s.fromRotationMatrix=function(e,r){if(!t(e))throw new n("matrix is required.");var i,a,o,f,h,d=e[u.COLUMN0ROW0],w=e[u.COLUMN1ROW1],m=e[u.COLUMN2ROW2],p=d+w+m;if(p>0)i=Math.sqrt(p+1),h=.5*i,i=.5/i,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*i,o=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*i,f=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*i;else{var y=l,v=0;w>d&&(v=1),m>d&&m>w&&(v=2);var g=y[v],x=y[g];i=Math.sqrt(e[u.getElementIndex(v,v)]-e[u.getElementIndex(g,g)]-e[u.getElementIndex(x,x)]+1);var b=c;b[v]=.5*i,i=.5/i,h=(e[u.getElementIndex(x,g)]-e[u.getElementIndex(g,x)])*i,b[g]=(e[u.getElementIndex(g,v)]+e[u.getElementIndex(v,g)])*i,b[x]=(e[u.getElementIndex(x,v)]+e[u.getElementIndex(v,x)])*i,a=-b[0],o=-b[1],f=-b[2]}return t(r)?(r.x=a,r.y=o,r.z=f,r.w=h,r):new s(a,o,f,h)};var h=new e,d=new e,w=new s,m=new s,p=new s;s.packedLength=4,s.pack=function(e,i,a){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");a=r(a,0),i[a++]=e.x,i[a++]=e.y,i[a++]=e.z,i[a]=e.w},s.unpack=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new s),a.x=e[i],a.y=e[i+1],a.z=e[i+2],a.w=e[i+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,r,t,n){s.unpack(e,4*t,p),s.conjugate(p,p);for(var i=0,a=t-r+1;a>i;i++){var o=3*i;s.unpack(e,4*(r+i),w),s.multiply(w,p,w),w.w<0&&s.negate(w,w),s.getAxis(w,h);var u=s.getAngle(w);n[o]=h.x*u,n[o+1]=h.y*u,n[o+2]=h.z*u}},s.unpackInterpolationResult=function(r,n,i,a,o){t(o)||(o=new s),e.fromArray(r,0,d);var u=e.magnitude(d);return s.unpack(n,4*a,m),0===u?s.clone(s.IDENTITY,w):s.fromAxisAngle(d,u,w),s.multiply(w,m,o)},s.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,r){if(!t(e))throw new n("quaternion is required");return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r):new s(-e.x,-e.y,-e.z,e.w)},s.magnitudeSquared=function(e){if(!t(e))throw new n("quaternion is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){var n=1/s.magnitude(e),i=e.x*n,a=e.y*n,o=e.z*n,u=e.w*n;return t(r)?(r.x=i,r.y=a,r.z=o,r.w=u,r):new s(i,a,o,u)},s.inverse=function(e,r){var t=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/t,r)},s.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");return t(i)?(i.x=e.x+r.x,i.y=e.y+r.y,i.z=e.z+r.z,i.w=e.w+r.w,i):new s(e.x+r.x,e.y+r.y,e.z+r.z,e.w+r.w)},s.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");return t(i)?(i.x=e.x-r.x,i.y=e.y-r.y,i.z=e.z-r.z,i.w=e.w-r.w,i):new s(e.x-r.x,e.y-r.y,e.z-r.z,e.w-r.w)},s.negate=function(e,r){if(!t(e))throw new n("quaternion is required");return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r):new s(-e.x,-e.y,-e.z,-e.w)},s.dot=function(e,r){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");return e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");var a=e.x,o=e.y,u=e.z,f=e.w,l=r.x,c=r.y,h=r.z,d=r.w,w=f*l+a*d+o*h-u*c,m=f*c-a*h+o*d+u*l,p=f*h+a*c-o*l+u*d,y=f*d-a*l-o*c-u*h;return t(i)?(i.x=w,i.y=m,i.z=p,i.w=y,i):new s(w,m,p,y)},s.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");return t(i)?(i.x=e.x*r,i.y=e.y*r,i.z=e.z*r,i.w=e.w*r,i):new s(e.x*r,e.y*r,e.z*r,e.w*r)},s.divideByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");return t(i)?(i.x=e.x/r,i.y=e.y/r,i.z=e.z/r,i.w=e.w/r,i):new s(e.x/r,e.y/r,e.z/r,e.w/r)},s.getAxis=function(r,i){if(!t(r))throw new n("quaternion is required");var a=r.w;if(Math.abs(a-1)<o.EPSILON6)return t(i)?(i.x=i.y=i.z=0,i):new e;var u=1/Math.sqrt(1-a*a);return t(i)?(i.x=r.x*u,i.y=r.y*u,i.z=r.z*u,i):new e(r.x*u,r.y*u,r.z*u)},s.getAngle=function(e){if(!t(e))throw new n("quaternion is required");return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var y;s.lerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");return y=s.multiplyByScalar(r,i,y),a=s.multiplyByScalar(e,1-i,a),s.add(y,a,a)};var v,g,x;s.slerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");var u=s.dot(e,r),f=r;if(0>u&&(u=-u,f=v=s.negate(r,v)),1-u<o.EPSILON6)return s.lerp(e,f,i,a);var l=Math.acos(u);return g=s.multiplyByScalar(e,Math.sin((1-i)*l),g),x=s.multiplyByScalar(f,Math.sin(i*l),x),a=s.add(g,x,a),s.multiplyByScalar(a,1/Math.sin(l),a)},s.log=function(r,i){if(!t(r))throw new n("quaternion is required.");var a=o.acosClamped(r.w),u=0;return 0!==a&&(u=a/Math.sin(a)),t(i)||(i=new e),e.multiplyByScalar(r,u,i)},s.exp=function(r,i){if(!t(r))throw new n("cartesian is required.");var a=e.magnitude(r),o=0;return 0!==a&&(o=Math.sin(a)/a),t(i)||(i=new s),i.x=r.x*o,i.y=r.y*o,i.z=r.z*o,i.w=Math.cos(a),i};var b=new e,q=new e,E=new s,S=new s;s.innerQuadrangle=function(r,i,a,o){if(!t(r)||!t(i)||!t(a))throw new n("q0, q1, and q2 are required.");var u=s.conjugate(i,E);s.multiply(u,a,S);var f=s.log(S,b);s.multiply(u,r,S);var l=s.log(S,q);return e.add(f,l,f),e.multiplyByScalar(f,.25,f),e.negate(f,f),s.exp(f,E),s.multiply(i,E,o)},s.squad=function(e,r,i,a,o,u){if(!(t(e)&&t(r)&&t(i)&&t(a)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof o)throw new n("t is required and must be a number.");var f=s.slerp(e,r,o,E),l=s.slerp(i,a,o,S);return s.slerp(f,l,2*o*(1-o),u)};for(var T=new s,O=1.9011074535173003,M=i.supportsTypedArrays()?new Float32Array(8):[],_=i.supportsTypedArrays()?new Float32Array(8):[],P=i.supportsTypedArrays()?new Float32Array(8):[],N=i.supportsTypedArrays()?new Float32Array(8):[],I=0;7>I;++I){var A=I+1,C=2*A+1;M[I]=1/(A*C),_[I]=A/C}return M[7]=O/136,_[7]=8*O/17,s.fastSlerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");t(a)||(a=new s);var o,u=s.dot(e,r);u>=0?o=1:(o=-1,u=-u);for(var f=u-1,l=1-i,c=i*i,h=l*l,d=7;d>=0;--d)P[d]=(M[d]*c-_[d])*f,N[d]=(M[d]*h-_[d])*f;var w=o*i*(1+P[0]*(1+P[1]*(1+P[2]*(1+P[3]*(1+P[4]*(1+P[5]*(1+P[6]*(1+P[7])))))))),m=l*(1+N[0]*(1+N[1]*(1+N[2]*(1+N[3]*(1+N[4]*(1+N[5]*(1+N[6]*(1+N[7])))))))),p=s.multiplyByScalar(e,m,T);return s.multiplyByScalar(r,w,a),s.add(p,a,a)},s.fastSquad=function(e,r,i,a,o,u){if(!(t(e)&&t(r)&&t(i)&&t(a)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof o)throw new n("t is required and must be a number.");var f=s.fastSlerp(e,r,o,E),l=s.fastSlerp(i,a,o,S);return s.fastSlerp(f,l,2*o*(1-o),u)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},s.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon is required and must be a number.");return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},s.ZERO=a(new s(0,0,0,0)),s.IDENTITY=a(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return s.equalsEpsilon(this,e,r)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/VertexFormat",["./defaultValue","./freezeObject"],function(e,r){"use strict";var t=function(r){r=e(r,e.EMPTY_OBJECT),this.position=e(r.position,!1),this.normal=e(r.normal,!1),this.st=e(r.st,!1),this.binormal=e(r.binormal,!1),this.tangent=e(r.tangent,!1)};return t.POSITION_ONLY=r(new t({position:!0})),t.POSITION_AND_NORMAL=r(new t({position:!0,normal:!0})),t.POSITION_NORMAL_AND_ST=r(new t({position:!0,normal:!0,st:!0})),t.POSITION_AND_ST=r(new t({position:!0,st:!0})),t.ALL=r(new t({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),t.DEFAULT=t.POSITION_NORMAL_AND_ST,t}),define("Core/PolygonGeometry",["./BoundingRectangle","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./PolygonGeometryLibrary","./PolygonPipeline","./PrimitiveType","./Quaternion","./Queue","./VertexFormat","./WindingOrder"],function(e,r,t,n,i,a,o,u,s,f,l,c,h,d,w,m,p,y,v,g,x,b,q,E,S){"use strict";function T(e,r,t,i){for(var a=b.fromAxisAngle(e._plane.normal,t,A),u=y.fromQuaternion(a,C),s=Number.POSITIVE_INFINITY,f=Number.NEGATIVE_INFINITY,l=Number.POSITIVE_INFINITY,c=Number.NEGATIVE_INFINITY,h=r.length,d=0;h>d;++d){var w=n.clone(r[d],I);y.multiplyByVector(u,w,w);var m=e.projectPointOntoPlane(w,N);o(m)&&(s=Math.min(s,m.x),f=Math.max(f,m.x),l=Math.min(l,m.y),c=Math.max(c,m.y))}return i.x=s,i.y=l,i.width=f-s,i.height=c-l,i}function O(e,r,t,n){var a=f.fromPoints(r,e),o=a.projectPointsOntoPlane(r,R),u=g.computeWindingOrder2D(o);u===S.CLOCKWISE&&(o.reverse(),r.reverse());var s=g.triangulate(o);s.length<3&&(s=[0,1,2]);var h;if(n){for(var w=r.length,m=new Array(3*w),p=0,y=0;w>y;y++){var v=r[y];m[p++]=v.x,m[p++]=v.y,m[p++]=v.z}h=new l({attributes:{position:new c({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:m})},indices:s,primitiveType:x.TRIANGLES})}else h=g.computeSubdivision(r,s,t);return new d({geometry:h})}function M(e,r,a,o,u,s,l){if(e.st||e.normal||e.tangent||e.binormal){var h=f.fromPoints(a,o),d=T(h,a,u,z),w=G;w.x=d.x,w.y=d.y;var m=r.attributes.position.values,v=m.length,g=e.st?new Float32Array(2*(v/3)):void 0,x=e.normal?new Float32Array(v):void 0,q=e.tangent?new Float32Array(v):void 0,E=e.binormal?new Float32Array(v):void 0,S=0,O=0,M=L,_=U,P=B,N=!0,I=b.fromAxisAngle(h._plane.normal,u,j),A=y.fromQuaternion(I,k),C=v/2,R=v/3;s&&(v/=2);for(var H=0;v>H;H+=3){var Z=n.fromArray(m,H,Y);if(e.st){var X=y.multiplyByVector(A,Z,D),J=h.projectPointOntoPlane(X,V);t.subtract(J,w,J),s&&(g[S+R]=J.x/d.width,g[S+1+R]=J.y/d.height),g[S]=J.x/d.width,g[S+1]=J.y/d.height,S+=2}if(e.normal||e.tangent||e.binormal){var K=O+1,Q=O+2;if(l){if(v>H+3){var $=n.fromArray(m,H+3,F);if(N){var er=n.fromArray(m,H+v,W);n.subtract($,Z,$),n.subtract(er,Z,er),M=n.normalize(n.cross(er,$,M),M),N=!1}n.equalsEpsilon($,Z,p.EPSILON10)&&(N=!0)}(e.tangent||e.binormal)&&(P=o.geodeticSurfaceNormal(Z,P),e.tangent&&(_=n.normalize(n.cross(P,M,_),_)))}else M=o.geodeticSurfaceNormal(Z,M),(e.tangent||e.binormal)&&(_=n.cross(n.UNIT_Z,M,_),_=n.normalize(y.multiplyByVector(A,_,_),_),e.binormal&&(P=n.normalize(n.cross(M,_,P),P)));e.normal&&(s&&!l?(x[O+C]=-M.x,x[K+C]=-M.y,x[Q+C]=-M.z):(x[O+C]=M.x,x[K+C]=M.y,x[Q+C]=M.z),x[O]=M.x,x[K]=M.y,x[Q]=M.z),e.tangent&&(s&&!l?(q[O+C]=-_.x,q[K+C]=-_.y,q[Q+C]=-_.z):(q[O+C]=_.x,q[K+C]=_.y,q[Q+C]=_.z),q[O]=_.x,q[K]=_.y,q[Q]=_.z),e.binormal&&(s&&(E[O+C]=P.x,E[K+C]=P.y,E[Q+C]=P.z),E[O]=P.x,E[K]=P.y,E[Q]=P.z),O+=3}}e.st&&(r.attributes.st=new c({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:g})),e.normal&&(r.attributes.normal=new c({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:x})),e.tangent&&(r.attributes.tangent=new c({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:q})),e.binormal&&(r.attributes.binormal=new c({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:E}))}return r}function _(e,r,t){var a,o,u,s,f,d,w,y,g,b=[],q=e.length;if(t)for(w=0;q>w;w++)y=e[w],g=e[(w+1)%q],b.push(y.x,y.y,y.z,g.x,g.y,g.z);else for(w=0;q>w;w++)y=e[w],g=e[(w+1)%q],a=v.subdivideLine(y,g,r),a.push(g.x,g.y,g.z),b=b.concat(a);b=b.concat(b),q=b.length;var E=m.createTypedArray(q/3,q-6*e.length);for(o=0,q/=6,w=0;q>w;w++)u=w,s=u+1,y=n.fromArray(b,3*u,F),g=n.fromArray(b,3*s,W),n.equalsEpsilon(y,g,p.EPSILON6)||(f=u+q,d=f+1,E[o++]=u,E[o++]=f,E[o++]=s,E[o++]=s,E[o++]=f,E[o++]=d);return new l({attributes:new h({position:new c({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:b})}),indices:E,primitiveType:x.TRIANGLES})}function P(e,r,t,n,a){var o=O(e,r,t,a).geometry,u=o.attributes.position.values,s=o.indices,w=u.concat(u),p=w.length/3,y=m.createTypedArray(p,2*s.length);y.set(s);var v,x=s.length,b=p/2;for(v=0;x>v;v+=3){var q=y[v]+b,E=y[v+1]+b,T=y[v+2]+b;y[v+x]=T,y[v+1+x]=E,y[v+2+x]=q}var M=new l({attributes:new h({position:new c({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:w})}),indices:y,primitiveType:o.primitiveType}),P={topAndBottom:new d({geometry:M})};P.walls=[];var N=n.outerRing,I=f.fromPoints(N,e),A=I.projectPointsOntoPlane(N,H),C=g.computeWindingOrder2D(A);C===S.CLOCKWISE&&N.reverse();var R=_(N,t,a);P.walls.push(new d({geometry:R}));var z=n.holes;for(v=0;v<z.length;v++){var D=z[v];I=f.fromPoints(D,e),A=I.projectPointsOntoPlane(D,H),C=g.computeWindingOrder2D(A),C===S.CLOCKWISE&&D.reverse(),R=_(D,t),P.walls.push(new d({geometry:R}))}return P}var N=new t,I=new n,A=new b,C=new y,R=[],z=new e,D=new n,L=new n,U=new n,B=new n;new r;var F=new n,W=new n,G=new t,V=new t,Y=new n,j=new b,k=new y,H=[],Z=function(e){e=a(e,a.EMPTY_OBJECT);var r=a(e.vertexFormat,E.DEFAULT),t=a(e.ellipsoid,s.WGS84),n=a(e.granularity,p.RADIANS_PER_DEGREE),i=a(e.stRotation,0),f=a(e.height,0),l=a(e.perPositionHeight,!1),c=e.extrudedHeight,h=o(c)&&(!p.equalsEpsilon(f,c,p.EPSILON6)||l);if(h){var d=c;c=Math.min(d,f),f=Math.max(d,f)}var w=e.polygonHierarchy;if(!o(w))throw new u("options.polygonHierarchy is required.");this._vertexFormat=r,this._ellipsoid=t,this._granularity=n,this._stRotation=i,this._height=f,this._extrudedHeight=c,this._extrude=h,this._polygonHierarchy=w,this._perPositionHeight=l,this._workerName="createPolygonGeometry"};return Z.fromPositions=function(e){if(e=a(e,a.EMPTY_OBJECT),!o(e.positions))throw new u("options.positions is required.");var r={polygonHierarchy:{positions:e.positions},height:e.height,extrudedHeight:e.extrudedHeight,vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight};return new Z(r)},Z.createGeometry=function(e){var t,n,i,a=e._vertexFormat,s=e._ellipsoid,f=e._granularity,c=e._stRotation,h=e._height,d=e._extrudedHeight,p=e._extrude,y=e._polygonHierarchy,x=e._perPositionHeight,b=[],E=new q;E.enqueue(y),y=[];for(var S;0!==E.length;){var T=E.dequeue(),_=T.positions,N=T.holes;if(_=g.removeDuplicates(_),_.length<3)throw new u("At least three positions are required.");var I=N?N.length:0;if(0===I)y.push({outerRing:_,holes:[]}),b.push(_);else{var A=[];for(S=0;I>S;S++){var C=N[S];if(C.positions=g.removeDuplicates(C.positions),C.positions.length<3)throw new u("At least three positions are required.");A.push(C.positions);var R=0;o(C.holes)&&(R=C.holes.length);for(var z=0;R>z;z++)E.enqueue(C.holes[z])}y.push({outerRing:_,holes:A});var D=g.eliminateHoles(_,A);b.push(D)}}i=b[0];var L,U=[];if(p){for(S=0;S<b.length;S++)if(L=P(s,b[S],f,y[S],x),o(L)){n=L.topAndBottom,n.geometry=v.scaleToGeodeticHeightExtruded(n.geometry,h,d,s,x),n.geometry=M(a,n.geometry,i,s,c,!0,!1),U.push(n),t=L.walls;for(var B=0;B<t.length;B++){var F=t[B];F.geometry=v.scaleToGeodeticHeightExtruded(F.geometry,h,d,s,x),F.geometry=M(a,F.geometry,i,s,c,!0,!0),U.push(F)}}}else for(S=0;S<b.length;S++)L=O(s,b[S],f,x),o(L)&&(L.geometry=g.scaleToGeodeticHeight(L.geometry,h,s,!x),L.geometry=M(a,L.geometry,i,s,c,!1,!1),U.push(L));L=w.combine(U),L.attributes.position.values=new Float64Array(L.attributes.position.values),L.indices=m.createTypedArray(L.attributes.position.values.length/3,L.indices);var W=L.attributes,G=r.fromVertices(W.position.values);return a.position||delete W.position,new l({attributes:W,indices:L.indices,primitiveType:L.primitiveType,boundingSphere:G})},Z}),define("Workers/createPolygonGeometry",["../Core/Ellipsoid","../Core/PolygonGeometry"],function(e,r){"use strict";function t(t){return t._ellipsoid=e.clone(t._ellipsoid),r.createGeometry(t)}return t})}();