/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2014 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=.5*3*Math.PI,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,a=e-Math.floor(e/r)*r;return a<-Math.PI?a+r:a>=Math.PI?a-r:a},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");for(var r=i.EPSILON10,a=i.PI,o=i.TWO_PI;-(a+r)>e;)e+=o;if(-a>e)return-a;for(;e>a+r;)e-=o;return e>a?a:e},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=e%i.TWO_PI;return 0>r?(r+i.TWO_PI)%i.TWO_PI:r},i.equalsEpsilon=function(e,i,a){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");return a=r(a,0),Math.abs(e-i)<=a};var a=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=a.length;if(e>=r)for(var t=a[r-1],i=r;e>=i;i++)a.push(t*i);return a[e]},i.incrementWrap=function(e,i,a){if(a=r(a,0),!t(e))throw new n("n is required.");if(a>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=a),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var o=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");o=new e(r)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){return Math.asin(i.clamp(e,-1,1))},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};a.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new a);var o=n.clock,u=n.cone,s=e(n.magnitude,1),h=s*Math.sin(u);return i.x=h*Math.cos(o),i.y=h*Math.sin(o),i.z=s*Math.cos(u),i},a.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new a(e,t,n)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a]=n.z},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i],o},a.fromArray=a.unpack,a.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},a.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},a.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},a.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var u=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,u),o=a.multiplyByScalar(e,1-i,o),a.add(u,o,o)};var s=new a,h=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");a.normalize(e,s),a.normalize(n,h);var i=a.dot(s,h),o=a.magnitude(a.cross(s,h,s));return Math.atan2(o,i)};var f=new a;a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,f);return a.abs(i,i),n=i.x<=i.y?i.x<=i.z?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Z,n):i.y<=i.z?a.clone(a.UNIT_Y,n):a.clone(a.UNIT_Z,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i},a.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var a=e.x,o=e.y,u=e.z,s=n.x,h=n.y,f=n.z,w=o*f-u*h,c=u*s-a*f,l=a*h-o*s;return i.x=w,i.y=c,i.z=l,i},a.fromDegrees=function(e,n,o,u,s){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var h=i.toRadians(e),f=i.toRadians(n);return a.fromRadians(h,f,o,u,s)};var w=new a,c=new a,l=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,i,o,u,s){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");o=e(o,0);var h=r(u)?u.radiiSquared:l,f=Math.cos(i);w.x=f*Math.cos(n),w.y=f*Math.sin(n),w.z=Math.sin(i),w=a.normalize(w,w),a.multiplyComponents(h,w,c);var d=Math.sqrt(a.dot(w,c));return c=a.divideByScalar(c,d,c),w=a.multiplyByScalar(w,o,w),r(s)||(s=new a),a.add(c,w,s)},a.fromDegreesArray=function(e,n,o){if(!r(e))throw new t("positions is required.");for(var u=new Array(e.length),s=0;s<e.length;s++)u[s]=i.toRadians(e[s]);return a.fromRadiansArray(u,n,o)},a.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(0!==e.length%2)throw new t("positions length must be a multiple of 2.");var o=e.length;r(i)?i.length=o/2:i=new Array(o/2);for(var u=0;o>u;u+=2){var s=e[u],h=e[u+1];i[u/2]=a.fromRadians(s,h,0,n,i[u/2])}return i},a.fromDegreesArrayHeights=function(e,n,o){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");for(var u=new Array(e.length),s=0;s<e.length;s+=3)u[s]=i.toRadians(e[s]),u[s+1]=i.toRadians(e[s+1]),u[s+2]=e[s+2];return a.fromRadiansArrayHeights(u,n,o)},a.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");var o=e.length;r(i)?i.length=o/3:i=new Array(o/3);for(var u=0;o>u;u+=3){var s=e[u],h=e[u+1],f=e[u+2];i[u/3]=a.fromRadians(s,h,f,n,i[u/3])}return i},a.ZERO=n(new a(0,0,0)),a.UNIT_X=n(new a(1,0,0)),a.UNIT_Y=n(new a(0,1,0)),a.UNIT_Z=n(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return a.fromRadians=function(n,i,o,u){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return o=e(o,0),r(u)?(u.longitude=n,u.latitude=i,u.height=o,u):new a(n,i,o)},a.fromDegrees=function(e,n,o,u){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),a.fromRadians(e,n,o,u)},a.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new a(e.longitude,e.latitude,e.height):void 0},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},a.toString=function(e){if(!r(e))throw new t("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},a.ZERO=n(new a(0,0,0)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return a.toString(this)},a}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a,o,u){"use strict";var s=function(r,n,i){if(r=t(r,0),n=t(n,0),i=t(i,0),0>r||0>n||0>i)throw new a("All radii components must be greater than or equal to zero.");this._radii=new e(r,n,i),this._radiiSquared=new e(r*r,n*n,i*i),this._radiiToTheFourth=new e(r*r*r*r,n*n*n*n,i*i*i*i),this._oneOverRadii=new e(0===r?0:1/r,0===n?0:1/n,0===i?0:1/i),this._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===n?0:1/(n*n),0===i?0:1/(i*i)),this._minimumRadius=Math.min(r,n,i),this._maximumRadius=Math.max(r,n,i),this._centerToleranceSquared=u.EPSILON1};i(s.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),s.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new s(i.x,i.y,i.z)},s.fromCartesian3=function(e){return n(e)?new s(e.x,e.y,e.z):new s},s.WGS84=o(new s(6378137,6378137,6356752.314245179)),s.UNIT_SPHERE=o(new s(1,1,1)),s.MOON=o(new s(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.geocentricSurfaceNormal=e.normalize,s.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new a("cartographic is required.");var i=r.longitude,o=r.latitude,u=Math.cos(o),s=u*Math.cos(i),h=u*Math.sin(i),f=Math.sin(o);return n(t)||(t=new e),t.x=s,t.y=h,t.z=f,e.normalize(t,t)},s.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var h=new e,f=new e;s.prototype.cartographicToCartesian=function(r,t){var i=h,a=f;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(a,i,t)},s.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new a("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var w=new e,c=new e,l=new e;s.prototype.cartesianToCartographic=function(t,i){var a=this.scaleToGeodeticSurface(t,c);if(!n(a))return void 0;var o=this.geodeticSurfaceNormal(a,w),s=e.subtract(t,a,l),h=Math.atan2(o.y,o.x),f=Math.asin(o.z),d=u.sign(e.dot(s,t))*e.magnitude(s);return n(i)?(i.longitude=h,i.latitude=f,i.height=d,i):new r(h,f,d)},s.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new a("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var d=new e,m=new e;return s.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");var i=r.x,o=r.y,s=r.z,h=this._oneOverRadii,f=h.x,w=h.y,c=h.z,l=i*i*f*f,y=o*o*w*w,p=s*s*c*c,q=l+y+p,g=Math.sqrt(1/q),x=e.multiplyByScalar(r,g,d);if(q<this._centerToleranceSquared)return isFinite(g)?e.clone(x,t):void 0;var v=this._oneOverRadiiSquared,b=v.x,E=v.y,M=v.z,S=m;S.x=2*x.x*b,S.y=2*x.y*E,S.z=2*x.z*M;var z,O,T,I,_,N,R,A,P,C,L,U=(1-g)*e.magnitude(r)/(.5*e.magnitude(S)),D=0;do{U-=D,T=1/(1+U*b),I=1/(1+U*E),_=1/(1+U*M),N=T*T,R=I*I,A=_*_,P=N*T,C=R*I,L=A*_,z=l*N+y*R+p*A-1,O=l*P*b+y*C*E+p*L*M;var B=-2*O;D=z/B}while(Math.abs(z)>u.EPSILON12);return n(t)?(t.x=i*T,t.y=o*I,t.z=s*_,t):new e(i*T,o*I,s*_)},s.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");n(t)||(t=new e);var i=r.x,o=r.y,u=r.z,s=this._oneOverRadiiSquared,h=1/Math.sqrt(i*i*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(r,h,t)},s.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},s.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},s.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},s.prototype.toString=function(){return this._radii.toString()},s}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,a,o){"use strict";var u=function(e){this._ellipsoid=t(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(r,t){var i=this._semimajorAxis,a=r.longitude*i,o=r.latitude*i,u=r.height;return n(t)?(t.x=a,t.y=o,t.z=u,t):new e(a,o,u)},u.prototype.unproject=function(e,t){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=e.y*i,s=e.z;return n(t)?(t.longitude=o,t.latitude=u,t.height=s,t):new r(o,u,s)},u}),define("Core/Intersect",[],function(){"use strict";var e={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};i.fromElements=function(e,t,n,a,o){return r(o)?(o.x=e,o.y=t,o.z=n,o.w=a,o):new i(e,t,n,a)},i.fromColor=function(e,n){if(!r(e))throw new t("color is required");return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a++]=n.z,i[a]=n.w},i.unpack=function(n,a,o){if(!r(n))throw new t("array is required");return a=e(a,0),r(o)||(o=new i),o.x=n[a++],o.y=n[a++],o.z=n[a++],o.w=n[a],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},i.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},i.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},i.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},i.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return i.subtract(e,n,a),i.magnitude(a)},i.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var a=i.magnitude(e);return n.x=e.x/a,n.y=e.y/a,n.z=e.z/a,n.w=e.w/a,n},i.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},i.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},i.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},i.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},i.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},i.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},i.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},i.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var o=new i;i.lerp=function(e,n,a,u){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof a)throw new t("t is required and must be a number.");if(!r(u))throw new t("result is required.");return i.multiplyByScalar(n,a,o),u=i.multiplyByScalar(e,1-a,u),i.add(o,u,u)};var u=new i;return i.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var a=i.normalize(e,u);return i.abs(a,a),n=a.x<=a.y?a.x<=a.z?a.x<=a.w?i.clone(i.UNIT_X,n):i.clone(i.UNIT_W,n):a.z<=a.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n):a.y<=a.z?a.y<=a.w?i.clone(i.UNIT_Y,n):i.clone(i.UNIT_W,n):a.z<=a.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},i.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i&&Math.abs(e.w-n.w)<=i},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,r){return i.equalsEpsilon(this,e,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a){"use strict";function o(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function u(e){for(var r=0,t=0;3>t;++t){var n=e[h.getElementIndex(l[t],c[t])];r+=2*n*n}return Math.sqrt(r)}function s(e,r){for(var t=a.EPSILON15,n=0,i=1,o=0;3>o;++o){var u=Math.abs(e[h.getElementIndex(l[o],c[o])]);u>n&&(i=o,n=u)}var s=1,f=0,w=c[i],d=l[i];if(Math.abs(e[h.getElementIndex(d,w)])>t){var m,y=e[h.getElementIndex(d,d)],p=e[h.getElementIndex(w,w)],q=e[h.getElementIndex(d,w)],g=(y-p)/2/q;m=0>g?-1/(-g+Math.sqrt(1+g*g)):1/(g+Math.sqrt(1+g*g)),s=1/Math.sqrt(1+m*m),f=m*s}return r=h.clone(h.IDENTITY,r),r[h.getElementIndex(w,w)]=r[h.getElementIndex(d,d)]=s,r[h.getElementIndex(d,w)]=f,r[h.getElementIndex(w,d)]=-f,r}var h=function(e,t,n,i,a,o,u,s,h){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(h,0)};h.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new h(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},h.fromArray=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new h),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a[9]=e[i+9],a},h.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return h.clone(e,r)},h.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new h(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},h.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,u=e.x*e.w,s=e.y*e.y,f=e.y*e.z,w=e.y*e.w,c=e.z*e.z,l=e.z*e.w,d=e.w*e.w,m=i-s-c+d,y=2*(a-l),p=2*(o+w),q=2*(a+l),g=-i+s-c+d,x=2*(f-u),v=2*(o-w),b=2*(f+u),E=-i-s+c+d;return t(r)?(r[0]=m,r[1]=q,r[2]=v,r[3]=y,r[4]=g,r[5]=b,r[6]=p,r[7]=x,r[8]=E,r):new h(m,y,p,q,g,x,v,b,E)},h.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new h(e.x,0,0,0,e.y,0,0,0,e.z)},h.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new h(e,0,0,0,e,0,0,0,e)},h.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=a,r[6]=0,r[7]=-a,r[8]=i,r):new h(1,0,0,0,i,-a,0,a,i)},h.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=i,r):new h(i,0,a,0,1,0,-a,0,i)},h.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=a,r[2]=0,r[3]=-a,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new h(i,-a,0,a,i,0,0,0,1)},h.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},h.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},h.getColumn=function(r,i,a){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var o=3*i,u=r[o],s=r[o+1],h=r[o+2];return t(a)?(a.x=u,a.y=s,a.z=h,a):new e(u,s,h)},h.setColumn=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");a=h.clone(e,a);var o=3*r;return a[o]=i.x,a[o+1]=i.y,a[o+2]=i.z,a},h.getRow=function(r,i,a){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var o=r[i],u=r[i+3],s=r[i+6];return t(a)?(a.x=o,a.y=u,a.z=s,a):new e(o,u,s)},h.setRow=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");return a=h.clone(e,a),a[r]=i.x,a[r+3]=i.y,a[r+6]=i.z,a};var f=new e;h.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");return t(i)||(i=new e),i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],f)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],f)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],f)),i};var w=new e;h.getMaximumScale=function(r){return h.getScale(r,w),e.getMaximumComponent(w)},h.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");var a=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],o=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],u=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],f=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],w=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],c=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],l=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],d=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return t(i)?(i[0]=a,i[1]=o,i[2]=u,i[3]=s,i[4]=f,i[5]=w,i[6]=c,i[7]=l,i[8]=d,i):new h(a,s,c,o,f,l,u,w,d)},h.multiplyByVector=function(r,i,a){if(!t(r))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");var o=i.x,u=i.y,s=i.z,h=r[0]*o+r[3]*u+r[6]*s,f=r[1]*o+r[4]*u+r[7]*s,w=r[2]*o+r[5]*u+r[8]*s;return t(a)?(a.x=h,a.y=f,a.z=w,a):new e(h,f,w)},h.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");return t(i)?(i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i):new h(e[0]*r,e[3]*r,e[6]*r,e[1]*r,e[4]*r,e[7]*r,e[2]*r,e[5]*r,e[8]*r)},h.negate=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r):new h(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},h.transpose=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],a=e[3],o=e[6],u=e[1],s=e[4],f=e[7],w=e[2],c=e[5],l=e[8];return t(r)?(r[0]=i,r[1]=a,r[2]=o,r[3]=u,r[4]=s,r[5]=f,r[6]=w,r[7]=c,r[8]=l,r):new h(i,u,w,a,s,c,o,f,l)};var c=[1,0,0],l=[2,2,1],d=new h,m=new h;return h.getEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=a.EPSILON20,f=10,w=0,c=0;
t(r)||(r={});for(var l=r.unitary=h.clone(h.IDENTITY,r.unitary),y=r.diagonal=h.clone(e,r.diagonal),p=i*o(y);f>c&&u(y)>p;)s(y,d),h.transpose(d,m),h.multiply(y,d,y),h.multiply(m,y,y),h.multiply(l,d,l),++w>2&&(++c,w=0);return r},h.abs=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r):new h(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},h.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],a=e[6],o=e[1],u=e[4],s=e[7],h=e[2],f=e[5],w=e[8];return r*(u*w-f*s)+o*(f*a-i*w)+h*(i*s-u*a)},h.inverse=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],o=e[1],u=e[2],s=e[3],f=e[4],w=e[5],c=e[6],l=e[7],d=e[8],m=h.determinant(e);if(Math.abs(m)<=a.EPSILON15)throw new n("matrix is not invertible");t(r)||(r=new h),r[0]=f*d-l*w,r[1]=l*u-o*d,r[2]=o*w-f*u,r[3]=c*w-s*d,r[4]=i*d-c*u,r[5]=s*u-i*w,r[6]=s*l-c*f,r[7]=c*o-i*l,r[8]=i*f-s*o;var y=1/m;return h.multiplyByScalar(r,y,r)},h.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},h.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},h.IDENTITY=i(new h(1,0,0,0,1,0,0,0,1)),h.COLUMN0ROW0=0,h.COLUMN0ROW1=1,h.COLUMN0ROW2=2,h.COLUMN1ROW0=3,h.COLUMN1ROW1=4,h.COLUMN1ROW2=5,h.COLUMN2ROW0=6,h.COLUMN2ROW1=7,h.COLUMN2ROW2=8,h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.equalsEpsilon=function(e,r){return h.equalsEpsilon(this,e,r)},h.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},h}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,a,o,u,s){"use strict";var h=function(e,r,n,i,a,o,u,s,h,f,w,c,l,d,m,y){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(h,0),this[3]=t(l,0),this[4]=t(r,0),this[5]=t(o,0),this[6]=t(f,0),this[7]=t(d,0),this[8]=t(n,0),this[9]=t(u,0),this[10]=t(w,0),this[11]=t(m,0),this[12]=t(i,0),this[13]=t(s,0),this[14]=t(c,0),this[15]=t(y,0)};h.packedLength=16,h.pack=function(e,r,a){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");a=t(a,0),r[a++]=e[0],r[a++]=e[1],r[a++]=e[2],r[a++]=e[3],r[a++]=e[4],r[a++]=e[5],r[a++]=e[6],r[a++]=e[7],r[a++]=e[8],r[a++]=e[9],r[a++]=e[10],r[a++]=e[11],r[a++]=e[12],r[a++]=e[13],r[a++]=e[14],r[a]=e[15]},h.unpack=function(e,r,a){if(!n(e))throw new i("array is required");return r=t(r,0),n(a)||(a=new h),a[0]=e[r++],a[1]=e[r++],a[2]=e[r++],a[3]=e[r++],a[4]=e[r++],a[5]=e[r++],a[6]=e[r++],a[7]=e[r++],a[8]=e[r++],a[9]=e[r++],a[10]=e[r++],a[11]=e[r++],a[12]=e[r++],a[13]=e[r++],a[14]=e[r++],a[15]=e[r],a},h.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new h(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},h.fromArray=h.unpack,h.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return h.clone(e,r)},h.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new h(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},h.fromRotationTranslation=function(e,r,t){if(!n(e))throw new i("rotation is required.");if(!n(r))throw new i("translation is required.");return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=0,t[4]=e[3],t[5]=e[4],t[6]=e[5],t[7]=0,t[8]=e[6],t[9]=e[7],t[10]=e[8],t[11]=0,t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=1,t):new h(e[0],e[3],e[6],r.x,e[1],e[4],e[7],r.y,e[2],e[5],e[8],r.z,0,0,0,1)},new u,h.fromTranslationQuaternionRotationScale=function(e,r,t,a){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(a)||(a=new h);var o=t.x,u=t.y,s=t.z,f=r.x*r.x,w=r.x*r.y,c=r.x*r.z,l=r.x*r.w,d=r.y*r.y,m=r.y*r.z,y=r.y*r.w,p=r.z*r.z,q=r.z*r.w,g=r.w*r.w,x=f-d-p+g,v=2*(w-q),b=2*(c+y),E=2*(w+q),M=-f+d-p+g,S=2*(m-l),z=2*(c-y),O=2*(m+l),T=-f-d+p+g;return a[0]=x*o,a[1]=E*o,a[2]=z*o,a[3]=0,a[4]=v*u,a[5]=M*u,a[6]=O*u,a[7]=0,a[8]=b*s,a[9]=S*s,a[10]=T*s,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},h.fromTranslation=function(e,r){return h.fromRotationTranslation(u.IDENTITY,e,r)},h.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new h(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},h.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new h(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var f=new e,w=new e,c=new e;h.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var a=r.eye,o=r.target,u=r.up;if(!n(a))throw new i("camera.eye is required.");if(!n(o))throw new i("camera.target is required.");if(!n(u))throw new i("camera.up is required.");e.normalize(e.subtract(o,a,f),f),e.normalize(e.cross(f,u,w),w),e.normalize(e.cross(w,f,c),c);var s=w.x,l=w.y,d=w.z,m=f.x,y=f.y,p=f.z,q=c.x,g=c.y,x=c.z,v=a.x,b=a.y,E=a.z,M=s*-v+l*-b+d*-E,S=q*-v+g*-b+x*-E,z=m*v+y*b+p*E;return n(t)?(t[0]=s,t[1]=q,t[2]=-m,t[3]=0,t[4]=l,t[5]=g,t[6]=-y,t[7]=0,t[8]=d,t[9]=x,t[10]=-p,t[11]=0,t[12]=M,t[13]=S,t[14]=z,t[15]=1,t):new h(s,l,d,M,q,g,x,S,-m,-y,-p,z,0,0,0,1)},h.computePerspectiveFieldOfView=function(e,r,t,a,o){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=a)throw new i("far must be greater than zero.");var u=Math.tan(.5*e),s=1/u,f=s/r,w=(a+t)/(t-a),c=2*a*t/(t-a);return n(o)?(o[0]=f,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=w,o[11]=-1,o[12]=0,o[13]=0,o[14]=c,o[15]=0,o):new h(f,0,0,0,0,s,0,0,0,0,w,c,0,0,-1,0)},h.computeOrthographicOffCenter=function(e,r,t,a,o,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(u))throw new i("far is required.");var f=1/(r-e),w=1/(a-t),c=1/(u-o),l=-(r+e)*f,d=-(a+t)*w,m=-(u+o)*c;return f*=2,w*=2,c*=-2,n(s)?(s[0]=f,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=w,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=c,s[11]=0,s[12]=l,s[13]=d,s[14]=m,s[15]=1,s):new h(f,0,0,l,0,w,0,d,0,0,c,m,0,0,0,1)},h.computePerspectiveOffCenter=function(e,r,t,a,o,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(u))throw new i("far is required.");var f=2*o/(r-e),w=2*o/(a-t),c=(r+e)/(r-e),l=(a+t)/(a-t),d=-(u+o)/(u-o),m=-1,y=-2*u*o/(u-o);return n(s)?(s[0]=f,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=w,s[6]=0,s[7]=0,s[8]=c,s[9]=l,s[10]=d,s[11]=m,s[12]=0,s[13]=0,s[14]=y,s[15]=0,s):new h(f,0,c,0,0,w,l,0,0,0,d,y,0,0,m,0)},h.computeInfinitePerspectiveOffCenter=function(e,r,t,a,o,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");var s=2*o/(r-e),f=2*o/(a-t),w=(r+e)/(r-e),c=(a+t)/(a-t),l=-1,d=-1,m=-2*o;return n(u)?(u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=f,u[6]=0,u[7]=0,u[8]=w,u[9]=c,u[10]=l,u[11]=d,u[12]=0,u[13]=0,u[14]=m,u[15]=0,u):new h(s,0,w,0,0,f,c,0,0,0,l,m,0,0,d,0)},h.computeViewportTransformation=function(e,r,i,a){e=t(e,t.EMPTY_OBJECT);var o=t(e.x,0),u=t(e.y,0),s=t(e.width,0),f=t(e.height,0);r=t(r,0),i=t(i,1);var w=.5*s,c=.5*f,l=.5*(i-r),d=w,m=c,y=l,p=o+w,q=u+c,g=r+l,x=1;return n(a)?(a[0]=d,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=m,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=y,a[11]=0,a[12]=p,a[13]=q,a[14]=g,a[15]=x,a):new h(d,0,0,p,0,m,0,q,0,0,y,g,0,0,0,x)},h.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},h.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},h.getColumn=function(e,t,a){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var o=4*t,u=e[o],s=e[o+1],h=e[o+2],f=e[o+3];return n(a)?(a.x=u,a.y=s,a.z=h,a.w=f,a):new r(u,s,h,f)},h.setColumn=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");a=h.clone(e,a);var o=4*r;return a[o]=t.x,a[o+1]=t.y,a[o+2]=t.z,a[o+3]=t.w,a},h.getRow=function(e,t,a){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var o=e[t],u=e[t+4],s=e[t+8],h=e[t+12];return n(a)?(a.x=o,a.y=u,a.z=s,a.w=h,a):new r(o,u,s,h)},h.setRow=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");return a=h.clone(e,a),a[r]=t.x,a[r+4]=t.y,a[r+8]=t.z,a[r+12]=t.w,a};var l=new e;h.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");return n(t)||(t=new e),t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],l)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],l)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],l)),t};var d=new e;h.getMaximumScale=function(r){return h.getScale(r,d),e.getMaximumComponent(d)},h.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var a=e[0],o=e[1],u=e[2],s=e[3],f=e[4],w=e[5],c=e[6],l=e[7],d=e[8],m=e[9],y=e[10],p=e[11],q=e[12],g=e[13],x=e[14],v=e[15],b=r[0],E=r[1],M=r[2],S=r[3],z=r[4],O=r[5],T=r[6],I=r[7],_=r[8],N=r[9],R=r[10],A=r[11],P=r[12],C=r[13],L=r[14],U=r[15],D=a*b+f*E+d*M+q*S,B=o*b+w*E+m*M+g*S,F=u*b+c*E+y*M+x*S,W=s*b+l*E+p*M+v*S,V=a*z+f*O+d*T+q*I,G=o*z+w*O+m*T+g*I,Y=u*z+c*O+y*T+x*I,k=s*z+l*O+p*T+v*I,j=a*_+f*N+d*R+q*A,H=o*_+w*N+m*R+g*A,Z=u*_+c*N+y*R+x*A,X=s*_+l*N+p*R+v*A,K=a*P+f*C+d*L+q*U,J=o*P+w*C+m*L+g*U,Q=u*P+c*C+y*L+x*U,$=s*P+l*C+p*L+v*U;return n(t)?(t[0]=D,t[1]=B,t[2]=F,t[3]=W,t[4]=V,t[5]=G,t[6]=Y,t[7]=k,t[8]=j,t[9]=H,t[10]=Z,t[11]=X,t[12]=K,t[13]=J,t[14]=Q,t[15]=$,t):new h(D,V,j,K,B,G,H,J,F,Y,Z,Q,W,k,X,$)},h.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var a=e[0],o=e[1],u=e[2],s=e[4],f=e[5],w=e[6],c=e[8],l=e[9],d=e[10],m=e[12],y=e[13],p=e[14],q=r[0],g=r[1],x=r[2],v=r[4],b=r[5],E=r[6],M=r[8],S=r[9],z=r[10],O=r[12],T=r[13],I=r[14],_=a*q+s*g+c*x,N=o*q+f*g+l*x,R=u*q+w*g+d*x,A=a*v+s*b+c*E,P=o*v+f*b+l*E,C=u*v+w*b+d*E,L=a*M+s*S+c*z,U=o*M+f*S+l*z,D=u*M+w*S+d*z,B=a*O+s*T+c*I+m,F=o*O+f*T+l*I+y,W=u*O+w*T+d*I+p;return n(t)?(t[0]=_,t[1]=N,t[2]=R,t[3]=0,t[4]=A,t[5]=P,t[6]=C,t[7]=0,t[8]=L,t[9]=U,t[10]=D,t[11]=0,t[12]=B,t[13]=F,t[14]=W,t[15]=1,t):new h(_,A,L,B,N,P,U,F,R,C,D,W,0,0,0,1)},h.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");var a=r.x,o=r.y,u=r.z,s=a*e[0]+o*e[4]+u*e[8]+e[12],f=a*e[1]+o*e[5]+u*e[9]+e[13],w=a*e[2]+o*e[6]+u*e[10]+e[14];return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=s,t[13]=f,t[14]=w,t[15]=e[15],t):new h(e[0],e[4],e[8],s,e[1],e[5],e[9],f,e[2],e[6],e[10],w,e[3],e[7],e[11],e[15])};var m=new e;return h.multiplyByUniformScale=function(e,r,t){if("number"!=typeof r)throw new i("scale is required");return m.x=r,m.y=r,m.z=r,h.multiplyByScale(e,m,t)},h.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");var a=r.x,o=r.y,u=r.z;return 1===a&&1===o&&1===u?h.clone(e,t):n(t)?(t[0]=a*e[0],t[1]=a*e[1],t[2]=a*e[2],t[3]=0,t[4]=o*e[4],t[5]=o*e[5],t[6]=o*e[6],t[7]=0,t[8]=u*e[8],t[9]=u*e[9],t[10]=u*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t):new h(a*e[0],o*e[4],u*e[8],e[12],a*e[1],o*e[5],u*e[9],e[13],a*e[2],o*e[6],u*e[10],e[14],0,0,0,1)},h.multiplyByVector=function(e,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,u=t.y,s=t.z,h=t.w,f=e[0]*o+e[4]*u+e[8]*s+e[12]*h,w=e[1]*o+e[5]*u+e[9]*s+e[13]*h,c=e[2]*o+e[6]*u+e[10]*s+e[14]*h,l=e[3]*o+e[7]*u+e[11]*s+e[15]*h;return n(a)?(a.x=f,a.y=w,a.z=c,a.w=l,a):new r(f,w,c,l)},h.multiplyByPointAsVector=function(r,t,a){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,u=t.y,s=t.z,h=r[0]*o+r[4]*u+r[8]*s,f=r[1]*o+r[5]*u+r[9]*s,w=r[2]*o+r[6]*u+r[10]*s;return n(a)?(a.x=h,a.y=f,a.z=w,a):new e(h,f,w)},h.multiplyByPoint=function(r,t,a){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,u=t.y,s=t.z,h=r[0]*o+r[4]*u+r[8]*s+r[12],f=r[1]*o+r[5]*u+r[9]*s+r[13],w=r[2]*o+r[6]*u+r[10]*s+r[14];return n(a)?(a.x=h,a.y=f,a.z=w,a):new e(h,f,w)},h.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");return n(t)?(t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t):new h(e[0]*r,e[4]*r,e[8]*r,e[12]*r,e[1]*r,e[5]*r,e[9]*r,e[13]*r,e[2]*r,e[6]*r,e[10]*r,e[14]*r,e[3]*r,e[7]*r,e[11]*r,e[15]*r)},h.negate=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r):new h(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},h.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))return new h(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var t=e[1],a=e[2],o=e[3],u=e[6],s=e[7],f=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=a,r[9]=u,r[10]=e[10],r[11]=e[14],r[12]=o,r[13]=s,r[14]=f,r[15]=e[15],r},h.abs=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r):new h(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},h.equals=function(e,r){return e===r||n(e)&&n(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[11]===r[11]&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[15]===r[15]},h.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},h.getTranslation=function(r,t){if(!n(r))throw new i("matrix is required");return n(t)?(t.x=r[12],t.y=r[13],t.z=r[14],t):new e(r[12],r[13],r[14])},h.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r):new u(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},h.inverse=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],a=e[4],u=e[8],f=e[12],w=e[1],c=e[5],l=e[9],d=e[13],m=e[2],y=e[6],p=e[10],q=e[14],g=e[3],x=e[7],v=e[11],b=e[15],E=p*b,M=q*v,S=y*b,z=q*x,O=y*v,T=p*x,I=m*b,_=q*g,N=m*v,R=p*g,A=m*x,P=y*g,C=E*c+z*l+O*d-(M*c+S*l+T*d),L=M*w+I*l+R*d-(E*w+_*l+N*d),U=S*w+_*c+A*d-(z*w+I*c+P*d),D=T*w+N*c+P*l-(O*w+R*c+A*l),B=M*a+S*u+T*f-(E*a+z*u+O*f),F=E*t+_*u+N*f-(M*t+I*u+R*f),W=z*t+I*a+P*f-(S*t+_*a+A*f),V=O*t+R*a+A*u-(T*t+N*a+P*u);E=u*d,M=f*l,S=a*d,z=f*c,O=a*l,T=u*c,I=t*d,_=f*w,N=t*l,R=u*w,A=t*c,P=a*w;var G=E*x+z*v+O*b-(M*x+S*v+T*b),Y=M*g+I*v+R*b-(E*g+_*v+N*b),k=S*g+_*x+A*b-(z*g+I*x+P*b),j=T*g+N*x+P*v-(O*g+R*x+A*v),H=S*p+T*q+M*y-(O*q+E*y+z*p),Z=N*q+E*m+_*p-(I*p+R*q+M*m),X=I*y+P*q+z*m-(A*q+S*m+_*y),K=A*p+O*m+R*y-(N*y+P*p+T*m),J=t*C+a*L+u*U+f*D;if(Math.abs(J)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return J=1/J,n(r)?(r[0]=C*J,r[1]=L*J,r[2]=U*J,r[3]=D*J,r[4]=B*J,r[5]=F*J,r[6]=W*J,r[7]=V*J,r[8]=G*J,r[9]=Y*J,r[10]=k*J,r[11]=j*J,r[12]=H*J,r[13]=Z*J,r[14]=X*J,r[15]=K*J,r):new h(C*J,B*J,G*J,H*J,L*J,F*J,Y*J,Z*J,U*J,W*J,k*J,X*J,D*J,V*J,j*J,K*J)},h.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],a=e[1],o=e[2],u=e[4],s=e[5],f=e[6],w=e[8],c=e[9],l=e[10],d=e[12],m=e[13],y=e[14],p=-t*d-a*m-o*y,q=-u*d-s*m-f*y,g=-w*d-c*m-l*y;return n(r)?(r[0]=t,r[1]=u,r[2]=w,r[3]=0,r[4]=a,r[5]=s,r[6]=c,r[7]=0,r[8]=o,r[9]=f,r[10]=l,r[11]=0,r[12]=p,r[13]=q,r[14]=g,r[15]=1,r):new h(t,a,o,p,u,s,f,q,w,c,l,g,0,0,0,1)},h.IDENTITY=a(new h(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),h.COLUMN0ROW0=0,h.COLUMN0ROW1=1,h.COLUMN0ROW2=2,h.COLUMN0ROW3=3,h.COLUMN1ROW0=4,h.COLUMN1ROW1=5,h.COLUMN1ROW2=6,h.COLUMN1ROW3=7,h.COLUMN2ROW0=8,h.COLUMN2ROW1=9,h.COLUMN2ROW2=10,h.COLUMN2ROW3=11,h.COLUMN3ROW0=12,h.COLUMN3ROW1=13,h.COLUMN3ROW2=14,h.COLUMN3ROW3=15,h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.equalsEpsilon=function(e,r){return h.equalsEpsilon(this,e,r)},h.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},h}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,a,o){"use strict";var u=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};u.fromDegrees=function(e,n,i,a,s){return e=o.toRadians(r(e,0)),n=o.toRadians(r(n,0)),i=o.toRadians(r(i,0)),a=o.toRadians(r(a,0)),t(s)?(s.west=e,s.south=n,s.east=i,s.north=a,s):new u(e,n,i,a)},u.fromCartographicArray=function(e,r){if(!t(e))throw new n("cartographics is required.");for(var i=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,s=-Number.MAX_VALUE,h=0,f=e.length;f>h;h++){var w=e[h];i=Math.min(i,w.longitude),a=Math.max(a,w.longitude),o=Math.min(o,w.latitude),s=Math.max(s,w.latitude)}return t(r)?(r.west=i,r.south=o,r.east=a,r.north=s,r):new u(i,o,a,s)},u.packedLength=4,u.pack=function(e,i,a){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");a=r(a,0),i[a++]=e.west,i[a++]=e.south,i[a++]=e.east,i[a]=e.north},u.unpack=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new u),a.west=e[i++],a.south=e[i++],a.east=e[i++],a.north=e[i],a},u.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new u(e.west,e.south,e.east,e.north):void 0},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},u.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new n("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},u.validate=function(e){if(!t(e))throw new n("rectangle is required");var r=e.north;if("number"!=typeof r)throw new n("north is required to be a number.");if(r<-o.PI_OVER_TWO||r>o.PI_OVER_TWO)throw new n("north must be in the interval [-Pi/2, Pi/2].");var i=e.south;if("number"!=typeof i)throw new n("south is required to be a number.");if(i<-o.PI_OVER_TWO||i>o.PI_OVER_TWO)throw new n("south must be in the interval [-Pi/2, Pi/2].");var a=e.west;if("number"!=typeof a)throw new n("west is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new n("west must be in the interval [-Pi, Pi].");var u=e.east;if("number"!=typeof u)throw new n("east is required to be a number.");if(u<-Math.PI||u>Math.PI)throw new n("east must be in the interval [-Pi, Pi].")},u.getSouthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},u.getNorthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},u.getNortheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},u.getSoutheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},u.getCenter=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=.5*(r.west+r.east),i.latitude=.5*(r.south+r.north),i.height=0,i):new e(.5*(r.west+r.east),.5*(r.south+r.north))},u.intersectWith=function(e,r,i){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("otherRectangle is required.");var a=Math.max(e.west,r.west),o=Math.max(e.south,r.south),s=Math.min(e.east,r.east),h=Math.min(e.north,r.north);return t(i)?(i.west=a,i.south=o,i.east=s,i.north=h,i):new u(a,o,s,h)},u.contains=function(e,r){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("cartographic is required.");return r.longitude>=e.west&&r.longitude<=e.east&&r.latitude>=e.south&&r.latitude<=e.north},u.isEmpty=function(e){if(!t(e))throw new n("rectangle is required");return e.west>=e.east||e.south>=e.north};var s=new e;return u.subsample=function(e,a,u,h){if(!t(e))throw new n("rectangle is required");a=r(a,i.WGS84),u=r(u,0),t(h)||(h=[]);var f=0,w=e.north,c=e.south,l=e.east,d=e.west,m=s;m.height=u,m.longitude=d,m.latitude=w,h[f]=a.cartographicToCartesian(m,h[f]),f++,m.longitude=l,h[f]=a.cartographicToCartesian(m,h[f]),f++,m.latitude=c,h[f]=a.cartographicToCartesian(m,h[f]),f++,m.longitude=d,h[f]=a.cartographicToCartesian(m,h[f]),f++,m.latitude=0>w?w:c>0?c:0;for(var y=1;8>y;++y){var p=-Math.PI+y*o.PI_OVER_TWO;p>d&&l>p&&(m.longitude=p,h[f]=a.cartographicToCartesian(m,h[f]),f++)}return 0===m.latitude&&(m.longitude=d,h[f]=a.cartographicToCartesian(m,h[f]),f++,m.longitude=l,h[f]=a.cartographicToCartesian(m,h[f]),f++),h.length=f,h},u.MAX_VALUE=a(new u(-Math.PI,-o.PI_OVER_TWO,Math.PI,o.PI_OVER_TWO)),u}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,r,t,n,i,a,o,u,s,h,f){"use strict";var w=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},c=new e,l=new e,d=new e,m=new e,y=new e,p=new e,q=new e,g=new e,x=new e,v=new e,b=new e,E=new e;w.fromPoints=function(r,t){if(n(t)||(t=new w),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],q),a=e.clone(i,c),o=e.clone(i,l),u=e.clone(i,d),s=e.clone(i,m),h=e.clone(i,y),f=e.clone(i,p),M=r.length,S=1;M>S;S++){e.clone(r[S],i);var z=i.x,O=i.y,T=i.z;z<a.x&&e.clone(i,a),z>s.x&&e.clone(i,s),O<o.y&&e.clone(i,o),O>h.y&&e.clone(i,h),T<u.z&&e.clone(i,u),T>f.z&&e.clone(i,f)}var I=e.magnitudeSquared(e.subtract(s,a,g)),_=e.magnitudeSquared(e.subtract(h,o,g)),N=e.magnitudeSquared(e.subtract(f,u,g)),R=a,A=s,P=I;_>P&&(P=_,R=o,A=h),N>P&&(P=N,R=u,A=f);var C=x;C.x=.5*(R.x+A.x),C.y=.5*(R.y+A.y),C.z=.5*(R.z+A.z);var L=e.magnitudeSquared(e.subtract(A,C,g)),U=Math.sqrt(L),D=v;D.x=a.x,D.y=o.y,D.z=u.z;var B=b;B.x=s.x,B.y=h.y,B.z=f.z;var F=e.multiplyByScalar(e.add(D,B,g),.5,E),W=0;for(S=0;M>S;S++){e.clone(r[S],i);var V=e.magnitude(e.subtract(i,F,g));V>W&&(W=V);var G=e.magnitudeSquared(e.subtract(i,C,g));if(G>L){var Y=Math.sqrt(G);U=.5*(U+Y),L=U*U;var k=Y-U;C.x=(U*C.x+k*i.x)/Y,C.y=(U*C.y+k*i.y)/Y,C.z=(U*C.z+k*i.z)/Y}}return W>U?(e.clone(C,t.center),t.radius=U):(e.clone(F,t.center),t.radius=W),t};var M=new o,S=new e,z=new e,O=new r,T=new r;w.fromRectangle2D=function(e,r,t){return w.fromRectangleWithHeights2D(e,r,0,0,t)},w.fromRectangleWithHeights2D=function(r,i,a,o,u){if(n(u)||(u=new w),!n(r))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=t(i,M),f.getSouthwest(r,O),O.height=a,f.getNortheast(r,T),T.height=o;var s=i.project(O,S),h=i.project(T,z),c=h.x-s.x,l=h.y-s.y,d=h.z-s.z;u.radius=.5*Math.sqrt(c*c+l*l+d*d);var m=u.center;return m.x=s.x+.5*c,m.y=s.y+.5*l,m.z=s.z+.5*d,u};var I=[];w.fromRectangle3D=function(e,r,i,o){r=t(r,a.WGS84),i=t(i,0);var u;return n(e)&&(u=f.subsample(e,r,i,I)),w.fromPoints(u,o)},w.fromVertices=function(r,a,o,u){if(n(u)||(u=new w),!n(r)||0===r.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;if(a=t(a,e.ZERO),o=t(o,3),3>o)throw new i("stride must be 3 or greater.");var s=q;s.x=r[0]+a.x,s.y=r[1]+a.y,s.z=r[2]+a.z;for(var h=e.clone(s,c),f=e.clone(s,l),M=e.clone(s,d),S=e.clone(s,m),z=e.clone(s,y),O=e.clone(s,p),T=r.length,I=0;T>I;I+=o){var _=r[I]+a.x,N=r[I+1]+a.y,R=r[I+2]+a.z;s.x=_,s.y=N,s.z=R,_<h.x&&e.clone(s,h),_>S.x&&e.clone(s,S),N<f.y&&e.clone(s,f),N>z.y&&e.clone(s,z),R<M.z&&e.clone(s,M),R>O.z&&e.clone(s,O)}var A=e.magnitudeSquared(e.subtract(S,h,g)),P=e.magnitudeSquared(e.subtract(z,f,g)),C=e.magnitudeSquared(e.subtract(O,M,g)),L=h,U=S,D=A;P>D&&(D=P,L=f,U=z),C>D&&(D=C,L=M,U=O);var B=x;B.x=.5*(L.x+U.x),B.y=.5*(L.y+U.y),B.z=.5*(L.z+U.z);var F=e.magnitudeSquared(e.subtract(U,B,g)),W=Math.sqrt(F),V=v;V.x=h.x,V.y=f.y,V.z=M.z;var G=b;G.x=S.x,G.y=z.y,G.z=O.z;var Y=e.multiplyByScalar(e.add(V,G,g),.5,E),k=0;for(I=0;T>I;I+=o){s.x=r[I]+a.x,s.y=r[I+1]+a.y,s.z=r[I+2]+a.z;var j=e.magnitude(e.subtract(s,Y,g));j>k&&(k=j);var H=e.magnitudeSquared(e.subtract(s,B,g));if(H>F){var Z=Math.sqrt(H);W=.5*(W+Z),F=W*W;var X=Z-W;B.x=(W*B.x+X*s.x)/Z,B.y=(W*B.y+X*s.y)/Z,B.z=(W*B.z+X*s.z)/Z}}return k>W?(e.clone(B,u.center),u.radius=W):(e.clone(Y,u.center),u.radius=k),u},w.fromCornerPoints=function(r,t,a){if(!n(r)||!n(t))throw new i("corner and oppositeCorner are required.");n(a)||(a=new w);var o=a.center;return e.add(r,t,o),e.multiplyByScalar(o,.5,o),a.radius=e.distance(o,t),a},w.fromEllipsoid=function(r,t){if(!n(r))throw new i("ellipsoid is required.");return n(t)||(t=new w),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t},w.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new w(r.center,r.radius):void 0},w.packedLength=4,w.pack=function(e,r,a){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");a=t(a,0);var o=e.center;r[a++]=o.x,r[a++]=o.y,r[a++]=o.z,r[a]=e.radius},w.unpack=function(e,r,a){if(!n(e))throw new i("array is required");r=t(r,0),n(a)||(a=new w);var o=a.center;return o.x=e[r++],o.y=e[r++],o.z=e[r++],a.radius=e[r],a};var _=new e,N=new e;w.union=function(r,t,a){if(!n(r))throw new i("left is required.");if(!n(t))throw new i("right is required.");n(a)||(a=new w);var o=r.center,u=t.center;e.add(o,u,N);var s=e.multiplyByScalar(N,.5,N),h=e.magnitude(e.subtract(o,s,_))+r.radius,f=e.magnitude(e.subtract(u,s,_))+t.radius;return a.radius=Math.max(h,f),e.clone(s,a.center),a};var R=new e;w.expand=function(r,t,a){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("point is required.");a=w.clone(r,a);var o=e.magnitude(e.subtract(t,a.center,R));return o>a.radius&&(a.radius=o),a},w.intersect=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("plane is required.");var a=r.center,o=r.radius,s=e.dot(t,a)+t.w;return-o>s?u.OUTSIDE:o>s?u.INTERSECTING:u.INSIDE},w.transform=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new w),t.center=h.multiplyByPoint(r,e.center,t.center),t.radius=h.getMaximumScale(r)*e.radius,t};var A=new e;w.distanceSquaredTo=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("cartesian is required.");var a=e.subtract(r.center,t,A);return e.magnitudeSquared(a)-r.radius*r.radius},w.transformWithoutScale=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new w),t.center=h.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var P=new e;w.getPlaneDistances=function(r,t,a,o){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("position is required.");if(!n(a))throw new i("direction is required.");n(o)||(o=new s);var u=e.subtract(r.center,t,P),h=e.multiplyByScalar(a,e.dot(a,u),P),f=e.magnitude(h);return o.start=f-r.radius,o.stop=f+r.radius,o};for(var C=new e,L=new e,U=new e,D=new e,B=new e,F=new r,W=new Array(8),V=0;8>V;++V)W[V]=new e;var G=new o;return w.projectTo2D=function(r,a,o){if(!n(r))throw new i("sphere is required.");a=t(a,G);var u=a.ellipsoid,s=r.center,h=r.radius,f=u.geodeticSurfaceNormal(s,C),c=e.cross(e.UNIT_Z,f,L);e.normalize(c,c);var l=e.cross(f,c,U);e.normalize(l,l),e.multiplyByScalar(f,h,f),e.multiplyByScalar(l,h,l),e.multiplyByScalar(c,h,c);var d=e.negate(l,B),m=e.negate(c,D),y=W,p=y[0];e.add(f,l,p),e.add(p,c,p),p=y[1],e.add(f,l,p),e.add(p,m,p),p=y[2],e.add(f,d,p),e.add(p,m,p),p=y[3],e.add(f,d,p),e.add(p,c,p),e.negate(f,f),p=y[4],e.add(f,l,p),e.add(p,c,p),p=y[5],e.add(f,l,p),e.add(p,m,p),p=y[6],e.add(f,d,p),e.add(p,m,p),p=y[7],e.add(f,d,p),e.add(p,c,p);for(var q=y.length,g=0;q>g;++g){var x=y[g];e.add(s,x,x);var v=u.cartesianToCartographic(x,F);a.project(v,x)}o=w.fromPoints(y,o),s=o.center;var b=s.x,E=s.y,M=s.z;return s.x=M,s.y=b,s.z=E,o},w.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius
},w.prototype.intersect=function(e){return w.intersect(this,e)},w.prototype.equals=function(e){return w.equals(this,e)},w.prototype.clone=function(e){return w.clone(this,e)},w}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t){this.x=e(r,0),this.y=e(t,0)};a.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new a(e,t)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a]=n.y},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i],o},a.fromArray=a.unpack,a.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y)},a.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y)},a.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i},a.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n};var u=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,u),o=a.multiplyByScalar(e,1-i,o),a.add(u,o,o)};var s=new a,h=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return a.normalize(e,s),a.normalize(n,h),i.acosClamped(a.dot(s,h))};var f=new a;return a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,f);return a.abs(i,i),n=i.x<=i.y?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Y,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i},a.ZERO=n(new a(0,0)),a.UNIT_X=n(new a(1,0)),a.UNIT_Y=n(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;u>o;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=s+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=s+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=s+"fullscreenchange",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(c)){var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null===e?c=!1:(c=!0,l=n(e[1]))}return c}function a(){return i()&&l}function o(){if(!r(d))if(i()||!/ Safari\/[\.0-9]+/.test(navigator.userAgent))d=!1;else{var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null===e?d=!1:(d=!0,m=n(e[1]))}return d}function u(){return o()&&m}function s(){if(!r(y)){var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null===e?y=!1:(y=!0,p=n(e[1]),p.isNightly=!!e[2])}return y}function h(){return s()&&p}function f(){if(!r(q)){var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(q=!0,g=n(e[1]))):"Netscape"===navigator.appName?(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(q=!0,g=n(e[1]))):q=!1}return q}function w(){return f()&&g}var c,l,d,m,y,p,q,g,x={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:h,isInternetExplorer:f,internetExplorerVersion:w,hardwareConcurrency:e(navigator.hardwareConcurrency,3)};return x.supportsFullscreen=function(){return t.supportsFullscreen()},x.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},x}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection"],function(e,r,t,n){"use strict";if(!n.supportsTypedArrays())return{};var i={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return i.getSizeInBytes=function(e){if(!r(e))throw new t("value is required.");switch(e){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new t("componentDatatype is not a valid value.")}},i.fromTypedArray=function(e){return e instanceof Int8Array?i.BYTE:e instanceof Uint8Array?i.UNSIGNED_BYTE:e instanceof Int16Array?i.SHORT:e instanceof Uint16Array?i.UNSIGNED_SHORT:e instanceof Float32Array?i.FLOAT:e instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(e){return r(e)&&(e===i.BYTE||e===i.UNSIGNED_BYTE||e===i.SHORT||e===i.UNSIGNED_SHORT||e===i.FLOAT||e===i.DOUBLE)},i.createTypedArray=function(e,n){if(!r(e))throw new t("componentDatatype is required.");if(!r(n))throw new t("valuesOrLength is required.");switch(e){case i.BYTE:return new Int8Array(n);case i.UNSIGNED_BYTE:return new Uint8Array(n);case i.SHORT:return new Int16Array(n);case i.UNSIGNED_SHORT:return new Uint16Array(n);case i.FLOAT:return new Float32Array(n);case i.DOUBLE:return new Float64Array(n);default:throw new t("componentDatatype is not a valid value.")}},i.createArrayBufferView=function(n,a,o,u){if(!r(n))throw new t("componentDatatype is required.");if(!r(a))throw new t("buffer is required.");switch(o=e(o,0),u=e(u,(a.byteLength-o)/i.getSizeInBytes(n)),n){case i.BYTE:return new Int8Array(a,o,u);case i.UNSIGNED_BYTE:return new Uint8Array(a,o,u);case i.SHORT:return new Int16Array(a,o,u);case i.UNSIGNED_SHORT:return new Uint16Array(a,o,u);case i.FLOAT:return new Float32Array(a,o,u);case i.DOUBLE:return new Float64Array(a,o,u);default:throw new t("componentDatatype is not a valid value.")}},i}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.attributes))throw new t("options.attributes is required.");if(!r(n.primitiveType))throw new t("options.primitiveType is required.");this.attributes=n.attributes,this.indices=n.indices,this.primitiveType=n.primitiveType,this.boundingSphere=n.boundingSphere};return n.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&r(e.attributes[i])&&r(e.attributes[i].values)){var a=e.attributes[i],o=a.values.length/a.componentsPerAttribute;if(n!==o&&-1!==n)throw new t("All attribute lists must have the same number of attributes.");n=o}return n},n}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(n.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(n.values))throw new t("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/IndexDatatype",["./defined","./DeveloperError","./Math"],function(e,r,t){"use strict";var n={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return n.getSizeInBytes=function(e){switch(e){case n.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case n.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case n.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new r("indexDatatype is required and must be a valid IndexDatatype constant.")},n.validate=function(r){return e(r)&&(r===n.UNSIGNED_BYTE||r===n.UNSIGNED_SHORT||r===n.UNSIGNED_INT)},n.createTypedArray=function(n,i){if(!e(n))throw new r("numberOfVertices is required.");return n>t.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},n}),define("Core/PrimitiveType",[],function(){"use strict";var e={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(r){return r===e.POINTS||r===e.LINES||r===e.LINE_LOOP||r===e.LINE_STRIP||r===e.TRIANGLES||r===e.TRIANGLE_STRIP||r===e.TRIANGLE_FAN}};return e}),define("Core/VertexFormat",["./defaultValue","./freezeObject"],function(e,r){"use strict";var t=function(r){r=e(r,e.EMPTY_OBJECT),this.position=e(r.position,!1),this.normal=e(r.normal,!1),this.st=e(r.st,!1),this.binormal=e(r.binormal,!1),this.tangent=e(r.tangent,!1)};return t.POSITION_ONLY=r(new t({position:!0})),t.POSITION_AND_NORMAL=r(new t({position:!0,normal:!0})),t.POSITION_NORMAL_AND_ST=r(new t({position:!0,normal:!0,st:!0})),t.POSITION_AND_ST=r(new t({position:!0,st:!0})),t.ALL=r(new t({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),t.DEFAULT=t.POSITION_NORMAL_AND_ST,t}),define("Core/EllipsoidGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat"],function(e,r,t,n,i,a,o,u,s,h,f,w,c,l){"use strict";var d=new t,m=new t,y=new t,p=new t,q=new t,g=new t(1,1,1),x=Math.cos,v=Math.sin,b=function(e){e=i(e,i.EMPTY_OBJECT);var r=i(e.radii,g),n=i(e.stackPartitions,64),o=i(e.slicePartitions,64),u=i(e.vertexFormat,l.DEFAULT);if(3>o)throw new a("options.slicePartitions cannot be less than three.");if(3>n)throw new a("options.stackPartitions cannot be less than three.");this._radii=t.clone(r),this._stackPartitions=n,this._slicePartitions=o,this._vertexFormat=u,this._workerName="createEllipsoidGeometry"};return b.createGeometry=function(i){var a,l,g=i._radii,b=o.fromCartesian3(g),E=i._vertexFormat,M=i._slicePartitions+1,S=i._stackPartitions+1,z=S*M,O=new Float64Array(3*z),T=6*(M-1)*(S-1),I=f.createTypedArray(z,T),_=E.normal?new Float32Array(3*z):void 0,N=E.tangent?new Float32Array(3*z):void 0,R=E.binormal?new Float32Array(3*z):void 0,A=E.st?new Float32Array(2*z):void 0,P=new Array(M),C=new Array(M),L=0;for(a=0;M>a;a++){var U=w.TWO_PI*a/(M-1);P[a]=x(U),C[a]=v(U),O[L++]=0,O[L++]=0,O[L++]=g.z}for(a=1;S-1>a;a++){var D=Math.PI*a/(S-1),B=v(D),F=g.x*B,W=g.y*B,V=g.z*x(D);for(l=0;M>l;l++)O[L++]=P[l]*F,O[L++]=C[l]*W,O[L++]=V}for(a=0;M>a;a++)O[L++]=0,O[L++]=0,O[L++]=-g.z;var G=new h;E.position&&(G.position=new s({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:O}));var Y=0,k=0,j=0,H=0;if(E.st||E.normal||E.tangent||E.binormal){for(a=0;z>a;a++){var Z=t.fromArray(O,3*a,d),X=b.geodeticSurfaceNormal(Z,m);if(E.st){var K=r.negate(X,q);r.magnitude(K)<w.EPSILON6&&(L=3*(a+M*Math.floor(.5*S)),L>O.length&&(L=3*(a-M*Math.floor(.5*S))),t.fromArray(O,L,K),b.geodeticSurfaceNormal(K,K),r.negate(K,K)),A[Y++]=Math.atan2(K.y,K.x)/w.TWO_PI+.5,A[Y++]=Math.asin(X.z)/Math.PI+.5}if(E.normal&&(_[k++]=X.x,_[k++]=X.y,_[k++]=X.z),E.tangent||E.binormal){var J=y;if(M>a||a>z-M-1?(t.cross(t.UNIT_X,X,J),t.normalize(J,J)):(t.cross(t.UNIT_Z,X,J),t.normalize(J,J)),E.tangent&&(N[j++]=J.x,N[j++]=J.y,N[j++]=J.z),E.binormal){var Q=t.cross(X,J,p);t.normalize(Q,Q),R[H++]=Q.x,R[H++]=Q.y,R[H++]=Q.z}}}E.st&&(G.st=new s({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:A})),E.normal&&(G.normal=new s({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:_})),E.tangent&&(G.tangent=new s({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:N})),E.binormal&&(G.binormal=new s({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:R}))}for(L=0,a=0;S>a;a++){var $=a*M,er=(a+1)*M;for(l=0;M-1>l;l++)I[L++]=er+l,I[L++]=er+l+1,I[L++]=$+l+1,I[L++]=er+l,I[L++]=$+l+1,I[L++]=$+l}return new u({attributes:G,indices:I,primitiveType:c.TRIANGLES,boundingSphere:e.fromEllipsoid(b)})},b}),define("Workers/createEllipsoidGeometry",["../Core/EllipsoidGeometry"],function(e){"use strict";return e.createGeometry})}();