/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2014 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=.5*3*Math.PI,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,a=e-Math.floor(e/r)*r;return a<-Math.PI?a+r:a>=Math.PI?a-r:a},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");for(var r=i.EPSILON10,a=i.PI,o=i.TWO_PI;-(a+r)>e;)e+=o;if(-a>e)return-a;for(;e>a+r;)e-=o;return e>a?a:e},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=e%i.TWO_PI;return 0>r?(r+i.TWO_PI)%i.TWO_PI:r},i.equalsEpsilon=function(e,i,a){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");return a=r(a,0),Math.abs(e-i)<=a};var a=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=a.length;if(e>=r)for(var t=a[r-1],i=r;e>=i;i++)a.push(t*i);return a[e]},i.incrementWrap=function(e,i,a){if(a=r(a,0),!t(e))throw new n("n is required.");if(a>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=a),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var o=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");o=new e(r)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){return Math.asin(i.clamp(e,-1,1))},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};a.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new a);var o=n.clock,s=n.cone,u=e(n.magnitude,1),l=u*Math.sin(s);return i.x=l*Math.cos(o),i.y=l*Math.sin(o),i.z=u*Math.cos(s),i},a.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new a(e,t,n)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a]=n.z},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i],o},a.fromArray=a.unpack,a.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},a.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},a.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},a.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var s=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,s),o=a.multiplyByScalar(e,1-i,o),a.add(s,o,o)};var u=new a,l=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");a.normalize(e,u),a.normalize(n,l);var i=a.dot(u,l),o=a.magnitude(a.cross(u,l,u));return Math.atan2(o,i)};var f=new a;a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,f);return a.abs(i,i),n=i.x<=i.y?i.x<=i.z?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Z,n):i.y<=i.z?a.clone(a.UNIT_Y,n):a.clone(a.UNIT_Z,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i},a.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var a=e.x,o=e.y,s=e.z,u=n.x,l=n.y,f=n.z,c=o*f-s*l,h=s*u-a*f,d=a*l-o*u;return i.x=c,i.y=h,i.z=d,i},a.fromDegrees=function(e,n,o,s,u){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var l=i.toRadians(e),f=i.toRadians(n);return a.fromRadians(l,f,o,s,u)};var c=new a,h=new a,d=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,i,o,s,u){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");o=e(o,0);var l=r(s)?s.radiiSquared:d,f=Math.cos(i);c.x=f*Math.cos(n),c.y=f*Math.sin(n),c.z=Math.sin(i),c=a.normalize(c,c),a.multiplyComponents(l,c,h);var w=Math.sqrt(a.dot(c,h));return h=a.divideByScalar(h,w,h),c=a.multiplyByScalar(c,o,c),r(u)||(u=new a),a.add(h,c,u)},a.fromDegreesArray=function(e,n,o){if(!r(e))throw new t("positions is required.");for(var s=new Array(e.length),u=0;u<e.length;u++)s[u]=i.toRadians(e[u]);return a.fromRadiansArray(s,n,o)},a.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(0!==e.length%2)throw new t("positions length must be a multiple of 2.");var o=e.length;r(i)?i.length=o/2:i=new Array(o/2);for(var s=0;o>s;s+=2){var u=e[s],l=e[s+1];i[s/2]=a.fromRadians(u,l,0,n,i[s/2])}return i},a.fromDegreesArrayHeights=function(e,n,o){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");for(var s=new Array(e.length),u=0;u<e.length;u+=3)s[u]=i.toRadians(e[u]),s[u+1]=i.toRadians(e[u+1]),s[u+2]=e[u+2];return a.fromRadiansArrayHeights(s,n,o)},a.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");var o=e.length;r(i)?i.length=o/3:i=new Array(o/3);for(var s=0;o>s;s+=3){var u=e[s],l=e[s+1],f=e[s+2];i[s/3]=a.fromRadians(u,l,f,n,i[s/3])}return i},a.ZERO=n(new a(0,0,0)),a.UNIT_X=n(new a(1,0,0)),a.UNIT_Y=n(new a(0,1,0)),a.UNIT_Z=n(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return a.fromRadians=function(n,i,o,s){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return o=e(o,0),r(s)?(s.longitude=n,s.latitude=i,s.height=o,s):new a(n,i,o)},a.fromDegrees=function(e,n,o,s){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),a.fromRadians(e,n,o,s)},a.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new a(e.longitude,e.latitude,e.height):void 0},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},a.toString=function(e){if(!r(e))throw new t("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},a.ZERO=n(new a(0,0,0)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return a.toString(this)},a}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a,o,s){"use strict";var u=function(r,n,i){if(r=t(r,0),n=t(n,0),i=t(i,0),0>r||0>n||0>i)throw new a("All radii components must be greater than or equal to zero.");this._radii=new e(r,n,i),this._radiiSquared=new e(r*r,n*n,i*i),this._radiiToTheFourth=new e(r*r*r*r,n*n*n*n,i*i*i*i),this._oneOverRadii=new e(0===r?0:1/r,0===n?0:1/n,0===i?0:1/i),this._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===n?0:1/(n*n),0===i?0:1/(i*i)),this._minimumRadius=Math.min(r,n,i),this._maximumRadius=Math.max(r,n,i),this._centerToleranceSquared=s.EPSILON1};i(u.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),u.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new u(i.x,i.y,i.z)},u.fromCartesian3=function(e){return n(e)?new u(e.x,e.y,e.z):new u},u.WGS84=o(new u(6378137,6378137,6356752.314245179)),u.UNIT_SPHERE=o(new u(1,1,1)),u.MOON=o(new u(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.geocentricSurfaceNormal=e.normalize,u.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new a("cartographic is required.");var i=r.longitude,o=r.latitude,s=Math.cos(o),u=s*Math.cos(i),l=s*Math.sin(i),f=Math.sin(o);return n(t)||(t=new e),t.x=u,t.y=l,t.z=f,e.normalize(t,t)},u.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var l=new e,f=new e;u.prototype.cartographicToCartesian=function(r,t){var i=l,a=f;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(a,i,t)},u.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new a("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var c=new e,h=new e,d=new e;u.prototype.cartesianToCartographic=function(t,i){var a=this.scaleToGeodeticSurface(t,h);if(!n(a))return void 0;var o=this.geodeticSurfaceNormal(a,c),u=e.subtract(t,a,d),l=Math.atan2(o.y,o.x),f=Math.asin(o.z),w=s.sign(e.dot(u,t))*e.magnitude(u);return n(i)?(i.longitude=l,i.latitude=f,i.height=w,i):new r(l,f,w)},u.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new a("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var w=new e,m=new e;return u.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");var i=r.x,o=r.y,u=r.z,l=this._oneOverRadii,f=l.x,c=l.y,h=l.z,d=i*i*f*f,y=o*o*c*c,p=u*u*h*h,v=d+y+p,g=Math.sqrt(1/v),q=e.multiplyByScalar(r,g,w);if(v<this._centerToleranceSquared)return isFinite(g)?e.clone(q,t):void 0;var x=this._oneOverRadiiSquared,b=x.x,E=x.y,S=x.z,M=m;M.x=2*q.x*b,M.y=2*q.y*E,M.z=2*q.z*S;var _,O,T,P,A,N,z,R,C,I,D,U=(1-g)*e.magnitude(r)/(.5*e.magnitude(M)),L=0;do{U-=L,T=1/(1+U*b),P=1/(1+U*E),A=1/(1+U*S),N=T*T,z=P*P,R=A*A,C=N*T,I=z*P,D=R*A,_=d*N+y*z+p*R-1,O=d*C*b+y*I*E+p*D*S;var B=-2*O;L=_/B}while(Math.abs(_)>s.EPSILON12);return n(t)?(t.x=i*T,t.y=o*P,t.z=u*A,t):new e(i*T,o*P,u*A)},u.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");n(t)||(t=new e);var i=r.x,o=r.y,s=r.z,u=this._oneOverRadiiSquared,l=1/Math.sqrt(i*i*u.x+o*o*u.y+s*s*u.z);return e.multiplyByScalar(r,l,t)},u.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},u.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},u.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},u.prototype.toString=function(){return this._radii.toString()},u}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,a,o){"use strict";var s=function(e){this._ellipsoid=t(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(r,t){var i=this._semimajorAxis,a=r.longitude*i,o=r.latitude*i,s=r.height;return n(t)?(t.x=a,t.y=o,t.z=s,t):new e(a,o,s)},s.prototype.unproject=function(e,t){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,s=e.y*i,u=e.z;return n(t)?(t.longitude=o,t.latitude=s,t.height=u,t):new r(o,s,u)},s}),define("Core/Intersect",[],function(){"use strict";var e={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};i.fromElements=function(e,t,n,a,o){return r(o)?(o.x=e,o.y=t,o.z=n,o.w=a,o):new i(e,t,n,a)},i.fromColor=function(e,n){if(!r(e))throw new t("color is required");return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a++]=n.z,i[a]=n.w},i.unpack=function(n,a,o){if(!r(n))throw new t("array is required");return a=e(a,0),r(o)||(o=new i),o.x=n[a++],o.y=n[a++],o.z=n[a++],o.w=n[a],o},i.fromArray=i.unpack,i.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},i.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},i.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},i.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},i.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return i.subtract(e,n,a),i.magnitude(a)},i.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var a=i.magnitude(e);return n.x=e.x/a,n.y=e.y/a,n.z=e.z/a,n.w=e.w/a,n},i.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},i.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},i.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},i.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},i.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},i.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},i.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},i.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var o=new i;i.lerp=function(e,n,a,s){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof a)throw new t("t is required and must be a number.");if(!r(s))throw new t("result is required.");return i.multiplyByScalar(n,a,o),s=i.multiplyByScalar(e,1-a,s),i.add(o,s,s)};var s=new i;return i.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var a=i.normalize(e,s);return i.abs(a,a),n=a.x<=a.y?a.x<=a.z?a.x<=a.w?i.clone(i.UNIT_X,n):i.clone(i.UNIT_W,n):a.z<=a.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n):a.y<=a.z?a.y<=a.w?i.clone(i.UNIT_Y,n):i.clone(i.UNIT_W,n):a.z<=a.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},i.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i&&Math.abs(e.w-n.w)<=i},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,r){return i.equalsEpsilon(this,e,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a){"use strict";function o(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function s(e){for(var r=0,t=0;3>t;++t){var n=e[l.getElementIndex(d[t],h[t])];r+=2*n*n}return Math.sqrt(r)}function u(e,r){for(var t=a.EPSILON15,n=0,i=1,o=0;3>o;++o){var s=Math.abs(e[l.getElementIndex(d[o],h[o])]);s>n&&(i=o,n=s)}var u=1,f=0,c=h[i],w=d[i];if(Math.abs(e[l.getElementIndex(w,c)])>t){var m,y=e[l.getElementIndex(w,w)],p=e[l.getElementIndex(c,c)],v=e[l.getElementIndex(w,c)],g=(y-p)/2/v;m=0>g?-1/(-g+Math.sqrt(1+g*g)):1/(g+Math.sqrt(1+g*g)),u=1/Math.sqrt(1+m*m),f=m*u}return r=l.clone(l.IDENTITY,r),r[l.getElementIndex(c,c)]=r[l.getElementIndex(w,w)]=u,r[l.getElementIndex(w,c)]=f,r[l.getElementIndex(c,w)]=-f,r}var l=function(e,t,n,i,a,o,s,u,l){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(s,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(u,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(l,0)};l.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new l(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},l.fromArray=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new l),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a[9]=e[i+9],a},l.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return l.clone(e,r)},l.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},l.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,s=e.x*e.w,u=e.y*e.y,f=e.y*e.z,c=e.y*e.w,h=e.z*e.z,d=e.z*e.w,w=e.w*e.w,m=i-u-h+w,y=2*(a-d),p=2*(o+c),v=2*(a+d),g=-i+u-h+w,q=2*(f-s),x=2*(o-c),b=2*(f+s),E=-i-u+h+w;return t(r)?(r[0]=m,r[1]=v,r[2]=x,r[3]=y,r[4]=g,r[5]=b,r[6]=p,r[7]=q,r[8]=E,r):new l(m,y,p,v,g,q,x,b,E)},l.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new l(e.x,0,0,0,e.y,0,0,0,e.z)},l.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new l(e,0,0,0,e,0,0,0,e)},l.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=a,r[6]=0,r[7]=-a,r[8]=i,r):new l(1,0,0,0,i,-a,0,a,i)},l.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=i,r):new l(i,0,a,0,1,0,-a,0,i)},l.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=a,r[2]=0,r[3]=-a,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new l(i,-a,0,a,i,0,0,0,1)},l.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},l.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},l.getColumn=function(r,i,a){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var o=3*i,s=r[o],u=r[o+1],l=r[o+2];return t(a)?(a.x=s,a.y=u,a.z=l,a):new e(s,u,l)},l.setColumn=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");a=l.clone(e,a);var o=3*r;return a[o]=i.x,a[o+1]=i.y,a[o+2]=i.z,a},l.getRow=function(r,i,a){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var o=r[i],s=r[i+3],u=r[i+6];return t(a)?(a.x=o,a.y=s,a.z=u,a):new e(o,s,u)},l.setRow=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");return a=l.clone(e,a),a[r]=i.x,a[r+3]=i.y,a[r+6]=i.z,a};var f=new e;l.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");return t(i)||(i=new e),i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],f)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],f)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],f)),i};var c=new e;l.getMaximumScale=function(r){return l.getScale(r,c),e.getMaximumComponent(c)},l.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");var a=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],o=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],s=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],f=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],h=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],d=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],w=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return t(i)?(i[0]=a,i[1]=o,i[2]=s,i[3]=u,i[4]=f,i[5]=c,i[6]=h,i[7]=d,i[8]=w,i):new l(a,u,h,o,f,d,s,c,w)},l.multiplyByVector=function(r,i,a){if(!t(r))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");var o=i.x,s=i.y,u=i.z,l=r[0]*o+r[3]*s+r[6]*u,f=r[1]*o+r[4]*s+r[7]*u,c=r[2]*o+r[5]*s+r[8]*u;return t(a)?(a.x=l,a.y=f,a.z=c,a):new e(l,f,c)},l.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");return t(i)?(i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i):new l(e[0]*r,e[3]*r,e[6]*r,e[1]*r,e[4]*r,e[7]*r,e[2]*r,e[5]*r,e[8]*r)},l.negate=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r):new l(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},l.transpose=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],a=e[3],o=e[6],s=e[1],u=e[4],f=e[7],c=e[2],h=e[5],d=e[8];return t(r)?(r[0]=i,r[1]=a,r[2]=o,r[3]=s,r[4]=u,r[5]=f,r[6]=c,r[7]=h,r[8]=d,r):new l(i,s,c,a,u,h,o,f,d)};var h=[1,0,0],d=[2,2,1],w=new l,m=new l;return l.getEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=a.EPSILON20,f=10,c=0,h=0;
t(r)||(r={});for(var d=r.unitary=l.clone(l.IDENTITY,r.unitary),y=r.diagonal=l.clone(e,r.diagonal),p=i*o(y);f>h&&s(y)>p;)u(y,w),l.transpose(w,m),l.multiply(y,w,y),l.multiply(m,y,y),l.multiply(d,w,d),++c>2&&(++h,c=0);return r},l.abs=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r):new l(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},l.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],a=e[6],o=e[1],s=e[4],u=e[7],l=e[2],f=e[5],c=e[8];return r*(s*c-f*u)+o*(f*a-i*c)+l*(i*u-s*a)},l.inverse=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],o=e[1],s=e[2],u=e[3],f=e[4],c=e[5],h=e[6],d=e[7],w=e[8],m=l.determinant(e);if(Math.abs(m)<=a.EPSILON15)throw new n("matrix is not invertible");t(r)||(r=new l),r[0]=f*w-d*c,r[1]=d*s-o*w,r[2]=o*c-f*s,r[3]=h*c-u*w,r[4]=i*w-h*s,r[5]=u*s-i*c,r[6]=u*d-h*f,r[7]=h*o-i*d,r[8]=i*f-u*o;var y=1/m;return l.multiplyByScalar(r,y,r)},l.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},l.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},l.IDENTITY=i(new l(1,0,0,0,1,0,0,0,1)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN1ROW0=3,l.COLUMN1ROW1=4,l.COLUMN1ROW2=5,l.COLUMN2ROW0=6,l.COLUMN2ROW1=7,l.COLUMN2ROW2=8,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,r){return l.equalsEpsilon(this,e,r)},l.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},l}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,a,o,s,u){"use strict";var l=function(e,r,n,i,a,o,s,u,l,f,c,h,d,w,m,y){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(l,0),this[3]=t(d,0),this[4]=t(r,0),this[5]=t(o,0),this[6]=t(f,0),this[7]=t(w,0),this[8]=t(n,0),this[9]=t(s,0),this[10]=t(c,0),this[11]=t(m,0),this[12]=t(i,0),this[13]=t(u,0),this[14]=t(h,0),this[15]=t(y,0)};l.packedLength=16,l.pack=function(e,r,a){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");a=t(a,0),r[a++]=e[0],r[a++]=e[1],r[a++]=e[2],r[a++]=e[3],r[a++]=e[4],r[a++]=e[5],r[a++]=e[6],r[a++]=e[7],r[a++]=e[8],r[a++]=e[9],r[a++]=e[10],r[a++]=e[11],r[a++]=e[12],r[a++]=e[13],r[a++]=e[14],r[a]=e[15]},l.unpack=function(e,r,a){if(!n(e))throw new i("array is required");return r=t(r,0),n(a)||(a=new l),a[0]=e[r++],a[1]=e[r++],a[2]=e[r++],a[3]=e[r++],a[4]=e[r++],a[5]=e[r++],a[6]=e[r++],a[7]=e[r++],a[8]=e[r++],a[9]=e[r++],a[10]=e[r++],a[11]=e[r++],a[12]=e[r++],a[13]=e[r++],a[14]=e[r++],a[15]=e[r],a},l.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new l(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},l.fromArray=l.unpack,l.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return l.clone(e,r)},l.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},l.fromRotationTranslation=function(e,r,t){if(!n(e))throw new i("rotation is required.");if(!n(r))throw new i("translation is required.");return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=0,t[4]=e[3],t[5]=e[4],t[6]=e[5],t[7]=0,t[8]=e[6],t[9]=e[7],t[10]=e[8],t[11]=0,t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=1,t):new l(e[0],e[3],e[6],r.x,e[1],e[4],e[7],r.y,e[2],e[5],e[8],r.z,0,0,0,1)},new s,l.fromTranslationQuaternionRotationScale=function(e,r,t,a){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(a)||(a=new l);var o=t.x,s=t.y,u=t.z,f=r.x*r.x,c=r.x*r.y,h=r.x*r.z,d=r.x*r.w,w=r.y*r.y,m=r.y*r.z,y=r.y*r.w,p=r.z*r.z,v=r.z*r.w,g=r.w*r.w,q=f-w-p+g,x=2*(c-v),b=2*(h+y),E=2*(c+v),S=-f+w-p+g,M=2*(m-d),_=2*(h-y),O=2*(m+d),T=-f-w+p+g;return a[0]=q*o,a[1]=E*o,a[2]=_*o,a[3]=0,a[4]=x*s,a[5]=S*s,a[6]=O*s,a[7]=0,a[8]=b*u,a[9]=M*u,a[10]=T*u,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},l.fromTranslation=function(e,r){return l.fromRotationTranslation(s.IDENTITY,e,r)},l.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new l(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},l.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new l(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var f=new e,c=new e,h=new e;l.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var a=r.eye,o=r.target,s=r.up;if(!n(a))throw new i("camera.eye is required.");if(!n(o))throw new i("camera.target is required.");if(!n(s))throw new i("camera.up is required.");e.normalize(e.subtract(o,a,f),f),e.normalize(e.cross(f,s,c),c),e.normalize(e.cross(c,f,h),h);var u=c.x,d=c.y,w=c.z,m=f.x,y=f.y,p=f.z,v=h.x,g=h.y,q=h.z,x=a.x,b=a.y,E=a.z,S=u*-x+d*-b+w*-E,M=v*-x+g*-b+q*-E,_=m*x+y*b+p*E;return n(t)?(t[0]=u,t[1]=v,t[2]=-m,t[3]=0,t[4]=d,t[5]=g,t[6]=-y,t[7]=0,t[8]=w,t[9]=q,t[10]=-p,t[11]=0,t[12]=S,t[13]=M,t[14]=_,t[15]=1,t):new l(u,d,w,S,v,g,q,M,-m,-y,-p,_,0,0,0,1)},l.computePerspectiveFieldOfView=function(e,r,t,a,o){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=a)throw new i("far must be greater than zero.");var s=Math.tan(.5*e),u=1/s,f=u/r,c=(a+t)/(t-a),h=2*a*t/(t-a);return n(o)?(o[0]=f,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=u,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=-1,o[12]=0,o[13]=0,o[14]=h,o[15]=0,o):new l(f,0,0,0,0,u,0,0,0,0,c,h,0,0,-1,0)},l.computeOrthographicOffCenter=function(e,r,t,a,o,s,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(s))throw new i("far is required.");var f=1/(r-e),c=1/(a-t),h=1/(s-o),d=-(r+e)*f,w=-(a+t)*c,m=-(s+o)*h;return f*=2,c*=2,h*=-2,n(u)?(u[0]=f,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=h,u[11]=0,u[12]=d,u[13]=w,u[14]=m,u[15]=1,u):new l(f,0,0,d,0,c,0,w,0,0,h,m,0,0,0,1)},l.computePerspectiveOffCenter=function(e,r,t,a,o,s,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(s))throw new i("far is required.");var f=2*o/(r-e),c=2*o/(a-t),h=(r+e)/(r-e),d=(a+t)/(a-t),w=-(s+o)/(s-o),m=-1,y=-2*s*o/(s-o);return n(u)?(u[0]=f,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=h,u[9]=d,u[10]=w,u[11]=m,u[12]=0,u[13]=0,u[14]=y,u[15]=0,u):new l(f,0,h,0,0,c,d,0,0,0,w,y,0,0,m,0)},l.computeInfinitePerspectiveOffCenter=function(e,r,t,a,o,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");var u=2*o/(r-e),f=2*o/(a-t),c=(r+e)/(r-e),h=(a+t)/(a-t),d=-1,w=-1,m=-2*o;return n(s)?(s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=f,s[6]=0,s[7]=0,s[8]=c,s[9]=h,s[10]=d,s[11]=w,s[12]=0,s[13]=0,s[14]=m,s[15]=0,s):new l(u,0,c,0,0,f,h,0,0,0,d,m,0,0,w,0)},l.computeViewportTransformation=function(e,r,i,a){e=t(e,t.EMPTY_OBJECT);var o=t(e.x,0),s=t(e.y,0),u=t(e.width,0),f=t(e.height,0);r=t(r,0),i=t(i,1);var c=.5*u,h=.5*f,d=.5*(i-r),w=c,m=h,y=d,p=o+c,v=s+h,g=r+d,q=1;return n(a)?(a[0]=w,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=m,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=y,a[11]=0,a[12]=p,a[13]=v,a[14]=g,a[15]=q,a):new l(w,0,0,p,0,m,0,v,0,0,y,g,0,0,0,q)},l.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},l.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},l.getColumn=function(e,t,a){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var o=4*t,s=e[o],u=e[o+1],l=e[o+2],f=e[o+3];return n(a)?(a.x=s,a.y=u,a.z=l,a.w=f,a):new r(s,u,l,f)},l.setColumn=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");a=l.clone(e,a);var o=4*r;return a[o]=t.x,a[o+1]=t.y,a[o+2]=t.z,a[o+3]=t.w,a},l.getRow=function(e,t,a){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var o=e[t],s=e[t+4],u=e[t+8],l=e[t+12];return n(a)?(a.x=o,a.y=s,a.z=u,a.w=l,a):new r(o,s,u,l)},l.setRow=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");return a=l.clone(e,a),a[r]=t.x,a[r+4]=t.y,a[r+8]=t.z,a[r+12]=t.w,a};var d=new e;l.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");return n(t)||(t=new e),t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],d)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],d)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],d)),t};var w=new e;l.getMaximumScale=function(r){return l.getScale(r,w),e.getMaximumComponent(w)},l.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var a=e[0],o=e[1],s=e[2],u=e[3],f=e[4],c=e[5],h=e[6],d=e[7],w=e[8],m=e[9],y=e[10],p=e[11],v=e[12],g=e[13],q=e[14],x=e[15],b=r[0],E=r[1],S=r[2],M=r[3],_=r[4],O=r[5],T=r[6],P=r[7],A=r[8],N=r[9],z=r[10],R=r[11],C=r[12],I=r[13],D=r[14],U=r[15],L=a*b+f*E+w*S+v*M,B=o*b+c*E+m*S+g*M,F=s*b+h*E+y*S+q*M,W=u*b+d*E+p*S+x*M,G=a*_+f*O+w*T+v*P,V=o*_+c*O+m*T+g*P,j=s*_+h*O+y*T+q*P,Y=u*_+d*O+p*T+x*P,H=a*A+f*N+w*z+v*R,k=o*A+c*N+m*z+g*R,Z=s*A+h*N+y*z+q*R,X=u*A+d*N+p*z+x*R,J=a*C+f*I+w*D+v*U,Q=o*C+c*I+m*D+g*U,$=s*C+h*I+y*D+q*U,K=u*C+d*I+p*D+x*U;return n(t)?(t[0]=L,t[1]=B,t[2]=F,t[3]=W,t[4]=G,t[5]=V,t[6]=j,t[7]=Y,t[8]=H,t[9]=k,t[10]=Z,t[11]=X,t[12]=J,t[13]=Q,t[14]=$,t[15]=K,t):new l(L,G,H,J,B,V,k,Q,F,j,Z,$,W,Y,X,K)},l.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var a=e[0],o=e[1],s=e[2],u=e[4],f=e[5],c=e[6],h=e[8],d=e[9],w=e[10],m=e[12],y=e[13],p=e[14],v=r[0],g=r[1],q=r[2],x=r[4],b=r[5],E=r[6],S=r[8],M=r[9],_=r[10],O=r[12],T=r[13],P=r[14],A=a*v+u*g+h*q,N=o*v+f*g+d*q,z=s*v+c*g+w*q,R=a*x+u*b+h*E,C=o*x+f*b+d*E,I=s*x+c*b+w*E,D=a*S+u*M+h*_,U=o*S+f*M+d*_,L=s*S+c*M+w*_,B=a*O+u*T+h*P+m,F=o*O+f*T+d*P+y,W=s*O+c*T+w*P+p;return n(t)?(t[0]=A,t[1]=N,t[2]=z,t[3]=0,t[4]=R,t[5]=C,t[6]=I,t[7]=0,t[8]=D,t[9]=U,t[10]=L,t[11]=0,t[12]=B,t[13]=F,t[14]=W,t[15]=1,t):new l(A,R,D,B,N,C,U,F,z,I,L,W,0,0,0,1)},l.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");var a=r.x,o=r.y,s=r.z,u=a*e[0]+o*e[4]+s*e[8]+e[12],f=a*e[1]+o*e[5]+s*e[9]+e[13],c=a*e[2]+o*e[6]+s*e[10]+e[14];return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=u,t[13]=f,t[14]=c,t[15]=e[15],t):new l(e[0],e[4],e[8],u,e[1],e[5],e[9],f,e[2],e[6],e[10],c,e[3],e[7],e[11],e[15])};var m=new e;return l.multiplyByUniformScale=function(e,r,t){if("number"!=typeof r)throw new i("scale is required");return m.x=r,m.y=r,m.z=r,l.multiplyByScale(e,m,t)},l.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");var a=r.x,o=r.y,s=r.z;return 1===a&&1===o&&1===s?l.clone(e,t):n(t)?(t[0]=a*e[0],t[1]=a*e[1],t[2]=a*e[2],t[3]=0,t[4]=o*e[4],t[5]=o*e[5],t[6]=o*e[6],t[7]=0,t[8]=s*e[8],t[9]=s*e[9],t[10]=s*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t):new l(a*e[0],o*e[4],s*e[8],e[12],a*e[1],o*e[5],s*e[9],e[13],a*e[2],o*e[6],s*e[10],e[14],0,0,0,1)},l.multiplyByVector=function(e,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,s=t.y,u=t.z,l=t.w,f=e[0]*o+e[4]*s+e[8]*u+e[12]*l,c=e[1]*o+e[5]*s+e[9]*u+e[13]*l,h=e[2]*o+e[6]*s+e[10]*u+e[14]*l,d=e[3]*o+e[7]*s+e[11]*u+e[15]*l;return n(a)?(a.x=f,a.y=c,a.z=h,a.w=d,a):new r(f,c,h,d)},l.multiplyByPointAsVector=function(r,t,a){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,s=t.y,u=t.z,l=r[0]*o+r[4]*s+r[8]*u,f=r[1]*o+r[5]*s+r[9]*u,c=r[2]*o+r[6]*s+r[10]*u;return n(a)?(a.x=l,a.y=f,a.z=c,a):new e(l,f,c)},l.multiplyByPoint=function(r,t,a){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var o=t.x,s=t.y,u=t.z,l=r[0]*o+r[4]*s+r[8]*u+r[12],f=r[1]*o+r[5]*s+r[9]*u+r[13],c=r[2]*o+r[6]*s+r[10]*u+r[14];return n(a)?(a.x=l,a.y=f,a.z=c,a):new e(l,f,c)},l.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");return n(t)?(t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t):new l(e[0]*r,e[4]*r,e[8]*r,e[12]*r,e[1]*r,e[5]*r,e[9]*r,e[13]*r,e[2]*r,e[6]*r,e[10]*r,e[14]*r,e[3]*r,e[7]*r,e[11]*r,e[15]*r)},l.negate=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r):new l(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},l.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))return new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var t=e[1],a=e[2],o=e[3],s=e[6],u=e[7],f=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=a,r[9]=s,r[10]=e[10],r[11]=e[14],r[12]=o,r[13]=u,r[14]=f,r[15]=e[15],r},l.abs=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r):new l(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},l.equals=function(e,r){return e===r||n(e)&&n(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[11]===r[11]&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[15]===r[15]},l.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},l.getTranslation=function(r,t){if(!n(r))throw new i("matrix is required");return n(t)?(t.x=r[12],t.y=r[13],t.z=r[14],t):new e(r[12],r[13],r[14])},l.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r):new s(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},l.inverse=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],a=e[4],s=e[8],f=e[12],c=e[1],h=e[5],d=e[9],w=e[13],m=e[2],y=e[6],p=e[10],v=e[14],g=e[3],q=e[7],x=e[11],b=e[15],E=p*b,S=v*x,M=y*b,_=v*q,O=y*x,T=p*q,P=m*b,A=v*g,N=m*x,z=p*g,R=m*q,C=y*g,I=E*h+_*d+O*w-(S*h+M*d+T*w),D=S*c+P*d+z*w-(E*c+A*d+N*w),U=M*c+A*h+R*w-(_*c+P*h+C*w),L=T*c+N*h+C*d-(O*c+z*h+R*d),B=S*a+M*s+T*f-(E*a+_*s+O*f),F=E*t+A*s+N*f-(S*t+P*s+z*f),W=_*t+P*a+C*f-(M*t+A*a+R*f),G=O*t+z*a+R*s-(T*t+N*a+C*s);E=s*w,S=f*d,M=a*w,_=f*h,O=a*d,T=s*h,P=t*w,A=f*c,N=t*d,z=s*c,R=t*h,C=a*c;var V=E*q+_*x+O*b-(S*q+M*x+T*b),j=S*g+P*x+z*b-(E*g+A*x+N*b),Y=M*g+A*q+R*b-(_*g+P*q+C*b),H=T*g+N*q+C*x-(O*g+z*q+R*x),k=M*p+T*v+S*y-(O*v+E*y+_*p),Z=N*v+E*m+A*p-(P*p+z*v+S*m),X=P*y+C*v+_*m-(R*v+M*m+A*y),J=R*p+O*m+z*y-(N*y+C*p+T*m),Q=t*I+a*D+s*U+f*L;if(Math.abs(Q)<o.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return Q=1/Q,n(r)?(r[0]=I*Q,r[1]=D*Q,r[2]=U*Q,r[3]=L*Q,r[4]=B*Q,r[5]=F*Q,r[6]=W*Q,r[7]=G*Q,r[8]=V*Q,r[9]=j*Q,r[10]=Y*Q,r[11]=H*Q,r[12]=k*Q,r[13]=Z*Q,r[14]=X*Q,r[15]=J*Q,r):new l(I*Q,B*Q,V*Q,k*Q,D*Q,F*Q,j*Q,Z*Q,U*Q,W*Q,Y*Q,X*Q,L*Q,G*Q,H*Q,J*Q)},l.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],a=e[1],o=e[2],s=e[4],u=e[5],f=e[6],c=e[8],h=e[9],d=e[10],w=e[12],m=e[13],y=e[14],p=-t*w-a*m-o*y,v=-s*w-u*m-f*y,g=-c*w-h*m-d*y;return n(r)?(r[0]=t,r[1]=s,r[2]=c,r[3]=0,r[4]=a,r[5]=u,r[6]=h,r[7]=0,r[8]=o,r[9]=f,r[10]=d,r[11]=0,r[12]=p,r[13]=v,r[14]=g,r[15]=1,r):new l(t,a,o,p,s,u,f,v,c,h,d,g,0,0,0,1)},l.IDENTITY=a(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,r){return l.equalsEpsilon(this,e,r)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,a,o){"use strict";var s=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};s.fromDegrees=function(e,n,i,a,u){return e=o.toRadians(r(e,0)),n=o.toRadians(r(n,0)),i=o.toRadians(r(i,0)),a=o.toRadians(r(a,0)),t(u)?(u.west=e,u.south=n,u.east=i,u.north=a,u):new s(e,n,i,a)},s.fromCartographicArray=function(e,r){if(!t(e))throw new n("cartographics is required.");for(var i=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,u=-Number.MAX_VALUE,l=0,f=e.length;f>l;l++){var c=e[l];i=Math.min(i,c.longitude),a=Math.max(a,c.longitude),o=Math.min(o,c.latitude),u=Math.max(u,c.latitude)}return t(r)?(r.west=i,r.south=o,r.east=a,r.north=u,r):new s(i,o,a,u)},s.packedLength=4,s.pack=function(e,i,a){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");a=r(a,0),i[a++]=e.west,i[a++]=e.south,i[a++]=e.east,i[a]=e.north},s.unpack=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new s),a.west=e[i++],a.south=e[i++],a.east=e[i++],a.north=e[i],a},s.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},s.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new n("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){if(!t(e))throw new n("rectangle is required");var r=e.north;if("number"!=typeof r)throw new n("north is required to be a number.");if(r<-o.PI_OVER_TWO||r>o.PI_OVER_TWO)throw new n("north must be in the interval [-Pi/2, Pi/2].");var i=e.south;if("number"!=typeof i)throw new n("south is required to be a number.");if(i<-o.PI_OVER_TWO||i>o.PI_OVER_TWO)throw new n("south must be in the interval [-Pi/2, Pi/2].");var a=e.west;if("number"!=typeof a)throw new n("west is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new n("west must be in the interval [-Pi, Pi].");var s=e.east;if("number"!=typeof s)throw new n("east is required to be a number.");if(s<-Math.PI||s>Math.PI)throw new n("east must be in the interval [-Pi, Pi].")},s.getSouthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.getNorthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.getNortheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.getSoutheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.getCenter=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=.5*(r.west+r.east),i.latitude=.5*(r.south+r.north),i.height=0,i):new e(.5*(r.west+r.east),.5*(r.south+r.north))},s.intersectWith=function(e,r,i){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("otherRectangle is required.");var a=Math.max(e.west,r.west),o=Math.max(e.south,r.south),u=Math.min(e.east,r.east),l=Math.min(e.north,r.north);return t(i)?(i.west=a,i.south=o,i.east=u,i.north=l,i):new s(a,o,u,l)},s.contains=function(e,r){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("cartographic is required.");return r.longitude>=e.west&&r.longitude<=e.east&&r.latitude>=e.south&&r.latitude<=e.north},s.isEmpty=function(e){if(!t(e))throw new n("rectangle is required");return e.west>=e.east||e.south>=e.north};var u=new e;return s.subsample=function(e,a,s,l){if(!t(e))throw new n("rectangle is required");a=r(a,i.WGS84),s=r(s,0),t(l)||(l=[]);var f=0,c=e.north,h=e.south,d=e.east,w=e.west,m=u;m.height=s,m.longitude=w,m.latitude=c,l[f]=a.cartographicToCartesian(m,l[f]),f++,m.longitude=d,l[f]=a.cartographicToCartesian(m,l[f]),f++,m.latitude=h,l[f]=a.cartographicToCartesian(m,l[f]),f++,m.longitude=w,l[f]=a.cartographicToCartesian(m,l[f]),f++,m.latitude=0>c?c:h>0?h:0;for(var y=1;8>y;++y){var p=-Math.PI+y*o.PI_OVER_TWO;p>w&&d>p&&(m.longitude=p,l[f]=a.cartographicToCartesian(m,l[f]),f++)}return 0===m.latitude&&(m.longitude=w,l[f]=a.cartographicToCartesian(m,l[f]),f++,m.longitude=d,l[f]=a.cartographicToCartesian(m,l[f]),f++),l.length=f,l},s.MAX_VALUE=a(new s(-Math.PI,-o.PI_OVER_TWO,Math.PI,o.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,r,t,n,i,a,o,s,u,l,f){"use strict";var c=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},h=new e,d=new e,w=new e,m=new e,y=new e,p=new e,v=new e,g=new e,q=new e,x=new e,b=new e,E=new e;c.fromPoints=function(r,t){if(n(t)||(t=new c),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],v),a=e.clone(i,h),o=e.clone(i,d),s=e.clone(i,w),u=e.clone(i,m),l=e.clone(i,y),f=e.clone(i,p),S=r.length,M=1;S>M;M++){e.clone(r[M],i);var _=i.x,O=i.y,T=i.z;_<a.x&&e.clone(i,a),_>u.x&&e.clone(i,u),O<o.y&&e.clone(i,o),O>l.y&&e.clone(i,l),T<s.z&&e.clone(i,s),T>f.z&&e.clone(i,f)}var P=e.magnitudeSquared(e.subtract(u,a,g)),A=e.magnitudeSquared(e.subtract(l,o,g)),N=e.magnitudeSquared(e.subtract(f,s,g)),z=a,R=u,C=P;A>C&&(C=A,z=o,R=l),N>C&&(C=N,z=s,R=f);var I=q;I.x=.5*(z.x+R.x),I.y=.5*(z.y+R.y),I.z=.5*(z.z+R.z);var D=e.magnitudeSquared(e.subtract(R,I,g)),U=Math.sqrt(D),L=x;L.x=a.x,L.y=o.y,L.z=s.z;var B=b;B.x=u.x,B.y=l.y,B.z=f.z;var F=e.multiplyByScalar(e.add(L,B,g),.5,E),W=0;for(M=0;S>M;M++){e.clone(r[M],i);var G=e.magnitude(e.subtract(i,F,g));G>W&&(W=G);var V=e.magnitudeSquared(e.subtract(i,I,g));if(V>D){var j=Math.sqrt(V);U=.5*(U+j),D=U*U;var Y=j-U;I.x=(U*I.x+Y*i.x)/j,I.y=(U*I.y+Y*i.y)/j,I.z=(U*I.z+Y*i.z)/j}}return W>U?(e.clone(I,t.center),t.radius=U):(e.clone(F,t.center),t.radius=W),t};var S=new o,M=new e,_=new e,O=new r,T=new r;c.fromRectangle2D=function(e,r,t){return c.fromRectangleWithHeights2D(e,r,0,0,t)},c.fromRectangleWithHeights2D=function(r,i,a,o,s){if(n(s)||(s=new c),!n(r))return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;i=t(i,S),f.getSouthwest(r,O),O.height=a,f.getNortheast(r,T),T.height=o;var u=i.project(O,M),l=i.project(T,_),h=l.x-u.x,d=l.y-u.y,w=l.z-u.z;s.radius=.5*Math.sqrt(h*h+d*d+w*w);var m=s.center;return m.x=u.x+.5*h,m.y=u.y+.5*d,m.z=u.z+.5*w,s};var P=[];c.fromRectangle3D=function(e,r,i,o){r=t(r,a.WGS84),i=t(i,0);var s;return n(e)&&(s=f.subsample(e,r,i,P)),c.fromPoints(s,o)},c.fromVertices=function(r,a,o,s){if(n(s)||(s=new c),!n(r)||0===r.length)return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;if(a=t(a,e.ZERO),o=t(o,3),3>o)throw new i("stride must be 3 or greater.");var u=v;u.x=r[0]+a.x,u.y=r[1]+a.y,u.z=r[2]+a.z;for(var l=e.clone(u,h),f=e.clone(u,d),S=e.clone(u,w),M=e.clone(u,m),_=e.clone(u,y),O=e.clone(u,p),T=r.length,P=0;T>P;P+=o){var A=r[P]+a.x,N=r[P+1]+a.y,z=r[P+2]+a.z;u.x=A,u.y=N,u.z=z,A<l.x&&e.clone(u,l),A>M.x&&e.clone(u,M),N<f.y&&e.clone(u,f),N>_.y&&e.clone(u,_),z<S.z&&e.clone(u,S),z>O.z&&e.clone(u,O)}var R=e.magnitudeSquared(e.subtract(M,l,g)),C=e.magnitudeSquared(e.subtract(_,f,g)),I=e.magnitudeSquared(e.subtract(O,S,g)),D=l,U=M,L=R;C>L&&(L=C,D=f,U=_),I>L&&(L=I,D=S,U=O);var B=q;B.x=.5*(D.x+U.x),B.y=.5*(D.y+U.y),B.z=.5*(D.z+U.z);var F=e.magnitudeSquared(e.subtract(U,B,g)),W=Math.sqrt(F),G=x;G.x=l.x,G.y=f.y,G.z=S.z;var V=b;V.x=M.x,V.y=_.y,V.z=O.z;var j=e.multiplyByScalar(e.add(G,V,g),.5,E),Y=0;for(P=0;T>P;P+=o){u.x=r[P]+a.x,u.y=r[P+1]+a.y,u.z=r[P+2]+a.z;var H=e.magnitude(e.subtract(u,j,g));H>Y&&(Y=H);var k=e.magnitudeSquared(e.subtract(u,B,g));if(k>F){var Z=Math.sqrt(k);W=.5*(W+Z),F=W*W;var X=Z-W;B.x=(W*B.x+X*u.x)/Z,B.y=(W*B.y+X*u.y)/Z,B.z=(W*B.z+X*u.z)/Z}}return Y>W?(e.clone(B,s.center),s.radius=W):(e.clone(j,s.center),s.radius=Y),s},c.fromCornerPoints=function(r,t,a){if(!n(r)||!n(t))throw new i("corner and oppositeCorner are required.");n(a)||(a=new c);var o=a.center;return e.add(r,t,o),e.multiplyByScalar(o,.5,o),a.radius=e.distance(o,t),a},c.fromEllipsoid=function(r,t){if(!n(r))throw new i("ellipsoid is required.");return n(t)||(t=new c),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t},c.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new c(r.center,r.radius):void 0},c.packedLength=4,c.pack=function(e,r,a){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");a=t(a,0);var o=e.center;r[a++]=o.x,r[a++]=o.y,r[a++]=o.z,r[a]=e.radius},c.unpack=function(e,r,a){if(!n(e))throw new i("array is required");r=t(r,0),n(a)||(a=new c);var o=a.center;return o.x=e[r++],o.y=e[r++],o.z=e[r++],a.radius=e[r],a};var A=new e,N=new e;c.union=function(r,t,a){if(!n(r))throw new i("left is required.");if(!n(t))throw new i("right is required.");n(a)||(a=new c);var o=r.center,s=t.center;e.add(o,s,N);var u=e.multiplyByScalar(N,.5,N),l=e.magnitude(e.subtract(o,u,A))+r.radius,f=e.magnitude(e.subtract(s,u,A))+t.radius;return a.radius=Math.max(l,f),e.clone(u,a.center),a};var z=new e;c.expand=function(r,t,a){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("point is required.");a=c.clone(r,a);var o=e.magnitude(e.subtract(t,a.center,z));return o>a.radius&&(a.radius=o),a},c.intersect=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("plane is required.");var a=r.center,o=r.radius,u=e.dot(t,a)+t.w;return-o>u?s.OUTSIDE:o>u?s.INTERSECTING:s.INSIDE},c.transform=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new c),t.center=l.multiplyByPoint(r,e.center,t.center),t.radius=l.getMaximumScale(r)*e.radius,t};var R=new e;c.distanceSquaredTo=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("cartesian is required.");var a=e.subtract(r.center,t,R);return e.magnitudeSquared(a)-r.radius*r.radius},c.transformWithoutScale=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new c),t.center=l.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var C=new e;c.getPlaneDistances=function(r,t,a,o){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("position is required.");if(!n(a))throw new i("direction is required.");n(o)||(o=new u);var s=e.subtract(r.center,t,C),l=e.multiplyByScalar(a,e.dot(a,s),C),f=e.magnitude(l);return o.start=f-r.radius,o.stop=f+r.radius,o};for(var I=new e,D=new e,U=new e,L=new e,B=new e,F=new r,W=new Array(8),G=0;8>G;++G)W[G]=new e;var V=new o;return c.projectTo2D=function(r,a,o){if(!n(r))throw new i("sphere is required.");a=t(a,V);var s=a.ellipsoid,u=r.center,l=r.radius,f=s.geodeticSurfaceNormal(u,I),h=e.cross(e.UNIT_Z,f,D);e.normalize(h,h);var d=e.cross(f,h,U);e.normalize(d,d),e.multiplyByScalar(f,l,f),e.multiplyByScalar(d,l,d),e.multiplyByScalar(h,l,h);var w=e.negate(d,B),m=e.negate(h,L),y=W,p=y[0];e.add(f,d,p),e.add(p,h,p),p=y[1],e.add(f,d,p),e.add(p,m,p),p=y[2],e.add(f,w,p),e.add(p,m,p),p=y[3],e.add(f,w,p),e.add(p,h,p),e.negate(f,f),p=y[4],e.add(f,d,p),e.add(p,h,p),p=y[5],e.add(f,d,p),e.add(p,m,p),p=y[6],e.add(f,w,p),e.add(p,m,p),p=y[7],e.add(f,w,p),e.add(p,h,p);for(var v=y.length,g=0;v>g;++g){var q=y[g];e.add(u,q,q);var x=s.cartesianToCartographic(q,F);a.project(x,q)}o=c.fromPoints(y,o),u=o.center;var b=u.x,E=u.y,S=u.z;return u.x=S,u.y=b,u.z=E,o},c.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius
},c.prototype.intersect=function(e){return c.intersect(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.prototype.clone=function(e){return c.clone(this,e)},c}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,s=a.length;s>o;++o){var u=a[o];i=u+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=u+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=u+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=u+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=u+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=u+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=u+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=u+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=u+"fullscreenchange",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=u+"fullscreenerror",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(h)){var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null===e?h=!1:(h=!0,d=n(e[1]))}return h}function a(){return i()&&d}function o(){if(!r(w))if(i()||!/ Safari\/[\.0-9]+/.test(navigator.userAgent))w=!1;else{var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null===e?w=!1:(w=!0,m=n(e[1]))}return w}function s(){return o()&&m}function u(){if(!r(y)){var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null===e?y=!1:(y=!0,p=n(e[1]),p.isNightly=!!e[2])}return y}function l(){return u()&&p}function f(){if(!r(v)){var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(v=!0,g=n(e[1]))):"Netscape"===navigator.appName?(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(v=!0,g=n(e[1]))):v=!1}return v}function c(){return f()&&g}var h,d,w,m,y,p,v,g,q={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:s,isWebkit:u,webkitVersion:l,isInternetExplorer:f,internetExplorerVersion:c,hardwareConcurrency:e(navigator.hardwareConcurrency,3)};return q.supportsFullscreen=function(){return t.supportsFullscreen()},q.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},q}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection"],function(e,r,t,n){"use strict";if(!n.supportsTypedArrays())return{};var i={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return i.getSizeInBytes=function(e){if(!r(e))throw new t("value is required.");switch(e){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new t("componentDatatype is not a valid value.")}},i.fromTypedArray=function(e){return e instanceof Int8Array?i.BYTE:e instanceof Uint8Array?i.UNSIGNED_BYTE:e instanceof Int16Array?i.SHORT:e instanceof Uint16Array?i.UNSIGNED_SHORT:e instanceof Float32Array?i.FLOAT:e instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(e){return r(e)&&(e===i.BYTE||e===i.UNSIGNED_BYTE||e===i.SHORT||e===i.UNSIGNED_SHORT||e===i.FLOAT||e===i.DOUBLE)},i.createTypedArray=function(e,n){if(!r(e))throw new t("componentDatatype is required.");if(!r(n))throw new t("valuesOrLength is required.");switch(e){case i.BYTE:return new Int8Array(n);case i.UNSIGNED_BYTE:return new Uint8Array(n);case i.SHORT:return new Int16Array(n);case i.UNSIGNED_SHORT:return new Uint16Array(n);case i.FLOAT:return new Float32Array(n);case i.DOUBLE:return new Float64Array(n);default:throw new t("componentDatatype is not a valid value.")}},i.createArrayBufferView=function(n,a,o,s){if(!r(n))throw new t("componentDatatype is required.");if(!r(a))throw new t("buffer is required.");switch(o=e(o,0),s=e(s,(a.byteLength-o)/i.getSizeInBytes(n)),n){case i.BYTE:return new Int8Array(a,o,s);case i.UNSIGNED_BYTE:return new Uint8Array(a,o,s);case i.SHORT:return new Int16Array(a,o,s);case i.UNSIGNED_SHORT:return new Uint16Array(a,o,s);case i.FLOAT:return new Float32Array(a,o,s);case i.DOUBLE:return new Float64Array(a,o,s);default:throw new t("componentDatatype is not a valid value.")}},i}),define("Core/CornerType",[],function(){"use strict";var e={ROUNDED:0,MITERED:1,BEVELED:2};return e}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,r,t,n,i,a,o,s){"use strict";function u(e){var r=e._uSquared,t=e._ellipsoid.maximumRadius,n=e._ellipsoid.minimumRadius,i=(t-n)/t,a=Math.cos(e._startHeading),o=Math.sin(e._startHeading),s=(1-i)*Math.tan(e._start.latitude),u=1/Math.sqrt(1+s*s),l=u*s,f=Math.atan2(s,a),c=u*o,h=c*c,d=1-h,w=Math.sqrt(d),m=r/4,y=m*m,p=y*m,v=y*y,g=1+m-3*y/4+5*p/4-175*v/64,q=1-m+15*y/8-35*p/8,x=1-3*m+35*y/4,b=1-5*m,E=g*f-q*Math.sin(2*f)*m/2-x*Math.sin(4*f)*y/16-b*Math.sin(6*f)*p/48-5*Math.sin(8*f)*v/512,S=e._constants;S.a=t,S.b=n,S.f=i,S.cosineHeading=a,S.sineHeading=o,S.tanU=s,S.cosineU=u,S.sineU=l,S.sigma=f,S.sineAlpha=c,S.sineSquaredAlpha=h,S.cosineSquaredAlpha=d,S.cosineAlpha=w,S.u2Over4=m,S.u4Over16=y,S.u6Over64=p,S.u8Over256=v,S.a0=g,S.a1=q,S.a2=x,S.a3=b,S.distanceRatio=E}function l(e,r){return e*r*(4+e*(4-3*r))/16}function f(e,r,t,n,i,a,o){var s=l(e,t);return(1-s)*e*r*(n+s*i*(o+s*a*(2*o*o-1)))}function c(e,r,t,n,i,a,o){var u,l,c,h,d,w=(r-t)/r,m=a-n,y=Math.atan((1-w)*Math.tan(i)),p=Math.atan((1-w)*Math.tan(o)),v=Math.cos(y),g=Math.sin(y),q=Math.cos(p),x=Math.sin(p),b=v*q,E=v*x,S=g*x,M=g*q,_=m,O=s.TWO_PI,T=Math.cos(_),P=Math.sin(_);do{T=Math.cos(_),P=Math.sin(_);var A=E-M*T;c=Math.sqrt(q*q*P*P+A*A),l=S+b*T,u=Math.atan2(c,l);var N;0===c?(N=0,h=1):(N=b*P/c,h=1-N*N),O=_,d=l-2*S/h,isNaN(d)&&(d=0),_=m+f(w,N,h,u,c,l,d)}while(Math.abs(_-O)>s.EPSILON12);var z=h*(r*r-t*t)/(t*t),R=1+z*(4096+z*(z*(320-175*z)-768))/16384,C=z*(256+z*(z*(74-47*z)-128))/1024,I=d*d,D=C*c*(d+C*(l*(2*I-1)-C*d*(4*c*c-3)*(4*I-3)/6)/4),U=t*R*(u-D),L=Math.atan2(q*P,E-M*T),B=Math.atan2(v*P,E*T-M);e._distance=U,e._startHeading=L,e._endHeading=B,e._uSquared=z}function h(t,n,i,o){var s=e.normalize(o.cartographicToCartesian(n,w),d),l=e.normalize(o.cartographicToCartesian(i,w),w);if(Math.abs(Math.abs(e.angleBetween(s,l))-Math.PI)<.0125)throw new a("geodesic position is not unique");c(t,o.maximumRadius,o.minimumRadius,n.longitude,n.latitude,i.longitude,i.latitude),n.height=0,i.height=0,t._start=r.clone(n,t._start),t._end=r.clone(i,t._end),u(t)}var d=new e,w=new e,m=function(e,i,a){var s=t(a,o.WGS84);this._ellipsoid=s,this._start=new r,this._end=new r,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,n(e)&&n(i)&&h(this,e,i,s)};return i(m.prototype,{surfaceDistance:{get:function(){if(!n(this._distance))throw new a("set end positions before getting surfaceDistance");return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){if(!n(this._distance))throw new a("set end positions before getting startHeading");return this._startHeading}},endHeading:{get:function(){if(!n(this._distance))throw new a("set end positions before getting endHeading");return this._endHeading}}}),m.prototype.setEndPoints=function(e,r){if(!n(e))throw new a("start cartographic position is required");if(!n(r))throw new a("end cartgraphic position is required");h(this,e,r,this._ellipsoid)},m.prototype.interpolateUsingFraction=function(e,r){return this.interpolateUsingSurfaceDistance(this._distance*e,r)},m.prototype.interpolateUsingSurfaceDistance=function(e,t){if(!n(this._distance))throw new a("start and end must be set before calling funciton interpolateUsingSurfaceDistance");var i=this._constants,o=i.distanceRatio+e/i.b,s=Math.cos(2*o),u=Math.cos(4*o),l=Math.cos(6*o),c=Math.sin(2*o),h=Math.sin(4*o),d=Math.sin(6*o),w=Math.sin(8*o),m=o*o,y=o*m,p=i.u8Over256,v=i.u2Over4,g=i.u6Over64,q=i.u4Over16,x=2*y*p*s/3+o*(1-v+7*q/4-15*g/4+579*p/64-(q-15*g/4+187*p/16)*s-(5*g/4-115*p/16)*u-29*p*l/16)+(v/2-q+71*g/32-85*p/16)*c+(5*q/16-5*g/4+383*p/96)*h-m*((g-11*p/2)*c+5*p*h/2)+(29*g/96-29*p/16)*d+539*p*w/1536,b=Math.asin(Math.sin(x)*i.cosineAlpha),E=Math.atan(i.a/i.b*Math.tan(b));x-=i.sigma;var S=Math.cos(2*i.sigma+x),M=Math.sin(x),_=Math.cos(x),O=i.cosineU*_,T=i.sineU*M,P=Math.atan2(M*i.sineHeading,O-T*i.cosineHeading),A=P-f(i.f,i.sineAlpha,i.cosineSquaredAlpha,x,M,_,S);return n(t)?(t.longitude=this._start.longitude+A,t.latitude=E,t.height=0,t):new r(this._start.longitude+A,E,0)},m}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,r){"use strict";function t(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}var n={};return n.discriminant=function(r,t,n){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=t*t-4*r*n;return i},n.realRoots=function(n,i,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");var o;if(0===n)return 0===i?[]:[-a/i];if(0===i){if(0===a)return[0,0];var s=Math.abs(a),u=Math.abs(n);if(u>s&&s/u<r.EPSILON14)return[0,0];if(s>u&&u/s<r.EPSILON14)return[];if(o=-a/n,0>o)return[];var l=Math.sqrt(o);return[-l,l]}if(0===a)return o=-i/n,0>o?[o,0]:[0,o];var f=i*i,c=4*n*a,h=t(f,-c,r.EPSILON14);if(0>h)return[];var d=-.5*t(i,r.sign(i)*Math.sqrt(h),r.EPSILON14);return i>0?[d/n,a/d]:[a/d,d/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,r){"use strict";function t(e,r,t,n){var i,a,o=e,s=r/3,u=t/3,l=n,f=o*u,c=s*l,h=s*s,d=u*u,w=o*u-h,m=o*l-s*u,y=s*l-d,p=4*w*y-m*m;if(0>p){var v,g,q;h*c>=f*d?(v=o,g=w,q=-2*s*w+o*m):(v=l,g=y,q=-l*m+2*u*y);var x=0>q?-1:1,b=-x*Math.abs(v)*Math.sqrt(-p);a=-q+b;var E=a/2,S=0>E?-Math.pow(-E,1/3):Math.pow(E,1/3),M=a===b?-S:-g/S;return i=0>=g?S+M:-q/(S*S+M*M+g),h*c>=f*d?[(i-s)/o]:[-l/(i+u)]}var _=w,O=-2*s*w+o*m,T=y,P=-l*m+2*u*y,A=Math.sqrt(p),N=Math.sqrt(3)/2,z=Math.abs(Math.atan2(o*A,-O)/3);i=2*Math.sqrt(-_);var R=Math.cos(z);a=i*R;var C=i*(-R/2-N*Math.sin(z)),I=a+C>2*s?a-s:C-s,D=o,U=I/D;z=Math.abs(Math.atan2(l*A,-P)/3),i=2*Math.sqrt(-T),R=Math.cos(z),a=i*R,C=i*(-R/2-N*Math.sin(z));var L=-l,B=2*u>a+C?a+u:C+u,F=L/B,W=D*B,G=-I*B-D*L,V=I*L,j=(u*G-s*V)/(-s*G+u*W);return j>=U?F>=U?F>=j?[U,j,F]:[U,F,j]:[F,U,j]:F>=U?[j,U,F]:F>=j?[j,F,U]:[F,j,U]}var n={};return n.discriminant=function(r,t,n,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var a=r*r,o=t*t,s=n*n,u=i*i,l=18*r*t*n*i+o*s-27*a*u-4*(r*s*n+o*t*i);return l},n.realRoots=function(n,i,a,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var s,u;if(0===n)return r.realRoots(i,a,o);if(0===i){if(0===a){if(0===o)return[0,0,0];u=-o/n;var l=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[l,l,l]}return 0===o?(s=r.realRoots(n,0,a),0===s.Length?[0]:[s[0],0,s[1]]):t(n,0,a,o)}return 0===a?0===o?(u=-i/n,0>u?[u,0,0]:[0,0,u]):t(n,i,0,o):0===o?(s=r.realRoots(n,i,a),0===s.length?[0]:s[1]<=0?[s[0],s[1],0]:s[0]>=0?[0,s[0],s[1]]:[s[0],0,s[1]]):t(n,i,a,o)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,r,t,n){"use strict";function i(r,i,a,o){var s=r*r,u=i-3*s/8,l=a-i*r/2+s*r/8,f=o-a*r/4+i*s/16-3*s*s/256,c=e.realRoots(1,2*u,u*u-4*f,-l*l);if(c.length>0){var h=-r/4,d=c[c.length-1];if(Math.abs(d)<t.EPSILON14){var w=n.realRoots(1,u,f);if(2===w.length){var m,y=w[0],p=w[1];if(y>=0&&p>=0){var v=Math.sqrt(y),g=Math.sqrt(p);return[h-g,h-v,h+v,h+g]}if(y>=0&&0>p)return m=Math.sqrt(y),[h-m,h+m];if(0>y&&p>=0)return m=Math.sqrt(p),[h-m,h+m]}return[]}if(d>0){var q=Math.sqrt(d),x=(u+d-l/q)/2,b=(u+d+l/q)/2,E=n.realRoots(1,q,x),S=n.realRoots(1,-q,b);return 0!==E.length?(E[0]+=h,E[1]+=h,0!==S.length?(S[0]+=h,S[1]+=h,E[1]<=S[0]?[E[0],E[1],S[0],S[1]]:S[1]<=E[0]?[S[0],S[1],E[0],E[1]]:E[0]>=S[0]&&E[1]<=S[1]?[S[0],E[0],E[1],S[1]]:S[0]>=E[0]&&S[1]<=E[1]?[E[0],S[0],S[1],E[1]]:E[0]>S[0]&&E[0]<S[1]?[S[0],E[0],S[1],E[1]]:[E[0],S[0],E[1],S[1]]):E):0!==S.length?(S[0]+=h,S[1]+=h,S):[]}}return[]}function a(r,i,a,o){var s=a*a,u=i*i,l=r*r,f=-2*i,c=a*r+u-4*o,h=l*o-a*i*r+s,d=e.realRoots(1,f,c,h);if(d.length>0){var w,m,y=d[0],p=i-y,v=p*p,g=r/2,q=p/2,x=v-4*o,b=v+4*Math.abs(o),E=l-4*y,S=l+4*Math.abs(y);if(0>y||E*b>x*S){var M=Math.sqrt(E);w=M/2,m=0===M?0:(r*q-a)/M}else{var _=Math.sqrt(x);w=0===_?0:(r*q-a)/_,m=_/2}var O,T;0===g&&0===w?(O=0,T=0):t.sign(g)===t.sign(w)?(O=g+w,T=y/O):(T=g-w,O=y/T);var P,A;0===q&&0===m?(P=0,A=0):t.sign(q)===t.sign(m)?(P=q+m,A=o/P):(A=q-m,P=o/A);var N=n.realRoots(1,O,P),z=n.realRoots(1,T,A);if(0!==N.length)return 0!==z.length?N[1]<=z[0]?[N[0],N[1],z[0],z[1]]:z[1]<=N[0]?[z[0],z[1],N[0],N[1]]:N[0]>=z[0]&&N[1]<=z[1]?[z[0],N[0],N[1],z[1]]:z[0]>=N[0]&&z[1]<=N[1]?[N[0],z[0],z[1],N[1]]:N[0]>z[0]&&N[0]<z[1]?[z[0],N[0],z[1],N[1]]:[N[0],z[0],N[1],z[1]]:N;if(0!==z.length)return z}return[]}var o={};return o.discriminant=function(e,t,n,i,a){if("number"!=typeof e)throw new r("a is a required number.");if("number"!=typeof t)throw new r("b is a required number.");if("number"!=typeof n)throw new r("c is a required number.");if("number"!=typeof i)throw new r("d is a required number.");if("number"!=typeof a)throw new r("e is a required number.");var o=e*e,s=o*e,u=t*t,l=u*t,f=n*n,c=f*n,h=i*i,d=h*i,w=a*a,m=w*a,y=u*f*h-4*l*d-4*e*c*h+18*e*t*n*d-27*o*h*h+256*s*m+a*(18*l*n*i-4*u*c+16*e*f*f-80*e*t*f*i-6*e*u*h+144*o*n*h)+w*(144*e*u*n-27*u*u-128*o*f-192*o*t*i);return y},o.realRoots=function(n,o,s,u,l){if("number"!=typeof n)throw new r("a is a required number.");if("number"!=typeof o)throw new r("b is a required number.");if("number"!=typeof s)throw new r("c is a required number.");if("number"!=typeof u)throw new r("d is a required number.");if("number"!=typeof l)throw new r("e is a required number.");if(Math.abs(n)<t.EPSILON15)return e.realRoots(o,s,u,l);var f=o/n,c=s/n,h=u/n,d=l/n,w=0>f?1:0;switch(w+=0>c?w+1:w,w+=0>h?w+1:w,w+=0>d?w+1:w){case 0:return i(f,c,h,d);case 1:return a(f,c,h,d);case 2:return a(f,c,h,d);case 3:return i(f,c,h,d);case 4:return i(f,c,h,d);case 5:return a(f,c,h,d);case 6:return i(f,c,h,d);case 7:return i(f,c,h,d);case 8:return a(f,c,h,d);case 9:return i(f,c,h,d);case 10:return i(f,c,h,d);case 11:return a(f,c,h,d);case 12:return i(f,c,h,d);case 13:return i(f,c,h,d);case 14:return i(f,c,h,d);case 15:return i(f,c,h,d);default:return void 0}},o}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial"],function(e,r,t,n,i,a,o,s){"use strict";function u(e,r,t){var n=e+r;return i.sign(e)!==i.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<t?0:n}function l(r,t,n,l,f){var c,h=l*l,d=f*f,w=(r[a.COLUMN1ROW1]-r[a.COLUMN2ROW2])*d,m=f*(l*u(r[a.COLUMN1ROW0],r[a.COLUMN0ROW1],i.EPSILON15)+t.y),y=r[a.COLUMN0ROW0]*h+r[a.COLUMN2ROW2]*d+l*t.x+n,p=d*u(r[a.COLUMN2ROW1],r[a.COLUMN1ROW2],i.EPSILON15),v=f*(l*u(r[a.COLUMN2ROW0],r[a.COLUMN0ROW2])+t.z),g=[];if(0===v&&0===p){if(c=o.realRoots(w,m,y),0===c.length)return g;var q=c[0],x=Math.sqrt(Math.max(1-q*q,0));if(g.push(new e(l,f*q,f*-x)),g.push(new e(l,f*q,f*x)),2===c.length){var b=c[1],E=Math.sqrt(Math.max(1-b*b,0));g.push(new e(l,f*b,f*-E)),g.push(new e(l,f*b,f*E))}return g}var S=v*v,M=p*p,_=w*w,O=v*p,T=_+M,P=2*(m*w+O),A=2*y*w+m*m-M+S,N=2*(y*m-O),z=y*y-S;if(0===T&&0===P&&0===A&&0===N)return g;c=s.realRoots(T,P,A,N,z);var R=c.length;if(0===R)return g;for(var C=0;R>C;++C){var I,D=c[C],U=D*D,L=Math.max(1-U,0),B=Math.sqrt(L);I=i.sign(w)===i.sign(y)?u(w*U+y,m*D,i.EPSILON12):i.sign(y)===i.sign(m*D)?u(w*U,m*D+y,i.EPSILON12):u(w*U+m*D,y,i.EPSILON12);var F=u(p*D,v,i.EPSILON15),W=I*F;0>W?g.push(new e(l,f*D,f*B)):W>0?g.push(new e(l,f*D,f*-B)):0!==B?(g.push(new e(l,f*D,f*-B)),g.push(new e(l,f*D,f*B)),++C):g.push(new e(l,f*D,f*B))}return g}var f={};f.rayPlane=function(r,a,o){if(!t(r))throw new n("ray is required.");if(!t(a))throw new n("plane is required.");t(o)||(o=new e);var s=r.origin,u=r.direction,l=a.normal,f=e.dot(l,u);if(Math.abs(f)<i.EPSILON15)return void 0;var c=(-a.distance-e.dot(l,s))/f;return 0>c?void 0:(o=e.multiplyByScalar(u,c,o),e.add(s,o,o))};var c=new e,h=new e;f.rayEllipsoid=function(r,i){if(!t(r))throw new n("ray is required.");if(!t(i))throw new n("ellipsoid is required.");var a,o,s,u,l,f=i.oneOverRadii,d=e.multiplyComponents(f,r.origin,c),w=e.multiplyComponents(f,r.direction,h),m=e.magnitudeSquared(d),y=e.dot(d,w);if(m>1){if(y>=0)return void 0;var p=y*y;if(a=m-1,o=e.magnitudeSquared(w),s=o*a,s>p)return void 0;if(p>s){u=y*y-s,l=-y+Math.sqrt(u);var v=l/o,g=a/l;return g>v?{start:v,stop:g}:{start:g,stop:v}}var q=Math.sqrt(a/o);return{start:q,stop:q}}return 1>m?(a=m-1,o=e.magnitudeSquared(w),s=o*a,u=y*y-s,l=-y+Math.sqrt(u),{start:0,stop:l/o}):0>y?(o=e.magnitudeSquared(w),{start:0,stop:-y/o}):void 0};var d=new e,w=new e,m=new e,y=new e;f.grazingAltitudeLocation=function(o,s){if(!t(o))throw new n("ray is required.");if(!t(s))throw new n("ellipsoid is required.");var u=o.origin,f=o.direction,c=s.geodeticSurfaceNormal(u);if(e.dot(f,c)>=0)return u;var h,p,v=t(this.rayEllipsoid(o,s)),g=s.transformPositionToScaledSpace(f),q=e.normalize(g,d),x=e.mostOrthogonalAxis(g,y),b=e.normalize(e.cross(x,q,w),w),E=e.normalize(e.cross(q,b,m),m),S=new a(q.x,b.x,E.x,q.y,b.y,E.y,q.z,b.z,E.z),M=a.transpose(S),_=a.fromScale(s.radii),O=a.fromScale(s.oneOverRadii),T=new a(0,f.z,-f.y,-f.z,0,f.x,f.y,-f.x,0),P=a.multiply(a.multiply(M,O),T),A=a.multiply(a.multiply(P,_),S),N=a.multiplyByVector(P,u),z=l(A,e.negate(N,d),0,0,1),R=z.length;if(R>0){for(var C=e.ZERO,I=Number.NEGATIVE_INFINITY,D=0;R>D;++D){h=a.multiplyByVector(_,a.multiplyByVector(S,z[D]));var U=e.normalize(e.subtract(h,u,y),y),L=e.dot(U,f);L>I&&(I=L,C=h)}var B=s.cartesianToCartographic(C);return I=i.clamp(I,0,1),p=e.magnitude(e.subtract(C,u,y))*Math.sqrt(1-I*I),p=v?-p:p,s.cartographicToCartesian(new r(B.longitude,B.latitude,p))}return void 0};var p=new e;return f.lineSegmentPlane=function(r,a,o,s){if(!t(r))throw new n("endPoint0 is required.");if(!t(a))throw new n("endPoint1 is required.");if(!t(o))throw new n("plane is required.");t(s)||(s=new e);var u=e.subtract(a,r,p),l=o.normal,f=e.dot(l,u);if(Math.abs(f)<i.EPSILON6)return void 0;var c=e.dot(l,r),h=-(o.distance+c)/f;return 0>h||h>1?void 0:(e.multiplyByScalar(u,h,s),e.add(r,s,s),s)},f.trianglePlaneIntersection=function(r,i,a,o){if(!(t(r)&&t(i)&&t(a)&&t(o)))throw new n("p0, p1, p2, and plane are required.");var s=o.normal,u=o.distance,l=e.dot(s,r)+u<0,c=e.dot(s,i)+u<0,h=e.dot(s,a)+u<0,d=0;d+=l?1:0,d+=c?1:0,d+=h?1:0;var w,m;if((1===d||2===d)&&(w=new e,m=new e),1===d){if(l)return f.lineSegmentPlane(r,i,o,w),f.lineSegmentPlane(r,a,o,m),{positions:[r,i,a,w,m],indices:[0,3,4,1,2,4,1,4,3]};if(c)return f.lineSegmentPlane(i,a,o,w),f.lineSegmentPlane(i,r,o,m),{positions:[r,i,a,w,m],indices:[1,3,4,2,0,4,2,4,3]};if(h)return f.lineSegmentPlane(a,r,o,w),f.lineSegmentPlane(a,i,o,m),{positions:[r,i,a,w,m],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===d){if(!l)return f.lineSegmentPlane(i,r,o,w),f.lineSegmentPlane(a,r,o,m),{positions:[r,i,a,w,m],indices:[1,2,4,1,4,3,0,3,4]};if(!c)return f.lineSegmentPlane(a,i,o,w),f.lineSegmentPlane(r,i,o,m),{positions:[r,i,a,w,m],indices:[2,0,4,2,4,3,1,3,4]};if(!h)return f.lineSegmentPlane(r,a,o,w),f.lineSegmentPlane(i,a,o,m),{positions:[r,i,a,w,m],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},f}),define("Core/isArray",["./defined"],function(e){"use strict";var r=Array.isArray;return e(r)||(r=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),r}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n,i){if(!r(n))throw new t("normal is required.");if(!r(i))throw new t("distance is required.");this.normal=e.clone(n),this.distance=i};return n.fromPointNormal=function(i,a,o){if(!r(i))throw new t("point is required.");if(!r(a))throw new t("normal is required.");var s=-e.dot(a,i);return r(o)?(e.clone(a,o.normal),o.distance=s,o):new n(a,s)},n.getPointDistance=function(n,i){if(!r(n))throw new t("plane is required.");if(!r(i))throw new t("point is required.");return e.dot(n.normal,i)+n.distance},n}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,r,t,n,i,a,o,s,u,l,f,c){"use strict";function h(r,t,n,i){var a=i.scaleToGeodeticSurface(r,_),o=i.scaleToGeodeticSurface(t,O),s=e.angleBetween(a,o),u=Math.ceil(s/n),l=new Array(3*u),f=i.cartesianToCartographic(a,E),c=i.cartesianToCartographic(o,S);T.setEndPoints(f,c);var h=T.surfaceDistance/u,d=0;f.height=0;var w=i.cartographicToCartesian(f,M);l[d++]=w.x,l[d++]=w.y,l[d++]=w.z;for(var m=1;u>m;m++){var y=T.interpolateUsingSurfaceDistance(m*h,S);w=i.cartographicToCartesian(y,M),l[d++]=w.x,l[d++]=w.y,l[d++]=w.z}return l}function d(r,t,n){var i=P;return n.geodeticSurfaceNormal(r,i),e.multiplyByScalar(i,t,i),e.add(r,i,r),r}var w={},m=new f,y=new e,p=new e,v=new c(e.ZERO,0),g=new e,q=new c(e.ZERO,0),x=new e,b=new e,E=new r,S=new r,M=new e,_=new e,O=new e,T=new o,P=new e,A=new e;return w.wrapLongitude=function(r,i){var a=[],o=[];if(n(r)&&r.length>0){i=t(i,f.IDENTITY);var u=f.inverseTransformation(i,m),l=f.multiplyByPoint(u,e.ZERO,y),h=f.multiplyByPointAsVector(u,e.UNIT_Y,p),d=c.fromPointNormal(l,h,v),w=f.multiplyByPointAsVector(u,e.UNIT_X,g),E=c.fromPointNormal(l,w,q),S=1;a.push(e.clone(r[0]));for(var M=a[0],_=r.length,O=1;_>O;++O){var T=r[O];if(c.getPointDistance(E,M)<0||c.getPointDistance(E,T)<0){var P=s.lineSegmentPlane(M,T,d,x);if(n(P)){var A=e.multiplyByScalar(h,5e-9,b);c.getPointDistance(d,M)<0&&e.negate(A,A),a.push(e.add(P,A,new e)),o.push(S+1),e.negate(A,A),a.push(e.add(P,A,new e)),S=1}}a.push(e.clone(r[O])),S++,M=T}o.push(S)}return{positions:a,lengths:o}},w.removeDuplicates=function(r){if(!n(r))throw new i("positions is required.");var t=r.length;if(2>t)return r.slice(0);var a=[];a.push(r[0]);for(var o=1;t>o;++o){var s=r[o-1],u=r[o];e.equals(s,u)||a.push(u)}return a},w.scaleToSurface=function(e,r,o){if(!n(e))throw new i("positions is required");r=t(r,l.RADIANS_PER_DEGREE),o=t(o,a.WGS84);for(var s=e.length,u=[],f=0;s-1>f;f++){var c=e[f],d=e[f+1];u=u.concat(h(c,d,r,o))}var w=e[s-1],m=o.cartesianToCartographic(w,E);m.height=0;var y=o.cartographicToCartesian(m,M);return u.push(y.x,y.y,y.z),u},w.scaleToGeodeticHeight=function(r,o,s,l){if(!n(r))throw new i("positions must be defined.");if(!n(o))throw new i("height must be defined");s=t(s,a.WGS84);var f,c,h=r.length,w=A;if(n(l)){if(l.length!==r.length)throw new i("result.length must be equal to positions.length");c=l}else c=new Array(r.length);if(0===o){for(f=0;h>f;f+=3)w=s.scaleToGeodeticSurface(e.fromArray(r,f,w),w),c[f]=w.x,c[f+1]=w.y,c[f+2]=w.z;return c}var m;if(u(o)){if(o.length!==h/3)throw new i("height.length must be equal to positions.length");for(f=0;h>f;f+=3)m=o[f/3],w=e.fromArray(r,f,w),w=d(w,m,s),c[f]=w.x,c[f+1]=w.y,c[f+2]=w.z}else for(m=o,f=0;h>f;f+=3)w=e.fromArray(r,f,w),w=d(w,m,s),c[f]=w.x,c[f+1]=w.y,c[f+2]=w.z;return c},w}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t){this.x=e(r,0),this.y=e(t,0)};a.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new a(e,t)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a]=n.y},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i],o},a.fromArray=a.unpack,a.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y)},a.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y)},a.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i},a.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n};var s=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,s),o=a.multiplyByScalar(e,1-i,o),a.add(s,o,o)};var u=new a,l=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return a.normalize(e,u),a.normalize(n,l),i.acosClamped(a.dot(u,l))};var f=new a;return a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,f);return a.abs(i,i),n=i.x<=i.y?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Y,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i},a.ZERO=n(new a(0,0)),a.UNIT_X=n(new a(1,0)),a.UNIT_Y=n(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Intersect"],function(e,r,t,n,i){"use strict";var a=function(n,i,a){this.minimum=e.clone(r(n,e.ZERO)),this.maximum=e.clone(r(i,e.ZERO)),t(a)?a=e.clone(a):(a=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(a,.5,a)),this.center=a};a.fromPoints=function(r,n){if(t(n)||(n=new a),!t(r)||0===r.length)return n.minimum=e.clone(e.ZERO,n.minimum),n.maximum=e.clone(e.ZERO,n.maximum),n.center=e.clone(e.ZERO,n.center),n;for(var i=r[0].x,o=r[0].y,s=r[0].z,u=r[0].x,l=r[0].y,f=r[0].z,c=r.length,h=1;c>h;h++){var d=r[h],w=d.x,m=d.y,y=d.z;i=Math.min(w,i),u=Math.max(w,u),o=Math.min(m,o),l=Math.max(m,l),s=Math.min(y,s),f=Math.max(y,f)}var p=n.minimum;p.x=i,p.y=o,p.z=s;var v=n.maximum;v.x=u,v.y=l,v.z=f;var g=e.add(p,v,n.center);return e.multiplyByScalar(g,.5,g),n},a.clone=function(r,n){return t(r)?t(n)?(n.minimum=e.clone(r.minimum,n.minimum),n.maximum=e.clone(r.maximum,n.maximum),n.center=e.clone(r.center,n.center),n):new a(r.minimum,r.maximum):void 0},a.equals=function(r,n){return r===n||t(r)&&t(n)&&e.equals(r.center,n.center)&&e.equals(r.minimum,n.minimum)&&e.equals(r.maximum,n.maximum)};var o=new e;return a.intersect=function(r,a){if(!t(r))throw new n("box is required.");if(!t(a))throw new n("plane is required.");o=e.subtract(r.maximum,r.minimum,o);var s=e.multiplyByScalar(o,.5,o),u=s.x*Math.abs(a.x)+s.y*Math.abs(a.y)+s.z*Math.abs(a.z),l=e.dot(r.center,a)+a.w;return l-u>0?i.INSIDE:0>l+u?i.OUTSIDE:i.INTERSECTING},a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.intersect=function(e){return a.intersect(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=function(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n};return i.getPoint=function(r,i,a){if(!t(r))throw new n("ray is requred");if("number"!=typeof i)throw new n("t is a required number");return t(a)||(a=new e),a=e.multiplyByScalar(r.direction,i,a),e.add(r.origin,a,a)
},i}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,t,n,i){return r(e).then(t,n,i)}function r(e){var r,t;return e instanceof n?r=e:s(e)?(t=o(),e.then(function(e){t.resolve(e)},function(e){t.reject(e)},function(e){t.progress(e)}),r=t.promise):r=i(e),r}function t(r){return e(r,a)}function n(e){this.then=e}function i(e){var t=new n(function(t){try{return r(t?t(e):e)}catch(n){return a(n)}});return t}function a(e){var t=new n(function(t,n){try{return n?r(n(e)):a(e)}catch(i){return a(i)}});return t}function o(){function e(e,r,t){return h(e,r,t)}function t(e){return w(e)}function i(e){return w(a(e))}function s(e){return d(e)}var u,l,f,c,h,d,w;return l=new n(e),u={then:e,resolve:t,reject:i,progress:s,promise:l,resolver:{resolve:t,reject:i,progress:s}},f=[],c=[],h=function(e,r,t){var n,i;return n=o(),i="function"==typeof t?function(e){try{n.progress(t(e))}catch(r){n.progress(r)}}:function(e){n.progress(e)},f.push(function(t){t.then(e,r).then(n.resolve,n.reject,i)}),c.push(i),n.promise},d=function(e){return m(c,e),e},w=function(e){return e=r(e),h=e.then,w=r,d=p,m(f,e),c=f=x,e},u}function s(e){return e&&"function"==typeof e.then}function u(r,t,n,i,a){return y(2,arguments),e(r,function(r){function s(e){m(e)}function u(e){w(e)}var l,f,c,h,d,w,m,y,v,g;if(v=r.length>>>0,l=Math.max(0,Math.min(t,v)),c=[],f=v-l+1,h=[],d=o(),l)for(y=d.progress,m=function(e){h.push(e),--f||(w=m=p,d.reject(h))},w=function(e){c.push(e),--l||(w=m=p,d.resolve(c))},g=0;v>g;++g)g in r&&e(r[g],u,s,y);else d.resolve(c);return d.then(n,i,a)})}function l(e,r,t,n){function i(e){return r?r(e[0]):e[0]}return u(e,1,i,t,n)}function f(e,r,t,n){return y(1,arguments),h(e,v).then(r,t,n)}function c(){return h(arguments,v)}function h(r,t){return e(r,function(r){var n,i,a,s,u,l;if(a=i=r.length>>>0,n=[],l=o(),a)for(s=function(r,i){e(r,t).then(function(e){n[i]=e,--a||l.resolve(n)},l.reject)},u=0;i>u;u++)u in r?s(r[u],u):--a;else l.resolve(n);return l.promise})}function d(r,t){var n=q.call(arguments,1);return e(r,function(r){var i;return i=r.length,n[0]=function(r,n,a){return e(r,function(r){return e(n,function(e){return t(r,e,a,i)})})},g.apply(r,n)})}function w(r,t,n){var i=arguments.length>2;return e(r,function(e){return e=i?n:e,t.resolve(e),e},function(e){return t.reject(e),a(e)},t.progress)}function m(e,r){for(var t,n=0;t=e[n++];)t(r)}function y(e,r){for(var t,n=r.length;n>e;)if(t=r[--n],null!=t&&"function"!=typeof t)throw new Error("arg "+n+" must be a function")}function p(){}function v(e){return e}var g,q,x;return e.defer=o,e.resolve=r,e.reject=t,e.join=c,e.all=f,e.map=h,e.reduce=d,e.any=l,e.some=u,e.chain=w,e.isPromise=s,n.prototype={always:function(e,r){return this.then(e,e,r)},otherwise:function(e){return this.then(x,e)},yield:function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(r){return f(r,function(r){return e.apply(x,r)})})}},q=[].slice,g=[].reduce||function(e){var r,t,n,i,a;if(a=0,r=Object(this),i=r.length>>>0,t=arguments,t.length<=1)for(;;){if(a in r){n=r[a++];break}if(++a>=i)throw new TypeError}else n=t[1];for(;i>a;++a)a in r&&(n=e(n,r[a],a,r));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,r){"use strict";var t=function(t,n,i){if(!e(t))throw new r("array is required.");if(!e(n))throw new r("itemToFind is required.");if(!e(i))throw new r("comparator is required.");for(var a,o,s=0,u=t.length-1;u>=s;)if(a=~~((s+u)/2),o=i(t[a],n),0>o)s=a+1;else{if(!(o>0))return a;u=a-1}return~(u+1)};return t}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,r,t,n,i){this.xPoleWander=e,this.yPoleWander=r,this.xPoleOffset=t,this.yPoleOffset=n,this.ut1MinusUtc=i};return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,r=arguments,t=0,n=r[t++],i=function(e,r,t,n){t||(t=" ");var i=e.length>=r?"":Array(1+r-e.length>>>0).join(t);return n?e+i:i+e},a=function(e,r,t,n,a,o){var s=n-e.length;return s>0&&(e=t||!a?i(e,n,o,t):e.slice(0,r.length)+i("",s,"0",!0)+e.slice(r.length)),e},o=function(e,r,t,n,o,s,u){var l=e>>>0;return t=t&&l&&{2:"0b",8:"0",16:"0x"}[r]||"",e=t+i(l.toString(r),s||0,"0",!1),a(e,t,n,o,u)},s=function(e,r,t,n,i,o){return null!=n&&(e=e.slice(0,n)),a(e,"",r,t,i,o)},u=function(e,n,u,l,f,c,h){var d,w,m,y,p;if("%%"==e)return"%";for(var v=!1,g="",q=!1,x=!1,b=" ",E=u.length,S=0;u&&E>S;S++)switch(u.charAt(S)){case" ":g=" ";break;case"+":g="+";break;case"-":v=!0;break;case"'":b=u.charAt(S+1);break;case"0":q=!0;break;case"#":x=!0}if(l=l?"*"==l?+r[t++]:"*"==l.charAt(0)?+r[l.slice(1,-1)]:+l:0,0>l&&(l=-l,v=!0),!isFinite(l))throw new Error("sprintf: (minimum-)width must be finite");switch(c=c?"*"==c?+r[t++]:"*"==c.charAt(0)?+r[c.slice(1,-1)]:+c:"fFeE".indexOf(h)>-1?6:"d"==h?0:void 0,p=n?r[n.slice(0,-1)]:r[t++],h){case"s":return s(String(p),v,l,c,q,b);case"c":return s(String.fromCharCode(+p),v,l,c,q);case"b":return o(p,2,x,v,l,c,q);case"o":return o(p,8,x,v,l,c,q);case"x":return o(p,16,x,v,l,c,q);case"X":return o(p,16,x,v,l,c,q).toUpperCase();case"u":return o(p,10,x,v,l,c,q);case"i":case"d":return d=+p||0,d=Math.round(d-d%1),w=0>d?"-":g,p=w+i(String(Math.abs(d)),c,"0",!1),a(p,w,v,l,q);case"e":case"E":case"f":case"F":case"g":case"G":return d=+p,w=0>d?"-":g,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(h.toLowerCase())],y=["toString","toUpperCase"]["eEfFgG".indexOf(h)%2],p=w+Math.abs(d)[m](c),a(p,w,v,l,q)[y]();default:return e}};return n.replace(e,u)}return e}),define("Core/GregorianDate",[],function(){"use strict";var e=function(e,r,t,n,i,a,o,s){this.year=e,this.month=r,this.day=t,this.hour=n,this.minute=i,this.second=a,this.millisecond=o,this.isLeapSecond=s};return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function r(r){if(null===r||isNaN(r))throw new e("year is required and must be a number.");return 0===r%4&&0!==r%100||0===r%400}return r}),define("Core/LeapSecond",[],function(){"use strict";var e=function(e,r){this.julianDate=e,this.offset=r};return e}),define("Core/TimeConstants",[],function(){"use strict";var e={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e}),define("Core/TimeStandard",[],function(){"use strict";var e={UTC:0,TAI:1};return e}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./defineProperties","./DeveloperError","./GregorianDate","./isArray","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,r,t,n,i,a,o,s,u,l,f,c){"use strict";function h(e,r){return N.compare(e.julianDate,r.julianDate)}function d(e){q.julianDate=e;var t=N.leapSeconds,n=r(t,q,h);0>n&&(n=~n),n>=t.length&&(n=t.length-1);var i=t[n].offset;if(n>0){var a=N.getSecondsDifference(t[n].julianDate,e);a>i&&(n--,i=t[n].offset)}N.addSeconds(e,i,e)}function w(e,t){q.julianDate=e;var n=N.leapSeconds,i=r(n,q,h);if(0>i&&(i=~i),0===i)return N.addSeconds(e,-n[0].offset,t);if(i>=n.length)return N.addSeconds(e,-n[i-1].offset,t);var a=N.getSecondsDifference(n[i].julianDate,e);return 0===a?N.addSeconds(e,-n[i].offset,t):1>=a?void 0:N.addSeconds(e,-n[--i].offset,t)}function m(e,r,t){var n=0|r/f.SECONDS_PER_DAY;return e+=n,r-=f.SECONDS_PER_DAY*n,0>r&&(e--,r+=f.SECONDS_PER_DAY),t.dayNumber=e,t.secondsOfDay=r,t}function y(e,r,t,n,i,a,o){var s=0|(r-14)/12,u=e+4800+s,l=(0|1461*u/4)+(0|367*(r-2-12*s)/12)-(0|3*((u+100)/100)/4)+t-32075;n-=12,0>n&&(n+=24);var c=a+(n*f.SECONDS_PER_HOUR+i*f.SECONDS_PER_MINUTE+o*f.SECONDS_PER_MILLISECOND);return c>=43200&&(l-=1),[l,c]}var p=new o,v=[31,28,31,30,31,30,31,31,30,31,30,31],g=29,q=new l,x=/^(\d{4})$/,b=/^(\d{4})-(\d{2})$/,E=/^(\d{4})-?(\d{3})$/,S=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,M=/^(\d{4})-?(\d{2})-?(\d{2})$/,_=/([Z+\-])?(\d{2})?:?(\d{2})?$/,O=/^(\d{2})(\.\d+)?/.source+_.source,T=/^(\d{2}):?(\d{2})(\.\d+)?/.source+_.source,P=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+_.source,A="Invalid ISO 8601 date.",N=function(e,r,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=t(e,0),r=t(r,0),n=t(n,c.UTC);var i=0|e;r+=(e-i)*f.SECONDS_PER_DAY,m(i,r,this),n===c.UTC&&d(this)};N.fromDate=function(e,r){if(!(e instanceof Date)||isNaN(e.getTime()))throw new a("date must be a valid JavaScript Date.");var t=y(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(r)?(m(t[0],t[1],r),d(r),r):new N(t[0],t[1],c.UTC)},N.fromIso8601=function(e,r){if("string"!=typeof e)throw new a(A);e=e.replace(",",".");var t,i,o,s=e.split("T"),l=1,f=1,h=0,w=0,p=0,q=0,_=s[0],z=s[1];if(!n(_))throw new a(A);var R;if(s=_.match(M),null!==s){if(R=_.split("-").length-1,R>0&&2!==R)throw new a(A);t=+s[1],l=+s[2],f=+s[3]}else if(s=_.match(b),null!==s)t=+s[1],l=+s[2];else if(s=_.match(x),null!==s)t=+s[1];else{var C;if(s=_.match(E),null!==s){if(t=+s[1],C=+s[2],o=u(t),1>C||o&&C>366||!o&&C>365)throw new a(A)}else{if(s=_.match(S),null===s)throw new a(A);t=+s[1];var I=+s[2],D=+s[3]||0;if(R=_.split("-").length-1,R>0&&(!n(s[3])&&1!==R||n(s[3])&&2!==R))throw new a(A);var U=new Date(Date.UTC(t,0,4));C=7*I+D-U.getUTCDay()-3}i=new Date(Date.UTC(t,0,1)),i.setUTCDate(C),l=i.getUTCMonth()+1,f=i.getUTCDate()}if(o=u(t),1>l||l>12||1>f||(2!==l||!o)&&f>v[l-1]||o&&2===l&&f>g)throw new a(A);var L;if(n(z)){if(s=z.match(P),null!==s){if(R=z.split(":").length-1,R>0&&2!==R&&3!==R)throw new a(A);h=+s[1],w=+s[2],p=+s[3],q=1e3*+(s[4]||0),L=5}else if(s=z.match(T),null!==s){if(R=z.split(":").length-1,R>0&&1!==R)throw new a(A);h=+s[1],w=+s[2],p=60*+(s[3]||0),L=4}else{if(s=z.match(O),null===s)throw new a(A);h=+s[1],w=60*+(s[2]||0),L=3}if(w>=60||p>=61||h>24||24===h&&(w>0||p>0||q>0))throw new a(A);var B=s[L],F=+s[L+1],W=+(s[L+2]||0);switch(B){case"+":h-=F,w-=W;break;case"-":h+=F,w+=W;break;case"Z":break;default:w+=new Date(Date.UTC(t,l-1,f,h,w)).getTimezoneOffset()}}else w+=new Date(Date.UTC(t,l-1,f)).getTimezoneOffset();var G=60===p;for(G&&p--;w>=60;)w-=60,h++;for(;h>=24;)h-=24,f++;for(i=o&&2===l?g:v[l-1];f>i;)f-=i,l++,l>12&&(l-=12,t++),i=o&&2===l?g:v[l-1];for(;0>w;)w+=60,h--;for(;0>h;)h+=24,f--;for(;1>f;)l--,1>l&&(l+=12,t--),i=o&&2===l?g:v[l-1],f+=i;var V=y(t,l,f,h,w,p,q);return n(r)?(m(V[0],V[1],r),d(r)):r=new N(V[0],V[1],c.UTC),G&&N.addSeconds(r,1,r),r},N.now=function(e){return N.fromDate(new Date,e)};var z=new N(0,0,c.TAI);return N.toGregorianDate=function(e,r){if(!n(e))throw new a("julianDate is required.");var t=!1,i=w(e,z);n(i)||(N.addSeconds(e,-1,z),i=w(z,z),t=!0);var s=i.dayNumber,u=i.secondsOfDay;u>=43200&&(s+=1);var l=0|s+68569,c=0|4*l/146097;l=0|l-(0|(146097*c+3)/4);var h=0|4e3*(l+1)/1461001;l=0|l-(0|1461*h/4)+31;var d=0|80*l/2447,m=0|l-(0|2447*d/80);l=0|d/11;var y=0|d+2-12*l,p=0|100*(c-49)+h+l,v=0|u/f.SECONDS_PER_HOUR,g=u-v*f.SECONDS_PER_HOUR,q=0|g/f.SECONDS_PER_MINUTE;g-=q*f.SECONDS_PER_MINUTE;var x=0|g,b=(g-x)/f.SECONDS_PER_MILLISECOND;return v+=12,v>23&&(v-=24),t&&(x+=1),n(r)?(r.year=p,r.month=y,r.day=m,r.hour=v,r.minute=q,r.second=x,r.millisecond=b,r.isLeapSecond=t,r):new o(p,y,m,v,q,x,b,t)},N.toDate=function(e){if(!n(e))throw new a("julianDate is required.");var r=N.toGregorianDate(e,p),t=r.second;return r.isLeapSecond&&(t-=1),new Date(Date.UTC(r.year,r.month-1,r.day,r.hour,r.minute,t,r.millisecond))},N.toIso8601=function(r,t){if(!n(r))throw new a("julianDate is required.");var i,o=N.toGregorianDate(r,o);return n(t)||0===o.millisecond?n(t)&&0!==t?(i=(.01*o.millisecond).toFixed(t).replace(".","").slice(0,t),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,i)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",o.year,o.month,o.day,o.hour,o.minute,o.second):(i=(.01*o.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,i))},N.clone=function(e,r){return n(e)?n(r)?(r.dayNumber=e.dayNumber,r.secondsOfDay=e.secondsOfDay,r):new N(e.dayNumber,e.secondsOfDay,c.TAI):void 0},N.compare=function(e,r){if(!n(e))throw new a("left is required.");if(!n(r))throw new a("right is required.");var t=e.dayNumber-r.dayNumber;return 0!==t?t:e.secondsOfDay-r.secondsOfDay},N.equals=function(e,r){return e===r||n(e)&&n(r)&&e.dayNumber===r.dayNumber&&e.secondsOfDay===r.secondsOfDay},N.equalsEpsilon=function(e,r,t){if(!n(t))throw new a("epsilon is required.");return e===r||n(e)&&n(r)&&Math.abs(N.getSecondsDifference(e,r))<=t},N.getTotalDays=function(e){if(!n(e))throw new a("julianDate is required.");return e.dayNumber+e.secondsOfDay/f.SECONDS_PER_DAY},N.getSecondsDifference=function(e,r){if(!n(e))throw new a("left is required.");if(!n(r))throw new a("right is required.");var t=(e.dayNumber-r.dayNumber)*f.SECONDS_PER_DAY;return t+(e.secondsOfDay-r.secondsOfDay)},N.getDaysDifference=function(e,r){if(!n(e))throw new a("left is required.");if(!n(r))throw new a("right is required.");var t=e.dayNumber-r.dayNumber,i=(e.secondsOfDay-r.secondsOfDay)/f.SECONDS_PER_DAY;return t+i},N.getTaiMinusUtc=function(e){q.julianDate=e;var t=N.leapSeconds,n=r(t,q,h);return 0>n&&(n=~n,--n,0>n&&(n=0)),t[n].offset},N.addSeconds=function(e,r,t){if(!n(e))throw new a("julianDate is required.");if(!n(r))throw new a("seconds is required.");if(!n(t))throw new a("result is required.");return m(e.dayNumber,e.secondsOfDay+r,t)},N.addMinutes=function(e,r,t){if(!n(e))throw new a("julianDate is required.");if(!n(r))throw new a("minutes is required.");if(!n(t))throw new a("result is required.");var i=e.secondsOfDay+r*f.SECONDS_PER_MINUTE;return m(e.dayNumber,i,t)},N.addHours=function(e,r,t){if(!n(e))throw new a("julianDate is required.");if(!n(r))throw new a("hours is required.");if(!n(t))throw new a("result is required.");var i=e.secondsOfDay+r*f.SECONDS_PER_HOUR;return m(e.dayNumber,i,t)},N.addDays=function(e,r,t){if(!n(e))throw new a("julianDate is required.");if(!n(r))throw new a("days is required.");if(!n(t))throw new a("result is required.");var i=e.dayNumber+r;return m(i,e.secondsOfDay,t)},N.lessThan=function(e,r){return N.compare(e,r)<0},N.lessThanOrEquals=function(e,r){return N.compare(e,r)<=0},N.greaterThan=function(e,r){return N.compare(e,r)>0},N.greaterThanOrEquals=function(e,r){return N.compare(e,r)>=0},N.prototype.clone=function(e){return N.clone(this,e)},N.prototype.equals=function(e){return N.equals(this,e)},N.prototype.equalsEpsilon=function(e,r){return N.equalsEpsilon(this,e,r)},N.leapSeconds=[new l(new N(2441317,43210,c.TAI),10),new l(new N(2441499,43211,c.TAI),11),new l(new N(2441683,43212,c.TAI),12),new l(new N(2442048,43213,c.TAI),13),new l(new N(2442413,43214,c.TAI),14),new l(new N(2442778,43215,c.TAI),15),new l(new N(2443144,43216,c.TAI),16),new l(new N(2443509,43217,c.TAI),17),new l(new N(2443874,43218,c.TAI),18),new l(new N(2444239,43219,c.TAI),19),new l(new N(2444786,43220,c.TAI),20),new l(new N(2445151,43221,c.TAI),21),new l(new N(2445516,43222,c.TAI),22),new l(new N(2446247,43223,c.TAI),23),new l(new N(2447161,43224,c.TAI),24),new l(new N(2447892,43225,c.TAI),25),new l(new N(2448257,43226,c.TAI),26),new l(new N(2448804,43227,c.TAI),27),new l(new N(2449169,43228,c.TAI),28),new l(new N(2449534,43229,c.TAI),29),new l(new N(2450083,43230,c.TAI),30),new l(new N(2450630,43231,c.TAI),31),new l(new N(2451179,43232,c.TAI),32),new l(new N(2453736,43233,c.TAI),33),new l(new N(2454832,43234,c.TAI),34),new l(new N(2456109,43235,c.TAI),35)],N}),define("Core/clone",["./defaultValue"],function(e){"use strict";var r=function(t,n){if(null===t||"object"!=typeof t)return t;n=e(n,!1);var i=new t.constructor;for(var a in t)if(t.hasOwnProperty(a)){var o=t[a];n&&(o=r(o,n)),i[a]=o}return i};return r}),define("Core/parseResponseHeaders",[],function(){"use strict";var e=function(e){var r={};if(!e)return r;for(var t=e.split("\r\n"),n=0;n<t.length;++n){var i=t[n],a=i.indexOf(": ");if(a>0){var o=i.substring(0,a),s=i.substring(a+2);r[o]=s}}return r};return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,r){"use strict";var t=function(e,t,n){this.statusCode=e,this.response=t,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=r(this.responseHeaders))};return t.prototype.toString=function(){var r="Request has failed.";return e(this.statusCode)&&(r+=" Status Code: "+this.statusCode),r},t}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent"],function(e,r,t,n,i){"use strict";function a(e,r){var t=decodeURIComponent(r);return e?atob(t):t}function o(e,r){for(var t=a(e,r),n=new ArrayBuffer(t.length),i=new Uint8Array(n),o=0;o<t.length;o++)i[o]=t.charCodeAt(o);return n}function s(e,t){t=r(t,"");var i=e[1],s=!!e[2],u=e[3];switch(t){case"":case"text":return a(s,u);case"arraybuffer":return o(s,u);case"blob":var l=o(s,u);return new Blob([l],{type:i});case"document":var f=new DOMParser;return f.parseFromString(a(s,u),i);case"json":return JSON.parse(a(s,u));default:throw new n("Unhandled responseType: "+t)}}var u=function(i){if(i=r(i,r.EMPTY_OBJECT),!t(i.url))throw new n("options.url is required.");var a=i.responseType,o=r(i.method,"GET"),s=i.data,l=i.headers,f=i.overrideMimeType;return e(i.url,function(r){var t=e.defer();return u.load(r,a,o,s,l,t,f),t.promise})},l=/^data:(.*?)(;base64)?,(.*)$/;return u.load=function(e,r,n,a,o,u,f){var c=l.exec(e);if(null!==c)return u.resolve(s(c,r)),void 0;var h=new XMLHttpRequest;if(t(f)&&h.overrideMimeType(f),h.open(n,e,!0),t(o))for(var d in o)o.hasOwnProperty(d)&&h.setRequestHeader(d,o[d]);t(r)&&(h.responseType=r),h.onload=function(){200===h.status?u.resolve(h.response):u.reject(new i(h.status,h.response,h.getAllResponseHeaders()))},h.onerror=function(){u.reject(new i)},h.send(a)},u.defaultLoad=u.load,u}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";var r=function(r,t){return e({url:r,headers:t})};return r}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,r,t,n){"use strict";var i={Accept:"application/json,*/*;q=0.01"},a=function(a,o){if(!r(a))throw new t("url is required.");return r(o)?r(o.Accept)||(o=e(o),o.Accept=i.Accept):o=i,n(a,o).then(function(e){return JSON.parse(e)})};return a}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,r,t,n,i,a,o,s,u,l,f,c){"use strict";function h(e,r){return o.compare(e.julianDate,r)}function d(e,t){if(!n(t.columnNames))return e._dataError="Error in loaded EOP data: The columnNames property is required.",void 0;if(!n(t.samples))return e._dataError="Error in loaded EOP data: The samples property is required.",void 0;var i=t.columnNames.indexOf("modifiedJulianDateUtc"),a=t.columnNames.indexOf("xPoleWanderRadians"),u=t.columnNames.indexOf("yPoleWanderRadians"),l=t.columnNames.indexOf("ut1MinusUtcSeconds"),d=t.columnNames.indexOf("xCelestialPoleOffsetRadians"),w=t.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=t.columnNames.indexOf("taiMinusUtcSeconds");if(0>i||0>a||0>u||0>l||0>d||0>w||0>m)return e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns",void 0;var y=e._samples=t.samples,p=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=a,e._yPoleWanderRadiansColumn=u,e._ut1MinusUtcSecondsColumn=l,e._xCelestialPoleOffsetRadiansColumn=d,e._yCelestialPoleOffsetRadiansColumn=w,e._taiMinusUtcSecondsColumn=m,e._columnCount=t.columnNames.length,e._lastIndex=void 0;for(var v,g=e._addNewLeapSeconds,q=0,x=y.length;x>q;q+=e._columnCount){var b=y[q+i],E=y[q+m],S=b+f.MODIFIED_JULIAN_DATE_DIFFERENCE,M=new o(S,E,c.TAI);if(p.push(M),g){if(E!==v&&n(v)){var _=o.leapSeconds,O=r(_,M,h);if(0>O){var T=new s(M,E);_.splice(~O,0,T)}}v=E}}}function w(e,r,t,n,i){var a=t*n;i.xPoleWander=r[a+e._xPoleWanderRadiansColumn],i.yPoleWander=r[a+e._yPoleWanderRadiansColumn],i.xPoleOffset=r[a+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=r[a+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=r[a+e._ut1MinusUtcSecondsColumn]}function m(e,r,t){return r+e*(t-r)}function y(e,r,t,n,i,a,s){var u=e._columnCount;if(a>r.length-1)return s.xPoleWander=0,s.yPoleWander=0,s.xPoleOffset=0,s.yPoleOffset=0,s.ut1MinusUtc=0,s;var l=r[i],f=r[a];if(l.equals(f)||n.equals(l))return w(e,t,i,u,s),s;if(n.equals(f))return w(e,t,a,u,s),s;var c=o.getSecondsDifference(n,l)/o.getSecondsDifference(f,l),h=i*u,d=a*u,y=t[h+e._ut1MinusUtcSecondsColumn],p=t[d+e._ut1MinusUtcSecondsColumn],v=p-y;if(v>.5||-.5>v){var g=t[h+e._taiMinusUtcSecondsColumn],q=t[d+e._taiMinusUtcSecondsColumn];g!==q&&(f.equals(n)?y=p:p-=q-g)}return s.xPoleWander=m(c,t[h+e._xPoleWanderRadiansColumn],t[d+e._xPoleWanderRadiansColumn]),s.yPoleWander=m(c,t[h+e._yPoleWanderRadiansColumn],t[d+e._yPoleWanderRadiansColumn]),s.xPoleOffset=m(c,t[h+e._xCelestialPoleOffsetRadiansColumn],t[d+e._xCelestialPoleOffsetRadiansColumn]),s.yPoleOffset=m(c,t[h+e._yCelestialPoleOffsetRadiansColumn],t[d+e._yCelestialPoleOffsetRadiansColumn]),s.ut1MinusUtc=m(c,y,p),s}var p=function(r){if(r=t(r,t.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=t(r.addNewLeapSeconds,!0),n(r.data))d(this,r.data);else if(n(r.url)){var i=this;this._downloadPromise=e(u(r.url),function(e){d(i,e)},function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+r.url+"."})}else d(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return p.NONE=a({getPromiseToLoad:function(){return e()},compute:function(e,r){return n(r)?(r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0):r=new i(0,0,0,0,0),r}}),p.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},p.prototype.compute=function(e,t){if(!n(this._samples)){if(n(this._dataError))throw new l(this._dataError);return void 0}if(n(t)||(t=new i(0,0,0,0,0)),0===this._samples.length)return t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0,t;var a=this._dates,s=this._lastIndex,u=0,f=0;if(n(s)){var c=a[s],h=a[s+1],d=o.lessThanOrEquals(c,e),w=!n(h),m=w||o.greaterThanOrEquals(h,e);if(d&&m)return u=s,!w&&h.equals(e)&&++u,f=u+1,y(this,a,this._samples,e,u,f,t),t}var p=r(a,e,o.compare,this._dateColumn);return p>=0?(p<a.length-1&&a[p+1].equals(e)&&++p,u=p,f=p):(f=~p,u=f-1,0>u&&(u=0)),this._lastIndex=u,y(this,a,this._samples,e,u,f,t),t},p}),define("ThirdParty/Uri",[],function(){function e(r){if(r instanceof e)this.scheme=r.scheme,this.authority=r.authority,this.path=r.path,this.query=r.query,this.fragment=r.fragment;else if(r){var t=n.exec(r);this.scheme=t[1],this.authority=t[2],this.path=t[3],this.query=t[4],this.fragment=t[5]}}function r(e){var r=unescape(e);return a.test(r)?r:e.toUpperCase()}function t(e,r,t,n){return(r||"")+t.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,t).replace(i,r)),this.path&&(this.path=this.path.replace(i,r)),this.query&&(this.query=this.query.replace(i,r)),this.fragment&&(this.fragment=this.fragment.replace(i,r))};var i=/%[0-9a-z]{2}/gi,a=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(r){var t=new e;return this.scheme?(t.scheme=this.scheme,t.authority=this.authority,t.path=this.path,t.query=this.query):(t.scheme=r.scheme,this.authority?(t.authority=this.authority,t.path=this.path,t.query=this.query):(t.authority=r.authority,""==this.path?(t.path=r.path,t.query=this.query||r.query):("/"==this.path.charAt(0)?(t.path=this.path,t.removeDotSegments()):(t.path=r.authority&&""==r.path?"/"+this.path:r.path.substring(0,r.path.lastIndexOf("/")+1)+this.path,t.removeDotSegments()),t.query=this.query))),t.fragment=this.fragment,t},e.prototype.removeDotSegments=function(){var e,r=this.path.split("/"),t=[],n=""==r[0];for(n&&r.shift(),""==r[0]?r.shift():null;r.length;)e=r.shift(),".."==e?t.pop():"."!=e&&t.push(e);("."==e||".."==e)&&t.push(""),n&&t.unshift(""),this.path=t.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,r,t,n){"use strict";function i(){for(var e=document.getElementsByTagName("script"),r=0,t=e.length;t>r;++r){var n=e[r].getAttribute("src"),i=c.exec(n);if(null!==i)return i[1]}return void 0}function a(){if(r(u))return u;var n;if(n="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:i(),!r(n))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return u=new e(n).resolve(new e(document.location.href))}function o(e){return n.toUrl("../"+e)}function s(r){return new e(r).resolve(a()).toString()}var u,l,f,c=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,h=function(e){r(l)||(l=r(n.toUrl)?o:s),r(f)||(f=document.createElement("a"));var t=l(e);return f.href=t,f.href=f.href,f.href};return h._cesiumScriptRegex=c,h}),define("Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,r,t){this.x=e,this.y=r,this.s=t};return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,r,t,n,i,a,o,s){"use strict";function u(e,r,t){var n=c;return n.dayNumber=r,n.secondsOfDay=t,a.getDaysDifference(n,e._sampleZeroDateTT)}function l(t,i){if(t._chunkDownloadsInProgress[i])return t._chunkDownloadsInProgress[i];var a=e.defer();t._chunkDownloadsInProgress[i]=a;var s,u=t._xysFileUrlTemplate;return s=n(u)?u.replace("{0}",i):r("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json"),e(o(s),function(e){t._chunkDownloadsInProgress[i]=!1;for(var r=t._samples,n=e.samples,o=3*i*t._samplesPerXysFile,s=0,u=n.length;u>s;++s)r[o+s]=n[s];a.resolve()}),a.promise}var f=function(e){e=t(e,t.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=t(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=t(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new a(this._sampleZeroJulianEphemerisDate,0,s.TAI),this._stepSizeDays=t(e.stepSizeDays,1),this._samplesPerXysFile=t(e.samplesPerXysFile,1e3),this._totalSamples=t(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var r=this._interpolationOrder,n=this._denominators=new Array(r+1),i=this._xTable=new Array(r+1),o=Math.pow(this._stepSizeDays,r),u=0;r>=u;++u){n[u]=o,i[u]=u*this._stepSizeDays;for(var l=0;r>=l;++l)l!==u&&(n[u]*=u-l);n[u]=1/n[u]}this._work=new Array(r+1),this._coef=new Array(r+1)},c=new a(0,0,s.TAI);return f.prototype.preload=function(r,t,n,i){var a=u(this,r,t),o=u(this,n,i),s=0|a/this._stepSizeDays-this._interpolationOrder/2;0>s&&(s=0);var f=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;f>=this._totalSamples&&(f=this._totalSamples-1);for(var c=0|s/this._samplesPerXysFile,h=0|f/this._samplesPerXysFile,d=[],w=c;h>=w;++w)d.push(l(this,w));return e.all(d)},f.prototype.computeXysRadians=function(e,r,t){var a=u(this,e,r);if(0>a)return void 0;var o=0|a/this._stepSizeDays;if(o>=this._totalSamples)return void 0;var s=this._interpolationOrder,f=o-(0|s/2);0>f&&(f=0);var c=f+s;c>=this._totalSamples&&(c=this._totalSamples-1,f=c-s,0>f&&(f=0));var h=!1,d=this._samples;if(n(d[3*f])||(l(this,0|f/this._samplesPerXysFile),h=!0),n(d[3*c])||(l(this,0|c/this._samplesPerXysFile),h=!0),h)return void 0;n(t)?(t.x=0,t.y=0,t.s=0):t=new i(0,0,0);var w,m,y=a-f*this._stepSizeDays,p=this._work,v=this._denominators,g=this._coef,q=this._xTable;for(w=0;s>=w;++w)p[w]=y-q[w];for(w=0;s>=w;++w){for(g[w]=1,m=0;s>=m;++m)m!==w&&(g[w]*=p[m]);g[w]*=v[w];var x=3*(f+w);t.x+=g[w]*d[x++],t.y+=g[w]*d[x++],t.s+=g[w]*d[x]}return t},f}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./TimeConstants"],function(e,r,t,n,i,a,o,s,u,l,f,c,h,d,w,m,y){"use strict";var p={},v=new t,g=new t,q=new t;p.eastNorthUpToFixedFrame=function(e,r,n){if(!a(e))throw new o("origin is required.");if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var s=d.sign(e.z);return a(n)?(n[0]=0,n[1]=1,n[2]=0,n[3]=0,n[4]=-s,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=s,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(0,-s,0,e.x,1,0,0,e.y,0,0,s,e.z,0,0,0,1)}var u=v,f=g,c=q;return r=i(r,l.WGS84),r.geodeticSurfaceNormal(e,u),f.x=-e.y,f.y=e.x,f.z=0,t.normalize(f,f),t.cross(u,f,c),a(n)?(n[0]=f.x,n[1]=f.y,n[2]=f.z,n[3]=0,n[4]=c.x,n[5]=c.y,n[6]=c.z,n[7]=0,n[8]=u.x,n[9]=u.y,n[10]=u.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(f.x,c.x,u.x,e.x,f.y,c.y,u.y,e.y,f.z,c.z,u.z,e.z,0,0,0,1)};var x=new t,b=new t,E=new t;p.northEastDownToFixedFrame=function(e,r,n){if(!a(e))throw new o("origin is required.");if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var s=d.sign(e.z);return a(n)?(n[0]=-s,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=1,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=-s,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(-s,0,0,e.x,0,1,0,e.y,0,0,-s,e.z,0,0,0,1)}var u=x,f=b,c=E;return r=i(r,l.WGS84),r.geodeticSurfaceNormal(e,u),f.x=-e.y,f.y=e.x,f.z=0,t.normalize(f,f),t.cross(u,f,c),a(n)?(n[0]=c.x,n[1]=c.y,n[2]=c.z,n[3]=0,n[4]=f.x,n[5]=f.y,n[6]=f.z,n[7]=0,n[8]=-u.x,n[9]=-u.y,n[10]=-u.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(c.x,f.x,-u.x,e.x,c.y,f.y,-u.y,e.y,c.z,f.z,-u.z,e.z,0,0,0,1)};var S=24110.54841,M=8640184.812866,_=.093104,O=-62e-7,T=1.1772758384668e-19,P=72921158553e-15,A=d.TWO_PI/86400,N=new h;p.computeTemeToPseudoFixedMatrix=function(e,r){if(!a(e))throw new o("date is required.");N=h.addSeconds(e,-h.getTaiMinusUtc(e),N);var t,n=N.dayNumber,i=N.secondsOfDay,s=n-2451545;t=i>=43200?(s+.5)/y.DAYS_PER_JULIAN_CENTURY:(s-.5)/y.DAYS_PER_JULIAN_CENTURY;var u=S+t*(M+t*(_+t*O)),l=u*A%d.TWO_PI,f=P+T*(n-2451545.5),c=(i+.5*y.SECONDS_PER_DAY)%y.SECONDS_PER_DAY,m=l+f*c,p=Math.cos(m),v=Math.sin(m);
return a(r)?(r[0]=p,r[1]=-v,r[2]=0,r[3]=v,r[4]=p,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new w(p,v,0,-v,p,0,0,0,1)},p.iau2006XysData=new f,p.earthOrientationParameters=s.NONE;var z=32.184,R=2451545;p.preloadIcrfFixed=function(r){var t=r.start.dayNumber,n=r.start.secondsOfDay+z,i=r.stop.dayNumber,a=r.stop.secondsOfDay+z,o=p.iau2006XysData.preload(t,n,i,a),s=p.earthOrientationParameters.getPromiseToLoad();return e.all([o,s])},p.computeIcrfToFixedMatrix=function(e,r){if(!a(e))throw new o("date is required.");var t=p.computeFixedToIcrfMatrix(e,r);return a(t)?w.transpose(t,r):void 0};var C=new c(0,0,0),I=new u(0,0,0,0,0,0),D=new w,U=new w;p.computeFixedToIcrfMatrix=function(e,r){if(!a(e))throw new o("date is required.");var t=p.earthOrientationParameters.compute(e,I);if(!a(t))return void 0;var n=e.dayNumber,i=e.secondsOfDay+z,s=p.iau2006XysData.computeXysRadians(n,i,C);if(!a(s))return void 0;var u=s.x+t.xPoleOffset,l=s.y+t.yPoleOffset,f=1/(1+Math.sqrt(1-u*u-l*l)),c=D;c[0]=1-f*u*u,c[3]=-f*u*l,c[6]=u,c[1]=-f*u*l,c[4]=1-f*l*l,c[7]=l,c[2]=-u,c[5]=-l,c[8]=1-f*(u*u+l*l);var m=w.fromRotationZ(-s.s,U),v=w.multiply(c,m,D),g=e.dayNumber,q=e.secondsOfDay-h.getTaiMinusUtc(e)+t.ut1MinusUtc,x=g-2451545,b=q/y.SECONDS_PER_DAY,E=.779057273264+b+.00273781191135448*(x+b);E=E%1*d.TWO_PI;var S=w.fromRotationZ(E,U),M=w.multiply(v,S,D),_=Math.cos(t.xPoleWander),O=Math.cos(t.yPoleWander),T=Math.sin(t.xPoleWander),P=Math.sin(t.yPoleWander),A=n-R+i/y.SECONDS_PER_DAY;A/=36525;var N=-47e-6*A*d.RADIANS_PER_DEGREE/3600,L=Math.cos(N),B=Math.sin(N),F=U;return F[0]=_*L,F[1]=_*B,F[2]=T,F[3]=-O*B+P*T*L,F[4]=O*L+P*T*B,F[5]=-P*_,F[6]=-P*B-O*T*L,F[7]=P*L-O*T*B,F[8]=O*_,w.multiply(M,F,r)};var L=new n;return p.pointToWindowCoordinates=function(e,t,i,s){if(!a(e))throw new o("modelViewProjectionMatrix is required.");if(!a(t))throw new o("viewportTransformation is required.");if(!a(i))throw new o("point is required.");a(s)||(s=new r);var u=L;return m.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,u),u),n.multiplyByScalar(u,1/u.w,u),m.multiplyByVector(t,u,u),r.fromCartesian4(u,s)},p}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix4","./Plane","./Ray","./Transforms"],function(e,r,t,n,i,a,o,s,u,l,f,c,h){"use strict";var d=function(e,r){if(!i(e))throw new o("origin is required.");if(r=n(r,s.WGS84),e=r.scaleToGeodeticSurface(e),!i(e))throw new o("origin must not be at the center of the ellipsoid.");var a=h.eastNorthUpToFixedFrame(e,r);this._ellipsoid=r,this._origin=e,this._xAxis=t.fromCartesian4(l.getColumn(a,0)),this._yAxis=t.fromCartesian4(l.getColumn(a,1));var u=t.fromCartesian4(l.getColumn(a,2));this._plane=f.fromPointNormal(e,u)};a(d.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}}});var w=new e;d.fromPoints=function(r,t){if(!i(r))throw new o("cartesians is required.");var n=e.fromPoints(r,w);return new d(n.center,t)};var m=new c,y=new t;d.prototype.projectPointOntoPlane=function(e,n){if(!i(e))throw new o("cartesian is required.");var a=m;a.origin=e,t.normalize(e,a.direction);var s=u.rayPlane(a,this._plane,y);if(i(s)||(t.negate(a.direction,a.direction),s=u.rayPlane(a,this._plane,y)),i(s)){var l=t.subtract(s,this._origin,s),f=t.dot(this._xAxis,l),c=t.dot(this._yAxis,l);return i(n)?(n.x=f,n.y=c,n):new r(f,c)}return void 0},d.prototype.projectPointsOntoPlane=function(e,r){if(!i(e))throw new o("cartesians is required.");i(r)||(r=[]);for(var t=0,n=e.length,a=0;n>a;a++){var s=this.projectPointOntoPlane(e[a],r[t]);i(s)&&(r[t]=s,t++)}return r.length=t,r};var p=new t;return d.prototype.projectPointsOntoEllipsoid=function(e,r){if(!i(e))throw new o("cartesians is required.");var n=e.length;i(r)?r.length=n:r=new Array(n);for(var a=this._ellipsoid,s=this._origin,u=this._xAxis,l=this._yAxis,f=p,c=0;n>c;++c){var h=e[c];t.multiplyByScalar(u,h.x,f),i(r[c])||(r[c]=new t);var d=t.add(s,f,r[c]);t.multiplyByScalar(l,h.y,f),t.add(d,f,d),a.scaleToGeocentricSurface(d,d)}return r},d}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,r,t,n,i,a,o,s){"use strict";var u=function(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)},l=new e;u.fromAxisAngle=function(r,i,a){if(!t(r))throw new n("axis is required.");if("number"!=typeof i)throw new n("angle is required and must be a number.");var o=i/2,s=Math.sin(o);l=e.normalize(r,l);var f=l.x*s,c=l.y*s,h=l.z*s,d=Math.cos(o);return t(a)?(a.x=f,a.y=c,a.z=h,a.w=d,a):new u(f,c,h,d)};var f=[1,2,0],c=new Array(3);u.fromRotationMatrix=function(e,r){if(!t(e))throw new n("matrix is required.");var i,a,o,l,h,d=e[s.COLUMN0ROW0],w=e[s.COLUMN1ROW1],m=e[s.COLUMN2ROW2],y=d+w+m;if(y>0)i=Math.sqrt(y+1),h=.5*i,i=.5/i,a=(e[s.COLUMN1ROW2]-e[s.COLUMN2ROW1])*i,o=(e[s.COLUMN2ROW0]-e[s.COLUMN0ROW2])*i,l=(e[s.COLUMN0ROW1]-e[s.COLUMN1ROW0])*i;else{var p=f,v=0;w>d&&(v=1),m>d&&m>w&&(v=2);var g=p[v],q=p[g];i=Math.sqrt(e[s.getElementIndex(v,v)]-e[s.getElementIndex(g,g)]-e[s.getElementIndex(q,q)]+1);var x=c;x[v]=.5*i,i=.5/i,h=(e[s.getElementIndex(q,g)]-e[s.getElementIndex(g,q)])*i,x[g]=(e[s.getElementIndex(g,v)]+e[s.getElementIndex(v,g)])*i,x[q]=(e[s.getElementIndex(q,v)]+e[s.getElementIndex(v,q)])*i,a=-x[0],o=-x[1],l=-x[2]}return t(r)?(r.x=a,r.y=o,r.z=l,r.w=h,r):new u(a,o,l,h)};var h=new e,d=new e,w=new u,m=new u,y=new u;u.packedLength=4,u.pack=function(e,i,a){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");a=r(a,0),i[a++]=e.x,i[a++]=e.y,i[a++]=e.z,i[a]=e.w},u.unpack=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new u),a.x=e[i],a.y=e[i+1],a.z=e[i+2],a.w=e[i+3],a},u.packedInterpolationLength=3,u.convertPackedArrayForInterpolation=function(e,r,t,n){u.unpack(e,4*t,y),u.conjugate(y,y);for(var i=0,a=t-r+1;a>i;i++){var o=3*i;u.unpack(e,4*(r+i),w),u.multiply(w,y,w),w.w<0&&u.negate(w,w),u.getAxis(w,h);var s=u.getAngle(w);n[o]=h.x*s,n[o+1]=h.y*s,n[o+2]=h.z*s}},u.unpackInterpolationResult=function(r,n,i,a,o){t(o)||(o=new u),e.fromArray(r,0,d);var s=e.magnitude(d);return u.unpack(n,4*a,m),0===s?u.clone(u.IDENTITY,w):u.fromAxisAngle(d,s,w),u.multiply(w,m,o)},u.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new u(e.x,e.y,e.z,e.w):void 0},u.conjugate=function(e,r){if(!t(e))throw new n("quaternion is required");return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r):new u(-e.x,-e.y,-e.z,e.w)},u.magnitudeSquared=function(e){if(!t(e))throw new n("quaternion is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},u.magnitude=function(e){return Math.sqrt(u.magnitudeSquared(e))},u.normalize=function(e,r){var n=1/u.magnitude(e),i=e.x*n,a=e.y*n,o=e.z*n,s=e.w*n;return t(r)?(r.x=i,r.y=a,r.z=o,r.w=s,r):new u(i,a,o,s)},u.inverse=function(e,r){var t=u.magnitudeSquared(e);return r=u.conjugate(e,r),u.multiplyByScalar(r,1/t,r)},u.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");return t(i)?(i.x=e.x+r.x,i.y=e.y+r.y,i.z=e.z+r.z,i.w=e.w+r.w,i):new u(e.x+r.x,e.y+r.y,e.z+r.z,e.w+r.w)},u.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");return t(i)?(i.x=e.x-r.x,i.y=e.y-r.y,i.z=e.z-r.z,i.w=e.w-r.w,i):new u(e.x-r.x,e.y-r.y,e.z-r.z,e.w-r.w)},u.negate=function(e,r){if(!t(e))throw new n("quaternion is required");return t(r)?(r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r):new u(-e.x,-e.y,-e.z,-e.w)},u.dot=function(e,r){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");return e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},u.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");var a=e.x,o=e.y,s=e.z,l=e.w,f=r.x,c=r.y,h=r.z,d=r.w,w=l*f+a*d+o*h-s*c,m=l*c-a*h+o*d+s*f,y=l*h+a*c-o*f+s*d,p=l*d-a*f-o*c-s*h;return t(i)?(i.x=w,i.y=m,i.z=y,i.w=p,i):new u(w,m,y,p)},u.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");return t(i)?(i.x=e.x*r,i.y=e.y*r,i.z=e.z*r,i.w=e.w*r,i):new u(e.x*r,e.y*r,e.z*r,e.w*r)},u.divideByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");return t(i)?(i.x=e.x/r,i.y=e.y/r,i.z=e.z/r,i.w=e.w/r,i):new u(e.x/r,e.y/r,e.z/r,e.w/r)},u.getAxis=function(r,i){if(!t(r))throw new n("quaternion is required");var a=r.w;if(Math.abs(a-1)<o.EPSILON6)return t(i)?(i.x=i.y=i.z=0,i):new e;var s=1/Math.sqrt(1-a*a);return t(i)?(i.x=r.x*s,i.y=r.y*s,i.z=r.z*s,i):new e(r.x*s,r.y*s,r.z*s)},u.getAngle=function(e){if(!t(e))throw new n("quaternion is required");return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var p;u.lerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");return p=u.multiplyByScalar(r,i,p),a=u.multiplyByScalar(e,1-i,a),u.add(p,a,a)};var v,g,q;u.slerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");var s=u.dot(e,r),l=r;if(0>s&&(s=-s,l=v=u.negate(r,v)),1-s<o.EPSILON6)return u.lerp(e,l,i,a);var f=Math.acos(s);return g=u.multiplyByScalar(e,Math.sin((1-i)*f),g),q=u.multiplyByScalar(l,Math.sin(i*f),q),a=u.add(g,q,a),u.multiplyByScalar(a,1/Math.sin(f),a)},u.log=function(r,i){if(!t(r))throw new n("quaternion is required.");var a=o.acosClamped(r.w),s=0;return 0!==a&&(s=a/Math.sin(a)),t(i)||(i=new e),e.multiplyByScalar(r,s,i)},u.exp=function(r,i){if(!t(r))throw new n("cartesian is required.");var a=e.magnitude(r),o=0;return 0!==a&&(o=Math.sin(a)/a),t(i)||(i=new u),i.x=r.x*o,i.y=r.y*o,i.z=r.z*o,i.w=Math.cos(a),i};var x=new e,b=new e,E=new u,S=new u;u.innerQuadrangle=function(r,i,a,o){if(!t(r)||!t(i)||!t(a))throw new n("q0, q1, and q2 are required.");var s=u.conjugate(i,E);u.multiply(s,a,S);var l=u.log(S,x);u.multiply(s,r,S);var f=u.log(S,b);return e.add(l,f,l),e.multiplyByScalar(l,.25,l),e.negate(l,l),u.exp(l,E),u.multiply(i,E,o)},u.squad=function(e,r,i,a,o,s){if(!(t(e)&&t(r)&&t(i)&&t(a)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof o)throw new n("t is required and must be a number.");var l=u.slerp(e,r,o,E),f=u.slerp(i,a,o,S);return u.slerp(l,f,2*o*(1-o),s)};for(var M=new u,_=1.9011074535173003,O=i.supportsTypedArrays()?new Float32Array(8):[],T=i.supportsTypedArrays()?new Float32Array(8):[],P=i.supportsTypedArrays()?new Float32Array(8):[],A=i.supportsTypedArrays()?new Float32Array(8):[],N=0;7>N;++N){var z=N+1,R=2*z+1;O[N]=1/(z*R),T[N]=z/R}return O[7]=_/136,T[7]=8*_/17,u.fastSlerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");t(a)||(a=new u);var o,s=u.dot(e,r);s>=0?o=1:(o=-1,s=-s);for(var l=s-1,f=1-i,c=i*i,h=f*f,d=7;d>=0;--d)P[d]=(O[d]*c-T[d])*l,A[d]=(O[d]*h-T[d])*l;var w=o*i*(1+P[0]*(1+P[1]*(1+P[2]*(1+P[3]*(1+P[4]*(1+P[5]*(1+P[6]*(1+P[7])))))))),m=f*(1+A[0]*(1+A[1]*(1+A[2]*(1+A[3]*(1+A[4]*(1+A[5]*(1+A[6]*(1+A[7])))))))),y=u.multiplyByScalar(e,m,M);return u.multiplyByScalar(r,w,a),u.add(y,a,a)},u.fastSquad=function(e,r,i,a,o,s){if(!(t(e)&&t(r)&&t(i)&&t(a)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof o)throw new n("t is required and must be a number.");var l=u.fastSlerp(e,r,o,E),f=u.fastSlerp(i,a,o,S);return u.fastSlerp(l,f,2*o*(1-o),s)},u.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},u.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon is required and must be a number.");return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},u.ZERO=a(new u(0,0,0,0)),u.IDENTITY=a(new u(0,0,0,1)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,r){return u.equalsEpsilon(this,e,r)},u.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},u}),define("Core/PolylineVolumeGeometryLibrary",["./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./CornerType","./EllipsoidTangentPlane","./Math","./Matrix3","./Matrix4","./PolylinePipeline","./Quaternion","./Transforms"],function(e,r,t,n,i,a,o,s,u,l,f,c){"use strict";function h(e,r){for(var t=new Array(e.length),n=0;n<e.length;n++){var i=e[n];C=r.cartesianToCartographic(i,C),t[n]=C.height,e[n]=r.scaleToGeodeticSurface(i,i)}return t}function d(e,t,n,i){var a,o=e[0],s=e[1],u=r.angleBetween(o,s),l=Math.ceil(u/i),f=new Array(l);if(t===n){for(a=0;l>a;a++)f[a]=t;return f.push(n),f}var c=n-t,h=c/l;for(a=1;l>a;a++){var d=t+a*h;f[a]=d}return f[0]=t,f.push(n),f}function w(t,n,i,o){var s=new a(i,o),u=s.projectPointOntoPlane(r.add(i,t,k),k),l=s.projectPointOntoPlane(r.add(i,n,Z),Z),f=e.angleBetween(u,l);return l.x*u.y-l.y*u.x>=0?-f:f}function m(e,t,n,i,a,o,l,f){var h=F,d=W;D=c.eastNorthUpToFixedFrame(e,a,D),h=u.multiplyByPointAsVector(D,I,h),h=r.normalize(h,h);var m=w(h,t,e,a);L=s.fromRotationZ(m,L),G.z=o,D=u.multiplyTransformation(D,u.fromRotationTranslation(L,G,U),D);var y=B;y[0]=l;for(var p=0;f>p;p++)for(var v=0;v<n.length;v+=3)d=r.fromArray(n,v,d),d=s.multiplyByVector(y,d,d),d=u.multiplyByPoint(D,d,d),i.push(d.x,d.y,d.z);return i}function y(e,t,n,i,a,o,s){for(var u=0;u<e.length;u+=3){var l=r.fromArray(e,u,V);i=m(l,t,n,i,a,o[u/3],s,1)}return i}function p(e,r){var t=e.length,n=new Array(6*t),i=0,a=r.x+r.width/2,o=r.y+r.height/2,s=e[0];n[i++]=s.x-a,n[i++]=0,n[i++]=s.y-o;for(var u=1;t>u;u++){s=e[u];var l=s.x-a,f=s.y-o;n[i++]=l,n[i++]=0,n[i++]=f,n[i++]=l,n[i++]=0,n[i++]=f}return s=e[0],n[i++]=s.x-a,n[i++]=0,n[i++]=s.y-o,n}function v(e,r){for(var t=e.length,n=new Array(3*t),i=0,a=r.x+r.width/2,o=r.y+r.height/2,s=0;t>s;s++)n[i++]=e[s].x-a,n[i++]=0,n[i++]=e[s].y-o;return n}function g(e,t,n,a,u,l,c,h,d,w){var y,p=r.angleBetween(r.subtract(t,e,N),r.subtract(n,e,z)),v=a===i.BEVELED?0:Math.ceil(p/o.toRadians(5));y=u?s.fromQuaternion(f.fromAxisAngle(r.negate(e,N),p/(v+1),j),H):s.fromQuaternion(f.fromAxisAngle(e,p/(v+1),j),H);var g,q;if(t=r.clone(t,Y),v>0)for(var x=w?2:1,b=0;v>b;b++)t=s.multiplyByVector(y,t,t),g=r.subtract(t,e,N),g=r.normalize(g,g),u||(g=r.negate(g,g)),q=l.scaleToGeodeticSurface(t,z),c=m(q,g,h,c,l,d,1,x);else g=r.subtract(t,e,N),g=r.normalize(g,g),u||(g=r.negate(g,g)),q=l.scaleToGeodeticSurface(t,z),c=m(q,g,h,c,l,d,1,1),n=r.clone(n,Y),g=r.subtract(n,e,N),g=r.normalize(g,g),u||(g=r.negate(g,g)),q=l.scaleToGeodeticSurface(n,z),c=m(q,g,h,c,l,d,1,1);return c}function q(e,r){return o.equalsEpsilon(e.latitude,r.latitude,o.EPSILON6)&&o.equalsEpsilon(e.longitude,r.longitude,o.EPSILON6)}var x=[new r,new r],b=new r,E=new r,S=new r,M=new r,_=new r,O=new r,T=new r,P=new r,A=new r,N=new r,z=new r,R={},C=new n,I=new r(-1,0,0),D=new u,U=new u,L=new s,B=s.IDENTITY.clone(),F=new r,W=new t,G=new r,V=new r,j=new f,Y=new r,H=new s;R.removeDuplicatesFromShape=function(r){for(var t=r.length,n=[],i=t-1,a=0;t>a;i=a++){var o=r[i],s=r[a];e.equals(o,s)||n.push(s)}return n};var k=new r,Z=new r;R.angleIsGreaterThanPi=function(e,t,n,i){var o=new a(n,i),s=o.projectPointOntoPlane(r.add(n,e,k),k),u=o.projectPointOntoPlane(r.add(n,t,Z),Z);return u.x*s.y-u.y*s.x>=0};var X=new n,J=new n;return R.removeDuplicatesFromPositions=function(e,r){var t=e.length;if(2>t)return e.slice(0);var n=[];n.push(e[0]);for(var i=1;t>i;++i){var a=e[i-1],o=e[i],s=r.cartesianToCartographic(a,X),u=r.cartesianToCartographic(o,J);q(s,u)||n.push(o)}return n},R.computePositions=function(e,t,n,a,s){var u=a._ellipsoid,f=h(e,u),c=a._granularity,w=a._cornerType,q=s?p(t,n):v(t,n),z=s?v(t,n):void 0,C=n.height/2,I=n.width/2,D=e.length,U=[],L=s?[]:void 0,B=b,F=E,W=S,G=M,V=_,j=O,Y=T,H=P,k=A,Z=e[0],X=e[1];G=u.geodeticSurfaceNormal(Z,G),B=r.subtract(X,Z,B),B=r.normalize(B,B),H=r.cross(G,B,H),H=r.normalize(H,H);var J=f[0],Q=f[1];s&&(L=m(Z,H,z,L,u,J+C,1,1)),k=r.clone(Z,k),Z=X,F=r.negate(B,F);for(var $,K,er=1;D-1>er;er++){var rr=s?2:1;X=e[er+1],B=r.subtract(X,Z,B),B=r.normalize(B,B),W=r.add(B,F,W),W=r.normalize(W,W),G=u.geodeticSurfaceNormal(Z,G);var tr=!r.equalsEpsilon(r.negate(W,N),G,o.EPSILON2);if(tr){W=r.cross(W,G,W),W=r.cross(G,W,W),W=r.normalize(W,W);var nr=1/Math.max(.25,r.magnitude(r.cross(W,F,N))),ir=R.angleIsGreaterThanPi(B,F,Z,u);ir?(V=r.add(Z,r.multiplyByScalar(W,nr*I,W),V),j=r.add(V,r.multiplyByScalar(H,I,j),j),x[0]=r.clone(k,x[0]),x[1]=r.clone(j,x[1]),$=d(x,J+C,Q+C,c),K=l.scaleToSurface(x),U=y(K,H,q,U,u,$,1),H=r.cross(G,B,H),H=r.normalize(H,H),Y=r.add(V,r.multiplyByScalar(H,I,Y),Y),w===i.ROUNDED||w===i.BEVELED?g(V,j,Y,w,ir,u,U,q,Q+C,s):(W=r.negate(W,W),U=m(Z,W,q,U,u,Q+C,nr,rr)),k=r.clone(Y,k)):(V=r.add(Z,r.multiplyByScalar(W,nr*I,W),V),j=r.add(V,r.multiplyByScalar(H,-I,j),j),x[0]=r.clone(k,x[0]),x[1]=r.clone(j,x[1]),$=d(x,J+C,Q+C,c),K=l.scaleToSurface(x,c,u),U=y(K,H,q,U,u,$,1),H=r.cross(G,B,H),H=r.normalize(H,H),Y=r.add(V,r.multiplyByScalar(H,-I,Y),Y),w===i.ROUNDED||w===i.BEVELED?g(V,j,Y,w,ir,u,U,q,Q+C,s):U=m(Z,W,q,U,u,Q+C,nr,rr),k=r.clone(Y,k)),F=r.negate(B,F)}else U=m(k,H,q,U,u,J+C,1,1),k=Z;J=Q,Q=f[er+1],Z=X}x[0]=r.clone(k,x[0]),x[1]=r.clone(Z,x[1]),$=d(x,J+C,Q+C,c),K=l.scaleToSurface(x,c,u),U=y(K,H,q,U,u,$,1),s&&(L=m(Z,H,z,L,u,Q+C,1,1)),D=U.length;var ar=s?D+L.length:D,or=new Float64Array(ar);return or.set(U),s&&or.set(L,D),or},R}),define("Core/CorridorGeometryLibrary",["./Cartesian3","./CornerType","./defined","./Math","./Matrix3","./PolylinePipeline","./PolylineVolumeGeometryLibrary","./Quaternion"],function(e,r,t,n,i,a,o,s){"use strict";function u(t,a,o,u,l){var f=e.angleBetween(e.subtract(a,t,w),e.subtract(o,t,m)),c=u===r.BEVELED?1:Math.ceil(f/n.toRadians(5))+1,h=3*c,d=new Array(h);d[h-3]=o.x,d[h-2]=o.y,d[h-1]=o.z;var y;y=l?i.fromQuaternion(s.fromAxisAngle(e.negate(t,w),f/c,P),A):i.fromQuaternion(s.fromAxisAngle(t,f/c,P),A);var p=0;a=e.clone(a,w);for(var v=0;c>v;v++)a=i.multiplyByVector(y,a,a),d[p++]=a.x,d[p++]=a.y,d[p++]=a.z;return d}function l(t){var n=g,i=q,a=x,o=t[1];i=e.fromArray(t[1],o.length-3,i),a=e.fromArray(t[0],0,a),n=e.multiplyByScalar(e.add(i,a,n),.5,n);var s=u(n,i,a,r.ROUNDED,!1),l=t.length-1,f=t[l-1];o=t[l],i=e.fromArray(f,f.length-3,i),a=e.fromArray(o,0,a),n=e.multiplyByScalar(e.add(i,a,n),.5,n);var c=u(n,i,a,r.ROUNDED,!1);return[s,c]}function f(r,t,n,i){var a=w;return i?a=e.add(r,t,a):(t=e.negate(t,t),a=e.add(r,t,a)),[a.x,a.y,a.z,n.x,n.y,n.z]}function c(r,t,n,i){for(var a=new Array(r.length),o=new Array(r.length),s=e.multiplyByScalar(t,n,w),u=e.negate(s,m),l=0,f=r.length-1,c=0;c<r.length;c+=3){var h=e.fromArray(r,c,y),d=e.add(h,u,p);a[l++]=d.x,a[l++]=d.y,a[l++]=d.z;var v=e.add(h,s,p);o[f--]=v.z,o[f--]=v.y,o[f--]=v.x}return i.push(a,o),i}function h(e,r){for(var t=0;t<e.length;t++)e[t]=r.scaleToGeodeticSurface(e[t],e[t]);return e}var d={},w=new e,m=new e,y=new e,p=new e,v=[new e,new e],g=new e,q=new e,x=new e,b=new e,E=new e,S=new e,M=new e,_=new e,O=new e,T=new e,P=new s,A=new i;return d.addAttribute=function(e,r,n,i){var a=r.x,o=r.y,s=r.z;t(n)&&(e[n]=a,e[n+1]=o,e[n+2]=s),t(i)&&(e[i]=s,e[i-1]=o,e[i-2]=a)},d.computePositions=function(t){var i=t.granularity,s=t.positions,d=t.ellipsoid;s=h(s,d);var m=t.width/2,y=t.cornerType,p=t.saveAttributes,P=g,A=q,N=x,z=b,R=E,C=S,I=M,D=_,U=O,L=T,B=[],F=p?[]:void 0,W=p?[]:void 0,G=s[0],V=s[1];A=e.normalize(e.subtract(V,G,A),A),P=d.geodeticSurfaceNormal(G,P),z=e.normalize(e.cross(P,A,z),z),p&&(F.push(z.x,z.y,z.z),W.push(P.x,P.y,P.z)),I=e.clone(G,I),G=V,N=e.negate(A,N);var j,Y,H=[],k=s.length;for(Y=1;k-1>Y;Y++){P=d.geodeticSurfaceNormal(G,P),V=s[Y+1],A=e.normalize(e.subtract(V,G,A),A),R=e.normalize(e.add(A,N,R),R);var Z=!e.equalsEpsilon(e.negate(R,w),P,n.EPSILON2);if(Z){R=e.cross(R,P,R),R=e.cross(P,R,R);var X=m/Math.max(.25,e.magnitude(e.cross(R,N,w))),J=o.angleIsGreaterThanPi(A,N,G,d);R=e.multiplyByScalar(R,X,R),J?(D=e.add(G,R,D),L=e.add(D,e.multiplyByScalar(z,m,L),L),U=e.add(D,e.multiplyByScalar(z,2*m,U),U),v[0]=e.clone(I,v[0]),v[1]=e.clone(L,v[1]),j=a.scaleToSurface(v,i,d),B=c(j,z,m,B),p&&(F.push(z.x,z.y,z.z),W.push(P.x,P.y,P.z)),C=e.clone(U,C),z=e.normalize(e.cross(P,A,z),z),U=e.add(D,e.multiplyByScalar(z,2*m,U),U),I=e.add(D,e.multiplyByScalar(z,m,I),I),y===r.ROUNDED||y===r.BEVELED?H.push({leftPositions:u(D,C,U,y,J)}):H.push({leftPositions:f(G,e.negate(R,R),U,J)})):(U=e.add(G,R,U),L=e.add(U,e.negate(e.multiplyByScalar(z,m,L),L),L),D=e.add(U,e.negate(e.multiplyByScalar(z,2*m,D),D),D),v[0]=e.clone(I,v[0]),v[1]=e.clone(L,v[1]),j=a.scaleToSurface(v,i,d),B=c(j,z,m,B),p&&(F.push(z.x,z.y,z.z),W.push(P.x,P.y,P.z)),C=e.clone(D,C),z=e.normalize(e.cross(P,A,z),z),D=e.add(U,e.negate(e.multiplyByScalar(z,2*m,D),D),D),I=e.add(U,e.negate(e.multiplyByScalar(z,m,I),I),I),y===r.ROUNDED||y===r.BEVELED?H.push({rightPositions:u(U,C,D,y,J)}):H.push({rightPositions:f(G,R,D,J)})),N=e.negate(A,N)}G=V}P=d.geodeticSurfaceNormal(G,P),v[0]=e.clone(I,v[0]),v[1]=e.clone(G,v[1]),j=a.scaleToSurface(v,i,d),B=c(j,z,m,B),p&&(F.push(z.x,z.y,z.z),W.push(P.x,P.y,P.z));var Q;return y===r.ROUNDED&&(Q=l(B)),{positions:B,corners:H,lefts:F,normals:W,endPositions:Q}},d}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.attributes))throw new t("options.attributes is required.");if(!r(n.primitiveType))throw new t("options.primitiveType is required.");this.attributes=n.attributes,this.indices=n.indices,this.primitiveType=n.primitiveType,this.boundingSphere=n.boundingSphere};return n.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&r(e.attributes[i])&&r(e.attributes[i].values)){var a=e.attributes[i],o=a.values.length/a.componentsPerAttribute;if(n!==o&&-1!==n)throw new t("All attribute lists must have the same number of attributes.");n=o}return n},n}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(n.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(n.values))throw new t("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/IndexDatatype",["./defined","./DeveloperError","./Math"],function(e,r,t){"use strict";var n={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return n.getSizeInBytes=function(e){switch(e){case n.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case n.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case n.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new r("indexDatatype is required and must be a valid IndexDatatype constant.")},n.validate=function(r){return e(r)&&(r===n.UNSIGNED_BYTE||r===n.UNSIGNED_SHORT||r===n.UNSIGNED_INT)},n.createTypedArray=function(n,i){if(!e(n))throw new r("numberOfVertices is required.");return n>t.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},n}),define("Core/PrimitiveType",[],function(){"use strict";var e={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(r){return r===e.POINTS||r===e.LINES||r===e.LINE_LOOP||r===e.LINE_STRIP||r===e.TRIANGLES||r===e.TRIANGLE_STRIP||r===e.TRIANGLE_FAN}};return e}),define("Core/VertexFormat",["./defaultValue","./freezeObject"],function(e,r){"use strict";var t=function(r){r=e(r,e.EMPTY_OBJECT),this.position=e(r.position,!1),this.normal=e(r.normal,!1),this.st=e(r.st,!1),this.binormal=e(r.binormal,!1),this.tangent=e(r.tangent,!1)};return t.POSITION_ONLY=r(new t({position:!0})),t.POSITION_AND_NORMAL=r(new t({position:!0,normal:!0})),t.POSITION_NORMAL_AND_ST=r(new t({position:!0,normal:!0,st:!0})),t.POSITION_AND_ST=r(new t({position:!0,st:!0})),t.ALL=r(new t({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),t.DEFAULT=t.POSITION_NORMAL_AND_ST,t}),define("Core/CorridorGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./CornerType","./CorridorGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType","./VertexFormat"],function(e,r,t,n,i,a,o,s,u,l,f,c,h,d,w,m,y){"use strict";function p(e,t,n,a,o,s){var u=e.normals,l=e.tangents,f=e.binormals,c=r.normalize(r.cross(n,t,T),T);s.normal&&i.addAttribute(u,t,a,o),s.binormal&&i.addAttribute(f,n,a,o),s.tangent&&i.addAttribute(l,c,a,o)}function v(e,n,a){var s,u,l,w=e.positions,m=e.corners,y=e.endPositions,v=e.lefts,g=e.normals,q=new c,x=0,_=0,A=0;for(u=0;u<w.length;u+=2)l=w[u].length-3,x+=l,A+=2*l,_+=w[u+1].length-3;for(x+=3,_+=3,u=0;u<m.length;u++){s=m[u];var N=m[u].leftPositions;o(N)?(l=N.length,x+=l,A+=l):(l=m[u].rightPositions.length,_+=l,A+=l)}var z,R=o(y);R&&(z=y[0].length-3,x+=z,_+=z,z/=3,A+=6*z);var C,I,D,U,L,B,F=x+_,W=new Float64Array(F),G=n.normal?new Float32Array(F):void 0,V=n.tangent?new Float32Array(F):void 0,j=n.binormal?new Float32Array(F):void 0,Y={normals:G,tangents:V,binormals:j},H=0,k=F-1,Z=b,X=E,J=z/2,Q=h.createTypedArray(F/3,A),$=0;if(R){B=S,L=M;var K=y[0];for(Z=r.fromArray(g,0,Z),X=r.fromArray(v,0,X),u=0;J>u;u++)B=r.fromArray(K,3*(J-1-u),B),L=r.fromArray(K,3*(J+u),L),i.addAttribute(W,L,H),i.addAttribute(W,B,void 0,k),p(Y,Z,X,H,k,n),I=H/3,U=I+1,C=(k-2)/3,D=C-1,Q[$++]=C,Q[$++]=I,Q[$++]=D,Q[$++]=D,Q[$++]=I,Q[$++]=U,H+=3,k-=3}var er=0,rr=0,tr=w[er++],nr=w[er++];W.set(tr,H),W.set(nr,k-nr.length+1),X=r.fromArray(v,rr,X);var ir,ar;for(l=nr.length-3,u=0;l>u;u+=3)ir=a.geodeticSurfaceNormal(r.fromArray(tr,u,T),T),ar=a.geodeticSurfaceNormal(r.fromArray(nr,l-u,P),P),Z=r.normalize(r.add(ir,ar,Z),Z),p(Y,Z,X,H,k,n),I=H/3,U=I+1,C=(k-2)/3,D=C-1,Q[$++]=C,Q[$++]=I,Q[$++]=D,Q[$++]=D,Q[$++]=I,Q[$++]=U,H+=3,k-=3;for(ir=a.geodeticSurfaceNormal(r.fromArray(tr,l,T),T),ar=a.geodeticSurfaceNormal(r.fromArray(nr,l,P),P),Z=r.normalize(r.add(ir,ar,Z),Z),rr+=3,u=0;u<m.length;u++){var or;s=m[u];var sr,ur,lr=s.leftPositions,fr=s.rightPositions,cr=O,hr=S,dr=M;if(Z=r.fromArray(g,rr,Z),o(lr)){for(p(Y,Z,X,void 0,k,n),k-=3,sr=U,ur=D,or=0;or<lr.length/3;or++)cr=r.fromArray(lr,3*or,cr),Q[$++]=sr,Q[$++]=ur-or-1,Q[$++]=ur-or,i.addAttribute(W,cr,void 0,k),hr=r.fromArray(W,3*(ur-or-1),hr),dr=r.fromArray(W,3*sr,dr),X=r.normalize(r.subtract(hr,dr,X),X),p(Y,Z,X,void 0,k,n),k-=3;cr=r.fromArray(W,3*sr,cr),hr=r.subtract(r.fromArray(W,3*ur,hr),cr,hr),dr=r.subtract(r.fromArray(W,3*(ur-or),dr),cr,dr),X=r.normalize(r.add(hr,dr,X),X),p(Y,Z,X,H,void 0,n),H+=3}else{for(p(Y,Z,X,H,void 0,n),H+=3,sr=D,ur=U,or=0;or<fr.length/3;or++)cr=r.fromArray(fr,3*or,cr),Q[$++]=sr,Q[$++]=ur+or,Q[$++]=ur+or+1,i.addAttribute(W,cr,H),hr=r.fromArray(W,3*sr,hr),dr=r.fromArray(W,3*(ur+or),dr),X=r.normalize(r.subtract(hr,dr,X),X),p(Y,Z,X,H,void 0,n),H+=3;cr=r.fromArray(W,3*sr,cr),hr=r.subtract(r.fromArray(W,3*(ur+or),hr),cr,hr),dr=r.subtract(r.fromArray(W,3*ur,dr),cr,dr),X=r.normalize(r.negate(r.add(dr,hr,X),X),X),p(Y,Z,X,void 0,k,n),k-=3}for(tr=w[er++],nr=w[er++],tr.splice(0,3),nr.splice(nr.length-3,3),W.set(tr,H),W.set(nr,k-nr.length+1),l=nr.length-3,rr+=3,X=r.fromArray(v,rr,X),or=0;or<nr.length;or+=3)ir=a.geodeticSurfaceNormal(r.fromArray(tr,or,T),T),ar=a.geodeticSurfaceNormal(r.fromArray(nr,l-or,P),P),Z=r.normalize(r.add(ir,ar,Z),Z),p(Y,Z,X,H,k,n),U=H/3,I=U-1,D=(k-2)/3,C=D+1,Q[$++]=C,Q[$++]=I,Q[$++]=D,Q[$++]=D,Q[$++]=I,Q[$++]=U,H+=3,k-=3;H-=3,k+=3}if(Z=r.fromArray(g,g.length-3,Z),p(Y,Z,X,H,k,n),R){H+=3,k-=3,B=S,L=M;var wr=y[1];for(u=0;J>u;u++)B=r.fromArray(wr,3*(z-u-1),B),L=r.fromArray(wr,3*u,L),i.addAttribute(W,B,void 0,k),i.addAttribute(W,L,H),p(Y,Z,X,H,k,n),U=H/3,I=U-1,D=(k-2)/3,C=D+1,Q[$++]=C,Q[$++]=I,Q[$++]=D,Q[$++]=D,Q[$++]=I,Q[$++]=U,H+=3,k-=3}if(q.position=new f({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:W}),n.st){var mr,yr,pr=new Float32Array(2*(F/3)),vr=0;if(R){x/=3,_/=3;var gr=Math.PI/(z+1);yr=1/(x-z+1),mr=1/(_-z+1);var qr,xr=z/2;for(u=xr+1;z+1>u;u++)qr=d.PI_OVER_TWO+gr*u,pr[vr++]=mr*(1+Math.cos(qr)),pr[vr++]=.5*(1+Math.sin(qr));for(u=1;_-z+1>u;u++)pr[vr++]=u*mr,pr[vr++]=0;for(u=z;u>xr;u--)qr=d.PI_OVER_TWO-u*gr,pr[vr++]=1-mr*(1+Math.cos(qr)),pr[vr++]=.5*(1+Math.sin(qr));for(u=xr;u>0;u--)qr=d.PI_OVER_TWO-gr*u,pr[vr++]=1-yr*(1+Math.cos(qr)),pr[vr++]=.5*(1+Math.sin(qr));for(u=x-z;u>0;u--)pr[vr++]=u*yr,pr[vr++]=1;for(u=1;xr+1>u;u++)qr=d.PI_OVER_TWO+gr*u,pr[vr++]=yr*(1+Math.cos(qr)),pr[vr++]=.5*(1+Math.sin(qr))}else{for(x/=3,_/=3,yr=1/(x-1),mr=1/(_-1),u=0;_>u;u++)pr[vr++]=u*mr,pr[vr++]=0;for(u=x;u>0;u--)pr[vr++]=(u-1)*yr,pr[vr++]=1}q.st=new f({componentDatatype:t.FLOAT,componentsPerAttribute:2,values:pr})}return n.normal&&(q.normal=new f({componentDatatype:t.FLOAT,componentsPerAttribute:3,values:Y.normals})),n.tangent&&(q.tangent=new f({componentDatatype:t.FLOAT,componentsPerAttribute:3,values:Y.tangents})),n.binormal&&(q.binormal=new f({componentDatatype:t.FLOAT,componentsPerAttribute:3,values:Y.binormals})),{attributes:q,indices:Q}}function g(e,t){if(!(t.normal||t.binormal||t.tangent||t.st))return e;var n,a,o=e.position.values;(t.normal||t.binormal)&&(n=e.normal.values,a=e.binormal.values);var s,u=e.position.values.length/18,l=3*u,f=2*u,c=2*l;if(t.normal||t.binormal||t.tangent){var h=t.normal?new Float32Array(6*l):void 0,d=t.binormal?new Float32Array(6*l):void 0,w=t.tangent?new Float32Array(6*l):void 0,m=b,y=E,p=S,v=M,g=_,q=O,x=c;for(s=0;l>s;s+=3){var T=x+c;m=r.fromArray(o,s,m),y=r.fromArray(o,s+l,y),p=r.fromArray(o,(s+3)%l,p),y=r.subtract(y,m,y),p=r.subtract(p,m,p),v=r.normalize(r.cross(y,p,v),v),t.normal&&(i.addAttribute(h,v,T),i.addAttribute(h,v,T+3),i.addAttribute(h,v,x),i.addAttribute(h,v,x+3)),(t.tangent||t.binormal)&&(q=r.fromArray(n,s,q),t.binormal&&(i.addAttribute(d,q,T),i.addAttribute(d,q,T+3),i.addAttribute(d,q,x),i.addAttribute(d,q,x+3)),t.tangent&&(g=r.normalize(r.cross(q,v,g),g),i.addAttribute(w,g,T),i.addAttribute(w,g,T+3),i.addAttribute(w,g,x),i.addAttribute(w,g,x+3))),x+=6}if(t.normal){for(h.set(n),s=0;l>s;s+=3)h[s+l]=-n[s],h[s+l+1]=-n[s+1],h[s+l+2]=-n[s+2];e.normal.values=h}else e.normal=void 0;if(t.binormal?(d.set(a),d.set(a,l),e.binormal.values=d):e.binormal=void 0,t.tangent){var P=e.tangent.values;w.set(P),w.set(P,l),e.tangent.values=w}}if(t.st){var A=e.st.values,N=new Float32Array(6*f);N.set(A),N.set(A,f);for(var z=2*f,R=0;2>R;R++){for(N[z++]=A[0],N[z++]=A[1],s=2;f>s;s+=2){var C=A[s],I=A[s+1];N[z++]=C,N[z++]=I,N[z++]=C,N[z++]=I}N[z++]=A[0],N[z++]=A[1]}e.st.values=N}return e}function q(e,r,t){t[r++]=e[0],t[r++]=e[1],t[r++]=e[2];for(var n=3;n<e.length;n+=3){var i=e[n],a=e[n+1],o=e[n+2];t[r++]=i,t[r++]=a,t[r++]=o,t[r++]=i,t[r++]=a,t[r++]=o}return t[r++]=e[0],t[r++]=e[1],t[r++]=e[2],t}function x(e,r){var t=new y({position:r.positon,normal:r.normal||r.binormal,tangent:r.tangent,binormal:r.normal||r.binormal,st:r.st}),n=e.ellipsoid,a=i.computePositions(e),o=v(a,t,n),s=e.height,u=e.extrudedHeight,l=o.attributes,f=o.indices,c=l.position.values,d=c.length,m=new Float64Array(6*d),p=new Float64Array(d);p.set(c);var x=new Float64Array(4*d);c=w.scaleToGeodeticHeight(c,s,n,c),x=q(c,0,x),p=w.scaleToGeodeticHeight(p,u,n,p),x=q(p,2*d,x),m.set(c),m.set(p,d),m.set(x,2*d),l.position.values=m,d/=3;var b,E=f.length,S=d+d,M=h.createTypedArray(m.length/3,2*E+3*S);M.set(f);var _=E;
for(b=0;E>b;b+=3){var O=f[b],T=f[b+1],P=f[b+2];M[_++]=P+d,M[_++]=T+d,M[_++]=O+d}l=g(l,r);var A,N,z,R;for(b=0;S>b;b+=2)A=b+S,N=A+S,z=A+1,R=N+1,M[_++]=A,M[_++]=N,M[_++]=z,M[_++]=z,M[_++]=N,M[_++]=R;return{attributes:l,indices:M}}var b=new r,E=new r,S=new r,M=new r,_=new r,O=new r,T=new r,P=new r,A=function(e){e=a(e,a.EMPTY_OBJECT);var r=e.positions,t=e.width;if(!o(r))throw new s("options.positions is required.");if(!o(t))throw new s("options.width is required.");this._positions=r,this._width=t,this._ellipsoid=a(e.ellipsoid,u.WGS84),this._height=a(e.height,0),this._extrudedHeight=a(e.extrudedHeight,this._height),this._cornerType=a(e.cornerType,n.ROUNDED),this._vertexFormat=a(e.vertexFormat,y.DEFAULT),this._granularity=a(e.granularity,d.RADIANS_PER_DEGREE),this._workerName="createCorridorGeometry"};return A.createGeometry=function(r){var t=r._positions,n=r._height,a=r._extrudedHeight,o=n!==a,u=w.removeDuplicates(t);if(u.length<2)throw new s("Count of unique positions must be greater than 1.");var f,c=r._ellipsoid,h=r._vertexFormat,d={ellipsoid:c,positions:u,width:r._width,cornerType:r._cornerType,granularity:r._granularity,saveAttributes:!0};if(o){var y=Math.max(n,a);a=Math.min(n,a),n=y,d.height=n,d.extrudedHeight=a,f=x(d,h)}else{var p=i.computePositions(d);f=v(p,h,c),f.attributes.position.values=w.scaleToGeodeticHeight(f.attributes.position.values,n,c,f.attributes.position.values)}var g=f.attributes,q=e.fromVertices(g.position.values,void 0,3);return h.position||(f.attributes.position.values=void 0),new l({attributes:g,indices:f.indices,primitiveType:m.TRIANGLES,boundingSphere:q})},A}),define("Workers/createCorridorGeometry",["../Core/CorridorGeometry","../Core/Ellipsoid"],function(e,r){"use strict";function t(t){return t._ellipsoid=r.clone(t._ellipsoid),e.createGeometry(t)}return t})}();