/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2014 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=.5*3*Math.PI,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,o=e-Math.floor(e/r)*r;return o<-Math.PI?o+r:o>=Math.PI?o-r:o},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");for(var r=i.EPSILON10,o=i.PI,a=i.TWO_PI;-(o+r)>e;)e+=a;if(-o>e)return-o;for(;e>o+r;)e-=a;return e>o?o:e},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=e%i.TWO_PI;return 0>r?(r+i.TWO_PI)%i.TWO_PI:r},i.equalsEpsilon=function(e,i,o){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");return o=r(o,0),Math.abs(e-i)<=o};var o=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=o.length;if(e>=r)for(var t=o[r-1],i=r;e>=i;i++)o.push(t*i);return o[e]},i.incrementWrap=function(e,i,o){if(o=r(o,0),!t(e))throw new n("n is required.");if(o>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=o),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var a=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");a=new e(r)},i.nextRandomNumber=function(){return a.random()},i.acosClamped=function(e){return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){return Math.asin(i.clamp(e,-1,1))},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};o.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new o);var a=n.clock,s=n.cone,u=e(n.magnitude,1),f=u*Math.sin(s);return i.x=f*Math.cos(a),i.y=f*Math.sin(a),i.z=u*Math.cos(s),i},o.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new o(e,t,n)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o]=n.z},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i],a},o.fromArray=o.unpack,o.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},o.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},o.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},o.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var s=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,s),a=o.multiplyByScalar(e,1-i,a),o.add(s,a,a)};var u=new o,f=new o;o.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");o.normalize(e,u),o.normalize(n,f);var i=o.dot(u,f),a=o.magnitude(o.cross(u,f,u));return Math.atan2(a,i)};var l=new o;o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,l);return o.abs(i,i),n=i.x<=i.y?i.x<=i.z?o.clone(o.UNIT_X,n):o.clone(o.UNIT_Z,n):i.y<=i.z?o.clone(o.UNIT_Y,n):o.clone(o.UNIT_Z,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i},o.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var o=e.x,a=e.y,s=e.z,u=n.x,f=n.y,l=n.z,c=a*l-s*f,h=s*u-o*l,m=o*f-a*u;return i.x=c,i.y=h,i.z=m,i},o.fromDegrees=function(e,n,a,s,u){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var f=i.toRadians(e),l=i.toRadians(n);return o.fromRadians(f,l,a,s,u)};var c=new o,h=new o,m=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(n,i,a,s,u){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");a=e(a,0);var f=r(s)?s.radiiSquared:m,l=Math.cos(i);c.x=l*Math.cos(n),c.y=l*Math.sin(n),c.z=Math.sin(i),c=o.normalize(c,c),o.multiplyComponents(f,c,h);var w=Math.sqrt(o.dot(c,h));return h=o.divideByScalar(h,w,h),c=o.multiplyByScalar(c,a,c),r(u)||(u=new o),o.add(h,c,u)},o.fromDegreesArray=function(e,n,a){if(!r(e))throw new t("positions is required.");for(var s=new Array(e.length),u=0;u<e.length;u++)s[u]=i.toRadians(e[u]);return o.fromRadiansArray(s,n,a)},o.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(0!==e.length%2)throw new t("positions length must be a multiple of 2.");var a=e.length;r(i)?i.length=a/2:i=new Array(a/2);for(var s=0;a>s;s+=2){var u=e[s],f=e[s+1];i[s/2]=o.fromRadians(u,f,0,n,i[s/2])}return i},o.fromDegreesArrayHeights=function(e,n,a){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");for(var s=new Array(e.length),u=0;u<e.length;u+=3)s[u]=i.toRadians(e[u]),s[u+1]=i.toRadians(e[u+1]),s[u+2]=e[u+2];return o.fromRadiansArrayHeights(s,n,a)},o.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");var a=e.length;r(i)?i.length=a/3:i=new Array(a/3);for(var s=0;a>s;s+=3){var u=e[s],f=e[s+1],l=e[s+2];i[s/3]=o.fromRadians(u,f,l,n,i[s/3])}return i},o.ZERO=n(new o(0,0,0)),o.UNIT_X=n(new o(1,0,0)),o.UNIT_Y=n(new o(0,1,0)),o.UNIT_Z=n(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return o.fromRadians=function(n,i,a,s){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return a=e(a,0),r(s)?(s.longitude=n,s.latitude=i,s.height=a,s):new o(n,i,a)},o.fromDegrees=function(e,n,a,s){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),o.fromRadians(e,n,a,s)},o.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},o.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},o.toString=function(e){if(!r(e))throw new t("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},o.ZERO=n(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return o.toString(this)},o}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o,a,s){"use strict";var u=function(r,n,i){if(r=t(r,0),n=t(n,0),i=t(i,0),0>r||0>n||0>i)throw new o("All radii components must be greater than or equal to zero.");this._radii=new e(r,n,i),this._radiiSquared=new e(r*r,n*n,i*i),this._radiiToTheFourth=new e(r*r*r*r,n*n*n*n,i*i*i*i),this._oneOverRadii=new e(0===r?0:1/r,0===n?0:1/n,0===i?0:1/i),this._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===n?0:1/(n*n),0===i?0:1/(i*i)),this._minimumRadius=Math.min(r,n,i),this._maximumRadius=Math.max(r,n,i),this._centerToleranceSquared=s.EPSILON1};i(u.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),u.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new u(i.x,i.y,i.z)},u.fromCartesian3=function(e){return n(e)?new u(e.x,e.y,e.z):new u},u.WGS84=a(new u(6378137,6378137,6356752.314245179)),u.UNIT_SPHERE=a(new u(1,1,1)),u.MOON=a(new u(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.geocentricSurfaceNormal=e.normalize,u.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new o("cartographic is required.");var i=r.longitude,a=r.latitude,s=Math.cos(a),u=s*Math.cos(i),f=s*Math.sin(i),l=Math.sin(a);return n(t)||(t=new e),t.x=u,t.y=f,t.z=l,e.normalize(t,t)},u.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var f=new e,l=new e;u.prototype.cartographicToCartesian=function(r,t){var i=f,o=l;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,o);var a=Math.sqrt(e.dot(i,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(o,i,t)},u.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new o("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var c=new e,h=new e,m=new e;u.prototype.cartesianToCartographic=function(t,i){var o=this.scaleToGeodeticSurface(t,h);if(!n(o))return void 0;var a=this.geodeticSurfaceNormal(o,c),u=e.subtract(t,o,m),f=Math.atan2(a.y,a.x),l=Math.asin(a.z),w=s.sign(e.dot(u,t))*e.magnitude(u);return n(i)?(i.longitude=f,i.latitude=l,i.height=w,i):new r(f,l,w)},u.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new o("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var w=new e,d=new e;return u.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");var i=r.x,a=r.y,u=r.z,f=this._oneOverRadii,l=f.x,c=f.y,h=f.z,m=i*i*l*l,p=a*a*c*c,y=u*u*h*h,g=m+p+y,v=Math.sqrt(1/g),b=e.multiplyByScalar(r,v,w);if(g<this._centerToleranceSquared)return isFinite(v)?e.clone(b,t):void 0;var E=this._oneOverRadiiSquared,C=E.x,S=E.y,q=E.z,x=d;x.x=2*b.x*C,x.y=2*b.y*S,x.z=2*b.z*q;var A,M,T,O,R,I,N,L,P,D,z,F=(1-v)*e.magnitude(r)/(.5*e.magnitude(x)),_=0;do{F-=_,T=1/(1+F*C),O=1/(1+F*S),R=1/(1+F*q),I=T*T,N=O*O,L=R*R,P=I*T,D=N*O,z=L*R,A=m*I+p*N+y*L-1,M=m*P*C+p*D*S+y*z*q;var B=-2*M;_=A/B}while(Math.abs(A)>s.EPSILON12);return n(t)?(t.x=i*T,t.y=a*O,t.z=u*R,t):new e(i*T,a*O,u*R)},u.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");n(t)||(t=new e);var i=r.x,a=r.y,s=r.z,u=this._oneOverRadiiSquared,f=1/Math.sqrt(i*i*u.x+a*a*u.y+s*s*u.z);return e.multiplyByScalar(r,f,t)},u.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},u.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},u.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},u.prototype.toString=function(){return this._radii.toString()},u}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,o,a){"use strict";var s=function(e){this._ellipsoid=t(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(r,t){var i=this._semimajorAxis,o=r.longitude*i,a=r.latitude*i,s=r.height;return n(t)?(t.x=o,t.y=a,t.z=s,t):new e(o,a,s)},s.prototype.unproject=function(e,t){if(!n(e))throw new o("cartesian is required");var i=this._oneOverSemimajorAxis,a=e.x*i,s=e.y*i,u=e.z;return n(t)?(t.longitude=a,t.latitude=s,t.height=u,t):new r(a,s,u)},s}),define("Core/Intersect",[],function(){"use strict";var e={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};i.fromElements=function(e,t,n,o,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=o,a):new i(e,t,n,o)},i.fromColor=function(e,n){if(!r(e))throw new t("color is required");return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o++]=n.z,i[o]=n.w},i.unpack=function(n,o,a){if(!r(n))throw new t("array is required");return o=e(o,0),r(a)||(a=new i),a.x=n[o++],a.y=n[o++],a.z=n[o++],a.w=n[o],a},i.fromArray=i.unpack,i.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},i.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},i.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},i.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},i.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return i.subtract(e,n,o),i.magnitude(o)},i.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var o=i.magnitude(e);return n.x=e.x/o,n.y=e.y/o,n.z=e.z/o,n.w=e.w/o,n},i.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},i.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},i.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},i.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},i.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},i.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},i.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},i.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var a=new i;i.lerp=function(e,n,o,s){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof o)throw new t("t is required and must be a number.");if(!r(s))throw new t("result is required.");return i.multiplyByScalar(n,o,a),s=i.multiplyByScalar(e,1-o,s),i.add(a,s,s)};var s=new i;return i.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var o=i.normalize(e,s);return i.abs(o,o),n=o.x<=o.y?o.x<=o.z?o.x<=o.w?i.clone(i.UNIT_X,n):i.clone(i.UNIT_W,n):o.z<=o.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n):o.y<=o.z?o.y<=o.w?i.clone(i.UNIT_Y,n):i.clone(i.UNIT_W,n):o.z<=o.w?i.clone(i.UNIT_Z,n):i.clone(i.UNIT_W,n)},i.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},i.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i&&Math.abs(e.z-n.z)<=i&&Math.abs(e.w-n.w)<=i},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,r){return i.equalsEpsilon(this,e,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o){"use strict";function a(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function s(e){for(var r=0,t=0;3>t;++t){var n=e[f.getElementIndex(m[t],h[t])];r+=2*n*n}return Math.sqrt(r)}function u(e,r){for(var t=o.EPSILON15,n=0,i=1,a=0;3>a;++a){var s=Math.abs(e[f.getElementIndex(m[a],h[a])]);s>n&&(i=a,n=s)}var u=1,l=0,c=h[i],w=m[i];if(Math.abs(e[f.getElementIndex(w,c)])>t){var d,p=e[f.getElementIndex(w,w)],y=e[f.getElementIndex(c,c)],g=e[f.getElementIndex(w,c)],v=(p-y)/2/g;d=0>v?-1/(-v+Math.sqrt(1+v*v)):1/(v+Math.sqrt(1+v*v)),u=1/Math.sqrt(1+d*d),l=d*u}return r=f.clone(f.IDENTITY,r),r[f.getElementIndex(c,c)]=r[f.getElementIndex(w,w)]=u,r[f.getElementIndex(w,c)]=l,r[f.getElementIndex(c,w)]=-l,r}var f=function(e,t,n,i,o,a,s,u,f){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(s,0),this[3]=r(t,0),this[4]=r(o,0),this[5]=r(u,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(f,0)};f.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new f(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},f.fromArray=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new f),o[0]=e[i],o[1]=e[i+1],o[2]=e[i+2],o[3]=e[i+3],o[4]=e[i+4],o[5]=e[i+5],o[6]=e[i+6],o[7]=e[i+7],o[8]=e[i+8],o[9]=e[i+9],o},f.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},f.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,o=e.x*e.y,a=e.x*e.z,s=e.x*e.w,u=e.y*e.y,l=e.y*e.z,c=e.y*e.w,h=e.z*e.z,m=e.z*e.w,w=e.w*e.w,d=i-u-h+w,p=2*(o-m),y=2*(a+c),g=2*(o+m),v=-i+u-h+w,b=2*(l-s),E=2*(a-c),C=2*(l+s),S=-i-u+h+w;return t(r)?(r[0]=d,r[1]=g,r[2]=E,r[3]=p,r[4]=v,r[5]=C,r[6]=y,r[7]=b,r[8]=S,r):new f(d,p,y,g,v,b,E,C,S)},f.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new f(e.x,0,0,0,e.y,0,0,0,e.z)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new f(e,0,0,0,e,0,0,0,e)},f.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=o,r[6]=0,r[7]=-o,r[8]=i,r):new f(1,0,0,0,i,-o,0,o,i)},f.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=i,r):new f(i,0,o,0,1,0,-o,0,i)},f.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=o,r[2]=0,r[3]=-o,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new f(i,-o,0,o,i,0,0,0,1)},f.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},f.getColumn=function(r,i,o){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var a=3*i,s=r[a],u=r[a+1],f=r[a+2];return t(o)?(o.x=s,o.y=u,o.z=f,o):new e(s,u,f)},f.setColumn=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");o=f.clone(e,o);var a=3*r;return o[a]=i.x,o[a+1]=i.y,o[a+2]=i.z,o},f.getRow=function(r,i,o){if(!t(r))throw new n("matrix is required.");if("number"!=typeof i||0>i||i>2)throw new n("index must be 0, 1, or 2.");var a=r[i],s=r[i+3],u=r[i+6];return t(o)?(o.x=a,o.y=s,o.z=u,o):new e(a,s,u)},f.setRow=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");return o=f.clone(e,o),o[r]=i.x,o[r+3]=i.y,o[r+6]=i.z,o};var l=new e;f.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");return t(i)||(i=new e),i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],l)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],l)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],l)),i};var c=new e;f.getMaximumScale=function(r){return f.getScale(r,c),e.getMaximumComponent(c)},f.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],s=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],l=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],h=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],m=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],w=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return t(i)?(i[0]=o,i[1]=a,i[2]=s,i[3]=u,i[4]=l,i[5]=c,i[6]=h,i[7]=m,i[8]=w,i):new f(o,u,h,a,l,m,s,c,w)},f.multiplyByVector=function(r,i,o){if(!t(r))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");var a=i.x,s=i.y,u=i.z,f=r[0]*a+r[3]*s+r[6]*u,l=r[1]*a+r[4]*s+r[7]*u,c=r[2]*a+r[5]*s+r[8]*u;return t(o)?(o.x=f,o.y=l,o.z=c,o):new e(f,l,c)},f.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");return t(i)?(i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i):new f(e[0]*r,e[3]*r,e[6]*r,e[1]*r,e[4]*r,e[7]*r,e[2]*r,e[5]*r,e[8]*r)},f.negate=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r):new f(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},f.transpose=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],o=e[3],a=e[6],s=e[1],u=e[4],l=e[7],c=e[2],h=e[5],m=e[8];return t(r)?(r[0]=i,r[1]=o,r[2]=a,r[3]=s,r[4]=u,r[5]=l,r[6]=c,r[7]=h,r[8]=m,r):new f(i,s,c,o,u,h,a,l,m)};var h=[1,0,0],m=[2,2,1],w=new f,d=new f;return f.getEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=o.EPSILON20,l=10,c=0,h=0;
t(r)||(r={});for(var m=r.unitary=f.clone(f.IDENTITY,r.unitary),p=r.diagonal=f.clone(e,r.diagonal),y=i*a(p);l>h&&s(p)>y;)u(p,w),f.transpose(w,d),f.multiply(p,w,p),f.multiply(d,p,p),f.multiply(m,w,m),++c>2&&(++h,c=0);return r},f.abs=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r):new f(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},f.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],o=e[6],a=e[1],s=e[4],u=e[7],f=e[2],l=e[5],c=e[8];return r*(s*c-l*u)+a*(l*o-i*c)+f*(i*u-s*o)},f.inverse=function(e,r){if(!t(e))throw new n("matrix is required");var i=e[0],a=e[1],s=e[2],u=e[3],l=e[4],c=e[5],h=e[6],m=e[7],w=e[8],d=f.determinant(e);if(Math.abs(d)<=o.EPSILON15)throw new n("matrix is not invertible");t(r)||(r=new f),r[0]=l*w-m*c,r[1]=m*s-a*w,r[2]=a*c-l*s,r[3]=h*c-u*w,r[4]=i*w-h*s,r[5]=u*s-i*c,r[6]=u*m-h*l,r[7]=h*a-i*m,r[8]=i*l-u*a;var p=1/d;return f.multiplyByScalar(r,p,r)},f.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},f.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},f.IDENTITY=i(new f(1,0,0,0,1,0,0,0,1)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN1ROW0=3,f.COLUMN1ROW1=4,f.COLUMN1ROW2=5,f.COLUMN2ROW0=6,f.COLUMN2ROW1=7,f.COLUMN2ROW2=8,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},f}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,o,a,s,u){"use strict";var f=function(e,r,n,i,o,a,s,u,f,l,c,h,m,w,d,p){this[0]=t(e,0),this[1]=t(o,0),this[2]=t(f,0),this[3]=t(m,0),this[4]=t(r,0),this[5]=t(a,0),this[6]=t(l,0),this[7]=t(w,0),this[8]=t(n,0),this[9]=t(s,0),this[10]=t(c,0),this[11]=t(d,0),this[12]=t(i,0),this[13]=t(u,0),this[14]=t(h,0),this[15]=t(p,0)};f.packedLength=16,f.pack=function(e,r,o){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");o=t(o,0),r[o++]=e[0],r[o++]=e[1],r[o++]=e[2],r[o++]=e[3],r[o++]=e[4],r[o++]=e[5],r[o++]=e[6],r[o++]=e[7],r[o++]=e[8],r[o++]=e[9],r[o++]=e[10],r[o++]=e[11],r[o++]=e[12],r[o++]=e[13],r[o++]=e[14],r[o]=e[15]},f.unpack=function(e,r,o){if(!n(e))throw new i("array is required");return r=t(r,0),n(o)||(o=new f),o[0]=e[r++],o[1]=e[r++],o[2]=e[r++],o[3]=e[r++],o[4]=e[r++],o[5]=e[r++],o[6]=e[r++],o[7]=e[r++],o[8]=e[r++],o[9]=e[r++],o[10]=e[r++],o[11]=e[r++],o[12]=e[r++],o[13]=e[r++],o[14]=e[r++],o[15]=e[r],o},f.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(e,r,t){if(!n(e))throw new i("rotation is required.");if(!n(r))throw new i("translation is required.");return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=0,t[4]=e[3],t[5]=e[4],t[6]=e[5],t[7]=0,t[8]=e[6],t[9]=e[7],t[10]=e[8],t[11]=0,t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=1,t):new f(e[0],e[3],e[6],r.x,e[1],e[4],e[7],r.y,e[2],e[5],e[8],r.z,0,0,0,1)},new s,f.fromTranslationQuaternionRotationScale=function(e,r,t,o){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(o)||(o=new f);var a=t.x,s=t.y,u=t.z,l=r.x*r.x,c=r.x*r.y,h=r.x*r.z,m=r.x*r.w,w=r.y*r.y,d=r.y*r.z,p=r.y*r.w,y=r.z*r.z,g=r.z*r.w,v=r.w*r.w,b=l-w-y+v,E=2*(c-g),C=2*(h+p),S=2*(c+g),q=-l+w-y+v,x=2*(d-m),A=2*(h-p),M=2*(d+m),T=-l-w+y+v;return o[0]=b*a,o[1]=S*a,o[2]=A*a,o[3]=0,o[4]=E*s,o[5]=q*s,o[6]=M*s,o[7]=0,o[8]=C*u,o[9]=x*u,o[10]=T*u,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},f.fromTranslation=function(e,r){return f.fromRotationTranslation(s.IDENTITY,e,r)},f.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,c=new e,h=new e;f.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var o=r.eye,a=r.target,s=r.up;if(!n(o))throw new i("camera.eye is required.");if(!n(a))throw new i("camera.target is required.");if(!n(s))throw new i("camera.up is required.");e.normalize(e.subtract(a,o,l),l),e.normalize(e.cross(l,s,c),c),e.normalize(e.cross(c,l,h),h);var u=c.x,m=c.y,w=c.z,d=l.x,p=l.y,y=l.z,g=h.x,v=h.y,b=h.z,E=o.x,C=o.y,S=o.z,q=u*-E+m*-C+w*-S,x=g*-E+v*-C+b*-S,A=d*E+p*C+y*S;return n(t)?(t[0]=u,t[1]=g,t[2]=-d,t[3]=0,t[4]=m,t[5]=v,t[6]=-p,t[7]=0,t[8]=w,t[9]=b,t[10]=-y,t[11]=0,t[12]=q,t[13]=x,t[14]=A,t[15]=1,t):new f(u,m,w,q,g,v,b,x,-d,-p,-y,A,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,r,t,o,a){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=o)throw new i("far must be greater than zero.");var s=Math.tan(.5*e),u=1/s,l=u/r,c=(o+t)/(t-o),h=2*o*t/(t-o);return n(a)?(a[0]=l,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=c,a[11]=-1,a[12]=0,a[13]=0,a[14]=h,a[15]=0,a):new f(l,0,0,0,0,u,0,0,0,0,c,h,0,0,-1,0)},f.computeOrthographicOffCenter=function(e,r,t,o,a,s,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(s))throw new i("far is required.");var l=1/(r-e),c=1/(o-t),h=1/(s-a),m=-(r+e)*l,w=-(o+t)*c,d=-(s+a)*h;return l*=2,c*=2,h*=-2,n(u)?(u[0]=l,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=h,u[11]=0,u[12]=m,u[13]=w,u[14]=d,u[15]=1,u):new f(l,0,0,m,0,c,0,w,0,0,h,d,0,0,0,1)},f.computePerspectiveOffCenter=function(e,r,t,o,a,s,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(s))throw new i("far is required.");var l=2*a/(r-e),c=2*a/(o-t),h=(r+e)/(r-e),m=(o+t)/(o-t),w=-(s+a)/(s-a),d=-1,p=-2*s*a/(s-a);return n(u)?(u[0]=l,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=h,u[9]=m,u[10]=w,u[11]=d,u[12]=0,u[13]=0,u[14]=p,u[15]=0,u):new f(l,0,h,0,0,c,m,0,0,0,w,p,0,0,d,0)},f.computeInfinitePerspectiveOffCenter=function(e,r,t,o,a,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");var u=2*a/(r-e),l=2*a/(o-t),c=(r+e)/(r-e),h=(o+t)/(o-t),m=-1,w=-1,d=-2*a;return n(s)?(s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=l,s[6]=0,s[7]=0,s[8]=c,s[9]=h,s[10]=m,s[11]=w,s[12]=0,s[13]=0,s[14]=d,s[15]=0,s):new f(u,0,c,0,0,l,h,0,0,0,m,d,0,0,w,0)},f.computeViewportTransformation=function(e,r,i,o){e=t(e,t.EMPTY_OBJECT);var a=t(e.x,0),s=t(e.y,0),u=t(e.width,0),l=t(e.height,0);r=t(r,0),i=t(i,1);var c=.5*u,h=.5*l,m=.5*(i-r),w=c,d=h,p=m,y=a+c,g=s+h,v=r+m,b=1;return n(o)?(o[0]=w,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=d,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=p,o[11]=0,o[12]=y,o[13]=g,o[14]=v,o[15]=b,o):new f(w,0,0,y,0,d,0,g,0,0,p,v,0,0,0,b)},f.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},f.getColumn=function(e,t,o){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var a=4*t,s=e[a],u=e[a+1],f=e[a+2],l=e[a+3];return n(o)?(o.x=s,o.y=u,o.z=f,o.w=l,o):new r(s,u,f,l)},f.setColumn=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");o=f.clone(e,o);var a=4*r;return o[a]=t.x,o[a+1]=t.y,o[a+2]=t.z,o[a+3]=t.w,o},f.getRow=function(e,t,o){if(!n(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new i("index must be 0, 1, 2, or 3.");var a=e[t],s=e[t+4],u=e[t+8],f=e[t+12];return n(o)?(o.x=a,o.y=s,o.z=u,o.w=f,o):new r(a,s,u,f)},f.setRow=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");return o=f.clone(e,o),o[r]=t.x,o[r+4]=t.y,o[r+8]=t.z,o[r+12]=t.w,o};var m=new e;f.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");return n(t)||(t=new e),t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],m)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],m)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],m)),t};var w=new e;f.getMaximumScale=function(r){return f.getScale(r,w),e.getMaximumComponent(w)},f.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var o=e[0],a=e[1],s=e[2],u=e[3],l=e[4],c=e[5],h=e[6],m=e[7],w=e[8],d=e[9],p=e[10],y=e[11],g=e[12],v=e[13],b=e[14],E=e[15],C=r[0],S=r[1],q=r[2],x=r[3],A=r[4],M=r[5],T=r[6],O=r[7],R=r[8],I=r[9],N=r[10],L=r[11],P=r[12],D=r[13],z=r[14],F=r[15],_=o*C+l*S+w*q+g*x,B=a*C+c*S+d*q+v*x,U=s*C+h*S+p*q+b*x,G=u*C+m*S+y*q+E*x,k=o*A+l*M+w*T+g*O,W=a*A+c*M+d*T+v*O,V=s*A+h*M+p*T+b*O,Y=u*A+m*M+y*T+E*O,H=o*R+l*I+w*N+g*L,j=a*R+c*I+d*N+v*L,K=s*R+h*I+p*N+b*L,Z=u*R+m*I+y*N+E*L,X=o*P+l*D+w*z+g*F,Q=a*P+c*D+d*z+v*F,J=s*P+h*D+p*z+b*F,$=u*P+m*D+y*z+E*F;return n(t)?(t[0]=_,t[1]=B,t[2]=U,t[3]=G,t[4]=k,t[5]=W,t[6]=V,t[7]=Y,t[8]=H,t[9]=j,t[10]=K,t[11]=Z,t[12]=X,t[13]=Q,t[14]=J,t[15]=$,t):new f(_,k,H,X,B,W,j,Q,U,V,K,J,G,Y,Z,$)},f.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");var o=e[0],a=e[1],s=e[2],u=e[4],l=e[5],c=e[6],h=e[8],m=e[9],w=e[10],d=e[12],p=e[13],y=e[14],g=r[0],v=r[1],b=r[2],E=r[4],C=r[5],S=r[6],q=r[8],x=r[9],A=r[10],M=r[12],T=r[13],O=r[14],R=o*g+u*v+h*b,I=a*g+l*v+m*b,N=s*g+c*v+w*b,L=o*E+u*C+h*S,P=a*E+l*C+m*S,D=s*E+c*C+w*S,z=o*q+u*x+h*A,F=a*q+l*x+m*A,_=s*q+c*x+w*A,B=o*M+u*T+h*O+d,U=a*M+l*T+m*O+p,G=s*M+c*T+w*O+y;return n(t)?(t[0]=R,t[1]=I,t[2]=N,t[3]=0,t[4]=L,t[5]=P,t[6]=D,t[7]=0,t[8]=z,t[9]=F,t[10]=_,t[11]=0,t[12]=B,t[13]=U,t[14]=G,t[15]=1,t):new f(R,L,z,B,I,P,F,U,N,D,_,G,0,0,0,1)},f.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");var o=r.x,a=r.y,s=r.z,u=o*e[0]+a*e[4]+s*e[8]+e[12],l=o*e[1]+a*e[5]+s*e[9]+e[13],c=o*e[2]+a*e[6]+s*e[10]+e[14];return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=u,t[13]=l,t[14]=c,t[15]=e[15],t):new f(e[0],e[4],e[8],u,e[1],e[5],e[9],l,e[2],e[6],e[10],c,e[3],e[7],e[11],e[15])};var d=new e;return f.multiplyByUniformScale=function(e,r,t){if("number"!=typeof r)throw new i("scale is required");return d.x=r,d.y=r,d.z=r,f.multiplyByScale(e,d,t)},f.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");var o=r.x,a=r.y,s=r.z;return 1===o&&1===a&&1===s?f.clone(e,t):n(t)?(t[0]=o*e[0],t[1]=o*e[1],t[2]=o*e[2],t[3]=0,t[4]=a*e[4],t[5]=a*e[5],t[6]=a*e[6],t[7]=0,t[8]=s*e[8],t[9]=s*e[9],t[10]=s*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t):new f(o*e[0],a*e[4],s*e[8],e[12],o*e[1],a*e[5],s*e[9],e[13],o*e[2],a*e[6],s*e[10],e[14],0,0,0,1)},f.multiplyByVector=function(e,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var a=t.x,s=t.y,u=t.z,f=t.w,l=e[0]*a+e[4]*s+e[8]*u+e[12]*f,c=e[1]*a+e[5]*s+e[9]*u+e[13]*f,h=e[2]*a+e[6]*s+e[10]*u+e[14]*f,m=e[3]*a+e[7]*s+e[11]*u+e[15]*f;return n(o)?(o.x=l,o.y=c,o.z=h,o.w=m,o):new r(l,c,h,m)},f.multiplyByPointAsVector=function(r,t,o){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var a=t.x,s=t.y,u=t.z,f=r[0]*a+r[4]*s+r[8]*u,l=r[1]*a+r[5]*s+r[9]*u,c=r[2]*a+r[6]*s+r[10]*u;return n(o)?(o.x=f,o.y=l,o.z=c,o):new e(f,l,c)},f.multiplyByPoint=function(r,t,o){if(!n(r))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");var a=t.x,s=t.y,u=t.z,f=r[0]*a+r[4]*s+r[8]*u+r[12],l=r[1]*a+r[5]*s+r[9]*u+r[13],c=r[2]*a+r[6]*s+r[10]*u+r[14];return n(o)?(o.x=f,o.y=l,o.z=c,o):new e(f,l,c)},f.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");return n(t)?(t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t):new f(e[0]*r,e[4]*r,e[8]*r,e[12]*r,e[1]*r,e[5]*r,e[9]*r,e[13]*r,e[2]*r,e[6]*r,e[10]*r,e[14]*r,e[3]*r,e[7]*r,e[11]*r,e[15]*r)},f.negate=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r):new f(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},f.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))return new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var t=e[1],o=e[2],a=e[3],s=e[6],u=e[7],l=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=o,r[9]=s,r[10]=e[10],r[11]=e[14],r[12]=a,r[13]=u,r[14]=l,r[15]=e[15],r},f.abs=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r):new f(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},f.equals=function(e,r){return e===r||n(e)&&n(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[11]===r[11]&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[15]===r[15]},f.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},f.getTranslation=function(r,t){if(!n(r))throw new i("matrix is required");return n(t)?(t.x=r[12],t.y=r[13],t.z=r[14],t):new e(r[12],r[13],r[14])},f.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r):new s(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},f.inverse=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],o=e[4],s=e[8],l=e[12],c=e[1],h=e[5],m=e[9],w=e[13],d=e[2],p=e[6],y=e[10],g=e[14],v=e[3],b=e[7],E=e[11],C=e[15],S=y*C,q=g*E,x=p*C,A=g*b,M=p*E,T=y*b,O=d*C,R=g*v,I=d*E,N=y*v,L=d*b,P=p*v,D=S*h+A*m+M*w-(q*h+x*m+T*w),z=q*c+O*m+N*w-(S*c+R*m+I*w),F=x*c+R*h+L*w-(A*c+O*h+P*w),_=T*c+I*h+P*m-(M*c+N*h+L*m),B=q*o+x*s+T*l-(S*o+A*s+M*l),U=S*t+R*s+I*l-(q*t+O*s+N*l),G=A*t+O*o+P*l-(x*t+R*o+L*l),k=M*t+N*o+L*s-(T*t+I*o+P*s);S=s*w,q=l*m,x=o*w,A=l*h,M=o*m,T=s*h,O=t*w,R=l*c,I=t*m,N=s*c,L=t*h,P=o*c;var W=S*b+A*E+M*C-(q*b+x*E+T*C),V=q*v+O*E+N*C-(S*v+R*E+I*C),Y=x*v+R*b+L*C-(A*v+O*b+P*C),H=T*v+I*b+P*E-(M*v+N*b+L*E),j=x*y+T*g+q*p-(M*g+S*p+A*y),K=I*g+S*d+R*y-(O*y+N*g+q*d),Z=O*p+P*g+A*d-(L*g+x*d+R*p),X=L*y+M*d+N*p-(I*p+P*y+T*d),Q=t*D+o*z+s*F+l*_;if(Math.abs(Q)<a.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return Q=1/Q,n(r)?(r[0]=D*Q,r[1]=z*Q,r[2]=F*Q,r[3]=_*Q,r[4]=B*Q,r[5]=U*Q,r[6]=G*Q,r[7]=k*Q,r[8]=W*Q,r[9]=V*Q,r[10]=Y*Q,r[11]=H*Q,r[12]=j*Q,r[13]=K*Q,r[14]=Z*Q,r[15]=X*Q,r):new f(D*Q,B*Q,W*Q,j*Q,z*Q,U*Q,V*Q,K*Q,F*Q,G*Q,Y*Q,Z*Q,_*Q,k*Q,H*Q,X*Q)},f.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");var t=e[0],o=e[1],a=e[2],s=e[4],u=e[5],l=e[6],c=e[8],h=e[9],m=e[10],w=e[12],d=e[13],p=e[14],y=-t*w-o*d-a*p,g=-s*w-u*d-l*p,v=-c*w-h*d-m*p;return n(r)?(r[0]=t,r[1]=s,r[2]=c,r[3]=0,r[4]=o,r[5]=u,r[6]=h,r[7]=0,r[8]=a,r[9]=l,r[10]=m,r[11]=0,r[12]=y,r[13]=g,r[14]=v,r[15]=1,r):new f(t,o,a,y,s,u,l,g,c,h,m,v,0,0,0,1)},f.IDENTITY=o(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,o,a){"use strict";var s=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};s.fromDegrees=function(e,n,i,o,u){return e=a.toRadians(r(e,0)),n=a.toRadians(r(n,0)),i=a.toRadians(r(i,0)),o=a.toRadians(r(o,0)),t(u)?(u.west=e,u.south=n,u.east=i,u.north=o,u):new s(e,n,i,o)},s.fromCartographicArray=function(e,r){if(!t(e))throw new n("cartographics is required.");for(var i=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,u=-Number.MAX_VALUE,f=0,l=e.length;l>f;f++){var c=e[f];i=Math.min(i,c.longitude),o=Math.max(o,c.longitude),a=Math.min(a,c.latitude),u=Math.max(u,c.latitude)}return t(r)?(r.west=i,r.south=a,r.east=o,r.north=u,r):new s(i,a,o,u)},s.packedLength=4,s.pack=function(e,i,o){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");o=r(o,0),i[o++]=e.west,i[o++]=e.south,i[o++]=e.east,i[o]=e.north},s.unpack=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new s),o.west=e[i++],o.south=e[i++],o.east=e[i++],o.north=e[i],o},s.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},s.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new n("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){if(!t(e))throw new n("rectangle is required");var r=e.north;if("number"!=typeof r)throw new n("north is required to be a number.");if(r<-a.PI_OVER_TWO||r>a.PI_OVER_TWO)throw new n("north must be in the interval [-Pi/2, Pi/2].");var i=e.south;if("number"!=typeof i)throw new n("south is required to be a number.");if(i<-a.PI_OVER_TWO||i>a.PI_OVER_TWO)throw new n("south must be in the interval [-Pi/2, Pi/2].");var o=e.west;if("number"!=typeof o)throw new n("west is required to be a number.");if(o<-Math.PI||o>Math.PI)throw new n("west must be in the interval [-Pi, Pi].");var s=e.east;if("number"!=typeof s)throw new n("east is required to be a number.");if(s<-Math.PI||s>Math.PI)throw new n("east must be in the interval [-Pi, Pi].")},s.getSouthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.getNorthwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.getNortheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.getSoutheast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.getCenter=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=.5*(r.west+r.east),i.latitude=.5*(r.south+r.north),i.height=0,i):new e(.5*(r.west+r.east),.5*(r.south+r.north))},s.intersectWith=function(e,r,i){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("otherRectangle is required.");var o=Math.max(e.west,r.west),a=Math.max(e.south,r.south),u=Math.min(e.east,r.east),f=Math.min(e.north,r.north);return t(i)?(i.west=o,i.south=a,i.east=u,i.north=f,i):new s(o,a,u,f)},s.contains=function(e,r){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("cartographic is required.");return r.longitude>=e.west&&r.longitude<=e.east&&r.latitude>=e.south&&r.latitude<=e.north},s.isEmpty=function(e){if(!t(e))throw new n("rectangle is required");return e.west>=e.east||e.south>=e.north};var u=new e;return s.subsample=function(e,o,s,f){if(!t(e))throw new n("rectangle is required");o=r(o,i.WGS84),s=r(s,0),t(f)||(f=[]);var l=0,c=e.north,h=e.south,m=e.east,w=e.west,d=u;d.height=s,d.longitude=w,d.latitude=c,f[l]=o.cartographicToCartesian(d,f[l]),l++,d.longitude=m,f[l]=o.cartographicToCartesian(d,f[l]),l++,d.latitude=h,f[l]=o.cartographicToCartesian(d,f[l]),l++,d.longitude=w,f[l]=o.cartographicToCartesian(d,f[l]),l++,d.latitude=0>c?c:h>0?h:0;for(var p=1;8>p;++p){var y=-Math.PI+p*a.PI_OVER_TWO;y>w&&m>y&&(d.longitude=y,f[l]=o.cartographicToCartesian(d,f[l]),l++)}return 0===d.latitude&&(d.longitude=w,f[l]=o.cartographicToCartesian(d,f[l]),l++,d.longitude=m,f[l]=o.cartographicToCartesian(d,f[l]),l++),f.length=l,f},s.MAX_VALUE=o(new s(-Math.PI,-a.PI_OVER_TWO,Math.PI,a.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,r,t,n,i,o,a,s,u,f,l){"use strict";var c=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},h=new e,m=new e,w=new e,d=new e,p=new e,y=new e,g=new e,v=new e,b=new e,E=new e,C=new e,S=new e;c.fromPoints=function(r,t){if(n(t)||(t=new c),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],g),o=e.clone(i,h),a=e.clone(i,m),s=e.clone(i,w),u=e.clone(i,d),f=e.clone(i,p),l=e.clone(i,y),q=r.length,x=1;q>x;x++){e.clone(r[x],i);var A=i.x,M=i.y,T=i.z;A<o.x&&e.clone(i,o),A>u.x&&e.clone(i,u),M<a.y&&e.clone(i,a),M>f.y&&e.clone(i,f),T<s.z&&e.clone(i,s),T>l.z&&e.clone(i,l)}var O=e.magnitudeSquared(e.subtract(u,o,v)),R=e.magnitudeSquared(e.subtract(f,a,v)),I=e.magnitudeSquared(e.subtract(l,s,v)),N=o,L=u,P=O;R>P&&(P=R,N=a,L=f),I>P&&(P=I,N=s,L=l);var D=b;D.x=.5*(N.x+L.x),D.y=.5*(N.y+L.y),D.z=.5*(N.z+L.z);var z=e.magnitudeSquared(e.subtract(L,D,v)),F=Math.sqrt(z),_=E;_.x=o.x,_.y=a.y,_.z=s.z;var B=C;B.x=u.x,B.y=f.y,B.z=l.z;var U=e.multiplyByScalar(e.add(_,B,v),.5,S),G=0;for(x=0;q>x;x++){e.clone(r[x],i);var k=e.magnitude(e.subtract(i,U,v));k>G&&(G=k);var W=e.magnitudeSquared(e.subtract(i,D,v));if(W>z){var V=Math.sqrt(W);F=.5*(F+V),z=F*F;var Y=V-F;D.x=(F*D.x+Y*i.x)/V,D.y=(F*D.y+Y*i.y)/V,D.z=(F*D.z+Y*i.z)/V}}return G>F?(e.clone(D,t.center),t.radius=F):(e.clone(U,t.center),t.radius=G),t};var q=new a,x=new e,A=new e,M=new r,T=new r;c.fromRectangle2D=function(e,r,t){return c.fromRectangleWithHeights2D(e,r,0,0,t)},c.fromRectangleWithHeights2D=function(r,i,o,a,s){if(n(s)||(s=new c),!n(r))return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;i=t(i,q),l.getSouthwest(r,M),M.height=o,l.getNortheast(r,T),T.height=a;var u=i.project(M,x),f=i.project(T,A),h=f.x-u.x,m=f.y-u.y,w=f.z-u.z;s.radius=.5*Math.sqrt(h*h+m*m+w*w);var d=s.center;return d.x=u.x+.5*h,d.y=u.y+.5*m,d.z=u.z+.5*w,s};var O=[];c.fromRectangle3D=function(e,r,i,a){r=t(r,o.WGS84),i=t(i,0);var s;return n(e)&&(s=l.subsample(e,r,i,O)),c.fromPoints(s,a)},c.fromVertices=function(r,o,a,s){if(n(s)||(s=new c),!n(r)||0===r.length)return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;if(o=t(o,e.ZERO),a=t(a,3),3>a)throw new i("stride must be 3 or greater.");var u=g;u.x=r[0]+o.x,u.y=r[1]+o.y,u.z=r[2]+o.z;for(var f=e.clone(u,h),l=e.clone(u,m),q=e.clone(u,w),x=e.clone(u,d),A=e.clone(u,p),M=e.clone(u,y),T=r.length,O=0;T>O;O+=a){var R=r[O]+o.x,I=r[O+1]+o.y,N=r[O+2]+o.z;u.x=R,u.y=I,u.z=N,R<f.x&&e.clone(u,f),R>x.x&&e.clone(u,x),I<l.y&&e.clone(u,l),I>A.y&&e.clone(u,A),N<q.z&&e.clone(u,q),N>M.z&&e.clone(u,M)}var L=e.magnitudeSquared(e.subtract(x,f,v)),P=e.magnitudeSquared(e.subtract(A,l,v)),D=e.magnitudeSquared(e.subtract(M,q,v)),z=f,F=x,_=L;P>_&&(_=P,z=l,F=A),D>_&&(_=D,z=q,F=M);var B=b;B.x=.5*(z.x+F.x),B.y=.5*(z.y+F.y),B.z=.5*(z.z+F.z);var U=e.magnitudeSquared(e.subtract(F,B,v)),G=Math.sqrt(U),k=E;k.x=f.x,k.y=l.y,k.z=q.z;var W=C;W.x=x.x,W.y=A.y,W.z=M.z;var V=e.multiplyByScalar(e.add(k,W,v),.5,S),Y=0;for(O=0;T>O;O+=a){u.x=r[O]+o.x,u.y=r[O+1]+o.y,u.z=r[O+2]+o.z;var H=e.magnitude(e.subtract(u,V,v));H>Y&&(Y=H);var j=e.magnitudeSquared(e.subtract(u,B,v));if(j>U){var K=Math.sqrt(j);G=.5*(G+K),U=G*G;var Z=K-G;B.x=(G*B.x+Z*u.x)/K,B.y=(G*B.y+Z*u.y)/K,B.z=(G*B.z+Z*u.z)/K}}return Y>G?(e.clone(B,s.center),s.radius=G):(e.clone(V,s.center),s.radius=Y),s},c.fromCornerPoints=function(r,t,o){if(!n(r)||!n(t))throw new i("corner and oppositeCorner are required.");n(o)||(o=new c);var a=o.center;return e.add(r,t,a),e.multiplyByScalar(a,.5,a),o.radius=e.distance(a,t),o},c.fromEllipsoid=function(r,t){if(!n(r))throw new i("ellipsoid is required.");return n(t)||(t=new c),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t},c.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new c(r.center,r.radius):void 0},c.packedLength=4,c.pack=function(e,r,o){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");o=t(o,0);var a=e.center;r[o++]=a.x,r[o++]=a.y,r[o++]=a.z,r[o]=e.radius},c.unpack=function(e,r,o){if(!n(e))throw new i("array is required");r=t(r,0),n(o)||(o=new c);var a=o.center;return a.x=e[r++],a.y=e[r++],a.z=e[r++],o.radius=e[r],o};var R=new e,I=new e;c.union=function(r,t,o){if(!n(r))throw new i("left is required.");if(!n(t))throw new i("right is required.");n(o)||(o=new c);var a=r.center,s=t.center;e.add(a,s,I);var u=e.multiplyByScalar(I,.5,I),f=e.magnitude(e.subtract(a,u,R))+r.radius,l=e.magnitude(e.subtract(s,u,R))+t.radius;return o.radius=Math.max(f,l),e.clone(u,o.center),o};var N=new e;c.expand=function(r,t,o){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("point is required.");o=c.clone(r,o);var a=e.magnitude(e.subtract(t,o.center,N));return a>o.radius&&(o.radius=a),o},c.intersect=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("plane is required.");var o=r.center,a=r.radius,u=e.dot(t,o)+t.w;return-a>u?s.OUTSIDE:a>u?s.INTERSECTING:s.INSIDE},c.transform=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new c),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=f.getMaximumScale(r)*e.radius,t};var L=new e;c.distanceSquaredTo=function(r,t){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("cartesian is required.");var o=e.subtract(r.center,t,L);return e.magnitudeSquared(o)-r.radius*r.radius},c.transformWithoutScale=function(e,r,t){if(!n(e))throw new i("sphere is required.");if(!n(r))throw new i("transform is required.");return n(t)||(t=new c),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var P=new e;c.getPlaneDistances=function(r,t,o,a){if(!n(r))throw new i("sphere is required.");if(!n(t))throw new i("position is required.");if(!n(o))throw new i("direction is required.");n(a)||(a=new u);var s=e.subtract(r.center,t,P),f=e.multiplyByScalar(o,e.dot(o,s),P),l=e.magnitude(f);return a.start=l-r.radius,a.stop=l+r.radius,a};for(var D=new e,z=new e,F=new e,_=new e,B=new e,U=new r,G=new Array(8),k=0;8>k;++k)G[k]=new e;var W=new a;return c.projectTo2D=function(r,o,a){if(!n(r))throw new i("sphere is required.");o=t(o,W);var s=o.ellipsoid,u=r.center,f=r.radius,l=s.geodeticSurfaceNormal(u,D),h=e.cross(e.UNIT_Z,l,z);e.normalize(h,h);var m=e.cross(l,h,F);e.normalize(m,m),e.multiplyByScalar(l,f,l),e.multiplyByScalar(m,f,m),e.multiplyByScalar(h,f,h);var w=e.negate(m,B),d=e.negate(h,_),p=G,y=p[0];e.add(l,m,y),e.add(y,h,y),y=p[1],e.add(l,m,y),e.add(y,d,y),y=p[2],e.add(l,w,y),e.add(y,d,y),y=p[3],e.add(l,w,y),e.add(y,h,y),e.negate(l,l),y=p[4],e.add(l,m,y),e.add(y,h,y),y=p[5],e.add(l,m,y),e.add(y,d,y),y=p[6],e.add(l,w,y),e.add(y,d,y),y=p[7],e.add(l,w,y),e.add(y,h,y);for(var g=p.length,v=0;g>v;++v){var b=p[v];e.add(u,b,b);var E=s.cartesianToCartographic(b,U);o.project(E,b)}a=c.fromPoints(p,a),u=a.center;var C=u.x,S=u.y,q=u.z;return u.x=q,u.y=C,u.z=S,a},c.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius
},c.prototype.intersect=function(e){return c.intersect(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.prototype.clone=function(e){return c.clone(this,e)},c}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,o=["webkit","moz","o","ms","khtml"],a=0,s=o.length;s>a;++a){var u=o[a];i=u+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=u+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=u+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=u+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=u+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=u+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=u+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=u+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=u+"fullscreenchange",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=u+"fullscreenerror",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(h)){var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null===e?h=!1:(h=!0,m=n(e[1]))}return h}function o(){return i()&&m}function a(){if(!r(w))if(i()||!/ Safari\/[\.0-9]+/.test(navigator.userAgent))w=!1;else{var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null===e?w=!1:(w=!0,d=n(e[1]))}return w}function s(){return a()&&d}function u(){if(!r(p)){var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null===e?p=!1:(p=!0,y=n(e[1]),y.isNightly=!!e[2])}return p}function f(){return u()&&y}function l(){if(!r(g)){var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(g=!0,v=n(e[1]))):"Netscape"===navigator.appName?(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(g=!0,v=n(e[1]))):g=!1}return g}function c(){return l()&&v}var h,m,w,d,p,y,g,v,b={isChrome:i,chromeVersion:o,isSafari:a,safariVersion:s,isWebkit:u,webkitVersion:f,isInternetExplorer:l,internetExplorerVersion:c,hardwareConcurrency:e(navigator.hardwareConcurrency,3)};return b.supportsFullscreen=function(){return t.supportsFullscreen()},b.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},b}),define("Core/Color",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math"],function(e,r,t,n,i,o){"use strict";function a(e,r,t){return 0>t&&(t+=1),t>1&&(t-=1),1>6*t?e+6*(r-e)*t:1>2*t?r:2>3*t?e+6*(r-e)*(2/3-t):e}var s=function(r,t,n,i){this.red=e(r,1),this.green=e(t,1),this.blue=e(n,1),this.alpha=e(i,1)};s.fromCartesian4=function(e,n){if(!r(e))throw new t("cartesian is required");return r(n)?(n.red=e.x,n.green=e.y,n.blue=e.z,n.alpha=e.w,n):new s(e.x,e.y,e.z,e.w)},s.fromBytes=function(r,t,n,i){return r=s.byteToFloat(e(r,255)),t=s.byteToFloat(e(t,255)),n=s.byteToFloat(e(n,255)),i=s.byteToFloat(e(i,255)),new s(r,t,n,i)};var u,f,l;n.supportsTypedArrays()&&(u=new ArrayBuffer(4),f=new Uint32Array(u),l=new Uint8Array(u)),s.fromRgba=function(e){return f[0]=e,s.fromBytes(l[0],l[1],l[2],l[3])},s.fromHsl=function(r,t,n,i){r=e(r,0)%1,t=e(t,0),n=e(n,0),i=e(i,1);var o=n,u=n,f=n;if(0!==t){var l;l=.5>n?n*(1+t):n+t-n*t;var c=2*n-l;o=a(c,l,r+1/3),u=a(c,l,r),f=a(c,l,r-1/3)}return new s(o,u,f,i)},s.fromRandom=function(n,i){n=e(n,e.EMPTY_OBJECT);var a=n.red;if(!r(a)){var u=e(n.minimumRed,0),f=e(n.maximumRed,1);if(u>f)throw new t("minimumRed must be less than or equal to maximumRed");a=u+o.nextRandomNumber()*(f-u)}var l=n.green;if(!r(l)){var c=e(n.minimumGreen,0),h=e(n.maximumGreen,1);if(c>h)throw new t("minimumGreen must be less than or equal to maximumGreen");l=c+o.nextRandomNumber()*(h-c)}var m=n.blue;if(!r(m)){var w=e(n.minimumBlue,0),d=e(n.maximumBlue,1);if(w>d)throw new t("minimumBlue must be less than or equal to maximumBlue");m=w+o.nextRandomNumber()*(d-w)}var p=n.alpha;if(!r(p)){var y=e(n.minimumAlpha,0),g=e(n.maximumAlpha,1);if(y>g)throw new t("minimumAlpha must be less than or equal to maximumAlpha");p=y+o.nextRandomNumber()*(g-y)}return r(i)?(i.red=a,i.green=l,i.blue=m,i.alpha=p,i):new s(a,l,m,p)};var c=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,h=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,m=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,w=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(n){if(!r(n))throw new t("color is required");var i=s[n.toUpperCase()];if(r(i))return s.clone(i);var o=c.exec(n);return null!==o?new s(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=h.exec(n),null!==o?new s(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=m.exec(n),null!==o?new s(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(e(o[4],"1.0"))):(o=w.exec(n),null!==o?s.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(e(o[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.red,i[o++]=n.green,i[o++]=n.blue,i[o]=n.alpha},s.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new s),o.red=n[i++],o.green=n[i++],o.blue=n[i++],o.alpha=n[i],o},s.byteToFloat=function(e){return e/255},s.floatToByte=function(e){return 1===e?255:0|256*e},s.clone=function(e,t){return r(e)?r(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new s(e.red,e.green,e.blue,e.alpha):void 0},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return this===e||r(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var e=s.floatToByte(this.red),r=s.floatToByte(this.green),t=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+r+","+t+")":"rgba("+e+","+r+","+t+","+this.alpha+")"},s.prototype.toBytes=function(e){var t=s.floatToByte(this.red),n=s.floatToByte(this.green),i=s.floatToByte(this.blue),o=s.floatToByte(this.alpha);return r(e)?(e[0]=t,e[1]=n,e[2]=i,e[3]=o,e):[t,n,i,o]},s.prototype.toRgba=function(){return l[0]=s.floatToByte(this.red),l[1]=s.floatToByte(this.green),l[2]=s.floatToByte(this.blue),l[3]=s.floatToByte(this.alpha),f[0]},s.ALICEBLUE=i(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=i(s.fromCssColorString("#FAEBD7")),s.AQUA=i(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=i(s.fromCssColorString("#7FFFD4")),s.AZURE=i(s.fromCssColorString("#F0FFFF")),s.BEIGE=i(s.fromCssColorString("#F5F5DC")),s.BISQUE=i(s.fromCssColorString("#FFE4C4")),s.BLACK=i(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=i(s.fromCssColorString("#FFEBCD")),s.BLUE=i(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=i(s.fromCssColorString("#8A2BE2")),s.BROWN=i(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=i(s.fromCssColorString("#DEB887")),s.CADETBLUE=i(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=i(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=i(s.fromCssColorString("#D2691E")),s.CORAL=i(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=i(s.fromCssColorString("#6495ED")),s.CORNSILK=i(s.fromCssColorString("#FFF8DC")),s.CRIMSON=i(s.fromCssColorString("#DC143C")),s.CYAN=i(s.fromCssColorString("#00FFFF")),s.DARKBLUE=i(s.fromCssColorString("#00008B")),s.DARKCYAN=i(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=i(s.fromCssColorString("#B8860B")),s.DARKGRAY=i(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=i(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=i(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=i(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=i(s.fromCssColorString("#556B2F")),s.DARKORANGE=i(s.fromCssColorString("#FF8C00")),s.DARKORCHID=i(s.fromCssColorString("#9932CC")),s.DARKRED=i(s.fromCssColorString("#8B0000")),s.DARKSALMON=i(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=i(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=i(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=i(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=i(s.fromCssColorString("#00CED1")),s.DARKVIOLET=i(s.fromCssColorString("#9400D3")),s.DEEPPINK=i(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=i(s.fromCssColorString("#00BFFF")),s.DIMGRAY=i(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=i(s.fromCssColorString("#1E90FF")),s.FIREBRICK=i(s.fromCssColorString("#B22222")),s.FLORALWHITE=i(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=i(s.fromCssColorString("#228B22")),s.FUSCHIA=i(s.fromCssColorString("#FF00FF")),s.GAINSBORO=i(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=i(s.fromCssColorString("#F8F8FF")),s.GOLD=i(s.fromCssColorString("#FFD700")),s.GOLDENROD=i(s.fromCssColorString("#DAA520")),s.GRAY=i(s.fromCssColorString("#808080")),s.GREEN=i(s.fromCssColorString("#008000")),s.GREENYELLOW=i(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=i(s.fromCssColorString("#F0FFF0")),s.HOTPINK=i(s.fromCssColorString("#FF69B4")),s.INDIANRED=i(s.fromCssColorString("#CD5C5C")),s.INDIGO=i(s.fromCssColorString("#4B0082")),s.IVORY=i(s.fromCssColorString("#FFFFF0")),s.KHAKI=i(s.fromCssColorString("#F0E68C")),s.LAVENDER=i(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=i(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=i(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=i(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=i(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=i(s.fromCssColorString("#F08080")),s.LIGHTCYAN=i(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=i(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=i(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=i(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=i(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=i(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=i(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=i(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=i(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=i(s.fromCssColorString("#FFFFE0")),s.LIME=i(s.fromCssColorString("#00FF00")),s.LIMEGREEN=i(s.fromCssColorString("#32CD32")),s.LINEN=i(s.fromCssColorString("#FAF0E6")),s.MAGENTA=i(s.fromCssColorString("#FF00FF")),s.MAROON=i(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=i(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=i(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=i(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=i(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=i(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=i(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=i(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=i(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=i(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=i(s.fromCssColorString("#191970")),s.MINTCREAM=i(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=i(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=i(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=i(s.fromCssColorString("#FFDEAD")),s.NAVY=i(s.fromCssColorString("#000080")),s.OLDLACE=i(s.fromCssColorString("#FDF5E6")),s.OLIVE=i(s.fromCssColorString("#808000")),s.OLIVEDRAB=i(s.fromCssColorString("#6B8E23")),s.ORANGE=i(s.fromCssColorString("#FFA500")),s.ORANGERED=i(s.fromCssColorString("#FF4500")),s.ORCHID=i(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=i(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=i(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=i(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=i(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=i(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=i(s.fromCssColorString("#FFDAB9")),s.PERU=i(s.fromCssColorString("#CD853F")),s.PINK=i(s.fromCssColorString("#FFC0CB")),s.PLUM=i(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=i(s.fromCssColorString("#B0E0E6")),s.PURPLE=i(s.fromCssColorString("#800080")),s.RED=i(s.fromCssColorString("#FF0000")),s.ROSYBROWN=i(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=i(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=i(s.fromCssColorString("#8B4513")),s.SALMON=i(s.fromCssColorString("#FA8072")),s.SANDYBROWN=i(s.fromCssColorString("#F4A460")),s.SEAGREEN=i(s.fromCssColorString("#2E8B57")),s.SEASHELL=i(s.fromCssColorString("#FFF5EE")),s.SIENNA=i(s.fromCssColorString("#A0522D")),s.SILVER=i(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=i(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=i(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=i(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=i(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=i(s.fromCssColorString("#00FF7F")),s.STEELBLUE=i(s.fromCssColorString("#4682B4")),s.TAN=i(s.fromCssColorString("#D2B48C")),s.TEAL=i(s.fromCssColorString("#008080")),s.THISTLE=i(s.fromCssColorString("#D8BFD8")),s.TOMATO=i(s.fromCssColorString("#FF6347")),s.TURQUOISE=i(s.fromCssColorString("#40E0D0")),s.VIOLET=i(s.fromCssColorString("#EE82EE")),s.WHEAT=i(s.fromCssColorString("#F5DEB3")),s.WHITE=i(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=i(s.fromCssColorString("#F5F5F5")),s.YELLOW=i(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=i(s.fromCssColorString("#9ACD32")),s}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection"],function(e,r,t,n){"use strict";if(!n.supportsTypedArrays())return{};var i={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return i.getSizeInBytes=function(e){if(!r(e))throw new t("value is required.");switch(e){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new t("componentDatatype is not a valid value.")}},i.fromTypedArray=function(e){return e instanceof Int8Array?i.BYTE:e instanceof Uint8Array?i.UNSIGNED_BYTE:e instanceof Int16Array?i.SHORT:e instanceof Uint16Array?i.UNSIGNED_SHORT:e instanceof Float32Array?i.FLOAT:e instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(e){return r(e)&&(e===i.BYTE||e===i.UNSIGNED_BYTE||e===i.SHORT||e===i.UNSIGNED_SHORT||e===i.FLOAT||e===i.DOUBLE)},i.createTypedArray=function(e,n){if(!r(e))throw new t("componentDatatype is required.");if(!r(n))throw new t("valuesOrLength is required.");switch(e){case i.BYTE:return new Int8Array(n);case i.UNSIGNED_BYTE:return new Uint8Array(n);case i.SHORT:return new Int16Array(n);case i.UNSIGNED_SHORT:return new Uint16Array(n);case i.FLOAT:return new Float32Array(n);case i.DOUBLE:return new Float64Array(n);default:throw new t("componentDatatype is not a valid value.")}},i.createArrayBufferView=function(n,o,a,s){if(!r(n))throw new t("componentDatatype is required.");if(!r(o))throw new t("buffer is required.");switch(a=e(a,0),s=e(s,(o.byteLength-a)/i.getSizeInBytes(n)),n){case i.BYTE:return new Int8Array(o,a,s);case i.UNSIGNED_BYTE:return new Uint8Array(o,a,s);case i.SHORT:return new Int16Array(o,a,s);case i.UNSIGNED_SHORT:return new Uint16Array(o,a,s);case i.FLOAT:return new Float32Array(o,a,s);case i.DOUBLE:return new Float64Array(o,a,s);default:throw new t("componentDatatype is not a valid value.")}},i}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.attributes))throw new t("options.attributes is required.");if(!r(n.primitiveType))throw new t("options.primitiveType is required.");this.attributes=n.attributes,this.indices=n.indices,this.primitiveType=n.primitiveType,this.boundingSphere=n.boundingSphere};return n.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&r(e.attributes[i])&&r(e.attributes[i].values)){var o=e.attributes[i],a=o.values.length/o.componentsPerAttribute;if(n!==a&&-1!==n)throw new t("All attribute lists must have the same number of attributes.");n=a}return n},n}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(n.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(n.values))throw new t("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t){this.x=e(r,0),this.y=e(t,0)};o.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new o(e,t)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y):void 0},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o]=n.y},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i],a},o.fromArray=o.unpack,o.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y)},o.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y)},o.getMinimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i},o.getMaximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n};var s=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,s),a=o.multiplyByScalar(e,1-i,a),o.add(s,a,a)};var u=new o,f=new o;o.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return o.normalize(e,u),o.normalize(n,f),i.acosClamped(o.dot(u,f))};var l=new o;return o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,l);return o.abs(i,i),n=i.x<=i.y?o.clone(o.UNIT_X,n):o.clone(o.UNIT_Y,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.x-n.x)<=i&&Math.abs(e.y-n.y)<=i},o.ZERO=n(new o(0,0)),o.UNIT_X=n(new o(1,0)),o.UNIT_Y=n(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=new r,o=new r,a=new r,s=function(s,u,f,l,c){if(!(t(s)&&t(u)&&t(f)&&t(l)))throw new n("point, p0, p1, and p2 are required.");t(c)||(c=new r);var h,m,w,d,p,y,g,v;t(u.z)?(h=r.subtract(f,u,i),m=r.subtract(l,u,o),w=r.subtract(s,u,a),d=r.dot(h,h),p=r.dot(h,m),y=r.dot(h,w),g=r.dot(m,m),v=r.dot(m,w)):(h=e.subtract(f,u,i),m=e.subtract(l,u,o),w=e.subtract(s,u,a),d=e.dot(h,h),p=e.dot(h,m),y=e.dot(h,w),g=e.dot(m,m),v=e.dot(m,w));var b=1/(d*g-p*p);return c.y=(g*y-p*v)*b,c.z=(d*v-p*y)*b,c.x=1-c.y-c.z,c};return s}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};n.encode=function(e,n){if(!r(e))throw new t("value is required");r(n)||(n={high:0,low:0});var i;return e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,o){if(!r(e))throw new t("cartesian is required");r(o)||(o=new n);var a=o.high,s=o.low;return n.encode(e.x,i),a.x=i.high,s.x=i.low,n.encode(e.y,i),a.y=i.high,s.y=i.low,n.encode(e.z,i),a.z=i.high,s.z=i.low,o};var o=new n;return n.writeElements=function(e,i,a){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("cartesianArray is required");if("number"!=typeof a||0>a)throw new t("index must be a number greater than or equal to 0.");n.fromCartesian(e,o);var s=o.high,u=o.low;i[a]=s.x,i[a+1]=s.y,i[a+2]=s.z,i[a+3]=u.x,i[a+4]=u.y,i[a+5]=u.z},n}),define("Core/IndexDatatype",["./defined","./DeveloperError","./Math"],function(e,r,t){"use strict";var n={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return n.getSizeInBytes=function(e){switch(e){case n.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case n.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case n.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new r("indexDatatype is required and must be a valid IndexDatatype constant.")},n.validate=function(r){return e(r)&&(r===n.UNSIGNED_BYTE||r===n.UNSIGNED_SHORT||r===n.UNSIGNED_INT)},n.createTypedArray=function(n,i){if(!e(n))throw new r("numberOfVertices is required.");return n>t.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},n}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,r){"use strict";function t(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}var n={};return n.discriminant=function(r,t,n){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=t*t-4*r*n;return i},n.realRoots=function(n,i,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");var a;if(0===n)return 0===i?[]:[-o/i];if(0===i){if(0===o)return[0,0];var s=Math.abs(o),u=Math.abs(n);if(u>s&&s/u<r.EPSILON14)return[0,0];if(s>u&&u/s<r.EPSILON14)return[];if(a=-o/n,0>a)return[];var f=Math.sqrt(a);return[-f,f]}if(0===o)return a=-i/n,0>a?[a,0]:[0,a];var l=i*i,c=4*n*o,h=t(l,-c,r.EPSILON14);if(0>h)return[];var m=-.5*t(i,r.sign(i)*Math.sqrt(h),r.EPSILON14);return i>0?[m/n,o/m]:[o/m,m/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,r){"use strict";function t(e,r,t,n){var i,o,a=e,s=r/3,u=t/3,f=n,l=a*u,c=s*f,h=s*s,m=u*u,w=a*u-h,d=a*f-s*u,p=s*f-m,y=4*w*p-d*d;if(0>y){var g,v,b;h*c>=l*m?(g=a,v=w,b=-2*s*w+a*d):(g=f,v=p,b=-f*d+2*u*p);var E=0>b?-1:1,C=-E*Math.abs(g)*Math.sqrt(-y);o=-b+C;var S=o/2,q=0>S?-Math.pow(-S,1/3):Math.pow(S,1/3),x=o===C?-q:-v/q;return i=0>=v?q+x:-b/(q*q+x*x+v),h*c>=l*m?[(i-s)/a]:[-f/(i+u)]}var A=w,M=-2*s*w+a*d,T=p,O=-f*d+2*u*p,R=Math.sqrt(y),I=Math.sqrt(3)/2,N=Math.abs(Math.atan2(a*R,-M)/3);i=2*Math.sqrt(-A);var L=Math.cos(N);o=i*L;var P=i*(-L/2-I*Math.sin(N)),D=o+P>2*s?o-s:P-s,z=a,F=D/z;N=Math.abs(Math.atan2(f*R,-O)/3),i=2*Math.sqrt(-T),L=Math.cos(N),o=i*L,P=i*(-L/2-I*Math.sin(N));var _=-f,B=2*u>o+P?o+u:P+u,U=_/B,G=z*B,k=-D*B-z*_,W=D*_,V=(u*k-s*W)/(-s*k+u*G);return V>=F?U>=F?U>=V?[F,V,U]:[F,U,V]:[U,F,V]:U>=F?[V,F,U]:U>=V?[V,U,F]:[U,V,F]}var n={};return n.discriminant=function(r,t,n,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var o=r*r,a=t*t,s=n*n,u=i*i,f=18*r*t*n*i+a*s-27*o*u-4*(r*s*n+a*t*i);return f},n.realRoots=function(n,i,o,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var s,u;if(0===n)return r.realRoots(i,o,a);if(0===i){if(0===o){if(0===a)return[0,0,0];u=-a/n;var f=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[f,f,f]}return 0===a?(s=r.realRoots(n,0,o),0===s.Length?[0]:[s[0],0,s[1]]):t(n,0,o,a)}return 0===o?0===a?(u=-i/n,0>u?[u,0,0]:[0,0,u]):t(n,i,0,a):0===a?(s=r.realRoots(n,i,o),0===s.length?[0]:s[1]<=0?[s[0],s[1],0]:s[0]>=0?[0,s[0],s[1]]:[s[0],0,s[1]]):t(n,i,o,a)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,r,t,n){"use strict";function i(r,i,o,a){var s=r*r,u=i-3*s/8,f=o-i*r/2+s*r/8,l=a-o*r/4+i*s/16-3*s*s/256,c=e.realRoots(1,2*u,u*u-4*l,-f*f);if(c.length>0){var h=-r/4,m=c[c.length-1];if(Math.abs(m)<t.EPSILON14){var w=n.realRoots(1,u,l);if(2===w.length){var d,p=w[0],y=w[1];if(p>=0&&y>=0){var g=Math.sqrt(p),v=Math.sqrt(y);return[h-v,h-g,h+g,h+v]}if(p>=0&&0>y)return d=Math.sqrt(p),[h-d,h+d];if(0>p&&y>=0)return d=Math.sqrt(y),[h-d,h+d]}return[]}if(m>0){var b=Math.sqrt(m),E=(u+m-f/b)/2,C=(u+m+f/b)/2,S=n.realRoots(1,b,E),q=n.realRoots(1,-b,C);return 0!==S.length?(S[0]+=h,S[1]+=h,0!==q.length?(q[0]+=h,q[1]+=h,S[1]<=q[0]?[S[0],S[1],q[0],q[1]]:q[1]<=S[0]?[q[0],q[1],S[0],S[1]]:S[0]>=q[0]&&S[1]<=q[1]?[q[0],S[0],S[1],q[1]]:q[0]>=S[0]&&q[1]<=S[1]?[S[0],q[0],q[1],S[1]]:S[0]>q[0]&&S[0]<q[1]?[q[0],S[0],q[1],S[1]]:[S[0],q[0],S[1],q[1]]):S):0!==q.length?(q[0]+=h,q[1]+=h,q):[]}}return[]}function o(r,i,o,a){var s=o*o,u=i*i,f=r*r,l=-2*i,c=o*r+u-4*a,h=f*a-o*i*r+s,m=e.realRoots(1,l,c,h);if(m.length>0){var w,d,p=m[0],y=i-p,g=y*y,v=r/2,b=y/2,E=g-4*a,C=g+4*Math.abs(a),S=f-4*p,q=f+4*Math.abs(p);if(0>p||S*C>E*q){var x=Math.sqrt(S);w=x/2,d=0===x?0:(r*b-o)/x}else{var A=Math.sqrt(E);w=0===A?0:(r*b-o)/A,d=A/2}var M,T;0===v&&0===w?(M=0,T=0):t.sign(v)===t.sign(w)?(M=v+w,T=p/M):(T=v-w,M=p/T);var O,R;0===b&&0===d?(O=0,R=0):t.sign(b)===t.sign(d)?(O=b+d,R=a/O):(R=b-d,O=a/R);var I=n.realRoots(1,M,O),N=n.realRoots(1,T,R);if(0!==I.length)return 0!==N.length?I[1]<=N[0]?[I[0],I[1],N[0],N[1]]:N[1]<=I[0]?[N[0],N[1],I[0],I[1]]:I[0]>=N[0]&&I[1]<=N[1]?[N[0],I[0],I[1],N[1]]:N[0]>=I[0]&&N[1]<=I[1]?[I[0],N[0],N[1],I[1]]:I[0]>N[0]&&I[0]<N[1]?[N[0],I[0],N[1],I[1]]:[I[0],N[0],I[1],N[1]]:I;if(0!==N.length)return N}return[]}var a={};return a.discriminant=function(e,t,n,i,o){if("number"!=typeof e)throw new r("a is a required number.");if("number"!=typeof t)throw new r("b is a required number.");if("number"!=typeof n)throw new r("c is a required number.");if("number"!=typeof i)throw new r("d is a required number.");if("number"!=typeof o)throw new r("e is a required number.");var a=e*e,s=a*e,u=t*t,f=u*t,l=n*n,c=l*n,h=i*i,m=h*i,w=o*o,d=w*o,p=u*l*h-4*f*m-4*e*c*h+18*e*t*n*m-27*a*h*h+256*s*d+o*(18*f*n*i-4*u*c+16*e*l*l-80*e*t*l*i-6*e*u*h+144*a*n*h)+w*(144*e*u*n-27*u*u-128*a*l-192*a*t*i);return p},a.realRoots=function(n,a,s,u,f){if("number"!=typeof n)throw new r("a is a required number.");if("number"!=typeof a)throw new r("b is a required number.");if("number"!=typeof s)throw new r("c is a required number.");if("number"!=typeof u)throw new r("d is a required number.");if("number"!=typeof f)throw new r("e is a required number.");if(Math.abs(n)<t.EPSILON15)return e.realRoots(a,s,u,f);var l=a/n,c=s/n,h=u/n,m=f/n,w=0>l?1:0;switch(w+=0>c?w+1:w,w+=0>h?w+1:w,w+=0>m?w+1:w){case 0:return i(l,c,h,m);case 1:return o(l,c,h,m);case 2:return o(l,c,h,m);case 3:return i(l,c,h,m);case 4:return i(l,c,h,m);case 5:return o(l,c,h,m);case 6:return i(l,c,h,m);case 7:return i(l,c,h,m);case 8:return o(l,c,h,m);case 9:return i(l,c,h,m);case 10:return i(l,c,h,m);case 11:return o(l,c,h,m);case 12:return i(l,c,h,m);case 13:return i(l,c,h,m);case 14:return i(l,c,h,m);case 15:return i(l,c,h,m);default:return void 0}},a}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial"],function(e,r,t,n,i,o,a,s){"use strict";function u(e,r,t){var n=e+r;
return i.sign(e)!==i.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<t?0:n}function f(r,t,n,f,l){var c,h=f*f,m=l*l,w=(r[o.COLUMN1ROW1]-r[o.COLUMN2ROW2])*m,d=l*(f*u(r[o.COLUMN1ROW0],r[o.COLUMN0ROW1],i.EPSILON15)+t.y),p=r[o.COLUMN0ROW0]*h+r[o.COLUMN2ROW2]*m+f*t.x+n,y=m*u(r[o.COLUMN2ROW1],r[o.COLUMN1ROW2],i.EPSILON15),g=l*(f*u(r[o.COLUMN2ROW0],r[o.COLUMN0ROW2])+t.z),v=[];if(0===g&&0===y){if(c=a.realRoots(w,d,p),0===c.length)return v;var b=c[0],E=Math.sqrt(Math.max(1-b*b,0));if(v.push(new e(f,l*b,l*-E)),v.push(new e(f,l*b,l*E)),2===c.length){var C=c[1],S=Math.sqrt(Math.max(1-C*C,0));v.push(new e(f,l*C,l*-S)),v.push(new e(f,l*C,l*S))}return v}var q=g*g,x=y*y,A=w*w,M=g*y,T=A+x,O=2*(d*w+M),R=2*p*w+d*d-x+q,I=2*(p*d-M),N=p*p-q;if(0===T&&0===O&&0===R&&0===I)return v;c=s.realRoots(T,O,R,I,N);var L=c.length;if(0===L)return v;for(var P=0;L>P;++P){var D,z=c[P],F=z*z,_=Math.max(1-F,0),B=Math.sqrt(_);D=i.sign(w)===i.sign(p)?u(w*F+p,d*z,i.EPSILON12):i.sign(p)===i.sign(d*z)?u(w*F,d*z+p,i.EPSILON12):u(w*F+d*z,p,i.EPSILON12);var U=u(y*z,g,i.EPSILON15),G=D*U;0>G?v.push(new e(f,l*z,l*B)):G>0?v.push(new e(f,l*z,l*-B)):0!==B?(v.push(new e(f,l*z,l*-B)),v.push(new e(f,l*z,l*B)),++P):v.push(new e(f,l*z,l*B))}return v}var l={};l.rayPlane=function(r,o,a){if(!t(r))throw new n("ray is required.");if(!t(o))throw new n("plane is required.");t(a)||(a=new e);var s=r.origin,u=r.direction,f=o.normal,l=e.dot(f,u);if(Math.abs(l)<i.EPSILON15)return void 0;var c=(-o.distance-e.dot(f,s))/l;return 0>c?void 0:(a=e.multiplyByScalar(u,c,a),e.add(s,a,a))};var c=new e,h=new e;l.rayEllipsoid=function(r,i){if(!t(r))throw new n("ray is required.");if(!t(i))throw new n("ellipsoid is required.");var o,a,s,u,f,l=i.oneOverRadii,m=e.multiplyComponents(l,r.origin,c),w=e.multiplyComponents(l,r.direction,h),d=e.magnitudeSquared(m),p=e.dot(m,w);if(d>1){if(p>=0)return void 0;var y=p*p;if(o=d-1,a=e.magnitudeSquared(w),s=a*o,s>y)return void 0;if(y>s){u=p*p-s,f=-p+Math.sqrt(u);var g=f/a,v=o/f;return v>g?{start:g,stop:v}:{start:v,stop:g}}var b=Math.sqrt(o/a);return{start:b,stop:b}}return 1>d?(o=d-1,a=e.magnitudeSquared(w),s=a*o,u=p*p-s,f=-p+Math.sqrt(u),{start:0,stop:f/a}):0>p?(a=e.magnitudeSquared(w),{start:0,stop:-p/a}):void 0};var m=new e,w=new e,d=new e,p=new e;l.grazingAltitudeLocation=function(a,s){if(!t(a))throw new n("ray is required.");if(!t(s))throw new n("ellipsoid is required.");var u=a.origin,l=a.direction,c=s.geodeticSurfaceNormal(u);if(e.dot(l,c)>=0)return u;var h,y,g=t(this.rayEllipsoid(a,s)),v=s.transformPositionToScaledSpace(l),b=e.normalize(v,m),E=e.mostOrthogonalAxis(v,p),C=e.normalize(e.cross(E,b,w),w),S=e.normalize(e.cross(b,C,d),d),q=new o(b.x,C.x,S.x,b.y,C.y,S.y,b.z,C.z,S.z),x=o.transpose(q),A=o.fromScale(s.radii),M=o.fromScale(s.oneOverRadii),T=new o(0,l.z,-l.y,-l.z,0,l.x,l.y,-l.x,0),O=o.multiply(o.multiply(x,M),T),R=o.multiply(o.multiply(O,A),q),I=o.multiplyByVector(O,u),N=f(R,e.negate(I,m),0,0,1),L=N.length;if(L>0){for(var P=e.ZERO,D=Number.NEGATIVE_INFINITY,z=0;L>z;++z){h=o.multiplyByVector(A,o.multiplyByVector(q,N[z]));var F=e.normalize(e.subtract(h,u,p),p),_=e.dot(F,l);_>D&&(D=_,P=h)}var B=s.cartesianToCartographic(P);return D=i.clamp(D,0,1),y=e.magnitude(e.subtract(P,u,p))*Math.sqrt(1-D*D),y=g?-y:y,s.cartographicToCartesian(new r(B.longitude,B.latitude,y))}return void 0};var y=new e;return l.lineSegmentPlane=function(r,o,a,s){if(!t(r))throw new n("endPoint0 is required.");if(!t(o))throw new n("endPoint1 is required.");if(!t(a))throw new n("plane is required.");t(s)||(s=new e);var u=e.subtract(o,r,y),f=a.normal,l=e.dot(f,u);if(Math.abs(l)<i.EPSILON6)return void 0;var c=e.dot(f,r),h=-(a.distance+c)/l;return 0>h||h>1?void 0:(e.multiplyByScalar(u,h,s),e.add(r,s,s),s)},l.trianglePlaneIntersection=function(r,i,o,a){if(!(t(r)&&t(i)&&t(o)&&t(a)))throw new n("p0, p1, p2, and plane are required.");var s=a.normal,u=a.distance,f=e.dot(s,r)+u<0,c=e.dot(s,i)+u<0,h=e.dot(s,o)+u<0,m=0;m+=f?1:0,m+=c?1:0,m+=h?1:0;var w,d;if((1===m||2===m)&&(w=new e,d=new e),1===m){if(f)return l.lineSegmentPlane(r,i,a,w),l.lineSegmentPlane(r,o,a,d),{positions:[r,i,o,w,d],indices:[0,3,4,1,2,4,1,4,3]};if(c)return l.lineSegmentPlane(i,o,a,w),l.lineSegmentPlane(i,r,a,d),{positions:[r,i,o,w,d],indices:[1,3,4,2,0,4,2,4,3]};if(h)return l.lineSegmentPlane(o,r,a,w),l.lineSegmentPlane(o,i,a,d),{positions:[r,i,o,w,d],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===m){if(!f)return l.lineSegmentPlane(i,r,a,w),l.lineSegmentPlane(o,r,a,d),{positions:[r,i,o,w,d],indices:[1,2,4,1,4,3,0,3,4]};if(!c)return l.lineSegmentPlane(o,i,a,w),l.lineSegmentPlane(r,i,a,d),{positions:[r,i,o,w,d],indices:[2,0,4,2,4,3,1,3,4]};if(!h)return l.lineSegmentPlane(r,o,a,w),l.lineSegmentPlane(i,o,a,d),{positions:[r,i,o,w,d],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},l}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n,i){if(!r(n))throw new t("normal is required.");if(!r(i))throw new t("distance is required.");this.normal=e.clone(n),this.distance=i};return n.fromPointNormal=function(i,o,a){if(!r(i))throw new t("point is required.");if(!r(o))throw new t("normal is required.");var s=-e.dot(o,i);return r(a)?(e.clone(o,a.normal),a.distance=s,a):new n(o,s)},n.getPointDistance=function(n,i){if(!r(n))throw new t("plane is required.");if(!r(i))throw new t("point is required.");return e.dot(n.normal,i)+n.distance},n}),define("Core/PrimitiveType",[],function(){"use strict";var e={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(r){return r===e.POINTS||r===e.LINES||r===e.LINE_LOOP||r===e.LINE_STRIP||r===e.TRIANGLES||r===e.TRIANGLE_STRIP||r===e.TRIANGLE_FAN}};return e}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n={};return n.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var i=n.indices,o=n.maximumIndex,a=e(n.cacheSize,24);if(!r(i))throw new t("indices is required.");var s=i.length;if(3>s||0!==s%3)throw new t("indices length must be a multiple of three.");if(0>=o)throw new t("maximumIndex must be greater than zero.");if(3>a)throw new t("cacheSize must be greater than two.");if(!r(o)){o=0;for(var u=0,f=i[u];s>u;)f>o&&(o=f),++u,f=i[u]}for(var l=[],c=0;o+1>c;c++)l[c]=0;for(var h=a+1,m=0;s>m;++m)h-l[i[m]]>a&&(l[i[m]]=h,++h);return(h-a+1)/(s/3)},n.tipsify=function(n){function i(e,r,t,n){for(;r.length>=1;){var i=r[r.length-1];if(r.splice(r.length-1,1),e[i].numLiveTriangles>0)return i}for(;n>a;){if(e[a].numLiveTriangles>0)return++a,a-1;++a}return-1}function o(e,r,t,n,o,a,s){for(var u,f=-1,l=-1,c=0;c<t.length;){var h=t[c];n[h].numLiveTriangles&&(u=0,o-n[h].timeStamp+2*n[h].numLiveTriangles<=r&&(u=o-n[h].timeStamp),(u>l||-1===l)&&(l=u,f=h)),++c}return-1===f?i(n,a,e,s):f}n=e(n,e.EMPTY_OBJECT);var a,s=n.indices,u=n.maximumIndex,f=e(n.cacheSize,24);if(!r(s))throw new t("indices is required.");var l=s.length;if(3>l||0!==l%3)throw new t("indices length must be a multiple of three.");if(0>=u)throw new t("maximumIndex must be greater than zero.");if(3>f)throw new t("cacheSize must be greater than two.");var c=0,h=0,m=s[h],w=l;if(r(u))c=u+1;else{for(;w>h;)m>c&&(c=m),++h,m=s[h];if(-1===c)return 0;++c}for(var d=[],p=0;c>p;p++)d[p]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};h=0;for(var y=0;w>h;)d[s[h]].vertexTriangles.push(y),++d[s[h]].numLiveTriangles,d[s[h+1]].vertexTriangles.push(y),++d[s[h+1]].numLiveTriangles,d[s[h+2]].vertexTriangles.push(y),++d[s[h+2]].numLiveTriangles,++y,h+=3;var g=0,v=f+1;a=1;var b,E,C=[],S=[],q=0,x=[],A=l/3,M=[];for(p=0;A>p;p++)M[p]=!1;for(var T,O;-1!==g;){C=[],E=d[g],O=E.vertexTriangles.length;for(var R=0;O>R;++R)if(y=E.vertexTriangles[R],!M[y]){M[y]=!0,h=y+y+y;for(var I=0;3>I;++I)T=s[h],C.push(T),S.push(T),x[q]=T,++q,b=d[T],--b.numLiveTriangles,v-b.timeStamp>f&&(b.timeStamp=v,++v),++h}g=o(s,f,C,d,v,S,c)}return x},n}),define("Core/GeometryPipeline",["./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,r,t,n,i,o,a,s,u,f,l,c,h,m,w,d,p,y,g,v,b,E,C){"use strict";function S(e,r,t,n,i){e[r++]=t,e[r++]=n,e[r++]=n,e[r++]=i,e[r++]=i,e[r]=t}function q(e){for(var r=e.length,t=6*(r/3),n=w.createTypedArray(r,t),i=0,o=0;r>o;o+=3,i+=6)S(n,i,e[o],e[o+1],e[o+2]);return n}function x(e){var r=e.length;if(r>=3){var t=6*(r-2),n=w.createTypedArray(r,t);S(n,0,e[0],e[1],e[2]);for(var i=6,o=3;r>o;++o,i+=6)S(n,i,e[o-1],e[o],e[o-2]);return n}return new Uint16Array}function A(e){if(e.length>0){for(var r=e.length-1,t=6*(r-1),n=w.createTypedArray(r,t),i=e[0],o=0,a=1;r>a;++a,o+=6)S(n,o,i,e[a],e[a+1]);return n}return new Uint16Array}function M(e){var r={};for(var t in e)if(e.hasOwnProperty(t)&&u(e[t])&&u(e[t].values)){var n=e[t];r[t]=new m({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return r}function T(e,r,t){for(var n in r)if(r.hasOwnProperty(n)&&u(r[n])&&u(r[n].values))for(var i=r[n],o=0;o<i.componentsPerAttribute;++o)e[n].values.push(i.values[t*i.componentsPerAttribute+o])}function O(e,r){if(u(r))for(var t=r.values,i=t.length,o=0;i>o;o+=3)n.unpack(t,o,Z),v.multiplyByPoint(e,Z,Z),n.pack(Z,t,o)}function R(e,r){if(u(r))for(var t=r.values,i=t.length,o=0;i>o;o+=3)n.unpack(t,o,Z),g.multiplyByVector(e,Z,Z),Z=n.normalize(Z,Z),n.pack(Z,t,o)}function I(e){var r,t=e.length,n={},i=e[0].geometry.attributes;for(r in i)if(i.hasOwnProperty(r)&&u(i[r])&&u(i[r].values)){for(var o=i[r],s=o.values.length,f=!0,l=1;t>l;++l){var c=e[l].geometry.attributes[r];if(!u(c)||o.componentDatatype!==c.componentDatatype||o.componentsPerAttribute!==c.componentsPerAttribute||o.normalize!==c.normalize){f=!1;break}s+=c.values.length}f&&(n[r]=new m({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:a.createTypedArray(o.componentDatatype,s)}))}return n}function N(e){if(u(e.indices))return e;var r=h.computeNumberOfVertices(e);if(3>r)throw new f("The number of vertices must be at least three.");if(0!==r%3)throw new f("The number of vertices must be a multiple of three.");for(var t=w.createTypedArray(r,r),n=0;r>n;++n)t[n]=n;return e.indices=t,e}function L(e){var r=h.computeNumberOfVertices(e);if(3>r)throw new f("The number of vertices must be at least three.");var t=w.createTypedArray(r,3*(r-2));t[0]=1,t[1]=0,t[2]=2;for(var n=3,i=3;r>i;++i)t[n++]=i-1,t[n++]=0,t[n++]=i;return e.indices=t,e.primitiveType=E.TRIANGLES,e}function P(e){var r=h.computeNumberOfVertices(e);if(3>r)throw new f("The number of vertices must be at least 3.");var t=w.createTypedArray(r,3*(r-2));t[0]=0,t[1]=1,t[2]=2,r>3&&(t[3]=0,t[4]=2,t[5]=3);for(var n=6,i=3;r-1>i;i+=2)t[n++]=i,t[n++]=i-1,t[n++]=i+1,r>i+2&&(t[n++]=i,t[n++]=i+1,t[n++]=i+2);return e.indices=t,e.primitiveType=E.TRIANGLES,e}function D(e){if(u(e.indices))return e;var r=h.computeNumberOfVertices(e);if(2>r)throw new f("The number of vertices must be at least two.");if(0!==r%2)throw new f("The number of vertices must be a multiple of 2.");for(var t=w.createTypedArray(r,r),n=0;r>n;++n)t[n]=n;return e.indices=t,e}function z(e){var r=h.computeNumberOfVertices(e);if(2>r)throw new f("The number of vertices must be at least two.");var t=w.createTypedArray(r,2*(r-1));t[0]=0,t[1]=1;for(var n=2,i=2;r>i;++i)t[n++]=i-1,t[n++]=i;return e.indices=t,e.primitiveType=E.LINES,e}function F(e){var r=h.computeNumberOfVertices(e);if(2>r)throw new f("The number of vertices must be at least two.");var t=w.createTypedArray(r,2*r);t[0]=0,t[1]=1;for(var n=2,i=2;r>i;++i)t[n++]=i-1,t[n++]=i;return t[n++]=r-1,t[n]=0,e.indices=t,e.primitiveType=E.LINES,e}function _(e){switch(e.primitiveType){case E.TRIANGLE_FAN:return L(e);case E.TRIANGLE_STRIP:return P(e);case E.TRIANGLES:return N(e);case E.LINE_STRIP:return z(e);case E.LINE_LOOP:return F(e);case E.LINES:return D(e)}return e}function B(e,r){Math.abs(e.y)<y.EPSILON11&&(e.y=r?-y.EPSILON11:y.EPSILON11)}function U(e,r,t,i){n.add(e,n.multiplyByScalar(n.subtract(r,e,ar),e.y/(e.y-r.y),ar),t),n.clone(t,i),B(t,!0),B(i,!1)}function G(e,r,t){if(e.x>=0||r.x>=0||t.x>=0)return void 0;var n=e.y<0,i=r.y<0,o=t.y<0;B(e,n),B(r,i),B(t,o);var a=0;a+=n?1:0,a+=i?1:0,a+=o?1:0;var s=cr.indices;1===a?(s[1]=3,s[2]=4,s[5]=6,s[7]=6,s[8]=5,n?(U(e,r,sr,fr),U(e,t,ur,lr),s[0]=0,s[3]=1,s[4]=2,s[6]=1):i?(U(r,t,sr,fr),U(r,e,ur,lr),s[0]=1,s[3]=2,s[4]=0,s[6]=2):o&&(U(t,e,sr,fr),U(t,r,ur,lr),s[0]=2,s[3]=0,s[4]=1,s[6]=0)):2===a&&(s[2]=4,s[4]=4,s[5]=3,s[7]=5,s[8]=6,n?i?o||(U(t,e,sr,fr),U(t,r,ur,lr),s[0]=0,s[1]=1,s[3]=0,s[6]=2):(U(r,t,sr,fr),U(r,e,ur,lr),s[0]=2,s[1]=0,s[3]=2,s[6]=1):(U(e,r,sr,fr),U(e,t,ur,lr),s[0]=1,s[1]=2,s[3]=1,s[6]=0));var u=cr.positions;return u[0]=e,u[1]=r,u[2]=t,cr.length=3,(1===a||2===a)&&(u[3]=sr,u[4]=ur,u[5]=fr,u[6]=lr,cr.length=7),cr}function k(r,i,o,a,s,f,l,c){if(u(s)||u(f)||u(l)||u(c)){var h,m,w,d,p,y,g,v,b,E,C,S,q=a.positions,x=q[0],A=q[1],M=q[2],T=dr,O=pr,R=yr,I=hr,N=mr,L=wr;u(s)&&(h=n.fromArray(s,3*r),m=n.fromArray(s,3*i),w=n.fromArray(s,3*o)),u(f)&&(d=n.fromArray(f,3*r),p=n.fromArray(f,3*i),y=n.fromArray(f,3*o)),u(l)&&(g=n.fromArray(l,3*r),v=n.fromArray(l,3*i),b=n.fromArray(l,3*o)),u(c)&&(E=t.fromArray(c,2*r),C=t.fromArray(c,2*i),S=t.fromArray(c,2*o));for(var P=3;P<q.length;++P){var D=q[P],z=e(D,x,A,M);if(u(s)){T=n.multiplyByScalar(h,z.x,T),O=n.multiplyByScalar(m,z.y,O),R=n.multiplyByScalar(w,z.z,R);var F=n.add(T,O,gr);n.add(F,R,F),n.normalize(F,F),s.push(F.x,F.y,F.z)}if(u(f)){T=n.multiplyByScalar(d,z.x,T),O=n.multiplyByScalar(p,z.y,O),R=n.multiplyByScalar(y,z.z,R);var _=n.add(T,O,gr);n.add(_,R,_),n.normalize(_,_),f.push(_.x,_.y,_.z)}if(u(l)){T=n.multiplyByScalar(g,z.x,T),O=n.multiplyByScalar(v,z.y,O),R=n.multiplyByScalar(b,z.z,R);var B=n.add(T,O,gr);n.add(B,R,B),n.normalize(B,B),l.push(B.x,B.y,B.z)}if(u(c)){I=t.multiplyByScalar(E,z.x,I),N=t.multiplyByScalar(C,z.y,N),L=t.multiplyByScalar(S,z.z,L);var U=t.add(I,N,I);t.add(U,L,U),c.push(U.x,U.y)}}}}function W(e){for(var r=e.attributes,t=r.position.values,i=u(r.normal)?r.normal.values:void 0,o=u(r.binormal)?r.binormal.values:void 0,s=u(r.tangent)?r.tangent.values:void 0,f=u(r.st)?r.st.values:void 0,l=e.indices,c=Array.prototype.slice.call(t,0),m=u(i)?Array.prototype.slice.call(i,0):void 0,d=u(o)?Array.prototype.slice.call(o,0):void 0,p=u(s)?Array.prototype.slice.call(s,0):void 0,y=u(f)?Array.prototype.slice.call(f,0):void 0,g=[],v=l.length,b=0;v>b;b+=3){var E=l[b],C=l[b+1],S=l[b+2],q=n.fromArray(t,3*E),x=n.fromArray(t,3*C),A=n.fromArray(t,3*S),M=G(q,x,A);if(u(M))if(c[3*E+1]=M.positions[0].y,c[3*C+1]=M.positions[1].y,c[3*S+1]=M.positions[2].y,M.length>3){for(var T=c.length/3,O=0;O<M.indices.length;++O){var R=M.indices[O];3>R?g.push(l[b+R]):g.push(R-3+T)}for(var I=3;I<M.positions.length;++I){var N=M.positions[I];c.push(N.x,N.y,N.z)}k(E,C,S,M,m,d,p,y)}else g.push(E,C,S);else g.push(E,C,S)}e.attributes.position.values=new Float64Array(c),u(m)&&(r.normal.values=a.createTypedArray(r.normal.componentDatatype,m)),u(d)&&(r.binormal.values=a.createTypedArray(r.binormal.componentDatatype,d)),u(p)&&(r.tangent.values=a.createTypedArray(r.tangent.componentDatatype,p)),u(y)&&(r.st.values=a.createTypedArray(r.st.componentDatatype,y));var L=h.computeNumberOfVertices(e);e.indices=w.createTypedArray(L,g)}function V(e){for(var r=e.attributes,t=r.position.values,i=e.indices,o=Array.prototype.slice.call(t,0),a=[],s=b.fromPointNormal(n.ZERO,n.UNIT_Y),f=i.length,l=0;f>l;l+=2){var c=i[l],m=i[l+1],d=n.fromArray(t,3*c),g=n.fromArray(t,3*m);if(Math.abs(d.y)<y.EPSILON6&&(d.y=d.y<0?-y.EPSILON6:y.EPSILON6,o[3*c+1]=d.y),Math.abs(g.y)<y.EPSILON6&&(g.y=g.y<0?-y.EPSILON6:y.EPSILON6,o[3*m+1]=g.y),a.push(c),d.x<0||g.x<0){var v=p.lineSegmentPlane(d,g,s);if(u(v)){var E=n.multiplyByScalar(n.UNIT_Y,5*y.EPSILON9,vr);d.y<0&&n.negate(E,E);var C=o.length/3;a.push(C,C+1);var S=n.add(v,E,br);o.push(S.x,S.y,S.z),n.negate(E,E),n.add(v,E,S),o.push(S.x,S.y,S.z)}}a.push(m)}e.attributes.position.values=new Float64Array(o);var q=h.computeNumberOfVertices(e);e.indices=w.createTypedArray(q,a)}var Y={};Y.toWireframe=function(e){if(!u(e))throw new f("geometry is required.");var r=e.indices;if(u(r)){switch(e.primitiveType){case E.TRIANGLES:e.indices=q(r);break;case E.TRIANGLE_STRIP:e.indices=x(r);break;case E.TRIANGLE_FAN:e.indices=A(r);break;default:throw new f("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=E.LINES}return e},Y.createLineSegmentsForVectors=function(e,t,n){if(t=s(t,"normal"),!u(e))throw new f("geometry is required.");if(!u(e.attributes.position))throw new f("geometry.attributes.position is required.");if(!u(e.attributes[t]))throw new f("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+t+".");n=s(n,1e4);for(var i=e.attributes.position.values,o=e.attributes[t].values,l=i.length,c=new Float64Array(2*l),w=0,d=0;l>d;d+=3)c[w++]=i[d],c[w++]=i[d+1],c[w++]=i[d+2],c[w++]=i[d]+o[d]*n,c[w++]=i[d+1]+o[d+1]*n,c[w++]=i[d+2]+o[d+2]*n;var p,y=e.boundingSphere;return u(y)&&(p=new r(y.center,y.radius+n)),new h({attributes:{position:new m({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:c})},primitiveType:E.LINES,boundingSphere:p})},Y.createAttributeLocations=function(e){if(!u(e))throw new f("geometry is required.");var r,t=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent"],n=e.attributes,i={},o=0,a=t.length;for(r=0;a>r;++r){var s=t[r];u(n[s])&&(i[s]=o++)}for(var l in n)n.hasOwnProperty(l)&&!u(i[l])&&(i[l]=o++);return i},Y.reorderForPreVertexCache=function(e){if(!u(e))throw new f("geometry is required.");var r=h.computeNumberOfVertices(e),t=e.indices;if(u(t)){for(var n=new Int32Array(r),i=0;r>i;i++)n[i]=-1;for(var o,s=t,l=s.length,c=w.createTypedArray(r,l),m=0,d=0,p=0;l>m;)o=n[s[m]],-1!==o?c[d]=o:(o=s[m],n[o]=p,c[d]=p,++p),++m,++d;e.indices=c;var y=e.attributes;for(var g in y)if(y.hasOwnProperty(g)&&u(y[g])&&u(y[g].values)){for(var v=y[g],b=v.values,E=0,C=v.componentsPerAttribute,S=a.createTypedArray(v.componentDatatype,p*C);r>E;){var q=n[E];if(-1!==q)for(i=0;C>i;i++)S[C*q+i]=b[C*E+i];++E}v.values=S}}return e},Y.reorderForPostVertexCache=function(e,r){if(!u(e))throw new f("geometry is required.");var t=e.indices;if(e.primitiveType===E.TRIANGLES&&u(t)){for(var n=t.length,i=0,o=0;n>o;o++)t[o]>i&&(i=t[o]);e.indices=C.tipsify({indices:t,maximumIndex:i,cacheSize:r})}return e},Y.fitToUnsignedShortIndices=function(e){if(!u(e))throw new f("geometry is required.");if(u(e.indices)&&e.primitiveType!==E.TRIANGLES&&e.primitiveType!==E.LINES&&e.primitiveType!==E.POINTS)throw new f("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var r=[],t=h.computeNumberOfVertices(e);if(u(e.indices)&&t>y.SIXTY_FOUR_KILOBYTES){var n,i=[],o=[],a=0,s=M(e.attributes),l=e.indices,c=l.length;e.primitiveType===E.TRIANGLES?n=3:e.primitiveType===E.LINES?n=2:e.primitiveType===E.POINTS&&(n=1);for(var m=0;c>m;m+=n){for(var w=0;n>w;++w){var d=l[m+w],p=i[d];u(p)||(p=a++,i[d]=p,T(s,e.attributes,d)),o.push(p)}a+n>y.SIXTY_FOUR_KILOBYTES&&(r.push(new h({attributes:s,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere})),i=[],o=[],a=0,s=M(e.attributes))}0!==o.length&&r.push(new h({attributes:s,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere}))}else r.push(e);return r};var H=new n,j=new o;Y.projectTo2D=function(e,r,t,i,o){if(!u(e))throw new f("geometry is required.");if(!u(r))throw new f("attributeName is required.");if(!u(t))throw new f("attributeName3D is required.");if(!u(i))throw new f("attributeName2D is required.");if(!u(e.attributes[r]))throw new f("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==a.DOUBLE)throw new f("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");var s=e.attributes[r];o=u(o)?o:new c;for(var l=o.ellipsoid,h=s.values,w=new Float64Array(h.length),d=0,p=0;p<h.length;p+=3){var y=n.fromArray(h,p,H),g=l.cartesianToCartographic(y,j);if(!u(g))throw new f("Could not project point ("+y.x+", "+y.y+", "+y.z+") to 2D.");var v=o.project(g,H);w[d++]=v.x,w[d++]=v.y,w[d++]=v.z}return e.attributes[t]=s,e.attributes[i]=new m({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:w}),delete e.attributes[r],e};var K={high:0,low:0};Y.encodeAttribute=function(e,r,t,n){if(!u(e))throw new f("geometry is required.");if(!u(r))throw new f("attributeName is required.");if(!u(t))throw new f("attributeHighName is required.");if(!u(n))throw new f("attributeLowName is required.");if(!u(e.attributes[r]))throw new f("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==a.DOUBLE)throw new f("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var i=e.attributes[r],o=i.values,s=o.length,c=new Float32Array(s),h=new Float32Array(s),w=0;s>w;++w)l.encode(o[w],K),c[w]=K.high,h[w]=K.low;var d=i.componentsPerAttribute;return e.attributes[t]=new m({componentDatatype:a.FLOAT,componentsPerAttribute:d,values:c}),e.attributes[n]=new m({componentDatatype:a.FLOAT,componentsPerAttribute:d,values:h}),delete e.attributes[r],e};var Z=new n,X=new v,Q=new g;Y.transformToWorldCoordinates=function(e){if(!u(e))throw new f("instance is required.");var t=e.modelMatrix;if(v.equals(t,v.IDENTITY))return e;var n=e.geometry.attributes;O(t,n.position),O(t,n.prevPosition),O(t,n.nextPosition),(u(n.normal)||u(n.binormal)||u(n.tangent))&&(v.inverse(t,X),v.transpose(X,X),v.getRotation(X,Q),R(Q,n.normal),R(Q,n.binormal),R(Q,n.tangent));var i=e.geometry.boundingSphere;return u(i)&&(e.geometry.boundingSphere=r.transform(i,t,i)),e.modelMatrix=v.clone(v.IDENTITY),e};var J=new n;Y.combine=function(e){if(!u(e)||e.length<1)throw new f("instances is required and must have length greater than zero.");var t,i,o,a,s=e.length,l=e[0].modelMatrix,c=u(e[0].geometry.indices),m=e[0].geometry.primitiveType;for(i=1;s>i;++i){if(!v.equals(e[i].modelMatrix,l))throw new f("All instances must have the same modelMatrix.");if(u(e[i].geometry.indices)!==c)throw new f("All instance geometries must have an indices or not have one.");if(e[i].geometry.primitiveType!==m)throw new f("All instance geometries must have the same primitiveType.")}var d,p,y,g=I(e);for(t in g)if(g.hasOwnProperty(t))for(d=g[t].values,a=0,i=0;s>i;++i)for(p=e[i].geometry.attributes[t].values,y=p.length,o=0;y>o;++o)d[a++]=p[o];var b;if(c){var C=0;for(i=0;s>i;++i)C+=e[i].geometry.indices.length;var S=h.computeNumberOfVertices(new h({attributes:g,primitiveType:E.POINTS})),q=w.createTypedArray(S,C),x=0,A=0;for(i=0;s>i;++i){var M=e[i].geometry.indices,T=M.length;for(a=0;T>a;++a)q[x++]=A+M[a];A+=h.computeNumberOfVertices(e[i].geometry)}b=q}var O,R=new n,N=0;for(i=0;s>i;++i){if(O=e[i].geometry.boundingSphere,!u(O)){R=void 0;break}n.add(O.center,R,R)}if(u(R))for(n.divideByScalar(R,s,R),i=0;s>i;++i){O=e[i].geometry.boundingSphere;var L=n.magnitude(n.subtract(O.center,R,J))+O.radius;L>N&&(N=L)}return new h({attributes:g,indices:b,primitiveType:m,boundingSphere:u(R)?new r(R,N):void 0})};var $=new n,er=new n,rr=new n,tr=new n;Y.computeNormal=function(e){if(!u(e))throw new f("geometry is required.");if(!u(e.attributes.position)||!u(e.attributes.position.values))throw new f("geometry.attributes.position.values is required.");if(!u(e.indices))throw new f("geometry.indices is required.");if(e.indices.length<2||0!==e.indices.length%3)throw new f("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==E.TRIANGLES)throw new f("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var r=e.indices,t=e.attributes,i=t.position.values,o=t.position.values.length/3,s=r.length,l=new Array(o),c=new Array(s/3),h=new Array(s),w=0;o>w;w++)l[w]={indexOffset:0,count:0,currentCount:0};var d=0;for(w=0;s>w;w+=3){var p=r[w],y=r[w+1],g=r[w+2],v=3*p,b=3*y,C=3*g;er.x=i[v],er.y=i[v+1],er.z=i[v+2],rr.x=i[b],rr.y=i[b+1],rr.z=i[b+2],tr.x=i[C],tr.y=i[C+1],tr.z=i[C+2],l[p].count++,l[y].count++,l[g].count++,n.subtract(rr,er,rr),n.subtract(tr,er,tr),c[d]=n.cross(rr,tr,new n),d++}var S=0;for(w=0;o>w;w++)l[w].indexOffset+=S,S+=l[w].count;d=0;var q;for(w=0;s>w;w+=3){q=l[r[w]];var x=q.indexOffset+q.currentCount;h[x]=d,q.currentCount++,q=l[r[w+1]],x=q.indexOffset+q.currentCount,h[x]=d,q.currentCount++,q=l[r[w+2]],x=q.indexOffset+q.currentCount,h[x]=d,q.currentCount++,d++}var A=new Float32Array(3*o);for(w=0;o>w;w++){var M=3*w;if(q=l[w],q.count>0){for(n.clone(n.ZERO,$),d=0;d<q.count;d++)n.add($,c[h[q.indexOffset+d]],$);n.normalize($,$),A[M]=$.x,A[M+1]=$.y,A[M+2]=$.z}else A[M]=0,A[M+1]=0,A[M+2]=1}return e.attributes.normal=new m({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:A}),e};var nr=new n,ir=new n,or=new n;Y.computeBinormalAndTangent=function(e){if(!u(e))throw new f("geometry is required.");var r=e.attributes,t=e.indices;if(!u(r.position)||!u(r.position.values))throw new f("geometry.attributes.position.values is required.");if(!u(r.normal)||!u(r.normal.values))throw new f("geometry.attributes.normal.values is required.");if(!u(r.st)||!u(r.st.values))throw new f("geometry.attributes.st.values is required.");if(!u(t))throw new f("geometry.indices is required.");if(t.length<2||0!==t.length%3)throw new f("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==E.TRIANGLES)throw new f("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var i=e.attributes.position.values,o=e.attributes.normal.values,s=e.attributes.st.values,l=e.attributes.position.values.length/3,c=t.length,h=new Array(3*l),w=0;w<h.length;w++)h[w]=0;var d,p,y;for(w=0;c>w;w+=3){var g=t[w],v=t[w+1],b=t[w+2];d=3*g,p=3*v,y=3*b;var C=2*g,S=2*v,q=2*b,x=i[d],A=i[d+1],M=i[d+2],T=s[C],O=s[C+1],R=s[S+1]-O,I=s[q+1]-O,N=1/((s[S]-T)*I-(s[q]-T)*R),L=(I*(i[p]-x)-R*(i[y]-x))*N,P=(I*(i[p+1]-A)-R*(i[y+1]-A))*N,D=(I*(i[p+2]-M)-R*(i[y+2]-M))*N;h[d]+=L,h[d+1]+=P,h[d+2]+=D,h[p]+=L,h[p+1]+=P,h[p+2]+=D,h[y]+=L,h[y+1]+=P,h[y+2]+=D}var z=new Float32Array(3*l),F=new Float32Array(3*l);for(w=0;l>w;w++){d=3*w,p=d+1,y=d+2;var _=n.fromArray(o,d,nr),B=n.fromArray(h,d,or),U=n.dot(_,B);n.multiplyByScalar(_,U,ir),n.normalize(n.subtract(B,ir,B),B),F[d]=B.x,F[p]=B.y,F[y]=B.z,n.normalize(n.cross(_,B,B),B),z[d]=B.x,z[p]=B.y,z[y]=B.z}return e.attributes.tangent=new m({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:F}),e.attributes.binormal=new m({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:z}),e};var ar=new n,sr=new n,ur=new n,fr=new n,lr=new n,cr={positions:new Array(7),indices:new Array(9)},hr=new t,mr=new t,wr=new t,dr=new n,pr=new n,yr=new n,gr=new n,vr=new n,br=new n;return Y.wrapLongitude=function(e){if(!u(e))throw new f("geometry is required.");var t=e.boundingSphere;if(u(t)){var n=t.center.x-t.radius;if(n>0||r.intersect(t,i.UNIT_Y)!==d.INTERSECTING)return e}return _(e),e.primitiveType===E.TRIANGLES?W(e):e.primitiveType===E.LINES&&V(e),e},Y}),define("Core/WebMercatorProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,r,t,n,i,o,a,s){"use strict";var u=function(e){this._ellipsoid=t(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.mercatorAngleToGeodeticLatitude=function(e){return s.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},u.geodeticLatitudeToMercatorAngle=function(e){e>u.MaximumLatitude?e=u.MaximumLatitude:e<-u.MaximumLatitude&&(e=-u.MaximumLatitude);var r=Math.sin(e);return.5*Math.log((1+r)/(1-r))},u.MaximumLatitude=u.mercatorAngleToGeodeticLatitude(Math.PI),u.prototype.project=function(r,t){var i=this._semimajorAxis,o=r.longitude*i,a=u.geodeticLatitudeToMercatorAngle(r.latitude)*i,s=r.height;return n(t)?(t.x=o,t.y=a,t.z=s,t):new e(o,a,s)},u.prototype.unproject=function(e,t){if(!n(e))throw new o("cartesian is required");var i=this._oneOverSemimajorAxis,a=e.x*i,s=u.mercatorAngleToGeodeticLatitude(e.y*i),f=e.z;return n(t)?(t.longitude=a,t.latitude=s,t.height=f,t):new r(a,s,f)},u}),define("Scene/PrimitivePipeline",["../Core/BoundingSphere","../Core/Color","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Ellipsoid","../Core/FeatureDetection","../Core/GeographicProjection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryPipeline","../Core/IndexDatatype","../Core/Matrix4","../Core/WebMercatorProjection"],function(e,r,t,n,i,o,a,s,u,f,l,c,h,m,w){"use strict";function d(e,r,t){var n,i=!t,o=e.length;if(!i&&o>1){var a=e[0].modelMatrix;for(n=1;o>n;++n)if(!m.equals(a,e[n].modelMatrix)){i=!0;break}}if(i)for(n=0;o>n;++n)c.transformToWorldCoordinates(e[n]);else m.clone(e[0].modelMatrix,r)}function p(e,n){for(var i=e.length,o=0;i>o;++o){var a=e[o],s=a.geometry,u=s.attributes,f=u.position,c=4*(f.values.length/f.componentsPerAttribute);u.pickColor=new l({componentDatatype:t.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0,values:new Uint8Array(c)});for(var h=n[o],m=r.floatToByte(h.red),w=r.floatToByte(h.green),d=r.floatToByte(h.blue),p=r.floatToByte(h.alpha),y=u.pickColor.values,g=0;c>g;g+=4)y[g]=m,y[g+1]=w,y[g+2]=d,y[g+3]=p}}function y(e){var r,t=e.length,n=[],o=e[0].attributes;for(r in o)if(o.hasOwnProperty(r)){for(var a=o[r],s=!0,u=1;t>u;++u){var f=e[u].attributes[r];if(!i(f)||a.componentDatatype!==f.componentDatatype||a.componentsPerAttribute!==f.componentsPerAttribute||a.normalize!==f.normalize){s=!1;break}}s&&n.push(r)}return n}function g(e,r){for(var n=e.length,i=0;n>i;++i)for(var o=e[i],a=o.attributes,s=o.geometry,u=f.computeNumberOfVertices(s),c=r.length,h=0;c>h;++h){for(var m=r[h],w=a[m],d=w.componentDatatype,p=w.value,y=p.length,g=t.createTypedArray(d,u*y),v=0;u>v;++v)g.set(p,v*y);s.attributes[m]=new l({componentDatatype:d,componentsPerAttribute:y,normalize:w.normalize,values:g})}}function v(e){var r,n=e.instances,i=e.pickIds,a=e.projection,s=e.elementIndexUintSupported,u=e.allow3DOnly,f=e.allowPicking,l=e.vertexCacheOptimize,h=e.modelMatrix,m=n.length,w=n[0].geometry.primitiveType;for(r=1;m>r;++r)if(n[r].geometry.primitiveType!==w)throw new o("All instance geometries must have the same primitiveType.");if(d(n,h,u),!u)for(r=0;m>r;++r)c.wrapLongitude(n[r].geometry);f&&p(n,i);var v=y(n);if(g(n,v),l)for(r=0;m>r;++r)c.reorderForPostVertexCache(n[r].geometry),c.reorderForPreVertexCache(n[r].geometry);var b,E=c.combine(n),C=E.attributes;if(u)for(b in C)C.hasOwnProperty(b)&&C[b].componentDatatype===t.DOUBLE&&c.encodeAttribute(E,b,b+"3DHigh",b+"3DLow");else for(b in C)if(C.hasOwnProperty(b)&&C[b].componentDatatype===t.DOUBLE){var S=b+"3D",q=b+"2D";c.projectTo2D(E,b,S,q,a),c.encodeAttribute(E,S,S+"High",S+"Low"),c.encodeAttribute(E,q,q+"High",q+"Low")}return s?[E]:c.fitToUnsignedShortIndices(E)}function b(e,r,n){for(var i=[],o=e.attributes,a=n.length,s=0;a>s;++s){var u=n[s],f=o[u],l=f.componentDatatype;l===t.DOUBLE&&(l=t.FLOAT);var c=t.createTypedArray(l,f.values);i.push({index:r[u],componentDatatype:l,componentsPerAttribute:f.componentsPerAttribute,normalize:f.normalize,values:c}),delete o[u]}return i}function E(e,r,t){for(var o=[],a=y(e),s=e.length,u={},l={},c=0;s>c;++c)for(var h=e[c],m=f.computeNumberOfVertices(h.geometry),w=a.length,d=0;w>d;++d)for(var p=a[d],g=t[p],v=m;v>0;){for(var b,E=n(l[p],0),C=r[E],S=C.length,q=0;S>q&&(b=C[q],b.index!==g);++q);i(o[c])||(o[c]={}),i(o[c][p])||(o[c][p]={dirty:!1,value:h.attributes[p].value,indices:[]});var x,A=b.values.length/b.componentsPerAttribute,M=n(u[p],0);A>M+v?(x=v,o[c][p].indices.push({attribute:b,offset:M,count:x}),u[p]=M+v):(x=A-M,o[c][p].indices.push({attribute:b,offset:M,count:x}),u[p]=0,l[p]=E+1),v-=x
}return o}function C(e,r){var t=e.attributes;for(var n in t)if(t.hasOwnProperty(n)){var o=t[n];i(o)&&i(o.values)&&r.push(o.values.buffer)}i(e.indices)&&r.push(e.indices.buffer)}function S(e,r){for(var t=e.length,n=0;t>n;++n)C(e[n],r)}function q(e,r){for(var t=e.length,n=0;t>n;++n)for(var i=e[n],o=i.length,a=0;o>a;++a)r.push(i[a].values.buffer)}function x(r){for(var t=1,n=r.length,o=0;n>o;o++){var a=r[o],s=a.attributes;t+=3+e.packedLength+(i(a.indices)?a.indices.length:0);for(var u in s)if(s.hasOwnProperty(u)&&i(s[u])){var f=s[u];t+=5+f.values.length}}return t}function A(e,r){for(var t=e.length,n=new Uint32Array(e.length),i=0;t>i;++i)n[i]=e[i].toRgba();return r.push(n.buffer),n}function M(e){for(var t=e.length,n=new Array(t),i=0;t>i;i++)n[i]=r.fromRgba(e[i]);return n}function T(e){for(var r=e.length,t=1+17*r,n=0;r>n;n++){var o=e[n].attributes;for(var a in o)if(o.hasOwnProperty(a)&&i(o[a])){var s=o[a];t+=5+s.value.length}}return t}function O(e,r){var t=new Float64Array(T(e)),n={},o=[],a=e.length,s=0;t[s++]=a;for(var u=0;a>u;u++){var f=e[u];m.pack(f.modelMatrix,t,s),s+=m.packedLength;var l=f.attributes,c=[];for(var h in l)l.hasOwnProperty(h)&&i(l[h])&&(c.push(h),i(n[h])||(n[h]=o.length,o.push(h)));t[s++]=c.length;for(var w=0;w<c.length;w++){var d=c[w],p=l[d];t[s++]=n[d],t[s++]=p.componentDatatype,t[s++]=p.componentsPerAttribute,t[s++]=p.normalize,t[s++]=p.value.length,t.set(p.value,s),s+=p.value.length}}return r.push(t.buffer),{stringTable:o,packedData:t}}function R(e){for(var r=e.packedData,n=e.stringTable,i=new Array(r[0]),o=0,a=1;a<r.length;){var s=m.unpack(r,a);a+=m.packedLength;for(var u={},f=r[a++],l=0;f>l;l++){for(var c=n[r[a++]],h=r[a++],w=r[a++],d=0!==r[a++],p=r[a++],y=t.createTypedArray(h,p),g=0;p>g;g++)y[g]=r[a++];u[c]={componentDatatype:h,componentsPerAttribute:w,normalize:d,value:y}}i[o++]={attributes:u,modelMatrix:s}}return i}function I(e){for(var r=e.length,t=1+r,n=0;r>n;n++){var o=e[n];for(var a in o)if(o.hasOwnProperty(a)&&i(o[a])){var s=o[a];t+=3+3*s.indices.length+s.value.length}}return t}function N(e,r){var t=new Float64Array(I(e)),n=[],o=[],a={},s=e.length,u=0;t[u++]=s;for(var f=0;s>f;f++){var l=e[f],c=[];for(var h in l)l.hasOwnProperty(h)&&i(l[h])&&(c.push(h),i(a[h])||(a[h]=n.length,n.push(h)));t[u++]=c.length;for(var m=0;m<c.length;m++){var w=c[m],d=l[w];t[u++]=a[w];var p=d.indices,y=p.length;t[u++]=y;for(var g=0;y>g;g++){var v=p[g];t[u++]=v.count,t[u++]=v.offset;var b=o.indexOf(v.attribute);-1===b&&(b=o.length,o.push(v.attribute)),t[u++]=b}t[u++]=d.value.length,t.set(d.value,u),u+=d.value.length}}return r.push(t.buffer),{stringTable:n,packedData:t,attributeTable:o}}function L(e){for(var r=e.stringTable,n=e.attributeTable,i=e.packedData,o=new Array(i[0]),a=0,s=1,u=i.length;u>s;){for(var f={},l=i[s++],c=0;l>c;c++){for(var h=r[i[s++]],m=new Array(i[s++]),w=0;w<m.length;w++){var d={};d.count=i[s++],d.offset=i[s++],d.attribute=n[i[s++]],m[w]=d}for(var p=i[s++],y=t.createTypedArray(m[0].attribute.componentDatatype,p),g=0;p>g;g++)y[g]=i[s++];f[h]={dirty:!1,indices:m,value:y}}o[a++]=f}return o}if(!s.supportsTypedArrays())return{};var P={};return P.combineGeometry=function(e){for(var r={instances:e.instances,pickIds:e.pickIds,ellipsoid:e.ellipsoid,projection:e.projection,elementIndexUintSupported:e.elementIndexUintSupported,allow3DOnly:e.allow3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,modelMatrix:m.clone(e.modelMatrix)},t=v(r),n=c.createAttributeLocations(t[0]),i=r.instances,o=y(i),a=[],s=t.length,u=0;s>u;++u){var f=t[u];a.push(b(f,n,o))}var l=E(i,a,n);return{geometries:t,modelMatrix:r.modelMatrix,attributeLocations:n,vaAttributes:a,vaAttributeLocations:l}},P.packCreateGeometryResults=function(r,t){var n=new Float64Array(x(r)),o=[],a={},s=r.length,u=0;n[u++]=s;for(var f=0;s>f;f++){var l=r[f];n[u++]=l.primitiveType,e.pack(l.boundingSphere,n,u),u+=e.packedLength;var c=l.attributes,h=[];for(var m in c)c.hasOwnProperty(m)&&i(c[m])&&(h.push(m),i(a[m])||(a[m]=o.length,o.push(m)));n[u++]=h.length;for(var w=0;w<h.length;w++){var d=h[w],p=c[d];n[u++]=a[d],n[u++]=p.componentDatatype,n[u++]=p.componentsPerAttribute,n[u++]=p.normalize?1:0,n[u++]=p.values.length,n.set(p.values,u),u+=p.values.length}var y=i(l.indices)?l.indices.length:0;n[u++]=y,y>0&&(n.set(l.indices,u),u+=y)}return t.push(n.buffer),{stringTable:o,packedData:n}},P.unpackCreateGeometryResults=function(r){for(var n,i=r.stringTable,o=r.packedData,a=new Array(o[0]),s=0,u=1;u<o.length;){var c=o[u++],m=e.unpack(o,u);u+=e.packedLength;var w,d,p,y={},g=o[u++];for(n=0;g>n;n++){var v=i[o[u++]],b=o[u++];p=o[u++];var E=0!==o[u++];w=o[u++],d=t.createTypedArray(b,w);for(var C=0;w>C;C++)d[C]=o[u++];y[v]=new l({componentDatatype:b,componentsPerAttribute:p,normalize:E,values:d})}var S;if(w=o[u++],w>0){var q=d.length/p;for(S=h.createTypedArray(q,w),n=0;w>n;n++)S[n]=o[u++]}a[s++]=new f({primitiveType:c,boundingSphere:m,indices:S,attributes:y})}return a},P.packCombineGeometryParameters=function(e,r){for(var t=e.createGeometryResults,n=t.length,i=0;n>i;i++)r.push(t[i].packedData.buffer);var o;return e.allowPicking&&(o=A(e.pickIds,r)),{createGeometryResults:e.createGeometryResults,packedInstances:O(e.instances,r),packedPickIds:o,ellipsoid:e.ellipsoid,isGeographic:e.projection instanceof u,elementIndexUintSupported:e.elementIndexUintSupported,allow3DOnly:e.allow3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,modelMatrix:e.modelMatrix}},P.unpackCombineGeometryParameters=function(e){for(var r=R(e.packedInstances),t=e.allowPicking?M(e.packedPickIds):void 0,n=e.createGeometryResults,i=n.length,o=0,s=0;i>s;s++)for(var f=P.unpackCreateGeometryResults(n[s]),l=f.length,c=0;l>c;c++)r[o++].geometry=f[c];var h=a.clone(e.ellipsoid),d=e.isGeographic?new u(h):new w(h);return m.clone(e.modelMatrix),{instances:r,pickIds:t,ellipsoid:h,projection:d,elementIndexUintSupported:e.elementIndexUintSupported,allow3DOnly:e.allow3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,modelMatrix:e.modelMatrix}},P.packCombineGeometryResults=function(e,r){return S(e.geometries,r),q(e.vaAttributes,r),{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,packedVaAttributeLocations:N(e.vaAttributeLocations,r),modelMatrix:e.modelMatrix}},P.unpackCombineGeometryResults=function(e){return{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,perInstanceAttributeLocations:L(e.packedVaAttributeLocations,e.vaAttributes),modelMatrix:e.modelMatrix}},P}),define("Core/formatError",["./defined"],function(e){"use strict";var r=function(r){var t,n=r.name,i=r.message;t=e(n)&&e(i)?n+": "+i:r.toString();var o=r.stack;return e(o)&&(t+="\n"+o),t};return r}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,r,t){"use strict";var n=function(n){var i,o=[],a={id:void 0,result:void 0,error:void 0};return function(s){var u=s.data;o.length=0,a.id=u.id,a.error=void 0,a.result=void 0;try{a.result=n(u.parameters,o)}catch(f){a.error=f instanceof Error?{name:f.name,message:f.message,stack:f.stack}:f}r(i)||(i=e(self.webkitPostMessage,self.postMessage)),u.canTransferArrayBuffer||(o.length=0);try{i(a,o)}catch(f){a.result=void 0,a.error="postMessage failed with error: "+t(f)+"\n  with responseMessage: "+JSON.stringify(a),i(a)}}};return n}),define("Workers/combineGeometry",["../Scene/PrimitivePipeline","./createTaskProcessorWorker"],function(e,r){"use strict";function t(r,t){var n=e.unpackCombineGeometryParameters(r),i=e.combineGeometry(n);return e.packCombineGeometryResults(i,t)}return r(t)})}();