/**
 * Created with IntelliJ IDEA.
 * User: patrickclancey
 * Date: 28/05/2013
 * Time: 10:41
 * To change this template use File | Settings | File Templates.
 */







test( "No video links on current page", function() {
    ok( jQuery().youtubeVideoGallery().test.getVideoLinks( jQuery('#test-html') ).length === 0, "Passed" );
});
test( "One video link on current page", function() {
    $('#test-html').append('<a href="href">title</a>');
    ok( jQuery().youtubeVideoGallery().test.getVideoLinks( jQuery('#test-html') ).length === 1, "Passed" );
    $('#test-html').empty();
});

test( "Get before, returns the string before a given substring", function() {
    ok( jQuery().youtubeVideoGallery().test.getBefore( 'abcdefg', 'efg' ) === 'abcd', "Passed" );
});
test( "Get before, returns the string entire string if substring not found", function() {
    ok( jQuery().youtubeVideoGallery().test.getBefore( 'abcdefg', 'xwz' ) === 'abcdefg', "Passed" );
});
test( "Get before, returns empty string if empty string is passed in", function() {
    ok( jQuery().youtubeVideoGallery().test.getBefore( '', '' ) === '', "Passed" );
});

test( "Get id, returns the id if URL format links to normal page", function() {
    ok( jQuery().youtubeVideoGallery().test.getId( 'http://www.youtube.com/watch?v=XNsa1mu12yI' ) === 'XNsa1mu12yI', "Passed" );
});
test( "Get id, returns the id if URL format links to embed page", function() {
    ok( jQuery().youtubeVideoGallery().test.getId( 'http://www.youtube.com/embed/XNsa1mu12yI' ) === 'XNsa1mu12yI', "Passed" );
});
test( "Get id, returns the string if it's not a youtube url", function() {
    ok( jQuery().youtubeVideoGallery().test.getId( 'q8m0hAXBRDA' ) === 'q8m0hAXBRDA', "Passed" );
});
test( "Get id, returns empty string if an empty string is passed in", function() {
    ok( jQuery().youtubeVideoGallery().test.getId( '' ) === '', "Passed" );
});


test( "Get iframe template", function() {
    ok( jQuery().youtubeVideoGallery().test.getIframeTemplate( 200, 100 ) === '<iframe title="Youtube video player" id="youtube-videogallery-iframe" style="height:100px;width:200px;" frameborder="0" src="about:blank" />', "Passed" );
    ok( jQuery().youtubeVideoGallery().test.getIframeTemplate( 400, 200 ) === '<iframe title="Youtube video player" id="youtube-videogallery-iframe" style="height:200px;width:400px;" frameborder="0" src="about:blank" />', "Passed" );
});



test( "Get getTitleStyle", function() {
    ok( jQuery().youtubeVideoGallery().test.getTitleStyle( 'full' ) === 'youtube-videogallery-allowtitle', "Passed" );
    ok( jQuery().youtubeVideoGallery().test.getTitleStyle( 'none' ) === '', "Passed" );
    ok( jQuery().youtubeVideoGallery().test.getTitleStyle( 'default' ) === '', "Passed" );
});

test( "Get getStyle", function() {
    ok( jQuery().youtubeVideoGallery().test.getStyle( '' ) === '', "Passed" );
    ok( jQuery().youtubeVideoGallery().test.getStyle( 'some-value' ) === 'youtube-videogallery-some-value', "Passed" );
});

test( "Get videos array from getVideosFromFeed", function() {
    var feed = JSON.parse('{"version":"1.0","encoding":"UTF-8","feed":{"xmlns":"http://www.w3.org/2005/Atom","xmlns$media":"http://search.yahoo.com/mrss/","xmlns$openSearch":"http://a9.com/-/spec/opensearch/1.1/","xmlns$gd":"http://schemas.google.com/g/2005","xmlns$yt":"http://gdata.youtube.com/schemas/2007","gd$etag":"W0AGRXo_fyp7I2A9WhFTGEQ.","id":{"$t":"tag:youtube.com,2008:videos"},"updated":{"$t":"2013-06-10T19:15:24.447Z"},"category":[{"scheme":"http://schemas.google.com/g/2005#kind","term":"http://gdata.youtube.com/schemas/2007#video"}],"title":{"$t":"Videos matching: football -soccer"},"logo":{"$t":"http://www.youtube.com/img/pic_youtubelogo_123x63.gif"},"link":[{"rel":"alternate","type":"text/html","href":"https://www.youtube.com"},{"rel":"http://schemas.google.com/g/2005#feed","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos?v=2"},{"rel":"http://schemas.google.com/g/2005#batch","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/batch?v=2"},{"rel":"self","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos?alt=json&q=football+-soccer&start-index=1&max-results=10&orderby=published&v=2"},{"rel":"service","type":"application/atomsvc+xml","href":"https://gdata.youtube.com/feeds/api/videos?alt=atom-service&v=2"},{"rel":"next","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos?alt=json&q=football+-soccer&start-index=11&max-results=10&orderby=published&v=2"}],"author":[{"name":{"$t":"YouTube"},"uri":{"$t":"http://www.youtube.com/"}}],"generator":{"$t":"YouTube data API","version":"2.1","uri":"http://gdata.youtube.com"},"openSearch$totalResults":{"$t":1000000},"openSearch$startIndex":{"$t":1},"openSearch$itemsPerPage":{"$t":10},"entry":[{"gd$etag":"WCkUGRn47eCp7I2A9WhFTGEQ","id":{"$t":"tag:youtube.com,2008:video:rmhfbnpIIM8"},"published":{"$t":"2013-06-10T18:38:17.000Z"},"updated":{"$t":"2013-06-10T18:50:27.000Z"},"category":[{"scheme":"http://schemas.google.com/g/2005#kind","term":"http://gdata.youtube.com/schemas/2007#video"},{"scheme":"http://gdata.youtube.com/schemas/2007/categories.cat","term":"Sports","label":"Sports"}],"title":{"$t":"Donald\'s 2013 Bowman Football Box Break"},"content":{"type":"application/x-shockwave-flash","src":"https://www.youtube.com/v/rmhfbnpIIM8?version=3&f=videos&app=youtube_gdata"},"link":[{"rel":"alternate","type":"text/html","href":"https://www.youtube.com/watch?v=rmhfbnpIIM8&feature=youtube_gdata"},{"rel":"http://gdata.youtube.com/schemas/2007#video.responses","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/rmhfbnpIIM8/responses?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#video.related","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/rmhfbnpIIM8/related?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#mobile","type":"text/html","href":"https://m.youtube.com/details?v=rmhfbnpIIM8"},{"rel":"http://gdata.youtube.com/schemas/2007#uploader","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/users/mnp-WxsWlhdGZ_lforMX4g?v=2"},{"rel":"self","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/rmhfbnpIIM8?v=2"}],"author":[{"name":{"$t":"chri5784"},"uri":{"$t":"https://gdata.youtube.com/feeds/api/users/chri5784"},"yt$userId":{"$t":"mnp-WxsWlhdGZ_lforMX4g"}}],"yt$accessControl":[{"action":"comment","permission":"allowed"},{"action":"commentVote","permission":"allowed"},{"action":"videoRespond","permission":"moderated"},{"action":"rate","permission":"allowed"},{"action":"embed","permission":"allowed"},{"action":"list","permission":"allowed"},{"action":"autoPlay","permission":"allowed"},{"action":"syndicate","permission":"allowed"}],"gd$comments":{"gd$feedLink":{"rel":"http://gdata.youtube.com/schemas/2007#comments","href":"https://gdata.youtube.com/feeds/api/videos/rmhfbnpIIM8/comments?v=2","countHint":9}},"yt$hd":{},"media$group":{"media$category":[{"$t":"Sports","label":"Sports","scheme":"http://gdata.youtube.com/schemas/2007/categories.cat"}],"media$content":[{"url":"https://www.youtube.com/v/rmhfbnpIIM8?version=3&f=videos&app=youtube_gdata","type":"application/x-shockwave-flash","medium":"video","isDefault":"true","expression":"full","duration":290,"yt$format":5},{"url":"rtsp://v5.cache3.c.youtube.com/CiILENy73wIaGQnPIEh6bl9orhMYDSANFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":290,"yt$format":1},{"url":"rtsp://v5.cache3.c.youtube.com/CiILENy73wIaGQnPIEh6bl9orhMYESARFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":290,"yt$format":6}],"media$credit":[{"$t":"chri5784","role":"uploader","scheme":"urn:youtube","yt$display":"chri5784","yt$type":"partner"}],"media$description":{"$t":"Thanks a lot Donald, Chris J. http://www.cardsinfinity.com/ For random updates and etc: Facebook: http://www.facebook.com/#!/pages/Cards-Infinitycom/18806405...","type":"plain"},"media$keywords":{},"media$license":{"$t":"youtube","type":"text/html","href":"http://www.youtube.com/t/terms"},"media$player":{"url":"https://www.youtube.com/watch?v=rmhfbnpIIM8&feature=youtube_gdata_player"},"media$thumbnail":[{"url":"https://i.ytimg.com/vi/rmhfbnpIIM8/default.jpg","height":90,"width":120,"time":"00:02:25","yt$name":"default"},{"url":"https://i.ytimg.com/vi/rmhfbnpIIM8/mqdefault.jpg","height":180,"width":320,"yt$name":"mqdefault"},{"url":"https://i.ytimg.com/vi/rmhfbnpIIM8/hqdefault.jpg","height":360,"width":480,"yt$name":"hqdefault"},{"url":"https://i.ytimg.com/vi/rmhfbnpIIM8/sddefault.jpg","height":480,"width":640,"yt$name":"sddefault"},{"url":"https://i.ytimg.com/vi/rmhfbnpIIM8/1.jpg","height":90,"width":120,"time":"00:01:12.500","yt$name":"start"},{"url":"https://i.ytimg.com/vi/rmhfbnpIIM8/2.jpg","height":90,"width":120,"time":"00:02:25","yt$name":"middle"},{"url":"https://i.ytimg.com/vi/rmhfbnpIIM8/3.jpg","height":90,"width":120,"time":"00:03:37.500","yt$name":"end"}],"media$title":{"$t":"Donald\'s 2013 Bowman Football Box Break","type":"plain"},"yt$aspectRatio":{"$t":"widescreen"},"yt$duration":{"seconds":"290"},"yt$uploaded":{"$t":"2013-06-10T18:38:17.000Z"},"yt$uploaderId":{"$t":"UCmnp-WxsWlhdGZ_lforMX4g"},"yt$videoid":{"$t":"rmhfbnpIIM8"}},"gd$rating":{"average":5.0,"max":5,"min":1,"numRaters":7,"rel":"http://schemas.google.com/g/2005#overall"},"yt$statistics":{"favoriteCount":"0","viewCount":"54"},"yt$rating":{"numDislikes":"0","numLikes":"7"}},{"gd$etag":"W0MMR347eCp7I2A9WhFTGEU","id":{"$t":"tag:youtube.com,2008:video:BJicWWQgc3M"},"published":{"$t":"2013-06-10T18:21:54.000Z"},"updated":{"$t":"2013-06-10T18:38:06.000Z"},"category":[{"scheme":"http://schemas.google.com/g/2005#kind","term":"http://gdata.youtube.com/schemas/2007#video"},{"scheme":"http://gdata.youtube.com/schemas/2007/categories.cat","term":"Howto","label":"Howto & Style"}],"title":{"$t":"Top Eleven Football Manager Tokens Generator"},"content":{"type":"application/x-shockwave-flash","src":"https://www.youtube.com/v/BJicWWQgc3M?version=3&f=videos&app=youtube_gdata"},"link":[{"rel":"alternate","type":"text/html","href":"https://www.youtube.com/watch?v=BJicWWQgc3M&feature=youtube_gdata"},{"rel":"http://gdata.youtube.com/schemas/2007#video.responses","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/BJicWWQgc3M/responses?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#video.related","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/BJicWWQgc3M/related?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#mobile","type":"text/html","href":"https://m.youtube.com/details?v=BJicWWQgc3M"},{"rel":"http://gdata.youtube.com/schemas/2007#uploader","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/users/vt9JlENpbRdbpfvCbFDmSA?v=2"},{"rel":"self","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/BJicWWQgc3M?v=2"}],"author":[{"name":{"$t":"JoanM Miller"},"uri":{"$t":"https://gdata.youtube.com/feeds/api/users/vt9JlENpbRdbpfvCbFDmSA"},"yt$userId":{"$t":"vt9JlENpbRdbpfvCbFDmSA"}}],"yt$accessControl":[{"action":"comment","permission":"allowed"},{"action":"commentVote","permission":"allowed"},{"action":"videoRespond","permission":"moderated"},{"action":"rate","permission":"allowed"},{"action":"embed","permission":"allowed"},{"action":"list","permission":"allowed"},{"action":"autoPlay","permission":"allowed"},{"action":"syndicate","permission":"allowed"}],"gd$comments":{"gd$feedLink":{"rel":"http://gdata.youtube.com/schemas/2007#comments","href":"https://gdata.youtube.com/feeds/api/videos/BJicWWQgc3M/comments?v=2","countHint":0}},"media$group":{"media$category":[{"$t":"Howto","label":"Howto & Style","scheme":"http://gdata.youtube.com/schemas/2007/categories.cat"}],"media$content":[{"url":"https://www.youtube.com/v/BJicWWQgc3M?version=3&f=videos&app=youtube_gdata","type":"application/x-shockwave-flash","medium":"video","isDefault":"true","expression":"full","duration":42,"yt$format":5},{"url":"rtsp://v5.cache1.c.youtube.com/CiILENy73wIaGQlzcyBkWZyYBBMYDSANFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":42,"yt$format":1},{"url":"rtsp://v5.cache1.c.youtube.com/CiILENy73wIaGQlzcyBkWZyYBBMYESARFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":42,"yt$format":6}],"media$credit":[{"$t":"vt9JlENpbRdbpfvCbFDmSA","role":"uploader","scheme":"urn:youtube","yt$display":"JoanM Miller","yt$type":"partner"}],"media$description":{"$t":"Download from mediafire Link : http://www.mediafire.com/?n09357g5gcz5z5t Scanned For Virus : http://Virustotal.com/ Scan it Yourself if You Can Feel As If It...","type":"plain"},"media$keywords":{},"media$license":{"$t":"youtube","type":"text/html","href":"http://www.youtube.com/t/terms"},"media$player":{"url":"https://www.youtube.com/watch?v=BJicWWQgc3M&feature=youtube_gdata_player"},"media$thumbnail":[{"url":"https://i.ytimg.com/vi/BJicWWQgc3M/default.jpg","height":90,"width":120,"time":"00:00:21","yt$name":"default"},{"url":"https://i.ytimg.com/vi/BJicWWQgc3M/mqdefault.jpg","height":180,"width":320,"yt$name":"mqdefault"},{"url":"https://i.ytimg.com/vi/BJicWWQgc3M/hqdefault.jpg","height":360,"width":480,"yt$name":"hqdefault"},{"url":"https://i.ytimg.com/vi/BJicWWQgc3M/sddefault.jpg","height":480,"width":640,"yt$name":"sddefault"},{"url":"https://i.ytimg.com/vi/BJicWWQgc3M/1.jpg","height":90,"width":120,"time":"00:00:10.500","yt$name":"start"},{"url":"https://i.ytimg.com/vi/BJicWWQgc3M/2.jpg","height":90,"width":120,"time":"00:00:21","yt$name":"middle"},{"url":"https://i.ytimg.com/vi/BJicWWQgc3M/3.jpg","height":90,"width":120,"time":"00:00:31.500","yt$name":"end"}],"media$title":{"$t":"Top Eleven Football Manager Tokens Generator","type":"plain"},"yt$aspectRatio":{"$t":"widescreen"},"yt$duration":{"seconds":"42"},"yt$uploaded":{"$t":"2013-06-10T18:21:54.000Z"},"yt$uploaderId":{"$t":"UCvt9JlENpbRdbpfvCbFDmSA"},"yt$videoid":{"$t":"BJicWWQgc3M"}}},{"gd$etag":"WMBSX47eCp7I2A9WhFTGEU","id":{"$t":"tag:youtube.com,2008:video:BKHoqk8STbY"},"published":{"$t":"2013-06-10T18:19:51.000Z"},"updated":{"$t":"2013-06-10T18:20:58.000Z"},"category":[{"scheme":"http://schemas.google.com/g/2005#kind","term":"http://gdata.youtube.com/schemas/2007#video"},{"scheme":"http://gdata.youtube.com/schemas/2007/categories.cat","term":"Howto","label":"Howto & Style"}],"title":{"$t":"Top Eleven Football Manager Token Coins Cash Hack Tool Cheat Engine 2013"},"content":{"type":"application/x-shockwave-flash","src":"https://www.youtube.com/v/BKHoqk8STbY?version=3&f=videos&app=youtube_gdata"},"link":[{"rel":"alternate","type":"text/html","href":"https://www.youtube.com/watch?v=BKHoqk8STbY&feature=youtube_gdata"},{"rel":"http://gdata.youtube.com/schemas/2007#video.responses","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/BKHoqk8STbY/responses?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#video.related","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/BKHoqk8STbY/related?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#mobile","type":"text/html","href":"https://m.youtube.com/details?v=BKHoqk8STbY"},{"rel":"http://gdata.youtube.com/schemas/2007#uploader","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/users/vt9JlENpbRdbpfvCbFDmSA?v=2"},{"rel":"self","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/BKHoqk8STbY?v=2"}],"author":[{"name":{"$t":"JoanM Miller"},"uri":{"$t":"https://gdata.youtube.com/feeds/api/users/vt9JlENpbRdbpfvCbFDmSA"},"yt$userId":{"$t":"vt9JlENpbRdbpfvCbFDmSA"}}],"yt$accessControl":[{"action":"comment","permission":"allowed"},{"action":"commentVote","permission":"allowed"},{"action":"videoRespond","permission":"moderated"},{"action":"rate","permission":"allowed"},{"action":"embed","permission":"allowed"},{"action":"list","permission":"allowed"},{"action":"autoPlay","permission":"allowed"},{"action":"syndicate","permission":"allowed"}],"gd$comments":{"gd$feedLink":{"rel":"http://gdata.youtube.com/schemas/2007#comments","href":"https://gdata.youtube.com/feeds/api/videos/BKHoqk8STbY/comments?v=2","countHint":0}},"media$group":{"media$category":[{"$t":"Howto","label":"Howto & Style","scheme":"http://gdata.youtube.com/schemas/2007/categories.cat"}],"media$content":[{"url":"https://www.youtube.com/v/BKHoqk8STbY?version=3&f=videos&app=youtube_gdata","type":"application/x-shockwave-flash","medium":"video","isDefault":"true","expression":"full","duration":116,"yt$format":5},{"url":"rtsp://v5.cache2.c.youtube.com/CiILENy73wIaGQm2TRJPquihBBMYDSANFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":116,"yt$format":1},{"url":"rtsp://v5.cache2.c.youtube.com/CiILENy73wIaGQm2TRJPquihBBMYESARFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":116,"yt$format":6}],"media$credit":[{"$t":"vt9JlENpbRdbpfvCbFDmSA","role":"uploader","scheme":"urn:youtube","yt$display":"JoanM Miller"}],"media$description":{"$t":"Download from mediafire Link : http://www.mediafire.com/?n09357g5gcz5z5t Scanned For Virus : http://Virustotal.com/ Scan it Yourself if You Can Feel As If It...","type":"plain"},"media$keywords":{},"media$license":{"$t":"youtube","type":"text/html","href":"http://www.youtube.com/t/terms"},"media$player":{"url":"https://www.youtube.com/watch?v=BKHoqk8STbY&feature=youtube_gdata_player"},"media$thumbnail":[{"url":"https://i.ytimg.com/vi/BKHoqk8STbY/default.jpg","height":90,"width":120,"time":"00:00:58","yt$name":"default"},{"url":"https://i.ytimg.com/vi/BKHoqk8STbY/mqdefault.jpg","height":180,"width":320,"yt$name":"mqdefault"},{"url":"https://i.ytimg.com/vi/BKHoqk8STbY/hqdefault.jpg","height":360,"width":480,"yt$name":"hqdefault"},{"url":"https://i.ytimg.com/vi/BKHoqk8STbY/1.jpg","height":90,"width":120,"time":"00:00:29","yt$name":"start"},{"url":"https://i.ytimg.com/vi/BKHoqk8STbY/2.jpg","height":90,"width":120,"time":"00:00:58","yt$name":"middle"},{"url":"https://i.ytimg.com/vi/BKHoqk8STbY/3.jpg","height":90,"width":120,"time":"00:01:27","yt$name":"end"}],"media$title":{"$t":"Top Eleven Football Manager Token Coins Cash Hack Tool Cheat Engine 2013","type":"plain"},"yt$duration":{"seconds":"116"},"yt$uploaded":{"$t":"2013-06-10T18:19:51.000Z"},"yt$uploaderId":{"$t":"UCvt9JlENpbRdbpfvCbFDmSA"},"yt$videoid":{"$t":"BKHoqk8STbY"}}},{"gd$etag":"WkMBR347eCp7I2A9WhFTGEU","id":{"$t":"tag:youtube.com,2008:video:SVl6MnsnInE"},"published":{"$t":"2013-06-10T18:18:03.000Z"},"updated":{"$t":"2013-06-10T18:20:56.000Z"},"category":[{"scheme":"http://schemas.google.com/g/2005#kind","term":"http://gdata.youtube.com/schemas/2007#video"},{"scheme":"http://gdata.youtube.com/schemas/2007/categories.cat","term":"Howto","label":"Howto & Style"}],"title":{"$t":"Top eleven football manager hack updated 2013"},"content":{"type":"application/x-shockwave-flash","src":"https://www.youtube.com/v/SVl6MnsnInE?version=3&f=videos&app=youtube_gdata"},"link":[{"rel":"alternate","type":"text/html","href":"https://www.youtube.com/watch?v=SVl6MnsnInE&feature=youtube_gdata"},{"rel":"http://gdata.youtube.com/schemas/2007#video.responses","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/SVl6MnsnInE/responses?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#video.related","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/SVl6MnsnInE/related?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#mobile","type":"text/html","href":"https://m.youtube.com/details?v=SVl6MnsnInE"},{"rel":"http://gdata.youtube.com/schemas/2007#uploader","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/users/vt9JlENpbRdbpfvCbFDmSA?v=2"},{"rel":"self","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/SVl6MnsnInE?v=2"}],"author":[{"name":{"$t":"JoanM Miller"},"uri":{"$t":"https://gdata.youtube.com/feeds/api/users/vt9JlENpbRdbpfvCbFDmSA"},"yt$userId":{"$t":"vt9JlENpbRdbpfvCbFDmSA"}}],"yt$accessControl":[{"action":"comment","permission":"allowed"},{"action":"commentVote","permission":"allowed"},{"action":"videoRespond","permission":"moderated"},{"action":"rate","permission":"allowed"},{"action":"embed","permission":"allowed"},{"action":"list","permission":"allowed"},{"action":"autoPlay","permission":"allowed"},{"action":"syndicate","permission":"allowed"}],"gd$comments":{"gd$feedLink":{"rel":"http://gdata.youtube.com/schemas/2007#comments","href":"https://gdata.youtube.com/feeds/api/videos/SVl6MnsnInE/comments?v=2","countHint":0}},"media$group":{"media$category":[{"$t":"Howto","label":"Howto & Style","scheme":"http://gdata.youtube.com/schemas/2007/categories.cat"}],"media$content":[{"url":"https://www.youtube.com/v/SVl6MnsnInE?version=3&f=videos&app=youtube_gdata","type":"application/x-shockwave-flash","medium":"video","isDefault":"true","expression":"full","duration":141,"yt$format":5},{"url":"rtsp://v4.cache6.c.youtube.com/CiILENy73wIaGQlxIid7MnpZSRMYDSANFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":141,"yt$format":1},{"url":"rtsp://v4.cache6.c.youtube.com/CiILENy73wIaGQlxIid7MnpZSRMYESARFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":141,"yt$format":6}],"media$credit":[{"$t":"vt9JlENpbRdbpfvCbFDmSA","role":"uploader","scheme":"urn:youtube","yt$display":"JoanM Miller"}],"media$description":{"$t":"Download from mediafire Link : http://www.mediafire.com/?n09357g5gcz5z5t Scanned For Virus : http://Virustotal.com/ Scan it Yourself if You Can Feel As If It...","type":"plain"},"media$keywords":{},"media$license":{"$t":"youtube","type":"text/html","href":"http://www.youtube.com/t/terms"},"media$player":{"url":"https://www.youtube.com/watch?v=SVl6MnsnInE&feature=youtube_gdata_player"},"media$thumbnail":[{"url":"https://i.ytimg.com/vi/SVl6MnsnInE/default.jpg","height":90,"width":120,"time":"00:01:10.500","yt$name":"default"},{"url":"https://i.ytimg.com/vi/SVl6MnsnInE/mqdefault.jpg","height":180,"width":320,"yt$name":"mqdefault"},{"url":"https://i.ytimg.com/vi/SVl6MnsnInE/hqdefault.jpg","height":360,"width":480,"yt$name":"hqdefault"},{"url":"https://i.ytimg.com/vi/SVl6MnsnInE/1.jpg","height":90,"width":120,"time":"00:00:35.250","yt$name":"start"},{"url":"https://i.ytimg.com/vi/SVl6MnsnInE/2.jpg","height":90,"width":120,"time":"00:01:10.500","yt$name":"middle"},{"url":"https://i.ytimg.com/vi/SVl6MnsnInE/3.jpg","height":90,"width":120,"time":"00:01:45.750","yt$name":"end"}],"media$title":{"$t":"Top eleven football manager hack updated 2013","type":"plain"},"yt$duration":{"seconds":"141"},"yt$uploaded":{"$t":"2013-06-10T18:18:03.000Z"},"yt$uploaderId":{"$t":"UCvt9JlENpbRdbpfvCbFDmSA"},"yt$videoid":{"$t":"SVl6MnsnInE"}}},{"gd$etag":"WkMGQn47eCp7I2A9WhFTGEU.","id":{"$t":"tag:youtube.com,2008:video:pwGBALJ27ps"},"published":{"$t":"2013-06-10T18:16:34.000Z"},"updated":{"$t":"2013-06-10T18:20:23.000Z"},"category":[{"scheme":"http://schemas.google.com/g/2005#kind","term":"http://gdata.youtube.com/schemas/2007#video"},{"scheme":"http://gdata.youtube.com/schemas/2007/categories.cat","term":"Howto","label":"Howto & Style"}],"title":{"$t":"Top Eleven Football Manager Hack Tokens Cheats 2013"},"content":{"type":"application/x-shockwave-flash","src":"https://www.youtube.com/v/pwGBALJ27ps?version=3&f=videos&app=youtube_gdata"},"link":[{"rel":"alternate","type":"text/html","href":"https://www.youtube.com/watch?v=pwGBALJ27ps&feature=youtube_gdata"},{"rel":"http://gdata.youtube.com/schemas/2007#video.responses","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/pwGBALJ27ps/responses?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#video.related","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/pwGBALJ27ps/related?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#mobile","type":"text/html","href":"https://m.youtube.com/details?v=pwGBALJ27ps"},{"rel":"http://gdata.youtube.com/schemas/2007#uploader","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/users/vt9JlENpbRdbpfvCbFDmSA?v=2"},{"rel":"self","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/pwGBALJ27ps?v=2"}],"author":[{"name":{"$t":"JoanM Miller"},"uri":{"$t":"https://gdata.youtube.com/feeds/api/users/vt9JlENpbRdbpfvCbFDmSA"},"yt$userId":{"$t":"vt9JlENpbRdbpfvCbFDmSA"}}],"yt$accessControl":[{"action":"comment","permission":"allowed"},{"action":"commentVote","permission":"allowed"},{"action":"videoRespond","permission":"moderated"},{"action":"rate","permission":"allowed"},{"action":"embed","permission":"allowed"},{"action":"list","permission":"allowed"},{"action":"autoPlay","permission":"allowed"},{"action":"syndicate","permission":"allowed"}],"gd$comments":{"gd$feedLink":{"rel":"http://gdata.youtube.com/schemas/2007#comments","href":"https://gdata.youtube.com/feeds/api/videos/pwGBALJ27ps/comments?v=2","countHint":0}},"media$group":{"media$category":[{"$t":"Howto","label":"Howto & Style","scheme":"http://gdata.youtube.com/schemas/2007/categories.cat"}],"media$content":[{"url":"https://www.youtube.com/v/pwGBALJ27ps?version=3&f=videos&app=youtube_gdata","type":"application/x-shockwave-flash","medium":"video","isDefault":"true","expression":"full","duration":112,"yt$format":5},{"url":"rtsp://v5.cache8.c.youtube.com/CiILENy73wIaGQmb7nayAIEBpxMYDSANFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":112,"yt$format":1},{"url":"rtsp://v5.cache8.c.youtube.com/CiILENy73wIaGQmb7nayAIEBpxMYESARFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":112,"yt$format":6}],"media$credit":[{"$t":"vt9JlENpbRdbpfvCbFDmSA","role":"uploader","scheme":"urn:youtube","yt$display":"JoanM Miller"}],"media$description":{"$t":"Download from mediafire Link : http://www.mediafire.com/?n09357g5gcz5z5t Scanned For Virus : http://Virustotal.com/ Scan it Yourself if You Can Feel As If It...","type":"plain"},"media$keywords":{},"media$license":{"$t":"youtube","type":"text/html","href":"http://www.youtube.com/t/terms"},"media$player":{"url":"https://www.youtube.com/watch?v=pwGBALJ27ps&feature=youtube_gdata_player"},"media$thumbnail":[{"url":"https://i.ytimg.com/vi/pwGBALJ27ps/default.jpg","height":90,"width":120,"time":"00:00:56","yt$name":"default"},{"url":"https://i.ytimg.com/vi/pwGBALJ27ps/mqdefault.jpg","height":180,"width":320,"yt$name":"mqdefault"},{"url":"https://i.ytimg.com/vi/pwGBALJ27ps/hqdefault.jpg","height":360,"width":480,"yt$name":"hqdefault"},{"url":"https://i.ytimg.com/vi/pwGBALJ27ps/1.jpg","height":90,"width":120,"time":"00:00:28","yt$name":"start"},{"url":"https://i.ytimg.com/vi/pwGBALJ27ps/2.jpg","height":90,"width":120,"time":"00:00:56","yt$name":"middle"},{"url":"https://i.ytimg.com/vi/pwGBALJ27ps/3.jpg","height":90,"width":120,"time":"00:01:24","yt$name":"end"}],"media$title":{"$t":"Top Eleven Football Manager Hack Tokens Cheats 2013","type":"plain"},"yt$duration":{"seconds":"112"},"yt$uploaded":{"$t":"2013-06-10T18:16:34.000Z"},"yt$uploaderId":{"$t":"UCvt9JlENpbRdbpfvCbFDmSA"},"yt$videoid":{"$t":"pwGBALJ27ps"}}},{"gd$etag":"WAkYHRH47eCp7I2A9WhFTGEU","id":{"$t":"tag:youtube.com,2008:video:OuupGw6bV4w"},"published":{"$t":"2013-06-10T18:15:27.000Z"},"updated":{"$t":"2013-06-10T18:15:35.000Z"},"category":[{"scheme":"http://schemas.google.com/g/2005#kind","term":"http://gdata.youtube.com/schemas/2007#video"},{"scheme":"http://gdata.youtube.com/schemas/2007/categories.cat","term":"People","label":"People & Blogs"}],"title":{"$t":"football 01"},"content":{"type":"application/x-shockwave-flash","src":"https://www.youtube.com/v/OuupGw6bV4w?version=3&f=videos&app=youtube_gdata"},"link":[{"rel":"alternate","type":"text/html","href":"https://www.youtube.com/watch?v=OuupGw6bV4w&feature=youtube_gdata"},{"rel":"http://gdata.youtube.com/schemas/2007#video.responses","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/OuupGw6bV4w/responses?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#video.related","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/OuupGw6bV4w/related?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#mobile","type":"text/html","href":"https://m.youtube.com/details?v=OuupGw6bV4w"},{"rel":"http://gdata.youtube.com/schemas/2007#uploader","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/users/-UJG-lgTK7IhPl8HBr-PUg?v=2"},{"rel":"self","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/OuupGw6bV4w?v=2"}],"author":[{"name":{"$t":"Théo VANNET"},"uri":{"$t":"https://gdata.youtube.com/feeds/api/users/-UJG-lgTK7IhPl8HBr-PUg"},"yt$userId":{"$t":"-UJG-lgTK7IhPl8HBr-PUg"}}],"yt$accessControl":[{"action":"comment","permission":"allowed"},{"action":"commentVote","permission":"allowed"},{"action":"videoRespond","permission":"moderated"},{"action":"rate","permission":"allowed"},{"action":"embed","permission":"allowed"},{"action":"list","permission":"allowed"},{"action":"autoPlay","permission":"allowed"},{"action":"syndicate","permission":"allowed"}],"gd$comments":{"gd$feedLink":{"rel":"http://gdata.youtube.com/schemas/2007#comments","href":"https://gdata.youtube.com/feeds/api/videos/OuupGw6bV4w/comments?v=2","countHint":0}},"media$group":{"media$category":[{"$t":"People","label":"People & Blogs","scheme":"http://gdata.youtube.com/schemas/2007/categories.cat"}],"media$content":[{"url":"https://www.youtube.com/v/OuupGw6bV4w?version=3&f=videos&app=youtube_gdata","type":"application/x-shockwave-flash","medium":"video","isDefault":"true","expression":"full","duration":36,"yt$format":5},{"url":"rtsp://v2.cache1.c.youtube.com/CiILENy73wIaGQmMV5sOG6nrOhMYDSANFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":36,"yt$format":1},{"url":"rtsp://v2.cache1.c.youtube.com/CiILENy73wIaGQmMV5sOG6nrOhMYESARFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":36,"yt$format":6}],"media$credit":[{"$t":"-UJG-lgTK7IhPl8HBr-PUg","role":"uploader","scheme":"urn:youtube","yt$display":"Théo VANNET"}],"media$description":{"$t":"foot.","type":"plain"},"media$keywords":{},"media$license":{"$t":"youtube","type":"text/html","href":"http://www.youtube.com/t/terms"},"media$player":{"url":"https://www.youtube.com/watch?v=OuupGw6bV4w&feature=youtube_gdata_player"},"media$thumbnail":[{"url":"https://i.ytimg.com/vi/OuupGw6bV4w/default.jpg","height":90,"width":120,"time":"00:00:18","yt$name":"default"},{"url":"https://i.ytimg.com/vi/OuupGw6bV4w/mqdefault.jpg","height":180,"width":320,"yt$name":"mqdefault"},{"url":"https://i.ytimg.com/vi/OuupGw6bV4w/hqdefault.jpg","height":360,"width":480,"yt$name":"hqdefault"},{"url":"https://i.ytimg.com/vi/OuupGw6bV4w/sddefault.jpg","height":480,"width":640,"yt$name":"sddefault"},{"url":"https://i.ytimg.com/vi/OuupGw6bV4w/1.jpg","height":90,"width":120,"time":"00:00:09","yt$name":"start"},{"url":"https://i.ytimg.com/vi/OuupGw6bV4w/2.jpg","height":90,"width":120,"time":"00:00:18","yt$name":"middle"},{"url":"https://i.ytimg.com/vi/OuupGw6bV4w/3.jpg","height":90,"width":120,"time":"00:00:27","yt$name":"end"}],"media$title":{"$t":"football 01","type":"plain"},"yt$duration":{"seconds":"36"},"yt$uploaded":{"$t":"2013-06-10T18:15:27.000Z"},"yt$uploaderId":{"$t":"UC-UJG-lgTK7IhPl8HBr-PUg"},"yt$videoid":{"$t":"OuupGw6bV4w"}}},{"gd$etag":"WAkcMRn47eCp7I2A9WhFTGEU","id":{"$t":"tag:youtube.com,2008:video:_HplSAHF4d4"},"published":{"$t":"2013-06-10T18:13:44.000Z"},"updated":{"$t":"2013-06-10T18:14:47.000Z"},"category":[{"scheme":"http://schemas.google.com/g/2005#kind","term":"http://gdata.youtube.com/schemas/2007#video"},{"scheme":"http://gdata.youtube.com/schemas/2007/categories.cat","term":"Howto","label":"Howto & Style"}],"title":{"$t":"Top eleven football manager hack token cash free + Tokens    Instructions"},"content":{"type":"application/x-shockwave-flash","src":"https://www.youtube.com/v/_HplSAHF4d4?version=3&f=videos&app=youtube_gdata"},"link":[{"rel":"alternate","type":"text/html","href":"https://www.youtube.com/watch?v=_HplSAHF4d4&feature=youtube_gdata"},{"rel":"http://gdata.youtube.com/schemas/2007#video.responses","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/_HplSAHF4d4/responses?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#video.related","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/_HplSAHF4d4/related?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#mobile","type":"text/html","href":"https://m.youtube.com/details?v=_HplSAHF4d4"},{"rel":"http://gdata.youtube.com/schemas/2007#uploader","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/users/vt9JlENpbRdbpfvCbFDmSA?v=2"},{"rel":"self","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/_HplSAHF4d4?v=2"}],"author":[{"name":{"$t":"JoanM Miller"},"uri":{"$t":"https://gdata.youtube.com/feeds/api/users/vt9JlENpbRdbpfvCbFDmSA"},"yt$userId":{"$t":"vt9JlENpbRdbpfvCbFDmSA"}}],"yt$accessControl":[{"action":"comment","permission":"allowed"},{"action":"commentVote","permission":"allowed"},{"action":"videoRespond","permission":"moderated"},{"action":"rate","permission":"allowed"},{"action":"embed","permission":"allowed"},{"action":"list","permission":"allowed"},{"action":"autoPlay","permission":"allowed"},{"action":"syndicate","permission":"allowed"}],"gd$comments":{"gd$feedLink":{"rel":"http://gdata.youtube.com/schemas/2007#comments","href":"https://gdata.youtube.com/feeds/api/videos/_HplSAHF4d4/comments?v=2","countHint":0}},"media$group":{"media$category":[{"$t":"Howto","label":"Howto & Style","scheme":"http://gdata.youtube.com/schemas/2007/categories.cat"}],"media$content":[{"url":"https://www.youtube.com/v/_HplSAHF4d4?version=3&f=videos&app=youtube_gdata","type":"application/x-shockwave-flash","medium":"video","isDefault":"true","expression":"full","duration":105,"yt$format":5},{"url":"rtsp://v5.cache6.c.youtube.com/CiILENy73wIaGQne4cUBSGV6_BMYDSANFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":105,"yt$format":1},{"url":"rtsp://v5.cache6.c.youtube.com/CiILENy73wIaGQne4cUBSGV6_BMYESARFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":105,"yt$format":6}],"media$credit":[{"$t":"vt9JlENpbRdbpfvCbFDmSA","role":"uploader","scheme":"urn:youtube","yt$display":"JoanM Miller"}],"media$description":{"$t":"Download from mediafire Link : http://www.mediafire.com/?n09357g5gcz5z5t Scanned For Virus : http://Virustotal.com/ Scan it Yourself if You Can Feel As If It...","type":"plain"},"media$keywords":{},"media$license":{"$t":"youtube","type":"text/html","href":"http://www.youtube.com/t/terms"},"media$player":{"url":"https://www.youtube.com/watch?v=_HplSAHF4d4&feature=youtube_gdata_player"},"media$thumbnail":[{"url":"https://i.ytimg.com/vi/_HplSAHF4d4/default.jpg","height":90,"width":120,"time":"00:00:52.500","yt$name":"default"},{"url":"https://i.ytimg.com/vi/_HplSAHF4d4/mqdefault.jpg","height":180,"width":320,"yt$name":"mqdefault"},{"url":"https://i.ytimg.com/vi/_HplSAHF4d4/hqdefault.jpg","height":360,"width":480,"yt$name":"hqdefault"},{"url":"https://i.ytimg.com/vi/_HplSAHF4d4/1.jpg","height":90,"width":120,"time":"00:00:26.250","yt$name":"start"},{"url":"https://i.ytimg.com/vi/_HplSAHF4d4/2.jpg","height":90,"width":120,"time":"00:00:52.500","yt$name":"middle"},{"url":"https://i.ytimg.com/vi/_HplSAHF4d4/3.jpg","height":90,"width":120,"time":"00:01:18.750","yt$name":"end"}],"media$title":{"$t":"Top eleven football manager hack token cash free + Tokens    Instructions","type":"plain"},"yt$aspectRatio":{"$t":"widescreen"},"yt$duration":{"seconds":"105"},"yt$uploaded":{"$t":"2013-06-10T18:13:44.000Z"},"yt$uploaderId":{"$t":"UCvt9JlENpbRdbpfvCbFDmSA"},"yt$videoid":{"$t":"_HplSAHF4d4"}}},{"gd$etag":"AkcNQ347eCp7I2A9WhFTGEU","id":{"$t":"tag:youtube.com,2008:video:xnLbauy8Bjc"},"published":{"$t":"2013-06-10T18:14:22.000Z"},"updated":{"$t":"2013-06-10T18:14:52.000Z"},"category":[{"scheme":"http://schemas.google.com/g/2005#kind","term":"http://gdata.youtube.com/schemas/2007#video"},{"scheme":"http://gdata.youtube.com/schemas/2007/categories.cat","term":"Howto","label":"Howto & Style"}],"title":{"$t":"Top eleven football manager hack token free download Generator Updated March, 2013]"},"content":{"type":"application/x-shockwave-flash","src":"https://www.youtube.com/v/xnLbauy8Bjc?version=3&f=videos&app=youtube_gdata"},"link":[{"rel":"alternate","type":"text/html","href":"https://www.youtube.com/watch?v=xnLbauy8Bjc&feature=youtube_gdata"},{"rel":"http://gdata.youtube.com/schemas/2007#video.responses","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/xnLbauy8Bjc/responses?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#video.related","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/xnLbauy8Bjc/related?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#mobile","type":"text/html","href":"https://m.youtube.com/details?v=xnLbauy8Bjc"},{"rel":"http://gdata.youtube.com/schemas/2007#uploader","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/users/vt9JlENpbRdbpfvCbFDmSA?v=2"},{"rel":"self","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/xnLbauy8Bjc?v=2"}],"author":[{"name":{"$t":"JoanM Miller"},"uri":{"$t":"https://gdata.youtube.com/feeds/api/users/vt9JlENpbRdbpfvCbFDmSA"},"yt$userId":{"$t":"vt9JlENpbRdbpfvCbFDmSA"}}],"yt$accessControl":[{"action":"comment","permission":"allowed"},{"action":"commentVote","permission":"allowed"},{"action":"videoRespond","permission":"moderated"},{"action":"rate","permission":"allowed"},{"action":"embed","permission":"allowed"},{"action":"list","permission":"allowed"},{"action":"autoPlay","permission":"allowed"},{"action":"syndicate","permission":"allowed"}],"gd$comments":{"gd$feedLink":{"rel":"http://gdata.youtube.com/schemas/2007#comments","href":"https://gdata.youtube.com/feeds/api/videos/xnLbauy8Bjc/comments?v=2","countHint":0}},"media$group":{"media$category":[{"$t":"Howto","label":"Howto & Style","scheme":"http://gdata.youtube.com/schemas/2007/categories.cat"}],"media$content":[{"url":"https://www.youtube.com/v/xnLbauy8Bjc?version=3&f=videos&app=youtube_gdata","type":"application/x-shockwave-flash","medium":"video","isDefault":"true","expression":"full","duration":39,"yt$format":5},{"url":"rtsp://v4.cache8.c.youtube.com/CiILENy73wIaGQk3BrzsattyxhMYDSANFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":39,"yt$format":1},{"url":"rtsp://v4.cache8.c.youtube.com/CiILENy73wIaGQk3BrzsattyxhMYESARFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":39,"yt$format":6}],"media$credit":[{"$t":"vt9JlENpbRdbpfvCbFDmSA","role":"uploader","scheme":"urn:youtube","yt$display":"JoanM Miller"}],"media$description":{"$t":"Download from mediafire Link : http://www.mediafire.com/?n09357g5gcz5z5t Scanned For Virus : http://Virustotal.com/ Scan it Yourself if You Can Feel As If It...","type":"plain"},"media$keywords":{},"media$license":{"$t":"youtube","type":"text/html","href":"http://www.youtube.com/t/terms"},"media$player":{"url":"https://www.youtube.com/watch?v=xnLbauy8Bjc&feature=youtube_gdata_player"},"media$thumbnail":[{"url":"https://i.ytimg.com/vi/xnLbauy8Bjc/default.jpg","height":90,"width":120,"time":"00:00:19.500","yt$name":"default"},{"url":"https://i.ytimg.com/vi/xnLbauy8Bjc/mqdefault.jpg","height":180,"width":320,"yt$name":"mqdefault"},{"url":"https://i.ytimg.com/vi/xnLbauy8Bjc/hqdefault.jpg","height":360,"width":480,"yt$name":"hqdefault"},{"url":"https://i.ytimg.com/vi/xnLbauy8Bjc/sddefault.jpg","height":480,"width":640,"yt$name":"sddefault"},{"url":"https://i.ytimg.com/vi/xnLbauy8Bjc/1.jpg","height":90,"width":120,"time":"00:00:09.750","yt$name":"start"},{"url":"https://i.ytimg.com/vi/xnLbauy8Bjc/2.jpg","height":90,"width":120,"time":"00:00:19.500","yt$name":"middle"},{"url":"https://i.ytimg.com/vi/xnLbauy8Bjc/3.jpg","height":90,"width":120,"time":"00:00:29.250","yt$name":"end"}],"media$title":{"$t":"Top eleven football manager hack token free download Generator Updated March, 2013]","type":"plain"},"yt$aspectRatio":{"$t":"widescreen"},"yt$duration":{"seconds":"39"},"yt$uploaded":{"$t":"2013-06-10T18:14:22.000Z"},"yt$uploaderId":{"$t":"UCvt9JlENpbRdbpfvCbFDmSA"},"yt$videoid":{"$t":"xnLbauy8Bjc"}}},{"gd$etag":"WA0MMSX47eCp7I2A9WhFTGEU","id":{"$t":"tag:youtube.com,2008:video:n16MYuKvJSY"},"published":{"$t":"2013-06-10T18:09:49.000Z"},"updated":{"$t":"2013-06-10T18:38:08.000Z"},"category":[{"scheme":"http://schemas.google.com/g/2005#kind","term":"http://gdata.youtube.com/schemas/2007#video"},{"scheme":"http://gdata.youtube.com/schemas/2007/categories.cat","term":"Howto","label":"Howto & Style"}],"title":{"$t":"Top Eleven Football Manager Hack"},"content":{"type":"application/x-shockwave-flash","src":"https://www.youtube.com/v/n16MYuKvJSY?version=3&f=videos&app=youtube_gdata"},"link":[{"rel":"alternate","type":"text/html","href":"https://www.youtube.com/watch?v=n16MYuKvJSY&feature=youtube_gdata"},{"rel":"http://gdata.youtube.com/schemas/2007#video.responses","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/n16MYuKvJSY/responses?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#video.related","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/n16MYuKvJSY/related?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#mobile","type":"text/html","href":"https://m.youtube.com/details?v=n16MYuKvJSY"},{"rel":"http://gdata.youtube.com/schemas/2007#uploader","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/users/vt9JlENpbRdbpfvCbFDmSA?v=2"},{"rel":"self","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/n16MYuKvJSY?v=2"}],"author":[{"name":{"$t":"JoanM Miller"},"uri":{"$t":"https://gdata.youtube.com/feeds/api/users/vt9JlENpbRdbpfvCbFDmSA"},"yt$userId":{"$t":"vt9JlENpbRdbpfvCbFDmSA"}}],"yt$accessControl":[{"action":"comment","permission":"allowed"},{"action":"commentVote","permission":"allowed"},{"action":"videoRespond","permission":"moderated"},{"action":"rate","permission":"allowed"},{"action":"embed","permission":"allowed"},{"action":"list","permission":"allowed"},{"action":"autoPlay","permission":"allowed"},{"action":"syndicate","permission":"allowed"}],"gd$comments":{"gd$feedLink":{"rel":"http://gdata.youtube.com/schemas/2007#comments","href":"https://gdata.youtube.com/feeds/api/videos/n16MYuKvJSY/comments?v=2","countHint":0}},"media$group":{"media$category":[{"$t":"Howto","label":"Howto & Style","scheme":"http://gdata.youtube.com/schemas/2007/categories.cat"}],"media$content":[{"url":"https://www.youtube.com/v/n16MYuKvJSY?version=3&f=videos&app=youtube_gdata","type":"application/x-shockwave-flash","medium":"video","isDefault":"true","expression":"full","duration":49,"yt$format":5},{"url":"rtsp://v5.cache8.c.youtube.com/CiILENy73wIaGQkmJa_iYoxenxMYDSANFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":49,"yt$format":1},{"url":"rtsp://v5.cache8.c.youtube.com/CiILENy73wIaGQkmJa_iYoxenxMYESARFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":49,"yt$format":6}],"media$credit":[{"$t":"vt9JlENpbRdbpfvCbFDmSA","role":"uploader","scheme":"urn:youtube","yt$display":"JoanM Miller","yt$type":"partner"}],"media$description":{"$t":"Download from mediafire Link : http://www.mediafire.com/?n09357g5gcz5z5t Scanned For Virus : http://Virustotal.com/ Scan it Yourself if You Can Feel As If It...","type":"plain"},"media$keywords":{},"media$license":{"$t":"youtube","type":"text/html","href":"http://www.youtube.com/t/terms"},"media$player":{"url":"https://www.youtube.com/watch?v=n16MYuKvJSY&feature=youtube_gdata_player"},"media$thumbnail":[{"url":"https://i.ytimg.com/vi/n16MYuKvJSY/default.jpg","height":90,"width":120,"time":"00:00:24.500","yt$name":"default"},{"url":"https://i.ytimg.com/vi/n16MYuKvJSY/mqdefault.jpg","height":180,"width":320,"yt$name":"mqdefault"},{"url":"https://i.ytimg.com/vi/n16MYuKvJSY/hqdefault.jpg","height":360,"width":480,"yt$name":"hqdefault"},{"url":"https://i.ytimg.com/vi/n16MYuKvJSY/sddefault.jpg","height":480,"width":640,"yt$name":"sddefault"},{"url":"https://i.ytimg.com/vi/n16MYuKvJSY/1.jpg","height":90,"width":120,"time":"00:00:12.250","yt$name":"start"},{"url":"https://i.ytimg.com/vi/n16MYuKvJSY/2.jpg","height":90,"width":120,"time":"00:00:24.500","yt$name":"middle"},{"url":"https://i.ytimg.com/vi/n16MYuKvJSY/3.jpg","height":90,"width":120,"time":"00:00:36.750","yt$name":"end"}],"media$title":{"$t":"Top Eleven Football Manager Hack","type":"plain"},"yt$aspectRatio":{"$t":"widescreen"},"yt$duration":{"seconds":"49"},"yt$uploaded":{"$t":"2013-06-10T18:09:49.000Z"},"yt$uploaderId":{"$t":"UCvt9JlENpbRdbpfvCbFDmSA"},"yt$videoid":{"$t":"n16MYuKvJSY"}}},{"gd$etag":"WAkcMQ347eCp7I2A9WhFTGEU","id":{"$t":"tag:youtube.com,2008:video:KBCHBUOfa0s"},"published":{"$t":"2013-06-10T18:10:46.000Z"},"updated":{"$t":"2013-06-10T18:14:42.000Z"},"category":[{"scheme":"http://schemas.google.com/g/2005#kind","term":"http://gdata.youtube.com/schemas/2007#video"},{"scheme":"http://gdata.youtube.com/schemas/2007/categories.cat","term":"Howto","label":"Howto & Style"}],"title":{"$t":"Top Eleven Football Manager Hack Free Download 2013 Updated"},"content":{"type":"application/x-shockwave-flash","src":"https://www.youtube.com/v/KBCHBUOfa0s?version=3&f=videos&app=youtube_gdata"},"link":[{"rel":"alternate","type":"text/html","href":"https://www.youtube.com/watch?v=KBCHBUOfa0s&feature=youtube_gdata"},{"rel":"http://gdata.youtube.com/schemas/2007#video.responses","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/KBCHBUOfa0s/responses?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#video.related","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/KBCHBUOfa0s/related?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#mobile","type":"text/html","href":"https://m.youtube.com/details?v=KBCHBUOfa0s"},{"rel":"http://gdata.youtube.com/schemas/2007#uploader","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/users/vt9JlENpbRdbpfvCbFDmSA?v=2"},{"rel":"self","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/KBCHBUOfa0s?v=2"}],"author":[{"name":{"$t":"JoanM Miller"},"uri":{"$t":"https://gdata.youtube.com/feeds/api/users/vt9JlENpbRdbpfvCbFDmSA"},"yt$userId":{"$t":"vt9JlENpbRdbpfvCbFDmSA"}}],"yt$accessControl":[{"action":"comment","permission":"allowed"},{"action":"commentVote","permission":"allowed"},{"action":"videoRespond","permission":"moderated"},{"action":"rate","permission":"allowed"},{"action":"embed","permission":"allowed"},{"action":"list","permission":"allowed"},{"action":"autoPlay","permission":"allowed"},{"action":"syndicate","permission":"allowed"}],"gd$comments":{"gd$feedLink":{"rel":"http://gdata.youtube.com/schemas/2007#comments","href":"https://gdata.youtube.com/feeds/api/videos/KBCHBUOfa0s/comments?v=2","countHint":0}},"media$group":{"media$category":[{"$t":"Howto","label":"Howto & Style","scheme":"http://gdata.youtube.com/schemas/2007/categories.cat"}],"media$content":[{"url":"https://www.youtube.com/v/KBCHBUOfa0s?version=3&f=videos&app=youtube_gdata","type":"application/x-shockwave-flash","medium":"video","isDefault":"true","expression":"full","duration":26,"yt$format":5},{"url":"rtsp://v5.cache5.c.youtube.com/CiILENy73wIaGQlLa59DBYcQKBMYDSANFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":26,"yt$format":1},{"url":"rtsp://v5.cache5.c.youtube.com/CiILENy73wIaGQlLa59DBYcQKBMYESARFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":26,"yt$format":6}],"media$credit":[{"$t":"vt9JlENpbRdbpfvCbFDmSA","role":"uploader","scheme":"urn:youtube","yt$display":"JoanM Miller"}],"media$description":{"$t":"Download from mediafire Link : http://www.mediafire.com/?n09357g5gcz5z5t Scanned For Virus : http://Virustotal.com/ Scan it Yourself if You Can Feel As If It...","type":"plain"},"media$keywords":{},"media$license":{"$t":"youtube","type":"text/html","href":"http://www.youtube.com/t/terms"},"media$player":{"url":"https://www.youtube.com/watch?v=KBCHBUOfa0s&feature=youtube_gdata_player"},"media$thumbnail":[{"url":"https://i.ytimg.com/vi/KBCHBUOfa0s/default.jpg","height":90,"width":120,"time":"00:00:13","yt$name":"default"},{"url":"https://i.ytimg.com/vi/KBCHBUOfa0s/mqdefault.jpg","height":180,"width":320,"yt$name":"mqdefault"},{"url":"https://i.ytimg.com/vi/KBCHBUOfa0s/hqdefault.jpg","height":360,"width":480,"yt$name":"hqdefault"},{"url":"https://i.ytimg.com/vi/KBCHBUOfa0s/sddefault.jpg","height":480,"width":640,"yt$name":"sddefault"},{"url":"https://i.ytimg.com/vi/KBCHBUOfa0s/1.jpg","height":90,"width":120,"time":"00:00:06.500","yt$name":"start"},{"url":"https://i.ytimg.com/vi/KBCHBUOfa0s/2.jpg","height":90,"width":120,"time":"00:00:13","yt$name":"middle"},{"url":"https://i.ytimg.com/vi/KBCHBUOfa0s/3.jpg","height":90,"width":120,"time":"00:00:19.500","yt$name":"end"}],"media$title":{"$t":"Top Eleven Football Manager Hack Free Download 2013 Updated","type":"plain"},"yt$aspectRatio":{"$t":"widescreen"},"yt$duration":{"seconds":"26"},"yt$uploaded":{"$t":"2013-06-10T18:10:46.000Z"},"yt$uploaderId":{"$t":"UCvt9JlENpbRdbpfvCbFDmSA"},"yt$videoid":{"$t":"KBCHBUOfa0s"}}}]}}');
    var user = JSON.parse('{"apiVersion":"2.1","data":{"updated":"2013-06-12T15:04:37.437Z","totalItems":8,"startIndex":1,"itemsPerPage":25,"items":[{"id":"o95tuRUO_P4","uploaded":"2013-03-18T11:31:18.000Z","updated":"2013-03-18T17:17:20.000Z","uploader":"themapofmedicine","category":"Tech","title":"Map of Medicine - supporting the clinical workflow","description":"Map of Medicine supports the optimisation of patient care by providing comprehensive, evidence-based local guidance and clinical decision support at the point of care.Map of Medicine is used by health economies across the country to support consistent use of care pathways and to effectively manage referral activity.","thumbnail":{"sqDefault":"http://i4.ytimg.com/vi/o95tuRUO_P4/default.jpg","hqDefault":"http://i4.ytimg.com/vi/o95tuRUO_P4/hqdefault.jpg"},"player":{"default":"http://www.youtube.com/watch?v=o95tuRUO_P4&feature=youtube_gdata_player","mobile":"http://m.youtube.com/details?v=o95tuRUO_P4"},"content":{"1":"rtsp://v7.cache1.c.youtube.com/CigLENy73wIaHwn-_A4VuW3eoxMYDSANFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp","5":"http://www.youtube.com/v/o95tuRUO_P4?version=3&f=user_uploads&app=youtube_gdata","6":"rtsp://v7.cache1.c.youtube.com/CigLENy73wIaHwn-_A4VuW3eoxMYESARFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp"},"duration":168,"aspectRatio":"widescreen","viewCount":994,"favoriteCount":0,"commentCount":0,"accessControl":{"comment":"allowed","commentVote":"allowed","videoRespond":"moderated","rate":"allowed","embed":"allowed","list":"allowed","autoPlay":"allowed","syndicate":"allowed"}},{"id":"-DHMwMrYTC4","uploaded":"2012-08-21T11:02:39.000Z","updated":"2012-08-21T11:03:21.000Z","uploader":"themapofmedicine","category":"Tech","title":"Managing Local Admin Info in the Map of Medicine","description":"Understand how to use the local admin functionality on Map of Medicine.","thumbnail":{"sqDefault":"http://i2.ytimg.com/vi/-DHMwMrYTC4/default.jpg","hqDefault":"http://i2.ytimg.com/vi/-DHMwMrYTC4/hqdefault.jpg"},"player":{"default":"http://www.youtube.com/watch?v=-DHMwMrYTC4&feature=youtube_gdata_player","mobile":"http://m.youtube.com/details?v=-DHMwMrYTC4"},"content":{"1":"rtsp://v6.cache2.c.youtube.com/CigLENy73wIaHwkuTNjKwMwx-BMYDSANFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp","5":"http://www.youtube.com/v/-DHMwMrYTC4?version=3&f=user_uploads&app=youtube_gdata","6":"rtsp://v6.cache2.c.youtube.com/CigLENy73wIaHwkuTNjKwMwx-BMYESARFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp"},"duration":163,"aspectRatio":"widescreen","viewCount":41,"favoriteCount":0,"commentCount":0,"accessControl":{"comment":"allowed","commentVote":"allowed","videoRespond":"moderated","rate":"allowed","embed":"allowed","list":"allowed","autoPlay":"allowed","syndicate":"allowed"}},{"id":"jXtsaoLP-nQ","uploaded":"2012-08-21T11:02:39.000Z","updated":"2013-03-18T17:17:44.000Z","uploader":"themapofmedicine","category":"Tech","title":"Managing Feedback in the Map of Medicine","description":"Users can now send feedback about clinical pathways or more general issues via the new Feedback button displayed on every page on the Map of Medicine.","thumbnail":{"sqDefault":"http://i3.ytimg.com/vi/jXtsaoLP-nQ/default.jpg","hqDefault":"http://i3.ytimg.com/vi/jXtsaoLP-nQ/hqdefault.jpg"},"player":{"default":"http://www.youtube.com/watch?v=jXtsaoLP-nQ&feature=youtube_gdata_player","mobile":"http://m.youtube.com/details?v=jXtsaoLP-nQ"},"content":{"1":"rtsp://v1.cache4.c.youtube.com/CigLENy73wIaHwl0-s-Camx7jRMYDSANFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp","5":"http://www.youtube.com/v/jXtsaoLP-nQ?version=3&f=user_uploads&app=youtube_gdata","6":"rtsp://v1.cache4.c.youtube.com/CigLENy73wIaHwl0-s-Camx7jRMYESARFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp"},"duration":159,"aspectRatio":"widescreen","viewCount":53,"favoriteCount":0,"commentCount":0,"accessControl":{"comment":"allowed","commentVote":"allowed","videoRespond":"moderated","rate":"allowed","embed":"allowed","list":"allowed","autoPlay":"allowed","syndicate":"allowed"}},{"id":"sfbpNsNjroA","uploaded":"2012-08-21T10:43:04.000Z","updated":"2012-08-21T11:01:59.000Z","uploader":"themapofmedicine","category":"Tech","title":"Introducing the Map of Medicine sidebar","description":"Introducing a new feature to allow access to the Map of Medicine within the clinical workflow","thumbnail":{"sqDefault":"http://i4.ytimg.com/vi/sfbpNsNjroA/default.jpg","hqDefault":"http://i4.ytimg.com/vi/sfbpNsNjroA/hqdefault.jpg"},"player":{"default":"http://www.youtube.com/watch?v=sfbpNsNjroA&feature=youtube_gdata_player","mobile":"http://m.youtube.com/details?v=sfbpNsNjroA"},"content":{"1":"rtsp://v8.cache8.c.youtube.com/CigLENy73wIaHwmArmPDNun2sRMYDSANFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp","5":"http://www.youtube.com/v/sfbpNsNjroA?version=3&f=user_uploads&app=youtube_gdata","6":"rtsp://v8.cache8.c.youtube.com/CigLENy73wIaHwmArmPDNun2sRMYESARFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp"},"duration":159,"aspectRatio":"widescreen","viewCount":278,"favoriteCount":0,"commentCount":0,"accessControl":{"comment":"allowed","commentVote":"allowed","videoRespond":"moderated","rate":"allowed","embed":"allowed","list":"allowed","autoPlay":"allowed","syndicate":"allowed"}},{"id":"-ztLrlCxkUA","uploaded":"2012-08-15T17:40:12.000Z","updated":"2012-08-21T11:02:39.000Z","uploader":"themapofmedicine","category":"Tech","title":"Managing Announcements in the Map of Medicine","description":"The new Announcements feature is designed to help you to raise awareness of new and updated care pathways amongst your local users. You can also use this as an additional communications tool to reach local clinicans.","thumbnail":{"sqDefault":"http://i2.ytimg.com/vi/-ztLrlCxkUA/default.jpg","hqDefault":"http://i2.ytimg.com/vi/-ztLrlCxkUA/hqdefault.jpg"},"player":{"default":"http://www.youtube.com/watch?v=-ztLrlCxkUA&feature=youtube_gdata_player","mobile":"http://m.youtube.com/details?v=-ztLrlCxkUA"},"content":{"1":"rtsp://v2.cache2.c.youtube.com/CigLENy73wIaHwlAkbFQrks7-xMYDSANFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp","5":"http://www.youtube.com/v/-ztLrlCxkUA?version=3&f=user_uploads&app=youtube_gdata","6":"rtsp://v2.cache2.c.youtube.com/CigLENy73wIaHwlAkbFQrks7-xMYESARFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp"},"duration":110,"aspectRatio":"widescreen","viewCount":34,"favoriteCount":0,"commentCount":0,"accessControl":{"comment":"allowed","commentVote":"allowed","videoRespond":"moderated","rate":"allowed","embed":"allowed","list":"allowed","autoPlay":"allowed","syndicate":"allowed"}},{"id":"uCiOPthBJaY","uploaded":"2012-07-12T08:36:28.000Z","updated":"2012-08-21T11:02:39.000Z","uploader":"themapofmedicine","category":"Tech","title":"Map of Medicine   Using the Map of Medicine","description":"This is a guide to some of the new features on the Map of Medicine.","thumbnail":{"sqDefault":"http://i2.ytimg.com/vi/uCiOPthBJaY/default.jpg","hqDefault":"http://i2.ytimg.com/vi/uCiOPthBJaY/hqdefault.jpg"},"player":{"default":"http://www.youtube.com/watch?v=uCiOPthBJaY&feature=youtube_gdata_player","mobile":"http://m.youtube.com/details?v=uCiOPthBJaY"},"content":{"1":"rtsp://v2.cache1.c.youtube.com/CigLENy73wIaHwmmJUHYPo4ouBMYDSANFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp","5":"http://www.youtube.com/v/uCiOPthBJaY?version=3&f=user_uploads&app=youtube_gdata","6":"rtsp://v2.cache1.c.youtube.com/CigLENy73wIaHwmmJUHYPo4ouBMYESARFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp"},"duration":218,"aspectRatio":"widescreen","viewCount":2247,"favoriteCount":0,"accessControl":{"comment":"denied","commentVote":"denied","videoRespond":"denied","rate":"denied","embed":"allowed","list":"allowed","autoPlay":"allowed","syndicate":"allowed"}},{"id":"Ywy-J-EiBN8","uploaded":"2012-07-12T08:34:29.000Z","updated":"2012-08-21T11:02:39.000Z","uploader":"themapofmedicine","category":"Tech","title":"Map of Medicine - Accessing the Map of Medicine","description":"This short video demonstrates the different ways you can access the Map of Medicine, dependent on your location within the NHS in England.","thumbnail":{"sqDefault":"http://i2.ytimg.com/vi/Ywy-J-EiBN8/default.jpg","hqDefault":"http://i2.ytimg.com/vi/Ywy-J-EiBN8/hqdefault.jpg"},"player":{"default":"http://www.youtube.com/watch?v=Ywy-J-EiBN8&feature=youtube_gdata_player","mobile":"http://m.youtube.com/details?v=Ywy-J-EiBN8"},"content":{"1":"rtsp://v1.cache1.c.youtube.com/CigLENy73wIaHwnfBCLhJ74MYxMYDSANFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp","5":"http://www.youtube.com/v/Ywy-J-EiBN8?version=3&f=user_uploads&app=youtube_gdata","6":"rtsp://v1.cache1.c.youtube.com/CigLENy73wIaHwnfBCLhJ74MYxMYESARFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp"},"duration":108,"aspectRatio":"widescreen","viewCount":473,"favoriteCount":0,"accessControl":{"comment":"denied","commentVote":"denied","videoRespond":"denied","rate":"denied","embed":"allowed","list":"allowed","autoPlay":"allowed","syndicate":"allowed"}},{"id":"q8m0hAXBRDA","uploaded":"2011-04-07T07:16:22.000Z","updated":"2013-06-08T15:04:57.000Z","uploader":"themapofmedicine","category":"Tech","title":"Introducing the Map of Medicine","description":"Introducing the Map of Medicine and how healthcare communities can use it to improve quality and productivity. Visit www.mapofmedicine.com","thumbnail":{"sqDefault":"http://i2.ytimg.com/vi/q8m0hAXBRDA/default.jpg","hqDefault":"http://i2.ytimg.com/vi/q8m0hAXBRDA/hqdefault.jpg"},"player":{"default":"http://www.youtube.com/watch?v=q8m0hAXBRDA&feature=youtube_gdata_player","mobile":"http://m.youtube.com/details?v=q8m0hAXBRDA"},"content":{"1":"rtsp://v2.cache3.c.youtube.com/CigLENy73wIaHwkwRMEFhLTJqxMYDSANFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp","5":"http://www.youtube.com/v/q8m0hAXBRDA?version=3&f=user_uploads&app=youtube_gdata","6":"rtsp://v2.cache3.c.youtube.com/CigLENy73wIaHwkwRMEFhLTJqxMYESARFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp"},"duration":195,"aspectRatio":"widescreen","rating":5,"likeCount":"6","ratingCount":6,"viewCount":9253,"favoriteCount":0,"commentCount":0,"accessControl":{"comment":"allowed","commentVote":"allowed","videoRespond":"moderated","rate":"allowed","embed":"allowed","list":"allowed","autoPlay":"allowed","syndicate":"allowed"}}]}}');

    ok( jQuery().youtubeVideoGallery().test.getVideosFromFeed( '' ).length === 0, "Passed" );
    ok( jQuery().youtubeVideoGallery().test.getVideosFromFeed( feed ).length === 10, "Passed" );
    ok( jQuery().youtubeVideoGallery().test.getVideosFromFeed( user ).length === 8, "Passed" );
});


test( "Get if from different API formats ", function() {
    var user = {"id":"o95tuRUO_P4","uploaded":"2013-03-18T11:31:18.000Z","updated":"2013-03-18T17:17:20.000Z","uploader":"themapofmedicine","category":"Tech","title":"Map of Medicine - supporting the clinical workflow","description":"Map of Medicine supports the optimisation of patient care by providing comprehensive, evidence-based local guidance and clinical decision support at the point of care.\nMap of Medicine is used by health economies across the country to support consistent use of care pathways and to effectively manage referral activity.","thumbnail":{"sqDefault":"http://i4.ytimg.com/vi/o95tuRUO_P4/default.jpg","hqDefault":"http://i4.ytimg.com/vi/o95tuRUO_P4/hqdefault.jpg"},"player":{"default":"http://www.youtube.com/watch?v=o95tuRUO_P4&feature=youtube_gdata_player","mobile":"http://m.youtube.com/details?v=o95tuRUO_P4"},"content":{"1":"rtsp://v7.cache1.c.youtube.com/CigLENy73wIaHwn-_A4VuW3eoxMYDSANFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp","5":"http://www.youtube.com/v/o95tuRUO_P4?version=3&f=user_uploads&app=youtube_gdata","6":"rtsp://v7.cache1.c.youtube.com/CigLENy73wIaHwn-_A4VuW3eoxMYESARFEgGUgx1c2VyX3VwbG9hZHMM/0/0/0/video.3gp"},"duration":168,"aspectRatio":"widescreen","viewCount":1010,"favoriteCount":0,"commentCount":0,"accessControl":{"comment":"allowed","commentVote":"allowed","videoRespond":"moderated","rate":"allowed","embed":"allowed","list":"allowed","autoPlay":"allowed","syndicate":"allowed"}},
        search = {"gd$etag":"W/\"DEEASH47eCp7I2A9WhFSEUw.\"","id":{"$t":"tag:youtube.com,2008:video:PLcYkDA1jnM"},"published":{"$t":"2013-06-13T09:44:09.000Z"},"updated":{"$t":"2013-06-13T09:44:09.000Z"},"category":[{"scheme":"http://schemas.google.com/g/2005#kind","term":"http://gdata.youtube.com/schemas/2007#video"},{"scheme":"http://gdata.youtube.com/schemas/2007/categories.cat","term":"People","label":"People & Blogs"}],"title":{"$t":"Top Eleven Football Manager Hack Token Cash 2013"},"content":{"type":"application/x-shockwave-flash","src":"https://www.youtube.com/v/PLcYkDA1jnM?version=3&f=videos&app=youtube_gdata"},"link":[{"rel":"alternate","type":"text/html","href":"https://www.youtube.com/watch?v=PLcYkDA1jnM&feature=youtube_gdata"},{"rel":"http://gdata.youtube.com/schemas/2007#video.responses","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/PLcYkDA1jnM/responses?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#video.related","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/PLcYkDA1jnM/related?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#mobile","type":"text/html","href":"https://m.youtube.com/details?v=PLcYkDA1jnM"},{"rel":"http://gdata.youtube.com/schemas/2007#uploader","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/users/ywDAa1VfO1e8hRBvAP4PJg?v=2"},{"rel":"self","type":"application/atom+xml","href":"https://gdata.youtube.com/feeds/api/videos/PLcYkDA1jnM?v=2"}],"author":[{"name":{"$t":"Lauren l"},"uri":{"$t":"https://gdata.youtube.com/feeds/api/users/ywDAa1VfO1e8hRBvAP4PJg"},"yt$userId":{"$t":"ywDAa1VfO1e8hRBvAP4PJg"}}],"yt$accessControl":[{"action":"comment","permission":"allowed"},{"action":"commentVote","permission":"allowed"},{"action":"videoRespond","permission":"moderated"},{"action":"rate","permission":"allowed"},{"action":"embed","permission":"allowed"},{"action":"list","permission":"allowed"},{"action":"autoPlay","permission":"allowed"},{"action":"syndicate","permission":"allowed"}],"gd$comments":{"gd$feedLink":{"rel":"http://gdata.youtube.com/schemas/2007#comments","href":"https://gdata.youtube.com/feeds/api/videos/PLcYkDA1jnM/comments?v=2","countHint":0}},"media$group":{"media$category":[{"$t":"People","label":"People & Blogs","scheme":"http://gdata.youtube.com/schemas/2007/categories.cat"}],"media$content":[{"url":"https://www.youtube.com/v/PLcYkDA1jnM?version=3&f=videos&app=youtube_gdata","type":"application/x-shockwave-flash","medium":"video","isDefault":"true","expression":"full","duration":51,"yt$format":5},{"url":"rtsp://v5.cache3.c.youtube.com/CiILENy73wIaGQlzjjUwkBi3PBMYDSANFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":51,"yt$format":1},{"url":"rtsp://v5.cache3.c.youtube.com/CiILENy73wIaGQlzjjUwkBi3PBMYESARFEgGUgZ2aWRlb3MM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":51,"yt$format":6}],"media$credit":[{"$t":"ywDAa1VfO1e8hRBvAP4PJg","role":"uploader","scheme":"urn:youtube","yt$display":"Lauren l"}],"media$description":{"$t":"Bienvenue sur le nouveau et le fonctionnement 100% Top Eleven Hack. La nouvelle mise Ã jour est maintenant! Notre Ã©quipe a crÃ©Ã© pour aider les nouveaux joueurs de se lancer dans onze premiers...","type":"plain"},"media$keywords":{},"media$license":{"$t":"youtube","type":"text/html","href":"http://www.youtube.com/t/terms"},"media$player":{"url":"https://www.youtube.com/watch?v=PLcYkDA1jnM&feature=youtube_gdata_player"},"media$thumbnail":[{"url":"https://i.ytimg.com/vi/PLcYkDA1jnM/default.jpg","height":90,"width":120,"time":"00:00:25.500","yt$name":"default"},{"url":"https://i.ytimg.com/vi/PLcYkDA1jnM/mqdefault.jpg","height":180,"width":320,"yt$name":"mqdefault"},{"url":"https://i.ytimg.com/vi/PLcYkDA1jnM/hqdefault.jpg","height":360,"width":480,"yt$name":"hqdefault"},{"url":"https://i.ytimg.com/vi/PLcYkDA1jnM/sddefault.jpg","height":480,"width":640,"yt$name":"sddefault"},{"url":"https://i.ytimg.com/vi/PLcYkDA1jnM/1.jpg","height":90,"width":120,"time":"00:00:12.750","yt$name":"start"},{"url":"https://i.ytimg.com/vi/PLcYkDA1jnM/2.jpg","height":90,"width":120,"time":"00:00:25.500","yt$name":"middle"},{"url":"https://i.ytimg.com/vi/PLcYkDA1jnM/3.jpg","height":90,"width":120,"time":"00:00:38.250","yt$name":"end"}],"media$title":{"$t":"Top Eleven Football Manager Hack Token Cash 2013","type":"plain"},"yt$aspectRatio":{"$t":"widescreen"},"yt$duration":{"seconds":"51"},"yt$uploaded":{"$t":"2013-06-13T09:44:09.000Z"},"yt$uploaderId":{"$t":"UCywDAa1VfO1e8hRBvAP4PJg"},"yt$videoid":{"$t":"PLcYkDA1jnM"}}} ,
        playlist = {"gd$etag":"W/\"YDwqeyM.\"","id":{"$t":"tag:youtube.com,2008:playlist:PLv0fFysopOMYczzBO8PofVO112_oWJKap:PL1Mor8po6BcU0r1UAwsKHc-1NPZWSWpy7pQG0dPFS_p0"},"published":{"$t":"2013-06-13T11:24:34.000Z"},"updated":{"$t":"1970-01-01T00:00:00.000Z"},"category":[{"scheme":"http://schemas.google.com/g/2005#kind","term":"http://gdata.youtube.com/schemas/2007#video"},{"scheme":"http://gdata.youtube.com/schemas/2007/categories.cat","term":"Tech","label":"Science & Technology"}],"title":{"$t":"Map of Medicine - supporting the clinical workflow"},"content":{"type":"application/x-shockwave-flash","src":"http://www.youtube.com/v/o95tuRUO_P4?version=3&f=playlists&app=youtube_gdata"},"link":[{"rel":"alternate","type":"text/html","href":"http://www.youtube.com/watch?v=o95tuRUO_P4&feature=youtube_gdata"},{"rel":"http://gdata.youtube.com/schemas/2007#video.responses","type":"application/atom+xml","href":"http://gdata.youtube.com/feeds/api/videos/o95tuRUO_P4/responses?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#video.related","type":"application/atom+xml","href":"http://gdata.youtube.com/feeds/api/videos/o95tuRUO_P4/related?v=2"},{"rel":"http://gdata.youtube.com/schemas/2007#mobile","type":"text/html","href":"http://m.youtube.com/details?v=o95tuRUO_P4"},{"rel":"http://gdata.youtube.com/schemas/2007#uploader","type":"application/atom+xml","href":"http://gdata.youtube.com/feeds/api/users/42CPAwk0K7cE87CWUooOZw?v=2"},{"rel":"related","type":"application/atom+xml","href":"http://gdata.youtube.com/feeds/api/videos/o95tuRUO_P4?v=2"},{"rel":"self","type":"application/atom+xml","href":"http://gdata.youtube.com/feeds/api/playlists/PLv0fFysopOMYczzBO8PofVO112_oWJKap/PL1Mor8po6BcU0r1UAwsKHc-1NPZWSWpy7pQG0dPFS_p0?v=2"}],"author":[{"name":{"$t":"TheMapofmedicine"},"uri":{"$t":"http://gdata.youtube.com/feeds/api/users/TheMapofmedicine"},"yt$userId":{"$t":"42CPAwk0K7cE87CWUooOZw"}}],"yt$accessControl":[{"action":"comment","permission":"allowed"},{"action":"commentVote","permission":"allowed"},{"action":"videoRespond","permission":"moderated"},{"action":"rate","permission":"allowed"},{"action":"embed","permission":"allowed"},{"action":"list","permission":"allowed"},{"action":"autoPlay","permission":"allowed"},{"action":"syndicate","permission":"allowed"}],"gd$comments":{"gd$feedLink":{"rel":"http://gdata.youtube.com/schemas/2007#comments","href":"http://gdata.youtube.com/feeds/api/videos/o95tuRUO_P4/comments?v=2","countHint":0}},"yt$hd":{},"media$group":{"media$category":[{"$t":"Tech","label":"Science & Technology","scheme":"http://gdata.youtube.com/schemas/2007/categories.cat"}],"media$content":[{"url":"http://www.youtube.com/v/o95tuRUO_P4?version=3&f=playlists&app=youtube_gdata","type":"application/x-shockwave-flash","medium":"video","isDefault":"true","expression":"full","duration":168,"yt$format":5},{"url":"rtsp://v7.cache1.c.youtube.com/CiULENy73wIaHAn-_A4VuW3eoxMYDSANFEgGUglwbGF5bGlzdHMM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":168,"yt$format":1},{"url":"rtsp://v7.cache1.c.youtube.com/CiULENy73wIaHAn-_A4VuW3eoxMYESARFEgGUglwbGF5bGlzdHMM/0/0/0/video.3gp","type":"video/3gpp","medium":"video","expression":"full","duration":168,"yt$format":6}],"media$credit":[{"$t":"themapofmedicine","role":"uploader","scheme":"urn:youtube","yt$display":"TheMapofmedicine"}],"media$description":{"$t":"Map of Medicine supports the optimisation of patient care by providing comprehensive, evidence-based local guidance and clinical decision support at the point of care.\nMap of Medicine is used by health economies across the country to support consistent use of care pathways and to effectively manage referral activity.","type":"plain"},"media$keywords":{},"media$license":{"$t":"youtube","type":"text/html","href":"http://www.youtube.com/t/terms"},"media$player":{"url":"http://www.youtube.com/watch?v=o95tuRUO_P4&feature=youtube_gdata_player"},"media$thumbnail":[{"url":"http://i4.ytimg.com/vi/o95tuRUO_P4/default.jpg","height":90,"width":120,"time":"00:01:24","yt$name":"default"},{"url":"http://i4.ytimg.com/vi/o95tuRUO_P4/mqdefault.jpg","height":180,"width":320,"yt$name":"mqdefault"},{"url":"http://i4.ytimg.com/vi/o95tuRUO_P4/hqdefault.jpg","height":360,"width":480,"yt$name":"hqdefault"},{"url":"http://i4.ytimg.com/vi/o95tuRUO_P4/sddefault.jpg","height":480,"width":640,"yt$name":"sddefault"},{"url":"http://i4.ytimg.com/vi/o95tuRUO_P4/1.jpg","height":90,"width":120,"time":"00:00:42","yt$name":"start"},{"url":"http://i4.ytimg.com/vi/o95tuRUO_P4/2.jpg","height":90,"width":120,"time":"00:01:24","yt$name":"middle"},{"url":"http://i4.ytimg.com/vi/o95tuRUO_P4/3.jpg","height":90,"width":120,"time":"00:02:06","yt$name":"end"}],"media$title":{"$t":"Map of Medicine - supporting the clinical workflow","type":"plain"},"yt$aspectRatio":{"$t":"widescreen"},"yt$duration":{"seconds":"168"},"yt$uploaded":{"$t":"2013-03-18T11:31:18.000Z"},"yt$uploaderId":{"$t":"UC42CPAwk0K7cE87CWUooOZw"},"yt$videoid":{"$t":"o95tuRUO_P4"}},"yt$statistics":{"favoriteCount":"0","viewCount":"1010"},"yt$threed":{"source":"converted"},"yt$position":{"$t":1}};
    ok( jQuery().youtubeVideoGallery().test.getIdFromEntry( user ) === 'o95tuRUO_P4', "Passed" );
    ok( jQuery().youtubeVideoGallery().test.getIdFromEntry( search ) === 'PLcYkDA1jnM', "Passed" );
    ok( jQuery().youtubeVideoGallery().test.getIdFromEntry( playlist ) === 'o95tuRUO_P4', "Passed" );
});

/*
getTitleStyle:getTitleStyle,
    getStyle:getStyle,
    getVideosFromFeed:getVideosFromFeed
*/