const path = require('path');

module.exports =
{
  mode: "development",
  entry:
  {
    exampleWithCSV: "./src/demo/exampleWithCSV.ts",
    exampleWithHTML: "./src/demo/exampleWithHTML.ts",
    exampleWithJSON: "./src/demo/exampleWithJSON.ts",
    exampleWithMixedFields: "./src/demo/exampleWithMixedFields.ts",
    exampleWithUL: "./src/demo/exampleWithUL.ts",
    exampleWithUserFile: "./src/demo/exampleWithUserFile.ts"
  },
  output:
  {
    path: path.resolve(__dirname, "public"),
    filename: "JS/[name].app.js"
  },
  resolve: {
    extensions: ['.tsx', '.ts', '.js'],
  }, 
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        use: 'ts-loader',
        exclude: /node_modules/,
      },
    ],
  },
  devServer: {
    static: path.join(__dirname, "public")
  },  
};