import { errors, FreeDatas2HTML, MixedFieldsRender } from "../../src/extensions/MixedFieldsRender";
const fixtures=require("../fixtures.js");

describe("Test du moteur de rendu alternatif avec contenus mixables, etc.", () =>
{
    let render: MixedFieldsRender;
    const fields=[ "Z", "Élément", "Symbole", "Famille" ] ;
    // Les champs des différentes lignes ne sont pas forcément dans le même ordre et certains peuvent être absents, vides ou encore en trop...
    const datas=[{"Z":"1","Élément":"Hydrogène","Symbole":"H","Famille":"Non-métal"},{"Famille":"Gaz noble","Élément":"Hélium","Z":"2","Symbole":"He"},{"Champ ignoré":"Je me champ ignoré !", "Z":"3","Élément":"Lithium","Famille":"Métal alcalin","Symbole":"Li"},{"Z":"4","Élément":"Béryllium","Famille":"","Champ ignoré":"Je me champ ignoré !"}] ;
    let renderSettings=
    {
        allBegining: "<div>",
        allEnding: "</div>",
        linesBegining: "<ul>",
        linesEnding: "</ul>",
        fieldsNamesDisplaying: "<h3>##0## | ##1##  | ##3## | ##2##</h3>", 
        datasLinesDisplaying: "<li>##0## | ##1## | ##3## | ##2##</li>" 
    };
    
    beforeEach(() =>
    {
        render=new MixedFieldsRender(renderSettings);
    });

    it("Doit générer une erreur, si une liste de champs vide lui est fournie.", () =>
    {
        expect(() => { return  render.fields=[]; } ).toThrowError(errors.renderNeedFields);
        expect(render.fields).toEqual([]);
    });
    
    it("Doit accepter toute liste de champs valide.", () =>
    {
        render=new MixedFieldsRender(renderSettings);
        expect(() => { return  render.fields=[""]; }).not.toThrowError(); // pas normal, mais pas testé par cette classe
        expect(render.fields).toEqual([""]);
        expect(() => { return  render.fields=["je vois double", "je vois double"]; }).not.toThrowError(); // idem
        expect(render.fields).toEqual(["je vois double", "je vois double"]);
        expect(() => { return  render.fields=["je me sens seul"]; }).not.toThrowError();
        expect(render.fields).toEqual(["je me sens seul"]);
    });

    it("Doit générer une erreur, si lancé sans avoir fourni une liste des champs.", () =>
    {
        expect(() => { return  render.rend2HTML(); }).toThrowError(errors.renderNeedFields);
    });
    
    it("Ne doit pas générer d'erreur, si lancé avec une liste des champs, même s'il n'y a aucune donnée fournie.", () =>
    {
        render.fields=fields;
        expect(() => { return  render.rend2HTML(); }).not.toThrowError();
    });
    
    it("Doit retourner un code HTML correspondant à la configuration fournie, avec ou sans données à afficher.", () =>
    {
        render.fields=fields;
        let html=render.rend2HTML();
        expect(html).toEqual("<div><h3>Z | Élément  | Famille | Symbole</h3><ul></ul></div>");    
        // Avec des données :
        render.datas=datas;
        html=render.rend2HTML(); 
        expect(html).toEqual("<div><h3>Z | Élément  | Famille | Symbole</h3><ul><li>1 | Hydrogène | Non-métal | H</li><li>2 | Hélium | Gaz noble | He</li><li>3 | Lithium | Métal alcalin | Li</li><li>4 | Béryllium |  | </li></ul></div>"); 
    });
    
    it("Doit retourner un code HTML prenant en compte les fonctions spécifiques d'affichage, ou encore les champs affichés plusieurs fois.", () =>
    {
        const newRenderSettings=
        {
            allBegining: "<div>",
            allEnding: "</div>",
            linesBegining: "<ul>",
            linesEnding: "</ul>",
            fieldsNamesDisplaying: "<h3>##0## | ##1##  | ##3## | ##2##</h3>", 
            datasLinesDisplaying: "<li>##0## | ##1## (##0##) | ##3## | ##2##</li>"
        };
        const newRender=new MixedFieldsRender(newRenderSettings);
        const rendFamille2HTML=(values: {[index: string]:string} ) : string =>
        {
            if(values["Famille"] !=="")
                return values["Famille"];
            else
                return  "Non  renseigné"; // doit apparaître car "Famille" est vide mais existant pour le Béryllium.
        };
        const rendSymbol2HTML=(values: {[index: string]:string} ) : string =>
        {
            if(values["Symbole"] !=="")
                return values["Symbole"];
            else
                return  "Inconnu"; // ne doit pas apparaître, car "Symbole" n'existe pas du tout par le Béryllium, donc rendSymbol2HTML() ne doit pas être appelée.
        };
        newRender.fieldRenders=[{ name:"Famille",  rend2HTML: rendFamille2HTML}, { name:"Symbole",  rend2HTML: rendSymbol2HTML}];
        newRender.fields=fields;
        newRender.datas=datas;
        let html=newRender.rend2HTML();
        expect(html).toEqual("<div><h3>Z | Élément  | Famille | Symbole</h3><ul><li>1 | Hydrogène (1) | Non-métal | H</li><li>2 | Hélium (2) | Gaz noble | He</li><li>3 | Lithium (3) | Métal alcalin | Li</li><li>4 | Béryllium (4) | Non  renseigné | </li></ul></div>"); 
    });
});