// Options de Papa Parse
// cf. https://www.papaparse.com/docs#config
export interface PublicPapaParseOptions
{
    delimiter: string;
    newline: string;
    quoteChar: string;
    escapeChar: string;
    transformHeader?(field: string, index: number): string;
    preview: number;
    comments: false|string;
    fastMode: boolean|undefined;
    transform?(value: string): string;
}
export interface PrivatePapaParseOptions
{
    header: boolean;
    download: boolean;
    downloadRequestHeaders: undefined| { [index: string]:string };
    skipEmptyLines: string;
    withCredentials: boolean|undefined;
}