import { FreeDatas2HTML, Pagination, Render, SearchEngine, Selector, SortingField } from "../FreeDatas2HTML";

const initialise = () =>
{
    try
    {
        // Éléments du DOM utilisés :
        const  dataDisplayElt=document.getElementById("datas") as HTMLElement;
        const  dataDisplayOptionsElt=document.getElementById("displayOptions") as HTMLElement;
        const myFile=document.getElementById("myFile") as HTMLInputElement;
        const myForm=document.getElementById("userSettings") as HTMLElement;
        const pagesElt=document.getElementById("pages") as HTMLElement;
        const paginationElt=document.getElementById("paginationOptions") as HTMLElement;
        const searchElt=document.getElementById("search") as HTMLElement;
        if(dataDisplayElt === null || dataDisplayOptionsElt === null || myFile === null || myForm === null|| pagesElt === null|| paginationElt === null|| searchElt === null)
            throw new Error("Tous les éléments HTML nécessaires au fonctionnement n'ont pas été trouvés dans la page;");

        let converter: FreeDatas2HTML;
        const myRender=new Render();
        // Attention, ici l'élément devant afficher le compteur n'est pas initialement présent dans la page :
        myRender.settings.allBegining="<table class='table-hover'><caption>Nombre de résultats : <span  id='counter'></span></caption>";

        myFile.addEventListener("change", function(e)
       {
            // Place nette pour le nouveau fichier :
            dataDisplayElt.innerHTML="";
            dataDisplayOptionsElt.innerHTML="";
            pagesElt.innerHTML="";
            paginationElt.innerHTML="";
            searchElt.innerHTML="";

            // Création d'un convertisseur parsant les données du fichier CSV sélectionné :
            converter=new FreeDatas2HTML("CSV");
            converter.datasRender=myRender;
            
            // L'utilisateur a-t-il vraiment sélectionné un  fichier ?
            // Si oui, est-ce un fichier CSV ?
            const selectedFiles=myFile.files;
            if(selectedFiles !== null && selectedFiles.length === 1)
            {
                // selectedFiles[0].type ne fonctionne pas avec certains navigateurs (Fennec), donc... :
                const extension=selectedFiles[0].name.substring(selectedFiles[0].name.lastIndexOf(".")+1);
                if(extension !== "csv")
                    dataDisplayOptionsElt.innerHTML=`<p class='text-danger'>Le fichier que vous avez sélectionné ne semble pas être un fichier CSV.</p>`;
                else
                {
                    // Lecture du contenu du fichier qui est passé au parseur :
                    const reader=new FileReader();
                    reader.onload=async function(e)
                    {
                        converter.parser.datas2Parse=reader.result as string;
                        await converter.run();
                        let fieldsSelectorHTML=`<fieldset class="form-group"><legend>Quels champs souhaitez-vous afficher ?</legend>`;
                        for(let i=0; i < converter.fields.length; i++)
                             fieldsSelectorHTML+=`<label for="selectedField_${i}" class="paper-check"> <input type="checkbox" class="selectedFields" id="selectedField_${i}" name="selectedField_${i}" value=${i} checked> <span>${converter.fields[i]}</span></label>`;
                        fieldsSelectorHTML+=`</fieldset>`;
                        dataDisplayOptionsElt.innerHTML=fieldsSelectorHTML+`<button type="submit" class="btn-success">Valider</button>`;
                    };
                    reader.readAsText(selectedFiles[0]);
                }
            }
        });

        // Une fois le choix des champs à afficher validé, on peut afficher les données et certains outils :
        myForm.addEventListener("submit", function(e)
       {
            e.preventDefault();
            dataDisplayElt.innerHTML="";
            
            // Quels champs ont été sélectionnés ?
            let fields2Rend: number[]=[];
            let checkBox: HTMLInputElement;
            for(let i=0; i < converter.fields.length; i++)
            {
                checkBox=document.getElementById("selectedField_"+i) as HTMLInputElement;
                if(checkBox !== null)
                {
                    if(checkBox.checked)
                        fields2Rend.push(i);
                }
            }

            if( fields2Rend.length === 0)
                dataDisplayElt.innerHTML=`<p class='text-danger'>Merci de sélectionner les champs que vous souhaitez afficher !</p>`;
            else
            {
                converter.fields2Rend=fields2Rend;
                converter.datasViewElt={  id:"datas" };

                // +  Un moteur de recherche opérant sur tous les champs :
                const mySearch=new SearchEngine(converter, { id:"search" });
                mySearch.label="Qui cherche trouve ?";
                mySearch.btnTxt="Va chercher !";
                // La recherche se lance automatiquement, dès que 2 caractères sont saisis :
                mySearch.automaticSearch=true;
                mySearch.nbCharsForSearch=2;
                mySearch.placeholder="Saisir un moins 2 caractères";
                mySearch.filter2HTML();
                converter.datasFilters=[mySearch];

                // + Pagination :
                const pagination=new Pagination(converter, { id:"pages" }, "Page à afficher :");
                pagination.options={ displayElement: { id:"paginationOptions" }, values: [10,20,50,100,500] , name: "Choix de pagination :" };
                pagination.selectedValue=20;
                converter.pagination=pagination;
                pagination.options2HTML();

                // + Compteur :
                converter.datasCounterElt={ id:"counter" };

                // +Toutes les colonnes affichées sont classables :
                let sortingField: SortingField;
                converter.datasSortingFields=[];
                for(let i=0; i < converter.fields2Rend.length; i++)
                {
                    sortingField=new SortingField(converter, converter.fields2Rend[i]);
                    converter.datasSortingFields.push(sortingField);
                }
                
                // Actualisation de l'affichage :
                converter.refreshView();

                // Déplacement vers les données
                const here=window.location;
                if(window.location.hash!=="")
                {
                    window.location.hash="";// ! le "#" reste
                    window.location.assign(here+"paginationOptions");
                }
                else
                    window.location.assign(here+"#paginationOptions");
            }
       });
    }
    catch(e)
    {
        console.error(e);
        document.getElementById("datas")!.innerHTML=`<div class="alert alert-warning">Désolé, mais un problème technique empêche le fonctionnement normal de cette page.</div>`;
    }
}
console.log("Hello, les dev !\nLe code source TypeScript utilisé pour faire fonctionner cette page est lisible ici : :\nhttps://forge.chapril.org/Fab_Blab/FreeDatas2HTML/src/branch/master/src/demo/exampleWithUserFile.ts");
initialise();