import { FreeDatas2HTML, Pagination, Render, SearchEngine, Selector, SortingField } from "../FreeDatas2HTML";
import { SortingFieldsStandAlone } from "../extensions/SortingFieldsStandAlone";

const initialise=async () =>
{
    try
    {
        // Création d'un convertisseur parsant les données d'un fichier CSV "distant"
        const converter=new FreeDatas2HTML("CSV");
        converter.parser.setRemoteSource({ url:"https://freedatas2html.le-fab-lab.com/datas/elements-chimiques.csv" });
        // Parsage des données, qui ne sont pas encore affichées :
        await converter.run();
        // On affiche que certains champs :
        converter.fields2Rend=[0,1,2,3];
                
        // Les données sont listées en dehors d'un tableau :
        const myRender=new Render();
        myRender.settings=
        {
            allBegining:"<h4>Liste des éléments chimiques :</h4>",
            allEnding:"",
            linesBegining:"<ul>",
            linesEnding:"</ul>",
            lineBegining:"<li><ul>",
            lineEnding:"</ul></li>",
            dataDisplaying:"<li><b>#FIELDNAME :</b> #VALUE</li>",
        };
        converter.datasRender=myRender;
        
        // Désignation des champs permettant de classer les données en dehors de l'affichage des données
        let sortingField1=new SortingField(converter, 0);
        let sortingField2=new SortingField(converter, 1);
        let sortingField3=new SortingField(converter, 2);
        const allFields=new SortingFieldsStandAlone(converter,{ id:"classement" });
        allFields.datasSortingFields=[sortingField1,sortingField2, sortingField3];
        allFields.rendSettings.allBeginning="<h4>#LABEL</h4><ul>";
        allFields.rend2HTML("Champ sur lequel classer les données :") ;
                
        // Affichage initial :
        converter.datasViewElt={  id:"datas" };
        converter.refreshView(); 
    }
    catch(e)
    {
        console.error(e);
        document.getElementById("datas")!.innerHTML=`<div class="alert alert-warning">Désolé, mais un problème technique empêche l'affichage des données.</div>`;
    }
}

console.log("Hello, les dev !\nLe code source TypeScript utilisé pour faire fonctionner cette page est lisible ici : :\nhttps://forge.chapril.org/Fab_Blab/FreeDatas2HTML/src/branch/master/src/demo/exampleWithJSON.ts");
initialise();