import { FreeDatas2HTML, Pagination, Render, SearchEngine, Selector, SortingField } from "../FreeDatas2HTML";

const initialise=async () =>
{
    try
    {
        // Création d'un convertisseur parsant des données transmises en JSON :
        const converter=new FreeDatas2HTML("JSON");
        // Exemple d'utilisation de headers (inutiles ici) :
        // converter.parser.setRemoteSource({ url: "https://freedatas2html.le-fab-lab.com/datas/posts2.json", withCredentials:true, headers: [{ key:"Authorization", value:"Token YWxhZGRpbjpvcGVuc2VzYW1l" }] });
        converter.parser.setRemoteSource({ url: "https://freedatas2html.le-fab-lab.com/datas/posts2.json" });
        // Parsage des données, qui ne sont pas encore affichées :
        await converter.run();
        
        // Adaptation du rendu suivant la taille de l'écran :
        const myRender=new Render();
        if(window.innerWidth < 800)
        {
            myRender.settings=
            {
                allBegining:"<h4>Affichage petits écrans !</h4>",
                allEnding:"",
                linesBegining:"<ul>",
                linesEnding:"</ul>",
                lineBegining:"<li><ul>",
                lineEnding:"</ul></li>",
                dataDisplaying:"<li><b>#FIELDNAME :</b> #VALUE</li>",
            };
            converter.datasRender=myRender;
        }
        else
        {
            // Ici, on adapte juste la balise encadrant l'ensemble des données pour passer une classe de paper.css :
            myRender.settings.allBegining="<table class='table-hover'>";
            converter.datasRender=myRender;
        }
        
        // Configuration de la pagination :
        const pagination=new Pagination(converter, { id:"pages" }, "Page à afficher :");
        pagination.options={ displayElement: { id:"paginationOptions" }, values: [15,30,90,150] , name: "Nombre de lignes par page :" };
        pagination.selectedValue=15;
        converter.pagination=pagination;
        pagination.options2HTML();

        // Désignation des champs permettant de classer les données :
        // Uniquement avec un rendu sous forme de tableau (grand écran), car des en-têtes de colonne sont nécessaires.
        if(window.innerWidth >= 800)
        {
            let sortingField1=new SortingField(converter, 0);
            let sortingField2=new SortingField(converter, 1);
            let sortingField3=new SortingField(converter, 2);
            converter.datasSortingFields=[sortingField1,sortingField2,sortingField3];
        }
                
        // Création d'un filtre sur la premier champ :
        let filtre1=new Selector(converter, 0, { id:"filtre1"} );
        filtre1.filter2HTML();

        // + Un moteur de recherche, mais filtrant les données seulement sur les 2 derniers champs :
        const mySearch=new SearchEngine(converter, { id:"search" }, [2,3]);
        mySearch.label="Qui cherche trouve ?";
        mySearch.btnTxt="Va chercher !";
        // La recherche se lance automatiquement, dès que 2 caractères sont saisis :
        mySearch.automaticSearch=true;
        mySearch.nbCharsForSearch=2;
        mySearch.placeholder="Tapes en NB, chef !";
        mySearch.filter2HTML();
        
        // Injection des filtres dans le convertisseur :
        converter.datasFilters=[filtre1, mySearch];
                
        // Affichage initial avec l'id de l'élément HTML devant afficher le compteur :
        converter.datasViewElt={  id:"datas" };
        converter.datasCounterElt={ id:"compteur" };
        converter.refreshView(); 
    }
    catch(e)
    {
        console.error(e);
        document.getElementById("datas")!.innerHTML=`<div class="alert alert-warning">Désolé, mais un problème technique empêche l'affichage des données.</div>`;
    }
}

console.log("Hello, les dev !\nLe code source TypeScript utilisé pour faire fonctionner cette page est lisible ici : :\nhttps://forge.chapril.org/Fab_Blab/FreeDatas2HTML/src/branch/master/src/demo/exampleWithJSON.ts");
initialise();