import { FreeDatas2HTML, Pagination, Render, Selector, SortingField } from "../FreeDatas2HTML";

const initialise=async () =>
{
    try
    {
        // Création d'un convertisseur parsant des données transmises en HTML :
        const converter=new FreeDatas2HTML("HTML");
        // Parsage des données, qui ne sont pas encore réaffichées :
        await converter.run();

        // Choix de l'ordre dans lequel les champs sont à afficher :
        converter.fields2Rend=[3,0,1,2];
        
        // Adaptation du rendu suivant la taille de l'écran :
        const myRender=new Render();
        if(window.innerWidth < 800)
        {
            myRender.settings=
            {
                allBegining:"<h4>Affichage petits écrans !</h4>",
                allEnding:"",
                linesBegining:"<ul>",
                linesEnding:"</ul>",
                lineBegining:"<li><ul>",
                lineEnding:"</ul></li>",
                dataDisplaying:"<li><b>#FIELDNAME :</b> #VALUE</li>",
            };
            converter.datasRender=myRender;
        }
        else
        {
            // Ici, on adapte juste la balise encadrant l'ensemble des données pour passer une classe de paper.css :
            myRender.settings.allBegining="<table class='table-hover'>";
            converter.datasRender=myRender;
        }

        // Configuration de la pagination :
        const pagination=new Pagination(converter, { id:"pages" }, "Page à afficher :");
        pagination.options={ displayElement: { id:"paginationOptions" }, values: [15,30,50] , name: "Nombre de lignes par page :" };
        pagination.selectedValue=15;
        converter.pagination=pagination;
        pagination.options2HTML();
           
        // Création d'un filtre sur le 4ième champ :
        let filtre1=new Selector(converter, 3, { id:"filtre1"} );
        filtre1.filter2HTML();
        converter.datasFilters=[filtre1];

        // Désignation des champs permettant de classer les données :
        // Uniquement avec un rendu sous forme de tableau (grand écran), car des en-têtes de colonne sont nécessaires.
        if(window.innerWidth >= 800)
        {
            let sortingField1=new SortingField(converter, 2);
            let sortingField2=new SortingField(converter, 3);
            converter.datasSortingFields=[sortingField1,sortingField2];
        }

        // Affichage initial :
        converter.datasViewElt={  id:"datas" };
        converter.refreshView();
    }
    catch(e)
    {
        console.error(e);
        document.getElementById("datas")!.innerHTML=`<div class="alert alert-warning">Désolé, mais un problème technique empêche l'affichage des données.</div>`;
    }
}

console.log("Hello, les dev !\nLe code source TypeScript utilisé pour faire fonctionner cette page est lisible ici : :\nhttps://forge.chapril.org/Fab_Blab/FreeDatas2HTML/src/branch/master/src/demo/exampleWithHTML.ts");
initialise();