import { FreeDatas2HTML, Pagination, Render, SearchEngine, Selector, SortingField } from "../FreeDatas2HTML";

const initialise=async () =>
{
    try
    {
        // Fonction spécifique de classement, utile pour les données du 4ième champ :
        const mySort=(a: any, b: any, order: "asc"|"desc" = "asc") =>
        {
            const values=[ "> 100000", "> 1 et < 100 000", "≤ 1",  "Traces", "Inexistant"];
            if(order === "desc")
                values.reverse();
            if(values.indexOf(a) > values.indexOf(b))
                return -1;
            else if(values.indexOf(a) < values.indexOf(b))
                return 1;
            else
                return 0;
        };
        
        // Création d'un convertisseur parsant les données d'un fichier CSV "distant"
        const converter=new FreeDatas2HTML("CSV");
        converter.parser.setRemoteSource({ url:"https://freedatas2html.le-fab-lab.com/datas/elements-chimiques.csv" });
        // Parsage des données, qui ne sont pas encore affichées :
        await converter.run();
        
        // Adaptation du rendu suivant la taille de l'écran :
        const myRender=new Render();
        if(window.innerWidth < 800)
        {
            myRender.settings=
            {
                allBegining:"<h4>Affichage petits écrans !</h4>",
                allEnding:"",
                linesBegining:"<ul>",
                linesEnding:"</ul>",
                lineBegining:"<li><ul>",
                lineEnding:"</ul></li>",
                dataDisplaying:"<li><b>#FIELDNAME :</b> #VALUE</li>",
            };
            converter.datasRender=myRender;
        }
        else
        {
            // Ici, on adapte juste la balise encadrant l'ensemble des données pour passer une classe de paper.css :
            myRender.settings.allBegining="<table class='table-hover'>";
            converter.datasRender=myRender;
        }

        // Ajout de la fonction de classement spécifique déclarée plus haut :
        converter.datasSortingFunctions=[{ datasFieldNb:4, sort:mySort }];

        // Configuration de la pagination :
        const pagination=new Pagination(converter, { id:"pages" }, "Page à afficher :");
        pagination.options={ displayElement: { id:"paginationOptions" }, values: [10,20,50,500] , name: "Choix de pagination :" };
        pagination.selectedValue=10;
        converter.pagination=pagination;
        pagination.options2HTML();

        // Création d'outils permettant de filtrer les données sur 3 champs différents :
        let filtre1=new Selector(converter, 3, { id:"filtre1"} );
        filtre1.filter2HTML();
        let filtre2=new Selector(converter, 4, { id:"filtre2"} );
        filtre2.filter2HTML();
        // Le troisième devant prendre en compte un séparateur :
        let filtre3=new Selector(converter, 5, { id:"filtre3"}, ",");
        filtre3.isMultiple=true;
        filtre3.filter2HTML();
        
        // + Un moteur de recherche opérant sur tous les champs :
        const mySearch=new SearchEngine(converter, { id:"search" });
        mySearch.label="Qui cherche trouve ?";
        mySearch.btnTxt="Va chercher !";
        // La recherche se lance automatiquement, dès que 2 caractères sont saisis :
        mySearch.automaticSearch=true;
        mySearch.nbCharsForSearch=2;
        mySearch.placeholder="Tapes en NB, chef !";
        mySearch.filter2HTML();
        
        // Injection des filtres dans le convertisseur :
        converter.datasFilters=[filtre1,filtre2,filtre3,mySearch];

        // Désignation des champs permettant de classer les données :
        // Uniquement avec un rendu sous forme de tableau (grand écran), car des en-têtes de colonne sont nécessaires.
        if(window.innerWidth >= 800)
        {
            let sortingField1=new SortingField(converter, 0);
            let sortingField2=new SortingField(converter, 1);
            let sortingField3=new SortingField(converter, 2);
            let sortingField4=new SortingField(converter, 4);
            converter.datasSortingFields=[sortingField1,sortingField2,sortingField3,sortingField4];
        }

        // Affichage initial avec l'id de l'élément HTML devant afficher le compteur :
        converter.datasViewElt={  id:"datas" };
        converter.datasCounterElt={ id:"compteur" };
        converter.refreshView(); 
    }
    catch(e)
    {
        console.error(e);
        document.getElementById("datas")!.innerHTML=`<div class="alert alert-warning">Désolé, mais un problème technique empêche l'affichage des données.</div>`;
    }
}

console.log("Hello, les dev !\nLe code source TypeScript utilisé pour faire fonctionner cette page est lisible ici : :\nhttps://forge.chapril.org/Fab_Blab/FreeDatas2HTML/src/branch/master/src/demo/exampleWithCSV.ts");
initialise();