var errors = require("../errors.js");
var MixedFieldsRender = (function () {
    function MixedFieldsRender(settings) {
        this._fields = [];
        this.fieldRenders = [];
        this.datas = [];
        this.settings = settings;
    }
    Object.defineProperty(MixedFieldsRender.prototype, "fields", {
        get: function () {
            return this._fields;
        },
        set: function (fields) {
            if (fields.length === 0)
                throw new Error(errors.renderNeedFields);
            else
                this._fields = fields;
        },
        enumerable: true,
        configurable: true
    });
    MixedFieldsRender.prototype.rend2HTML = function () {
        if (this._fields.length === 0)
            throw new Error(errors.renderNeedFields);
        else {
            var datasHTML = this.settings.allBegining;
            if (this.settings.fieldsNamesDisplaying !== undefined) {
                var fieldsNamesRend = this.settings.fieldsNamesDisplaying;
                for (var i = 0; i < this._fields.length; i++)
                    fieldsNamesRend = fieldsNamesRend.replace("##" + i + "##", this._fields[i]);
                datasHTML += fieldsNamesRend;
            }
            if (this.settings.linesBegining !== undefined)
                datasHTML += this.settings.linesBegining;
            for (var _i = 0, _a = this.datas; _i < _a.length; _i++) {
                var row = _a[_i];
                var lineRend = this.settings.datasLinesDisplaying;
                var _loop_1 = function (i) {
                    var currentField = this_1._fields[i];
                    if (row[currentField] !== undefined) {
                        var rowRend = row[currentField];
                        var render = this_1.fieldRenders.find(function (item) {
                            return item.name === currentField;
                        });
                        if (render !== undefined)
                            rowRend = render.rend2HTML(row);
                        lineRend = lineRend.replace(new RegExp("##" + i + "##", "g"), rowRend);
                    }
                    else
                        lineRend = lineRend.replace(new RegExp("##" + i + "##", "g"), "");
                };
                var this_1 = this;
                for (var i = 0; i < this._fields.length; i++) {
                    _loop_1(i);
                }
                datasHTML += lineRend;
            }
            if (this.settings.linesEnding !== undefined)
                datasHTML += this.settings.linesEnding;
            datasHTML += this.settings.allEnding;
            return datasHTML;
        }
    };
    return MixedFieldsRender;
}());
export { MixedFieldsRender };
export { FreeDatas2HTML } from "../FreeDatas2HTML";
export { errors };
