var compare = require('natural-orderby').compare;
var errors = require("./errors.js");
import { FreeDatas2HTML } from "./FreeDatas2HTML";
var Selector = (function () {
    function Selector(converter, datasFieldNb, elt, separator) {
        this._datasViewElt = { id: "", eltDOM: undefined };
        this._selectedValues = [];
        this._values = [];
        this._name = "";
        this.isMultiple = false;
        if (converter.fields.length === 0 || converter.datas.length === 0)
            throw new Error(errors.filterNeedDatas);
        else if (!converter.checkFieldExist(Number(datasFieldNb)))
            throw new Error(errors.selectorFieldNotFound);
        else {
            this._datasViewElt = FreeDatas2HTML.checkInDOMById(elt);
            this._converter = converter;
            this._datasFieldNb = datasFieldNb;
            if (separator !== undefined && separator !== "")
                this._separator = separator;
            this._name = this._converter.fields[this._datasFieldNb];
            this.setValues();
        }
    }
    Object.defineProperty(Selector.prototype, "converter", {
        get: function () {
            return this._converter;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Selector.prototype, "datasViewElt", {
        get: function () {
            return this._datasViewElt;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Selector.prototype, "datasFieldNb", {
        get: function () {
            return this._datasFieldNb;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Selector.prototype, "name", {
        get: function () {
            return this._name;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Selector.prototype, "selectedValues", {
        get: function () {
            return this._selectedValues;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Selector.prototype, "separator", {
        get: function () {
            return this._separator;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Selector.prototype, "values", {
        get: function () {
            return this._values;
        },
        enumerable: true,
        configurable: true
    });
    Selector.prototype.setValues = function () {
        for (var _i = 0, _a = this._converter.datas; _i < _a.length; _i++) {
            var row = _a[_i];
            var checkedValue = void 0;
            if (this._separator === undefined) {
                checkedValue = row[this._name].trim();
                if (checkedValue !== "" && this._values.indexOf(checkedValue) === -1)
                    this._values.push(checkedValue);
            }
            else {
                var checkedValues = row[this._name].split(this._separator);
                for (var _b = 0, checkedValues_1 = checkedValues; _b < checkedValues_1.length; _b++) {
                    var value = checkedValues_1[_b];
                    checkedValue = value.trim();
                    if (checkedValue !== "" && this._values.indexOf(checkedValue) === -1)
                        this._values.push(checkedValue);
                }
            }
        }
        if (this._values.length === 0)
            throw new Error(errors.selectorFieldIsEmpty);
        else {
            if (this._converter.getSortingFunctionForField(this._datasFieldNb) !== undefined)
                this._values.sort(this._converter.getSortingFunctionForField(this._datasFieldNb).sort);
            else
                this._values.sort(compare());
        }
    };
    Selector.prototype.filter2HTML = function (label) {
        if (label === void 0) { label = ""; }
        label = (label === "") ? this._name : label;
        var multipleAttr = (this.isMultiple) ? " multiple" : "";
        var selectorsHTML = "<label for='freeDatas2HTML_" + this._datasViewElt.id + "'>" + label + " :</label><select name='freeDatas2HTML_" + this._datasViewElt.id + "' id='freeDatas2HTML_" + this._datasViewElt.id + "'" + multipleAttr + "><option value='0'>----</option>";
        for (var i = 0; i < this._values.length; i++)
            selectorsHTML += "<option value='" + (i + 1) + "'>" + this._values[i] + "</option>";
        selectorsHTML += "</select>";
        this._datasViewElt.eltDOM.innerHTML = selectorsHTML;
        var selectElement = document.getElementById("freeDatas2HTML_" + this._datasViewElt.id), mySelector = this;
        selectElement.addEventListener("change", function (e) {
            mySelector._selectedValues = [];
            if (mySelector.isMultiple) {
                for (var i = 0; i < selectElement.selectedOptions.length; i++) {
                    var selectedValue = parseInt(selectElement.selectedOptions[i].value, 10);
                    if (selectedValue === 0) {
                        mySelector._selectedValues = [];
                        break;
                    }
                    else
                        mySelector._selectedValues.push(selectedValue - 1);
                }
            }
            else {
                var selectedValue = parseInt(selectElement.value, 10);
                if (selectedValue === 0)
                    mySelector._selectedValues = [];
                else
                    mySelector._selectedValues[0] = selectedValue - 1;
            }
            mySelector._converter.refreshView();
        });
    };
    Selector.prototype.dataIsOk = function (data) {
        var checkIsValid = function (selector, data, checkedValue) {
            if (selector._separator === undefined) {
                if (data[selector._name].trim() !== checkedValue)
                    return false;
                else
                    return true;
            }
            else {
                var find_1 = false;
                var checkedValues = data[selector._name].split(selector._separator);
                for (var _i = 0, checkedValues_2 = checkedValues; _i < checkedValues_2.length; _i++) {
                    var value = checkedValues_2[_i];
                    if (value.trim() === checkedValue) {
                        find_1 = true;
                        break;
                    }
                }
                return find_1;
            }
        };
        if (this._selectedValues.length === 0)
            return true;
        if (data[this._name] === undefined)
            return false;
        var find = false;
        for (var _i = 0, _a = this._selectedValues; _i < _a.length; _i++) {
            var value = _a[_i];
            if (this._values[value] === undefined)
                throw new Error(errors.selectorSelectedIndexNotFound);
            find = checkIsValid(this, data, this._values[value]);
            if (find)
                break;
        }
        return find;
    };
    return Selector;
}());
export { Selector };
