var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var errors = require("./errors.js");
import { RemoteSource } from "./RemoteSource";
var ParserForJSON = (function () {
    function ParserForJSON(datasRemoteSource) {
        this._datas2Parse = "";
        this._parseResults = undefined;
        if (datasRemoteSource !== undefined)
            this._datasRemoteSource = datasRemoteSource;
        else
            this._datasRemoteSource = new RemoteSource({ url: "" });
    }
    ParserForJSON.prototype.setRemoteSource = function (source) {
        this._datasRemoteSource = new RemoteSource(source);
    };
    Object.defineProperty(ParserForJSON.prototype, "datasRemoteSource", {
        get: function () {
            return this._datasRemoteSource;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ParserForJSON.prototype, "datas2Parse", {
        get: function () {
            return this._datas2Parse;
        },
        set: function (datas) {
            if (datas.trim().length === 0)
                throw new Error(errors.parserNeedDatas);
            else
                this._datas2Parse = datas.trim();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ParserForJSON.prototype, "parseResults", {
        get: function () {
            return this._parseResults;
        },
        enumerable: true,
        configurable: true
    });
    ParserForJSON.prototype.parse = function () {
        return __awaiter(this, void 0, void 0, function () {
            var parser, parseContent, settings, response, datasParsed, typesOkForValue, fields, datas, parseErrors, nbFields, nbDatas, goodFields, i, i, dataObject, nbObjFields, j, i, _i, datasParsed_1, data, dataObject, field;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        parser = this;
                        parseContent = "";
                        if (!(parser._datasRemoteSource.url !== "")) return [3, 3];
                        settings = parser._datasRemoteSource.getFetchSettings();
                        return [4, fetch(parser._datasRemoteSource.url, settings)];
                    case 1:
                        response = _a.sent();
                        if (!response.ok)
                            throw new Error(errors.parserRemoteFail);
                        return [4, response.text()];
                    case 2:
                        parseContent = _a.sent();
                        return [3, 4];
                    case 3:
                        if (parser._datas2Parse !== "")
                            parseContent = parser._datas2Parse;
                        else
                            throw new Error(errors.parserNeedSource);
                        _a.label = 4;
                    case 4:
                        datasParsed = JSON.parse(parseContent);
                        typesOkForValue = ["boolean", "number", "string"];
                        fields = [], datas = [], parseErrors = [];
                        if (Array.isArray(datasParsed.fields) && Array.isArray(datasParsed.datas)) {
                            nbFields = datasParsed.fields.length, nbDatas = datasParsed.datas.length;
                            goodFields = [];
                            fields = datasParsed.fields;
                            for (i = 0; i < nbFields; i++) {
                                if (typeof fields[i] !== "string")
                                    parseErrors.push({ row: -1, message: errors.parserTypeError + typeof fields[i] });
                                else {
                                    fields[i] = fields[i].trim();
                                    if (fields[i] !== "" && goodFields.indexOf(fields[i]) === -1)
                                        goodFields.push(fields[i]);
                                    else
                                        parseErrors.push({ row: -1, message: errors.parserFieldNameFail });
                                }
                            }
                            fields = goodFields;
                            if (fields.length === 0)
                                throw new Error(errors.parserFail);
                            for (i = 0; i < nbDatas; i++) {
                                dataObject = {}, nbObjFields = datasParsed.datas[i].length;
                                if (nbObjFields !== nbFields)
                                    parseErrors.push({ row: i, message: errors.parserNumberOfFieldsFail });
                                for (j = 0; j < nbObjFields && j < nbFields; j++) {
                                    if (typesOkForValue.indexOf(typeof datasParsed.datas[i][j]) === -1)
                                        parseErrors.push({ row: i, message: errors.parserTypeError + typeof datasParsed.datas[i][j] });
                                    else
                                        dataObject[fields[j]] = datasParsed.datas[i][j] + "";
                                }
                                if (Object.keys(dataObject).length !== 0)
                                    datas.push(dataObject);
                                else
                                    parseErrors.push({ row: i, message: errors.parserLineWithoutDatas });
                            }
                        }
                        else {
                            i = 0;
                            for (_i = 0, datasParsed_1 = datasParsed; _i < datasParsed_1.length; _i++) {
                                data = datasParsed_1[_i];
                                dataObject = {};
                                for (field in data) {
                                    field = field.trim();
                                    if (field === "")
                                        parseErrors.push({ row: -1, message: errors.parserFieldNameFail });
                                    else if (typesOkForValue.indexOf(typeof data[field]) === -1)
                                        parseErrors.push({ row: i, message: errors.parserTypeError + typeof data[field] });
                                    else {
                                        if (fields.indexOf(field) === -1)
                                            fields.push(field);
                                        if (dataObject[field] !== undefined)
                                            parseErrors.push({ row: i, message: errors.parserFieldNameFail });
                                        else
                                            dataObject[field] = data[field] + "";
                                    }
                                }
                                if (Object.keys(dataObject).length !== 0)
                                    datas.push(dataObject);
                                else
                                    parseErrors.push({ row: i, message: errors.parserLineWithoutDatas });
                                i++;
                            }
                            if (fields.length === 0)
                                throw new Error(errors.parserFail);
                        }
                        parser._parseResults =
                            {
                                datas: datas,
                                errors: parseErrors,
                                fields: fields,
                            };
                        return [2];
                }
            });
        });
    };
    return ParserForJSON;
}());
export { ParserForJSON };
