var errors = require("./errors.js");
import { FreeDatas2HTML } from "./FreeDatas2HTML";
var Pagination = (function () {
    function Pagination(converter, pagesElt, pagesName) {
        if (pagesName === void 0) { pagesName = "Pages"; }
        if (converter.fields.length === 0)
            throw new Error(errors.paginationNeedDatas);
        else {
            this._pages = { displayElement: FreeDatas2HTML.checkInDOMById(pagesElt), name: pagesName };
            this._converter = converter;
        }
    }
    Pagination.isPositiveInteger = function (nb) {
        return (Number.isInteger(nb) === false || nb <= 0) ? false : true;
    };
    Object.defineProperty(Pagination.prototype, "selectedValue", {
        get: function () {
            return this._selectedValue;
        },
        set: function (value) {
            if (value !== undefined) {
                if (!Pagination.isPositiveInteger(value))
                    throw new Error(errors.needPositiveInteger);
                if (this.options !== undefined && this.options.values.indexOf(value) === -1)
                    throw new Error(errors.paginationNeedByfaultValueBeInOptions);
            }
            this._selectedValue = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Pagination.prototype, "options", {
        get: function () {
            return this._options;
        },
        set: function (options) {
            if (options !== undefined) {
                options.displayElement = FreeDatas2HTML.checkInDOMById(options.displayElement);
                var realValues = [];
                for (var _i = 0, _a = options.values; _i < _a.length; _i++) {
                    var option = _a[_i];
                    if (!Pagination.isPositiveInteger(option))
                        throw new Error(errors.needPositiveInteger);
                    if (realValues.indexOf(option) === -1)
                        realValues.push(option);
                    else
                        console.log(errors.paginationOptionsDuplicatedValues);
                }
                if (realValues.length < 2)
                    throw new Error(errors.paginationNeedOptionsValues);
                options.values = realValues;
                if (this.selectedValue !== undefined && options.values.indexOf(this.selectedValue) === -1)
                    throw new Error(errors.paginationNeedByfaultValueBeInOptions);
                options.name = (options.name === undefined) ? "Pagination" : options.name;
            }
            this._options = options;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Pagination.prototype, "pages", {
        get: function () {
            return this._pages;
        },
        enumerable: true,
        configurable: true
    });
    Pagination.prototype.options2HTML = function () {
        if (this._options === undefined)
            throw new Error(errors.pagination2HTMLFail);
        else {
            var selectorsHTML = "<label for='freeDatas2HTMLPaginationSelector'>" + this._options.name + " </label><select name='freeDatas2HTMLPaginationSelector' id='freeDatas2HTMLPaginationSelector'><option value='0'>----</option>";
            for (var i = 0; i < this._options.values.length; i++)
                selectorsHTML += "<option value='" + (i + 1) + "'>" + this._options.values[i] + "</option>";
            selectorsHTML += "</select>";
            this._options.displayElement.eltDOM.innerHTML = selectorsHTML;
            var selectElement_1 = document.getElementById("freeDatas2HTMLPaginationSelector");
            if (this._selectedValue !== undefined)
                selectElement_1.value = "" + (this._options.values.indexOf(this._selectedValue) + 1);
            var pagination_1 = this;
            selectElement_1.addEventListener("change", function (e) {
                if (selectElement_1.value === "0")
                    pagination_1._selectedValue = undefined;
                else
                    pagination_1._selectedValue = pagination_1._options.values[Number(selectElement_1.value) - 1];
                pagination_1._converter.refreshView();
            });
        }
    };
    Pagination.prototype.pages2HTML = function () {
        if (this._selectedValue === undefined || this._converter.nbDatasValid <= this._selectedValue)
            this.pages.displayElement.eltDOM.innerHTML = "";
        else {
            var nbPages = Math.ceil(this._converter.nbDatasValid / this._selectedValue);
            var selectorsHTML = "<label for='freeDatas2HTMLPagesSelector'>" + this.pages.name + "</label><select name='freeDatas2HTMLPagesSelector' id='freeDatas2HTMLPagesSelector'>";
            this.pages.values = [];
            for (var j = 1; j <= nbPages; j++) {
                selectorsHTML += "<option value='" + j + "'>" + j + "</option>";
                this.pages.values.push(j);
            }
            selectorsHTML += "</select>";
            this.pages.displayElement.eltDOM.innerHTML = selectorsHTML;
            var selectElement_2 = document.getElementById("freeDatas2HTMLPagesSelector");
            var pagination_2 = this;
            selectElement_2.addEventListener("change", function (e) {
                pagination_2.pages.selectedValue = Number(selectElement_2.value);
                pagination_2._converter.refreshView(true);
                selectElement_2.value = "" + pagination_2.pages.selectedValue;
            });
        }
    };
    return Pagination;
}());
export { Pagination };
